// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/folders.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_V3_FOLDERS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_V3_FOLDERS_CLIENT_H

#include "google/cloud/resourcemanager/v3/folders_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/iam_updater.h"
#include "google/cloud/internal/make_status.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages Cloud Platform folder resources.
/// Folders can be used to organize the resources under an
/// organization and to control the policies applied to groups of resources.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class FoldersClient {
 public:
  explicit FoldersClient(std::shared_ptr<FoldersConnection> connection,
                         Options opts = {});
  ~FoldersClient();

  ///@{
  /// @name Copy and move support
  FoldersClient(FoldersClient const&) = default;
  FoldersClient& operator=(FoldersClient const&) = default;
  FoldersClient(FoldersClient&&) = default;
  FoldersClient& operator=(FoldersClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(FoldersClient const& a, FoldersClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(FoldersClient const& a, FoldersClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Retrieves a folder identified by the supplied resource name.
  /// Valid folder resource names have the format `folders/{folder_id}`
  /// (for example, `folders/1234`).
  /// The caller must have `resourcemanager.folders.get` permission on the
  /// identified folder.
  ///
  /// @param name  Required. The resource name of the folder to retrieve.
  ///  Must be of the form `folders/{folder_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.resourcemanager.v3.Folder])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.GetFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L335}
  ///
  // clang-format on
  StatusOr<google::cloud::resourcemanager::v3::Folder> GetFolder(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves a folder identified by the supplied resource name.
  /// Valid folder resource names have the format `folders/{folder_id}`
  /// (for example, `folders/1234`).
  /// The caller must have `resourcemanager.folders.get` permission on the
  /// identified folder.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.GetFolderRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.resourcemanager.v3.Folder])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.GetFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L335}
  ///
  // clang-format on
  StatusOr<google::cloud::resourcemanager::v3::Folder> GetFolder(
      google::cloud::resourcemanager::v3::GetFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists the folders that are direct descendants of supplied parent resource.
  /// `list()` provides a strongly consistent view of the folders underneath
  /// the specified parent resource.
  /// `list()` returns folders sorted based upon the (ascending) lexical ordering
  /// of their display_name.
  /// The caller must have `resourcemanager.folders.list` permission on the
  /// identified parent.
  ///
  /// @param parent  Required. The name of the parent resource whose folders are being listed.
  ///  Only children of this parent resource are listed; descendants are not
  ///  listed.
  ///  @n
  ///  If the parent is a folder, use the value `folders/{folder_id}`. If the
  ///  parent is an organization, use the value `organizations/{org_id}`.
  ///  @n
  ///  Access to this method is controlled by checking the
  ///  `resourcemanager.folders.list` permission on the `parent`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.resourcemanager.v3.Folder], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.ListFoldersRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L347}
  ///
  // clang-format on
  StreamRange<google::cloud::resourcemanager::v3::Folder> ListFolders(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists the folders that are direct descendants of supplied parent resource.
  /// `list()` provides a strongly consistent view of the folders underneath
  /// the specified parent resource.
  /// `list()` returns folders sorted based upon the (ascending) lexical ordering
  /// of their display_name.
  /// The caller must have `resourcemanager.folders.list` permission on the
  /// identified parent.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.ListFoldersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.resourcemanager.v3.Folder], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.ListFoldersRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L347}
  ///
  // clang-format on
  StreamRange<google::cloud::resourcemanager::v3::Folder> ListFolders(
      google::cloud::resourcemanager::v3::ListFoldersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Search for folders that match specific filter criteria.
  /// `search()` provides an eventually consistent view of the folders a user has
  /// access to which meet the specified filter criteria.
  ///
  /// This will only return folders on which the caller has the
  /// permission `resourcemanager.folders.get`.
  ///
  /// @param query  Optional. Search criteria used to select the folders to return.
  ///  If no search criteria is specified then all accessible folders will be
  ///  returned.
  ///  @n
  ///  For more information, see [SearchFoldersRequest][google.cloud.resourcemanager.v3.SearchFoldersRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.resourcemanager.v3.Folder], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.SearchFoldersRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L389}
  ///
  // clang-format on
  StreamRange<google::cloud::resourcemanager::v3::Folder> SearchFolders(
      std::string const& query, Options opts = {});

  // clang-format off
  ///
  /// Search for folders that match specific filter criteria.
  /// `search()` provides an eventually consistent view of the folders a user has
  /// access to which meet the specified filter criteria.
  ///
  /// This will only return folders on which the caller has the
  /// permission `resourcemanager.folders.get`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.SearchFoldersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.resourcemanager.v3.Folder], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.SearchFoldersRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L389}
  ///
  // clang-format on
  StreamRange<google::cloud::resourcemanager::v3::Folder> SearchFolders(
      google::cloud::resourcemanager::v3::SearchFoldersRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a folder in the resource hierarchy.
  /// Returns an `Operation` which can be used to track the progress of the
  /// folder creation workflow.
  /// Upon success, the `Operation.response` field will be populated with the
  /// created Folder.
  ///
  /// In order to succeed, the addition of this new folder must not violate
  /// the folder naming, height, or fanout constraints.
  ///
  /// + The folder's `display_name` must be distinct from all other folders that
  /// share its parent.
  /// + The addition of the folder must not cause the active folder hierarchy
  /// to exceed a height of 10. Note, the full active + deleted folder hierarchy
  /// is allowed to reach a height of 20; this provides additional headroom when
  /// moving folders that contain deleted folders.
  /// + The addition of the folder must not cause the total number of folders
  /// under its parent to exceed 300.
  ///
  /// If the operation fails due to a folder constraint violation, some errors
  /// may be returned by the `CreateFolder` request, with status code
  /// `FAILED_PRECONDITION` and an error description. Other folder constraint
  /// violations will be communicated in the `Operation`, with the specific
  /// `PreconditionFailure` returned in the details list in the `Operation.error`
  /// field.
  ///
  /// The caller must have `resourcemanager.folders.create` permission on the
  /// identified parent.
  ///
  /// @param folder  Required. The folder being created, only the display name and parent will
  ///  be consulted. All other fields will be ignored.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.CreateFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L445}
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> CreateFolder(
      google::cloud::resourcemanager::v3::Folder const& folder,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateFolder(
      NoAwaitTag, google::cloud::resourcemanager::v3::Folder const& folder,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a folder in the resource hierarchy.
  /// Returns an `Operation` which can be used to track the progress of the
  /// folder creation workflow.
  /// Upon success, the `Operation.response` field will be populated with the
  /// created Folder.
  ///
  /// In order to succeed, the addition of this new folder must not violate
  /// the folder naming, height, or fanout constraints.
  ///
  /// + The folder's `display_name` must be distinct from all other folders that
  /// share its parent.
  /// + The addition of the folder must not cause the active folder hierarchy
  /// to exceed a height of 10. Note, the full active + deleted folder hierarchy
  /// is allowed to reach a height of 20; this provides additional headroom when
  /// moving folders that contain deleted folders.
  /// + The addition of the folder must not cause the total number of folders
  /// under its parent to exceed 300.
  ///
  /// If the operation fails due to a folder constraint violation, some errors
  /// may be returned by the `CreateFolder` request, with status code
  /// `FAILED_PRECONDITION` and an error description. Other folder constraint
  /// violations will be communicated in the `Operation`, with the specific
  /// `PreconditionFailure` returned in the details list in the `Operation.error`
  /// field.
  ///
  /// The caller must have `resourcemanager.folders.create` permission on the
  /// identified parent.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.CreateFolderRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.CreateFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L445}
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> CreateFolder(
      google::cloud::resourcemanager::v3::CreateFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateFolder(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::CreateFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateFolder
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> CreateFolder(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates a folder, changing its `display_name`.
  /// Changes to the folder `display_name` will be rejected if they violate
  /// either the `display_name` formatting rules or the naming constraints
  /// described in the
  /// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
  /// documentation.
  ///
  /// The folder's `display_name` must start and end with a letter or digit,
  /// may contain letters, digits, spaces, hyphens and underscores and can be
  /// between 3 and 30 characters. This is captured by the regular expression:
  /// `[\p{L}\p{N}][\p{L}\p{N}_- ]{1,28}[\p{L}\p{N}]`.
  /// The caller must have `resourcemanager.folders.update` permission on the
  /// identified folder.
  ///
  /// If the update fails due to the unique name constraint then a
  /// `PreconditionFailure` explaining this violation will be returned
  /// in the Status.details field.
  ///
  /// @param folder  Required. The new definition of the Folder. It must include the `name`
  ///  field, which cannot be changed.
  /// @param update_mask  Required. Fields to be updated.
  ///  Only the `display_name` can be updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.Folders.CreateFolder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L112}
  /// [google.cloud.resourcemanager.v3.UpdateFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L469}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> UpdateFolder(
      google::cloud::resourcemanager::v3::Folder const& folder,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateFolder(
      NoAwaitTag, google::cloud::resourcemanager::v3::Folder const& folder,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a folder, changing its `display_name`.
  /// Changes to the folder `display_name` will be rejected if they violate
  /// either the `display_name` formatting rules or the naming constraints
  /// described in the
  /// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
  /// documentation.
  ///
  /// The folder's `display_name` must start and end with a letter or digit,
  /// may contain letters, digits, spaces, hyphens and underscores and can be
  /// between 3 and 30 characters. This is captured by the regular expression:
  /// `[\p{L}\p{N}][\p{L}\p{N}_- ]{1,28}[\p{L}\p{N}]`.
  /// The caller must have `resourcemanager.folders.update` permission on the
  /// identified folder.
  ///
  /// If the update fails due to the unique name constraint then a
  /// `PreconditionFailure` explaining this violation will be returned
  /// in the Status.details field.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.UpdateFolderRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.Folders.CreateFolder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L112}
  /// [google.cloud.resourcemanager.v3.UpdateFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L469}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> UpdateFolder(
      google::cloud::resourcemanager::v3::UpdateFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateFolder(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::UpdateFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFolder
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> UpdateFolder(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Moves a folder under a new resource parent.
  /// Returns an `Operation` which can be used to track the progress of the
  /// folder move workflow.
  /// Upon success, the `Operation.response` field will be populated with the
  /// moved folder.
  /// Upon failure, a `FolderOperationError` categorizing the failure cause will
  /// be returned - if the failure occurs synchronously then the
  /// `FolderOperationError` will be returned in the `Status.details` field.
  /// If it occurs asynchronously, then the FolderOperation will be returned
  /// in the `Operation.error` field.
  /// In addition, the `Operation.metadata` field will be populated with a
  /// `FolderOperation` message as an aid to stateless clients.
  /// Folder moves will be rejected if they violate either the naming, height,
  /// or fanout constraints described in the
  /// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
  /// documentation. The caller must have `resourcemanager.folders.move`
  /// permission on the folder's current and proposed new parent.
  ///
  /// @param name  Required. The resource name of the Folder to move.
  ///  Must be of the form folders/{folder_id}
  /// @param destination_parent  Required. The resource name of the folder or organization which should be
  ///  the folder's new parent. Must be of the form `folders/{folder_id}` or
  ///  `organizations/{org_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.Folders.CreateFolder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L112}
  /// [google.cloud.resourcemanager.v3.MoveFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L485}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> MoveFolder(
      std::string const& name, std::string const& destination_parent,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief MoveFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> MoveFolder(
      NoAwaitTag, std::string const& name,
      std::string const& destination_parent, Options opts = {});

  // clang-format off
  ///
  /// Moves a folder under a new resource parent.
  /// Returns an `Operation` which can be used to track the progress of the
  /// folder move workflow.
  /// Upon success, the `Operation.response` field will be populated with the
  /// moved folder.
  /// Upon failure, a `FolderOperationError` categorizing the failure cause will
  /// be returned - if the failure occurs synchronously then the
  /// `FolderOperationError` will be returned in the `Status.details` field.
  /// If it occurs asynchronously, then the FolderOperation will be returned
  /// in the `Operation.error` field.
  /// In addition, the `Operation.metadata` field will be populated with a
  /// `FolderOperation` message as an aid to stateless clients.
  /// Folder moves will be rejected if they violate either the naming, height,
  /// or fanout constraints described in the
  /// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
  /// documentation. The caller must have `resourcemanager.folders.move`
  /// permission on the folder's current and proposed new parent.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.MoveFolderRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.Folders.CreateFolder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L112}
  /// [google.cloud.resourcemanager.v3.MoveFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L485}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> MoveFolder(
      google::cloud::resourcemanager::v3::MoveFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief MoveFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> MoveFolder(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::MoveFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief MoveFolder
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> MoveFolder(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Requests deletion of a folder. The folder is moved into the
  /// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
  /// state immediately, and is deleted approximately 30 days later. This method
  /// may only be called on an empty folder, where a folder is empty if it
  /// doesn't contain any folders or projects in the
  /// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. If
  /// called on a folder in
  /// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
  /// state the operation will result in a no-op success.
  /// The caller must have `resourcemanager.folders.delete` permission on the
  /// identified folder.
  ///
  /// @param name  Required. The resource name of the folder to be deleted.
  ///  Must be of the form `folders/{folder_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.DeleteFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L517}
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.Folder.State.ACTIVE]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L286}
  /// [google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L289}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> DeleteFolder(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteFolder(NoAwaitTag,
                                                        std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Requests deletion of a folder. The folder is moved into the
  /// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
  /// state immediately, and is deleted approximately 30 days later. This method
  /// may only be called on an empty folder, where a folder is empty if it
  /// doesn't contain any folders or projects in the
  /// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. If
  /// called on a folder in
  /// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]
  /// state the operation will result in a no-op success.
  /// The caller must have `resourcemanager.folders.delete` permission on the
  /// identified folder.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.DeleteFolderRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.DeleteFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L517}
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.Folder.State.ACTIVE]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L286}
  /// [google.cloud.resourcemanager.v3.Folder.State.DELETE_REQUESTED]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L289}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> DeleteFolder(
      google::cloud::resourcemanager::v3::DeleteFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteFolder(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::DeleteFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFolder
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> DeleteFolder(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Cancels the deletion request for a folder. This method may be called on a
  /// folder in any state. If the folder is in the
  /// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state the
  /// result will be a no-op success. In order to succeed, the folder's parent
  /// must be in the
  /// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. In
  /// addition, reintroducing the folder into the tree must not violate folder
  /// naming, height, and fanout constraints described in the
  /// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
  /// documentation. The caller must have `resourcemanager.folders.undelete`
  /// permission on the identified folder.
  ///
  /// @param name  Required. The resource name of the folder to undelete.
  ///  Must be of the form `folders/{folder_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.Folder.State.ACTIVE]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L286}
  /// [google.cloud.resourcemanager.v3.Folders.CreateFolder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L112}
  /// [google.cloud.resourcemanager.v3.UndeleteFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L533}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> UndeleteFolder(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UndeleteFolder(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Cancels the deletion request for a folder. This method may be called on a
  /// folder in any state. If the folder is in the
  /// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state the
  /// result will be a no-op success. In order to succeed, the folder's parent
  /// must be in the
  /// [ACTIVE][google.cloud.resourcemanager.v3.Folder.State.ACTIVE] state. In
  /// addition, reintroducing the folder into the tree must not violate folder
  /// naming, height, and fanout constraints described in the
  /// [CreateFolder][google.cloud.resourcemanager.v3.Folders.CreateFolder]
  /// documentation. The caller must have `resourcemanager.folders.undelete`
  /// permission on the identified folder.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.UndeleteFolderRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Folder] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Folder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L273}
  /// [google.cloud.resourcemanager.v3.Folder.State.ACTIVE]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L286}
  /// [google.cloud.resourcemanager.v3.Folders.CreateFolder]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L112}
  /// [google.cloud.resourcemanager.v3.UndeleteFolderRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/folders.proto#L533}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> UndeleteFolder(
      google::cloud::resourcemanager::v3::UndeleteFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteFolder
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UndeleteFolder(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::UndeleteFolderRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteFolder
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Folder>> UndeleteFolder(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Gets the access control policy for a folder. The returned policy may be
  /// empty if no such policy or resource exists. The `resource` field should
  /// be the folder's resource name, for example: "folders/1234".
  /// The caller must have `resourcemanager.folders.getIamPolicy` permission
  /// on the identified folder.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.GetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L123}
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> GetIamPolicy(std::string const& resource,
                                                 Options opts = {});

  // clang-format off
  ///
  /// Gets the access control policy for a folder. The returned policy may be
  /// empty if no such policy or resource exists. The `resource` field should
  /// be the folder's resource name, for example: "folders/1234".
  /// The caller must have `resourcemanager.folders.getIamPolicy` permission
  /// on the identified folder.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.GetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.GetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L123}
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Sets the access control policy on a folder, replacing any existing policy.
  /// The `resource` field should be the folder's resource name, for example:
  /// "folders/1234".
  /// The caller must have `resourcemanager.folders.setIamPolicy` permission
  /// on the identified folder.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being specified.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param policy  REQUIRED: The complete policy to be applied to the `resource`. The size of
  ///  the policy is limited to a few 10s of KB. An empty policy is a
  ///  valid policy but certain Cloud Platform services (such as Projects)
  ///  might reject them.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.iam.v1.SetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L101}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      std::string const& resource, google::iam::v1::Policy const& policy,
      Options opts = {});

  /**
   * Updates the IAM policy for @p resource using an optimistic concurrency
   * control loop.
   *
   * The loop fetches the current policy for @p resource, and passes it to @p
   * updater, which should return the new policy. This new policy should use the
   * current etag so that the read-modify-write cycle can detect races and rerun
   * the update when there is a mismatch. If the new policy does not have an
   * etag, the existing policy will be blindly overwritten. If @p updater does
   * not yield a policy, the control loop is terminated and kCancelled is
   * returned.
   *
   * @param resource  Required. The resource for which the policy is being
   * specified. See the operation documentation for the appropriate value for
   * this field.
   * @param updater  Required. Functor to map the current policy to a new one.
   * @param opts  Optional. Override the class-level options, such as retry and
   *    backoff policies.
   * @return google::iam::v1::Policy
   */
  StatusOr<google::iam::v1::Policy> SetIamPolicy(std::string const& resource,
                                                 IamUpdater const& updater,
                                                 Options opts = {});

  // clang-format off
  ///
  /// Sets the access control policy on a folder, replacing any existing policy.
  /// The `resource` field should be the folder's resource name, for example:
  /// "folders/1234".
  /// The caller must have `resourcemanager.folders.setIamPolicy` permission
  /// on the identified folder.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.SetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.iam.v1.SetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L101}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Returns permissions that a caller has on the specified folder.
  /// The `resource` field should be the folder's resource name,
  /// for example: "folders/1234".
  ///
  /// There are no permissions required for making this API call.
  ///
  /// @param resource  REQUIRED: The resource for which the policy detail is being requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param permissions  The set of permissions to check for the `resource`. Permissions with
  ///  wildcards (such as '*' or 'storage.*') are not allowed. For more
  ///  information see
  ///  [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.TestIamPermissionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.TestIamPermissionsRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L136}
  /// [google.iam.v1.TestIamPermissionsResponse]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L151}
  ///
  // clang-format on
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      std::string const& resource, std::vector<std::string> const& permissions,
      Options opts = {});

  // clang-format off
  ///
  /// Returns permissions that a caller has on the specified folder.
  /// The `resource` field should be the folder's resource name,
  /// for example: "folders/1234".
  ///
  /// There are no permissions required for making this API call.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.TestIamPermissionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.TestIamPermissionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.TestIamPermissionsRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L136}
  /// [google.iam.v1.TestIamPermissionsResponse]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L151}
  ///
  // clang-format on
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<FoldersConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_V3_FOLDERS_CLIENT_H
