
#include <string.h>
#include <gtk/gtk.h>

#include "gamepick.h"
#include "read_line.h"
#include "add_games.h"
#include "options.h"
#include "icons.h"
#include "click_game.h"
#include "save_lists.h"


void close_dialog (GtkWidget *widget, GtkWidget *target)
{
  gtk_widget_destroy (target);
}


void show_notice (const gchar* text, GtkWidget *parent)
{
  GtkWidget *dialog, *table, *label, *button;
    
  dialog = gtk_dialog_new_with_buttons ("Gamepick message",
    GTK_WINDOW (parent), GTK_DIALOG_NO_SEPARATOR, NULL);
  if (parent)
    gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (parent));
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);

  table = gtk_table_new (2, 3, FALSE);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), table);
  gtk_widget_show (table);

  label = gtk_label_new (text);
  gtk_table_attach (GTK_TABLE (table), label, 0, 3, 0, 1,
    GTK_SHRINK, GTK_SHRINK, 0, 5);
  gtk_widget_show (label);
    
  button = gtk_button_new_with_label ("Dismiss");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (close_dialog),
    dialog); 
  gtk_table_attach (GTK_TABLE (table), button, 1, 2, 2, 3,
    GTK_SHRINK, GTK_SHRINK, 0, 5);
  gtk_widget_show (button);
      
  gtk_widget_show_all (dialog);
}


void accept_location (GtkWidget *widget, gamepick_info *info)
{
  GString *string;
  const gchar *text, *dir, *dir_slash, *cmd;
  gint diff, offset;
  
  text = gtk_file_selection_get_filename (GTK_FILE_SELECTION (
    info->browse_widget));
  dir = find_parent_dir (text);
  dir_slash = find_parent_dir_slash (text);
  
  if (info->browse_target == bt_cmd)
  {
    g_string_assign (info->cmd_dir, dir_slash);
    diff = strlen (text) - strlen (dir_slash);
    if (diff > 0 && diff < strlen (text))
    {
      gtk_entry_set_text (GTK_ENTRY (info->start_field), dir);
      string = g_string_new (NULL);
      offset = strlen (text) - diff;
      cmd = &text [offset];
      g_string_sprintf (string, "./%s", cmd);
      gtk_entry_set_text (GTK_ENTRY (info->cmd_field), string->str);
    }
    else
    {
      gtk_entry_set_text (GTK_ENTRY (info->start_field), "");
      gtk_entry_set_text (GTK_ENTRY (info->cmd_field), text);
    }
  }
  else
  if (info->browse_target == bt_icon)
  {
    gtk_entry_set_text (GTK_ENTRY (info->icon_field), text);
    g_string_assign (info->icon_dir, find_parent_dir_slash (text));
    if (info->edits_icon)
      gtk_widget_destroy (info->edits_icon);
    if (text [0])
    {
      info->edits_icon = scaled_icon (text, 48, 48);
      if (info->edits_icon)
      {
        gtk_table_attach (GTK_TABLE (info->edits_table), info->edits_icon,
          2, 3, 4, 5, GTK_SHRINK, GTK_SHRINK, info->icon_spacing, 0);
        gtk_widget_show (info->edits_icon);
      }
    }
  }
  else
    g_print ("(debug) tabby: unknown browse target\n");
  gtk_widget_destroy (info->browse_widget);
}


void browse_for_file (gamepick_info *info)
{
  GString *dir_name;
  const gchar *title, *initial;
  
  if (info->browse_target == bt_cmd)
  {
    title = "Game Location";
    initial = info->cmd_dir->str;
  }
  else
  if (info->browse_target == bt_icon)
  {
    title = "Icon Location";
    dir_name = g_string_new (NULL);
    g_string_sprintf (dir_name, "%s/", info->icon_dir->str);
    initial = dir_name->str;
  }
  else
  {
    g_print ("(debug) gamepick: unknown browse target\n");
    return;
  }

  info->browse_widget = gtk_file_selection_new (title);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (info->browse_widget),
    initial);
  gtk_window_set_transient_for (GTK_WINDOW (info->browse_widget),
    GTK_WINDOW (info->edits_dialog));
  gtk_window_set_modal (GTK_WINDOW (info->browse_widget), TRUE);
  g_signal_connect (G_OBJECT (info->browse_widget), "destroy",
    G_CALLBACK (close_dialog), info->browse_widget);
  g_signal_connect (G_OBJECT (
    GTK_FILE_SELECTION (info->browse_widget)->ok_button),
    "clicked", G_CALLBACK (accept_location), info);
  g_signal_connect (G_OBJECT (
    GTK_FILE_SELECTION (info->browse_widget)->cancel_button),
    "clicked", G_CALLBACK (close_dialog), info->browse_widget);
  gtk_widget_show (info->browse_widget);
}


void browse_for_cmd (GtkWidget *widget, gamepick_info *info)
{
  info->browse_target = bt_cmd;
  browse_for_file (info);
}


void browse_for_icon (GtkWidget *widget, gamepick_info *info)
{
  info->browse_target = bt_icon;
  browse_for_file (info);
}


void save_clicked (GtkWidget *widget, gamepick_info *info)
{
  game_struct *game = info->current_edit;
  
  g_string_assign (game->name,
    gtk_entry_get_text (GTK_ENTRY (info->name_field)));
  g_string_assign (game->start_dir,
    gtk_entry_get_text (GTK_ENTRY (info->start_field)));
  g_string_assign (game->cmd,
    gtk_entry_get_text (GTK_ENTRY (info->cmd_field)));
  g_string_assign (game->icon,
     gtk_entry_get_text (GTK_ENTRY (info->icon_field)));
  game->fsaa =
    gtk_combo_box_get_active (GTK_COMBO_BOX (info->edits_fsaa_combo));
  game->aitf =
    gtk_combo_box_get_active (GTK_COMBO_BOX (info->edits_aitf_combo));
  game->syncvblank = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON
    (info->edits_vsync));

  if (info->current_source != NULL)
  {
    take_down_game (game);
    pinup_game (info, game);
  }
  else
  {
    game = add_game (info, game,
      gtk_notebook_get_current_page (GTK_NOTEBOOK (info->tabs)));
  }
  
  reflect_game (info, game);
  
  gtk_widget_destroy (info->edits_dialog);
  save_config (info);
}


void new_text_field (gamepick_info *info, gint row, const gchar *text_label,
  GtkWidget **field, const gchar *initial)
{
  GtkWidget *label;

  label = gtk_label_new (text_label);
  gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
  gtk_table_attach_defaults (GTK_TABLE (info->edits_table), label, 0, 1,
    row, row + 1);
  gtk_widget_show (label);
  
  *field = gtk_entry_new();
  gtk_entry_set_text (GTK_ENTRY (*field), initial);
  gtk_table_attach_defaults (GTK_TABLE (info->edits_table), *field, 2, 3,
    row, row + 1);
  gtk_widget_show (*field);
}


void append (GtkWidget *combo, const gchar *text)
{
  gtk_combo_box_append_text (GTK_COMBO_BOX (combo), text);
}


void add_fsaa_combo (gamepick_info *info, GtkWidget *vbox, GtkWidget **dest)
{
  GtkWidget *frame, *combo, *ebox;
  
  frame = gtk_frame_new ("Fullscreen Antialiasing");
   gtk_widget_show (frame);
  ebox = gtk_event_box_new();
  gtk_container_set_border_width (GTK_CONTAINER (ebox), info->button_spacing);
  gtk_container_add (GTK_CONTAINER (frame), ebox);
  gtk_widget_show (ebox);
  *dest = gtk_combo_box_new_text();
  combo = *dest;
  gtk_widget_show (combo);
  gtk_container_add (GTK_CONTAINER (ebox), combo);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  append (combo, "0: None");
  append (combo, "1: 2x Bilinear Multisampling");
  append (combo, "2: 2x Quincunx Multisampling");
  append (combo, "3: None");
  append (combo, "4: 4x Bilinear Multisampling");
  append (combo, "5: 4x Gaussian Multisampling");
  append (combo, "6: 2x Bilinear Multisampling by 4x Supersampling");
  append (combo, "7: 4x Bilinear Multisampling by 4x Supersampling");
}


void add_aitf_combo (gamepick_info *info, GtkWidget *vbox, GtkWidget **dest)
{
  GtkWidget *frame, *combo, *ebox;
  
  frame = gtk_frame_new ("Anisotropic Filtering");
  gtk_widget_show (frame);
  ebox = gtk_event_box_new();
  gtk_container_set_border_width (GTK_CONTAINER (ebox), info->button_spacing);
  gtk_container_add (GTK_CONTAINER (frame), ebox);
  gtk_widget_show (ebox);
  *dest = gtk_combo_box_new_text();
  combo = *dest;
  gtk_widget_show (combo);
  gtk_container_add (GTK_CONTAINER (ebox), combo);
  gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
  append (combo, "0: None");
  append (combo, "1: Low");
  append (combo, "2: Medium");
  append (combo, "3: High");
}


void edits_run (gamepick_info *info, game_struct *source)
{
  GtkWidget *vbox, *button, *hbox;
  game_struct *game;
  const gchar *title;

  info->current_source = source;
  
  if (source == NULL)
  {
    game = g_malloc0 (sizeof (game_struct));
    zero_game_entry (game);
    title = "New";
  }
  else
  {
    game = source;
    title = "Edit";
  }
  info->current_edit = game;

  info->edits_dialog = gtk_dialog_new_with_buttons (title,
      GTK_WINDOW (info->main_window), GTK_DIALOG_NO_SEPARATOR, NULL);
  gtk_window_set_transient_for (GTK_WINDOW (info->edits_dialog),
    GTK_WINDOW (info->main_window));
  gtk_window_set_modal (GTK_WINDOW (info->edits_dialog), TRUE);
  gtk_container_set_border_width (GTK_CONTAINER (info->edits_dialog),
    info->button_spacing);
  info->edits_table = gtk_table_new (6, 4, FALSE);
  vbox = GTK_DIALOG (info->edits_dialog)->vbox;
  gtk_container_add (GTK_CONTAINER (vbox), info->edits_table);
  gtk_table_set_row_spacings (GTK_TABLE (info->edits_table),
    info->button_spacing);
  gtk_table_set_col_spacings (GTK_TABLE (info->edits_table),
    info->button_spacing);

  new_text_field (info, 0, "Name:", &info->name_field, game->name->str);
  new_text_field (info, 1, "Dir:", &info->start_field, game->start_dir->str);
  new_text_field (info, 2, "Command:", &info->cmd_field, game->cmd->str);
  new_text_field (info, 3, "Icon:", &info->icon_field, game->icon->str);

  button = gtk_button_new_with_label ("Save");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (save_clicked),
    info); 
  gtk_table_attach (GTK_TABLE (info->edits_table), button, 3, 4, 0, 1,
    GTK_FILL, GTK_SHRINK, 0, 0);
  
  button = gtk_button_new_with_label ("Browse");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (browse_for_cmd),
    info); 
  gtk_table_attach (GTK_TABLE (info->edits_table), button, 3, 4, 1, 3,
    GTK_FILL, GTK_SHRINK, 0, 0);
  
  button = gtk_button_new_with_label ("Browse");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (browse_for_icon),
    info); 
  gtk_table_attach (GTK_TABLE (info->edits_table), button, 3, 4, 3, 4,
    GTK_FILL, GTK_SHRINK, 0, 0);

  if (text_here (game->icon))
  {
    info->edits_icon = scaled_icon (game->icon->str, 48, 48);
    if (info->edits_icon)
    {
      gtk_table_attach (GTK_TABLE (info->edits_table), info->edits_icon,
        2, 3, 4, 5, GTK_SHRINK, GTK_SHRINK, info->icon_spacing, 0);
    }
  }

  add_fsaa_combo (info, vbox, &info->edits_fsaa_combo);
  add_aitf_combo (info, vbox, &info->edits_aitf_combo);
  
  gtk_combo_box_set_active (GTK_COMBO_BOX (info->edits_fsaa_combo), game->fsaa);
  gtk_combo_box_set_active (GTK_COMBO_BOX (info->edits_aitf_combo), game->aitf);

  info->edits_vsync = gtk_check_button_new_with_label ("Sync to VBlank");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (info->edits_vsync),
    game->syncvblank);
  gtk_box_pack_start (GTK_BOX (vbox), info->edits_vsync, FALSE, FALSE,
    info->button_spacing);
  
  hbox = gtk_hbox_new (FALSE, 0);
  button = gtk_button_new_with_label ("Cancel");
  g_signal_connect (G_OBJECT (button), "clicked", G_CALLBACK (close_dialog),
    info->edits_dialog); 
  gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, info->button_spacing);

  gtk_widget_show_all (info->edits_dialog);
}
