

#include <gtk/gtk.h>

#include "gamepick.h"
#include "load_lists.h"
#include "options.h"
#include "edits.h"
#include "gp_icon.h"


void play_choice (gamepick_info *info)
{
  GtkWidget *vbox, *button;
  
  g_signal_connect (G_OBJECT (info->main_window), "destroy",
    G_CALLBACK (gtk_main_quit), NULL);
  gtk_container_set_border_width (GTK_CONTAINER (info->main_window),
   info->button_spacing);

  gtk_window_set_default_icon (gdk_pixbuf_new_from_xpm_data (gp_small_icon()));
  
  vbox = gtk_vbox_new (FALSE, info->button_spacing * 2);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (info->main_window), vbox);
  
  info->tabs = gtk_notebook_new();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (info->tabs), GTK_POS_TOP);
  gtk_widget_show (info->tabs);
  
  load_lists (info);

  gtk_box_pack_start_defaults (GTK_BOX (vbox), info->tabs);

  add_fsaa_combo (info, vbox, &info->fsaa_combo);
  add_aitf_combo (info, vbox, &info->aitf_combo);

  info->vsync_check = gtk_check_button_new_with_label ("Sync to VBlank");
  gtk_box_pack_start_defaults (GTK_BOX (vbox), info->vsync_check);
  gtk_widget_show (info->vsync_check);
  
  info->play_table = gtk_table_new (1, 5, TRUE);
  gtk_widget_show (info->play_table);
  gtk_box_pack_start (GTK_BOX (vbox), info->play_table, TRUE, FALSE, 0);

  if (info->options_enabled != 0)
  {
    button = gtk_button_new_with_label (" Options ");
    gtk_widget_show (button);
    gtk_table_attach (GTK_TABLE (info->play_table), button, 0, 1, 0, 1,
      GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
      G_CALLBACK (options_run), info);
  }
  
  button = gtk_button_new_with_label (" Quit ");
  gtk_widget_show (button);
  gtk_table_attach (GTK_TABLE (info->play_table), button, 4, 5, 0, 1,
    GTK_EXPAND | GTK_FILL, GTK_EXPAND, 0, 0);
  g_signal_connect (G_OBJECT (button), "clicked",
    G_CALLBACK (gtk_main_quit), NULL);

}
