// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: private/pbconfigentry/config_entry.proto

package pbconfigentry

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	pbcommon "github.com/hashicorp/consul/proto/private/pbcommon"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Kind int32

const (
	Kind_KindUnknown               Kind = 0
	Kind_KindMeshConfig            Kind = 1
	Kind_KindServiceResolver       Kind = 2
	Kind_KindIngressGateway        Kind = 3
	Kind_KindServiceIntentions     Kind = 4
	Kind_KindServiceDefaults       Kind = 5
	Kind_KindInlineCertificate     Kind = 6
	Kind_KindAPIGateway            Kind = 7
	Kind_KindBoundAPIGateway       Kind = 8
	Kind_KindHTTPRoute             Kind = 9
	Kind_KindTCPRoute              Kind = 10
	Kind_KindSamenessGroup         Kind = 11
	Kind_KindJWTProvider           Kind = 12
	Kind_KindExportedServices      Kind = 13
	Kind_KindFileSystemCertificate Kind = 14
)

// Enum value maps for Kind.
var (
	Kind_name = map[int32]string{
		0:  "KindUnknown",
		1:  "KindMeshConfig",
		2:  "KindServiceResolver",
		3:  "KindIngressGateway",
		4:  "KindServiceIntentions",
		5:  "KindServiceDefaults",
		6:  "KindInlineCertificate",
		7:  "KindAPIGateway",
		8:  "KindBoundAPIGateway",
		9:  "KindHTTPRoute",
		10: "KindTCPRoute",
		11: "KindSamenessGroup",
		12: "KindJWTProvider",
		13: "KindExportedServices",
		14: "KindFileSystemCertificate",
	}
	Kind_value = map[string]int32{
		"KindUnknown":               0,
		"KindMeshConfig":            1,
		"KindServiceResolver":       2,
		"KindIngressGateway":        3,
		"KindServiceIntentions":     4,
		"KindServiceDefaults":       5,
		"KindInlineCertificate":     6,
		"KindAPIGateway":            7,
		"KindBoundAPIGateway":       8,
		"KindHTTPRoute":             9,
		"KindTCPRoute":              10,
		"KindSamenessGroup":         11,
		"KindJWTProvider":           12,
		"KindExportedServices":      13,
		"KindFileSystemCertificate": 14,
	}
)

func (x Kind) Enum() *Kind {
	p := new(Kind)
	*p = x
	return p
}

func (x Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[0].Descriptor()
}

func (Kind) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[0]
}

func (x Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Kind.Descriptor instead.
func (Kind) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{0}
}

type IntentionAction int32

const (
	IntentionAction_Deny  IntentionAction = 0
	IntentionAction_Allow IntentionAction = 1
)

// Enum value maps for IntentionAction.
var (
	IntentionAction_name = map[int32]string{
		0: "Deny",
		1: "Allow",
	}
	IntentionAction_value = map[string]int32{
		"Deny":  0,
		"Allow": 1,
	}
)

func (x IntentionAction) Enum() *IntentionAction {
	p := new(IntentionAction)
	*p = x
	return p
}

func (x IntentionAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IntentionAction) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[1].Descriptor()
}

func (IntentionAction) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[1]
}

func (x IntentionAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IntentionAction.Descriptor instead.
func (IntentionAction) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{1}
}

type IntentionSourceType int32

const (
	IntentionSourceType_Consul IntentionSourceType = 0
)

// Enum value maps for IntentionSourceType.
var (
	IntentionSourceType_name = map[int32]string{
		0: "Consul",
	}
	IntentionSourceType_value = map[string]int32{
		"Consul": 0,
	}
)

func (x IntentionSourceType) Enum() *IntentionSourceType {
	p := new(IntentionSourceType)
	*p = x
	return p
}

func (x IntentionSourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IntentionSourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[2].Descriptor()
}

func (IntentionSourceType) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[2]
}

func (x IntentionSourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IntentionSourceType.Descriptor instead.
func (IntentionSourceType) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{2}
}

type ProxyMode int32

const (
	ProxyMode_ProxyModeDefault     ProxyMode = 0
	ProxyMode_ProxyModeTransparent ProxyMode = 1
	ProxyMode_ProxyModeDirect      ProxyMode = 2
)

// Enum value maps for ProxyMode.
var (
	ProxyMode_name = map[int32]string{
		0: "ProxyModeDefault",
		1: "ProxyModeTransparent",
		2: "ProxyModeDirect",
	}
	ProxyMode_value = map[string]int32{
		"ProxyModeDefault":     0,
		"ProxyModeTransparent": 1,
		"ProxyModeDirect":      2,
	}
)

func (x ProxyMode) Enum() *ProxyMode {
	p := new(ProxyMode)
	*p = x
	return p
}

func (x ProxyMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProxyMode) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[3].Descriptor()
}

func (ProxyMode) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[3]
}

func (x ProxyMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProxyMode.Descriptor instead.
func (ProxyMode) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{3}
}

type MutualTLSMode int32

const (
	MutualTLSMode_MutualTLSModeDefault    MutualTLSMode = 0
	MutualTLSMode_MutualTLSModeStrict     MutualTLSMode = 1
	MutualTLSMode_MutualTLSModePermissive MutualTLSMode = 2
)

// Enum value maps for MutualTLSMode.
var (
	MutualTLSMode_name = map[int32]string{
		0: "MutualTLSModeDefault",
		1: "MutualTLSModeStrict",
		2: "MutualTLSModePermissive",
	}
	MutualTLSMode_value = map[string]int32{
		"MutualTLSModeDefault":    0,
		"MutualTLSModeStrict":     1,
		"MutualTLSModePermissive": 2,
	}
)

func (x MutualTLSMode) Enum() *MutualTLSMode {
	p := new(MutualTLSMode)
	*p = x
	return p
}

func (x MutualTLSMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MutualTLSMode) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[4].Descriptor()
}

func (MutualTLSMode) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[4]
}

func (x MutualTLSMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MutualTLSMode.Descriptor instead.
func (MutualTLSMode) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{4}
}

type MeshGatewayMode int32

const (
	MeshGatewayMode_MeshGatewayModeDefault MeshGatewayMode = 0
	MeshGatewayMode_MeshGatewayModeNone    MeshGatewayMode = 1
	MeshGatewayMode_MeshGatewayModeLocal   MeshGatewayMode = 2
	MeshGatewayMode_MeshGatewayModeRemote  MeshGatewayMode = 3
)

// Enum value maps for MeshGatewayMode.
var (
	MeshGatewayMode_name = map[int32]string{
		0: "MeshGatewayModeDefault",
		1: "MeshGatewayModeNone",
		2: "MeshGatewayModeLocal",
		3: "MeshGatewayModeRemote",
	}
	MeshGatewayMode_value = map[string]int32{
		"MeshGatewayModeDefault": 0,
		"MeshGatewayModeNone":    1,
		"MeshGatewayModeLocal":   2,
		"MeshGatewayModeRemote":  3,
	}
)

func (x MeshGatewayMode) Enum() *MeshGatewayMode {
	p := new(MeshGatewayMode)
	*p = x
	return p
}

func (x MeshGatewayMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MeshGatewayMode) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[5].Descriptor()
}

func (MeshGatewayMode) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[5]
}

func (x MeshGatewayMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MeshGatewayMode.Descriptor instead.
func (MeshGatewayMode) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{5}
}

type APIGatewayListenerProtocol int32

const (
	APIGatewayListenerProtocol_ListenerProtocolHTTP APIGatewayListenerProtocol = 0
	APIGatewayListenerProtocol_ListenerProtocolTCP  APIGatewayListenerProtocol = 1
)

// Enum value maps for APIGatewayListenerProtocol.
var (
	APIGatewayListenerProtocol_name = map[int32]string{
		0: "ListenerProtocolHTTP",
		1: "ListenerProtocolTCP",
	}
	APIGatewayListenerProtocol_value = map[string]int32{
		"ListenerProtocolHTTP": 0,
		"ListenerProtocolTCP":  1,
	}
)

func (x APIGatewayListenerProtocol) Enum() *APIGatewayListenerProtocol {
	p := new(APIGatewayListenerProtocol)
	*p = x
	return p
}

func (x APIGatewayListenerProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (APIGatewayListenerProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[6].Descriptor()
}

func (APIGatewayListenerProtocol) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[6]
}

func (x APIGatewayListenerProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use APIGatewayListenerProtocol.Descriptor instead.
func (APIGatewayListenerProtocol) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{6}
}

type HTTPMatchMethod int32

const (
	HTTPMatchMethod_HTTPMatchMethodAll     HTTPMatchMethod = 0
	HTTPMatchMethod_HTTPMatchMethodConnect HTTPMatchMethod = 1
	HTTPMatchMethod_HTTPMatchMethodDelete  HTTPMatchMethod = 2
	HTTPMatchMethod_HTTPMatchMethodGet     HTTPMatchMethod = 3
	HTTPMatchMethod_HTTPMatchMethodHead    HTTPMatchMethod = 4
	HTTPMatchMethod_HTTPMatchMethodOptions HTTPMatchMethod = 5
	HTTPMatchMethod_HTTPMatchMethodPatch   HTTPMatchMethod = 6
	HTTPMatchMethod_HTTPMatchMethodPost    HTTPMatchMethod = 7
	HTTPMatchMethod_HTTPMatchMethodPut     HTTPMatchMethod = 8
	HTTPMatchMethod_HTTPMatchMethodTrace   HTTPMatchMethod = 9
)

// Enum value maps for HTTPMatchMethod.
var (
	HTTPMatchMethod_name = map[int32]string{
		0: "HTTPMatchMethodAll",
		1: "HTTPMatchMethodConnect",
		2: "HTTPMatchMethodDelete",
		3: "HTTPMatchMethodGet",
		4: "HTTPMatchMethodHead",
		5: "HTTPMatchMethodOptions",
		6: "HTTPMatchMethodPatch",
		7: "HTTPMatchMethodPost",
		8: "HTTPMatchMethodPut",
		9: "HTTPMatchMethodTrace",
	}
	HTTPMatchMethod_value = map[string]int32{
		"HTTPMatchMethodAll":     0,
		"HTTPMatchMethodConnect": 1,
		"HTTPMatchMethodDelete":  2,
		"HTTPMatchMethodGet":     3,
		"HTTPMatchMethodHead":    4,
		"HTTPMatchMethodOptions": 5,
		"HTTPMatchMethodPatch":   6,
		"HTTPMatchMethodPost":    7,
		"HTTPMatchMethodPut":     8,
		"HTTPMatchMethodTrace":   9,
	}
)

func (x HTTPMatchMethod) Enum() *HTTPMatchMethod {
	p := new(HTTPMatchMethod)
	*p = x
	return p
}

func (x HTTPMatchMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPMatchMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[7].Descriptor()
}

func (HTTPMatchMethod) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[7]
}

func (x HTTPMatchMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPMatchMethod.Descriptor instead.
func (HTTPMatchMethod) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{7}
}

type HTTPHeaderMatchType int32

const (
	HTTPHeaderMatchType_HTTPHeaderMatchExact             HTTPHeaderMatchType = 0
	HTTPHeaderMatchType_HTTPHeaderMatchPrefix            HTTPHeaderMatchType = 1
	HTTPHeaderMatchType_HTTPHeaderMatchPresent           HTTPHeaderMatchType = 2
	HTTPHeaderMatchType_HTTPHeaderMatchRegularExpression HTTPHeaderMatchType = 3
	HTTPHeaderMatchType_HTTPHeaderMatchSuffix            HTTPHeaderMatchType = 4
)

// Enum value maps for HTTPHeaderMatchType.
var (
	HTTPHeaderMatchType_name = map[int32]string{
		0: "HTTPHeaderMatchExact",
		1: "HTTPHeaderMatchPrefix",
		2: "HTTPHeaderMatchPresent",
		3: "HTTPHeaderMatchRegularExpression",
		4: "HTTPHeaderMatchSuffix",
	}
	HTTPHeaderMatchType_value = map[string]int32{
		"HTTPHeaderMatchExact":             0,
		"HTTPHeaderMatchPrefix":            1,
		"HTTPHeaderMatchPresent":           2,
		"HTTPHeaderMatchRegularExpression": 3,
		"HTTPHeaderMatchSuffix":            4,
	}
)

func (x HTTPHeaderMatchType) Enum() *HTTPHeaderMatchType {
	p := new(HTTPHeaderMatchType)
	*p = x
	return p
}

func (x HTTPHeaderMatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPHeaderMatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[8].Descriptor()
}

func (HTTPHeaderMatchType) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[8]
}

func (x HTTPHeaderMatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPHeaderMatchType.Descriptor instead.
func (HTTPHeaderMatchType) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{8}
}

type HTTPPathMatchType int32

const (
	HTTPPathMatchType_HTTPPathMatchExact             HTTPPathMatchType = 0
	HTTPPathMatchType_HTTPPathMatchPrefix            HTTPPathMatchType = 1
	HTTPPathMatchType_HTTPPathMatchRegularExpression HTTPPathMatchType = 3
)

// Enum value maps for HTTPPathMatchType.
var (
	HTTPPathMatchType_name = map[int32]string{
		0: "HTTPPathMatchExact",
		1: "HTTPPathMatchPrefix",
		3: "HTTPPathMatchRegularExpression",
	}
	HTTPPathMatchType_value = map[string]int32{
		"HTTPPathMatchExact":             0,
		"HTTPPathMatchPrefix":            1,
		"HTTPPathMatchRegularExpression": 3,
	}
)

func (x HTTPPathMatchType) Enum() *HTTPPathMatchType {
	p := new(HTTPPathMatchType)
	*p = x
	return p
}

func (x HTTPPathMatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPPathMatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[9].Descriptor()
}

func (HTTPPathMatchType) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[9]
}

func (x HTTPPathMatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPPathMatchType.Descriptor instead.
func (HTTPPathMatchType) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{9}
}

type HTTPQueryMatchType int32

const (
	HTTPQueryMatchType_HTTPQueryMatchExact             HTTPQueryMatchType = 0
	HTTPQueryMatchType_HTTPQueryMatchPresent           HTTPQueryMatchType = 1
	HTTPQueryMatchType_HTTPQueryMatchRegularExpression HTTPQueryMatchType = 3
)

// Enum value maps for HTTPQueryMatchType.
var (
	HTTPQueryMatchType_name = map[int32]string{
		0: "HTTPQueryMatchExact",
		1: "HTTPQueryMatchPresent",
		3: "HTTPQueryMatchRegularExpression",
	}
	HTTPQueryMatchType_value = map[string]int32{
		"HTTPQueryMatchExact":             0,
		"HTTPQueryMatchPresent":           1,
		"HTTPQueryMatchRegularExpression": 3,
	}
)

func (x HTTPQueryMatchType) Enum() *HTTPQueryMatchType {
	p := new(HTTPQueryMatchType)
	*p = x
	return p
}

func (x HTTPQueryMatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HTTPQueryMatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_private_pbconfigentry_config_entry_proto_enumTypes[10].Descriptor()
}

func (HTTPQueryMatchType) Type() protoreflect.EnumType {
	return &file_private_pbconfigentry_config_entry_proto_enumTypes[10]
}

func (x HTTPQueryMatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HTTPQueryMatchType.Descriptor instead.
func (HTTPQueryMatchType) EnumDescriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{10}
}

type GetResolvedExportedServicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Partition string `protobuf:"bytes,1,opt,name=Partition,proto3" json:"Partition,omitempty"`
}

func (x *GetResolvedExportedServicesRequest) Reset() {
	*x = GetResolvedExportedServicesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetResolvedExportedServicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResolvedExportedServicesRequest) ProtoMessage() {}

func (x *GetResolvedExportedServicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResolvedExportedServicesRequest.ProtoReflect.Descriptor instead.
func (*GetResolvedExportedServicesRequest) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{0}
}

func (x *GetResolvedExportedServicesRequest) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

type GetResolvedExportedServicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Services []*ResolvedExportedService `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
}

func (x *GetResolvedExportedServicesResponse) Reset() {
	*x = GetResolvedExportedServicesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetResolvedExportedServicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResolvedExportedServicesResponse) ProtoMessage() {}

func (x *GetResolvedExportedServicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResolvedExportedServicesResponse.ProtoReflect.Descriptor instead.
func (*GetResolvedExportedServicesResponse) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{1}
}

func (x *GetResolvedExportedServicesResponse) GetServices() []*ResolvedExportedService {
	if x != nil {
		return x.Services
	}
	return nil
}

type ResolvedExportedService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Service        string                   `protobuf:"bytes,1,opt,name=Service,proto3" json:"Service,omitempty"`
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,2,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	Consumers      *Consumers               `protobuf:"bytes,3,opt,name=Consumers,proto3" json:"Consumers,omitempty"`
}

func (x *ResolvedExportedService) Reset() {
	*x = ResolvedExportedService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolvedExportedService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolvedExportedService) ProtoMessage() {}

func (x *ResolvedExportedService) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolvedExportedService.ProtoReflect.Descriptor instead.
func (*ResolvedExportedService) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{2}
}

func (x *ResolvedExportedService) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ResolvedExportedService) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *ResolvedExportedService) GetConsumers() *Consumers {
	if x != nil {
		return x.Consumers
	}
	return nil
}

type Consumers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Peers      []string `protobuf:"bytes,1,rep,name=Peers,proto3" json:"Peers,omitempty"`
	Partitions []string `protobuf:"bytes,2,rep,name=Partitions,proto3" json:"Partitions,omitempty"`
}

func (x *Consumers) Reset() {
	*x = Consumers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Consumers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Consumers) ProtoMessage() {}

func (x *Consumers) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Consumers.ProtoReflect.Descriptor instead.
func (*Consumers) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{3}
}

func (x *Consumers) GetPeers() []string {
	if x != nil {
		return x.Peers
	}
	return nil
}

func (x *Consumers) GetPartitions() []string {
	if x != nil {
		return x.Partitions
	}
	return nil
}

type ConfigEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind           Kind                     `protobuf:"varint,1,opt,name=Kind,proto3,enum=hashicorp.consul.internal.configentry.Kind" json:"Kind,omitempty"`
	Name           string                   `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,3,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	RaftIndex      *pbcommon.RaftIndex      `protobuf:"bytes,4,opt,name=RaftIndex,proto3" json:"RaftIndex,omitempty"`
	// Types that are assignable to Entry:
	//
	//	*ConfigEntry_MeshConfig
	//	*ConfigEntry_ServiceResolver
	//	*ConfigEntry_IngressGateway
	//	*ConfigEntry_ServiceIntentions
	//	*ConfigEntry_ServiceDefaults
	//	*ConfigEntry_APIGateway
	//	*ConfigEntry_BoundAPIGateway
	//	*ConfigEntry_TCPRoute
	//	*ConfigEntry_HTTPRoute
	//	*ConfigEntry_InlineCertificate
	//	*ConfigEntry_SamenessGroup
	//	*ConfigEntry_JWTProvider
	//	*ConfigEntry_ExportedServices
	//	*ConfigEntry_FileSystemCertificate
	Entry isConfigEntry_Entry `protobuf_oneof:"Entry"`
}

func (x *ConfigEntry) Reset() {
	*x = ConfigEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfigEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfigEntry) ProtoMessage() {}

func (x *ConfigEntry) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfigEntry.ProtoReflect.Descriptor instead.
func (*ConfigEntry) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{4}
}

func (x *ConfigEntry) GetKind() Kind {
	if x != nil {
		return x.Kind
	}
	return Kind_KindUnknown
}

func (x *ConfigEntry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConfigEntry) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *ConfigEntry) GetRaftIndex() *pbcommon.RaftIndex {
	if x != nil {
		return x.RaftIndex
	}
	return nil
}

func (m *ConfigEntry) GetEntry() isConfigEntry_Entry {
	if m != nil {
		return m.Entry
	}
	return nil
}

func (x *ConfigEntry) GetMeshConfig() *MeshConfig {
	if x, ok := x.GetEntry().(*ConfigEntry_MeshConfig); ok {
		return x.MeshConfig
	}
	return nil
}

func (x *ConfigEntry) GetServiceResolver() *ServiceResolver {
	if x, ok := x.GetEntry().(*ConfigEntry_ServiceResolver); ok {
		return x.ServiceResolver
	}
	return nil
}

func (x *ConfigEntry) GetIngressGateway() *IngressGateway {
	if x, ok := x.GetEntry().(*ConfigEntry_IngressGateway); ok {
		return x.IngressGateway
	}
	return nil
}

func (x *ConfigEntry) GetServiceIntentions() *ServiceIntentions {
	if x, ok := x.GetEntry().(*ConfigEntry_ServiceIntentions); ok {
		return x.ServiceIntentions
	}
	return nil
}

func (x *ConfigEntry) GetServiceDefaults() *ServiceDefaults {
	if x, ok := x.GetEntry().(*ConfigEntry_ServiceDefaults); ok {
		return x.ServiceDefaults
	}
	return nil
}

func (x *ConfigEntry) GetAPIGateway() *APIGateway {
	if x, ok := x.GetEntry().(*ConfigEntry_APIGateway); ok {
		return x.APIGateway
	}
	return nil
}

func (x *ConfigEntry) GetBoundAPIGateway() *BoundAPIGateway {
	if x, ok := x.GetEntry().(*ConfigEntry_BoundAPIGateway); ok {
		return x.BoundAPIGateway
	}
	return nil
}

func (x *ConfigEntry) GetTCPRoute() *TCPRoute {
	if x, ok := x.GetEntry().(*ConfigEntry_TCPRoute); ok {
		return x.TCPRoute
	}
	return nil
}

func (x *ConfigEntry) GetHTTPRoute() *HTTPRoute {
	if x, ok := x.GetEntry().(*ConfigEntry_HTTPRoute); ok {
		return x.HTTPRoute
	}
	return nil
}

func (x *ConfigEntry) GetInlineCertificate() *InlineCertificate {
	if x, ok := x.GetEntry().(*ConfigEntry_InlineCertificate); ok {
		return x.InlineCertificate
	}
	return nil
}

func (x *ConfigEntry) GetSamenessGroup() *SamenessGroup {
	if x, ok := x.GetEntry().(*ConfigEntry_SamenessGroup); ok {
		return x.SamenessGroup
	}
	return nil
}

func (x *ConfigEntry) GetJWTProvider() *JWTProvider {
	if x, ok := x.GetEntry().(*ConfigEntry_JWTProvider); ok {
		return x.JWTProvider
	}
	return nil
}

func (x *ConfigEntry) GetExportedServices() *ExportedServices {
	if x, ok := x.GetEntry().(*ConfigEntry_ExportedServices); ok {
		return x.ExportedServices
	}
	return nil
}

func (x *ConfigEntry) GetFileSystemCertificate() *FileSystemCertificate {
	if x, ok := x.GetEntry().(*ConfigEntry_FileSystemCertificate); ok {
		return x.FileSystemCertificate
	}
	return nil
}

type isConfigEntry_Entry interface {
	isConfigEntry_Entry()
}

type ConfigEntry_MeshConfig struct {
	MeshConfig *MeshConfig `protobuf:"bytes,5,opt,name=MeshConfig,proto3,oneof"`
}

type ConfigEntry_ServiceResolver struct {
	ServiceResolver *ServiceResolver `protobuf:"bytes,6,opt,name=ServiceResolver,proto3,oneof"`
}

type ConfigEntry_IngressGateway struct {
	IngressGateway *IngressGateway `protobuf:"bytes,7,opt,name=IngressGateway,proto3,oneof"`
}

type ConfigEntry_ServiceIntentions struct {
	ServiceIntentions *ServiceIntentions `protobuf:"bytes,8,opt,name=ServiceIntentions,proto3,oneof"`
}

type ConfigEntry_ServiceDefaults struct {
	ServiceDefaults *ServiceDefaults `protobuf:"bytes,9,opt,name=ServiceDefaults,proto3,oneof"`
}

type ConfigEntry_APIGateway struct {
	APIGateway *APIGateway `protobuf:"bytes,10,opt,name=APIGateway,proto3,oneof"`
}

type ConfigEntry_BoundAPIGateway struct {
	BoundAPIGateway *BoundAPIGateway `protobuf:"bytes,11,opt,name=BoundAPIGateway,proto3,oneof"`
}

type ConfigEntry_TCPRoute struct {
	TCPRoute *TCPRoute `protobuf:"bytes,12,opt,name=TCPRoute,proto3,oneof"`
}

type ConfigEntry_HTTPRoute struct {
	HTTPRoute *HTTPRoute `protobuf:"bytes,13,opt,name=HTTPRoute,proto3,oneof"`
}

type ConfigEntry_InlineCertificate struct {
	InlineCertificate *InlineCertificate `protobuf:"bytes,14,opt,name=InlineCertificate,proto3,oneof"`
}

type ConfigEntry_SamenessGroup struct {
	SamenessGroup *SamenessGroup `protobuf:"bytes,15,opt,name=SamenessGroup,proto3,oneof"`
}

type ConfigEntry_JWTProvider struct {
	JWTProvider *JWTProvider `protobuf:"bytes,16,opt,name=JWTProvider,proto3,oneof"`
}

type ConfigEntry_ExportedServices struct {
	ExportedServices *ExportedServices `protobuf:"bytes,17,opt,name=ExportedServices,proto3,oneof"`
}

type ConfigEntry_FileSystemCertificate struct {
	FileSystemCertificate *FileSystemCertificate `protobuf:"bytes,18,opt,name=FileSystemCertificate,proto3,oneof"`
}

func (*ConfigEntry_MeshConfig) isConfigEntry_Entry() {}

func (*ConfigEntry_ServiceResolver) isConfigEntry_Entry() {}

func (*ConfigEntry_IngressGateway) isConfigEntry_Entry() {}

func (*ConfigEntry_ServiceIntentions) isConfigEntry_Entry() {}

func (*ConfigEntry_ServiceDefaults) isConfigEntry_Entry() {}

func (*ConfigEntry_APIGateway) isConfigEntry_Entry() {}

func (*ConfigEntry_BoundAPIGateway) isConfigEntry_Entry() {}

func (*ConfigEntry_TCPRoute) isConfigEntry_Entry() {}

func (*ConfigEntry_HTTPRoute) isConfigEntry_Entry() {}

func (*ConfigEntry_InlineCertificate) isConfigEntry_Entry() {}

func (*ConfigEntry_SamenessGroup) isConfigEntry_Entry() {}

func (*ConfigEntry_JWTProvider) isConfigEntry_Entry() {}

func (*ConfigEntry_ExportedServices) isConfigEntry_Entry() {}

func (*ConfigEntry_FileSystemCertificate) isConfigEntry_Entry() {}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.MeshConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=RaftIndex,EnterpriseMeta
type MeshConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TransparentProxy                 *TransparentProxyMeshConfig `protobuf:"bytes,1,opt,name=TransparentProxy,proto3" json:"TransparentProxy,omitempty"`
	TLS                              *MeshTLSConfig              `protobuf:"bytes,2,opt,name=TLS,proto3" json:"TLS,omitempty"`
	HTTP                             *MeshHTTPConfig             `protobuf:"bytes,3,opt,name=HTTP,proto3" json:"HTTP,omitempty"`
	Meta                             map[string]string           `protobuf:"bytes,4,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Peering                          *PeeringMeshConfig          `protobuf:"bytes,5,opt,name=Peering,proto3" json:"Peering,omitempty"`
	AllowEnablingPermissiveMutualTLS bool                        `protobuf:"varint,6,opt,name=AllowEnablingPermissiveMutualTLS,proto3" json:"AllowEnablingPermissiveMutualTLS,omitempty"`
	Hash                             uint64                      `protobuf:"varint,7,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *MeshConfig) Reset() {
	*x = MeshConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeshConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshConfig) ProtoMessage() {}

func (x *MeshConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshConfig.ProtoReflect.Descriptor instead.
func (*MeshConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{5}
}

func (x *MeshConfig) GetTransparentProxy() *TransparentProxyMeshConfig {
	if x != nil {
		return x.TransparentProxy
	}
	return nil
}

func (x *MeshConfig) GetTLS() *MeshTLSConfig {
	if x != nil {
		return x.TLS
	}
	return nil
}

func (x *MeshConfig) GetHTTP() *MeshHTTPConfig {
	if x != nil {
		return x.HTTP
	}
	return nil
}

func (x *MeshConfig) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *MeshConfig) GetPeering() *PeeringMeshConfig {
	if x != nil {
		return x.Peering
	}
	return nil
}

func (x *MeshConfig) GetAllowEnablingPermissiveMutualTLS() bool {
	if x != nil {
		return x.AllowEnablingPermissiveMutualTLS
	}
	return false
}

func (x *MeshConfig) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.TransparentProxyMeshConfig
// output=config_entry.gen.go
// name=Structs
type TransparentProxyMeshConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MeshDestinationsOnly bool `protobuf:"varint,1,opt,name=MeshDestinationsOnly,proto3" json:"MeshDestinationsOnly,omitempty"`
}

func (x *TransparentProxyMeshConfig) Reset() {
	*x = TransparentProxyMeshConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransparentProxyMeshConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransparentProxyMeshConfig) ProtoMessage() {}

func (x *TransparentProxyMeshConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransparentProxyMeshConfig.ProtoReflect.Descriptor instead.
func (*TransparentProxyMeshConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{6}
}

func (x *TransparentProxyMeshConfig) GetMeshDestinationsOnly() bool {
	if x != nil {
		return x.MeshDestinationsOnly
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.MeshTLSConfig
// output=config_entry.gen.go
// name=Structs
type MeshTLSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Incoming *MeshDirectionalTLSConfig `protobuf:"bytes,1,opt,name=Incoming,proto3" json:"Incoming,omitempty"`
	Outgoing *MeshDirectionalTLSConfig `protobuf:"bytes,2,opt,name=Outgoing,proto3" json:"Outgoing,omitempty"`
}

func (x *MeshTLSConfig) Reset() {
	*x = MeshTLSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeshTLSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshTLSConfig) ProtoMessage() {}

func (x *MeshTLSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshTLSConfig.ProtoReflect.Descriptor instead.
func (*MeshTLSConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{7}
}

func (x *MeshTLSConfig) GetIncoming() *MeshDirectionalTLSConfig {
	if x != nil {
		return x.Incoming
	}
	return nil
}

func (x *MeshTLSConfig) GetOutgoing() *MeshDirectionalTLSConfig {
	if x != nil {
		return x.Outgoing
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.MeshDirectionalTLSConfig
// output=config_entry.gen.go
// name=Structs
type MeshDirectionalTLSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-from=tlsVersionFromStructs func-to=tlsVersionToStructs
	TLSMinVersion string `protobuf:"bytes,1,opt,name=TLSMinVersion,proto3" json:"TLSMinVersion,omitempty"`
	// mog: func-from=tlsVersionFromStructs func-to=tlsVersionToStructs
	TLSMaxVersion string `protobuf:"bytes,2,opt,name=TLSMaxVersion,proto3" json:"TLSMaxVersion,omitempty"`
	// mog: func-from=cipherSuitesFromStructs func-to=cipherSuitesToStructs
	CipherSuites []string `protobuf:"bytes,3,rep,name=CipherSuites,proto3" json:"CipherSuites,omitempty"`
}

func (x *MeshDirectionalTLSConfig) Reset() {
	*x = MeshDirectionalTLSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeshDirectionalTLSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshDirectionalTLSConfig) ProtoMessage() {}

func (x *MeshDirectionalTLSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshDirectionalTLSConfig.ProtoReflect.Descriptor instead.
func (*MeshDirectionalTLSConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{8}
}

func (x *MeshDirectionalTLSConfig) GetTLSMinVersion() string {
	if x != nil {
		return x.TLSMinVersion
	}
	return ""
}

func (x *MeshDirectionalTLSConfig) GetTLSMaxVersion() string {
	if x != nil {
		return x.TLSMaxVersion
	}
	return ""
}

func (x *MeshDirectionalTLSConfig) GetCipherSuites() []string {
	if x != nil {
		return x.CipherSuites
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.MeshHTTPConfig
// output=config_entry.gen.go
// name=Structs
type MeshHTTPConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SanitizeXForwardedClientCert bool `protobuf:"varint,1,opt,name=SanitizeXForwardedClientCert,proto3" json:"SanitizeXForwardedClientCert,omitempty"`
}

func (x *MeshHTTPConfig) Reset() {
	*x = MeshHTTPConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeshHTTPConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshHTTPConfig) ProtoMessage() {}

func (x *MeshHTTPConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshHTTPConfig.ProtoReflect.Descriptor instead.
func (*MeshHTTPConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{9}
}

func (x *MeshHTTPConfig) GetSanitizeXForwardedClientCert() bool {
	if x != nil {
		return x.SanitizeXForwardedClientCert
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.PeeringMeshConfig
// output=config_entry.gen.go
// name=Structs
type PeeringMeshConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PeerThroughMeshGateways bool `protobuf:"varint,1,opt,name=PeerThroughMeshGateways,proto3" json:"PeerThroughMeshGateways,omitempty"`
}

func (x *PeeringMeshConfig) Reset() {
	*x = PeeringMeshConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeeringMeshConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeeringMeshConfig) ProtoMessage() {}

func (x *PeeringMeshConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeeringMeshConfig.ProtoReflect.Descriptor instead.
func (*PeeringMeshConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{10}
}

func (x *PeeringMeshConfig) GetPeerThroughMeshGateways() bool {
	if x != nil {
		return x.PeerThroughMeshGateways
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceResolverConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type ServiceResolver struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DefaultSubset string                              `protobuf:"bytes,1,opt,name=DefaultSubset,proto3" json:"DefaultSubset,omitempty"`
	Subsets       map[string]*ServiceResolverSubset   `protobuf:"bytes,2,rep,name=Subsets,proto3" json:"Subsets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Redirect      *ServiceResolverRedirect            `protobuf:"bytes,3,opt,name=Redirect,proto3" json:"Redirect,omitempty"`
	Failover      map[string]*ServiceResolverFailover `protobuf:"bytes,4,rep,name=Failover,proto3" json:"Failover,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	ConnectTimeout *durationpb.Duration `protobuf:"bytes,5,opt,name=ConnectTimeout,proto3" json:"ConnectTimeout,omitempty"`
	LoadBalancer   *LoadBalancer        `protobuf:"bytes,6,opt,name=LoadBalancer,proto3" json:"LoadBalancer,omitempty"`
	Meta           map[string]string    `protobuf:"bytes,7,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	RequestTimeout       *durationpb.Duration                 `protobuf:"bytes,8,opt,name=RequestTimeout,proto3" json:"RequestTimeout,omitempty"`
	PrioritizeByLocality *ServiceResolverPrioritizeByLocality `protobuf:"bytes,9,opt,name=PrioritizeByLocality,proto3" json:"PrioritizeByLocality,omitempty"`
	Hash                 uint64                               `protobuf:"varint,10,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *ServiceResolver) Reset() {
	*x = ServiceResolver{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceResolver) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceResolver) ProtoMessage() {}

func (x *ServiceResolver) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceResolver.ProtoReflect.Descriptor instead.
func (*ServiceResolver) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{11}
}

func (x *ServiceResolver) GetDefaultSubset() string {
	if x != nil {
		return x.DefaultSubset
	}
	return ""
}

func (x *ServiceResolver) GetSubsets() map[string]*ServiceResolverSubset {
	if x != nil {
		return x.Subsets
	}
	return nil
}

func (x *ServiceResolver) GetRedirect() *ServiceResolverRedirect {
	if x != nil {
		return x.Redirect
	}
	return nil
}

func (x *ServiceResolver) GetFailover() map[string]*ServiceResolverFailover {
	if x != nil {
		return x.Failover
	}
	return nil
}

func (x *ServiceResolver) GetConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

func (x *ServiceResolver) GetLoadBalancer() *LoadBalancer {
	if x != nil {
		return x.LoadBalancer
	}
	return nil
}

func (x *ServiceResolver) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *ServiceResolver) GetRequestTimeout() *durationpb.Duration {
	if x != nil {
		return x.RequestTimeout
	}
	return nil
}

func (x *ServiceResolver) GetPrioritizeByLocality() *ServiceResolverPrioritizeByLocality {
	if x != nil {
		return x.PrioritizeByLocality
	}
	return nil
}

func (x *ServiceResolver) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceResolverSubset
// output=config_entry.gen.go
// name=Structs
type ServiceResolverSubset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filter      string `protobuf:"bytes,1,opt,name=Filter,proto3" json:"Filter,omitempty"`
	OnlyPassing bool   `protobuf:"varint,2,opt,name=OnlyPassing,proto3" json:"OnlyPassing,omitempty"`
}

func (x *ServiceResolverSubset) Reset() {
	*x = ServiceResolverSubset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceResolverSubset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceResolverSubset) ProtoMessage() {}

func (x *ServiceResolverSubset) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceResolverSubset.ProtoReflect.Descriptor instead.
func (*ServiceResolverSubset) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{12}
}

func (x *ServiceResolverSubset) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ServiceResolverSubset) GetOnlyPassing() bool {
	if x != nil {
		return x.OnlyPassing
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceResolverRedirect
// output=config_entry.gen.go
// name=Structs
type ServiceResolverRedirect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Service       string `protobuf:"bytes,1,opt,name=Service,proto3" json:"Service,omitempty"`
	ServiceSubset string `protobuf:"bytes,2,opt,name=ServiceSubset,proto3" json:"ServiceSubset,omitempty"`
	Namespace     string `protobuf:"bytes,3,opt,name=Namespace,proto3" json:"Namespace,omitempty"`
	Partition     string `protobuf:"bytes,4,opt,name=Partition,proto3" json:"Partition,omitempty"`
	Datacenter    string `protobuf:"bytes,5,opt,name=Datacenter,proto3" json:"Datacenter,omitempty"`
	Peer          string `protobuf:"bytes,6,opt,name=Peer,proto3" json:"Peer,omitempty"`
	SamenessGroup string `protobuf:"bytes,7,opt,name=SamenessGroup,proto3" json:"SamenessGroup,omitempty"`
}

func (x *ServiceResolverRedirect) Reset() {
	*x = ServiceResolverRedirect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceResolverRedirect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceResolverRedirect) ProtoMessage() {}

func (x *ServiceResolverRedirect) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceResolverRedirect.ProtoReflect.Descriptor instead.
func (*ServiceResolverRedirect) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{13}
}

func (x *ServiceResolverRedirect) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ServiceResolverRedirect) GetServiceSubset() string {
	if x != nil {
		return x.ServiceSubset
	}
	return ""
}

func (x *ServiceResolverRedirect) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *ServiceResolverRedirect) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *ServiceResolverRedirect) GetDatacenter() string {
	if x != nil {
		return x.Datacenter
	}
	return ""
}

func (x *ServiceResolverRedirect) GetPeer() string {
	if x != nil {
		return x.Peer
	}
	return ""
}

func (x *ServiceResolverRedirect) GetSamenessGroup() string {
	if x != nil {
		return x.SamenessGroup
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceResolverFailover
// output=config_entry.gen.go
// name=Structs
type ServiceResolverFailover struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Service       string                           `protobuf:"bytes,1,opt,name=Service,proto3" json:"Service,omitempty"`
	ServiceSubset string                           `protobuf:"bytes,2,opt,name=ServiceSubset,proto3" json:"ServiceSubset,omitempty"`
	Namespace     string                           `protobuf:"bytes,3,opt,name=Namespace,proto3" json:"Namespace,omitempty"`
	Datacenters   []string                         `protobuf:"bytes,4,rep,name=Datacenters,proto3" json:"Datacenters,omitempty"`
	Targets       []*ServiceResolverFailoverTarget `protobuf:"bytes,5,rep,name=Targets,proto3" json:"Targets,omitempty"`
	Policy        *ServiceResolverFailoverPolicy   `protobuf:"bytes,6,opt,name=Policy,proto3" json:"Policy,omitempty"`
	SamenessGroup string                           `protobuf:"bytes,7,opt,name=SamenessGroup,proto3" json:"SamenessGroup,omitempty"`
}

func (x *ServiceResolverFailover) Reset() {
	*x = ServiceResolverFailover{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceResolverFailover) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceResolverFailover) ProtoMessage() {}

func (x *ServiceResolverFailover) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceResolverFailover.ProtoReflect.Descriptor instead.
func (*ServiceResolverFailover) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{14}
}

func (x *ServiceResolverFailover) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ServiceResolverFailover) GetServiceSubset() string {
	if x != nil {
		return x.ServiceSubset
	}
	return ""
}

func (x *ServiceResolverFailover) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *ServiceResolverFailover) GetDatacenters() []string {
	if x != nil {
		return x.Datacenters
	}
	return nil
}

func (x *ServiceResolverFailover) GetTargets() []*ServiceResolverFailoverTarget {
	if x != nil {
		return x.Targets
	}
	return nil
}

func (x *ServiceResolverFailover) GetPolicy() *ServiceResolverFailoverPolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *ServiceResolverFailover) GetSamenessGroup() string {
	if x != nil {
		return x.SamenessGroup
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceResolverFailoverPolicy
// output=config_entry.gen.go
// name=Structs
type ServiceResolverFailoverPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mode    string   `protobuf:"bytes,1,opt,name=Mode,proto3" json:"Mode,omitempty"`
	Regions []string `protobuf:"bytes,2,rep,name=Regions,proto3" json:"Regions,omitempty"`
}

func (x *ServiceResolverFailoverPolicy) Reset() {
	*x = ServiceResolverFailoverPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceResolverFailoverPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceResolverFailoverPolicy) ProtoMessage() {}

func (x *ServiceResolverFailoverPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceResolverFailoverPolicy.ProtoReflect.Descriptor instead.
func (*ServiceResolverFailoverPolicy) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{15}
}

func (x *ServiceResolverFailoverPolicy) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *ServiceResolverFailoverPolicy) GetRegions() []string {
	if x != nil {
		return x.Regions
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceResolverPrioritizeByLocality
// output=config_entry.gen.go
// name=Structs
type ServiceResolverPrioritizeByLocality struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mode string `protobuf:"bytes,1,opt,name=Mode,proto3" json:"Mode,omitempty"`
}

func (x *ServiceResolverPrioritizeByLocality) Reset() {
	*x = ServiceResolverPrioritizeByLocality{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceResolverPrioritizeByLocality) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceResolverPrioritizeByLocality) ProtoMessage() {}

func (x *ServiceResolverPrioritizeByLocality) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceResolverPrioritizeByLocality.ProtoReflect.Descriptor instead.
func (*ServiceResolverPrioritizeByLocality) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{16}
}

func (x *ServiceResolverPrioritizeByLocality) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceResolverFailoverTarget
// output=config_entry.gen.go
// name=Structs
type ServiceResolverFailoverTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Service       string `protobuf:"bytes,1,opt,name=Service,proto3" json:"Service,omitempty"`
	ServiceSubset string `protobuf:"bytes,2,opt,name=ServiceSubset,proto3" json:"ServiceSubset,omitempty"`
	Partition     string `protobuf:"bytes,3,opt,name=Partition,proto3" json:"Partition,omitempty"`
	Namespace     string `protobuf:"bytes,4,opt,name=Namespace,proto3" json:"Namespace,omitempty"`
	Datacenter    string `protobuf:"bytes,5,opt,name=Datacenter,proto3" json:"Datacenter,omitempty"`
	Peer          string `protobuf:"bytes,6,opt,name=Peer,proto3" json:"Peer,omitempty"`
}

func (x *ServiceResolverFailoverTarget) Reset() {
	*x = ServiceResolverFailoverTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceResolverFailoverTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceResolverFailoverTarget) ProtoMessage() {}

func (x *ServiceResolverFailoverTarget) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceResolverFailoverTarget.ProtoReflect.Descriptor instead.
func (*ServiceResolverFailoverTarget) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{17}
}

func (x *ServiceResolverFailoverTarget) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *ServiceResolverFailoverTarget) GetServiceSubset() string {
	if x != nil {
		return x.ServiceSubset
	}
	return ""
}

func (x *ServiceResolverFailoverTarget) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *ServiceResolverFailoverTarget) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *ServiceResolverFailoverTarget) GetDatacenter() string {
	if x != nil {
		return x.Datacenter
	}
	return ""
}

func (x *ServiceResolverFailoverTarget) GetPeer() string {
	if x != nil {
		return x.Peer
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.LoadBalancer
// output=config_entry.gen.go
// name=Structs
type LoadBalancer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Policy             string              `protobuf:"bytes,1,opt,name=Policy,proto3" json:"Policy,omitempty"`
	RingHashConfig     *RingHashConfig     `protobuf:"bytes,2,opt,name=RingHashConfig,proto3" json:"RingHashConfig,omitempty"`
	LeastRequestConfig *LeastRequestConfig `protobuf:"bytes,3,opt,name=LeastRequestConfig,proto3" json:"LeastRequestConfig,omitempty"`
	HashPolicies       []*HashPolicy       `protobuf:"bytes,4,rep,name=HashPolicies,proto3" json:"HashPolicies,omitempty"`
}

func (x *LoadBalancer) Reset() {
	*x = LoadBalancer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoadBalancer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancer) ProtoMessage() {}

func (x *LoadBalancer) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancer.ProtoReflect.Descriptor instead.
func (*LoadBalancer) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{18}
}

func (x *LoadBalancer) GetPolicy() string {
	if x != nil {
		return x.Policy
	}
	return ""
}

func (x *LoadBalancer) GetRingHashConfig() *RingHashConfig {
	if x != nil {
		return x.RingHashConfig
	}
	return nil
}

func (x *LoadBalancer) GetLeastRequestConfig() *LeastRequestConfig {
	if x != nil {
		return x.LeastRequestConfig
	}
	return nil
}

func (x *LoadBalancer) GetHashPolicies() []*HashPolicy {
	if x != nil {
		return x.HashPolicies
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.RingHashConfig
// output=config_entry.gen.go
// name=Structs
type RingHashConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MinimumRingSize uint64 `protobuf:"varint,1,opt,name=MinimumRingSize,proto3" json:"MinimumRingSize,omitempty"`
	MaximumRingSize uint64 `protobuf:"varint,2,opt,name=MaximumRingSize,proto3" json:"MaximumRingSize,omitempty"`
}

func (x *RingHashConfig) Reset() {
	*x = RingHashConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RingHashConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RingHashConfig) ProtoMessage() {}

func (x *RingHashConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RingHashConfig.ProtoReflect.Descriptor instead.
func (*RingHashConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{19}
}

func (x *RingHashConfig) GetMinimumRingSize() uint64 {
	if x != nil {
		return x.MinimumRingSize
	}
	return 0
}

func (x *RingHashConfig) GetMaximumRingSize() uint64 {
	if x != nil {
		return x.MaximumRingSize
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.LeastRequestConfig
// output=config_entry.gen.go
// name=Structs
type LeastRequestConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ChoiceCount uint32 `protobuf:"varint,1,opt,name=ChoiceCount,proto3" json:"ChoiceCount,omitempty"`
}

func (x *LeastRequestConfig) Reset() {
	*x = LeastRequestConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LeastRequestConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LeastRequestConfig) ProtoMessage() {}

func (x *LeastRequestConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LeastRequestConfig.ProtoReflect.Descriptor instead.
func (*LeastRequestConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{20}
}

func (x *LeastRequestConfig) GetChoiceCount() uint32 {
	if x != nil {
		return x.ChoiceCount
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HashPolicy
// output=config_entry.gen.go
// name=Structs
type HashPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Field        string        `protobuf:"bytes,1,opt,name=Field,proto3" json:"Field,omitempty"`
	FieldValue   string        `protobuf:"bytes,2,opt,name=FieldValue,proto3" json:"FieldValue,omitempty"`
	CookieConfig *CookieConfig `protobuf:"bytes,3,opt,name=CookieConfig,proto3" json:"CookieConfig,omitempty"`
	SourceIP     bool          `protobuf:"varint,4,opt,name=SourceIP,proto3" json:"SourceIP,omitempty"`
	Terminal     bool          `protobuf:"varint,5,opt,name=Terminal,proto3" json:"Terminal,omitempty"`
}

func (x *HashPolicy) Reset() {
	*x = HashPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HashPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HashPolicy) ProtoMessage() {}

func (x *HashPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HashPolicy.ProtoReflect.Descriptor instead.
func (*HashPolicy) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{21}
}

func (x *HashPolicy) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (x *HashPolicy) GetFieldValue() string {
	if x != nil {
		return x.FieldValue
	}
	return ""
}

func (x *HashPolicy) GetCookieConfig() *CookieConfig {
	if x != nil {
		return x.CookieConfig
	}
	return nil
}

func (x *HashPolicy) GetSourceIP() bool {
	if x != nil {
		return x.SourceIP
	}
	return false
}

func (x *HashPolicy) GetTerminal() bool {
	if x != nil {
		return x.Terminal
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.CookieConfig
// output=config_entry.gen.go
// name=Structs
type CookieConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Session bool `protobuf:"varint,1,opt,name=Session,proto3" json:"Session,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	TTL  *durationpb.Duration `protobuf:"bytes,2,opt,name=TTL,proto3" json:"TTL,omitempty"`
	Path string               `protobuf:"bytes,3,opt,name=Path,proto3" json:"Path,omitempty"`
}

func (x *CookieConfig) Reset() {
	*x = CookieConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CookieConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CookieConfig) ProtoMessage() {}

func (x *CookieConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CookieConfig.ProtoReflect.Descriptor instead.
func (*CookieConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{22}
}

func (x *CookieConfig) GetSession() bool {
	if x != nil {
		return x.Session
	}
	return false
}

func (x *CookieConfig) GetTTL() *durationpb.Duration {
	if x != nil {
		return x.TTL
	}
	return nil
}

func (x *CookieConfig) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IngressGatewayConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type IngressGateway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	TLS       *GatewayTLSConfig     `protobuf:"bytes,1,opt,name=TLS,proto3" json:"TLS,omitempty"`
	Listeners []*IngressListener    `protobuf:"bytes,2,rep,name=Listeners,proto3" json:"Listeners,omitempty"`
	Meta      map[string]string     `protobuf:"bytes,3,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Defaults  *IngressServiceConfig `protobuf:"bytes,4,opt,name=Defaults,proto3" json:"Defaults,omitempty"`
	Hash      uint64                `protobuf:"varint,5,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *IngressGateway) Reset() {
	*x = IngressGateway{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngressGateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngressGateway) ProtoMessage() {}

func (x *IngressGateway) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngressGateway.ProtoReflect.Descriptor instead.
func (*IngressGateway) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{23}
}

func (x *IngressGateway) GetTLS() *GatewayTLSConfig {
	if x != nil {
		return x.TLS
	}
	return nil
}

func (x *IngressGateway) GetListeners() []*IngressListener {
	if x != nil {
		return x.Listeners
	}
	return nil
}

func (x *IngressGateway) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *IngressGateway) GetDefaults() *IngressServiceConfig {
	if x != nil {
		return x.Defaults
	}
	return nil
}

func (x *IngressGateway) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IngressServiceConfig
// output=config_entry.gen.go
// name=Structs
type IngressServiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MaxConnections        uint32              `protobuf:"varint,1,opt,name=MaxConnections,proto3" json:"MaxConnections,omitempty"`
	MaxPendingRequests    uint32              `protobuf:"varint,2,opt,name=MaxPendingRequests,proto3" json:"MaxPendingRequests,omitempty"`
	MaxConcurrentRequests uint32              `protobuf:"varint,3,opt,name=MaxConcurrentRequests,proto3" json:"MaxConcurrentRequests,omitempty"`
	PassiveHealthCheck    *PassiveHealthCheck `protobuf:"bytes,4,opt,name=PassiveHealthCheck,proto3" json:"PassiveHealthCheck,omitempty"`
}

func (x *IngressServiceConfig) Reset() {
	*x = IngressServiceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngressServiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngressServiceConfig) ProtoMessage() {}

func (x *IngressServiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngressServiceConfig.ProtoReflect.Descriptor instead.
func (*IngressServiceConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{24}
}

func (x *IngressServiceConfig) GetMaxConnections() uint32 {
	if x != nil {
		return x.MaxConnections
	}
	return 0
}

func (x *IngressServiceConfig) GetMaxPendingRequests() uint32 {
	if x != nil {
		return x.MaxPendingRequests
	}
	return 0
}

func (x *IngressServiceConfig) GetMaxConcurrentRequests() uint32 {
	if x != nil {
		return x.MaxConcurrentRequests
	}
	return 0
}

func (x *IngressServiceConfig) GetPassiveHealthCheck() *PassiveHealthCheck {
	if x != nil {
		return x.PassiveHealthCheck
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.GatewayTLSConfig
// output=config_entry.gen.go
// name=Structs
type GatewayTLSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Enabled bool                 `protobuf:"varint,1,opt,name=Enabled,proto3" json:"Enabled,omitempty"`
	SDS     *GatewayTLSSDSConfig `protobuf:"bytes,2,opt,name=SDS,proto3" json:"SDS,omitempty"`
	// mog: func-from=tlsVersionFromStructs func-to=tlsVersionToStructs
	TLSMinVersion string `protobuf:"bytes,3,opt,name=TLSMinVersion,proto3" json:"TLSMinVersion,omitempty"`
	// mog: func-from=tlsVersionFromStructs func-to=tlsVersionToStructs
	TLSMaxVersion string `protobuf:"bytes,4,opt,name=TLSMaxVersion,proto3" json:"TLSMaxVersion,omitempty"`
	// mog: func-from=cipherSuitesFromStructs func-to=cipherSuitesToStructs
	CipherSuites []string `protobuf:"bytes,5,rep,name=CipherSuites,proto3" json:"CipherSuites,omitempty"`
}

func (x *GatewayTLSConfig) Reset() {
	*x = GatewayTLSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayTLSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayTLSConfig) ProtoMessage() {}

func (x *GatewayTLSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayTLSConfig.ProtoReflect.Descriptor instead.
func (*GatewayTLSConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{25}
}

func (x *GatewayTLSConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *GatewayTLSConfig) GetSDS() *GatewayTLSSDSConfig {
	if x != nil {
		return x.SDS
	}
	return nil
}

func (x *GatewayTLSConfig) GetTLSMinVersion() string {
	if x != nil {
		return x.TLSMinVersion
	}
	return ""
}

func (x *GatewayTLSConfig) GetTLSMaxVersion() string {
	if x != nil {
		return x.TLSMaxVersion
	}
	return ""
}

func (x *GatewayTLSConfig) GetCipherSuites() []string {
	if x != nil {
		return x.CipherSuites
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.GatewayTLSSDSConfig
// output=config_entry.gen.go
// name=Structs
type GatewayTLSSDSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClusterName  string `protobuf:"bytes,1,opt,name=ClusterName,proto3" json:"ClusterName,omitempty"`
	CertResource string `protobuf:"bytes,2,opt,name=CertResource,proto3" json:"CertResource,omitempty"`
}

func (x *GatewayTLSSDSConfig) Reset() {
	*x = GatewayTLSSDSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayTLSSDSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayTLSSDSConfig) ProtoMessage() {}

func (x *GatewayTLSSDSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayTLSSDSConfig.ProtoReflect.Descriptor instead.
func (*GatewayTLSSDSConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{26}
}

func (x *GatewayTLSSDSConfig) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *GatewayTLSSDSConfig) GetCertResource() string {
	if x != nil {
		return x.CertResource
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IngressListener
// output=config_entry.gen.go
// name=Structs
type IngressListener struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=int func-from=int32
	Port     int32             `protobuf:"varint,1,opt,name=Port,proto3" json:"Port,omitempty"`
	Protocol string            `protobuf:"bytes,2,opt,name=Protocol,proto3" json:"Protocol,omitempty"`
	Services []*IngressService `protobuf:"bytes,3,rep,name=Services,proto3" json:"Services,omitempty"`
	TLS      *GatewayTLSConfig `protobuf:"bytes,4,opt,name=TLS,proto3" json:"TLS,omitempty"`
}

func (x *IngressListener) Reset() {
	*x = IngressListener{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngressListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngressListener) ProtoMessage() {}

func (x *IngressListener) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngressListener.ProtoReflect.Descriptor instead.
func (*IngressListener) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{27}
}

func (x *IngressListener) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *IngressListener) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *IngressListener) GetServices() []*IngressService {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *IngressListener) GetTLS() *GatewayTLSConfig {
	if x != nil {
		return x.TLS
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IngressService
// output=config_entry.gen.go
// name=Structs
type IngressService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name            string                   `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Hosts           []string                 `protobuf:"bytes,2,rep,name=Hosts,proto3" json:"Hosts,omitempty"`
	TLS             *GatewayServiceTLSConfig `protobuf:"bytes,3,opt,name=TLS,proto3" json:"TLS,omitempty"`
	RequestHeaders  *HTTPHeaderModifiers     `protobuf:"bytes,4,opt,name=RequestHeaders,proto3" json:"RequestHeaders,omitempty"`
	ResponseHeaders *HTTPHeaderModifiers     `protobuf:"bytes,5,opt,name=ResponseHeaders,proto3" json:"ResponseHeaders,omitempty"`
	Meta            map[string]string        `protobuf:"bytes,6,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// mog: func-to=enterpriseMetaToStructs func-from=enterpriseMetaFromStructs
	EnterpriseMeta        *pbcommon.EnterpriseMeta `protobuf:"bytes,7,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	MaxConnections        uint32                   `protobuf:"varint,8,opt,name=MaxConnections,proto3" json:"MaxConnections,omitempty"`
	MaxPendingRequests    uint32                   `protobuf:"varint,9,opt,name=MaxPendingRequests,proto3" json:"MaxPendingRequests,omitempty"`
	MaxConcurrentRequests uint32                   `protobuf:"varint,10,opt,name=MaxConcurrentRequests,proto3" json:"MaxConcurrentRequests,omitempty"`
	PassiveHealthCheck    *PassiveHealthCheck      `protobuf:"bytes,11,opt,name=PassiveHealthCheck,proto3" json:"PassiveHealthCheck,omitempty"`
}

func (x *IngressService) Reset() {
	*x = IngressService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IngressService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IngressService) ProtoMessage() {}

func (x *IngressService) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IngressService.ProtoReflect.Descriptor instead.
func (*IngressService) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{28}
}

func (x *IngressService) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IngressService) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *IngressService) GetTLS() *GatewayServiceTLSConfig {
	if x != nil {
		return x.TLS
	}
	return nil
}

func (x *IngressService) GetRequestHeaders() *HTTPHeaderModifiers {
	if x != nil {
		return x.RequestHeaders
	}
	return nil
}

func (x *IngressService) GetResponseHeaders() *HTTPHeaderModifiers {
	if x != nil {
		return x.ResponseHeaders
	}
	return nil
}

func (x *IngressService) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *IngressService) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *IngressService) GetMaxConnections() uint32 {
	if x != nil {
		return x.MaxConnections
	}
	return 0
}

func (x *IngressService) GetMaxPendingRequests() uint32 {
	if x != nil {
		return x.MaxPendingRequests
	}
	return 0
}

func (x *IngressService) GetMaxConcurrentRequests() uint32 {
	if x != nil {
		return x.MaxConcurrentRequests
	}
	return 0
}

func (x *IngressService) GetPassiveHealthCheck() *PassiveHealthCheck {
	if x != nil {
		return x.PassiveHealthCheck
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.GatewayServiceTLSConfig
// output=config_entry.gen.go
// name=Structs
type GatewayServiceTLSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SDS *GatewayTLSSDSConfig `protobuf:"bytes,1,opt,name=SDS,proto3" json:"SDS,omitempty"`
}

func (x *GatewayServiceTLSConfig) Reset() {
	*x = GatewayServiceTLSConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GatewayServiceTLSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayServiceTLSConfig) ProtoMessage() {}

func (x *GatewayServiceTLSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayServiceTLSConfig.ProtoReflect.Descriptor instead.
func (*GatewayServiceTLSConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{29}
}

func (x *GatewayServiceTLSConfig) GetSDS() *GatewayTLSSDSConfig {
	if x != nil {
		return x.SDS
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPHeaderModifiers
// output=config_entry.gen.go
// name=Structs
type HTTPHeaderModifiers struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Add    map[string]string `protobuf:"bytes,1,rep,name=Add,proto3" json:"Add,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Set    map[string]string `protobuf:"bytes,2,rep,name=Set,proto3" json:"Set,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Remove []string          `protobuf:"bytes,3,rep,name=Remove,proto3" json:"Remove,omitempty"`
}

func (x *HTTPHeaderModifiers) Reset() {
	*x = HTTPHeaderModifiers{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPHeaderModifiers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHeaderModifiers) ProtoMessage() {}

func (x *HTTPHeaderModifiers) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHeaderModifiers.ProtoReflect.Descriptor instead.
func (*HTTPHeaderModifiers) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{30}
}

func (x *HTTPHeaderModifiers) GetAdd() map[string]string {
	if x != nil {
		return x.Add
	}
	return nil
}

func (x *HTTPHeaderModifiers) GetSet() map[string]string {
	if x != nil {
		return x.Set
	}
	return nil
}

func (x *HTTPHeaderModifiers) GetRemove() []string {
	if x != nil {
		return x.Remove
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceIntentionsConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type ServiceIntentions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Sources []*SourceIntention       `protobuf:"bytes,1,rep,name=Sources,proto3" json:"Sources,omitempty"`
	Meta    map[string]string        `protobuf:"bytes,2,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	JWT     *IntentionJWTRequirement `protobuf:"bytes,3,opt,name=JWT,proto3" json:"JWT,omitempty"`
	Hash    uint64                   `protobuf:"varint,4,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *ServiceIntentions) Reset() {
	*x = ServiceIntentions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceIntentions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceIntentions) ProtoMessage() {}

func (x *ServiceIntentions) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceIntentions.ProtoReflect.Descriptor instead.
func (*ServiceIntentions) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{31}
}

func (x *ServiceIntentions) GetSources() []*SourceIntention {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *ServiceIntentions) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *ServiceIntentions) GetJWT() *IntentionJWTRequirement {
	if x != nil {
		return x.JWT
	}
	return nil
}

func (x *ServiceIntentions) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IntentionJWTRequirement
// output=config_entry.gen.go
// name=Structs
type IntentionJWTRequirement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Providers []*IntentionJWTProvider `protobuf:"bytes,1,rep,name=Providers,proto3" json:"Providers,omitempty"`
}

func (x *IntentionJWTRequirement) Reset() {
	*x = IntentionJWTRequirement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentionJWTRequirement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentionJWTRequirement) ProtoMessage() {}

func (x *IntentionJWTRequirement) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentionJWTRequirement.ProtoReflect.Descriptor instead.
func (*IntentionJWTRequirement) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{32}
}

func (x *IntentionJWTRequirement) GetProviders() []*IntentionJWTProvider {
	if x != nil {
		return x.Providers
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IntentionJWTProvider
// output=config_entry.gen.go
// name=Structs
type IntentionJWTProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name         string                           `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	VerifyClaims []*IntentionJWTClaimVerification `protobuf:"bytes,2,rep,name=VerifyClaims,proto3" json:"VerifyClaims,omitempty"`
}

func (x *IntentionJWTProvider) Reset() {
	*x = IntentionJWTProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentionJWTProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentionJWTProvider) ProtoMessage() {}

func (x *IntentionJWTProvider) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentionJWTProvider.ProtoReflect.Descriptor instead.
func (*IntentionJWTProvider) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{33}
}

func (x *IntentionJWTProvider) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IntentionJWTProvider) GetVerifyClaims() []*IntentionJWTClaimVerification {
	if x != nil {
		return x.VerifyClaims
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IntentionJWTClaimVerification
// output=config_entry.gen.go
// name=Structs
type IntentionJWTClaimVerification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path  []string `protobuf:"bytes,1,rep,name=Path,proto3" json:"Path,omitempty"`
	Value string   `protobuf:"bytes,2,opt,name=Value,proto3" json:"Value,omitempty"`
}

func (x *IntentionJWTClaimVerification) Reset() {
	*x = IntentionJWTClaimVerification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentionJWTClaimVerification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentionJWTClaimVerification) ProtoMessage() {}

func (x *IntentionJWTClaimVerification) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentionJWTClaimVerification.ProtoReflect.Descriptor instead.
func (*IntentionJWTClaimVerification) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{34}
}

func (x *IntentionJWTClaimVerification) GetPath() []string {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *IntentionJWTClaimVerification) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.SourceIntention
// output=config_entry.gen.go
// name=Structs
type SourceIntention struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	// mog: func-to=intentionActionToStructs func-from=intentionActionFromStructs
	Action      IntentionAction        `protobuf:"varint,2,opt,name=Action,proto3,enum=hashicorp.consul.internal.configentry.IntentionAction" json:"Action,omitempty"`
	Permissions []*IntentionPermission `protobuf:"bytes,3,rep,name=Permissions,proto3" json:"Permissions,omitempty"`
	// mog: func-to=int func-from=int32
	Precedence int32  `protobuf:"varint,4,opt,name=Precedence,proto3" json:"Precedence,omitempty"`
	LegacyID   string `protobuf:"bytes,5,opt,name=LegacyID,proto3" json:"LegacyID,omitempty"`
	// mog: func-to=intentionSourceTypeToStructs func-from=intentionSourceTypeFromStructs
	Type        IntentionSourceType `protobuf:"varint,6,opt,name=Type,proto3,enum=hashicorp.consul.internal.configentry.IntentionSourceType" json:"Type,omitempty"`
	Description string              `protobuf:"bytes,7,opt,name=Description,proto3" json:"Description,omitempty"`
	LegacyMeta  map[string]string   `protobuf:"bytes,8,rep,name=LegacyMeta,proto3" json:"LegacyMeta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// mog: func-to=timeToStructs func-from=timeFromStructs
	LegacyCreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=LegacyCreateTime,proto3" json:"LegacyCreateTime,omitempty"`
	// mog: func-to=timeToStructs func-from=timeFromStructs
	LegacyUpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=LegacyUpdateTime,proto3" json:"LegacyUpdateTime,omitempty"`
	// mog: func-to=enterpriseMetaToStructs func-from=enterpriseMetaFromStructs
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,11,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	Peer           string                   `protobuf:"bytes,12,opt,name=Peer,proto3" json:"Peer,omitempty"`
	SamenessGroup  string                   `protobuf:"bytes,13,opt,name=SamenessGroup,proto3" json:"SamenessGroup,omitempty"`
}

func (x *SourceIntention) Reset() {
	*x = SourceIntention{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceIntention) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceIntention) ProtoMessage() {}

func (x *SourceIntention) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceIntention.ProtoReflect.Descriptor instead.
func (*SourceIntention) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{35}
}

func (x *SourceIntention) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SourceIntention) GetAction() IntentionAction {
	if x != nil {
		return x.Action
	}
	return IntentionAction_Deny
}

func (x *SourceIntention) GetPermissions() []*IntentionPermission {
	if x != nil {
		return x.Permissions
	}
	return nil
}

func (x *SourceIntention) GetPrecedence() int32 {
	if x != nil {
		return x.Precedence
	}
	return 0
}

func (x *SourceIntention) GetLegacyID() string {
	if x != nil {
		return x.LegacyID
	}
	return ""
}

func (x *SourceIntention) GetType() IntentionSourceType {
	if x != nil {
		return x.Type
	}
	return IntentionSourceType_Consul
}

func (x *SourceIntention) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SourceIntention) GetLegacyMeta() map[string]string {
	if x != nil {
		return x.LegacyMeta
	}
	return nil
}

func (x *SourceIntention) GetLegacyCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LegacyCreateTime
	}
	return nil
}

func (x *SourceIntention) GetLegacyUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LegacyUpdateTime
	}
	return nil
}

func (x *SourceIntention) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *SourceIntention) GetPeer() string {
	if x != nil {
		return x.Peer
	}
	return ""
}

func (x *SourceIntention) GetSamenessGroup() string {
	if x != nil {
		return x.SamenessGroup
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IntentionPermission
// output=config_entry.gen.go
// name=Structs
type IntentionPermission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=intentionActionToStructs func-from=intentionActionFromStructs
	Action IntentionAction          `protobuf:"varint,1,opt,name=Action,proto3,enum=hashicorp.consul.internal.configentry.IntentionAction" json:"Action,omitempty"`
	HTTP   *IntentionHTTPPermission `protobuf:"bytes,2,opt,name=HTTP,proto3" json:"HTTP,omitempty"`
	JWT    *IntentionJWTRequirement `protobuf:"bytes,3,opt,name=JWT,proto3" json:"JWT,omitempty"`
}

func (x *IntentionPermission) Reset() {
	*x = IntentionPermission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentionPermission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentionPermission) ProtoMessage() {}

func (x *IntentionPermission) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentionPermission.ProtoReflect.Descriptor instead.
func (*IntentionPermission) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{36}
}

func (x *IntentionPermission) GetAction() IntentionAction {
	if x != nil {
		return x.Action
	}
	return IntentionAction_Deny
}

func (x *IntentionPermission) GetHTTP() *IntentionHTTPPermission {
	if x != nil {
		return x.HTTP
	}
	return nil
}

func (x *IntentionPermission) GetJWT() *IntentionJWTRequirement {
	if x != nil {
		return x.JWT
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IntentionHTTPPermission
// output=config_entry.gen.go
// name=Structs
type IntentionHTTPPermission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PathExact  string                           `protobuf:"bytes,1,opt,name=PathExact,proto3" json:"PathExact,omitempty"`
	PathPrefix string                           `protobuf:"bytes,2,opt,name=PathPrefix,proto3" json:"PathPrefix,omitempty"`
	PathRegex  string                           `protobuf:"bytes,3,opt,name=PathRegex,proto3" json:"PathRegex,omitempty"`
	Header     []*IntentionHTTPHeaderPermission `protobuf:"bytes,4,rep,name=Header,proto3" json:"Header,omitempty"`
	Methods    []string                         `protobuf:"bytes,5,rep,name=Methods,proto3" json:"Methods,omitempty"`
}

func (x *IntentionHTTPPermission) Reset() {
	*x = IntentionHTTPPermission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentionHTTPPermission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentionHTTPPermission) ProtoMessage() {}

func (x *IntentionHTTPPermission) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentionHTTPPermission.ProtoReflect.Descriptor instead.
func (*IntentionHTTPPermission) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{37}
}

func (x *IntentionHTTPPermission) GetPathExact() string {
	if x != nil {
		return x.PathExact
	}
	return ""
}

func (x *IntentionHTTPPermission) GetPathPrefix() string {
	if x != nil {
		return x.PathPrefix
	}
	return ""
}

func (x *IntentionHTTPPermission) GetPathRegex() string {
	if x != nil {
		return x.PathRegex
	}
	return ""
}

func (x *IntentionHTTPPermission) GetHeader() []*IntentionHTTPHeaderPermission {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *IntentionHTTPPermission) GetMethods() []string {
	if x != nil {
		return x.Methods
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.IntentionHTTPHeaderPermission
// output=config_entry.gen.go
// name=Structs
type IntentionHTTPHeaderPermission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name    string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Present bool   `protobuf:"varint,2,opt,name=Present,proto3" json:"Present,omitempty"`
	Exact   string `protobuf:"bytes,3,opt,name=Exact,proto3" json:"Exact,omitempty"`
	Prefix  string `protobuf:"bytes,4,opt,name=Prefix,proto3" json:"Prefix,omitempty"`
	Suffix  string `protobuf:"bytes,5,opt,name=Suffix,proto3" json:"Suffix,omitempty"`
	Regex   string `protobuf:"bytes,6,opt,name=Regex,proto3" json:"Regex,omitempty"`
	Invert  bool   `protobuf:"varint,7,opt,name=Invert,proto3" json:"Invert,omitempty"`
}

func (x *IntentionHTTPHeaderPermission) Reset() {
	*x = IntentionHTTPHeaderPermission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentionHTTPHeaderPermission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentionHTTPHeaderPermission) ProtoMessage() {}

func (x *IntentionHTTPHeaderPermission) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentionHTTPHeaderPermission.ProtoReflect.Descriptor instead.
func (*IntentionHTTPHeaderPermission) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{38}
}

func (x *IntentionHTTPHeaderPermission) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IntentionHTTPHeaderPermission) GetPresent() bool {
	if x != nil {
		return x.Present
	}
	return false
}

func (x *IntentionHTTPHeaderPermission) GetExact() string {
	if x != nil {
		return x.Exact
	}
	return ""
}

func (x *IntentionHTTPHeaderPermission) GetPrefix() string {
	if x != nil {
		return x.Prefix
	}
	return ""
}

func (x *IntentionHTTPHeaderPermission) GetSuffix() string {
	if x != nil {
		return x.Suffix
	}
	return ""
}

func (x *IntentionHTTPHeaderPermission) GetRegex() string {
	if x != nil {
		return x.Regex
	}
	return ""
}

func (x *IntentionHTTPHeaderPermission) GetInvert() bool {
	if x != nil {
		return x.Invert
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type ServiceDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Protocol string `protobuf:"bytes,1,opt,name=Protocol,proto3" json:"Protocol,omitempty"`
	// mog: func-to=proxyModeToStructs func-from=proxyModeFromStructs
	Mode             ProxyMode               `protobuf:"varint,2,opt,name=Mode,proto3,enum=hashicorp.consul.internal.configentry.ProxyMode" json:"Mode,omitempty"`
	TransparentProxy *TransparentProxyConfig `protobuf:"bytes,3,opt,name=TransparentProxy,proto3" json:"TransparentProxy,omitempty"`
	MeshGateway      *MeshGatewayConfig      `protobuf:"bytes,4,opt,name=MeshGateway,proto3" json:"MeshGateway,omitempty"`
	Expose           *ExposeConfig           `protobuf:"bytes,5,opt,name=Expose,proto3" json:"Expose,omitempty"`
	ExternalSNI      string                  `protobuf:"bytes,6,opt,name=ExternalSNI,proto3" json:"ExternalSNI,omitempty"`
	UpstreamConfig   *UpstreamConfiguration  `protobuf:"bytes,7,opt,name=UpstreamConfig,proto3" json:"UpstreamConfig,omitempty"`
	Destination      *DestinationConfig      `protobuf:"bytes,8,opt,name=Destination,proto3" json:"Destination,omitempty"`
	// mog: func-to=int func-from=int32
	MaxInboundConnections int32 `protobuf:"varint,9,opt,name=MaxInboundConnections,proto3" json:"MaxInboundConnections,omitempty"`
	// mog: func-to=int func-from=int32
	LocalConnectTimeoutMs int32 `protobuf:"varint,10,opt,name=LocalConnectTimeoutMs,proto3" json:"LocalConnectTimeoutMs,omitempty"`
	// mog: func-to=int func-from=int32
	LocalRequestTimeoutMs     int32             `protobuf:"varint,11,opt,name=LocalRequestTimeoutMs,proto3" json:"LocalRequestTimeoutMs,omitempty"`
	BalanceInboundConnections string            `protobuf:"bytes,12,opt,name=BalanceInboundConnections,proto3" json:"BalanceInboundConnections,omitempty"`
	RateLimits                *RateLimits       `protobuf:"bytes,16,opt,name=RateLimits,proto3" json:"RateLimits,omitempty"`
	Meta                      map[string]string `protobuf:"bytes,13,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// mog: func-to=EnvoyExtensionsToStructs func-from=EnvoyExtensionsFromStructs
	EnvoyExtensions []*pbcommon.EnvoyExtension `protobuf:"bytes,14,rep,name=EnvoyExtensions,proto3" json:"EnvoyExtensions,omitempty"`
	// mog: func-to=mutualTLSModeToStructs func-from=mutualTLSModeFromStructs
	MutualTLSMode MutualTLSMode `protobuf:"varint,15,opt,name=MutualTLSMode,proto3,enum=hashicorp.consul.internal.configentry.MutualTLSMode" json:"MutualTLSMode,omitempty"`
	Hash          uint64        `protobuf:"varint,17,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *ServiceDefaults) Reset() {
	*x = ServiceDefaults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceDefaults) ProtoMessage() {}

func (x *ServiceDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceDefaults.ProtoReflect.Descriptor instead.
func (*ServiceDefaults) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{39}
}

func (x *ServiceDefaults) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *ServiceDefaults) GetMode() ProxyMode {
	if x != nil {
		return x.Mode
	}
	return ProxyMode_ProxyModeDefault
}

func (x *ServiceDefaults) GetTransparentProxy() *TransparentProxyConfig {
	if x != nil {
		return x.TransparentProxy
	}
	return nil
}

func (x *ServiceDefaults) GetMeshGateway() *MeshGatewayConfig {
	if x != nil {
		return x.MeshGateway
	}
	return nil
}

func (x *ServiceDefaults) GetExpose() *ExposeConfig {
	if x != nil {
		return x.Expose
	}
	return nil
}

func (x *ServiceDefaults) GetExternalSNI() string {
	if x != nil {
		return x.ExternalSNI
	}
	return ""
}

func (x *ServiceDefaults) GetUpstreamConfig() *UpstreamConfiguration {
	if x != nil {
		return x.UpstreamConfig
	}
	return nil
}

func (x *ServiceDefaults) GetDestination() *DestinationConfig {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ServiceDefaults) GetMaxInboundConnections() int32 {
	if x != nil {
		return x.MaxInboundConnections
	}
	return 0
}

func (x *ServiceDefaults) GetLocalConnectTimeoutMs() int32 {
	if x != nil {
		return x.LocalConnectTimeoutMs
	}
	return 0
}

func (x *ServiceDefaults) GetLocalRequestTimeoutMs() int32 {
	if x != nil {
		return x.LocalRequestTimeoutMs
	}
	return 0
}

func (x *ServiceDefaults) GetBalanceInboundConnections() string {
	if x != nil {
		return x.BalanceInboundConnections
	}
	return ""
}

func (x *ServiceDefaults) GetRateLimits() *RateLimits {
	if x != nil {
		return x.RateLimits
	}
	return nil
}

func (x *ServiceDefaults) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *ServiceDefaults) GetEnvoyExtensions() []*pbcommon.EnvoyExtension {
	if x != nil {
		return x.EnvoyExtensions
	}
	return nil
}

func (x *ServiceDefaults) GetMutualTLSMode() MutualTLSMode {
	if x != nil {
		return x.MutualTLSMode
	}
	return MutualTLSMode_MutualTLSModeDefault
}

func (x *ServiceDefaults) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.TransparentProxyConfig
// output=config_entry.gen.go
// name=Structs
type TransparentProxyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=int func-from=int32
	OutboundListenerPort int32 `protobuf:"varint,1,opt,name=OutboundListenerPort,proto3" json:"OutboundListenerPort,omitempty"`
	DialedDirectly       bool  `protobuf:"varint,2,opt,name=DialedDirectly,proto3" json:"DialedDirectly,omitempty"`
}

func (x *TransparentProxyConfig) Reset() {
	*x = TransparentProxyConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransparentProxyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransparentProxyConfig) ProtoMessage() {}

func (x *TransparentProxyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransparentProxyConfig.ProtoReflect.Descriptor instead.
func (*TransparentProxyConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{40}
}

func (x *TransparentProxyConfig) GetOutboundListenerPort() int32 {
	if x != nil {
		return x.OutboundListenerPort
	}
	return 0
}

func (x *TransparentProxyConfig) GetDialedDirectly() bool {
	if x != nil {
		return x.DialedDirectly
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.MeshGatewayConfig
// output=config_entry.gen.go
// name=Structs
type MeshGatewayConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=meshGatewayModeToStructs func-from=meshGatewayModeFromStructs
	Mode MeshGatewayMode `protobuf:"varint,1,opt,name=Mode,proto3,enum=hashicorp.consul.internal.configentry.MeshGatewayMode" json:"Mode,omitempty"`
}

func (x *MeshGatewayConfig) Reset() {
	*x = MeshGatewayConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MeshGatewayConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshGatewayConfig) ProtoMessage() {}

func (x *MeshGatewayConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshGatewayConfig.ProtoReflect.Descriptor instead.
func (*MeshGatewayConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{41}
}

func (x *MeshGatewayConfig) GetMode() MeshGatewayMode {
	if x != nil {
		return x.Mode
	}
	return MeshGatewayMode_MeshGatewayModeDefault
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ExposeConfig
// output=config_entry.gen.go
// name=Structs
type ExposeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Checks bool          `protobuf:"varint,1,opt,name=Checks,proto3" json:"Checks,omitempty"`
	Paths  []*ExposePath `protobuf:"bytes,2,rep,name=Paths,proto3" json:"Paths,omitempty"`
}

func (x *ExposeConfig) Reset() {
	*x = ExposeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExposeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExposeConfig) ProtoMessage() {}

func (x *ExposeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExposeConfig.ProtoReflect.Descriptor instead.
func (*ExposeConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{42}
}

func (x *ExposeConfig) GetChecks() bool {
	if x != nil {
		return x.Checks
	}
	return false
}

func (x *ExposeConfig) GetPaths() []*ExposePath {
	if x != nil {
		return x.Paths
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ExposePath
// output=config_entry.gen.go
// name=Structs
type ExposePath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=int func-from=int32
	ListenerPort int32  `protobuf:"varint,1,opt,name=ListenerPort,proto3" json:"ListenerPort,omitempty"`
	Path         string `protobuf:"bytes,2,opt,name=Path,proto3" json:"Path,omitempty"`
	// mog: func-to=int func-from=int32
	LocalPathPort   int32  `protobuf:"varint,3,opt,name=LocalPathPort,proto3" json:"LocalPathPort,omitempty"`
	Protocol        string `protobuf:"bytes,4,opt,name=Protocol,proto3" json:"Protocol,omitempty"`
	ParsedFromCheck bool   `protobuf:"varint,5,opt,name=ParsedFromCheck,proto3" json:"ParsedFromCheck,omitempty"`
}

func (x *ExposePath) Reset() {
	*x = ExposePath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExposePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExposePath) ProtoMessage() {}

func (x *ExposePath) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExposePath.ProtoReflect.Descriptor instead.
func (*ExposePath) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{43}
}

func (x *ExposePath) GetListenerPort() int32 {
	if x != nil {
		return x.ListenerPort
	}
	return 0
}

func (x *ExposePath) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ExposePath) GetLocalPathPort() int32 {
	if x != nil {
		return x.LocalPathPort
	}
	return 0
}

func (x *ExposePath) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *ExposePath) GetParsedFromCheck() bool {
	if x != nil {
		return x.ParsedFromCheck
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.UpstreamConfiguration
// output=config_entry.gen.go
// name=Structs
type UpstreamConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Overrides []*UpstreamConfig `protobuf:"bytes,1,rep,name=Overrides,proto3" json:"Overrides,omitempty"`
	Defaults  *UpstreamConfig   `protobuf:"bytes,2,opt,name=Defaults,proto3" json:"Defaults,omitempty"`
}

func (x *UpstreamConfiguration) Reset() {
	*x = UpstreamConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpstreamConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpstreamConfiguration) ProtoMessage() {}

func (x *UpstreamConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpstreamConfiguration.ProtoReflect.Descriptor instead.
func (*UpstreamConfiguration) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{44}
}

func (x *UpstreamConfiguration) GetOverrides() []*UpstreamConfig {
	if x != nil {
		return x.Overrides
	}
	return nil
}

func (x *UpstreamConfiguration) GetDefaults() *UpstreamConfig {
	if x != nil {
		return x.Defaults
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.UpstreamConfig
// output=config_entry.gen.go
// name=Structs
type UpstreamConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	// mog: func-to=enterpriseMetaToStructs func-from=enterpriseMetaFromStructs
	EnterpriseMeta    *pbcommon.EnterpriseMeta `protobuf:"bytes,2,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	EnvoyListenerJSON string                   `protobuf:"bytes,3,opt,name=EnvoyListenerJSON,proto3" json:"EnvoyListenerJSON,omitempty"`
	EnvoyClusterJSON  string                   `protobuf:"bytes,4,opt,name=EnvoyClusterJSON,proto3" json:"EnvoyClusterJSON,omitempty"`
	Protocol          string                   `protobuf:"bytes,5,opt,name=Protocol,proto3" json:"Protocol,omitempty"`
	// mog: func-to=int func-from=int32
	ConnectTimeoutMs           int32               `protobuf:"varint,6,opt,name=ConnectTimeoutMs,proto3" json:"ConnectTimeoutMs,omitempty"`
	Limits                     *UpstreamLimits     `protobuf:"bytes,7,opt,name=Limits,proto3" json:"Limits,omitempty"`
	PassiveHealthCheck         *PassiveHealthCheck `protobuf:"bytes,8,opt,name=PassiveHealthCheck,proto3" json:"PassiveHealthCheck,omitempty"`
	MeshGateway                *MeshGatewayConfig  `protobuf:"bytes,9,opt,name=MeshGateway,proto3" json:"MeshGateway,omitempty"`
	BalanceOutboundConnections string              `protobuf:"bytes,10,opt,name=BalanceOutboundConnections,proto3" json:"BalanceOutboundConnections,omitempty"`
	Peer                       string              `protobuf:"bytes,11,opt,name=Peer,proto3" json:"Peer,omitempty"`
}

func (x *UpstreamConfig) Reset() {
	*x = UpstreamConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpstreamConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpstreamConfig) ProtoMessage() {}

func (x *UpstreamConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpstreamConfig.ProtoReflect.Descriptor instead.
func (*UpstreamConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{45}
}

func (x *UpstreamConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpstreamConfig) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *UpstreamConfig) GetEnvoyListenerJSON() string {
	if x != nil {
		return x.EnvoyListenerJSON
	}
	return ""
}

func (x *UpstreamConfig) GetEnvoyClusterJSON() string {
	if x != nil {
		return x.EnvoyClusterJSON
	}
	return ""
}

func (x *UpstreamConfig) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *UpstreamConfig) GetConnectTimeoutMs() int32 {
	if x != nil {
		return x.ConnectTimeoutMs
	}
	return 0
}

func (x *UpstreamConfig) GetLimits() *UpstreamLimits {
	if x != nil {
		return x.Limits
	}
	return nil
}

func (x *UpstreamConfig) GetPassiveHealthCheck() *PassiveHealthCheck {
	if x != nil {
		return x.PassiveHealthCheck
	}
	return nil
}

func (x *UpstreamConfig) GetMeshGateway() *MeshGatewayConfig {
	if x != nil {
		return x.MeshGateway
	}
	return nil
}

func (x *UpstreamConfig) GetBalanceOutboundConnections() string {
	if x != nil {
		return x.BalanceOutboundConnections
	}
	return ""
}

func (x *UpstreamConfig) GetPeer() string {
	if x != nil {
		return x.Peer
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.UpstreamLimits
// output=config_entry.gen.go
// name=Structs
type UpstreamLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=pointerToIntFromInt32 func-from=int32FromPointerToInt
	MaxConnections int32 `protobuf:"varint,1,opt,name=MaxConnections,proto3" json:"MaxConnections,omitempty"`
	// mog: func-to=pointerToIntFromInt32 func-from=int32FromPointerToInt
	MaxPendingRequests int32 `protobuf:"varint,2,opt,name=MaxPendingRequests,proto3" json:"MaxPendingRequests,omitempty"`
	// mog: func-to=pointerToIntFromInt32 func-from=int32FromPointerToInt
	MaxConcurrentRequests int32 `protobuf:"varint,3,opt,name=MaxConcurrentRequests,proto3" json:"MaxConcurrentRequests,omitempty"`
}

func (x *UpstreamLimits) Reset() {
	*x = UpstreamLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpstreamLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpstreamLimits) ProtoMessage() {}

func (x *UpstreamLimits) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpstreamLimits.ProtoReflect.Descriptor instead.
func (*UpstreamLimits) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{46}
}

func (x *UpstreamLimits) GetMaxConnections() int32 {
	if x != nil {
		return x.MaxConnections
	}
	return 0
}

func (x *UpstreamLimits) GetMaxPendingRequests() int32 {
	if x != nil {
		return x.MaxPendingRequests
	}
	return 0
}

func (x *UpstreamLimits) GetMaxConcurrentRequests() int32 {
	if x != nil {
		return x.MaxConcurrentRequests
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.PassiveHealthCheck
// output=config_entry.gen.go
// name=Structs
type PassiveHealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	Interval    *durationpb.Duration `protobuf:"bytes,1,opt,name=Interval,proto3" json:"Interval,omitempty"`
	MaxFailures uint32               `protobuf:"varint,2,opt,name=MaxFailures,proto3" json:"MaxFailures,omitempty"`
	// mog: target=EnforcingConsecutive5xx func-to=pointerToUint32FromUint32 func-from=uint32FromPointerToUint32
	EnforcingConsecutive5Xx uint32 `protobuf:"varint,3,opt,name=EnforcingConsecutive5xx,proto3" json:"EnforcingConsecutive5xx,omitempty"`
	// mog: func-to=pointerToUint32FromUint32 func-from=uint32FromPointerToUint32
	MaxEjectionPercent uint32 `protobuf:"varint,4,opt,name=MaxEjectionPercent,proto3" json:"MaxEjectionPercent,omitempty"`
	// mog: func-to=structs.DurationPointerFromProto func-from=structs.DurationPointerToProto
	BaseEjectionTime *durationpb.Duration `protobuf:"bytes,5,opt,name=BaseEjectionTime,proto3" json:"BaseEjectionTime,omitempty"`
}

func (x *PassiveHealthCheck) Reset() {
	*x = PassiveHealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PassiveHealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PassiveHealthCheck) ProtoMessage() {}

func (x *PassiveHealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PassiveHealthCheck.ProtoReflect.Descriptor instead.
func (*PassiveHealthCheck) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{47}
}

func (x *PassiveHealthCheck) GetInterval() *durationpb.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *PassiveHealthCheck) GetMaxFailures() uint32 {
	if x != nil {
		return x.MaxFailures
	}
	return 0
}

func (x *PassiveHealthCheck) GetEnforcingConsecutive5Xx() uint32 {
	if x != nil {
		return x.EnforcingConsecutive5Xx
	}
	return 0
}

func (x *PassiveHealthCheck) GetMaxEjectionPercent() uint32 {
	if x != nil {
		return x.MaxEjectionPercent
	}
	return 0
}

func (x *PassiveHealthCheck) GetBaseEjectionTime() *durationpb.Duration {
	if x != nil {
		return x.BaseEjectionTime
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.DestinationConfig
// output=config_entry.gen.go
// name=Structs
type DestinationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Addresses []string `protobuf:"bytes,1,rep,name=Addresses,proto3" json:"Addresses,omitempty"`
	// mog: func-to=int func-from=int32
	Port int32 `protobuf:"varint,2,opt,name=Port,proto3" json:"Port,omitempty"`
}

func (x *DestinationConfig) Reset() {
	*x = DestinationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DestinationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DestinationConfig) ProtoMessage() {}

func (x *DestinationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DestinationConfig.ProtoReflect.Descriptor instead.
func (*DestinationConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{48}
}

func (x *DestinationConfig) GetAddresses() []string {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *DestinationConfig) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.RateLimits
// output=config_entry.gen.go
// name=Structs
type RateLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	InstanceLevel *InstanceLevelRateLimits `protobuf:"bytes,1,opt,name=InstanceLevel,proto3" json:"InstanceLevel,omitempty"`
}

func (x *RateLimits) Reset() {
	*x = RateLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RateLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimits) ProtoMessage() {}

func (x *RateLimits) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimits.ProtoReflect.Descriptor instead.
func (*RateLimits) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{49}
}

func (x *RateLimits) GetInstanceLevel() *InstanceLevelRateLimits {
	if x != nil {
		return x.InstanceLevel
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.InstanceLevelRateLimits
// output=config_entry.gen.go
// name=Structs
type InstanceLevelRateLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=int func-from=uint32
	RequestsPerSecond uint32 `protobuf:"varint,1,opt,name=RequestsPerSecond,proto3" json:"RequestsPerSecond,omitempty"`
	// mog: func-to=int func-from=uint32
	RequestsMaxBurst uint32                          `protobuf:"varint,2,opt,name=RequestsMaxBurst,proto3" json:"RequestsMaxBurst,omitempty"`
	Routes           []*InstanceLevelRouteRateLimits `protobuf:"bytes,3,rep,name=Routes,proto3" json:"Routes,omitempty"`
}

func (x *InstanceLevelRateLimits) Reset() {
	*x = InstanceLevelRateLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceLevelRateLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceLevelRateLimits) ProtoMessage() {}

func (x *InstanceLevelRateLimits) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceLevelRateLimits.ProtoReflect.Descriptor instead.
func (*InstanceLevelRateLimits) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{50}
}

func (x *InstanceLevelRateLimits) GetRequestsPerSecond() uint32 {
	if x != nil {
		return x.RequestsPerSecond
	}
	return 0
}

func (x *InstanceLevelRateLimits) GetRequestsMaxBurst() uint32 {
	if x != nil {
		return x.RequestsMaxBurst
	}
	return 0
}

func (x *InstanceLevelRateLimits) GetRoutes() []*InstanceLevelRouteRateLimits {
	if x != nil {
		return x.Routes
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.InstanceLevelRouteRateLimits
// output=config_entry.gen.go
// name=Structs
type InstanceLevelRouteRateLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	PathExact  string `protobuf:"bytes,1,opt,name=PathExact,proto3" json:"PathExact,omitempty"`
	PathPrefix string `protobuf:"bytes,2,opt,name=PathPrefix,proto3" json:"PathPrefix,omitempty"`
	PathRegex  string `protobuf:"bytes,3,opt,name=PathRegex,proto3" json:"PathRegex,omitempty"`
	// mog: func-to=int func-from=uint32
	RequestsPerSecond uint32 `protobuf:"varint,4,opt,name=RequestsPerSecond,proto3" json:"RequestsPerSecond,omitempty"`
	// mog: func-to=int func-from=uint32
	RequestsMaxBurst uint32 `protobuf:"varint,5,opt,name=RequestsMaxBurst,proto3" json:"RequestsMaxBurst,omitempty"`
}

func (x *InstanceLevelRouteRateLimits) Reset() {
	*x = InstanceLevelRouteRateLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceLevelRouteRateLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceLevelRouteRateLimits) ProtoMessage() {}

func (x *InstanceLevelRouteRateLimits) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceLevelRouteRateLimits.ProtoReflect.Descriptor instead.
func (*InstanceLevelRouteRateLimits) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{51}
}

func (x *InstanceLevelRouteRateLimits) GetPathExact() string {
	if x != nil {
		return x.PathExact
	}
	return ""
}

func (x *InstanceLevelRouteRateLimits) GetPathPrefix() string {
	if x != nil {
		return x.PathPrefix
	}
	return ""
}

func (x *InstanceLevelRouteRateLimits) GetPathRegex() string {
	if x != nil {
		return x.PathRegex
	}
	return ""
}

func (x *InstanceLevelRouteRateLimits) GetRequestsPerSecond() uint32 {
	if x != nil {
		return x.RequestsPerSecond
	}
	return 0
}

func (x *InstanceLevelRouteRateLimits) GetRequestsMaxBurst() uint32 {
	if x != nil {
		return x.RequestsMaxBurst
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.APIGatewayConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type APIGateway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Meta      map[string]string     `protobuf:"bytes,1,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Listeners []*APIGatewayListener `protobuf:"bytes,2,rep,name=Listeners,proto3" json:"Listeners,omitempty"`
	Status    *Status               `protobuf:"bytes,3,opt,name=Status,proto3" json:"Status,omitempty"`
	Hash      uint64                `protobuf:"varint,4,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *APIGateway) Reset() {
	*x = APIGateway{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APIGateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APIGateway) ProtoMessage() {}

func (x *APIGateway) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APIGateway.ProtoReflect.Descriptor instead.
func (*APIGateway) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{52}
}

func (x *APIGateway) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *APIGateway) GetListeners() []*APIGatewayListener {
	if x != nil {
		return x.Listeners
	}
	return nil
}

func (x *APIGateway) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *APIGateway) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.Status
// output=config_entry.gen.go
// name=Structs
type Status struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Conditions []*Condition `protobuf:"bytes,1,rep,name=Conditions,proto3" json:"Conditions,omitempty"`
}

func (x *Status) Reset() {
	*x = Status{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status) ProtoMessage() {}

func (x *Status) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status.ProtoReflect.Descriptor instead.
func (*Status) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{53}
}

func (x *Status) GetConditions() []*Condition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.Condition
// output=config_entry.gen.go
// name=Structs
type Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type     string             `protobuf:"bytes,1,opt,name=Type,proto3" json:"Type,omitempty"`
	Status   string             `protobuf:"bytes,2,opt,name=Status,proto3" json:"Status,omitempty"`
	Reason   string             `protobuf:"bytes,3,opt,name=Reason,proto3" json:"Reason,omitempty"`
	Message  string             `protobuf:"bytes,4,opt,name=Message,proto3" json:"Message,omitempty"`
	Resource *ResourceReference `protobuf:"bytes,5,opt,name=Resource,proto3" json:"Resource,omitempty"`
	// mog: func-to=timeToStructs func-from=timeFromStructs
	LastTransitionTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=LastTransitionTime,proto3" json:"LastTransitionTime,omitempty"`
}

func (x *Condition) Reset() {
	*x = Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition) ProtoMessage() {}

func (x *Condition) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition.ProtoReflect.Descriptor instead.
func (*Condition) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{54}
}

func (x *Condition) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Condition) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *Condition) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *Condition) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *Condition) GetResource() *ResourceReference {
	if x != nil {
		return x.Resource
	}
	return nil
}

func (x *Condition) GetLastTransitionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastTransitionTime
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.APIGatewayListener
// output=config_entry.gen.go
// name=Structs
type APIGatewayListener struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name     string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Hostname string `protobuf:"bytes,2,opt,name=Hostname,proto3" json:"Hostname,omitempty"`
	// mog: func-to=int func-from=int32
	Port int32 `protobuf:"varint,3,opt,name=Port,proto3" json:"Port,omitempty"`
	// mog: func-to=apiGatewayProtocolToStructs func-from=apiGatewayProtocolFromStructs
	Protocol APIGatewayListenerProtocol  `protobuf:"varint,4,opt,name=Protocol,proto3,enum=hashicorp.consul.internal.configentry.APIGatewayListenerProtocol" json:"Protocol,omitempty"`
	TLS      *APIGatewayTLSConfiguration `protobuf:"bytes,5,opt,name=TLS,proto3" json:"TLS,omitempty"`
	Override *APIGatewayPolicy           `protobuf:"bytes,6,opt,name=Override,proto3" json:"Override,omitempty"`
	Default  *APIGatewayPolicy           `protobuf:"bytes,7,opt,name=Default,proto3" json:"Default,omitempty"`
}

func (x *APIGatewayListener) Reset() {
	*x = APIGatewayListener{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APIGatewayListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APIGatewayListener) ProtoMessage() {}

func (x *APIGatewayListener) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APIGatewayListener.ProtoReflect.Descriptor instead.
func (*APIGatewayListener) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{55}
}

func (x *APIGatewayListener) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *APIGatewayListener) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *APIGatewayListener) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *APIGatewayListener) GetProtocol() APIGatewayListenerProtocol {
	if x != nil {
		return x.Protocol
	}
	return APIGatewayListenerProtocol_ListenerProtocolHTTP
}

func (x *APIGatewayListener) GetTLS() *APIGatewayTLSConfiguration {
	if x != nil {
		return x.TLS
	}
	return nil
}

func (x *APIGatewayListener) GetOverride() *APIGatewayPolicy {
	if x != nil {
		return x.Override
	}
	return nil
}

func (x *APIGatewayListener) GetDefault() *APIGatewayPolicy {
	if x != nil {
		return x.Default
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.APIGatewayTLSConfiguration
// output=config_entry.gen.go
// name=Structs
type APIGatewayTLSConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Certificates []*ResourceReference `protobuf:"bytes,1,rep,name=Certificates,proto3" json:"Certificates,omitempty"`
	// mog: func-from=tlsVersionFromStructs func-to=tlsVersionToStructs
	MinVersion string `protobuf:"bytes,2,opt,name=MinVersion,proto3" json:"MinVersion,omitempty"`
	// mog: func-from=tlsVersionFromStructs func-to=tlsVersionToStructs
	MaxVersion string `protobuf:"bytes,3,opt,name=MaxVersion,proto3" json:"MaxVersion,omitempty"`
	// mog: func-from=cipherSuitesFromStructs func-to=cipherSuitesToStructs
	CipherSuites []string `protobuf:"bytes,4,rep,name=CipherSuites,proto3" json:"CipherSuites,omitempty"`
}

func (x *APIGatewayTLSConfiguration) Reset() {
	*x = APIGatewayTLSConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APIGatewayTLSConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APIGatewayTLSConfiguration) ProtoMessage() {}

func (x *APIGatewayTLSConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APIGatewayTLSConfiguration.ProtoReflect.Descriptor instead.
func (*APIGatewayTLSConfiguration) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{56}
}

func (x *APIGatewayTLSConfiguration) GetCertificates() []*ResourceReference {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *APIGatewayTLSConfiguration) GetMinVersion() string {
	if x != nil {
		return x.MinVersion
	}
	return ""
}

func (x *APIGatewayTLSConfiguration) GetMaxVersion() string {
	if x != nil {
		return x.MaxVersion
	}
	return ""
}

func (x *APIGatewayTLSConfiguration) GetCipherSuites() []string {
	if x != nil {
		return x.CipherSuites
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.APIGatewayPolicy
// output=config_entry.gen.go
// name=Structs
type APIGatewayPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=gwJWTRequirementToStructs func-from=gwJWTRequirementFromStructs
	JWT *APIGatewayJWTRequirement `protobuf:"bytes,1,opt,name=JWT,proto3" json:"JWT,omitempty"`
}

func (x *APIGatewayPolicy) Reset() {
	*x = APIGatewayPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APIGatewayPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APIGatewayPolicy) ProtoMessage() {}

func (x *APIGatewayPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APIGatewayPolicy.ProtoReflect.Descriptor instead.
func (*APIGatewayPolicy) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{57}
}

func (x *APIGatewayPolicy) GetJWT() *APIGatewayJWTRequirement {
	if x != nil {
		return x.JWT
	}
	return nil
}

type APIGatewayJWTRequirement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Providers []*APIGatewayJWTProvider `protobuf:"bytes,1,rep,name=Providers,proto3" json:"Providers,omitempty"`
}

func (x *APIGatewayJWTRequirement) Reset() {
	*x = APIGatewayJWTRequirement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APIGatewayJWTRequirement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APIGatewayJWTRequirement) ProtoMessage() {}

func (x *APIGatewayJWTRequirement) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APIGatewayJWTRequirement.ProtoReflect.Descriptor instead.
func (*APIGatewayJWTRequirement) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{58}
}

func (x *APIGatewayJWTRequirement) GetProviders() []*APIGatewayJWTProvider {
	if x != nil {
		return x.Providers
	}
	return nil
}

type APIGatewayJWTProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name         string                            `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	VerifyClaims []*APIGatewayJWTClaimVerification `protobuf:"bytes,2,rep,name=VerifyClaims,proto3" json:"VerifyClaims,omitempty"`
}

func (x *APIGatewayJWTProvider) Reset() {
	*x = APIGatewayJWTProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APIGatewayJWTProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APIGatewayJWTProvider) ProtoMessage() {}

func (x *APIGatewayJWTProvider) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APIGatewayJWTProvider.ProtoReflect.Descriptor instead.
func (*APIGatewayJWTProvider) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{59}
}

func (x *APIGatewayJWTProvider) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *APIGatewayJWTProvider) GetVerifyClaims() []*APIGatewayJWTClaimVerification {
	if x != nil {
		return x.VerifyClaims
	}
	return nil
}

type APIGatewayJWTClaimVerification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path  []string `protobuf:"bytes,1,rep,name=Path,proto3" json:"Path,omitempty"`
	Value string   `protobuf:"bytes,2,opt,name=Value,proto3" json:"Value,omitempty"`
}

func (x *APIGatewayJWTClaimVerification) Reset() {
	*x = APIGatewayJWTClaimVerification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *APIGatewayJWTClaimVerification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*APIGatewayJWTClaimVerification) ProtoMessage() {}

func (x *APIGatewayJWTClaimVerification) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use APIGatewayJWTClaimVerification.ProtoReflect.Descriptor instead.
func (*APIGatewayJWTClaimVerification) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{60}
}

func (x *APIGatewayJWTClaimVerification) GetPath() []string {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *APIGatewayJWTClaimVerification) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ResourceReference
// output=config_entry.gen.go
// name=Structs
type ResourceReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind        string `protobuf:"bytes,1,opt,name=Kind,proto3" json:"Kind,omitempty"`
	Name        string `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	SectionName string `protobuf:"bytes,3,opt,name=SectionName,proto3" json:"SectionName,omitempty"`
	// mog: func-to=enterpriseMetaToStructs func-from=enterpriseMetaFromStructs
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,4,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
}

func (x *ResourceReference) Reset() {
	*x = ResourceReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceReference) ProtoMessage() {}

func (x *ResourceReference) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceReference.ProtoReflect.Descriptor instead.
func (*ResourceReference) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{61}
}

func (x *ResourceReference) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *ResourceReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResourceReference) GetSectionName() string {
	if x != nil {
		return x.SectionName
	}
	return ""
}

func (x *ResourceReference) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.BoundAPIGatewayConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type BoundAPIGateway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Meta      map[string]string          `protobuf:"bytes,1,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Listeners []*BoundAPIGatewayListener `protobuf:"bytes,2,rep,name=Listeners,proto3" json:"Listeners,omitempty"`
	// mog: func-to=serviceRefsToStructs func-from=serviceRefFromStructs
	Services map[string]*ListOfResourceReference `protobuf:"bytes,3,rep,name=Services,proto3" json:"Services,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Hash     uint64                              `protobuf:"varint,4,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *BoundAPIGateway) Reset() {
	*x = BoundAPIGateway{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundAPIGateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundAPIGateway) ProtoMessage() {}

func (x *BoundAPIGateway) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundAPIGateway.ProtoReflect.Descriptor instead.
func (*BoundAPIGateway) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{62}
}

func (x *BoundAPIGateway) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *BoundAPIGateway) GetListeners() []*BoundAPIGatewayListener {
	if x != nil {
		return x.Listeners
	}
	return nil
}

func (x *BoundAPIGateway) GetServices() map[string]*ListOfResourceReference {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *BoundAPIGateway) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

type ListOfResourceReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ref []*ResourceReference `protobuf:"bytes,1,rep,name=Ref,proto3" json:"Ref,omitempty"`
}

func (x *ListOfResourceReference) Reset() {
	*x = ListOfResourceReference{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOfResourceReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOfResourceReference) ProtoMessage() {}

func (x *ListOfResourceReference) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOfResourceReference.ProtoReflect.Descriptor instead.
func (*ListOfResourceReference) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{63}
}

func (x *ListOfResourceReference) GetRef() []*ResourceReference {
	if x != nil {
		return x.Ref
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.BoundAPIGatewayListener
// output=config_entry.gen.go
// name=Structs
type BoundAPIGatewayListener struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name         string               `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Certificates []*ResourceReference `protobuf:"bytes,2,rep,name=Certificates,proto3" json:"Certificates,omitempty"`
	Routes       []*ResourceReference `protobuf:"bytes,3,rep,name=Routes,proto3" json:"Routes,omitempty"`
}

func (x *BoundAPIGatewayListener) Reset() {
	*x = BoundAPIGatewayListener{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundAPIGatewayListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundAPIGatewayListener) ProtoMessage() {}

func (x *BoundAPIGatewayListener) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundAPIGatewayListener.ProtoReflect.Descriptor instead.
func (*BoundAPIGatewayListener) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{64}
}

func (x *BoundAPIGatewayListener) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BoundAPIGatewayListener) GetCertificates() []*ResourceReference {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *BoundAPIGatewayListener) GetRoutes() []*ResourceReference {
	if x != nil {
		return x.Routes
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.FileSystemCertificateConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type FileSystemCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Meta        map[string]string `protobuf:"bytes,1,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Certificate string            `protobuf:"bytes,2,opt,name=Certificate,proto3" json:"Certificate,omitempty"`
	PrivateKey  string            `protobuf:"bytes,3,opt,name=PrivateKey,proto3" json:"PrivateKey,omitempty"`
	Hash        uint64            `protobuf:"varint,4,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *FileSystemCertificate) Reset() {
	*x = FileSystemCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileSystemCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileSystemCertificate) ProtoMessage() {}

func (x *FileSystemCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileSystemCertificate.ProtoReflect.Descriptor instead.
func (*FileSystemCertificate) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{65}
}

func (x *FileSystemCertificate) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *FileSystemCertificate) GetCertificate() string {
	if x != nil {
		return x.Certificate
	}
	return ""
}

func (x *FileSystemCertificate) GetPrivateKey() string {
	if x != nil {
		return x.PrivateKey
	}
	return ""
}

func (x *FileSystemCertificate) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.InlineCertificateConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type InlineCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Meta        map[string]string `protobuf:"bytes,1,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Certificate string            `protobuf:"bytes,2,opt,name=Certificate,proto3" json:"Certificate,omitempty"`
	PrivateKey  string            `protobuf:"bytes,3,opt,name=PrivateKey,proto3" json:"PrivateKey,omitempty"`
	Hash        uint64            `protobuf:"varint,4,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *InlineCertificate) Reset() {
	*x = InlineCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InlineCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InlineCertificate) ProtoMessage() {}

func (x *InlineCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InlineCertificate.ProtoReflect.Descriptor instead.
func (*InlineCertificate) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{66}
}

func (x *InlineCertificate) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *InlineCertificate) GetCertificate() string {
	if x != nil {
		return x.Certificate
	}
	return ""
}

func (x *InlineCertificate) GetPrivateKey() string {
	if x != nil {
		return x.PrivateKey
	}
	return ""
}

func (x *InlineCertificate) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPRouteConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type HTTPRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Meta      map[string]string    `protobuf:"bytes,1,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Parents   []*ResourceReference `protobuf:"bytes,2,rep,name=Parents,proto3" json:"Parents,omitempty"`
	Rules     []*HTTPRouteRule     `protobuf:"bytes,3,rep,name=Rules,proto3" json:"Rules,omitempty"`
	Hostnames []string             `protobuf:"bytes,4,rep,name=Hostnames,proto3" json:"Hostnames,omitempty"`
	Status    *Status              `protobuf:"bytes,5,opt,name=Status,proto3" json:"Status,omitempty"`
	Hash      uint64               `protobuf:"varint,6,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *HTTPRoute) Reset() {
	*x = HTTPRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRoute) ProtoMessage() {}

func (x *HTTPRoute) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRoute.ProtoReflect.Descriptor instead.
func (*HTTPRoute) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{67}
}

func (x *HTTPRoute) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *HTTPRoute) GetParents() []*ResourceReference {
	if x != nil {
		return x.Parents
	}
	return nil
}

func (x *HTTPRoute) GetRules() []*HTTPRouteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *HTTPRoute) GetHostnames() []string {
	if x != nil {
		return x.Hostnames
	}
	return nil
}

func (x *HTTPRoute) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *HTTPRoute) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPRouteRule
// output=config_entry.gen.go
// name=Structs
type HTTPRouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filters         *HTTPFilters         `protobuf:"bytes,1,opt,name=Filters,proto3" json:"Filters,omitempty"`
	Matches         []*HTTPMatch         `protobuf:"bytes,2,rep,name=Matches,proto3" json:"Matches,omitempty"`
	Services        []*HTTPService       `protobuf:"bytes,3,rep,name=Services,proto3" json:"Services,omitempty"`
	ResponseFilters *HTTPResponseFilters `protobuf:"bytes,4,opt,name=ResponseFilters,proto3" json:"ResponseFilters,omitempty"`
}

func (x *HTTPRouteRule) Reset() {
	*x = HTTPRouteRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPRouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPRouteRule) ProtoMessage() {}

func (x *HTTPRouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPRouteRule.ProtoReflect.Descriptor instead.
func (*HTTPRouteRule) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{68}
}

func (x *HTTPRouteRule) GetFilters() *HTTPFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *HTTPRouteRule) GetMatches() []*HTTPMatch {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *HTTPRouteRule) GetServices() []*HTTPService {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *HTTPRouteRule) GetResponseFilters() *HTTPResponseFilters {
	if x != nil {
		return x.ResponseFilters
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPMatch
// output=config_entry.gen.go
// name=Structs
type HTTPMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Headers []*HTTPHeaderMatch `protobuf:"bytes,1,rep,name=Headers,proto3" json:"Headers,omitempty"`
	// mog: func-to=httpMatchMethodToStructs func-from=httpMatchMethodFromStructs
	Method HTTPMatchMethod   `protobuf:"varint,2,opt,name=Method,proto3,enum=hashicorp.consul.internal.configentry.HTTPMatchMethod" json:"Method,omitempty"`
	Path   *HTTPPathMatch    `protobuf:"bytes,3,opt,name=Path,proto3" json:"Path,omitempty"`
	Query  []*HTTPQueryMatch `protobuf:"bytes,4,rep,name=Query,proto3" json:"Query,omitempty"`
}

func (x *HTTPMatch) Reset() {
	*x = HTTPMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[69]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPMatch) ProtoMessage() {}

func (x *HTTPMatch) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[69]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPMatch.ProtoReflect.Descriptor instead.
func (*HTTPMatch) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{69}
}

func (x *HTTPMatch) GetHeaders() []*HTTPHeaderMatch {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HTTPMatch) GetMethod() HTTPMatchMethod {
	if x != nil {
		return x.Method
	}
	return HTTPMatchMethod_HTTPMatchMethodAll
}

func (x *HTTPMatch) GetPath() *HTTPPathMatch {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *HTTPMatch) GetQuery() []*HTTPQueryMatch {
	if x != nil {
		return x.Query
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPHeaderMatch
// output=config_entry.gen.go
// name=Structs
type HTTPHeaderMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=httpHeaderMatchToStructs func-from=httpHeaderMatchFromStructs
	Match HTTPHeaderMatchType `protobuf:"varint,1,opt,name=Match,proto3,enum=hashicorp.consul.internal.configentry.HTTPHeaderMatchType" json:"Match,omitempty"`
	Name  string              `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	Value string              `protobuf:"bytes,3,opt,name=Value,proto3" json:"Value,omitempty"`
}

func (x *HTTPHeaderMatch) Reset() {
	*x = HTTPHeaderMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPHeaderMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHeaderMatch) ProtoMessage() {}

func (x *HTTPHeaderMatch) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHeaderMatch.ProtoReflect.Descriptor instead.
func (*HTTPHeaderMatch) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{70}
}

func (x *HTTPHeaderMatch) GetMatch() HTTPHeaderMatchType {
	if x != nil {
		return x.Match
	}
	return HTTPHeaderMatchType_HTTPHeaderMatchExact
}

func (x *HTTPHeaderMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPHeaderMatch) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPPathMatch
// output=config_entry.gen.go
// name=Structs
type HTTPPathMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=httpPathMatchToStructs func-from=httpPathMatchFromStructs
	Match HTTPPathMatchType `protobuf:"varint,1,opt,name=Match,proto3,enum=hashicorp.consul.internal.configentry.HTTPPathMatchType" json:"Match,omitempty"`
	Value string            `protobuf:"bytes,2,opt,name=Value,proto3" json:"Value,omitempty"`
}

func (x *HTTPPathMatch) Reset() {
	*x = HTTPPathMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPPathMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPPathMatch) ProtoMessage() {}

func (x *HTTPPathMatch) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPPathMatch.ProtoReflect.Descriptor instead.
func (*HTTPPathMatch) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{71}
}

func (x *HTTPPathMatch) GetMatch() HTTPPathMatchType {
	if x != nil {
		return x.Match
	}
	return HTTPPathMatchType_HTTPPathMatchExact
}

func (x *HTTPPathMatch) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPQueryMatch
// output=config_entry.gen.go
// name=Structs
type HTTPQueryMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=httpQueryMatchToStructs func-from=httpQueryMatchFromStructs
	Match HTTPQueryMatchType `protobuf:"varint,1,opt,name=Match,proto3,enum=hashicorp.consul.internal.configentry.HTTPQueryMatchType" json:"Match,omitempty"`
	Name  string             `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	Value string             `protobuf:"bytes,3,opt,name=Value,proto3" json:"Value,omitempty"`
}

func (x *HTTPQueryMatch) Reset() {
	*x = HTTPQueryMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPQueryMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPQueryMatch) ProtoMessage() {}

func (x *HTTPQueryMatch) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPQueryMatch.ProtoReflect.Descriptor instead.
func (*HTTPQueryMatch) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{72}
}

func (x *HTTPQueryMatch) GetMatch() HTTPQueryMatchType {
	if x != nil {
		return x.Match
	}
	return HTTPQueryMatchType_HTTPQueryMatchExact
}

func (x *HTTPQueryMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPQueryMatch) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPFilters
// output=config_entry.gen.go
// name=Structs
type HTTPFilters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Headers       []*HTTPHeaderFilter `protobuf:"bytes,1,rep,name=Headers,proto3" json:"Headers,omitempty"`
	URLRewrite    *URLRewrite         `protobuf:"bytes,2,opt,name=URLRewrite,proto3" json:"URLRewrite,omitempty"`
	RetryFilter   *RetryFilter        `protobuf:"bytes,3,opt,name=RetryFilter,proto3" json:"RetryFilter,omitempty"`
	TimeoutFilter *TimeoutFilter      `protobuf:"bytes,4,opt,name=TimeoutFilter,proto3" json:"TimeoutFilter,omitempty"`
	// mog: func-to=routeJWTFilterToStructs func-from=routeJWTFilterFromStructs
	JWT *JWTFilter `protobuf:"bytes,5,opt,name=JWT,proto3" json:"JWT,omitempty"`
}

func (x *HTTPFilters) Reset() {
	*x = HTTPFilters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPFilters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPFilters) ProtoMessage() {}

func (x *HTTPFilters) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPFilters.ProtoReflect.Descriptor instead.
func (*HTTPFilters) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{73}
}

func (x *HTTPFilters) GetHeaders() []*HTTPHeaderFilter {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HTTPFilters) GetURLRewrite() *URLRewrite {
	if x != nil {
		return x.URLRewrite
	}
	return nil
}

func (x *HTTPFilters) GetRetryFilter() *RetryFilter {
	if x != nil {
		return x.RetryFilter
	}
	return nil
}

func (x *HTTPFilters) GetTimeoutFilter() *TimeoutFilter {
	if x != nil {
		return x.TimeoutFilter
	}
	return nil
}

func (x *HTTPFilters) GetJWT() *JWTFilter {
	if x != nil {
		return x.JWT
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPResponseFilters
// output=config_entry.gen.go
// name=Structs
type HTTPResponseFilters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Headers []*HTTPHeaderFilter `protobuf:"bytes,1,rep,name=Headers,proto3" json:"Headers,omitempty"`
}

func (x *HTTPResponseFilters) Reset() {
	*x = HTTPResponseFilters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPResponseFilters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPResponseFilters) ProtoMessage() {}

func (x *HTTPResponseFilters) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPResponseFilters.ProtoReflect.Descriptor instead.
func (*HTTPResponseFilters) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{74}
}

func (x *HTTPResponseFilters) GetHeaders() []*HTTPHeaderFilter {
	if x != nil {
		return x.Headers
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.URLRewrite
// output=config_entry.gen.go
// name=Structs
type URLRewrite struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path string `protobuf:"bytes,1,opt,name=Path,proto3" json:"Path,omitempty"`
}

func (x *URLRewrite) Reset() {
	*x = URLRewrite{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *URLRewrite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*URLRewrite) ProtoMessage() {}

func (x *URLRewrite) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use URLRewrite.ProtoReflect.Descriptor instead.
func (*URLRewrite) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{75}
}

func (x *URLRewrite) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.RetryFilter
// output=config_entry.gen.go
// name=Structs
type RetryFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	NumRetries            uint32   `protobuf:"varint,1,opt,name=NumRetries,proto3" json:"NumRetries,omitempty"`
	RetryOn               []string `protobuf:"bytes,2,rep,name=RetryOn,proto3" json:"RetryOn,omitempty"`
	RetryOnStatusCodes    []uint32 `protobuf:"varint,3,rep,packed,name=RetryOnStatusCodes,proto3" json:"RetryOnStatusCodes,omitempty"`
	RetryOnConnectFailure bool     `protobuf:"varint,4,opt,name=RetryOnConnectFailure,proto3" json:"RetryOnConnectFailure,omitempty"`
}

func (x *RetryFilter) Reset() {
	*x = RetryFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryFilter) ProtoMessage() {}

func (x *RetryFilter) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryFilter.ProtoReflect.Descriptor instead.
func (*RetryFilter) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{76}
}

func (x *RetryFilter) GetNumRetries() uint32 {
	if x != nil {
		return x.NumRetries
	}
	return 0
}

func (x *RetryFilter) GetRetryOn() []string {
	if x != nil {
		return x.RetryOn
	}
	return nil
}

func (x *RetryFilter) GetRetryOnStatusCodes() []uint32 {
	if x != nil {
		return x.RetryOnStatusCodes
	}
	return nil
}

func (x *RetryFilter) GetRetryOnConnectFailure() bool {
	if x != nil {
		return x.RetryOnConnectFailure
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.TimeoutFilter
// output=config_entry.gen.go
// name=Structs
type TimeoutFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	RequestTimeout *durationpb.Duration `protobuf:"bytes,1,opt,name=RequestTimeout,proto3" json:"RequestTimeout,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	IdleTimeout *durationpb.Duration `protobuf:"bytes,2,opt,name=IdleTimeout,proto3" json:"IdleTimeout,omitempty"`
}

func (x *TimeoutFilter) Reset() {
	*x = TimeoutFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeoutFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeoutFilter) ProtoMessage() {}

func (x *TimeoutFilter) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeoutFilter.ProtoReflect.Descriptor instead.
func (*TimeoutFilter) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{77}
}

func (x *TimeoutFilter) GetRequestTimeout() *durationpb.Duration {
	if x != nil {
		return x.RequestTimeout
	}
	return nil
}

func (x *TimeoutFilter) GetIdleTimeout() *durationpb.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

type JWTFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Providers []*APIGatewayJWTProvider `protobuf:"bytes,1,rep,name=Providers,proto3" json:"Providers,omitempty"`
}

func (x *JWTFilter) Reset() {
	*x = JWTFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWTFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWTFilter) ProtoMessage() {}

func (x *JWTFilter) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWTFilter.ProtoReflect.Descriptor instead.
func (*JWTFilter) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{78}
}

func (x *JWTFilter) GetProviders() []*APIGatewayJWTProvider {
	if x != nil {
		return x.Providers
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPHeaderFilter
// output=config_entry.gen.go
// name=Structs
type HTTPHeaderFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Add    map[string]string `protobuf:"bytes,1,rep,name=Add,proto3" json:"Add,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Remove []string          `protobuf:"bytes,2,rep,name=Remove,proto3" json:"Remove,omitempty"`
	Set    map[string]string `protobuf:"bytes,3,rep,name=Set,proto3" json:"Set,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *HTTPHeaderFilter) Reset() {
	*x = HTTPHeaderFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPHeaderFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHeaderFilter) ProtoMessage() {}

func (x *HTTPHeaderFilter) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHeaderFilter.ProtoReflect.Descriptor instead.
func (*HTTPHeaderFilter) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{79}
}

func (x *HTTPHeaderFilter) GetAdd() map[string]string {
	if x != nil {
		return x.Add
	}
	return nil
}

func (x *HTTPHeaderFilter) GetRemove() []string {
	if x != nil {
		return x.Remove
	}
	return nil
}

func (x *HTTPHeaderFilter) GetSet() map[string]string {
	if x != nil {
		return x.Set
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HTTPService
// output=config_entry.gen.go
// name=Structs
type HTTPService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	// mog: func-to=int func-from=int32
	Weight  int32        `protobuf:"varint,2,opt,name=Weight,proto3" json:"Weight,omitempty"`
	Filters *HTTPFilters `protobuf:"bytes,3,opt,name=Filters,proto3" json:"Filters,omitempty"`
	// mog: func-to=enterpriseMetaToStructs func-from=enterpriseMetaFromStructs
	EnterpriseMeta  *pbcommon.EnterpriseMeta `protobuf:"bytes,4,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	ResponseFilters *HTTPResponseFilters     `protobuf:"bytes,5,opt,name=ResponseFilters,proto3" json:"ResponseFilters,omitempty"`
}

func (x *HTTPService) Reset() {
	*x = HTTPService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HTTPService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPService) ProtoMessage() {}

func (x *HTTPService) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPService.ProtoReflect.Descriptor instead.
func (*HTTPService) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{80}
}

func (x *HTTPService) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPService) GetWeight() int32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

func (x *HTTPService) GetFilters() *HTTPFilters {
	if x != nil {
		return x.Filters
	}
	return nil
}

func (x *HTTPService) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *HTTPService) GetResponseFilters() *HTTPResponseFilters {
	if x != nil {
		return x.ResponseFilters
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.TCPRouteConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type TCPRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Meta     map[string]string    `protobuf:"bytes,1,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Parents  []*ResourceReference `protobuf:"bytes,2,rep,name=Parents,proto3" json:"Parents,omitempty"`
	Services []*TCPService        `protobuf:"bytes,3,rep,name=Services,proto3" json:"Services,omitempty"`
	Status   *Status              `protobuf:"bytes,4,opt,name=Status,proto3" json:"Status,omitempty"`
	Hash     uint64               `protobuf:"varint,5,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *TCPRoute) Reset() {
	*x = TCPRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TCPRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TCPRoute) ProtoMessage() {}

func (x *TCPRoute) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TCPRoute.ProtoReflect.Descriptor instead.
func (*TCPRoute) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{81}
}

func (x *TCPRoute) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *TCPRoute) GetParents() []*ResourceReference {
	if x != nil {
		return x.Parents
	}
	return nil
}

func (x *TCPRoute) GetServices() []*TCPService {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *TCPRoute) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *TCPRoute) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.TCPService
// output=config_entry.gen.go
// name=Structs
type TCPService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	// mog: func-to=enterpriseMetaToStructs func-from=enterpriseMetaFromStructs
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,2,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
}

func (x *TCPService) Reset() {
	*x = TCPService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TCPService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TCPService) ProtoMessage() {}

func (x *TCPService) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TCPService.ProtoReflect.Descriptor instead.
func (*TCPService) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{82}
}

func (x *TCPService) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TCPService) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.SamenessGroupConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=RaftIndex
type SamenessGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name               string                 `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	DefaultForFailover bool                   `protobuf:"varint,2,opt,name=DefaultForFailover,proto3" json:"DefaultForFailover,omitempty"`
	IncludeLocal       bool                   `protobuf:"varint,3,opt,name=IncludeLocal,proto3" json:"IncludeLocal,omitempty"`
	Members            []*SamenessGroupMember `protobuf:"bytes,4,rep,name=Members,proto3" json:"Members,omitempty"`
	Meta               map[string]string      `protobuf:"bytes,5,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// mog: func-to=enterpriseMetaToStructs func-from=enterpriseMetaFromStructs
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,6,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	Hash           uint64                   `protobuf:"varint,7,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *SamenessGroup) Reset() {
	*x = SamenessGroup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SamenessGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SamenessGroup) ProtoMessage() {}

func (x *SamenessGroup) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SamenessGroup.ProtoReflect.Descriptor instead.
func (*SamenessGroup) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{83}
}

func (x *SamenessGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SamenessGroup) GetDefaultForFailover() bool {
	if x != nil {
		return x.DefaultForFailover
	}
	return false
}

func (x *SamenessGroup) GetIncludeLocal() bool {
	if x != nil {
		return x.IncludeLocal
	}
	return false
}

func (x *SamenessGroup) GetMembers() []*SamenessGroupMember {
	if x != nil {
		return x.Members
	}
	return nil
}

func (x *SamenessGroup) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *SamenessGroup) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *SamenessGroup) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.SamenessGroupMember
// output=config_entry.gen.go
// name=Structs
type SamenessGroupMember struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Partition string `protobuf:"bytes,1,opt,name=Partition,proto3" json:"Partition,omitempty"`
	Peer      string `protobuf:"bytes,2,opt,name=Peer,proto3" json:"Peer,omitempty"`
}

func (x *SamenessGroupMember) Reset() {
	*x = SamenessGroupMember{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[84]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SamenessGroupMember) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SamenessGroupMember) ProtoMessage() {}

func (x *SamenessGroupMember) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[84]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SamenessGroupMember.ProtoReflect.Descriptor instead.
func (*SamenessGroupMember) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{84}
}

func (x *SamenessGroupMember) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *SamenessGroupMember) GetPeer() string {
	if x != nil {
		return x.Peer
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWTProviderConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Name,Kind,RaftIndex,EnterpriseMeta
type JWTProvider struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JSONWebKeySet *JSONWebKeySet       `protobuf:"bytes,1,opt,name=JSONWebKeySet,proto3" json:"JSONWebKeySet,omitempty"`
	Issuer        string               `protobuf:"bytes,2,opt,name=Issuer,proto3" json:"Issuer,omitempty"`
	Audiences     []string             `protobuf:"bytes,3,rep,name=Audiences,proto3" json:"Audiences,omitempty"`
	Locations     []*JWTLocation       `protobuf:"bytes,4,rep,name=Locations,proto3" json:"Locations,omitempty"`
	Forwarding    *JWTForwardingConfig `protobuf:"bytes,5,opt,name=Forwarding,proto3" json:"Forwarding,omitempty"`
	CacheConfig   *JWTCacheConfig      `protobuf:"bytes,6,opt,name=CacheConfig,proto3" json:"CacheConfig,omitempty"`
	Meta          map[string]string    `protobuf:"bytes,7,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// mog: func-to=int func-from=int32
	ClockSkewSeconds int32  `protobuf:"varint,8,opt,name=ClockSkewSeconds,proto3" json:"ClockSkewSeconds,omitempty"`
	Hash             uint64 `protobuf:"varint,9,opt,name=Hash,proto3" json:"Hash,omitempty"`
}

func (x *JWTProvider) Reset() {
	*x = JWTProvider{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[85]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWTProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWTProvider) ProtoMessage() {}

func (x *JWTProvider) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[85]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWTProvider.ProtoReflect.Descriptor instead.
func (*JWTProvider) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{85}
}

func (x *JWTProvider) GetJSONWebKeySet() *JSONWebKeySet {
	if x != nil {
		return x.JSONWebKeySet
	}
	return nil
}

func (x *JWTProvider) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *JWTProvider) GetAudiences() []string {
	if x != nil {
		return x.Audiences
	}
	return nil
}

func (x *JWTProvider) GetLocations() []*JWTLocation {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *JWTProvider) GetForwarding() *JWTForwardingConfig {
	if x != nil {
		return x.Forwarding
	}
	return nil
}

func (x *JWTProvider) GetCacheConfig() *JWTCacheConfig {
	if x != nil {
		return x.CacheConfig
	}
	return nil
}

func (x *JWTProvider) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *JWTProvider) GetClockSkewSeconds() int32 {
	if x != nil {
		return x.ClockSkewSeconds
	}
	return 0
}

func (x *JWTProvider) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JSONWebKeySet
// output=config_entry.gen.go
// name=Structs
type JSONWebKeySet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Local  *LocalJWKS  `protobuf:"bytes,1,opt,name=Local,proto3" json:"Local,omitempty"`
	Remote *RemoteJWKS `protobuf:"bytes,2,opt,name=Remote,proto3" json:"Remote,omitempty"`
}

func (x *JSONWebKeySet) Reset() {
	*x = JSONWebKeySet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[86]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JSONWebKeySet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JSONWebKeySet) ProtoMessage() {}

func (x *JSONWebKeySet) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[86]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JSONWebKeySet.ProtoReflect.Descriptor instead.
func (*JSONWebKeySet) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{86}
}

func (x *JSONWebKeySet) GetLocal() *LocalJWKS {
	if x != nil {
		return x.Local
	}
	return nil
}

func (x *JSONWebKeySet) GetRemote() *RemoteJWKS {
	if x != nil {
		return x.Remote
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.LocalJWKS
// output=config_entry.gen.go
// name=Structs
type LocalJWKS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	JWKS     string `protobuf:"bytes,1,opt,name=JWKS,proto3" json:"JWKS,omitempty"`
	Filename string `protobuf:"bytes,2,opt,name=Filename,proto3" json:"Filename,omitempty"`
}

func (x *LocalJWKS) Reset() {
	*x = LocalJWKS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[87]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocalJWKS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalJWKS) ProtoMessage() {}

func (x *LocalJWKS) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[87]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalJWKS.ProtoReflect.Descriptor instead.
func (*LocalJWKS) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{87}
}

func (x *LocalJWKS) GetJWKS() string {
	if x != nil {
		return x.JWKS
	}
	return ""
}

func (x *LocalJWKS) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.RemoteJWKS
// output=config_entry.gen.go
// name=Structs
type RemoteJWKS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	URI string `protobuf:"bytes,1,opt,name=URI,proto3" json:"URI,omitempty"`
	// mog: func-to=int func-from=int32
	RequestTimeoutMs int32 `protobuf:"varint,2,opt,name=RequestTimeoutMs,proto3" json:"RequestTimeoutMs,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	CacheDuration       *durationpb.Duration `protobuf:"bytes,3,opt,name=CacheDuration,proto3" json:"CacheDuration,omitempty"`
	FetchAsynchronously bool                 `protobuf:"varint,4,opt,name=FetchAsynchronously,proto3" json:"FetchAsynchronously,omitempty"`
	RetryPolicy         *JWKSRetryPolicy     `protobuf:"bytes,5,opt,name=RetryPolicy,proto3" json:"RetryPolicy,omitempty"`
	JWKSCluster         *JWKSCluster         `protobuf:"bytes,6,opt,name=JWKSCluster,proto3" json:"JWKSCluster,omitempty"`
}

func (x *RemoteJWKS) Reset() {
	*x = RemoteJWKS{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[88]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteJWKS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteJWKS) ProtoMessage() {}

func (x *RemoteJWKS) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[88]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteJWKS.ProtoReflect.Descriptor instead.
func (*RemoteJWKS) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{88}
}

func (x *RemoteJWKS) GetURI() string {
	if x != nil {
		return x.URI
	}
	return ""
}

func (x *RemoteJWKS) GetRequestTimeoutMs() int32 {
	if x != nil {
		return x.RequestTimeoutMs
	}
	return 0
}

func (x *RemoteJWKS) GetCacheDuration() *durationpb.Duration {
	if x != nil {
		return x.CacheDuration
	}
	return nil
}

func (x *RemoteJWKS) GetFetchAsynchronously() bool {
	if x != nil {
		return x.FetchAsynchronously
	}
	return false
}

func (x *RemoteJWKS) GetRetryPolicy() *JWKSRetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

func (x *RemoteJWKS) GetJWKSCluster() *JWKSCluster {
	if x != nil {
		return x.JWKSCluster
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWKSCluster
// output=config_entry.gen.go
// name=Structs
type JWKSCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DiscoveryType   string              `protobuf:"bytes,1,opt,name=DiscoveryType,proto3" json:"DiscoveryType,omitempty"`
	TLSCertificates *JWKSTLSCertificate `protobuf:"bytes,2,opt,name=TLSCertificates,proto3" json:"TLSCertificates,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	ConnectTimeout *durationpb.Duration `protobuf:"bytes,3,opt,name=ConnectTimeout,proto3" json:"ConnectTimeout,omitempty"`
}

func (x *JWKSCluster) Reset() {
	*x = JWKSCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[89]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWKSCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWKSCluster) ProtoMessage() {}

func (x *JWKSCluster) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[89]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWKSCluster.ProtoReflect.Descriptor instead.
func (*JWKSCluster) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{89}
}

func (x *JWKSCluster) GetDiscoveryType() string {
	if x != nil {
		return x.DiscoveryType
	}
	return ""
}

func (x *JWKSCluster) GetTLSCertificates() *JWKSTLSCertificate {
	if x != nil {
		return x.TLSCertificates
	}
	return nil
}

func (x *JWKSCluster) GetConnectTimeout() *durationpb.Duration {
	if x != nil {
		return x.ConnectTimeout
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWKSTLSCertificate
// output=config_entry.gen.go
// name=Structs
type JWKSTLSCertificate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CaCertificateProviderInstance *JWKSTLSCertProviderInstance `protobuf:"bytes,1,opt,name=CaCertificateProviderInstance,proto3" json:"CaCertificateProviderInstance,omitempty"`
	TrustedCA                     *JWKSTLSCertTrustedCA        `protobuf:"bytes,2,opt,name=TrustedCA,proto3" json:"TrustedCA,omitempty"`
}

func (x *JWKSTLSCertificate) Reset() {
	*x = JWKSTLSCertificate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[90]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWKSTLSCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWKSTLSCertificate) ProtoMessage() {}

func (x *JWKSTLSCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[90]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWKSTLSCertificate.ProtoReflect.Descriptor instead.
func (*JWKSTLSCertificate) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{90}
}

func (x *JWKSTLSCertificate) GetCaCertificateProviderInstance() *JWKSTLSCertProviderInstance {
	if x != nil {
		return x.CaCertificateProviderInstance
	}
	return nil
}

func (x *JWKSTLSCertificate) GetTrustedCA() *JWKSTLSCertTrustedCA {
	if x != nil {
		return x.TrustedCA
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWKSTLSCertProviderInstance
// output=config_entry.gen.go
// name=Structs
type JWKSTLSCertProviderInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	InstanceName    string `protobuf:"bytes,1,opt,name=InstanceName,proto3" json:"InstanceName,omitempty"`
	CertificateName string `protobuf:"bytes,2,opt,name=CertificateName,proto3" json:"CertificateName,omitempty"`
}

func (x *JWKSTLSCertProviderInstance) Reset() {
	*x = JWKSTLSCertProviderInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[91]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWKSTLSCertProviderInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWKSTLSCertProviderInstance) ProtoMessage() {}

func (x *JWKSTLSCertProviderInstance) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[91]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWKSTLSCertProviderInstance.ProtoReflect.Descriptor instead.
func (*JWKSTLSCertProviderInstance) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{91}
}

func (x *JWKSTLSCertProviderInstance) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *JWKSTLSCertProviderInstance) GetCertificateName() string {
	if x != nil {
		return x.CertificateName
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWKSTLSCertTrustedCA
// output=config_entry.gen.go
// name=Structs
type JWKSTLSCertTrustedCA struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Filename            string `protobuf:"bytes,1,opt,name=Filename,proto3" json:"Filename,omitempty"`
	EnvironmentVariable string `protobuf:"bytes,2,opt,name=EnvironmentVariable,proto3" json:"EnvironmentVariable,omitempty"`
	InlineString        string `protobuf:"bytes,3,opt,name=InlineString,proto3" json:"InlineString,omitempty"`
	InlineBytes         []byte `protobuf:"bytes,4,opt,name=InlineBytes,proto3" json:"InlineBytes,omitempty"`
}

func (x *JWKSTLSCertTrustedCA) Reset() {
	*x = JWKSTLSCertTrustedCA{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[92]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWKSTLSCertTrustedCA) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWKSTLSCertTrustedCA) ProtoMessage() {}

func (x *JWKSTLSCertTrustedCA) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[92]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWKSTLSCertTrustedCA.ProtoReflect.Descriptor instead.
func (*JWKSTLSCertTrustedCA) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{92}
}

func (x *JWKSTLSCertTrustedCA) GetFilename() string {
	if x != nil {
		return x.Filename
	}
	return ""
}

func (x *JWKSTLSCertTrustedCA) GetEnvironmentVariable() string {
	if x != nil {
		return x.EnvironmentVariable
	}
	return ""
}

func (x *JWKSTLSCertTrustedCA) GetInlineString() string {
	if x != nil {
		return x.InlineString
	}
	return ""
}

func (x *JWKSTLSCertTrustedCA) GetInlineBytes() []byte {
	if x != nil {
		return x.InlineBytes
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWKSRetryPolicy
// output=config_entry.gen.go
// name=Structs
type JWKSRetryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=int func-from=int32
	NumRetries         int32               `protobuf:"varint,1,opt,name=NumRetries,proto3" json:"NumRetries,omitempty"`
	RetryPolicyBackOff *RetryPolicyBackOff `protobuf:"bytes,2,opt,name=RetryPolicyBackOff,proto3" json:"RetryPolicyBackOff,omitempty"`
}

func (x *JWKSRetryPolicy) Reset() {
	*x = JWKSRetryPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[93]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWKSRetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWKSRetryPolicy) ProtoMessage() {}

func (x *JWKSRetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[93]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWKSRetryPolicy.ProtoReflect.Descriptor instead.
func (*JWKSRetryPolicy) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{93}
}

func (x *JWKSRetryPolicy) GetNumRetries() int32 {
	if x != nil {
		return x.NumRetries
	}
	return 0
}

func (x *JWKSRetryPolicy) GetRetryPolicyBackOff() *RetryPolicyBackOff {
	if x != nil {
		return x.RetryPolicyBackOff
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.RetryPolicyBackOff
// output=config_entry.gen.go
// name=Structs
type RetryPolicyBackOff struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	BaseInterval *durationpb.Duration `protobuf:"bytes,1,opt,name=BaseInterval,proto3" json:"BaseInterval,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	MaxInterval *durationpb.Duration `protobuf:"bytes,2,opt,name=MaxInterval,proto3" json:"MaxInterval,omitempty"`
}

func (x *RetryPolicyBackOff) Reset() {
	*x = RetryPolicyBackOff{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[94]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryPolicyBackOff) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryPolicyBackOff) ProtoMessage() {}

func (x *RetryPolicyBackOff) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[94]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryPolicyBackOff.ProtoReflect.Descriptor instead.
func (*RetryPolicyBackOff) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{94}
}

func (x *RetryPolicyBackOff) GetBaseInterval() *durationpb.Duration {
	if x != nil {
		return x.BaseInterval
	}
	return nil
}

func (x *RetryPolicyBackOff) GetMaxInterval() *durationpb.Duration {
	if x != nil {
		return x.MaxInterval
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWTLocation
// output=config_entry.gen.go
// name=Structs
type JWTLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Header     *JWTLocationHeader     `protobuf:"bytes,1,opt,name=Header,proto3" json:"Header,omitempty"`
	QueryParam *JWTLocationQueryParam `protobuf:"bytes,2,opt,name=QueryParam,proto3" json:"QueryParam,omitempty"`
	Cookie     *JWTLocationCookie     `protobuf:"bytes,3,opt,name=Cookie,proto3" json:"Cookie,omitempty"`
}

func (x *JWTLocation) Reset() {
	*x = JWTLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[95]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWTLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWTLocation) ProtoMessage() {}

func (x *JWTLocation) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[95]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWTLocation.ProtoReflect.Descriptor instead.
func (*JWTLocation) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{95}
}

func (x *JWTLocation) GetHeader() *JWTLocationHeader {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *JWTLocation) GetQueryParam() *JWTLocationQueryParam {
	if x != nil {
		return x.QueryParam
	}
	return nil
}

func (x *JWTLocation) GetCookie() *JWTLocationCookie {
	if x != nil {
		return x.Cookie
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWTLocationHeader
// output=config_entry.gen.go
// name=Structs
type JWTLocationHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name        string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	ValuePrefix string `protobuf:"bytes,2,opt,name=ValuePrefix,proto3" json:"ValuePrefix,omitempty"`
	Forward     bool   `protobuf:"varint,3,opt,name=Forward,proto3" json:"Forward,omitempty"`
}

func (x *JWTLocationHeader) Reset() {
	*x = JWTLocationHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[96]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWTLocationHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWTLocationHeader) ProtoMessage() {}

func (x *JWTLocationHeader) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[96]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWTLocationHeader.ProtoReflect.Descriptor instead.
func (*JWTLocationHeader) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{96}
}

func (x *JWTLocationHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *JWTLocationHeader) GetValuePrefix() string {
	if x != nil {
		return x.ValuePrefix
	}
	return ""
}

func (x *JWTLocationHeader) GetForward() bool {
	if x != nil {
		return x.Forward
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWTLocationQueryParam
// output=config_entry.gen.go
// name=Structs
type JWTLocationQueryParam struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
}

func (x *JWTLocationQueryParam) Reset() {
	*x = JWTLocationQueryParam{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[97]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWTLocationQueryParam) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWTLocationQueryParam) ProtoMessage() {}

func (x *JWTLocationQueryParam) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[97]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWTLocationQueryParam.ProtoReflect.Descriptor instead.
func (*JWTLocationQueryParam) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{97}
}

func (x *JWTLocationQueryParam) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWTLocationCookie
// output=config_entry.gen.go
// name=Structs
type JWTLocationCookie struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
}

func (x *JWTLocationCookie) Reset() {
	*x = JWTLocationCookie{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[98]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWTLocationCookie) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWTLocationCookie) ProtoMessage() {}

func (x *JWTLocationCookie) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[98]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWTLocationCookie.ProtoReflect.Descriptor instead.
func (*JWTLocationCookie) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{98}
}

func (x *JWTLocationCookie) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWTForwardingConfig
// output=config_entry.gen.go
// name=Structs
type JWTForwardingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	HeaderName              string `protobuf:"bytes,1,opt,name=HeaderName,proto3" json:"HeaderName,omitempty"`
	PadForwardPayloadHeader bool   `protobuf:"varint,2,opt,name=PadForwardPayloadHeader,proto3" json:"PadForwardPayloadHeader,omitempty"`
}

func (x *JWTForwardingConfig) Reset() {
	*x = JWTForwardingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[99]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWTForwardingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWTForwardingConfig) ProtoMessage() {}

func (x *JWTForwardingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[99]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWTForwardingConfig.ProtoReflect.Descriptor instead.
func (*JWTForwardingConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{99}
}

func (x *JWTForwardingConfig) GetHeaderName() string {
	if x != nil {
		return x.HeaderName
	}
	return ""
}

func (x *JWTForwardingConfig) GetPadForwardPayloadHeader() bool {
	if x != nil {
		return x.PadForwardPayloadHeader
	}
	return false
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.JWTCacheConfig
// output=config_entry.gen.go
// name=Structs
type JWTCacheConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// mog: func-to=int func-from=int32
	Size int32 `protobuf:"varint,1,opt,name=Size,proto3" json:"Size,omitempty"`
}

func (x *JWTCacheConfig) Reset() {
	*x = JWTCacheConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[100]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JWTCacheConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JWTCacheConfig) ProtoMessage() {}

func (x *JWTCacheConfig) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[100]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JWTCacheConfig.ProtoReflect.Descriptor instead.
func (*JWTCacheConfig) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{100}
}

func (x *JWTCacheConfig) GetSize() int32 {
	if x != nil {
		return x.Size
	}
	return 0
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ExportedServicesConfigEntry
// output=config_entry.gen.go
// name=Structs
// ignore-fields=Kind,Name,RaftIndex,EnterpriseMeta
type ExportedServices struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	// mog: func-to=enterpriseMetaToStructs func-from=enterpriseMetaFromStructs
	EnterpriseMeta *pbcommon.EnterpriseMeta   `protobuf:"bytes,2,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	Meta           map[string]string          `protobuf:"bytes,3,rep,name=Meta,proto3" json:"Meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Hash           uint64                     `protobuf:"varint,4,opt,name=Hash,proto3" json:"Hash,omitempty"`
	Services       []*ExportedServicesService `protobuf:"bytes,5,rep,name=Services,proto3" json:"Services,omitempty"`
}

func (x *ExportedServices) Reset() {
	*x = ExportedServices{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[101]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportedServices) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportedServices) ProtoMessage() {}

func (x *ExportedServices) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[101]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportedServices.ProtoReflect.Descriptor instead.
func (*ExportedServices) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{101}
}

func (x *ExportedServices) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExportedServices) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *ExportedServices) GetMeta() map[string]string {
	if x != nil {
		return x.Meta
	}
	return nil
}

func (x *ExportedServices) GetHash() uint64 {
	if x != nil {
		return x.Hash
	}
	return 0
}

func (x *ExportedServices) GetServices() []*ExportedServicesService {
	if x != nil {
		return x.Services
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ExportedService
// output=config_entry.gen.go
// name=Structs
type ExportedServicesService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name      string                      `protobuf:"bytes,1,opt,name=Name,proto3" json:"Name,omitempty"`
	Namespace string                      `protobuf:"bytes,2,opt,name=Namespace,proto3" json:"Namespace,omitempty"`
	Consumers []*ExportedServicesConsumer `protobuf:"bytes,3,rep,name=Consumers,proto3" json:"Consumers,omitempty"`
}

func (x *ExportedServicesService) Reset() {
	*x = ExportedServicesService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[102]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportedServicesService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportedServicesService) ProtoMessage() {}

func (x *ExportedServicesService) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[102]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportedServicesService.ProtoReflect.Descriptor instead.
func (*ExportedServicesService) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{102}
}

func (x *ExportedServicesService) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExportedServicesService) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *ExportedServicesService) GetConsumers() []*ExportedServicesConsumer {
	if x != nil {
		return x.Consumers
	}
	return nil
}

// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.ServiceConsumer
// output=config_entry.gen.go
// name=Structs
type ExportedServicesConsumer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Partition     string `protobuf:"bytes,1,opt,name=Partition,proto3" json:"Partition,omitempty"`
	Peer          string `protobuf:"bytes,2,opt,name=Peer,proto3" json:"Peer,omitempty"`
	SamenessGroup string `protobuf:"bytes,3,opt,name=SamenessGroup,proto3" json:"SamenessGroup,omitempty"`
}

func (x *ExportedServicesConsumer) Reset() {
	*x = ExportedServicesConsumer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[103]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportedServicesConsumer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportedServicesConsumer) ProtoMessage() {}

func (x *ExportedServicesConsumer) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbconfigentry_config_entry_proto_msgTypes[103]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportedServicesConsumer.ProtoReflect.Descriptor instead.
func (*ExportedServicesConsumer) Descriptor() ([]byte, []int) {
	return file_private_pbconfigentry_config_entry_proto_rawDescGZIP(), []int{103}
}

func (x *ExportedServicesConsumer) GetPartition() string {
	if x != nil {
		return x.Partition
	}
	return ""
}

func (x *ExportedServicesConsumer) GetPeer() string {
	if x != nil {
		return x.Peer
	}
	return ""
}

func (x *ExportedServicesConsumer) GetSamenessGroup() string {
	if x != nil {
		return x.SamenessGroup
	}
	return ""
}

var File_private_pbconfigentry_config_entry_proto protoreflect.FileDescriptor

var file_private_pbconfigentry_config_entry_proto_rawDesc = []byte{
	0x0a, 0x28, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x2f, 0x70, 0x62, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x1a, 0x25, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x72,
	0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x2f, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x2f, 0x70, 0x62, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x42, 0x0a, 0x22, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1c,
	0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x01, 0x0a,
	0x23, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x22, 0xdd, 0x01, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x52, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x12, 0x4e, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x73, 0x52, 0x09, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x73,
	0x22, 0x41, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x73, 0x12, 0x14, 0x0a,
	0x05, 0x50, 0x65, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x50, 0x65,
	0x65, 0x72, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xcf, 0x0c, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x3f, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04,
	0x4b, 0x69, 0x6e, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x52, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x12, 0x49, 0x0a, 0x09, 0x52, 0x61, 0x66, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x61, 0x66, 0x74, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x52, 0x09, 0x52, 0x61, 0x66, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x53, 0x0a,
	0x0a, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0a, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x62, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x6c, 0x76, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c,
	0x76, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x12, 0x5f, 0x0a, 0x0e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x68, 0x0a, 0x11, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x11,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x62, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0a,
	0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x62, 0x0a, 0x0f, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x4d,
	0x0a, 0x08, 0x54, 0x43, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x54, 0x43, 0x50, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x48, 0x00, 0x52, 0x08, 0x54, 0x43, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x50, 0x0a,
	0x09, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12,
	0x68, 0x0a, 0x11, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x11, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x5c, 0x0a, 0x0d, 0x53, 0x61, 0x6d,
	0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73,
	0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x0d, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65,
	0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x56, 0x0a, 0x0b, 0x4a, 0x57, 0x54, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x0b, 0x4a, 0x57, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12,
	0x65, 0x0a, 0x10, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x48, 0x00, 0x52, 0x10, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x74, 0x0a, 0x15, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x46, 0x69,
	0x6c, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x15, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x42, 0x07, 0x0a, 0x05,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0xcc, 0x04, 0x0a, 0x0a, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x6d, 0x0a, 0x10, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x10, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x78, 0x79, 0x12, 0x46, 0x0a, 0x03, 0x54, 0x4c, 0x53, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x54, 0x4c, 0x53,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x54, 0x4c, 0x53, 0x12, 0x49, 0x0a, 0x04, 0x48,
	0x54, 0x54, 0x50, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x48, 0x54, 0x54, 0x50, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x04, 0x48, 0x54, 0x54, 0x50, 0x12, 0x4f, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4d, 0x65, 0x73,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x52, 0x0a, 0x07, 0x50, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x07, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x4a, 0x0a, 0x20, 0x41,
	0x6c, 0x6c, 0x6f, 0x77, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x76, 0x65, 0x4d, 0x75, 0x74, 0x75, 0x61, 0x6c, 0x54, 0x4c, 0x53, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x20, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x76, 0x65, 0x4d, 0x75,
	0x74, 0x75, 0x61, 0x6c, 0x54, 0x4c, 0x53, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d,
	0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x50, 0x0a, 0x1a, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x32, 0x0a, 0x14, 0x4d, 0x65, 0x73, 0x68, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x14, 0x4d, 0x65, 0x73, 0x68, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xc9, 0x01, 0x0a, 0x0d, 0x4d, 0x65, 0x73, 0x68, 0x54,
	0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5b, 0x0a, 0x08, 0x49, 0x6e, 0x63, 0x6f,
	0x6d, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x49, 0x6e, 0x63,
	0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x5b, 0x0a, 0x08, 0x4f, 0x75, 0x74, 0x67, 0x6f, 0x69, 0x6e,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e,
	0x4d, 0x65, 0x73, 0x68, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x54,
	0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x4f, 0x75, 0x74, 0x67, 0x6f, 0x69,
	0x6e, 0x67, 0x22, 0x8a, 0x01, 0x0a, 0x18, 0x4d, 0x65, 0x73, 0x68, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x24, 0x0a, 0x0d, 0x54, 0x4c, 0x53, 0x4d, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x54, 0x4c, 0x53, 0x4d, 0x69, 0x6e, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0d, 0x54, 0x4c, 0x53, 0x4d, 0x61, 0x78, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x54, 0x4c,
	0x53, 0x4d, 0x61, 0x78, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x43,
	0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0c, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x73, 0x22,
	0x54, 0x0a, 0x0e, 0x4d, 0x65, 0x73, 0x68, 0x48, 0x54, 0x54, 0x50, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x42, 0x0a, 0x1c, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x58, 0x46, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1c, 0x53, 0x61, 0x6e, 0x69, 0x74, 0x69, 0x7a,
	0x65, 0x58, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x43, 0x65, 0x72, 0x74, 0x22, 0x4d, 0x0a, 0x11, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x4d, 0x65, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x38, 0x0a, 0x17, 0x50, 0x65,
	0x65, 0x72, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x50, 0x65, 0x65,
	0x72, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x73, 0x22, 0xcd, 0x08, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x12, 0x5d,
	0x0a, 0x07, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x43, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x73, 0x12, 0x5a, 0x0a,
	0x08, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52,
	0x08, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x12, 0x60, 0x0a, 0x08, 0x46, 0x61, 0x69,
	0x6c, 0x6f, 0x76, 0x65, 0x72, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c,
	0x76, 0x65, 0x72, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x08, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x0e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x57,
	0x0a, 0x0c, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4c, 0x6f, 0x61,
	0x64, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x52, 0x0c, 0x4c, 0x6f, 0x61, 0x64, 0x42,
	0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x2e, 0x4d, 0x65,
	0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x41, 0x0a,
	0x0e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x12, 0x7e, 0x0a, 0x14, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x42, 0x79,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x69, 0x7a, 0x65,
	0x42, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x14, 0x50, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04,
	0x48, 0x61, 0x73, 0x68, 0x1a, 0x78, 0x0a, 0x0c, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x52, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x53, 0x75, 0x62,
	0x73, 0x65, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x7b,
	0x0a, 0x0d, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x54, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x37, 0x0a, 0x09, 0x4d,
	0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x51, 0x0a, 0x15, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x0b, 0x4f, 0x6e, 0x6c, 0x79, 0x50, 0x61, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x4f, 0x6e, 0x6c, 0x79,
	0x50, 0x61, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0xef, 0x01, 0x0a, 0x17, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x52, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x24, 0x0a,
	0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x75, 0x62,
	0x73, 0x65, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1e, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x50, 0x65, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x50,
	0x65, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x53, 0x61, 0x6d, 0x65,
	0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xfd, 0x02, 0x0a, 0x17, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x46, 0x61, 0x69,
	0x6c, 0x6f, 0x76, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x24, 0x0a, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53,
	0x75, 0x62, 0x73, 0x65, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x73, 0x12, 0x5e, 0x0a, 0x07, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x46, 0x61,
	0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x07, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x5c, 0x0a, 0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x46, 0x61, 0x69,
	0x6c, 0x6f, 0x76, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x24, 0x0a, 0x0d, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x53, 0x61, 0x6d, 0x65,
	0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x4d, 0x0a, 0x1d, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x46, 0x61, 0x69, 0x6c,
	0x6f, 0x76, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x4d, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x18,
	0x0a, 0x07, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x07, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x39, 0x0a, 0x23, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x50, 0x72, 0x69, 0x6f, 0x72,
	0x69, 0x74, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12,
	0x12, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4d,
	0x6f, 0x64, 0x65, 0x22, 0xcf, 0x01, 0x0a, 0x1d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x24, 0x0a, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53, 0x75, 0x62, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x53,
	0x75, 0x62, 0x73, 0x65, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x12, 0x12, 0x0a, 0x04, 0x50, 0x65, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x50, 0x65, 0x65, 0x72, 0x22, 0xc7, 0x02, 0x0a, 0x0c, 0x4c, 0x6f, 0x61, 0x64, 0x42, 0x61,
	0x6c, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5d,
	0x0a, 0x0e, 0x52, 0x69, 0x6e, 0x67, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52,
	0x69, 0x6e, 0x67, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x52,
	0x69, 0x6e, 0x67, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a,
	0x12, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x55, 0x0a, 0x0c, 0x48, 0x61, 0x73, 0x68,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x0c, 0x48, 0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x22,
	0x64, 0x0a, 0x0e, 0x52, 0x69, 0x6e, 0x67, 0x48, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x28, 0x0a, 0x0f, 0x4d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x52, 0x69, 0x6e, 0x67,
	0x53, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x4d, 0x69, 0x6e, 0x69,
	0x6d, 0x75, 0x6d, 0x52, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x4d,
	0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x52, 0x69, 0x6e, 0x67, 0x53, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x0f, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x52, 0x69, 0x6e,
	0x67, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x36, 0x0a, 0x12, 0x4c, 0x65, 0x61, 0x73, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20, 0x0a, 0x0b, 0x43,
	0x68, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0b, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xd3, 0x01,
	0x0a, 0x0a, 0x48, 0x61, 0x73, 0x68, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x1e, 0x0a, 0x0a, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x43,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x50, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x50, 0x12, 0x1a, 0x0a, 0x08, 0x54, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x61, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x54, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x61, 0x6c, 0x22, 0x69, 0x0a, 0x0c, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a,
	0x03, 0x54, 0x54, 0x4c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x03, 0x54, 0x54, 0x4c, 0x12, 0x12, 0x0a, 0x04, 0x50, 0x61,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x50, 0x61, 0x74, 0x68, 0x22, 0xac,
	0x03, 0x0a, 0x0e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x12, 0x49, 0x0a, 0x03, 0x54, 0x4c, 0x53, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x4c,
	0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x54, 0x4c, 0x53, 0x12, 0x54, 0x0a, 0x09,
	0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x4c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x52, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65,
	0x72, 0x73, 0x12, 0x53, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x57, 0x0a, 0x08, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04,
	0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x8f, 0x02,
	0x0a, 0x14, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0e, 0x4d, 0x61, 0x78, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e,
	0x4d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e,
	0x0a, 0x12, 0x4d, 0x61, 0x78, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12, 0x4d, 0x61, 0x78, 0x50,
	0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x34,
	0x0a, 0x15, 0x4d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x15, 0x4d,
	0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x12, 0x69, 0x0a, 0x12, 0x50, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65,
	0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x12, 0x50, 0x61, 0x73,
	0x73, 0x69, 0x76, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x22,
	0xea, 0x01, 0x0a, 0x10, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x4c, 0x53, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4c,
	0x0a, 0x03, 0x53, 0x44, 0x53, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x4c, 0x53, 0x53, 0x44,
	0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x53, 0x44, 0x53, 0x12, 0x24, 0x0a, 0x0d,
	0x54, 0x4c, 0x53, 0x4d, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x54, 0x4c, 0x53, 0x4d, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0d, 0x54, 0x4c, 0x53, 0x4d, 0x61, 0x78, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x54, 0x4c, 0x53, 0x4d, 0x61,
	0x78, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0c, 0x43, 0x69, 0x70, 0x68,
	0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x73, 0x22, 0x5b, 0x0a, 0x13,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x4c, 0x53, 0x53, 0x44, 0x53, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x20, 0x0a, 0x0b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x43, 0x65, 0x72, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x43, 0x65, 0x72,
	0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xdf, 0x01, 0x0a, 0x0f, 0x49, 0x6e,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a,
	0x04, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x50, 0x6f, 0x72,
	0x74, 0x12, 0x1a, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x51, 0x0a,
	0x08, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x49, 0x0a, 0x03, 0x54, 0x4c, 0x53, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x4c, 0x53,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x54, 0x4c, 0x53, 0x22, 0xb7, 0x06, 0x0a, 0x0e,
	0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x48, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x05, 0x48, 0x6f, 0x73, 0x74, 0x73, 0x12, 0x50, 0x0a, 0x03, 0x54, 0x4c, 0x53, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x4c, 0x53, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x54, 0x4c, 0x53, 0x12, 0x62, 0x0a, 0x0e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x52, 0x0e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x64,
	0x0a, 0x0f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e,
	0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x73, 0x52, 0x0f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x12, 0x53, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x58, 0x0a, 0x0e, 0x45, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x52, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x12, 0x26, 0x0a, 0x0e, 0x4d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0e, 0x4d, 0x61, 0x78,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x12, 0x4d,
	0x61, 0x78, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x12, 0x4d, 0x61, 0x78, 0x50, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x15, 0x4d,
	0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x15, 0x4d, 0x61, 0x78, 0x43,
	0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x12, 0x69, 0x0a, 0x12, 0x50, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x12, 0x50, 0x61, 0x73, 0x73, 0x69, 0x76,
	0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x1a, 0x37, 0x0a, 0x09,
	0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x67, 0x0a, 0x17, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x4c, 0x0a, 0x03, 0x53, 0x44, 0x53, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x4c, 0x53,
	0x53, 0x44, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x53, 0x44, 0x53, 0x22, 0xcb,
	0x02, 0x0a, 0x13, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x12, 0x55, 0x0a, 0x03, 0x41, 0x64, 0x64, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e,
	0x41, 0x64, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x03, 0x41, 0x64, 0x64, 0x12, 0x55, 0x0a,
	0x03, 0x53, 0x65, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x2e, 0x53, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x03, 0x53, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x1a, 0x36, 0x0a, 0x08,
	0x41, 0x64, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x36, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xdc, 0x02, 0x0a,
	0x11, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x50, 0x0a, 0x07, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x50, 0x0a, 0x03,
	0x4a, 0x57, 0x54, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x57, 0x54, 0x52, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x03, 0x4a, 0x57, 0x54, 0x12, 0x12,
	0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x48, 0x61,
	0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x74, 0x0a, 0x17, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x57, 0x54, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x57, 0x54, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x09, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72,
	0x73, 0x22, 0x94, 0x01, 0x0a, 0x14, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x57, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x68,
	0x0a, 0x0c, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x57, 0x54, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x22, 0x49, 0x0a, 0x1d, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x57, 0x54, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x56, 0x65, 0x72,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x50, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x50, 0x61, 0x74, 0x68, 0x12, 0x14, 0x0a,
	0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0xcc, 0x06, 0x0a, 0x0f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x06, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c, 0x0a, 0x0b, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x50, 0x72, 0x65,
	0x63, 0x65, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x50,
	0x72, 0x65, 0x63, 0x65, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x4c, 0x65, 0x67,
	0x61, 0x63, 0x79, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x4c, 0x65, 0x67,
	0x61, 0x63, 0x79, 0x49, 0x44, 0x12, 0x4e, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x0a, 0x4c, 0x65, 0x67, 0x61, 0x63,
	0x79, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0a, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74, 0x61, 0x12,
	0x46, 0x0a, 0x10, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x10, 0x4c, 0x65, 0x67, 0x61, 0x63,
	0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x4c,
	0x65, 0x67, 0x61, 0x63, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x58, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x50, 0x65, 0x65,
	0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x50, 0x65, 0x65, 0x72, 0x12, 0x24, 0x0a,
	0x0d, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x1a, 0x3d, 0x0a, 0x0f, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x4d, 0x65, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x8b, 0x02, 0x0a, 0x13, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x06, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x04, 0x48, 0x54,
	0x54, 0x50, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x54, 0x54, 0x50, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x48, 0x54, 0x54, 0x50, 0x12, 0x50,
	0x0a, 0x03, 0x4a, 0x57, 0x54, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x57, 0x54,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x03, 0x4a, 0x57, 0x54,
	0x22, 0xed, 0x01, 0x0a, 0x17, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x54,
	0x54, 0x50, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09,
	0x50, 0x61, 0x74, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x50, 0x61, 0x74, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x50, 0x61,
	0x74, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x50, 0x61, 0x74, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61,
	0x74, 0x68, 0x52, 0x65, 0x67, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50,
	0x61, 0x74, 0x68, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x5c, 0x0a, 0x06, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73,
	0x22, 0xc1, 0x01, 0x0a, 0x1d, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x54,
	0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x45, 0x78, 0x61, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x45, 0x78, 0x61, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x16,
	0x0a, 0x06, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x12, 0x14, 0x0a, 0x05, 0x52, 0x65, 0x67, 0x65, 0x78, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x16, 0x0a, 0x06,
	0x49, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x49, 0x6e,
	0x76, 0x65, 0x72, 0x74, 0x22, 0xf9, 0x09, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x44, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x50, 0x72, 0x6f, 0x78, 0x79,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x69, 0x0a, 0x10, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x10, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x78, 0x79, 0x12, 0x5a, 0x0a, 0x0b, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x12, 0x4b, 0x0a, 0x06, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x4e, 0x49, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x53, 0x4e, 0x49,
	0x12, 0x64, 0x0a, 0x0e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5a, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x15, 0x4d, 0x61, 0x78, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x15, 0x4d, 0x61, 0x78, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x34, 0x0a, 0x15, 0x4c, 0x6f, 0x63, 0x61,
	0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d,
	0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x73, 0x12, 0x34,
	0x0a, 0x15, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x4d, 0x73, 0x12, 0x3c, 0x0a, 0x19, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x19, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65,
	0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x51, 0x0a, 0x0a, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52,
	0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0a, 0x52, 0x61, 0x74, 0x65, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x54, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x0d, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x5a, 0x0a, 0x0f, 0x45,
	0x6e, 0x76, 0x6f, 0x79, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x76, 0x6f, 0x79, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x45, 0x6e, 0x76, 0x6f, 0x79, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x0d, 0x4d, 0x75, 0x74, 0x75, 0x61,
	0x6c, 0x54, 0x4c, 0x53, 0x4d, 0x6f, 0x64, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4d, 0x75, 0x74, 0x75, 0x61, 0x6c, 0x54, 0x4c, 0x53,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0d, 0x4d, 0x75, 0x74, 0x75, 0x61, 0x6c, 0x54, 0x4c, 0x53, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x04, 0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x74, 0x0a, 0x16, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x50,
	0x72, 0x6f, 0x78, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x32, 0x0a, 0x14, 0x4f, 0x75,
	0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x50, 0x6f,
	0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x26,
	0x0a, 0x0e, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x64, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6c, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x64, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6c, 0x79, 0x22, 0x5f, 0x0a, 0x11, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4a, 0x0a, 0x04, 0x4d,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4d, 0x6f, 0x64,
	0x65, 0x52, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x22, 0x6f, 0x0a, 0x0c, 0x45, 0x78, 0x70, 0x6f, 0x73,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x12,
	0x47, 0x0a, 0x05, 0x50, 0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x50, 0x61, 0x74,
	0x68, 0x52, 0x05, 0x50, 0x61, 0x74, 0x68, 0x73, 0x22, 0xb0, 0x01, 0x0a, 0x0a, 0x45, 0x78, 0x70,
	0x6f, 0x73, 0x65, 0x50, 0x61, 0x74, 0x68, 0x12, 0x22, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x4c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x50,
	0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x24, 0x0a, 0x0d, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x50, 0x6f, 0x72, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x50, 0x61, 0x74,
	0x68, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x12, 0x28, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x73, 0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x50, 0x61, 0x72, 0x73,
	0x65, 0x64, 0x46, 0x72, 0x6f, 0x6d, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x22, 0xbf, 0x01, 0x0a, 0x15,
	0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x09, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x09, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x08, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x08, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x8a, 0x05,
	0x0a, 0x0e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x0e,
	0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x2c,
	0x0a, 0x11, 0x45, 0x6e, 0x76, 0x6f, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x4a,
	0x53, 0x4f, 0x4e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x45, 0x6e, 0x76, 0x6f, 0x79,
	0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x4a, 0x53, 0x4f, 0x4e, 0x12, 0x2a, 0x0a, 0x10,
	0x45, 0x6e, 0x76, 0x6f, 0x79, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4a, 0x53, 0x4f, 0x4e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x45, 0x6e, 0x76, 0x6f, 0x79, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x4a, 0x53, 0x4f, 0x4e, 0x12, 0x1a, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x2a, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x73,
	0x12, 0x4d, 0x0a, 0x06, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x55, 0x70, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x06, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12,
	0x69, 0x0a, 0x12, 0x50, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x50, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x12, 0x50, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x48,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x5a, 0x0a, 0x0b, 0x4d, 0x65,
	0x73, 0x68, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x4d, 0x65, 0x73, 0x68, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x3e, 0x0a, 0x1a, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63,
	0x65, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x42, 0x61, 0x6c, 0x61,
	0x6e, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x50, 0x65, 0x65, 0x72, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x50, 0x65, 0x65, 0x72, 0x22, 0x9e, 0x01, 0x0a, 0x0e, 0x55,
	0x70, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x26, 0x0a,
	0x0e, 0x4d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x4d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x12, 0x4d, 0x61, 0x78, 0x50, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x12, 0x4d, 0x61, 0x78, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x15, 0x4d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x15, 0x4d, 0x61, 0x78, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x22, 0x9e, 0x02, 0x0a, 0x12,
	0x50, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x12, 0x35, 0x0a, 0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x08, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x20, 0x0a, 0x0b, 0x4d, 0x61, 0x78,
	0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b,
	0x4d, 0x61, 0x78, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x12, 0x38, 0x0a, 0x17, 0x45,
	0x6e, 0x66, 0x6f, 0x72, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x76, 0x65, 0x35, 0x78, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x17, 0x45, 0x6e,
	0x66, 0x6f, 0x72, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x76, 0x65, 0x35, 0x78, 0x78, 0x12, 0x2e, 0x0a, 0x12, 0x4d, 0x61, 0x78, 0x45, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x12, 0x4d, 0x61, 0x78, 0x45, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x10, 0x42, 0x61, 0x73, 0x65, 0x45, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x42, 0x61, 0x73, 0x65,
	0x45, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x45, 0x0a, 0x11,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x1c, 0x0a, 0x09, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x50,
	0x6f, 0x72, 0x74, 0x22, 0x72, 0x0a, 0x0a, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74,
	0x73, 0x12, 0x64, 0x0a, 0x0d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x52, 0x0d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0xd0, 0x01, 0x0a, 0x17, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d,
	0x69, 0x74, 0x73, 0x12, 0x2c, 0x0a, 0x11, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50,
	0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x12, 0x2a, 0x0a, 0x10, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x4d, 0x61, 0x78,
	0x42, 0x75, 0x72, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x4d, 0x61, 0x78, 0x42, 0x75, 0x72, 0x73, 0x74, 0x12, 0x5b, 0x0a,
	0x06, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65,
	0x76, 0x65, 0x6c, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x73, 0x52, 0x06, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x22, 0xd4, 0x01, 0x0a, 0x1c, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x50,
	0x61, 0x74, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x50, 0x61, 0x74, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x50, 0x61, 0x74,
	0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x50,
	0x61, 0x74, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x1c, 0x0a, 0x09, 0x50, 0x61, 0x74,
	0x68, 0x52, 0x65, 0x67, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x50, 0x61,
	0x74, 0x68, 0x52, 0x65, 0x67, 0x65, 0x78, 0x12, 0x2c, 0x0a, 0x11, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x11, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x53,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x12, 0x2a, 0x0a, 0x10, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x4d, 0x61, 0x78, 0x42, 0x75, 0x72, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x10, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x4d, 0x61, 0x78, 0x42, 0x75, 0x72, 0x73,
	0x74, 0x22, 0xca, 0x02, 0x0a, 0x0a, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x12, 0x4f, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74,
	0x61, 0x12, 0x57, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x50, 0x49,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x52,
	0x09, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x45, 0x0a, 0x06, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x04, 0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x5a,
	0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x50, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8b, 0x02, 0x0a, 0x09, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x54, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a, 0x12,
	0x4c, 0x61, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x12, 0x4c, 0x61, 0x73, 0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb4, 0x03, 0x0a, 0x12, 0x41, 0x50, 0x49,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x50, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x50,
	0x6f, 0x72, 0x74, 0x12, 0x5d, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x50,
	0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x12, 0x53, 0x0a, 0x03, 0x54, 0x4c, 0x53, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x03, 0x54, 0x4c, 0x53, 0x12, 0x53, 0x0a, 0x08, 0x4f, 0x76, 0x65, 0x72, 0x72,
	0x69, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x08, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x51, 0x0a, 0x07,
	0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x07, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x22,
	0xde, 0x01, 0x0a, 0x1a, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x54, 0x4c,
	0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c,
	0x0a, 0x0c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0c,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x0a,
	0x4d, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x4d, 0x69, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a,
	0x4d, 0x61, 0x78, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x4d, 0x61, 0x78, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0c,
	0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0c, 0x43, 0x69, 0x70, 0x68, 0x65, 0x72, 0x53, 0x75, 0x69, 0x74, 0x65, 0x73,
	0x22, 0x65, 0x0a, 0x10, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x51, 0x0a, 0x03, 0x4a, 0x57, 0x54, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x4a, 0x57, 0x54, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x03, 0x4a, 0x57, 0x54, 0x22, 0x76, 0x0a, 0x18, 0x41, 0x50, 0x49, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x4a, 0x57, 0x54, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x5a, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41,
	0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4a, 0x57, 0x54, 0x50, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x52, 0x09, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x22,
	0x96, 0x01, 0x0a, 0x15, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4a, 0x57,
	0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x69, 0x0a,
	0x0c, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x50, 0x49, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4a, 0x57, 0x54, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x22, 0x4a, 0x0a, 0x1e, 0x41, 0x50, 0x49, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4a, 0x57, 0x54, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x56, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x50, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x50, 0x61, 0x74, 0x68, 0x12, 0x14,
	0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0xb7, 0x01, 0x0a, 0x11, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x4b, 0x69,
	0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x0e,
	0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x22, 0xf1,
	0x03, 0x0a, 0x0f, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x12, 0x54, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x50,
	0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x5c, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x52, 0x09, 0x4c, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x60, 0x0a, 0x08, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09,
	0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x7b, 0x0a, 0x0d, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x54, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4f, 0x66, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x65, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x66, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x4a, 0x0a,
	0x03, 0x52, 0x65, 0x66, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x03, 0x52, 0x65, 0x66, 0x22, 0xdd, 0x01, 0x0a, 0x17, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4c, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x0c, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x0c, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x50, 0x0a, 0x06, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x52, 0x06, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x22, 0x82, 0x02, 0x0a, 0x15, 0x46, 0x69,
	0x6c, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x12, 0x5a, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x46, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e,
	0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12,
	0x20, 0x0a, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65,
	0x79, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x04, 0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xfa,
	0x01, 0x0a, 0x11, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x20, 0x0a, 0x0b,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x1e,
	0x0a, 0x0a, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x48, 0x61,
	0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xad, 0x03, 0x0a, 0x09,
	0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x4e, 0x0a, 0x04, 0x4d, 0x65, 0x74,
	0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e,
	0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x52, 0x0a, 0x07, 0x50, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x52, 0x07, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4a, 0x0a,
	0x05, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x75,
	0x6c, 0x65, 0x52, 0x05, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x48, 0x6f, 0x73,
	0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x48, 0x6f,
	0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x48, 0x61,
	0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xdf, 0x02, 0x0a, 0x0d,
	0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x4c, 0x0a,
	0x07, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x07, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4a, 0x0a, 0x07, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x07,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x08, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x08, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0f, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x22, 0xc4, 0x02,
	0x0a, 0x09, 0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x50, 0x0a, 0x07, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x4e, 0x0a,
	0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x48, 0x0a,
	0x04, 0x50, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x52, 0x04, 0x50, 0x61, 0x74, 0x68, 0x12, 0x4b, 0x0a, 0x05, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48,
	0x54, 0x54, 0x50, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x05, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x22, 0x8d, 0x01, 0x0a, 0x0f, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x50, 0x0a, 0x05, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e,
	0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x05, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x75, 0x0a, 0x0d, 0x48, 0x54, 0x54, 0x50, 0x50, 0x61, 0x74, 0x68,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x4e, 0x0a, 0x05, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54,
	0x50, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x14, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x8b, 0x01, 0x0a, 0x0e,
	0x48, 0x54, 0x54, 0x50, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x4f,
	0x0a, 0x05, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x05, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xa9, 0x03, 0x0a, 0x0b, 0x48, 0x54,
	0x54, 0x50, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x07, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x07, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x0a,
	0x55, 0x52, 0x4c, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x77, 0x72,
	0x69, 0x74, 0x65, 0x52, 0x0a, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12,
	0x54, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x74,
	0x72, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x0d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x0d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x42, 0x0a, 0x03, 0x4a, 0x57, 0x54, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x54, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x52, 0x03, 0x4a, 0x57, 0x54, 0x22, 0x68, 0x0a, 0x13, 0x48, 0x54, 0x54, 0x50, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x51, 0x0a, 0x07,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x07, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x22,
	0x20, 0x0a, 0x0a, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x50, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x50, 0x61, 0x74,
	0x68, 0x22, 0xad, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x4e, 0x75, 0x6d, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x4e, 0x75, 0x6d, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x18, 0x0a, 0x07, 0x52, 0x65, 0x74, 0x72, 0x79, 0x4f, 0x6e, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x07, 0x52, 0x65, 0x74, 0x72, 0x79, 0x4f, 0x6e, 0x12, 0x2e, 0x0a, 0x12, 0x52,
	0x65, 0x74, 0x72, 0x79, 0x4f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x12, 0x52, 0x65, 0x74, 0x72, 0x79, 0x4f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x15, 0x52,
	0x65, 0x74, 0x72, 0x79, 0x4f, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x46, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x52, 0x65, 0x74, 0x72,
	0x79, 0x4f, 0x6e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x22, 0x8f, 0x01, 0x0a, 0x0d, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x41, 0x0a, 0x0e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x49, 0x64, 0x6c, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x49, 0x64, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x22, 0x67, 0x0a, 0x09, 0x4a, 0x57, 0x54, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x5a, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x50, 0x49, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4a, 0x57, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x52, 0x09, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x22, 0xc2, 0x02, 0x0a,
	0x10, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x52, 0x0a, 0x03, 0x41, 0x64, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x41, 0x64, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x03, 0x41, 0x64, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x12, 0x52, 0x0a,
	0x03, 0x53, 0x65, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x03, 0x53, 0x65,
	0x74, 0x1a, 0x36, 0x0a, 0x08, 0x41, 0x64, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x36, 0x0a, 0x08, 0x53, 0x65, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xc7, 0x02, 0x0a, 0x0b, 0x48, 0x54, 0x54, 0x50, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x4c, 0x0a,
	0x07, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x52, 0x07, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x58, 0x0a, 0x0e, 0x45,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x48, 0x54, 0x54, 0x50, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0f, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x22, 0x90, 0x03, 0x0a, 0x08,
	0x54, 0x43, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x4d, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x54,
	0x43, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x52, 0x0a, 0x07, 0x50, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x52, 0x07, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x08, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x54, 0x43, 0x50, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x08, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x06, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x04, 0x52,
	0x04, 0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7a,
	0x0a, 0x0a, 0x54, 0x43, 0x50, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x58, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x0e, 0x45, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x22, 0xc8, 0x03, 0x0a, 0x0d, 0x53,
	0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x12, 0x0a, 0x04,
	0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x2e, 0x0a, 0x12, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x46, 0x6f, 0x72, 0x46, 0x61,
	0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x44, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x46, 0x6f, 0x72, 0x46, 0x61, 0x69, 0x6c, 0x6f, 0x76, 0x65, 0x72,
	0x12, 0x22, 0x0a, 0x0c, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4c,
	0x6f, 0x63, 0x61, 0x6c, 0x12, 0x54, 0x0a, 0x07, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x61,
	0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x52, 0x07, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x52, 0x0a, 0x04, 0x4d, 0x65,
	0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x58,
	0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x52, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09,
	0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x47, 0x0a, 0x13, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73,
	0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x50, 0x65,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x50, 0x65, 0x65, 0x72, 0x22, 0xf1,
	0x04, 0x0a, 0x0b, 0x4a, 0x57, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x5a,
	0x0a, 0x0d, 0x4a, 0x53, 0x4f, 0x4e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x53,
	0x4f, 0x4e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x52, 0x0d, 0x4a, 0x53, 0x4f,
	0x4e, 0x57, 0x65, 0x62, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x49, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x41, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x50, 0x0a, 0x09, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x54, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x0a, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a,
	0x57, 0x54, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0a, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x57,
	0x0a, 0x0b, 0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x54, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x43, 0x61, 0x63, 0x68,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57,
	0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x2a, 0x0a, 0x10, 0x43, 0x6c, 0x6f,
	0x63, 0x6b, 0x53, 0x6b, 0x65, 0x77, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x10, 0x43, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x6b, 0x65, 0x77, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73, 0x68, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x04, 0x52, 0x04, 0x48, 0x61, 0x73, 0x68, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xa2, 0x01, 0x0a, 0x0d, 0x4a, 0x53, 0x4f, 0x4e, 0x57, 0x65, 0x62, 0x4b, 0x65,
	0x79, 0x53, 0x65, 0x74, 0x12, 0x46, 0x0a, 0x05, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4c, 0x6f, 0x63, 0x61,
	0x6c, 0x4a, 0x57, 0x4b, 0x53, 0x52, 0x05, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x12, 0x49, 0x0a, 0x06,
	0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4a, 0x57, 0x4b, 0x53, 0x52,
	0x06, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x22, 0x3b, 0x0a, 0x09, 0x4c, 0x6f, 0x63, 0x61, 0x6c,
	0x4a, 0x57, 0x4b, 0x53, 0x12, 0x12, 0x0a, 0x04, 0x4a, 0x57, 0x4b, 0x53, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x4a, 0x57, 0x4b, 0x53, 0x12, 0x1a, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x46, 0x69, 0x6c, 0x65,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xed, 0x02, 0x0a, 0x0a, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x4a,
	0x57, 0x4b, 0x53, 0x12, 0x10, 0x0a, 0x03, 0x55, 0x52, 0x49, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x55, 0x52, 0x49, 0x12, 0x2a, 0x0a, 0x10, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x10, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x4d,
	0x73, 0x12, 0x3f, 0x0a, 0x0d, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x30, 0x0a, 0x13, 0x46, 0x65, 0x74, 0x63, 0x68, 0x41, 0x73, 0x79, 0x6e, 0x63,
	0x68, 0x72, 0x6f, 0x6e, 0x6f, 0x75, 0x73, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x13, 0x46, 0x65, 0x74, 0x63, 0x68, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x6f,
	0x75, 0x73, 0x6c, 0x79, 0x12, 0x58, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x4a, 0x57, 0x4b, 0x53, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x54,
	0x0a, 0x0b, 0x4a, 0x57, 0x4b, 0x53, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x4b, 0x53,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x0b, 0x4a, 0x57, 0x4b, 0x53, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x22, 0xdb, 0x01, 0x0a, 0x0b, 0x4a, 0x57, 0x4b, 0x53, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0d, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x63, 0x0a, 0x0f, 0x54, 0x4c,
	0x53, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x4b, 0x53,
	0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x0f,
	0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x12,
	0x41, 0x0a, 0x0e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f,
	0x75, 0x74, 0x22, 0xfa, 0x01, 0x0a, 0x12, 0x4a, 0x57, 0x4b, 0x53, 0x54, 0x4c, 0x53, 0x43, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x88, 0x01, 0x0a, 0x1d, 0x43, 0x61,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x4b, 0x53, 0x54, 0x4c,
	0x53, 0x43, 0x65, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x1d, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x59, 0x0a, 0x09, 0x54, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x43,
	0x41, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e,
	0x4a, 0x57, 0x4b, 0x53, 0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74, 0x54, 0x72, 0x75, 0x73, 0x74,
	0x65, 0x64, 0x43, 0x41, 0x52, 0x09, 0x54, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x43, 0x41, 0x22,
	0x6b, 0x0a, 0x1b, 0x4a, 0x57, 0x4b, 0x53, 0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x22,
	0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xaa, 0x01, 0x0a,
	0x14, 0x4a, 0x57, 0x4b, 0x53, 0x54, 0x4c, 0x53, 0x43, 0x65, 0x72, 0x74, 0x54, 0x72, 0x75, 0x73,
	0x74, 0x65, 0x64, 0x43, 0x41, 0x12, 0x1a, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x30, 0x0a, 0x13, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13,
	0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x49, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x20, 0x0a, 0x0b, 0x49, 0x6e, 0x6c, 0x69, 0x6e,
	0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x49, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x9c, 0x01, 0x0a, 0x0f, 0x4a, 0x57,
	0x4b, 0x53, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1e, 0x0a,
	0x0a, 0x4e, 0x75, 0x6d, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0a, 0x4e, 0x75, 0x6d, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x69, 0x0a,
	0x12, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x63, 0x6b,
	0x4f, 0x66, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68,
	0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x63,
	0x6b, 0x4f, 0x66, 0x66, 0x52, 0x12, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x61, 0x63, 0x6b, 0x4f, 0x66, 0x66, 0x22, 0x90, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x74,
	0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x61, 0x63, 0x6b, 0x4f, 0x66, 0x66, 0x12,
	0x3d, 0x0a, 0x0c, 0x42, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x42, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x3b,
	0x0a, 0x0b, 0x4d, 0x61, 0x78, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x4d, 0x61, 0x78, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0x8f, 0x02, 0x0a, 0x0b,
	0x4a, 0x57, 0x54, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x06, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x54, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x5c, 0x0a,
	0x0a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x54, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x52,
	0x0a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x12, 0x50, 0x0a, 0x06, 0x43,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x2e, 0x4a, 0x57, 0x54, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x52, 0x06, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x22, 0x63, 0x0a,
	0x11, 0x4a, 0x57, 0x54, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x18, 0x0a, 0x07, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x46, 0x6f, 0x72, 0x77, 0x61,
	0x72, 0x64, 0x22, 0x2b, 0x0a, 0x15, 0x4a, 0x57, 0x54, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x12, 0x12, 0x0a, 0x04, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0x27, 0x0a, 0x11, 0x4a, 0x57, 0x54, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6f, 0x6b, 0x69, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x6f, 0x0a, 0x13, 0x4a, 0x57, 0x54, 0x46,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x1e, 0x0a, 0x0a, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x38, 0x0a, 0x17, 0x50, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x50, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x17, 0x50, 0x61, 0x64, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x50, 0x61, 0x79, 0x6c,
	0x6f, 0x61, 0x64, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x24, 0x0a, 0x0e, 0x4a, 0x57, 0x54,
	0x43, 0x61, 0x63, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x53,
	0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0x80, 0x03, 0x0a, 0x10, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0e, 0x45, 0x6e, 0x74, 0x65,
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x52, 0x0e, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x12, 0x55, 0x0a, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x04, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x48, 0x61, 0x73,
	0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x48, 0x61, 0x73, 0x68, 0x12, 0x5a, 0x0a,
	0x08, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x08, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x37, 0x0a, 0x09, 0x4d, 0x65, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xaa, 0x01, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x5d, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x73,
	0x75, 0x6d, 0x65, 0x72, 0x52, 0x09, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x73, 0x22,
	0x72, 0x0a, 0x18, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x50, 0x65, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x50, 0x65, 0x65, 0x72, 0x12, 0x24, 0x0a,
	0x0d, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x53, 0x61, 0x6d, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x2a, 0xe2, 0x02, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x0f, 0x0a, 0x0b,
	0x4b, 0x69, 0x6e, 0x64, 0x55, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x10, 0x00, 0x12, 0x12, 0x0a,
	0x0e, 0x4b, 0x69, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x10,
	0x01, 0x12, 0x17, 0x0a, 0x13, 0x4b, 0x69, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x4b, 0x69,
	0x6e, 0x64, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x4b, 0x69, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x10, 0x04, 0x12, 0x17, 0x0a,
	0x13, 0x4b, 0x69, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x73, 0x10, 0x05, 0x12, 0x19, 0x0a, 0x15, 0x4b, 0x69, 0x6e, 0x64, 0x49, 0x6e,
	0x6c, 0x69, 0x6e, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x10,
	0x06, 0x12, 0x12, 0x0a, 0x0e, 0x4b, 0x69, 0x6e, 0x64, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x10, 0x07, 0x12, 0x17, 0x0a, 0x13, 0x4b, 0x69, 0x6e, 0x64, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x10, 0x08, 0x12, 0x11,
	0x0a, 0x0d, 0x4b, 0x69, 0x6e, 0x64, 0x48, 0x54, 0x54, 0x50, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x10,
	0x09, 0x12, 0x10, 0x0a, 0x0c, 0x4b, 0x69, 0x6e, 0x64, 0x54, 0x43, 0x50, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x10, 0x0a, 0x12, 0x15, 0x0a, 0x11, 0x4b, 0x69, 0x6e, 0x64, 0x53, 0x61, 0x6d, 0x65, 0x6e,
	0x65, 0x73, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x10, 0x0b, 0x12, 0x13, 0x0a, 0x0f, 0x4b, 0x69,
	0x6e, 0x64, 0x4a, 0x57, 0x54, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x10, 0x0c, 0x12,
	0x18, 0x0a, 0x14, 0x4b, 0x69, 0x6e, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x10, 0x0d, 0x12, 0x1d, 0x0a, 0x19, 0x4b, 0x69, 0x6e,
	0x64, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x10, 0x0e, 0x2a, 0x26, 0x0a, 0x0f, 0x49, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x08, 0x0a, 0x04, 0x44,
	0x65, 0x6e, 0x79, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x10, 0x01,
	0x2a, 0x21, 0x0a, 0x13, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x10, 0x00, 0x2a, 0x50, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d,
	0x6f, 0x64, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x10, 0x02, 0x2a, 0x5f, 0x0a, 0x0d, 0x4d, 0x75, 0x74, 0x75, 0x61, 0x6c, 0x54,
	0x4c, 0x53, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4d, 0x75, 0x74, 0x75, 0x61, 0x6c,
	0x54, 0x4c, 0x53, 0x4d, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x10, 0x00,
	0x12, 0x17, 0x0a, 0x13, 0x4d, 0x75, 0x74, 0x75, 0x61, 0x6c, 0x54, 0x4c, 0x53, 0x4d, 0x6f, 0x64,
	0x65, 0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x75, 0x74,
	0x75, 0x61, 0x6c, 0x54, 0x4c, 0x53, 0x4d, 0x6f, 0x64, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x76, 0x65, 0x10, 0x02, 0x2a, 0x7b, 0x0a, 0x0f, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x65, 0x73,
	0x68, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x4e, 0x6f, 0x6e, 0x65, 0x10, 0x01, 0x12, 0x18,
	0x0a, 0x14, 0x4d, 0x65, 0x73, 0x68, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4d, 0x6f, 0x64,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x65, 0x73, 0x68,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x65, 0x6d, 0x6f, 0x74,
	0x65, 0x10, 0x03, 0x2a, 0x4f, 0x0a, 0x1a, 0x41, 0x50, 0x49, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f,
	0x6c, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x48, 0x54, 0x54, 0x50, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x4c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x54,
	0x43, 0x50, 0x10, 0x01, 0x2a, 0x92, 0x02, 0x0a, 0x0f, 0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x12, 0x48, 0x54, 0x54, 0x50,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x41, 0x6c, 0x6c, 0x10, 0x00,
	0x12, 0x1a, 0x0a, 0x16, 0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15,
	0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x48, 0x54, 0x54, 0x50, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x47, 0x65, 0x74, 0x10, 0x03, 0x12,
	0x17, 0x0a, 0x13, 0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x48, 0x65, 0x61, 0x64, 0x10, 0x04, 0x12, 0x1a, 0x0a, 0x16, 0x48, 0x54, 0x54, 0x50,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x10, 0x05, 0x12, 0x18, 0x0a, 0x14, 0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x50, 0x61, 0x74, 0x63, 0x68, 0x10, 0x06, 0x12, 0x17,
	0x0a, 0x13, 0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x50, 0x6f, 0x73, 0x74, 0x10, 0x07, 0x12, 0x16, 0x0a, 0x12, 0x48, 0x54, 0x54, 0x50, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x50, 0x75, 0x74, 0x10, 0x08, 0x12,
	0x18, 0x0a, 0x14, 0x48, 0x54, 0x54, 0x50, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x54, 0x72, 0x61, 0x63, 0x65, 0x10, 0x09, 0x2a, 0xa7, 0x01, 0x0a, 0x13, 0x48, 0x54,
	0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x18, 0x0a, 0x14, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x48,
	0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
	0x10, 0x02, 0x12, 0x24, 0x0a, 0x20, 0x48, 0x54, 0x54, 0x50, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x45, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x48, 0x54, 0x54, 0x50,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x75, 0x66, 0x66, 0x69,
	0x78, 0x10, 0x04, 0x2a, 0x68, 0x0a, 0x11, 0x48, 0x54, 0x54, 0x50, 0x50, 0x61, 0x74, 0x68, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x48, 0x54, 0x54, 0x50,
	0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x10, 0x00,
	0x12, 0x17, 0x0a, 0x13, 0x48, 0x54, 0x54, 0x50, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x48, 0x54, 0x54,
	0x50, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61,
	0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x10, 0x03, 0x2a, 0x6d, 0x0a,
	0x12, 0x48, 0x54, 0x54, 0x50, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x13, 0x48, 0x54, 0x54, 0x50, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x45, 0x78, 0x61, 0x63, 0x74, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15,
	0x48, 0x54, 0x54, 0x50, 0x51, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72,
	0x65, 0x73, 0x65, 0x6e, 0x74, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x54, 0x54, 0x50, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72,
	0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x10, 0x03, 0x32, 0xd5, 0x01, 0x0a,
	0x12, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xbe, 0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x6c,
	0x76, 0x65, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x12, 0x49, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4a,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76,
	0x65, 0x64, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x08, 0xe2, 0x86, 0x04, 0x04,
	0x08, 0x02, 0x10, 0x0c, 0x42, 0xae, 0x02, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x10, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x2f, 0x70, 0x62, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0xa2,
	0x02, 0x04, 0x48, 0x43, 0x49, 0x43, 0xaa, 0x02, 0x25, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0xca, 0x02,
	0x25, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x5c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0xe2, 0x02, 0x31, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5c, 0x47,
	0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x28, 0x48, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x3a, 0x3a,
	0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_private_pbconfigentry_config_entry_proto_rawDescOnce sync.Once
	file_private_pbconfigentry_config_entry_proto_rawDescData = file_private_pbconfigentry_config_entry_proto_rawDesc
)

func file_private_pbconfigentry_config_entry_proto_rawDescGZIP() []byte {
	file_private_pbconfigentry_config_entry_proto_rawDescOnce.Do(func() {
		file_private_pbconfigentry_config_entry_proto_rawDescData = protoimpl.X.CompressGZIP(file_private_pbconfigentry_config_entry_proto_rawDescData)
	})
	return file_private_pbconfigentry_config_entry_proto_rawDescData
}

var file_private_pbconfigentry_config_entry_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_private_pbconfigentry_config_entry_proto_msgTypes = make([]protoimpl.MessageInfo, 127)
var file_private_pbconfigentry_config_entry_proto_goTypes = []interface{}{
	(Kind)(0),                                   // 0: hashicorp.consul.internal.configentry.Kind
	(IntentionAction)(0),                        // 1: hashicorp.consul.internal.configentry.IntentionAction
	(IntentionSourceType)(0),                    // 2: hashicorp.consul.internal.configentry.IntentionSourceType
	(ProxyMode)(0),                              // 3: hashicorp.consul.internal.configentry.ProxyMode
	(MutualTLSMode)(0),                          // 4: hashicorp.consul.internal.configentry.MutualTLSMode
	(MeshGatewayMode)(0),                        // 5: hashicorp.consul.internal.configentry.MeshGatewayMode
	(APIGatewayListenerProtocol)(0),             // 6: hashicorp.consul.internal.configentry.APIGatewayListenerProtocol
	(HTTPMatchMethod)(0),                        // 7: hashicorp.consul.internal.configentry.HTTPMatchMethod
	(HTTPHeaderMatchType)(0),                    // 8: hashicorp.consul.internal.configentry.HTTPHeaderMatchType
	(HTTPPathMatchType)(0),                      // 9: hashicorp.consul.internal.configentry.HTTPPathMatchType
	(HTTPQueryMatchType)(0),                     // 10: hashicorp.consul.internal.configentry.HTTPQueryMatchType
	(*GetResolvedExportedServicesRequest)(nil),  // 11: hashicorp.consul.internal.configentry.GetResolvedExportedServicesRequest
	(*GetResolvedExportedServicesResponse)(nil), // 12: hashicorp.consul.internal.configentry.GetResolvedExportedServicesResponse
	(*ResolvedExportedService)(nil),             // 13: hashicorp.consul.internal.configentry.ResolvedExportedService
	(*Consumers)(nil),                           // 14: hashicorp.consul.internal.configentry.Consumers
	(*ConfigEntry)(nil),                         // 15: hashicorp.consul.internal.configentry.ConfigEntry
	(*MeshConfig)(nil),                          // 16: hashicorp.consul.internal.configentry.MeshConfig
	(*TransparentProxyMeshConfig)(nil),          // 17: hashicorp.consul.internal.configentry.TransparentProxyMeshConfig
	(*MeshTLSConfig)(nil),                       // 18: hashicorp.consul.internal.configentry.MeshTLSConfig
	(*MeshDirectionalTLSConfig)(nil),            // 19: hashicorp.consul.internal.configentry.MeshDirectionalTLSConfig
	(*MeshHTTPConfig)(nil),                      // 20: hashicorp.consul.internal.configentry.MeshHTTPConfig
	(*PeeringMeshConfig)(nil),                   // 21: hashicorp.consul.internal.configentry.PeeringMeshConfig
	(*ServiceResolver)(nil),                     // 22: hashicorp.consul.internal.configentry.ServiceResolver
	(*ServiceResolverSubset)(nil),               // 23: hashicorp.consul.internal.configentry.ServiceResolverSubset
	(*ServiceResolverRedirect)(nil),             // 24: hashicorp.consul.internal.configentry.ServiceResolverRedirect
	(*ServiceResolverFailover)(nil),             // 25: hashicorp.consul.internal.configentry.ServiceResolverFailover
	(*ServiceResolverFailoverPolicy)(nil),       // 26: hashicorp.consul.internal.configentry.ServiceResolverFailoverPolicy
	(*ServiceResolverPrioritizeByLocality)(nil), // 27: hashicorp.consul.internal.configentry.ServiceResolverPrioritizeByLocality
	(*ServiceResolverFailoverTarget)(nil),       // 28: hashicorp.consul.internal.configentry.ServiceResolverFailoverTarget
	(*LoadBalancer)(nil),                        // 29: hashicorp.consul.internal.configentry.LoadBalancer
	(*RingHashConfig)(nil),                      // 30: hashicorp.consul.internal.configentry.RingHashConfig
	(*LeastRequestConfig)(nil),                  // 31: hashicorp.consul.internal.configentry.LeastRequestConfig
	(*HashPolicy)(nil),                          // 32: hashicorp.consul.internal.configentry.HashPolicy
	(*CookieConfig)(nil),                        // 33: hashicorp.consul.internal.configentry.CookieConfig
	(*IngressGateway)(nil),                      // 34: hashicorp.consul.internal.configentry.IngressGateway
	(*IngressServiceConfig)(nil),                // 35: hashicorp.consul.internal.configentry.IngressServiceConfig
	(*GatewayTLSConfig)(nil),                    // 36: hashicorp.consul.internal.configentry.GatewayTLSConfig
	(*GatewayTLSSDSConfig)(nil),                 // 37: hashicorp.consul.internal.configentry.GatewayTLSSDSConfig
	(*IngressListener)(nil),                     // 38: hashicorp.consul.internal.configentry.IngressListener
	(*IngressService)(nil),                      // 39: hashicorp.consul.internal.configentry.IngressService
	(*GatewayServiceTLSConfig)(nil),             // 40: hashicorp.consul.internal.configentry.GatewayServiceTLSConfig
	(*HTTPHeaderModifiers)(nil),                 // 41: hashicorp.consul.internal.configentry.HTTPHeaderModifiers
	(*ServiceIntentions)(nil),                   // 42: hashicorp.consul.internal.configentry.ServiceIntentions
	(*IntentionJWTRequirement)(nil),             // 43: hashicorp.consul.internal.configentry.IntentionJWTRequirement
	(*IntentionJWTProvider)(nil),                // 44: hashicorp.consul.internal.configentry.IntentionJWTProvider
	(*IntentionJWTClaimVerification)(nil),       // 45: hashicorp.consul.internal.configentry.IntentionJWTClaimVerification
	(*SourceIntention)(nil),                     // 46: hashicorp.consul.internal.configentry.SourceIntention
	(*IntentionPermission)(nil),                 // 47: hashicorp.consul.internal.configentry.IntentionPermission
	(*IntentionHTTPPermission)(nil),             // 48: hashicorp.consul.internal.configentry.IntentionHTTPPermission
	(*IntentionHTTPHeaderPermission)(nil),       // 49: hashicorp.consul.internal.configentry.IntentionHTTPHeaderPermission
	(*ServiceDefaults)(nil),                     // 50: hashicorp.consul.internal.configentry.ServiceDefaults
	(*TransparentProxyConfig)(nil),              // 51: hashicorp.consul.internal.configentry.TransparentProxyConfig
	(*MeshGatewayConfig)(nil),                   // 52: hashicorp.consul.internal.configentry.MeshGatewayConfig
	(*ExposeConfig)(nil),                        // 53: hashicorp.consul.internal.configentry.ExposeConfig
	(*ExposePath)(nil),                          // 54: hashicorp.consul.internal.configentry.ExposePath
	(*UpstreamConfiguration)(nil),               // 55: hashicorp.consul.internal.configentry.UpstreamConfiguration
	(*UpstreamConfig)(nil),                      // 56: hashicorp.consul.internal.configentry.UpstreamConfig
	(*UpstreamLimits)(nil),                      // 57: hashicorp.consul.internal.configentry.UpstreamLimits
	(*PassiveHealthCheck)(nil),                  // 58: hashicorp.consul.internal.configentry.PassiveHealthCheck
	(*DestinationConfig)(nil),                   // 59: hashicorp.consul.internal.configentry.DestinationConfig
	(*RateLimits)(nil),                          // 60: hashicorp.consul.internal.configentry.RateLimits
	(*InstanceLevelRateLimits)(nil),             // 61: hashicorp.consul.internal.configentry.InstanceLevelRateLimits
	(*InstanceLevelRouteRateLimits)(nil),        // 62: hashicorp.consul.internal.configentry.InstanceLevelRouteRateLimits
	(*APIGateway)(nil),                          // 63: hashicorp.consul.internal.configentry.APIGateway
	(*Status)(nil),                              // 64: hashicorp.consul.internal.configentry.Status
	(*Condition)(nil),                           // 65: hashicorp.consul.internal.configentry.Condition
	(*APIGatewayListener)(nil),                  // 66: hashicorp.consul.internal.configentry.APIGatewayListener
	(*APIGatewayTLSConfiguration)(nil),          // 67: hashicorp.consul.internal.configentry.APIGatewayTLSConfiguration
	(*APIGatewayPolicy)(nil),                    // 68: hashicorp.consul.internal.configentry.APIGatewayPolicy
	(*APIGatewayJWTRequirement)(nil),            // 69: hashicorp.consul.internal.configentry.APIGatewayJWTRequirement
	(*APIGatewayJWTProvider)(nil),               // 70: hashicorp.consul.internal.configentry.APIGatewayJWTProvider
	(*APIGatewayJWTClaimVerification)(nil),      // 71: hashicorp.consul.internal.configentry.APIGatewayJWTClaimVerification
	(*ResourceReference)(nil),                   // 72: hashicorp.consul.internal.configentry.ResourceReference
	(*BoundAPIGateway)(nil),                     // 73: hashicorp.consul.internal.configentry.BoundAPIGateway
	(*ListOfResourceReference)(nil),             // 74: hashicorp.consul.internal.configentry.ListOfResourceReference
	(*BoundAPIGatewayListener)(nil),             // 75: hashicorp.consul.internal.configentry.BoundAPIGatewayListener
	(*FileSystemCertificate)(nil),               // 76: hashicorp.consul.internal.configentry.FileSystemCertificate
	(*InlineCertificate)(nil),                   // 77: hashicorp.consul.internal.configentry.InlineCertificate
	(*HTTPRoute)(nil),                           // 78: hashicorp.consul.internal.configentry.HTTPRoute
	(*HTTPRouteRule)(nil),                       // 79: hashicorp.consul.internal.configentry.HTTPRouteRule
	(*HTTPMatch)(nil),                           // 80: hashicorp.consul.internal.configentry.HTTPMatch
	(*HTTPHeaderMatch)(nil),                     // 81: hashicorp.consul.internal.configentry.HTTPHeaderMatch
	(*HTTPPathMatch)(nil),                       // 82: hashicorp.consul.internal.configentry.HTTPPathMatch
	(*HTTPQueryMatch)(nil),                      // 83: hashicorp.consul.internal.configentry.HTTPQueryMatch
	(*HTTPFilters)(nil),                         // 84: hashicorp.consul.internal.configentry.HTTPFilters
	(*HTTPResponseFilters)(nil),                 // 85: hashicorp.consul.internal.configentry.HTTPResponseFilters
	(*URLRewrite)(nil),                          // 86: hashicorp.consul.internal.configentry.URLRewrite
	(*RetryFilter)(nil),                         // 87: hashicorp.consul.internal.configentry.RetryFilter
	(*TimeoutFilter)(nil),                       // 88: hashicorp.consul.internal.configentry.TimeoutFilter
	(*JWTFilter)(nil),                           // 89: hashicorp.consul.internal.configentry.JWTFilter
	(*HTTPHeaderFilter)(nil),                    // 90: hashicorp.consul.internal.configentry.HTTPHeaderFilter
	(*HTTPService)(nil),                         // 91: hashicorp.consul.internal.configentry.HTTPService
	(*TCPRoute)(nil),                            // 92: hashicorp.consul.internal.configentry.TCPRoute
	(*TCPService)(nil),                          // 93: hashicorp.consul.internal.configentry.TCPService
	(*SamenessGroup)(nil),                       // 94: hashicorp.consul.internal.configentry.SamenessGroup
	(*SamenessGroupMember)(nil),                 // 95: hashicorp.consul.internal.configentry.SamenessGroupMember
	(*JWTProvider)(nil),                         // 96: hashicorp.consul.internal.configentry.JWTProvider
	(*JSONWebKeySet)(nil),                       // 97: hashicorp.consul.internal.configentry.JSONWebKeySet
	(*LocalJWKS)(nil),                           // 98: hashicorp.consul.internal.configentry.LocalJWKS
	(*RemoteJWKS)(nil),                          // 99: hashicorp.consul.internal.configentry.RemoteJWKS
	(*JWKSCluster)(nil),                         // 100: hashicorp.consul.internal.configentry.JWKSCluster
	(*JWKSTLSCertificate)(nil),                  // 101: hashicorp.consul.internal.configentry.JWKSTLSCertificate
	(*JWKSTLSCertProviderInstance)(nil),         // 102: hashicorp.consul.internal.configentry.JWKSTLSCertProviderInstance
	(*JWKSTLSCertTrustedCA)(nil),                // 103: hashicorp.consul.internal.configentry.JWKSTLSCertTrustedCA
	(*JWKSRetryPolicy)(nil),                     // 104: hashicorp.consul.internal.configentry.JWKSRetryPolicy
	(*RetryPolicyBackOff)(nil),                  // 105: hashicorp.consul.internal.configentry.RetryPolicyBackOff
	(*JWTLocation)(nil),                         // 106: hashicorp.consul.internal.configentry.JWTLocation
	(*JWTLocationHeader)(nil),                   // 107: hashicorp.consul.internal.configentry.JWTLocationHeader
	(*JWTLocationQueryParam)(nil),               // 108: hashicorp.consul.internal.configentry.JWTLocationQueryParam
	(*JWTLocationCookie)(nil),                   // 109: hashicorp.consul.internal.configentry.JWTLocationCookie
	(*JWTForwardingConfig)(nil),                 // 110: hashicorp.consul.internal.configentry.JWTForwardingConfig
	(*JWTCacheConfig)(nil),                      // 111: hashicorp.consul.internal.configentry.JWTCacheConfig
	(*ExportedServices)(nil),                    // 112: hashicorp.consul.internal.configentry.ExportedServices
	(*ExportedServicesService)(nil),             // 113: hashicorp.consul.internal.configentry.ExportedServicesService
	(*ExportedServicesConsumer)(nil),            // 114: hashicorp.consul.internal.configentry.ExportedServicesConsumer
	nil,                                         // 115: hashicorp.consul.internal.configentry.MeshConfig.MetaEntry
	nil,                                         // 116: hashicorp.consul.internal.configentry.ServiceResolver.SubsetsEntry
	nil,                                         // 117: hashicorp.consul.internal.configentry.ServiceResolver.FailoverEntry
	nil,                                         // 118: hashicorp.consul.internal.configentry.ServiceResolver.MetaEntry
	nil,                                         // 119: hashicorp.consul.internal.configentry.IngressGateway.MetaEntry
	nil,                                         // 120: hashicorp.consul.internal.configentry.IngressService.MetaEntry
	nil,                                         // 121: hashicorp.consul.internal.configentry.HTTPHeaderModifiers.AddEntry
	nil,                                         // 122: hashicorp.consul.internal.configentry.HTTPHeaderModifiers.SetEntry
	nil,                                         // 123: hashicorp.consul.internal.configentry.ServiceIntentions.MetaEntry
	nil,                                         // 124: hashicorp.consul.internal.configentry.SourceIntention.LegacyMetaEntry
	nil,                                         // 125: hashicorp.consul.internal.configentry.ServiceDefaults.MetaEntry
	nil,                                         // 126: hashicorp.consul.internal.configentry.APIGateway.MetaEntry
	nil,                                         // 127: hashicorp.consul.internal.configentry.BoundAPIGateway.MetaEntry
	nil,                                         // 128: hashicorp.consul.internal.configentry.BoundAPIGateway.ServicesEntry
	nil,                                         // 129: hashicorp.consul.internal.configentry.FileSystemCertificate.MetaEntry
	nil,                                         // 130: hashicorp.consul.internal.configentry.InlineCertificate.MetaEntry
	nil,                                         // 131: hashicorp.consul.internal.configentry.HTTPRoute.MetaEntry
	nil,                                         // 132: hashicorp.consul.internal.configentry.HTTPHeaderFilter.AddEntry
	nil,                                         // 133: hashicorp.consul.internal.configentry.HTTPHeaderFilter.SetEntry
	nil,                                         // 134: hashicorp.consul.internal.configentry.TCPRoute.MetaEntry
	nil,                                         // 135: hashicorp.consul.internal.configentry.SamenessGroup.MetaEntry
	nil,                                         // 136: hashicorp.consul.internal.configentry.JWTProvider.MetaEntry
	nil,                                         // 137: hashicorp.consul.internal.configentry.ExportedServices.MetaEntry
	(*pbcommon.EnterpriseMeta)(nil),             // 138: hashicorp.consul.internal.common.EnterpriseMeta
	(*pbcommon.RaftIndex)(nil),                  // 139: hashicorp.consul.internal.common.RaftIndex
	(*durationpb.Duration)(nil),                 // 140: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),               // 141: google.protobuf.Timestamp
	(*pbcommon.EnvoyExtension)(nil),             // 142: hashicorp.consul.internal.common.EnvoyExtension
}
var file_private_pbconfigentry_config_entry_proto_depIdxs = []int32{
	13,  // 0: hashicorp.consul.internal.configentry.GetResolvedExportedServicesResponse.services:type_name -> hashicorp.consul.internal.configentry.ResolvedExportedService
	138, // 1: hashicorp.consul.internal.configentry.ResolvedExportedService.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	14,  // 2: hashicorp.consul.internal.configentry.ResolvedExportedService.Consumers:type_name -> hashicorp.consul.internal.configentry.Consumers
	0,   // 3: hashicorp.consul.internal.configentry.ConfigEntry.Kind:type_name -> hashicorp.consul.internal.configentry.Kind
	138, // 4: hashicorp.consul.internal.configentry.ConfigEntry.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	139, // 5: hashicorp.consul.internal.configentry.ConfigEntry.RaftIndex:type_name -> hashicorp.consul.internal.common.RaftIndex
	16,  // 6: hashicorp.consul.internal.configentry.ConfigEntry.MeshConfig:type_name -> hashicorp.consul.internal.configentry.MeshConfig
	22,  // 7: hashicorp.consul.internal.configentry.ConfigEntry.ServiceResolver:type_name -> hashicorp.consul.internal.configentry.ServiceResolver
	34,  // 8: hashicorp.consul.internal.configentry.ConfigEntry.IngressGateway:type_name -> hashicorp.consul.internal.configentry.IngressGateway
	42,  // 9: hashicorp.consul.internal.configentry.ConfigEntry.ServiceIntentions:type_name -> hashicorp.consul.internal.configentry.ServiceIntentions
	50,  // 10: hashicorp.consul.internal.configentry.ConfigEntry.ServiceDefaults:type_name -> hashicorp.consul.internal.configentry.ServiceDefaults
	63,  // 11: hashicorp.consul.internal.configentry.ConfigEntry.APIGateway:type_name -> hashicorp.consul.internal.configentry.APIGateway
	73,  // 12: hashicorp.consul.internal.configentry.ConfigEntry.BoundAPIGateway:type_name -> hashicorp.consul.internal.configentry.BoundAPIGateway
	92,  // 13: hashicorp.consul.internal.configentry.ConfigEntry.TCPRoute:type_name -> hashicorp.consul.internal.configentry.TCPRoute
	78,  // 14: hashicorp.consul.internal.configentry.ConfigEntry.HTTPRoute:type_name -> hashicorp.consul.internal.configentry.HTTPRoute
	77,  // 15: hashicorp.consul.internal.configentry.ConfigEntry.InlineCertificate:type_name -> hashicorp.consul.internal.configentry.InlineCertificate
	94,  // 16: hashicorp.consul.internal.configentry.ConfigEntry.SamenessGroup:type_name -> hashicorp.consul.internal.configentry.SamenessGroup
	96,  // 17: hashicorp.consul.internal.configentry.ConfigEntry.JWTProvider:type_name -> hashicorp.consul.internal.configentry.JWTProvider
	112, // 18: hashicorp.consul.internal.configentry.ConfigEntry.ExportedServices:type_name -> hashicorp.consul.internal.configentry.ExportedServices
	76,  // 19: hashicorp.consul.internal.configentry.ConfigEntry.FileSystemCertificate:type_name -> hashicorp.consul.internal.configentry.FileSystemCertificate
	17,  // 20: hashicorp.consul.internal.configentry.MeshConfig.TransparentProxy:type_name -> hashicorp.consul.internal.configentry.TransparentProxyMeshConfig
	18,  // 21: hashicorp.consul.internal.configentry.MeshConfig.TLS:type_name -> hashicorp.consul.internal.configentry.MeshTLSConfig
	20,  // 22: hashicorp.consul.internal.configentry.MeshConfig.HTTP:type_name -> hashicorp.consul.internal.configentry.MeshHTTPConfig
	115, // 23: hashicorp.consul.internal.configentry.MeshConfig.Meta:type_name -> hashicorp.consul.internal.configentry.MeshConfig.MetaEntry
	21,  // 24: hashicorp.consul.internal.configentry.MeshConfig.Peering:type_name -> hashicorp.consul.internal.configentry.PeeringMeshConfig
	19,  // 25: hashicorp.consul.internal.configentry.MeshTLSConfig.Incoming:type_name -> hashicorp.consul.internal.configentry.MeshDirectionalTLSConfig
	19,  // 26: hashicorp.consul.internal.configentry.MeshTLSConfig.Outgoing:type_name -> hashicorp.consul.internal.configentry.MeshDirectionalTLSConfig
	116, // 27: hashicorp.consul.internal.configentry.ServiceResolver.Subsets:type_name -> hashicorp.consul.internal.configentry.ServiceResolver.SubsetsEntry
	24,  // 28: hashicorp.consul.internal.configentry.ServiceResolver.Redirect:type_name -> hashicorp.consul.internal.configentry.ServiceResolverRedirect
	117, // 29: hashicorp.consul.internal.configentry.ServiceResolver.Failover:type_name -> hashicorp.consul.internal.configentry.ServiceResolver.FailoverEntry
	140, // 30: hashicorp.consul.internal.configentry.ServiceResolver.ConnectTimeout:type_name -> google.protobuf.Duration
	29,  // 31: hashicorp.consul.internal.configentry.ServiceResolver.LoadBalancer:type_name -> hashicorp.consul.internal.configentry.LoadBalancer
	118, // 32: hashicorp.consul.internal.configentry.ServiceResolver.Meta:type_name -> hashicorp.consul.internal.configentry.ServiceResolver.MetaEntry
	140, // 33: hashicorp.consul.internal.configentry.ServiceResolver.RequestTimeout:type_name -> google.protobuf.Duration
	27,  // 34: hashicorp.consul.internal.configentry.ServiceResolver.PrioritizeByLocality:type_name -> hashicorp.consul.internal.configentry.ServiceResolverPrioritizeByLocality
	28,  // 35: hashicorp.consul.internal.configentry.ServiceResolverFailover.Targets:type_name -> hashicorp.consul.internal.configentry.ServiceResolverFailoverTarget
	26,  // 36: hashicorp.consul.internal.configentry.ServiceResolverFailover.Policy:type_name -> hashicorp.consul.internal.configentry.ServiceResolverFailoverPolicy
	30,  // 37: hashicorp.consul.internal.configentry.LoadBalancer.RingHashConfig:type_name -> hashicorp.consul.internal.configentry.RingHashConfig
	31,  // 38: hashicorp.consul.internal.configentry.LoadBalancer.LeastRequestConfig:type_name -> hashicorp.consul.internal.configentry.LeastRequestConfig
	32,  // 39: hashicorp.consul.internal.configentry.LoadBalancer.HashPolicies:type_name -> hashicorp.consul.internal.configentry.HashPolicy
	33,  // 40: hashicorp.consul.internal.configentry.HashPolicy.CookieConfig:type_name -> hashicorp.consul.internal.configentry.CookieConfig
	140, // 41: hashicorp.consul.internal.configentry.CookieConfig.TTL:type_name -> google.protobuf.Duration
	36,  // 42: hashicorp.consul.internal.configentry.IngressGateway.TLS:type_name -> hashicorp.consul.internal.configentry.GatewayTLSConfig
	38,  // 43: hashicorp.consul.internal.configentry.IngressGateway.Listeners:type_name -> hashicorp.consul.internal.configentry.IngressListener
	119, // 44: hashicorp.consul.internal.configentry.IngressGateway.Meta:type_name -> hashicorp.consul.internal.configentry.IngressGateway.MetaEntry
	35,  // 45: hashicorp.consul.internal.configentry.IngressGateway.Defaults:type_name -> hashicorp.consul.internal.configentry.IngressServiceConfig
	58,  // 46: hashicorp.consul.internal.configentry.IngressServiceConfig.PassiveHealthCheck:type_name -> hashicorp.consul.internal.configentry.PassiveHealthCheck
	37,  // 47: hashicorp.consul.internal.configentry.GatewayTLSConfig.SDS:type_name -> hashicorp.consul.internal.configentry.GatewayTLSSDSConfig
	39,  // 48: hashicorp.consul.internal.configentry.IngressListener.Services:type_name -> hashicorp.consul.internal.configentry.IngressService
	36,  // 49: hashicorp.consul.internal.configentry.IngressListener.TLS:type_name -> hashicorp.consul.internal.configentry.GatewayTLSConfig
	40,  // 50: hashicorp.consul.internal.configentry.IngressService.TLS:type_name -> hashicorp.consul.internal.configentry.GatewayServiceTLSConfig
	41,  // 51: hashicorp.consul.internal.configentry.IngressService.RequestHeaders:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderModifiers
	41,  // 52: hashicorp.consul.internal.configentry.IngressService.ResponseHeaders:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderModifiers
	120, // 53: hashicorp.consul.internal.configentry.IngressService.Meta:type_name -> hashicorp.consul.internal.configentry.IngressService.MetaEntry
	138, // 54: hashicorp.consul.internal.configentry.IngressService.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	58,  // 55: hashicorp.consul.internal.configentry.IngressService.PassiveHealthCheck:type_name -> hashicorp.consul.internal.configentry.PassiveHealthCheck
	37,  // 56: hashicorp.consul.internal.configentry.GatewayServiceTLSConfig.SDS:type_name -> hashicorp.consul.internal.configentry.GatewayTLSSDSConfig
	121, // 57: hashicorp.consul.internal.configentry.HTTPHeaderModifiers.Add:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderModifiers.AddEntry
	122, // 58: hashicorp.consul.internal.configentry.HTTPHeaderModifiers.Set:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderModifiers.SetEntry
	46,  // 59: hashicorp.consul.internal.configentry.ServiceIntentions.Sources:type_name -> hashicorp.consul.internal.configentry.SourceIntention
	123, // 60: hashicorp.consul.internal.configentry.ServiceIntentions.Meta:type_name -> hashicorp.consul.internal.configentry.ServiceIntentions.MetaEntry
	43,  // 61: hashicorp.consul.internal.configentry.ServiceIntentions.JWT:type_name -> hashicorp.consul.internal.configentry.IntentionJWTRequirement
	44,  // 62: hashicorp.consul.internal.configentry.IntentionJWTRequirement.Providers:type_name -> hashicorp.consul.internal.configentry.IntentionJWTProvider
	45,  // 63: hashicorp.consul.internal.configentry.IntentionJWTProvider.VerifyClaims:type_name -> hashicorp.consul.internal.configentry.IntentionJWTClaimVerification
	1,   // 64: hashicorp.consul.internal.configentry.SourceIntention.Action:type_name -> hashicorp.consul.internal.configentry.IntentionAction
	47,  // 65: hashicorp.consul.internal.configentry.SourceIntention.Permissions:type_name -> hashicorp.consul.internal.configentry.IntentionPermission
	2,   // 66: hashicorp.consul.internal.configentry.SourceIntention.Type:type_name -> hashicorp.consul.internal.configentry.IntentionSourceType
	124, // 67: hashicorp.consul.internal.configentry.SourceIntention.LegacyMeta:type_name -> hashicorp.consul.internal.configentry.SourceIntention.LegacyMetaEntry
	141, // 68: hashicorp.consul.internal.configentry.SourceIntention.LegacyCreateTime:type_name -> google.protobuf.Timestamp
	141, // 69: hashicorp.consul.internal.configentry.SourceIntention.LegacyUpdateTime:type_name -> google.protobuf.Timestamp
	138, // 70: hashicorp.consul.internal.configentry.SourceIntention.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	1,   // 71: hashicorp.consul.internal.configentry.IntentionPermission.Action:type_name -> hashicorp.consul.internal.configentry.IntentionAction
	48,  // 72: hashicorp.consul.internal.configentry.IntentionPermission.HTTP:type_name -> hashicorp.consul.internal.configentry.IntentionHTTPPermission
	43,  // 73: hashicorp.consul.internal.configentry.IntentionPermission.JWT:type_name -> hashicorp.consul.internal.configentry.IntentionJWTRequirement
	49,  // 74: hashicorp.consul.internal.configentry.IntentionHTTPPermission.Header:type_name -> hashicorp.consul.internal.configentry.IntentionHTTPHeaderPermission
	3,   // 75: hashicorp.consul.internal.configentry.ServiceDefaults.Mode:type_name -> hashicorp.consul.internal.configentry.ProxyMode
	51,  // 76: hashicorp.consul.internal.configentry.ServiceDefaults.TransparentProxy:type_name -> hashicorp.consul.internal.configentry.TransparentProxyConfig
	52,  // 77: hashicorp.consul.internal.configentry.ServiceDefaults.MeshGateway:type_name -> hashicorp.consul.internal.configentry.MeshGatewayConfig
	53,  // 78: hashicorp.consul.internal.configentry.ServiceDefaults.Expose:type_name -> hashicorp.consul.internal.configentry.ExposeConfig
	55,  // 79: hashicorp.consul.internal.configentry.ServiceDefaults.UpstreamConfig:type_name -> hashicorp.consul.internal.configentry.UpstreamConfiguration
	59,  // 80: hashicorp.consul.internal.configentry.ServiceDefaults.Destination:type_name -> hashicorp.consul.internal.configentry.DestinationConfig
	60,  // 81: hashicorp.consul.internal.configentry.ServiceDefaults.RateLimits:type_name -> hashicorp.consul.internal.configentry.RateLimits
	125, // 82: hashicorp.consul.internal.configentry.ServiceDefaults.Meta:type_name -> hashicorp.consul.internal.configentry.ServiceDefaults.MetaEntry
	142, // 83: hashicorp.consul.internal.configentry.ServiceDefaults.EnvoyExtensions:type_name -> hashicorp.consul.internal.common.EnvoyExtension
	4,   // 84: hashicorp.consul.internal.configentry.ServiceDefaults.MutualTLSMode:type_name -> hashicorp.consul.internal.configentry.MutualTLSMode
	5,   // 85: hashicorp.consul.internal.configentry.MeshGatewayConfig.Mode:type_name -> hashicorp.consul.internal.configentry.MeshGatewayMode
	54,  // 86: hashicorp.consul.internal.configentry.ExposeConfig.Paths:type_name -> hashicorp.consul.internal.configentry.ExposePath
	56,  // 87: hashicorp.consul.internal.configentry.UpstreamConfiguration.Overrides:type_name -> hashicorp.consul.internal.configentry.UpstreamConfig
	56,  // 88: hashicorp.consul.internal.configentry.UpstreamConfiguration.Defaults:type_name -> hashicorp.consul.internal.configentry.UpstreamConfig
	138, // 89: hashicorp.consul.internal.configentry.UpstreamConfig.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	57,  // 90: hashicorp.consul.internal.configentry.UpstreamConfig.Limits:type_name -> hashicorp.consul.internal.configentry.UpstreamLimits
	58,  // 91: hashicorp.consul.internal.configentry.UpstreamConfig.PassiveHealthCheck:type_name -> hashicorp.consul.internal.configentry.PassiveHealthCheck
	52,  // 92: hashicorp.consul.internal.configentry.UpstreamConfig.MeshGateway:type_name -> hashicorp.consul.internal.configentry.MeshGatewayConfig
	140, // 93: hashicorp.consul.internal.configentry.PassiveHealthCheck.Interval:type_name -> google.protobuf.Duration
	140, // 94: hashicorp.consul.internal.configentry.PassiveHealthCheck.BaseEjectionTime:type_name -> google.protobuf.Duration
	61,  // 95: hashicorp.consul.internal.configentry.RateLimits.InstanceLevel:type_name -> hashicorp.consul.internal.configentry.InstanceLevelRateLimits
	62,  // 96: hashicorp.consul.internal.configentry.InstanceLevelRateLimits.Routes:type_name -> hashicorp.consul.internal.configentry.InstanceLevelRouteRateLimits
	126, // 97: hashicorp.consul.internal.configentry.APIGateway.Meta:type_name -> hashicorp.consul.internal.configentry.APIGateway.MetaEntry
	66,  // 98: hashicorp.consul.internal.configentry.APIGateway.Listeners:type_name -> hashicorp.consul.internal.configentry.APIGatewayListener
	64,  // 99: hashicorp.consul.internal.configentry.APIGateway.Status:type_name -> hashicorp.consul.internal.configentry.Status
	65,  // 100: hashicorp.consul.internal.configentry.Status.Conditions:type_name -> hashicorp.consul.internal.configentry.Condition
	72,  // 101: hashicorp.consul.internal.configentry.Condition.Resource:type_name -> hashicorp.consul.internal.configentry.ResourceReference
	141, // 102: hashicorp.consul.internal.configentry.Condition.LastTransitionTime:type_name -> google.protobuf.Timestamp
	6,   // 103: hashicorp.consul.internal.configentry.APIGatewayListener.Protocol:type_name -> hashicorp.consul.internal.configentry.APIGatewayListenerProtocol
	67,  // 104: hashicorp.consul.internal.configentry.APIGatewayListener.TLS:type_name -> hashicorp.consul.internal.configentry.APIGatewayTLSConfiguration
	68,  // 105: hashicorp.consul.internal.configentry.APIGatewayListener.Override:type_name -> hashicorp.consul.internal.configentry.APIGatewayPolicy
	68,  // 106: hashicorp.consul.internal.configentry.APIGatewayListener.Default:type_name -> hashicorp.consul.internal.configentry.APIGatewayPolicy
	72,  // 107: hashicorp.consul.internal.configentry.APIGatewayTLSConfiguration.Certificates:type_name -> hashicorp.consul.internal.configentry.ResourceReference
	69,  // 108: hashicorp.consul.internal.configentry.APIGatewayPolicy.JWT:type_name -> hashicorp.consul.internal.configentry.APIGatewayJWTRequirement
	70,  // 109: hashicorp.consul.internal.configentry.APIGatewayJWTRequirement.Providers:type_name -> hashicorp.consul.internal.configentry.APIGatewayJWTProvider
	71,  // 110: hashicorp.consul.internal.configentry.APIGatewayJWTProvider.VerifyClaims:type_name -> hashicorp.consul.internal.configentry.APIGatewayJWTClaimVerification
	138, // 111: hashicorp.consul.internal.configentry.ResourceReference.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	127, // 112: hashicorp.consul.internal.configentry.BoundAPIGateway.Meta:type_name -> hashicorp.consul.internal.configentry.BoundAPIGateway.MetaEntry
	75,  // 113: hashicorp.consul.internal.configentry.BoundAPIGateway.Listeners:type_name -> hashicorp.consul.internal.configentry.BoundAPIGatewayListener
	128, // 114: hashicorp.consul.internal.configentry.BoundAPIGateway.Services:type_name -> hashicorp.consul.internal.configentry.BoundAPIGateway.ServicesEntry
	72,  // 115: hashicorp.consul.internal.configentry.ListOfResourceReference.Ref:type_name -> hashicorp.consul.internal.configentry.ResourceReference
	72,  // 116: hashicorp.consul.internal.configentry.BoundAPIGatewayListener.Certificates:type_name -> hashicorp.consul.internal.configentry.ResourceReference
	72,  // 117: hashicorp.consul.internal.configentry.BoundAPIGatewayListener.Routes:type_name -> hashicorp.consul.internal.configentry.ResourceReference
	129, // 118: hashicorp.consul.internal.configentry.FileSystemCertificate.Meta:type_name -> hashicorp.consul.internal.configentry.FileSystemCertificate.MetaEntry
	130, // 119: hashicorp.consul.internal.configentry.InlineCertificate.Meta:type_name -> hashicorp.consul.internal.configentry.InlineCertificate.MetaEntry
	131, // 120: hashicorp.consul.internal.configentry.HTTPRoute.Meta:type_name -> hashicorp.consul.internal.configentry.HTTPRoute.MetaEntry
	72,  // 121: hashicorp.consul.internal.configentry.HTTPRoute.Parents:type_name -> hashicorp.consul.internal.configentry.ResourceReference
	79,  // 122: hashicorp.consul.internal.configentry.HTTPRoute.Rules:type_name -> hashicorp.consul.internal.configentry.HTTPRouteRule
	64,  // 123: hashicorp.consul.internal.configentry.HTTPRoute.Status:type_name -> hashicorp.consul.internal.configentry.Status
	84,  // 124: hashicorp.consul.internal.configentry.HTTPRouteRule.Filters:type_name -> hashicorp.consul.internal.configentry.HTTPFilters
	80,  // 125: hashicorp.consul.internal.configentry.HTTPRouteRule.Matches:type_name -> hashicorp.consul.internal.configentry.HTTPMatch
	91,  // 126: hashicorp.consul.internal.configentry.HTTPRouteRule.Services:type_name -> hashicorp.consul.internal.configentry.HTTPService
	85,  // 127: hashicorp.consul.internal.configentry.HTTPRouteRule.ResponseFilters:type_name -> hashicorp.consul.internal.configentry.HTTPResponseFilters
	81,  // 128: hashicorp.consul.internal.configentry.HTTPMatch.Headers:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderMatch
	7,   // 129: hashicorp.consul.internal.configentry.HTTPMatch.Method:type_name -> hashicorp.consul.internal.configentry.HTTPMatchMethod
	82,  // 130: hashicorp.consul.internal.configentry.HTTPMatch.Path:type_name -> hashicorp.consul.internal.configentry.HTTPPathMatch
	83,  // 131: hashicorp.consul.internal.configentry.HTTPMatch.Query:type_name -> hashicorp.consul.internal.configentry.HTTPQueryMatch
	8,   // 132: hashicorp.consul.internal.configentry.HTTPHeaderMatch.Match:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderMatchType
	9,   // 133: hashicorp.consul.internal.configentry.HTTPPathMatch.Match:type_name -> hashicorp.consul.internal.configentry.HTTPPathMatchType
	10,  // 134: hashicorp.consul.internal.configentry.HTTPQueryMatch.Match:type_name -> hashicorp.consul.internal.configentry.HTTPQueryMatchType
	90,  // 135: hashicorp.consul.internal.configentry.HTTPFilters.Headers:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderFilter
	86,  // 136: hashicorp.consul.internal.configentry.HTTPFilters.URLRewrite:type_name -> hashicorp.consul.internal.configentry.URLRewrite
	87,  // 137: hashicorp.consul.internal.configentry.HTTPFilters.RetryFilter:type_name -> hashicorp.consul.internal.configentry.RetryFilter
	88,  // 138: hashicorp.consul.internal.configentry.HTTPFilters.TimeoutFilter:type_name -> hashicorp.consul.internal.configentry.TimeoutFilter
	89,  // 139: hashicorp.consul.internal.configentry.HTTPFilters.JWT:type_name -> hashicorp.consul.internal.configentry.JWTFilter
	90,  // 140: hashicorp.consul.internal.configentry.HTTPResponseFilters.Headers:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderFilter
	140, // 141: hashicorp.consul.internal.configentry.TimeoutFilter.RequestTimeout:type_name -> google.protobuf.Duration
	140, // 142: hashicorp.consul.internal.configentry.TimeoutFilter.IdleTimeout:type_name -> google.protobuf.Duration
	70,  // 143: hashicorp.consul.internal.configentry.JWTFilter.Providers:type_name -> hashicorp.consul.internal.configentry.APIGatewayJWTProvider
	132, // 144: hashicorp.consul.internal.configentry.HTTPHeaderFilter.Add:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderFilter.AddEntry
	133, // 145: hashicorp.consul.internal.configentry.HTTPHeaderFilter.Set:type_name -> hashicorp.consul.internal.configentry.HTTPHeaderFilter.SetEntry
	84,  // 146: hashicorp.consul.internal.configentry.HTTPService.Filters:type_name -> hashicorp.consul.internal.configentry.HTTPFilters
	138, // 147: hashicorp.consul.internal.configentry.HTTPService.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	85,  // 148: hashicorp.consul.internal.configentry.HTTPService.ResponseFilters:type_name -> hashicorp.consul.internal.configentry.HTTPResponseFilters
	134, // 149: hashicorp.consul.internal.configentry.TCPRoute.Meta:type_name -> hashicorp.consul.internal.configentry.TCPRoute.MetaEntry
	72,  // 150: hashicorp.consul.internal.configentry.TCPRoute.Parents:type_name -> hashicorp.consul.internal.configentry.ResourceReference
	93,  // 151: hashicorp.consul.internal.configentry.TCPRoute.Services:type_name -> hashicorp.consul.internal.configentry.TCPService
	64,  // 152: hashicorp.consul.internal.configentry.TCPRoute.Status:type_name -> hashicorp.consul.internal.configentry.Status
	138, // 153: hashicorp.consul.internal.configentry.TCPService.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	95,  // 154: hashicorp.consul.internal.configentry.SamenessGroup.Members:type_name -> hashicorp.consul.internal.configentry.SamenessGroupMember
	135, // 155: hashicorp.consul.internal.configentry.SamenessGroup.Meta:type_name -> hashicorp.consul.internal.configentry.SamenessGroup.MetaEntry
	138, // 156: hashicorp.consul.internal.configentry.SamenessGroup.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	97,  // 157: hashicorp.consul.internal.configentry.JWTProvider.JSONWebKeySet:type_name -> hashicorp.consul.internal.configentry.JSONWebKeySet
	106, // 158: hashicorp.consul.internal.configentry.JWTProvider.Locations:type_name -> hashicorp.consul.internal.configentry.JWTLocation
	110, // 159: hashicorp.consul.internal.configentry.JWTProvider.Forwarding:type_name -> hashicorp.consul.internal.configentry.JWTForwardingConfig
	111, // 160: hashicorp.consul.internal.configentry.JWTProvider.CacheConfig:type_name -> hashicorp.consul.internal.configentry.JWTCacheConfig
	136, // 161: hashicorp.consul.internal.configentry.JWTProvider.Meta:type_name -> hashicorp.consul.internal.configentry.JWTProvider.MetaEntry
	98,  // 162: hashicorp.consul.internal.configentry.JSONWebKeySet.Local:type_name -> hashicorp.consul.internal.configentry.LocalJWKS
	99,  // 163: hashicorp.consul.internal.configentry.JSONWebKeySet.Remote:type_name -> hashicorp.consul.internal.configentry.RemoteJWKS
	140, // 164: hashicorp.consul.internal.configentry.RemoteJWKS.CacheDuration:type_name -> google.protobuf.Duration
	104, // 165: hashicorp.consul.internal.configentry.RemoteJWKS.RetryPolicy:type_name -> hashicorp.consul.internal.configentry.JWKSRetryPolicy
	100, // 166: hashicorp.consul.internal.configentry.RemoteJWKS.JWKSCluster:type_name -> hashicorp.consul.internal.configentry.JWKSCluster
	101, // 167: hashicorp.consul.internal.configentry.JWKSCluster.TLSCertificates:type_name -> hashicorp.consul.internal.configentry.JWKSTLSCertificate
	140, // 168: hashicorp.consul.internal.configentry.JWKSCluster.ConnectTimeout:type_name -> google.protobuf.Duration
	102, // 169: hashicorp.consul.internal.configentry.JWKSTLSCertificate.CaCertificateProviderInstance:type_name -> hashicorp.consul.internal.configentry.JWKSTLSCertProviderInstance
	103, // 170: hashicorp.consul.internal.configentry.JWKSTLSCertificate.TrustedCA:type_name -> hashicorp.consul.internal.configentry.JWKSTLSCertTrustedCA
	105, // 171: hashicorp.consul.internal.configentry.JWKSRetryPolicy.RetryPolicyBackOff:type_name -> hashicorp.consul.internal.configentry.RetryPolicyBackOff
	140, // 172: hashicorp.consul.internal.configentry.RetryPolicyBackOff.BaseInterval:type_name -> google.protobuf.Duration
	140, // 173: hashicorp.consul.internal.configentry.RetryPolicyBackOff.MaxInterval:type_name -> google.protobuf.Duration
	107, // 174: hashicorp.consul.internal.configentry.JWTLocation.Header:type_name -> hashicorp.consul.internal.configentry.JWTLocationHeader
	108, // 175: hashicorp.consul.internal.configentry.JWTLocation.QueryParam:type_name -> hashicorp.consul.internal.configentry.JWTLocationQueryParam
	109, // 176: hashicorp.consul.internal.configentry.JWTLocation.Cookie:type_name -> hashicorp.consul.internal.configentry.JWTLocationCookie
	138, // 177: hashicorp.consul.internal.configentry.ExportedServices.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	137, // 178: hashicorp.consul.internal.configentry.ExportedServices.Meta:type_name -> hashicorp.consul.internal.configentry.ExportedServices.MetaEntry
	113, // 179: hashicorp.consul.internal.configentry.ExportedServices.Services:type_name -> hashicorp.consul.internal.configentry.ExportedServicesService
	114, // 180: hashicorp.consul.internal.configentry.ExportedServicesService.Consumers:type_name -> hashicorp.consul.internal.configentry.ExportedServicesConsumer
	23,  // 181: hashicorp.consul.internal.configentry.ServiceResolver.SubsetsEntry.value:type_name -> hashicorp.consul.internal.configentry.ServiceResolverSubset
	25,  // 182: hashicorp.consul.internal.configentry.ServiceResolver.FailoverEntry.value:type_name -> hashicorp.consul.internal.configentry.ServiceResolverFailover
	74,  // 183: hashicorp.consul.internal.configentry.BoundAPIGateway.ServicesEntry.value:type_name -> hashicorp.consul.internal.configentry.ListOfResourceReference
	11,  // 184: hashicorp.consul.internal.configentry.ConfigEntryService.GetResolvedExportedServices:input_type -> hashicorp.consul.internal.configentry.GetResolvedExportedServicesRequest
	12,  // 185: hashicorp.consul.internal.configentry.ConfigEntryService.GetResolvedExportedServices:output_type -> hashicorp.consul.internal.configentry.GetResolvedExportedServicesResponse
	185, // [185:186] is the sub-list for method output_type
	184, // [184:185] is the sub-list for method input_type
	184, // [184:184] is the sub-list for extension type_name
	184, // [184:184] is the sub-list for extension extendee
	0,   // [0:184] is the sub-list for field type_name
}

func init() { file_private_pbconfigentry_config_entry_proto_init() }
func file_private_pbconfigentry_config_entry_proto_init() {
	if File_private_pbconfigentry_config_entry_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_private_pbconfigentry_config_entry_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetResolvedExportedServicesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetResolvedExportedServicesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolvedExportedService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Consumers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfigEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeshConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransparentProxyMeshConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeshTLSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeshDirectionalTLSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeshHTTPConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeeringMeshConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceResolver); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceResolverSubset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceResolverRedirect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceResolverFailover); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceResolverFailoverPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceResolverPrioritizeByLocality); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceResolverFailoverTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoadBalancer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RingHashConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LeastRequestConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HashPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CookieConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngressGateway); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngressServiceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayTLSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayTLSSDSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngressListener); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IngressService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GatewayServiceTLSConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPHeaderModifiers); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceIntentions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentionJWTRequirement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentionJWTProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentionJWTClaimVerification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceIntention); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentionPermission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentionHTTPPermission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentionHTTPHeaderPermission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceDefaults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransparentProxyConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MeshGatewayConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExposeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExposePath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpstreamConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpstreamConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpstreamLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PassiveHealthCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DestinationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RateLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceLevelRateLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstanceLevelRouteRateLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APIGateway); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[53].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Status); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[54].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APIGatewayListener); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APIGatewayTLSConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[57].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APIGatewayPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[58].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APIGatewayJWTRequirement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[59].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APIGatewayJWTProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[60].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*APIGatewayJWTClaimVerification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[61].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[62].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundAPIGateway); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[63].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOfResourceReference); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[64].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundAPIGatewayListener); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[65].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileSystemCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[66].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InlineCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[67].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[68].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPRouteRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[69].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[70].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPHeaderMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[71].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPPathMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[72].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPQueryMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[73].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPFilters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[74].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPResponseFilters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[75].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*URLRewrite); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[76].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[77].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeoutFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[78].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWTFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[79].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPHeaderFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[80].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HTTPService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[81].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TCPRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[82].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TCPService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[83].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SamenessGroup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[84].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SamenessGroupMember); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[85].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWTProvider); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[86].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JSONWebKeySet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[87].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocalJWKS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[88].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteJWKS); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[89].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWKSCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[90].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWKSTLSCertificate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[91].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWKSTLSCertProviderInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[92].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWKSTLSCertTrustedCA); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[93].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWKSRetryPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[94].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryPolicyBackOff); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[95].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWTLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[96].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWTLocationHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[97].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWTLocationQueryParam); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[98].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWTLocationCookie); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[99].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWTForwardingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[100].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JWTCacheConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[101].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportedServices); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[102].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportedServicesService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_private_pbconfigentry_config_entry_proto_msgTypes[103].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportedServicesConsumer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_private_pbconfigentry_config_entry_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ConfigEntry_MeshConfig)(nil),
		(*ConfigEntry_ServiceResolver)(nil),
		(*ConfigEntry_IngressGateway)(nil),
		(*ConfigEntry_ServiceIntentions)(nil),
		(*ConfigEntry_ServiceDefaults)(nil),
		(*ConfigEntry_APIGateway)(nil),
		(*ConfigEntry_BoundAPIGateway)(nil),
		(*ConfigEntry_TCPRoute)(nil),
		(*ConfigEntry_HTTPRoute)(nil),
		(*ConfigEntry_InlineCertificate)(nil),
		(*ConfigEntry_SamenessGroup)(nil),
		(*ConfigEntry_JWTProvider)(nil),
		(*ConfigEntry_ExportedServices)(nil),
		(*ConfigEntry_FileSystemCertificate)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_private_pbconfigentry_config_entry_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   127,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_private_pbconfigentry_config_entry_proto_goTypes,
		DependencyIndexes: file_private_pbconfigentry_config_entry_proto_depIdxs,
		EnumInfos:         file_private_pbconfigentry_config_entry_proto_enumTypes,
		MessageInfos:      file_private_pbconfigentry_config_entry_proto_msgTypes,
	}.Build()
	File_private_pbconfigentry_config_entry_proto = out.File
	file_private_pbconfigentry_config_entry_proto_rawDesc = nil
	file_private_pbconfigentry_config_entry_proto_goTypes = nil
	file_private_pbconfigentry_config_entry_proto_depIdxs = nil
}
