//
// About dialog for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2021 by Bill Spitzak and others.
//
// This library is free software. Distribution and use rights are outlined in
// the file "COPYING" which should have been included with this file.  If this
// file is missing or damaged, see the license at:
//
//     https://www.fltk.org/COPYING.php
//
// Please see the following page on how to report bugs and issues:
//
//     https://www.fltk.org/bugs.php
//

// generated by Fast Light User Interface Designer (fluid) version 1.0400

#include "about_panel.h"
void show_help(const char *name);

Fl_Double_Window *about_panel=(Fl_Double_Window *)0;

#include <FL/Fl_Anim_GIF_Image.H>

static const unsigned char idata_fluid[] =
{71,73,70,56,57,97,96,0,96,0,132,31,0,0,1,0,3,31,63,46,48,45,0,54,108,78,80,
77,64,123,116,124,126,123,125,173,98,107,166,116,171,204,63,220,233,19,253,254,
0,196,218,42,147,189,83,20,101,159,44,112,135,0,88,172,0,96,191,0,109,220,91,
161,140,68,152,169,38,140,205,0,128,255,15,133,249,45,146,236,47,148,254,108,
182,255,164,166,162,187,222,255,202,204,201,253,255,252,0,0,0,33,255,11,78,69,
84,83,67,65,80,69,50,46,48,3,1,0,0,0,33,249,4,5,10,0,31,0,44,0,0,0,0,96,0,96,0,
0,5,254,224,39,142,100,105,158,104,170,174,108,235,190,112,44,207,116,109,223,
120,110,2,124,239,3,186,160,238,71,36,14,34,61,161,18,86,244,13,32,78,139,5,201,
91,90,87,63,143,118,171,201,112,184,25,11,180,122,45,239,120,219,180,135,147,
241,174,219,223,164,121,46,234,169,211,108,111,87,163,149,211,205,118,119,96,28,
93,95,28,3,100,127,101,129,130,90,95,107,26,93,22,136,138,128,104,120,28,143,
90,124,121,97,80,149,139,151,142,109,164,111,134,153,99,160,87,140,155,145,153,
142,142,113,137,170,66,172,130,108,90,112,126,180,65,182,119,93,163,26,136,64,
188,181,162,183,112,111,25,169,197,189,199,119,121,143,108,204,205,57,190,120,
25,124,91,28,187,213,54,215,120,119,221,222,52,224,141,125,179,228,229,207,231,
105,227,234,49,230,231,239,240,47,242,141,244,245,45,247,130,249,250,88,236,218,
161,35,246,47,222,179,78,110,196,165,43,184,239,24,194,100,106,252,49,60,193,
232,33,41,77,3,39,50,17,101,17,226,22,137,26,73,84,36,69,50,225,199,133,33,254,
81,140,44,233,49,99,74,22,172,186,148,212,230,14,229,203,18,172,44,98,116,121,
51,133,47,66,26,118,158,36,216,147,98,64,129,32,95,242,83,72,180,40,206,163,
237,124,56,61,3,245,156,128,164,19,125,16,16,40,104,131,212,169,31,180,114,109,
100,224,171,83,31,99,149,37,236,64,192,236,77,31,27,198,178,204,48,180,105,72,
177,92,59,62,242,138,213,155,15,1,105,231,182,217,210,182,111,51,31,29,2,11,78,
83,216,38,60,196,105,61,8,166,91,211,49,57,31,6,34,171,37,185,147,175,229,195,
61,0,107,222,108,146,177,219,199,61,226,142,134,228,202,234,105,191,169,87,107,
246,108,23,52,15,213,178,35,211,86,135,55,183,230,198,181,85,193,245,189,250,
234,103,58,195,183,93,36,126,174,195,235,74,189,37,179,100,78,246,249,159,208,
216,88,10,165,238,1,56,45,200,91,38,115,23,100,60,120,168,219,106,196,143,103,
106,126,73,244,92,139,215,171,41,107,184,134,143,0,24,34,233,143,116,161,191,
255,11,251,5,40,224,128,4,6,24,128,117,198,0,254,16,128,4,82,52,232,224,131,16,
70,40,225,132,16,74,128,224,16,61,68,64,225,134,28,118,8,33,21,199,217,215,195,
0,30,150,104,226,132,99,132,56,67,15,1,104,248,32,6,48,62,120,193,137,52,98,
192,160,20,7,214,215,16,15,46,54,136,65,3,12,36,160,0,2,20,76,128,0,144,61,122,
120,65,3,9,84,112,227,139,8,28,144,0,3,10,56,41,133,4,57,182,183,98,15,16,60,88,
129,2,11,20,48,193,2,11,8,73,38,3,17,60,217,33,2,103,166,9,33,6,19,48,64,166,2,
110,74,145,162,150,27,241,64,226,131,114,162,201,166,2,14,200,185,64,3,117,118,
120,193,1,115,66,160,166,131,9,144,153,64,161,98,92,104,15,139,139,82,64,38,2,
16,68,48,1,5,16,128,25,38,164,28,126,57,36,168,82,92,32,40,166,139,102,137,39,
76,25,202,40,232,3,105,74,32,65,5,115,58,32,43,141,18,144,42,5,173,11,0,10,42,
150,58,62,197,67,151,47,38,170,225,140,108,150,169,40,174,183,74,152,172,2,138,
46,58,133,164,42,254,68,225,96,5,19,52,112,38,2,19,220,216,232,2,168,74,128,65,
145,7,80,192,32,156,155,58,152,65,5,69,54,43,5,5,9,36,48,193,183,13,44,27,225,
48,42,10,11,192,158,14,206,235,169,2,65,106,136,129,167,176,86,32,40,153,182,
90,128,232,160,26,82,224,233,160,79,98,208,232,144,7,23,96,111,132,170,202,224,
131,180,22,152,74,166,197,178,74,96,105,175,209,122,188,0,154,12,10,58,65,154,
23,12,76,230,202,231,202,233,235,152,189,218,202,177,20,17,100,105,144,158,18,
186,188,128,3,246,46,92,47,131,38,31,160,40,175,63,187,233,51,172,82,124,91,64,
154,52,51,144,233,134,22,246,101,109,132,35,51,96,179,20,130,62,205,32,175,10,
192,122,65,178,82,19,157,245,212,52,39,144,169,4,218,46,96,244,205,14,226,187,
234,125,20,38,171,246,141,24,144,249,243,178,81,71,43,232,219,82,180,253,54,6,
42,47,75,176,174,16,234,204,42,15,27,126,139,64,157,125,223,40,184,162,35,47,0,
235,141,93,67,109,172,5,35,67,235,238,134,254,146,250,144,100,132,135,75,78,38,
224,25,148,254,45,180,46,130,237,128,134,223,222,205,182,163,203,194,237,224,
157,62,177,184,97,222,100,70,219,177,167,94,115,158,168,4,19,120,58,180,20,125,
71,112,129,167,143,139,203,252,197,29,202,109,20,15,11,110,120,118,235,181,62,
112,128,5,52,215,27,168,227,16,32,192,224,228,13,60,160,55,200,109,91,94,0,5,38,
2,59,142,238,28,78,126,35,205,128,54,57,187,219,129,82,208,117,3,221,90,0,252,
1,7,144,128,167,140,118,36,48,133,13,101,237,59,141,15,136,213,184,143,65,78,
111,10,40,128,172,210,55,36,1,206,233,81,12,122,24,6,41,152,0,243,205,233,1,159,
235,16,238,234,48,162,14,185,204,115,13,50,216,201,130,247,165,147,193,12,81,10,
120,27,131,254,212,128,215,137,75,91,10,168,87,4,26,197,128,203,209,104,18,82,
185,218,134,120,165,67,7,229,42,86,13,58,34,18,143,232,174,92,133,236,74,76,12,
89,4,88,246,67,11,232,140,82,20,194,128,147,46,64,51,31,62,232,86,79,122,148,
226,141,158,104,196,207,49,72,2,51,234,216,25,171,104,129,170,253,32,0,27,146,
147,248,26,37,59,54,218,241,142,86,36,2,28,41,68,166,6,208,202,87,182,195,163,
32,39,164,42,234,109,8,1,10,152,82,15,17,55,200,70,74,168,144,10,226,144,3,40,
96,195,16,58,242,146,247,210,99,135,66,22,72,76,98,18,146,0,128,158,39,71,121,
34,9,224,238,141,1,72,165,42,87,201,202,86,186,242,149,176,140,165,44,103,201,
202,31,144,176,9,184,204,165,46,119,201,203,94,246,82,36,190,12,166,48,135,73,
76,34,76,175,152,200,76,102,49,75,16,2,0,33,249,4,5,10,0,31,0,44,30,0,4,0,38,0,
57,0,0,5,254,224,39,142,31,96,158,104,170,2,100,235,174,112,236,206,174,103,
223,56,158,210,60,205,113,185,91,111,152,201,136,56,25,100,50,232,25,246,126,71,
227,143,233,57,57,121,72,13,105,169,51,93,105,154,204,141,243,225,222,172,95,
151,70,227,209,126,128,65,116,186,85,92,127,168,115,44,156,218,204,147,236,111,
100,83,113,94,126,128,69,101,98,132,44,115,124,124,114,126,45,123,57,145,88,102,
56,149,60,110,153,156,157,158,159,160,161,162,149,142,120,145,165,76,164,168,
148,167,171,152,173,174,54,170,177,125,126,180,178,176,177,179,76,28,107,26,100,
163,34,97,69,69,192,162,74,196,197,163,201,201,155,160,204,196,206,159,208,117,
163,195,204,198,160,200,209,66,161,189,35,147,184,78,183,169,227,228,229,78,189,
191,231,226,62,208,225,186,154,208,108,231,150,212,240,174,238,247,236,181,36,
219,201,217,60,253,35,22,80,224,187,96,111,0,130,226,199,176,161,67,90,219,128,
61,196,49,144,204,68,27,3,139,93,244,144,49,137,175,143,32,67,138,244,149,225,
130,201,147,38,3,51,132,0,0,33,249,4,5,10,0,31,0,44,34,0,7,0,34,0,54,0,0,5,202,
224,39,138,94,105,158,168,57,174,236,154,190,104,43,143,112,237,205,179,13,227,
178,254,242,45,95,10,200,18,198,136,52,163,10,73,82,150,152,77,39,116,74,141,42,
167,206,39,52,123,171,122,191,224,176,120,76,46,155,207,232,244,151,195,230,156,
57,154,140,60,227,94,107,52,245,185,190,62,229,232,229,113,127,114,85,129,130,
134,83,1,126,130,23,134,25,136,138,127,140,135,80,137,141,134,124,76,144,127,
112,43,28,90,80,154,114,158,30,109,163,93,125,123,58,72,92,75,64,172,39,106,177,
76,175,63,69,175,112,119,152,46,172,133,162,61,92,161,190,182,89,141,26,65,92,
197,199,196,134,198,195,78,189,115,186,31,172,193,205,100,112,209,68,144,120,
102,208,116,180,90,193,25,26,224,93,222,114,229,34,231,25,233,31,25,23,240,241,
240,119,244,245,246,247,244,33,0,33,249,4,5,10,0,31,0,44,36,0,13,0,26,0,48,0,0,
5,196,224,39,138,156,102,114,99,170,174,100,230,186,26,43,143,220,107,163,243,
26,104,182,157,235,188,158,235,167,218,9,135,196,84,77,24,75,166,130,55,167,
106,153,209,224,164,88,44,103,123,205,150,162,217,207,177,155,164,246,178,208,
51,54,237,211,30,51,225,177,103,78,247,252,190,175,79,189,46,219,115,57,123,
124,44,129,132,123,125,133,136,42,0,139,136,137,41,139,0,141,30,93,100,31,144,
141,102,46,28,1,131,133,98,71,14,157,132,153,47,26,156,41,152,111,149,57,164,
154,104,76,97,164,171,101,39,78,84,86,97,31,108,25,128,146,83,71,26,146,118,79,
111,194,42,187,46,198,196,71,202,52,114,190,191,54,193,205,74,38,86,194,216,217,
218,219,136,102,171,194,178,43,146,173,188,42,227,170,199,214,234,214,25,23,238,
239,238,112,41,33,0,33,249,4,5,10,0,31,0,44,38,0,5,0,21,0,56,0,0,5,232,224,39,
142,80,52,158,104,202,101,25,151,190,98,166,105,172,11,167,44,171,125,156,125,
139,171,26,173,245,27,245,56,195,93,17,185,11,250,96,131,97,203,89,20,205,106,
181,170,199,99,67,102,127,219,174,231,11,3,132,129,231,159,57,204,217,186,223,
111,145,185,7,175,199,81,109,207,76,249,91,105,182,82,79,48,109,121,71,85,64,68,
135,39,52,127,112,76,26,130,136,132,133,57,58,47,121,34,92,149,57,28,1,153,118,
122,155,57,3,159,118,82,155,164,31,160,161,162,25,169,171,65,155,26,175,171,167,
53,158,170,171,154,58,79,186,160,138,192,193,194,39,190,118,55,73,160,0,0,120,
162,121,111,2,56,173,117,27,203,70,173,45,117,204,173,206,110,218,205,198,39,
215,191,39,177,156,197,110,73,96,231,235,117,71,189,190,167,124,240,162,74,186,
229,149,46,246,215,249,176,251,185,160,247,56,85,177,37,67,81,188,17,231,220,17,
99,199,176,225,186,61,16,35,74,220,19,2,0,59};
static Fl_Image *image_fluid() {
  Fl_GIF_Image::animate = true;
  static Fl_Image *image = NULL;
  if (!image)
    image = new Fl_Anim_GIF_Image("fluid.animated.gif", idata_fluid, 2545);
  return image;
}

static void cb_View(Fl_Button*, void*) {
  show_help("license.html");
}

static void cb_Close(Fl_Return_Button* o, void*) {
  ((Fl_Window*)(o->parent()))->hide();
}

Fl_Double_Window* make_about_panel() {
  static char cbuf[200] = "";
  if (!cbuf[0]) {
    time_t t = time(0);
    struct tm *lt = localtime(&t);
    sprintf(cbuf, "Copyright © 1998 - %d\nby Bill Spitzak and others", lt->tm_year+1900);
  }
  { about_panel = new Fl_Double_Window(345, 180, "About FLUID");
    about_panel->color(FL_LIGHT1);
    about_panel->selection_color(FL_DARK1);
    about_panel->hotspot(about_panel);
    { Fl_Box* o = new Fl_Box(10, 10, 115, 120);
      o->image( image_fluid() );
      ((Fl_Anim_GIF_Image*)(image_fluid()))->canvas(o, Fl_Anim_GIF_Image::DONT_RESIZE_CANVAS);
      ((Fl_Anim_GIF_Image*)(o->image()))->speed(0.5f);
    } // Fl_Box* o
    { Fl_Box* o = new Fl_Box(135, 10, 205, 75, "FLTK User\nInterface Designer\nVersion x.x.x");
      o->color((Fl_Color)12);
      o->selection_color(FL_DARK1);
      o->labelfont(1);
      o->labelsize(18);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE));
      char about[80]; // uses less than 60
      snprintf(about,sizeof(about),"FLTK User\nInterface Designer\nVersion %d.%d.%d",FL_MAJOR_VERSION,FL_MINOR_VERSION,FL_PATCH_VERSION);
      o->copy_label(about);
    } // Fl_Box* o
    { // Label edited dynamically:
      Fl_Box* o = new Fl_Box(135, 90, 200, 45, "(Copyright)");
      o->align(Fl_Align(132|FL_ALIGN_INSIDE));
      o->label(cbuf);
    } // Fl_Box* o
    { Fl_Button* o = new Fl_Button(115, 145, 123, 25, "View License...");
      o->labelcolor(FL_DARK_BLUE);
      o->callback((Fl_Callback*)cb_View);
    } // Fl_Button* o
    { Fl_Return_Button* o = new Fl_Return_Button(250, 145, 83, 25, "Close");
      o->callback((Fl_Callback*)cb_Close);
    } // Fl_Return_Button* o
    about_panel->set_non_modal();
    about_panel->end();
  } // Fl_Double_Window* about_panel
  return about_panel;
}

/**
 Embedded image for internal fluid.html web page.
*/
unsigned char fluid_flow_chart_800_png[41559] = /* data inlined from documentation/src/fluid_flow_chart_800.png */
{137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,3,32,0,0,1,41,8,6,0,0,0,
107,224,70,137,0,0,1,110,105,67,67,80,105,99,99,0,0,40,145,117,145,187,75,195,
80,20,198,127,173,79,172,226,160,131,136,67,6,149,14,22,124,128,56,106,29,92,
138,72,85,176,234,210,196,180,21,210,26,146,20,17,87,193,197,65,112,16,93,124,
13,254,7,186,10,174,10,130,160,8,34,110,238,190,22,41,241,92,83,104,17,189,225,
230,252,248,238,253,14,39,95,32,156,176,140,188,91,59,10,249,130,231,36,39,226,
218,92,106,94,107,120,33,66,61,109,68,25,72,27,174,61,54,53,149,224,223,245,121,
71,72,213,219,152,234,245,255,189,63,87,100,201,116,13,8,53,10,15,27,182,227,9,
203,52,36,86,61,91,241,150,112,187,145,75,47,9,31,10,247,57,50,160,240,149,210,
245,128,159,21,103,3,126,87,236,204,36,199,33,172,122,106,217,42,214,171,216,
200,57,121,225,168,112,119,222,42,26,229,121,212,151,52,155,133,217,105,169,157,
178,187,112,73,50,65,28,13,157,34,203,88,120,196,164,22,36,179,191,125,253,63,
190,73,86,196,99,200,219,102,13,71,28,89,114,226,237,19,181,40,93,77,169,25,209,
77,121,44,214,84,238,191,243,116,51,67,131,65,247,230,56,212,61,249,254,91,15,
52,236,64,105,219,247,191,142,124,191,116,12,53,143,112,81,168,248,87,36,167,
145,15,209,183,43,90,247,1,180,110,192,217,101,69,211,119,225,124,19,58,30,236,
180,147,254,145,106,100,135,51,25,120,61,133,150,20,180,221,64,211,66,144,85,
249,156,147,123,152,89,151,95,116,13,123,251,208,43,247,91,23,191,1,66,94,104,
40,91,243,153,39,0,0,0,9,112,72,89,115,0,0,11,17,0,0,11,17,1,127,100,95,145,0,
0,0,163,116,69,88,116,82,97,119,32,112,114,111,102,105,108,101,32,116,121,112,
101,32,101,120,105,102,0,10,101,120,105,102,10,32,32,32,32,32,32,54,50,10,52,53,
55,56,54,57,54,54,48,48,48,48,52,57,52,57,50,97,48,48,48,56,48,48,48,48,48,48,
48,49,48,48,54,57,56,55,48,52,48,48,48,49,48,48,48,48,48,48,49,97,48,48,48,48,
48,48,48,48,48,48,48,48,48,48,48,50,48,48,48,50,97,48,10,48,52,48,48,48,49,48,
48,48,48,48,48,102,54,48,54,48,48,48,48,48,51,97,48,48,52,48,48,48,49,48,48,48,
48,48,48,57,54,48,50,48,48,48,48,48,48,48,48,48,48,48,48,10,88,22,108,60,0,0,0,
90,116,69,88,116,82,97,119,32,112,114,111,102,105,108,101,32,116,121,112,101,
32,105,112,116,99,0,10,105,112,116,99,10,32,32,32,32,32,32,50,54,10,53,48,54,
56,54,102,55,52,54,102,55,51,54,56,54,102,55,48,50,48,51,51,50,101,51,48,48,48,
51,56,52,50,52,57,52,100,48,52,48,52,48,48,48,48,48,48,48,48,48,48,48,48,10,
199,209,105,220,0,0,19,85,116,69,88,116,82,97,119,32,112,114,111,102,105,108,
101,32,116,121,112,101,32,120,109,112,0,10,120,109,112,10,32,32,32,32,50,52,50,
51,10,51,99,51,102,55,56,55,48,54,49,54,51,54,98,54,53,55,52,50,48,54,50,54,53,
54,55,54,57,54,101,51,100,50,50,101,102,98,98,98,102,50,50,50,48,54,57,54,52,
51,100,50,50,53,55,51,53,52,100,51,48,52,100,55,48,52,51,54,53,54,56,54,57,10,
52,56,55,97,55,50,54,53,53,51,55,97,52,101,53,52,54,51,55,97,54,98,54,51,51,57,
54,52,50,50,51,102,51,101,48,97,51,99,55,56,51,97,55,56,54,100,55,48,54,100,54,
53,55,52,54,49,50,48,55,56,54,100,54,99,54,101,55,51,51,97,55,56,10,51,100,50,
50,54,49,54,52,54,102,54,50,54,53,51,97,54,101,55,51,51,97,54,100,54,53,55,52,
54,49,50,102,50,50,50,48,55,56,51,97,55,56,54,100,55,48,55,52,54,98,51,100,50,
50,53,56,52,100,53,48,50,48,52,51,54,102,55,50,54,53,50,48,10,51,52,50,101,51,
52,50,101,51,48,50,100,52,53,55,56,54,57,55,54,51,50,50,50,51,101,48,97,50,48,
51,99,55,50,54,52,54,54,51,97,53,50,52,52,52,54,50,48,55,56,54,100,54,99,54,
101,55,51,51,97,55,50,54,52,54,54,51,100,50,50,54,56,10,55,52,55,52,55,48,51,97,
50,102,50,102,55,55,55,55,55,55,50,101,55,55,51,51,50,101,54,102,55,50,54,55,
50,102,51,49,51,57,51,57,51,57,50,102,51,48,51,50,50,102,51,50,51,50,50,100,55,
50,54,52,54,54,50,100,55,51,55,57,54,101,55,52,10,54,49,55,56,50,100,54,101,55,
51,50,51,50,50,51,101,48,97,50,48,50,48,51,99,55,50,54,52,54,54,51,97,52,52,54,
53,55,51,54,51,55,50,54,57,55,48,55,52,54,57,54,102,54,101,50,48,55,50,54,52,
54,54,51,97,54,49,54,50,54,102,55,53,10,55,52,51,100,50,50,50,50,48,97,50,48,
50,48,50,48,50,48,55,56,54,100,54,99,54,101,55,51,51,97,54,53,55,56,54,57,54,
54,51,100,50,50,54,56,55,52,55,52,55,48,51,97,50,102,50,102,54,101,55,51,50,
101,54,49,54,52,54,102,54,50,54,53,10,50,101,54,51,54,102,54,100,50,102,54,53,
55,56,54,57,54,54,50,102,51,49,50,101,51,48,50,102,50,50,48,97,50,48,50,48,50,
48,54,53,55,56,54,57,54,54,51,97,53,48,54,57,55,56,54,53,54,99,53,56,52,52,54,
57,54,100,54,53,54,101,55,51,10,54,57,54,102,54,101,51,100,50,50,51,49,51,55,
51,56,51,50,50,50,48,97,50,48,50,48,50,48,54,53,55,56,54,57,54,54,51,97,53,48,
54,57,55,56,54,53,54,99,53,57,52,52,54,57,54,100,54,53,54,101,55,51,54,57,54,
102,54,101,51,100,50,50,10,51,54,51,54,51,50,50,50,50,102,51,101,48,97,50,48,51,
99,50,102,55,50,54,52,54,54,51,97,53,50,52,52,52,54,51,101,48,97,51,99,50,102,
55,56,51,97,55,56,54,100,55,48,54,100,54,53,55,52,54,49,51,101,48,97,50,48,50,
48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,10,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,48,97,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,
97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,10,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,
48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,
97,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
10,50,48,50,48,50,48,50,48,50,48,50,48,48,97,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,10,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,
48,50,48,50,48,50,48,50,48,48,97,10,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,50,48,
50,48,50,48,50,48,50,48,50,48,50,48,50,48,48,97,51,99,51,102,55,56,55,48,54,49,
54,51,54,98,54,53,10,55,52,50,48,54,53,54,101,54,52,51,100,50,50,55,55,50,50,
51,102,51,101,10,162,250,209,144,0,0,32,0,73,68,65,84,120,94,236,221,7,88,20,
199,251,7,240,57,122,81,20,81,81,236,96,5,197,222,27,246,222,107,108,49,49,150,
159,61,26,141,105,127,53,150,88,18,99,139,189,247,222,123,5,197,216,69,80,172,
128,8,82,21,145,222,217,255,188,43,103,8,65,6,241,238,56,184,239,231,121,230,
185,54,123,28,123,123,59,243,238,52,133,36,73,12,0,0,0,0,0,64,19,244,68,25,0,0,
0,0,0,0,84,5,1,8,0,0,0,0,0,104,12,2,16,0,0,0,0,0,208,24,4,32,0,0,0,0,0,160,49,
8,64,0,0,0,0,0,64,99,12,68,25,136,66,161,16,101,1,0,0,80,185,62,125,250,212,
113,117,117,181,141,140,140,180,138,139,139,43,204,159,42,196,147,5,79,5,120,50,
79,75,102,105,201,148,39,227,116,201,40,237,214,144,189,47,239,242,122,97,150,
202,83,18,79,137,105,41,33,237,54,62,45,197,241,20,147,118,27,157,118,63,138,
167,72,61,61,189,119,133,10,21,10,183,182,182,14,155,50,101,202,173,81,163,70,
133,102,246,7,0,0,62,87,118,102,216,85,100,43,19,2,16,0,0,208,160,211,167,79,
151,92,185,114,229,239,215,174,93,235,245,238,221,59,83,19,19,19,102,96,144,173,
107,102,144,9,42,235,227,227,227,89,106,106,42,179,181,181,125,209,183,111,223,
5,220,122,94,190,139,43,1,0,0,159,32,59,177,5,206,230,0,0,160,85,60,60,60,204,
126,252,241,199,109,231,207,159,111,91,170,84,41,246,195,15,63,176,142,29,59,50,
75,75,75,209,166,240,17,41,41,41,236,233,211,167,108,235,214,173,108,223,190,
125,21,118,238,220,185,150,7,35,177,252,165,29,162,109,1,0,84,142,162,20,81,2,0,
0,208,148,62,156,169,169,169,100,103,103,39,185,187,187,75,160,58,60,232,144,
126,251,237,55,42,216,37,91,91,91,247,213,171,87,23,22,125,31,0,0,159,66,202,78,
108,33,202,32,33,0,1,0,0,13,178,176,176,248,75,95,95,95,58,120,240,96,198,250,
51,168,0,5,33,157,58,117,146,244,244,244,82,120,144,87,67,244,125,0,0,124,10,
41,27,177,5,102,193,2,0,0,173,18,25,25,105,92,161,66,5,214,174,93,59,81,86,200,
1,26,215,57,120,240,96,26,15,34,133,134,134,154,137,242,3,0,168,26,2,16,0,0,
208,26,134,134,134,52,235,137,169,149,149,21,43,88,176,160,40,59,228,80,185,114,
229,232,70,17,29,29,141,0,4,0,52,14,1,8,0,0,104,141,148,148,20,125,126,99,130,
217,23,213,43,109,255,210,76,152,166,162,188,0,0,170,134,89,176,0,0,64,107,164,
166,166,210,133,49,99,9,227,15,53,129,162,16,19,81,38,0,128,79,145,157,11,72,
104,1,1,0,0,109,66,229,146,145,40,19,168,140,177,40,3,0,128,170,33,0,1,0,0,109,
34,183,128,100,231,10,26,168,4,130,61,0,208,56,4,32,0,0,160,77,168,92,50,20,
101,2,149,65,11,8,0,104,28,2,16,0,0,208,38,212,244,129,0,68,115,176,175,1,64,
227,16,128,0,0,128,54,65,11,136,102,161,5,4,0,52,14,1,8,0,0,104,19,4,32,154,133,
125,13,0,26,135,0,4,0,0,180,9,117,193,194,20,241,154,131,125,13,0,26,135,0,4,0,
0,180,9,2,16,205,194,190,6,0,141,67,0,2,0,0,218,4,1,136,102,97,95,3,128,198,
225,196,3,0,249,218,205,155,55,205,198,142,29,235,228,230,230,86,128,63,52,72,
77,77,165,62,239,148,104,240,45,173,129,96,146,118,223,36,195,125,229,235,198,
233,238,231,214,57,51,133,167,228,116,183,148,146,210,221,38,166,165,132,116,41,
78,161,80,196,25,27,27,199,154,153,153,197,244,238,221,219,107,195,134,13,55,
50,125,119,237,66,1,136,190,40,19,168,12,246,53,0,104,92,110,21,166,0,0,106,37,
73,146,105,175,94,189,90,245,235,215,239,151,224,224,224,70,252,49,43,88,176,
32,51,52,212,173,49,183,137,137,137,236,237,219,183,236,228,201,147,113,3,7,14,
252,118,247,238,221,107,181,124,145,63,4,32,154,133,122,0,0,104,28,78,60,0,144,
47,141,26,53,106,220,141,27,55,22,240,224,67,191,75,151,46,108,240,224,193,172,
102,205,154,204,202,202,138,233,233,233,70,239,211,212,212,84,22,18,18,194,14,
29,58,196,230,207,159,111,122,229,202,149,49,60,237,224,47,197,136,182,205,69,
8,64,52,11,245,0,0,208,60,186,42,40,74,0,0,121,201,136,17,35,90,91,90,90,70,
152,152,152,72,155,55,111,150,82,82,82,36,93,215,188,121,115,201,208,208,240,
109,187,118,237,236,68,251,47,151,149,224,233,77,163,70,141,68,255,18,124,6,87,
87,87,42,220,41,45,21,124,31,0,0,42,167,27,151,1,1,64,103,220,184,113,195,248,
234,213,171,179,35,34,34,44,22,44,88,192,134,15,31,174,51,45,30,31,147,156,156,
204,120,16,70,251,33,186,80,161,66,241,162,252,90,64,171,251,136,229,51,216,215,
0,160,113,186,93,42,3,64,190,243,219,111,191,181,241,243,243,107,220,162,69,
11,234,134,37,202,174,19,188,189,189,153,167,167,39,5,32,207,86,173,90,21,34,
202,15,0,0,160,78,8,64,0,32,95,225,149,237,225,241,241,241,250,95,126,249,37,51,
53,53,21,101,215,9,167,79,159,102,17,17,17,204,214,214,214,189,120,241,226,201,
162,252,0,0,0,234,132,0,4,0,242,141,153,51,103,150,11,8,8,104,93,182,108,89,214,
181,107,87,81,118,157,16,19,19,195,118,239,222,205,204,205,205,83,235,212,169,
115,80,148,31,0,0,64,221,16,128,0,64,190,113,231,206,157,161,225,225,225,86,61,
122,244,96,69,139,22,21,101,215,9,183,110,221,98,119,239,222,101,214,214,214,
183,182,109,219,230,38,202,15,0,0,160,110,8,64,0,32,95,152,55,111,158,177,135,
135,71,7,35,35,35,54,112,224,64,81,118,157,177,119,239,94,249,214,202,202,106,3,
45,76,40,200,14,0,0,160,118,8,64,0,32,95,184,121,243,166,67,112,112,112,195,
250,245,235,179,186,117,235,138,178,235,132,160,160,32,118,226,196,9,90,128,241,
205,144,33,67,206,137,242,3,0,0,104,2,2,16,0,200,243,36,73,82,4,4,4,12,79,74,74,
50,236,219,183,47,51,54,54,22,109,162,19,206,159,63,207,248,126,97,14,14,14,
247,38,77,154,228,47,202,15,0,0,160,9,8,64,0,32,207,91,176,96,65,17,127,127,255,
62,150,150,150,140,198,127,0,147,215,253,160,193,231,10,133,34,169,92,185,114,
127,137,242,3,0,0,104,10,2,16,0,200,211,36,73,98,174,174,174,61,222,188,121,83,
162,67,135,14,172,66,133,10,162,77,116,194,131,7,15,216,213,171,87,89,217,178,
101,95,180,104,209,226,162,40,63,0,0,128,166,32,0,1,128,188,78,241,234,213,171,
17,10,133,66,111,208,160,65,162,188,58,227,224,193,131,52,5,175,84,170,84,169,
29,99,198,140,137,17,229,7,0,0,208,20,4,32,0,144,167,141,26,53,170,154,143,143,
143,131,173,173,45,115,114,114,18,101,215,9,209,209,209,114,0,82,160,64,129,56,
27,27,155,221,162,252,0,0,0,154,132,0,4,0,242,180,219,183,111,119,137,138,138,
42,212,191,127,127,154,237,73,148,93,39,92,185,114,133,61,126,252,152,241,224,
227,218,254,253,251,125,69,249,1,0,0,52,9,1,8,0,228,89,59,118,236,176,124,251,
246,237,87,230,230,230,140,102,191,130,247,99,98,118,238,220,201,244,245,245,89,
195,134,13,143,43,20,138,100,209,54,0,0,0,154,132,0,4,0,242,172,109,219,182,213,
9,13,13,173,214,162,69,11,86,189,122,117,81,118,157,224,235,235,203,206,156,
57,195,44,44,44,124,235,215,175,191,71,148,31,0,0,64,211,16,128,0,64,158,245,
252,249,243,1,241,241,241,108,192,128,1,204,192,192,64,148,93,39,28,63,126,156,
189,125,251,150,85,174,92,249,226,196,137,19,95,139,242,3,0,0,104,26,2,16,0,200,
147,166,76,153,82,252,205,155,55,157,75,151,46,205,58,118,236,40,202,174,19,40,
24,219,179,103,15,13,62,151,26,54,108,120,72,148,31,0,0,32,55,32,0,1,128,60,
233,238,221,187,253,163,162,162,74,117,237,218,149,89,91,91,139,178,235,132,219,
183,111,179,59,119,238,48,30,148,61,250,253,247,223,175,136,242,3,0,0,228,6,4,
32,0,144,231,172,92,185,210,216,219,219,187,183,161,161,33,195,218,31,255,216,
191,127,191,188,2,186,141,141,205,54,35,35,163,104,81,126,0,0,128,220,128,0,4,0,
180,142,191,191,191,105,86,175,223,187,119,175,197,155,55,111,154,214,174,93,
155,213,175,95,63,171,172,185,38,57,89,179,147,79,133,132,132,176,163,71,143,50,
75,75,203,136,158,61,123,158,16,229,207,77,15,31,62,52,146,36,9,229,15,0,128,
142,66,1,0,0,90,199,221,221,189,205,215,95,127,61,110,193,130,5,153,46,236,113,
235,214,173,118,241,241,241,70,253,250,245,99,38,38,38,153,101,201,53,175,95,
191,102,255,251,223,255,216,190,125,251,228,233,112,105,70,42,63,63,63,246,251,
239,191,203,173,19,234,114,233,210,37,249,239,240,0,228,212,132,9,19,30,137,242,
231,38,125,125,253,178,191,254,250,235,98,254,57,237,69,121,243,139,216,216,88,
54,107,214,44,22,20,20,196,46,95,190,204,182,111,223,46,218,4,0,32,223,66,0,2,
0,90,231,229,203,151,87,220,220,220,198,46,91,182,204,181,91,183,110,35,188,
189,189,63,4,34,51,102,204,48,9,12,12,236,85,184,112,97,214,187,119,239,172,222,
38,87,92,187,118,141,174,240,203,171,178,151,43,87,142,186,67,49,254,121,229,
217,169,82,83,83,69,155,231,8,189,239,182,109,219,152,66,161,72,169,87,175,222,
65,126,43,218,36,87,149,44,89,210,251,209,163,71,150,251,247,239,191,222,190,
125,251,229,139,23,47,174,44,218,38,175,163,117,89,104,170,104,90,179,198,195,
195,131,93,189,122,85,180,9,0,64,190,133,0,4,0,180,206,184,113,227,34,107,213,
170,181,32,34,34,194,241,194,133,11,27,218,181,107,119,165,123,247,238,223,196,
197,197,89,132,133,133,125,29,21,21,85,158,63,199,108,109,109,69,111,149,45,49,
49,49,236,143,63,254,144,167,243,253,229,151,95,216,187,119,239,216,161,67,135,
104,161,67,249,117,90,91,131,90,48,220,221,221,217,252,249,243,229,215,201,95,
127,253,37,15,252,86,10,13,13,149,3,129,200,200,72,230,229,229,197,18,18,18,88,
98,98,162,92,249,164,150,26,10,12,232,241,134,13,27,216,136,17,35,216,130,5,11,
88,120,120,120,166,159,233,83,208,170,231,84,161,229,251,35,136,7,108,46,162,
252,185,141,7,143,82,143,30,61,22,154,154,154,74,252,251,157,176,124,249,242,27,
20,136,240,239,160,26,15,216,146,120,22,73,244,30,170,116,243,230,77,54,106,
212,40,54,108,216,48,118,246,236,89,249,57,250,142,231,205,155,39,31,19,115,230,
204,145,167,54,166,239,110,197,138,21,242,177,49,97,194,4,182,110,221,58,118,
253,250,117,54,126,252,120,246,253,247,223,203,173,95,252,216,100,171,87,175,
150,91,192,70,142,28,201,22,45,90,196,162,163,163,153,158,158,158,124,156,81,43,
24,141,93,50,50,50,146,255,206,147,39,79,216,244,233,211,229,86,179,243,231,
207,103,245,49,1,0,242,13,4,32,0,160,54,6,6,6,116,142,161,5,58,140,121,162,113,
29,5,120,178,224,201,82,148,120,176,113,185,108,217,178,158,252,150,249,248,
248,212,226,149,179,245,13,27,54,188,251,232,209,163,37,146,36,25,124,241,197,
23,153,253,201,79,70,43,135,83,69,243,239,191,255,102,99,199,142,165,191,197,
126,251,237,55,86,177,98,69,57,216,112,117,117,101,63,255,252,51,227,193,144,
252,28,205,50,69,193,202,225,195,135,217,174,93,187,88,153,50,101,62,188,87,129,
2,5,88,149,42,85,228,86,143,242,229,203,203,99,50,104,123,90,163,132,254,14,5,
34,75,150,44,97,23,47,94,148,43,187,20,176,80,69,246,115,199,139,28,60,120,80,
174,220,86,168,80,225,218,119,223,125,71,205,44,194,253,155,219,105,208,160,65,
193,85,171,86,61,68,251,196,223,223,223,242,210,165,75,19,150,46,93,234,202,247,
231,18,246,254,152,209,136,231,207,159,203,223,123,147,38,77,24,15,114,229,64,
226,217,179,103,242,119,78,221,165,166,76,153,34,183,96,77,157,58,149,209,177,
72,1,197,233,211,167,229,169,159,255,252,243,79,185,91,21,5,195,158,158,158,
108,213,170,85,242,84,200,63,253,244,19,115,113,113,97,212,69,144,90,196,232,56,
74,74,74,98,107,215,174,149,131,20,10,70,232,152,120,243,230,13,5,219,204,206,
206,142,209,108,110,51,103,206,100,231,206,157,19,125,100,85,163,223,166,240,
251,74,75,133,120,162,214,72,51,158,168,239,35,69,81,250,252,119,170,221,77,110,
0,160,117,52,118,146,7,128,252,141,87,196,106,159,57,115,166,175,175,175,175,
69,241,226,197,13,121,133,56,153,87,198,140,121,197,203,132,87,176,141,121,162,
91,211,148,148,20,19,158,140,233,74,176,68,181,242,143,216,179,103,79,10,175,
208,23,87,62,166,202,159,135,135,71,69,186,95,185,114,101,214,170,85,171,143,
109,250,73,232,74,55,85,40,215,175,95,207,234,213,171,199,170,85,171,198,30,60,
120,192,28,29,29,229,43,219,116,5,188,65,131,6,236,199,31,127,100,166,166,166,
108,241,226,197,172,79,159,62,242,122,27,91,183,110,101,37,74,148,248,240,94,
102,102,102,172,70,141,26,242,213,114,94,41,147,3,14,229,2,137,116,159,158,63,
112,224,128,124,181,155,174,128,55,107,214,140,241,128,65,110,97,161,224,38,39,
40,240,160,217,175,44,45,45,89,112,112,112,187,196,196,196,235,252,62,237,218,
84,46,253,45,221,145,248,119,144,156,182,219,165,12,183,25,239,171,29,15,58,44,
148,247,41,8,227,129,72,17,254,63,12,163,199,154,234,70,70,93,227,40,0,24,62,
124,184,252,152,31,187,114,96,120,255,254,125,57,200,44,86,172,24,77,107,204,
186,117,235,38,143,177,41,90,180,40,155,52,105,146,220,157,138,142,1,154,4,161,
71,143,30,114,171,215,201,147,39,229,224,130,182,161,64,134,142,1,234,42,56,
121,242,100,249,88,82,182,130,17,106,5,161,96,131,254,111,58,102,104,59,58,6,
246,238,221,203,218,183,111,159,197,39,86,185,158,60,213,206,42,3,125,102,254,
249,244,248,49,156,196,83,60,37,126,92,43,83,2,63,102,18,248,111,50,217,216,216,
216,144,7,109,113,13,27,54,12,236,213,171,215,238,111,190,249,198,63,171,247,5,
0,221,133,0,4,0,62,11,205,102,212,182,109,219,63,14,29,58,52,156,87,188,158,
181,105,211,230,162,131,131,195,83,94,249,122,201,43,36,113,60,0,73,228,129,72,
34,15,32,18,163,162,162,146,120,37,60,145,87,228,18,255,254,251,239,36,126,251,
209,65,17,11,22,44,40,178,123,247,238,139,238,238,238,197,232,113,193,130,5,229,
254,243,188,130,202,250,246,237,43,87,236,84,129,186,199,80,165,187,72,145,34,
242,99,170,128,82,96,64,104,150,45,186,250,77,21,84,10,62,8,181,120,80,75,71,88,
88,152,28,172,100,68,21,202,244,131,205,149,21,122,170,196,209,223,162,138,234,
173,91,183,228,43,239,244,28,181,132,208,251,229,20,181,176,208,152,147,38,77,
154,60,94,189,122,245,232,215,175,95,71,243,125,158,194,3,145,148,132,132,132,
228,180,219,84,190,255,83,120,176,146,226,230,230,22,207,239,75,177,177,177,18,
127,44,209,253,180,199,20,204,72,252,51,74,212,117,76,221,168,133,168,110,221,
186,27,142,29,59,86,149,30,83,160,102,107,107,27,85,170,84,169,163,151,47,95,
238,202,247,155,106,190,96,1,58,158,248,223,252,240,152,190,123,106,229,226,199,
174,124,188,17,250,108,244,93,209,126,161,227,160,80,161,66,242,243,20,68,210,
113,169,164,28,227,67,207,89,89,89,201,247,41,48,164,96,131,94,75,31,220,209,
251,209,223,166,46,120,202,241,65,116,108,81,48,162,97,135,121,154,158,85,6,254,
219,80,240,64,203,128,7,72,70,252,55,110,104,97,97,97,196,131,109,67,30,80,241,
93,96,100,200,3,18,67,126,220,88,60,123,246,172,252,203,151,47,107,241,244,245,
95,127,253,53,133,159,11,126,186,120,241,226,198,172,222,27,0,116,19,2,16,0,
200,177,169,83,167,26,242,74,201,242,74,149,42,13,235,212,169,211,128,133,11,23,
170,108,250,87,94,145,30,238,229,229,101,71,149,64,94,49,245,236,220,185,243,33,
23,23,151,233,188,194,102,76,1,200,231,162,105,107,169,18,72,129,7,85,42,233,
138,55,141,41,161,49,28,52,72,248,215,95,127,149,187,225,208,45,117,165,162,110,
83,188,66,197,150,46,93,42,183,122,80,87,43,106,21,161,113,32,116,245,90,132,
42,152,84,41,165,69,19,249,255,34,95,53,167,150,15,234,150,195,43,116,162,205,
51,69,239,73,221,192,168,117,133,127,166,21,53,107,214,204,51,35,155,215,175,
95,223,112,220,184,113,221,40,88,227,199,80,36,15,70,246,245,238,221,123,197,
204,153,51,95,241,151,59,137,182,87,21,170,240,83,235,23,5,142,212,202,70,99,
115,104,60,8,5,27,212,21,171,86,173,90,242,177,65,65,4,117,173,75,107,185,147,
183,165,219,140,45,70,244,152,186,89,81,43,90,163,70,141,228,174,125,20,212,82,
80,146,62,47,189,15,5,176,244,252,220,185,115,229,239,144,198,142,40,3,93,13,
162,104,51,42,171,12,20,108,211,108,110,217,197,255,79,163,177,99,199,78,229,
251,96,109,229,202,149,245,249,126,92,39,218,6,0,116,11,2,16,0,200,17,106,249,
224,65,199,252,114,229,202,13,227,21,168,238,245,234,213,187,40,218,38,187,78,
156,56,81,124,222,188,121,83,121,197,205,179,69,139,22,171,150,45,91,182,139,87,
10,29,238,220,185,243,83,235,214,173,85,114,149,152,191,167,124,5,155,250,240,
83,159,125,26,16,78,149,44,234,203,79,253,252,151,47,95,46,7,11,52,40,189,66,
133,10,242,56,17,170,36,82,23,42,154,66,149,186,217,208,56,0,218,134,2,10,37,
186,90,78,87,207,9,189,63,85,92,41,64,81,94,81,167,191,69,99,2,46,92,184,32,15,
64,238,217,179,167,220,117,43,39,40,128,225,251,138,130,143,119,195,134,13,187,
64,131,163,243,2,94,161,213,251,254,251,239,103,196,199,199,167,12,28,56,112,
83,191,126,253,150,247,234,213,203,157,186,31,113,212,167,77,51,253,175,56,254,
119,229,174,80,252,115,200,1,29,125,175,45,91,182,100,95,126,249,165,60,62,135,
90,193,40,0,153,49,99,134,28,172,210,247,168,236,70,69,247,233,251,37,233,191,
119,66,199,19,189,23,181,78,209,152,33,58,22,232,117,229,248,15,122,15,26,59,66,
221,188,250,247,239,47,183,148,208,152,19,58,238,52,76,229,251,154,255,111,137,
252,230,183,157,59,119,38,242,223,217,42,30,212,189,219,184,113,227,62,209,118,
0,160,67,148,87,112,178,74,0,0,25,241,74,186,189,163,163,227,219,49,99,198,
168,124,46,92,94,33,236,55,121,242,228,169,188,66,42,55,13,240,243,144,65,227,
198,141,143,208,221,77,155,54,73,170,240,250,245,107,233,205,155,55,31,30,191,
124,249,82,114,118,118,150,2,2,2,228,199,175,94,189,146,187,35,41,249,249,249,
73,33,33,33,82,112,112,240,191,222,131,82,122,180,13,175,96,203,247,223,190,
125,43,69,70,70,82,151,38,121,91,229,88,140,23,47,94,72,60,112,144,120,0,34,125,
14,94,89,165,19,180,212,189,123,119,141,143,92,254,28,252,255,174,186,100,201,
146,117,75,151,46,173,147,201,203,20,128,132,53,106,212,72,244,239,171,12,125,
63,215,175,95,151,110,221,186,37,189,31,34,243,30,15,70,165,147,39,79,202,223,
23,73,73,73,145,120,144,32,37,37,37,201,143,233,248,137,138,138,146,239,211,
247,78,199,2,29,55,60,24,151,124,124,124,164,139,23,47,254,107,91,58,118,104,91,
218,70,121,140,208,99,87,87,87,137,31,243,114,151,56,77,161,191,201,222,207,54,
182,44,147,239,64,101,120,112,254,27,223,31,30,92,206,251,25,2,64,254,35,33,0,1,
128,28,168,93,187,246,88,39,39,167,231,252,28,161,242,150,84,94,57,251,231,82,
50,247,243,207,63,219,89,91,91,71,217,216,216,124,8,16,116,93,98,98,162,212,
162,69,11,201,216,216,56,101,214,172,89,170,153,18,76,67,30,60,120,96,152,197,
203,26,15,64,84,137,2,89,7,7,7,121,92,141,54,211,84,0,178,123,247,110,187,250,
245,235,71,54,107,214,44,203,129,238,0,160,91,196,29,151,1,0,50,17,24,24,104,97,
105,105,233,162,80,40,62,111,14,217,76,88,89,89,125,24,5,205,235,74,116,197,124,
80,72,72,72,129,46,93,186,200,253,240,129,201,235,143,208,250,21,21,43,86,244,
159,58,117,234,113,81,126,109,82,163,70,141,36,81,158,188,138,186,93,81,55,42,
229,236,103,186,110,224,192,129,47,205,204,204,30,241,160,179,144,40,47,0,232,
14,4,32,0,144,35,22,22,22,198,213,170,85,123,42,202,247,185,30,61,122,100,230,
227,227,51,152,42,116,170,90,251,35,63,160,169,119,105,160,180,131,131,195,190,
130,5,11,70,139,242,131,102,208,32,114,26,167,132,0,228,61,186,64,81,169,82,37,
47,125,125,125,116,193,2,128,15,16,128,0,64,142,68,69,69,41,120,16,226,43,202,
247,185,254,250,235,175,70,222,222,222,229,105,224,121,227,198,141,69,217,117,2,
205,178,116,228,200,17,26,184,28,89,179,102,205,205,162,252,0,185,73,79,79,207,
155,159,47,52,62,189,23,0,104,47,4,32,0,144,35,137,137,137,198,10,133,66,237,11,
70,220,185,115,167,91,100,100,164,49,205,82,68,11,185,1,99,206,206,206,242,12,
88,213,170,85,187,251,227,143,63,122,137,242,3,228,166,148,148,148,132,164,164,
36,4,32,0,240,1,2,16,0,200,17,90,209,156,7,33,106,237,203,127,234,212,169,50,
175,95,191,254,130,166,40,165,233,82,225,253,218,31,59,118,236,144,167,127,109,
209,162,197,73,30,4,170,245,59,0,248,92,180,32,38,191,193,213,3,0,248,0,1,8,0,
228,8,175,8,27,165,85,44,212,102,211,166,77,78,129,129,129,214,109,219,182,101,
149,42,85,18,101,215,9,180,56,222,165,75,151,104,245,110,255,214,173,91,239,17,
229,7,200,109,180,222,11,191,49,18,229,3,0,221,129,0,4,0,114,132,7,32,134,234,
12,64,36,73,82,60,120,240,160,95,82,82,18,27,48,96,128,40,187,206,160,193,231,
209,209,209,52,147,212,133,246,237,219,7,136,242,3,228,182,180,243,196,191,166,
214,6,0,221,134,0,4,0,114,132,7,8,106,13,64,126,249,229,151,42,193,193,193,45,
108,109,109,153,147,147,147,40,187,78,136,140,140,148,87,98,167,46,105,109,218,
180,57,44,202,15,160,13,18,19,19,233,60,129,22,16,0,248,0,1,8,0,228,72,90,11,72,
138,40,95,78,221,189,123,119,88,68,68,68,161,158,61,123,178,34,69,138,136,178,
235,132,107,215,174,49,15,15,15,86,181,106,85,175,73,147,38,93,19,229,7,208,6,
60,0,65,23,44,0,248,23,4,32,0,144,35,212,2,146,214,183,91,229,120,69,187,224,
227,199,143,187,25,27,27,99,237,143,52,180,32,227,190,125,251,152,190,190,62,
171,92,185,242,22,133,66,241,86,180,13,128,54,72,72,72,72,101,8,64,0,32,29,4,32,
0,144,35,188,66,108,160,174,0,228,240,225,195,93,131,130,130,170,55,105,210,
132,57,58,58,138,178,235,4,63,63,63,118,250,244,105,90,9,62,186,127,255,254,39,
68,249,1,180,69,90,11,136,161,40,31,0,232,14,4,32,0,144,19,10,10,64,226,226,
226,84,30,128,60,121,242,196,192,197,197,165,43,173,242,61,104,208,32,172,40,
157,230,212,169,83,44,36,36,132,149,43,87,238,84,231,206,157,61,68,249,1,180,69,
90,87,77,252,144,1,224,3,4,32,0,144,35,234,10,64,86,175,94,93,204,219,219,187,
173,181,181,53,235,212,169,147,40,187,78,160,153,192,118,239,222,77,11,49,166,
52,105,210,228,176,66,161,144,68,219,0,104,139,196,196,68,234,130,133,0,4,0,62,
64,0,2,0,57,65,45,32,250,241,241,241,42,175,8,123,121,121,245,13,15,15,47,222,
185,115,103,90,235,66,148,93,39,184,185,185,177,155,55,111,210,224,243,224,113,
227,198,93,18,229,7,208,38,8,64,0,32,35,4,32,0,144,83,250,170,110,1,137,140,140,
52,240,245,245,29,70,3,173,49,248,252,31,52,248,156,87,226,104,60,204,177,178,
101,203,190,22,229,7,208,38,8,64,0,32,35,4,32,0,144,35,212,2,194,3,144,84,81,
190,79,49,114,228,200,58,60,0,169,86,189,122,117,214,188,121,115,81,118,157,16,
26,26,202,14,29,58,196,172,172,172,18,234,214,173,187,9,221,175,32,175,73,74,
74,66,0,2,0,255,130,0,4,0,114,66,238,130,21,27,27,171,210,0,228,209,163,71,117,
249,123,154,211,218,31,38,38,38,162,236,58,225,196,137,19,236,197,139,23,204,
222,222,222,109,226,196,137,15,69,249,1,180,77,90,0,130,250,6,0,124,128,19,2,0,
228,148,158,170,3,144,184,184,184,218,180,246,71,235,214,173,69,89,117,66,96,96,
32,155,55,111,30,43,84,168,16,107,213,170,213,10,133,66,17,47,218,6,64,219,36,
38,38,82,171,157,190,40,31,0,232,14,4,32,0,144,35,18,199,3,6,149,118,7,138,143,
143,47,162,167,167,199,204,205,205,69,89,243,61,47,47,47,54,116,232,80,185,245,
195,209,209,113,239,236,217,179,15,138,182,1,208,70,105,45,32,0,0,31,104,91,159,
76,10,136,20,233,110,51,75,44,147,199,185,69,74,75,233,239,103,150,82,211,221,
2,228,27,209,209,209,42,61,166,43,85,170,244,196,197,197,69,190,234,63,99,198,
12,102,107,107,203,12,13,117,103,253,50,30,208,201,1,199,133,11,23,216,186,117,
235,152,191,191,63,43,93,186,244,62,158,134,43,20,138,4,209,246,249,136,74,3,91,
200,146,218,247,53,2,16,0,200,40,87,2,144,35,71,142,20,90,181,106,85,191,107,
215,174,85,136,141,141,53,147,36,201,148,63,109,146,150,140,50,36,195,180,100,
144,46,233,167,37,186,159,91,173,56,116,66,77,73,75,201,233,110,41,37,241,148,
152,238,150,18,117,157,8,76,187,149,243,215,169,83,39,120,225,194,133,59,219,
181,107,23,243,223,183,7,208,126,169,169,170,173,87,52,107,214,108,79,112,112,
240,224,67,135,14,149,63,115,230,12,43,92,184,48,163,22,17,93,145,156,156,204,
34,34,34,228,64,196,202,202,42,185,85,171,86,187,251,247,239,63,230,127,255,
251,159,46,117,189,194,197,26,205,82,251,190,230,101,188,40,11,0,232,24,141,6,
32,252,36,100,200,11,210,182,211,166,77,251,221,203,203,203,158,78,74,37,75,
150,100,22,22,22,140,166,221,204,239,148,39,97,90,225,153,250,118,123,120,120,
176,95,126,249,165,207,221,187,119,123,212,173,91,87,151,42,24,0,153,154,51,103,
206,195,37,75,150,180,219,189,123,119,31,95,95,223,50,252,119,82,156,253,251,2,
132,126,38,73,239,35,73,19,173,164,230,6,6,6,5,120,224,16,204,178,247,183,168,
178,151,244,177,196,207,131,201,21,42,84,72,182,183,183,127,91,191,126,253,67,
252,252,112,241,242,229,203,89,188,93,190,132,0,68,179,176,175,1,64,243,168,82,
44,74,170,50,116,232,208,46,182,182,182,146,158,158,158,212,179,103,79,233,228,
201,147,82,64,64,128,68,3,212,82,83,83,117,38,69,69,69,73,87,175,94,149,106,212,
168,65,251,34,166,125,251,246,182,162,125,7,160,101,168,226,127,133,167,10,162,
140,185,224,99,221,55,85,154,248,121,75,209,181,107,215,117,60,80,240,228,172,
68,249,211,37,200,26,5,157,65,141,26,53,146,64,125,92,93,93,149,93,132,23,9,
190,15,85,232,197,211,118,81,38,0,208,29,26,235,219,176,96,193,2,199,203,151,47,
111,162,62,205,127,254,249,39,59,112,224,0,163,149,142,109,108,108,228,62,222,
10,133,66,103,82,129,2,5,168,171,137,188,208,26,15,72,76,249,62,169,41,218,127,
0,144,109,89,141,199,82,89,58,118,236,88,141,39,79,158,124,241,232,209,35,251,
173,91,183,14,18,229,79,151,32,107,180,143,112,85,94,115,176,175,1,64,227,52,18,
128,60,126,252,216,224,248,241,227,211,95,189,122,85,124,220,184,113,108,226,
196,137,58,209,229,74,228,245,107,121,65,227,56,99,99,227,23,162,188,0,160,61,
36,73,210,59,112,224,192,20,95,95,223,2,49,49,49,204,217,217,121,194,253,251,
247,139,138,182,131,108,67,165,88,115,176,175,1,64,227,52,18,128,236,217,179,
167,58,15,66,122,80,107,199,180,105,211,68,217,117,2,85,90,168,111,183,161,161,
97,92,106,106,170,175,40,63,0,104,143,163,71,143,214,184,115,231,78,63,26,52,
78,158,60,121,82,105,247,238,221,95,8,54,131,236,65,11,136,102,97,95,3,128,198,
105,36,0,185,116,233,82,151,240,240,240,2,125,250,244,145,187,92,1,99,55,111,
222,100,15,30,60,96,214,214,214,30,195,135,15,199,44,88,0,121,132,36,73,138,189,
123,247,78,244,245,245,53,83,62,23,25,25,201,92,92,92,38,4,4,4,20,206,106,91,
200,54,84,138,53,7,251,26,0,52,78,237,1,200,227,199,143,11,135,134,134,14,49,50,
50,98,67,134,12,17,101,215,25,187,119,239,102,41,41,41,172,102,205,154,39,166,
76,153,146,36,202,15,0,218,97,227,198,141,117,110,220,184,209,159,126,191,180,
66,185,185,185,185,100,106,106,74,179,218,85,90,178,100,201,48,209,246,32,68,
45,32,41,162,76,160,50,201,162,12,0,0,170,166,246,0,228,143,63,254,104,25,20,
20,84,165,65,131,6,172,118,237,218,162,236,58,129,166,224,61,121,242,36,179,
180,180,12,108,221,186,245,1,81,126,0,208,14,110,110,110,138,195,135,15,127,171,
80,40,140,191,250,234,171,131,213,170,85,155,111,96,96,112,108,244,232,209,191,
217,217,217,189,113,118,118,158,116,244,232,209,34,162,247,129,44,161,11,150,
102,97,95,3,128,198,169,125,29,16,15,15,143,94,145,145,145,138,126,253,250,233,
212,138,198,89,161,5,214,120,80,198,170,86,173,122,102,234,212,169,126,162,252,
0,160,53,28,91,181,106,101,242,197,23,95,116,31,60,120,240,25,30,136,244,228,
207,21,91,186,116,233,143,15,31,62,220,201,131,147,41,198,198,198,61,248,115,
155,69,111,4,31,133,22,16,205,66,11,8,0,104,156,90,3,144,197,139,23,91,47,88,
176,160,45,45,54,216,179,103,79,81,118,157,64,131,86,119,237,218,197,120,37,133,
213,173,91,119,223,147,39,79,68,155,0,128,150,48,53,53,125,50,117,234,212,254,
60,240,72,77,235,82,106,196,222,175,137,194,170,87,175,238,201,111,70,188,125,
251,246,195,216,16,200,17,4,32,154,133,125,13,0,26,167,214,46,88,247,238,221,27,
20,17,17,81,170,67,135,14,172,76,153,50,162,236,58,129,86,63,191,122,245,42,
237,15,239,9,19,38,220,17,229,7,0,237,81,181,106,213,4,10,62,178,202,83,164,72,
145,216,172,94,7,33,4,32,154,133,125,13,0,26,167,182,0,36,42,42,202,216,205,205,
173,87,106,106,170,188,224,30,188,71,11,48,38,38,38,210,236,87,155,27,53,106,20,
38,202,15,0,160,99,40,0,65,183,32,205,193,36,40,0,160,113,106,11,64,150,46,93,
218,44,48,48,176,137,163,163,35,107,210,164,137,40,187,78,160,133,7,247,239,223,
207,10,23,46,28,221,172,89,179,99,162,252,0,0,186,70,95,95,95,14,64,36,9,139,
198,171,147,114,255,42,20,10,4,123,0,160,113,106,9,64,104,158,252,43,87,174,208,
224,115,253,222,189,123,179,2,5,10,136,54,209,9,174,174,174,204,203,203,139,89,
89,89,157,95,176,96,193,3,81,126,0,0,93,211,185,115,103,201,196,196,36,37,60,
60,156,197,198,162,55,155,186,208,108,140,164,116,233,210,232,130,5,0,26,167,
150,0,228,231,159,127,182,124,250,244,105,231,130,5,11,50,90,124,16,222,95,109,
162,181,63,244,245,245,83,203,149,43,183,75,161,80,136,54,1,0,208,57,171,86,173,
74,178,181,181,141,241,241,241,97,206,206,206,162,236,144,3,84,30,237,217,179,
135,233,233,233,177,54,109,218,68,138,242,3,0,168,154,90,2,144,135,15,31,182,
246,247,247,47,215,178,101,75,86,173,90,53,81,118,157,240,252,249,115,118,225,
194,5,86,188,120,241,144,9,19,38,92,16,229,7,0,208,69,101,202,148,73,104,212,
168,209,17,154,182,125,198,140,25,242,185,19,84,107,245,234,213,236,216,177,99,
172,82,165,74,47,91,183,110,125,69,148,31,0,64,213,84,62,13,47,47,44,244,135,14,
29,58,134,223,213,163,193,231,184,210,255,30,157,236,169,75,129,147,147,211,
169,94,189,122,189,19,229,7,0,208,85,107,214,172,217,17,28,28,60,244,212,169,83,
13,187,119,239,206,38,79,158,204,120,69,153,198,207,137,54,133,143,160,9,97,
168,11,240,142,29,59,216,250,245,235,169,43,176,212,167,79,159,63,134,13,27,22,
40,218,22,0,64,213,84,30,128,108,223,190,189,60,15,66,234,148,42,85,138,209,
244,187,192,88,124,124,188,60,251,149,145,145,81,66,233,210,165,215,138,242,3,0,
232,50,126,174,140,56,125,250,244,0,125,125,253,45,206,206,206,78,99,198,140,97,
22,22,22,88,204,246,51,69,71,71,179,132,132,4,102,103,103,23,217,187,119,239,
197,243,230,205,91,49,127,254,124,209,102,0,0,42,167,242,0,228,216,177,99,29,
222,189,123,103,57,104,208,32,186,194,34,202,174,19,110,221,186,197,238,222,189,
203,42,84,168,224,54,121,242,100,15,186,2,5,0,249,215,196,137,19,75,62,127,254,
60,213,214,214,214,44,40,40,40,188,112,225,194,101,171,86,173,26,54,125,250,
244,0,209,182,100,209,162,69,150,17,17,17,118,125,251,246,117,175,93,187,118,
150,211,164,86,171,86,205,164,108,217,178,182,103,207,158,125,148,85,190,188,
166,83,167,78,47,37,73,106,63,97,194,132,238,252,252,233,228,230,230,102,18,25,
25,73,17,8,37,90,252,209,32,45,233,103,72,122,31,73,249,165,57,62,53,139,68,51,
90,165,100,72,244,28,29,67,201,165,75,151,78,174,85,171,86,0,63,174,246,15,31,
62,252,209,226,197,139,51,123,127,0,0,181,83,105,0,226,227,227,99,214,174,93,
187,175,232,42,213,128,1,3,68,217,117,6,13,246,163,21,208,235,212,169,115,174,
94,189,122,9,162,252,0,144,119,241,74,179,222,144,33,67,230,151,40,81,194,39,
36,36,164,85,201,146,37,23,233,235,235,47,52,51,51,219,203,95,206,214,229,102,
127,127,255,150,97,97,97,123,151,79,38,3,0,0,32,0,73,68,65,84,163,163,163,203,
241,135,193,89,229,125,252,248,113,233,212,212,212,77,252,110,163,172,242,229,
69,10,133,130,42,206,7,211,18,124,166,87,175,94,201,233,196,137,19,162,172,0,0,
106,165,210,0,228,135,31,126,104,24,26,26,90,167,65,131,6,140,87,180,69,217,117,
2,175,128,200,227,63,138,21,43,246,182,89,179,102,123,246,238,221,43,218,4,0,
242,168,169,83,167,26,180,104,209,162,152,185,185,121,131,82,165,74,121,134,135,
135,219,84,169,82,229,69,245,234,213,15,219,216,216,220,94,177,98,133,147,165,
165,165,201,158,61,123,244,56,51,30,156,156,88,187,118,109,252,246,237,219,203,
237,220,185,211,41,57,57,57,245,255,254,239,255,46,109,222,188,57,57,38,38,38,
37,42,42,170,0,223,102,84,173,90,181,206,242,243,135,223,214,173,91,135,190,
123,247,238,254,164,73,147,30,204,155,55,175,181,167,167,167,45,207,243,218,205,
205,45,145,254,254,165,75,151,140,246,239,223,223,137,7,48,69,29,28,28,206,46,
92,184,240,149,232,51,3,0,0,104,154,202,2,16,90,251,163,73,147,38,131,120,97,
168,215,175,95,63,102,108,108,44,218,68,39,156,57,115,134,5,4,4,80,235,135,203,
248,241,227,159,76,152,48,65,180,9,0,228,81,109,218,180,169,203,207,129,155,110,
223,190,93,209,192,192,96,90,88,88,88,50,15,66,190,222,183,111,95,159,122,245,
234,197,220,189,123,183,106,72,72,200,23,22,22,22,87,120,190,250,207,159,63,95,
126,249,242,229,85,243,231,207,63,199,131,143,119,10,133,162,216,180,105,211,
134,183,110,221,122,45,223,78,242,242,242,42,194,95,95,91,160,64,129,158,60,0,
241,191,126,253,250,242,160,160,160,153,47,94,188,168,201,223,107,77,177,98,197,
110,68,70,70,58,242,96,198,143,159,131,13,58,116,232,240,71,66,66,66,243,194,
133,11,135,156,60,121,114,84,203,150,45,7,185,184,184,120,139,62,55,0,0,128,38,
169,108,26,222,245,235,215,151,14,12,12,236,79,227,62,186,118,237,42,202,254,89,
226,226,226,228,46,77,52,171,71,102,104,144,29,229,161,215,105,190,115,74,41,41,
154,95,107,41,49,49,81,158,113,196,200,200,72,170,85,171,214,14,94,185,192,210,
190,0,249,88,231,206,157,111,250,251,251,47,25,62,124,184,17,191,95,60,38,38,
230,219,191,254,250,107,38,45,202,26,27,27,155,26,17,17,65,231,165,123,167,78,
157,234,50,114,228,200,115,134,134,134,45,151,46,93,218,57,32,32,64,239,210,165,
75,29,198,142,29,219,186,93,187,118,5,138,20,41,82,141,231,75,78,74,74,146,248,
182,137,241,241,241,116,2,83,240,247,139,229,193,69,17,55,55,183,105,229,202,
149,91,116,248,240,225,54,21,42,84,88,202,131,29,197,198,141,27,235,188,123,247,
238,43,30,148,204,115,116,116,156,89,180,104,209,2,252,220,243,139,232,51,3,0,0,
104,154,202,90,64,78,158,60,217,150,23,188,22,3,7,14,100,188,96,20,101,207,17,
10,36,54,111,222,204,246,239,223,207,230,206,157,203,182,108,217,194,102,207,
158,205,120,97,253,33,207,253,251,247,25,181,50,76,159,62,157,61,120,240,128,53,
106,212,136,153,153,153,201,125,94,105,27,77,162,191,127,237,218,53,154,58,242,
81,239,222,189,79,111,218,180,73,180,73,190,211,163,71,143,42,103,206,156,41,
199,131,49,61,186,66,203,159,50,74,75,198,233,146,9,79,166,116,203,131,52,163,
180,199,70,233,94,163,251,52,240,52,175,15,34,165,0,84,57,40,52,99,162,190,238,
212,141,38,145,239,39,186,77,72,75,241,148,248,126,137,229,199,113,44,175,92,
198,124,251,237,183,110,147,38,77,202,114,92,0,228,142,97,195,134,205,188,112,
225,66,15,254,155,151,94,188,120,161,168,83,167,206,247,60,192,120,76,99,25,104,
74,114,90,248,141,7,7,201,252,126,202,190,125,251,2,120,224,96,111,99,99,211,
245,249,243,231,222,252,57,154,158,251,29,255,254,27,142,30,61,186,23,207,107,
200,83,10,127,158,142,3,58,118,10,242,160,196,132,43,198,3,151,178,60,223,45,
250,155,197,139,23,191,195,243,116,226,1,140,5,15,86,140,249,223,29,195,207,197,
201,9,9,9,175,204,205,205,177,136,6,232,148,193,131,7,87,63,125,250,116,121,30,
172,155,243,223,128,57,123,95,182,80,82,150,55,70,105,229,140,50,81,185,100,200,
254,153,208,32,253,228,6,121,157,178,204,161,148,196,254,61,41,129,50,37,100,40,
115,40,197,241,125,20,199,203,156,24,43,43,171,152,137,19,39,222,255,238,187,
239,130,50,253,11,0,57,164,146,0,132,255,208,13,170,86,173,42,47,121,62,100,200,
16,181,173,253,65,45,10,188,208,102,212,197,171,116,233,210,236,246,237,219,
242,115,233,157,59,119,142,209,20,192,52,103,60,229,41,81,162,4,187,113,227,6,
45,142,248,159,247,50,50,50,98,234,68,83,239,82,75,76,131,6,13,142,116,237,218,
53,78,148,63,63,185,126,253,122,49,30,28,254,159,179,179,243,96,94,8,88,82,151,
60,94,217,18,109,6,31,65,193,55,181,236,189,124,249,146,241,10,173,31,47,12,22,
115,127,161,85,77,187,140,27,55,238,114,88,88,216,40,126,62,252,53,60,60,252,11,
30,40,78,174,88,177,98,224,201,147,39,63,84,102,232,187,36,252,220,16,195,239,
27,7,7,7,159,42,88,176,224,31,87,174,92,169,200,207,85,149,107,215,174,61,166,
75,151,46,23,66,66,66,82,248,182,252,107,79,136,240,244,244,52,190,121,243,102,
3,111,111,239,2,181,106,213,10,230,207,249,241,183,232,19,29,29,125,101,228,
200,145,93,121,160,98,201,183,243,121,240,224,193,27,254,25,214,125,245,213,87,
7,121,48,180,132,231,213,167,139,32,0,249,221,221,187,119,173,230,205,155,183,
224,204,153,51,3,222,190,125,91,144,202,28,30,128,139,54,131,143,80,150,57,254,
254,254,108,229,202,149,254,223,126,251,237,18,110,25,202,28,80,21,149,212,8,
231,207,159,95,155,23,182,109,105,213,243,230,205,155,139,178,231,24,181,98,60,
122,244,136,157,63,127,158,213,173,91,151,153,154,154,254,43,216,121,250,244,41,
59,116,232,144,252,163,113,119,119,151,243,58,58,58,202,115,199,43,231,143,167,
31,19,255,17,49,63,63,63,154,22,151,77,153,50,133,217,216,216,124,236,79,230,
24,63,1,178,35,71,142,80,235,71,92,135,14,29,78,187,184,184,136,54,201,55,248,
255,109,48,119,238,220,149,252,127,238,79,173,83,212,26,213,177,99,71,76,203,
252,25,148,139,136,109,223,190,157,102,85,43,187,107,215,174,21,201,201,201,116,
165,106,189,104,91,208,156,221,187,119,75,252,156,116,61,52,52,52,194,194,194,
226,76,147,38,77,174,242,130,92,159,63,247,154,191,28,205,19,181,114,188,73,203,
30,157,146,146,242,118,242,228,201,167,121,80,57,134,159,71,157,233,138,173,
165,165,229,159,81,81,81,15,249,54,161,252,119,243,118,245,234,213,23,110,221,
186,181,44,32,32,64,193,207,99,175,121,16,226,213,181,107,215,133,135,15,31,254,
253,235,175,191,110,203,207,117,15,248,177,240,100,218,180,105,62,252,249,45,7,
15,30,92,123,234,212,169,5,190,190,190,175,248,239,111,236,199,63,45,64,254,
192,203,126,163,31,126,248,97,237,233,211,167,251,208,98,149,191,254,250,43,117,
135,100,69,139,22,21,109,10,31,65,101,14,63,215,176,157,59,119,50,94,222,148,
225,229,206,159,252,57,42,115,86,139,182,5,200,14,149,4,32,206,206,206,61,163,
163,163,141,251,244,233,195,10,20,40,32,202,158,99,141,27,55,102,149,42,85,146,
199,152,88,91,91,255,103,92,7,117,253,106,218,180,169,188,216,18,5,30,43,86,172,
144,63,79,161,66,133,228,215,233,7,245,243,207,63,179,42,85,170,200,149,226,85,
171,86,209,204,93,114,183,46,234,26,161,74,174,174,174,114,64,84,163,70,141,183,
52,203,13,127,202,81,180,77,6,202,166,210,244,93,118,82,89,186,185,221,121,0,
150,18,23,23,71,39,132,127,55,3,229,178,13,27,54,52,190,120,241,98,159,98,197,
138,49,94,25,98,245,235,215,23,109,2,217,64,1,115,187,118,237,228,224,251,219,
111,191,165,64,111,26,15,166,15,243,32,250,13,3,173,192,131,130,27,47,95,190,
188,206,222,119,23,148,79,80,60,152,160,219,118,252,28,67,191,83,229,154,20,100,
133,145,145,209,154,150,45,91,70,241,115,83,59,254,187,233,206,243,190,152,58,
117,234,53,94,137,162,115,115,109,30,112,68,242,0,102,212,186,117,235,58,39,38,
38,6,241,115,217,83,126,14,139,187,112,225,66,34,207,255,240,221,187,119,117,
42,86,172,184,255,248,241,227,116,126,160,139,52,63,240,64,230,52,15,100,202,
125,247,221,119,135,27,53,106,20,157,201,199,4,200,87,102,205,154,213,226,220,
185,115,189,232,130,23,117,209,166,186,2,124,62,42,115,218,182,109,43,151,57,19,
39,78,164,243,219,119,11,22,44,56,56,99,198,140,80,209,182,0,34,159,29,128,240,
3,178,56,175,12,13,160,113,22,125,251,246,21,101,255,44,84,161,165,213,112,
203,150,45,43,183,126,40,187,50,40,153,152,152,80,127,104,121,204,7,5,30,212,
229,71,95,255,125,207,7,186,79,173,30,55,111,222,148,43,196,151,46,93,146,243,
208,227,55,111,222,200,219,169,210,238,221,187,229,86,23,170,116,240,10,201,31,
162,252,153,248,48,38,32,93,74,223,111,51,41,62,62,62,193,206,206,206,210,220,
220,188,92,88,88,88,82,131,6,13,220,121,112,182,97,196,136,17,190,31,125,87,13,
112,113,113,105,199,43,64,250,116,21,10,193,135,234,77,154,52,137,93,185,114,
133,2,144,74,203,151,47,183,101,255,92,81,215,52,41,45,65,26,254,91,255,207,162,
129,116,206,226,162,168,229,54,189,47,191,252,82,30,223,67,247,249,121,34,146,
223,124,88,161,148,159,87,41,160,160,231,148,107,97,28,101,25,124,243,205,55,
238,252,198,61,227,243,63,254,248,227,21,186,165,241,113,0,186,224,204,153,51,
78,49,49,49,122,127,254,249,39,130,15,53,24,63,126,188,124,81,117,223,190,125,
182,171,87,175,174,200,159,66,0,2,159,77,21,1,72,135,160,160,32,59,39,39,39,230,
224,224,32,202,254,89,168,5,131,18,181,124,100,12,62,50,230,201,12,141,199,72,
74,74,98,52,19,13,109,79,253,67,169,37,68,213,253,68,125,124,124,216,217,179,
103,169,203,209,203,63,254,248,163,117,155,54,109,124,69,219,228,128,130,166,62,
94,180,104,81,9,103,103,231,42,79,159,62,173,242,228,201,147,47,120,144,53,138,
127,23,195,249,115,167,68,111,160,46,81,81,81,10,26,127,211,165,75,23,81,86,200,
33,26,107,69,221,13,67,66,66,204,68,121,213,136,174,236,35,0,1,0,17,181,94,172,
8,15,15,55,41,89,178,36,235,214,173,155,40,43,228,16,149,57,180,142,89,104,
104,104,110,150,57,144,143,124,118,191,163,251,247,239,119,167,49,23,131,6,13,
82,121,55,38,66,211,237,82,228,253,238,221,187,255,188,63,141,255,248,88,32,
146,17,5,45,101,202,148,97,116,146,170,93,187,182,60,83,22,117,231,242,244,244,
84,249,154,37,52,246,131,159,16,153,165,165,229,65,53,5,31,132,254,241,212,62,
125,250,4,174,88,177,226,242,185,115,231,214,60,122,244,168,37,183,43,38,38,102,
79,173,90,181,114,243,76,172,207,255,119,244,191,85,163,242,229,203,203,183,60,
168,206,173,194,64,217,197,40,123,63,64,0,208,101,234,62,79,152,209,216,15,234,
37,1,234,161,156,221,148,151,57,170,189,98,11,58,235,179,34,134,31,127,252,177,
180,159,159,95,11,154,117,170,83,167,78,162,236,57,66,173,22,115,230,204,97,47,
94,188,144,187,52,209,216,15,234,126,69,193,8,205,112,165,236,98,165,68,227,61,
168,242,75,168,2,76,173,27,148,159,238,83,151,171,89,179,102,177,223,127,255,
157,245,239,223,159,45,91,182,140,245,234,213,75,165,179,51,81,48,70,51,117,153,
152,152,164,52,109,218,244,136,40,191,42,81,64,182,100,201,146,201,61,123,246,
220,194,247,203,190,69,139,22,213,20,109,163,38,242,14,85,215,108,104,240,175,
125,107,154,85,62,53,163,166,70,117,87,44,0,32,239,83,91,11,72,218,24,79,249,42,
34,202,28,245,209,146,50,7,242,19,229,66,125,89,165,143,225,21,221,159,120,69,
87,26,51,102,140,164,46,169,169,169,82,124,124,188,148,146,146,34,63,78,76,76,
252,215,125,122,61,189,228,228,100,137,22,239,34,116,75,121,41,81,94,37,90,97,
216,195,195,67,138,142,142,150,84,205,213,213,85,226,1,141,228,224,224,224,121,
251,246,109,139,143,238,60,53,226,31,67,207,222,222,254,72,251,246,237,119,72,
217,108,33,82,177,165,53,106,212,16,237,42,248,12,110,110,110,202,2,125,136,232,
203,80,19,10,50,169,155,95,105,81,198,124,174,63,79,27,69,153,0,116,28,181,200,
111,17,101,202,9,67,67,67,170,25,239,226,101,222,127,234,3,160,58,15,30,60,80,
150,57,195,179,254,70,0,178,39,199,45,32,79,158,60,49,121,248,240,97,47,106,61,
160,238,87,234,66,81,55,117,145,82,118,191,74,27,216,253,225,126,198,43,30,212,
34,162,108,209,160,91,202,75,73,57,13,47,161,166,90,94,65,86,249,216,15,66,131,
207,169,219,152,141,141,205,186,250,245,235,71,138,242,171,3,223,39,169,53,107,
214,92,231,227,227,83,127,240,224,193,170,107,222,201,62,245,46,176,2,233,229,
230,213,40,234,130,149,249,128,43,0,128,127,168,173,5,132,151,183,84,33,48,17,
229,3,149,193,190,6,149,200,113,0,178,101,203,150,214,33,33,33,181,104,122,54,
204,116,244,30,223,31,236,232,209,163,212,221,43,178,73,147,38,39,68,249,213,
169,92,185,114,247,205,204,204,162,156,157,157,115,99,140,0,2,16,205,201,141,
239,151,80,228,79,51,53,169,165,82,1,0,249,138,218,186,107,74,146,68,245,152,
220,188,16,163,107,84,59,104,22,116,86,142,2,16,254,131,103,183,110,221,250,34,
42,42,74,159,166,222,165,233,111,129,177,11,23,46,176,87,175,94,209,148,190,
199,103,205,154,229,35,202,175,78,51,102,204,136,228,1,200,211,55,111,222,168,
190,153,39,107,84,49,197,9,74,115,114,179,224,197,32,116,0,200,14,181,5,32,236,
125,61,38,55,207,131,186,6,23,24,65,37,114,212,61,103,225,194,133,86,79,158,60,
105,67,131,189,49,237,221,123,212,237,138,86,12,53,50,50,74,45,85,170,212,118,
133,66,161,174,147,109,182,20,46,92,56,90,79,79,239,145,161,161,161,166,3,16,42,
12,112,130,210,156,220,106,1,33,202,197,49,1,0,178,34,207,218,40,202,148,67,84,
230,228,230,121,80,215,160,124,7,149,200,81,11,136,171,171,107,199,192,192,192,
146,29,58,116,96,118,118,118,162,236,58,225,225,195,135,242,226,112,197,139,23,
127,241,251,239,191,95,21,229,215,132,212,212,84,163,132,132,4,77,95,25,146,175,
70,97,54,18,141,209,116,128,169,164,236,130,165,174,74,5,0,228,31,234,110,1,65,
0,162,57,232,225,0,42,241,201,1,200,185,115,231,76,121,240,49,150,42,152,3,7,
14,196,180,119,105,104,81,184,152,152,24,26,220,126,186,102,205,154,177,162,
252,26,66,35,239,53,221,63,142,142,41,156,160,52,39,55,11,94,140,1,1,128,236,80,
119,0,162,233,11,109,186,236,159,25,125,0,62,195,39,7,32,7,14,28,168,252,244,
233,211,218,85,170,84,97,173,90,181,18,101,215,9,180,178,250,225,195,135,105,44,
76,116,197,138,21,215,136,242,107,16,157,40,52,29,12,80,68,138,38,90,205,209,
244,247,155,30,90,64,0,32,59,212,217,5,139,202,28,84,138,53,39,71,93,247,1,50,
250,228,0,228,250,245,235,29,99,98,98,76,105,1,63,11,139,92,89,230,66,235,208,
74,237,143,30,61,98,182,182,182,247,150,47,95,254,72,148,95,131,114,163,5,4,1,
136,110,64,23,44,0,200,46,76,217,157,127,32,216,3,149,248,164,0,228,226,197,139,
5,34,34,34,6,209,172,87,253,250,245,19,101,215,9,52,35,216,158,61,123,228,251,
117,234,212,57,158,219,131,207,51,200,141,0,4,131,208,117,71,18,67,165,2,21,43,
0,177,84,134,223,73,126,129,22,16,80,137,79,58,144,86,173,90,213,42,44,44,172,
122,179,102,205,152,163,163,163,40,187,78,240,243,243,99,103,206,156,97,37,74,
148,8,238,208,161,195,161,29,59,118,136,54,209,36,10,4,114,35,0,201,173,129,209,
160,65,122,122,122,73,5,11,22,76,165,46,136,218,236,222,189,123,214,27,54,108,
232,243,232,209,163,42,158,158,158,6,252,28,102,152,154,154,74,231,62,67,133,66,
33,223,166,75,244,155,161,231,132,131,219,232,226,3,87,140,39,75,254,62,46,130,
236,159,75,217,135,62,53,147,148,146,46,81,171,84,10,255,108,116,155,204,191,
163,228,162,69,139,38,242,243,117,92,195,134,13,207,206,155,55,239,82,230,111,
15,160,86,152,178,59,255,248,164,122,163,174,24,57,114,100,189,227,199,143,87,
138,139,139,51,143,137,137,49,75,78,78,166,113,73,148,140,211,37,185,91,60,47,
47,232,86,89,246,24,164,37,253,116,183,185,65,89,150,36,167,75,244,56,137,151,
39,116,177,49,49,93,74,72,75,241,60,197,25,26,26,198,153,152,152,196,84,171,86,
45,98,243,230,205,23,29,28,28,162,51,253,11,25,100,251,64,226,31,64,81,167,78,
157,47,98,99,99,245,134,12,25,34,175,56,14,140,29,59,118,140,189,121,243,134,
241,194,253,20,223,47,62,67,135,14,21,109,162,73,244,253,106,122,140,0,29,24,5,
68,153,32,111,251,249,231,159,139,111,217,178,197,172,98,197,138,201,206,206,
206,162,236,185,130,159,179,76,198,142,29,219,237,203,47,191,156,239,229,229,85,
145,23,12,140,7,76,52,69,181,104,211,108,83,78,194,193,255,86,9,65,214,92,195,
207,217,242,26,69,79,158,60,153,204,207,81,147,182,111,223,190,142,127,110,92,
141,6,141,49,51,51,75,73,74,74,146,120,18,101,5,237,151,237,122,99,126,71,139,
96,46,94,188,184,236,161,67,135,230,28,60,120,176,247,219,183,111,205,168,135,
16,149,51,186,52,65,83,74,74,138,60,9,147,135,135,7,5,98,231,120,25,51,136,215,
133,195,68,219,101,251,64,90,179,102,77,229,208,208,208,110,54,54,54,172,99,199,
142,162,236,58,129,78,166,212,253,202,212,212,52,181,65,131,6,7,116,233,128,203,
2,237,4,68,167,249,156,183,183,119,237,162,69,139,86,248,245,215,95,19,91,180,
104,33,202,158,43,38,77,154,52,229,232,209,163,115,2,3,3,245,232,156,69,23,78,
106,214,172,201,248,231,166,214,27,209,230,249,66,106,106,42,11,9,9,145,103,233,
155,55,111,158,209,221,187,119,127,185,122,245,234,81,254,82,144,104,91,0,85,
225,245,134,4,43,43,171,106,252,247,88,176,68,137,18,81,162,252,160,213,80,190,
167,225,229,95,169,115,231,206,185,220,184,113,163,108,185,114,229,216,228,201,
147,153,147,147,19,43,95,190,60,51,54,214,244,181,223,220,19,29,29,205,30,60,
120,64,23,38,105,145,242,246,188,156,253,146,63,189,68,180,157,220,141,64,148,
72,251,246,237,199,211,248,134,49,99,198,72,240,30,63,232,36,3,3,3,137,159,92,
175,223,185,115,71,27,143,182,205,60,13,22,101,82,49,75,158,2,28,29,29,69,187,
15,62,131,155,155,27,253,48,41,109,18,124,31,106,193,79,48,211,29,28,28,14,138,
242,229,150,137,19,39,118,230,21,158,72,19,19,19,105,227,198,141,82,114,114,178,
104,151,230,123,205,155,55,151,120,161,24,211,182,109,219,170,162,253,7,160,74,
188,162,102,223,168,81,163,151,188,254,80,70,148,55,7,104,54,28,63,123,123,123,
137,7,220,162,159,1,228,16,175,96,42,203,156,109,130,239,67,39,240,58,159,69,
141,26,53,206,243,187,82,175,94,189,36,63,63,63,209,46,204,247,118,238,220,41,
119,19,230,251,229,153,104,255,145,108,93,6,116,119,119,55,244,244,244,236,67,
221,174,6,12,24,32,202,174,19,248,190,102,187,119,239,150,87,64,175,94,189,250,
209,122,245,234,37,136,182,201,5,113,12,253,110,65,197,102,207,158,93,48,33,33,
225,171,6,13,26,92,20,229,205,13,188,96,176,188,121,243,230,159,111,223,190,45,
248,219,111,191,177,175,191,254,90,231,187,140,210,121,138,154,201,13,12,12,18,
139,20,41,146,44,202,15,160,74,163,71,143,14,225,231,140,228,224,224,224,6,162,
188,89,225,229,46,186,25,228,62,124,7,28,47,91,134,122,123,123,183,109,216,176,
33,219,178,101,11,43,83,70,29,177,117,222,146,214,197,146,46,116,249,102,157,
243,189,108,5,32,235,215,175,111,28,30,30,222,180,78,157,58,52,214,65,148,93,39,
80,183,134,35,71,142,176,98,197,138,197,118,233,210,229,180,40,127,46,161,166,
110,4,32,160,50,188,2,80,200,223,223,127,127,161,66,133,20,99,199,142,221,35,
202,159,27,246,236,217,51,240,225,195,135,149,169,107,216,152,49,99,68,217,117,
2,47,40,25,223,39,140,127,111,175,166,79,159,46,236,155,11,160,74,214,214,214,
97,213,170,85,187,241,236,217,179,145,46,46,46,57,238,45,112,231,206,157,6,188,
226,247,205,230,205,155,177,6,0,228,154,75,151,46,21,242,240,240,24,75,93,92,
231,205,155,135,37,41,216,251,238,190,23,47,94,164,177,47,169,197,139,23,95,38,
202,79,178,21,128,220,188,121,179,111,108,108,172,97,223,190,125,105,188,131,40,
187,78,160,29,253,242,229,75,86,186,116,233,203,19,39,78,124,32,202,159,75,104,
69,118,12,54,5,149,72,76,76,44,48,121,242,228,61,183,110,221,170,105,110,110,
222,183,126,253,250,111,69,219,104,26,15,144,244,232,124,69,3,226,190,252,242,
75,90,28,84,180,137,78,56,125,250,52,139,140,140,100,101,203,150,189,93,175,94,
189,112,81,126,0,85,107,219,182,237,31,102,102,102,77,120,217,249,87,78,91,50,
146,146,146,30,94,189,122,117,212,156,57,115,46,15,29,58,116,16,127,31,250,129,
199,138,182,3,80,165,117,235,214,53,10,12,12,180,231,101,32,107,217,178,165,40,
187,78,8,14,14,102,103,207,158,165,139,92,193,101,202,148,185,35,202,79,178,21,
128,248,250,250,118,162,8,175,103,207,158,162,172,58,129,34,189,93,187,118,49,
35,35,35,90,124,112,187,22,207,40,19,195,16,128,228,119,41,162,12,159,227,254,
253,251,133,7,14,28,88,171,105,211,166,95,215,172,89,243,226,223,127,255,93,213,
212,212,180,221,165,75,151,30,138,182,205,13,135,14,29,170,239,227,227,211,148,
154,195,187,116,233,34,202,174,19,40,24,163,201,50,104,102,150,22,45,90,104,237,
184,29,200,223,190,254,250,235,123,41,41,41,61,79,158,60,57,112,242,228,201,235,
232,98,129,104,155,140,154,52,105,18,227,224,224,240,123,120,120,120,157,35,71,
142,236,172,85,171,150,75,223,190,125,191,82,164,205,0,131,137,96,64,221,232,
184,245,243,243,27,78,231,213,193,131,7,83,183,86,209,38,58,225,196,137,19,44,
52,52,148,85,168,80,193,101,237,218,181,33,162,252,36,91,123,238,245,235,215,
54,221,187,119,103,118,118,118,162,172,58,225,218,181,107,236,242,229,203,172,
100,201,146,190,19,38,76,56,119,240,160,214,150,233,20,128,160,11,86,254,214,
129,167,19,162,76,25,208,49,65,227,0,146,50,220,254,107,45,9,125,125,253,20,30,
124,216,152,152,152,56,36,37,37,197,241,0,228,204,232,209,163,215,181,106,213,
42,224,163,239,156,203,206,156,57,51,56,32,32,192,120,252,248,241,172,120,241,
226,162,236,58,225,246,237,219,114,170,94,189,250,227,153,51,103,186,46,90,180,
72,180,9,128,90,184,185,185,93,114,114,114,234,118,227,198,141,131,246,246,246,
53,248,185,100,71,213,170,85,31,241,32,226,73,155,54,109,2,69,219,19,126,252,
30,230,199,243,21,23,23,151,22,238,238,238,13,158,63,127,222,128,38,200,161,11,
131,52,214,9,21,66,80,167,229,203,151,87,120,245,234,85,15,107,107,107,92,228,
74,19,31,31,47,95,148,55,54,54,78,174,83,167,206,118,254,59,23,109,34,203,238,
47,213,136,250,83,235,202,212,149,89,161,110,12,52,213,24,13,182,225,59,122,13,
63,153,106,115,119,6,4,32,249,31,181,68,252,46,202,148,129,50,0,201,152,210,47,
104,151,66,115,247,243,2,61,113,242,228,201,241,195,135,15,143,244,244,244,148,
175,164,107,43,94,41,41,56,114,228,200,142,134,134,134,152,44,35,157,125,251,
246,201,87,134,203,148,41,179,217,220,220,92,187,87,141,132,124,207,217,217,249,
242,201,147,39,235,31,62,124,120,28,15,32,134,62,120,240,160,200,197,139,23,125,
245,245,245,223,166,164,164,208,66,160,202,148,233,130,160,20,108,240,227,184,
20,29,211,52,25,12,173,115,67,79,251,248,248,176,25,51,102,176,185,115,231,162,
235,37,168,205,133,11,23,58,250,251,251,155,242,50,145,186,224,139,178,235,4,10,
56,110,220,184,193,44,45,45,221,255,247,191,255,93,222,184,113,163,104,19,89,
118,3,16,69,98,98,162,40,79,190,231,229,229,37,159,224,174,92,185,194,236,237,
237,47,76,154,52,105,29,63,137,138,54,203,53,188,34,22,205,131,70,189,132,4,109,
156,160,11,84,132,90,35,156,69,153,114,34,42,42,74,78,116,162,205,11,246,239,
223,223,236,241,227,199,182,245,234,213,99,148,224,125,191,220,227,199,143,51,
43,43,171,152,97,195,134,157,229,21,63,209,38,0,106,215,165,75,23,111,126,51,
133,7,16,70,219,183,111,55,255,245,215,95,141,141,140,140,12,227,226,226,210,
175,6,157,233,212,117,118,118,118,198,54,54,54,75,255,254,251,239,15,93,50,40,
24,41,81,162,4,27,53,106,148,220,53,26,64,29,60,61,61,141,58,119,238,220,139,
102,85,28,52,104,144,40,187,206,160,94,64,20,35,84,174,92,249,16,47,123,179,29,
44,100,43,0,49,53,53,149,86,172,88,33,175,32,220,184,113,99,185,47,177,174,160,
157,234,235,235,43,119,185,162,105,119,95,189,122,197,74,149,42,229,204,79,128,
3,181,188,245,131,86,159,141,105,213,170,85,251,35,71,142,28,16,229,133,60,75,
183,231,151,77,67,253,114,123,246,236,57,154,7,219,250,253,250,245,195,21,208,
52,231,206,157,147,207,89,29,58,116,120,216,191,127,255,7,104,25,2,109,194,3,7,
170,172,100,187,194,66,86,174,92,217,114,252,248,241,141,104,90,233,210,165,75,
39,243,128,228,204,213,171,87,27,89,88,88,20,229,21,32,209,230,0,57,182,103,
207,158,6,97,97,97,45,29,28,28,104,60,146,40,187,78,224,251,131,29,61,122,148,
226,131,248,30,61,122,156,163,11,244,217,149,173,0,132,87,180,55,186,186,186,
142,28,59,118,44,93,80,215,169,174,88,212,196,75,39,58,194,119,112,84,211,166,
77,247,182,107,215,110,250,172,89,179,180,58,248,32,70,70,70,49,129,129,129,
117,68,249,0,242,186,195,135,15,87,112,115,115,107,73,23,73,122,245,234,37,202,
174,19,232,188,69,23,77,12,12,12,82,29,29,29,215,82,215,21,209,54,0,218,140,151,
199,134,3,7,14,252,37,42,42,202,160,91,183,110,199,58,118,236,248,39,63,174,111,
187,184,184,120,166,166,166,22,165,242,26,3,209,65,29,232,216,226,245,191,62,
209,209,209,6,116,33,199,204,204,76,180,137,78,160,139,243,212,59,200,222,222,
254,220,212,169,83,179,53,251,149,82,182,2,144,83,167,78,141,233,220,185,243,
214,107,215,174,89,242,31,190,121,114,114,50,237,121,186,196,72,115,242,210,156,
222,202,62,155,202,251,134,236,253,123,103,76,116,181,54,183,162,151,244,3,108,
211,167,164,180,148,152,46,37,164,37,90,200,47,174,96,193,130,177,230,230,230,
49,253,250,245,123,181,98,197,10,79,26,132,158,23,148,47,95,62,146,127,95,118,
43,87,174,180,25,63,126,124,182,6,248,101,23,63,224,244,42,86,172,136,25,182,
64,43,92,189,122,117,120,80,80,80,225,222,189,123,211,113,47,202,174,19,104,
221,15,190,95,168,203,74,32,15,202,142,45,94,188,88,180,9,128,86,115,115,115,
107,84,161,66,133,24,94,246,116,152,55,111,222,5,234,94,200,81,151,140,220,170,
87,128,142,216,183,111,95,153,128,128,128,190,52,35,44,149,51,240,207,140,176,
250,250,250,169,85,170,84,217,251,232,209,35,209,38,255,146,173,0,36,237,138,
194,117,81,190,252,74,217,23,158,186,161,229,37,171,86,173,122,49,118,236,216,
119,252,0,25,200,31,46,17,229,255,20,177,177,177,246,11,23,46,108,203,15,192,29,
63,252,240,195,27,81,126,0,117,161,11,34,109,218,180,233,67,51,224,160,95,238,
63,168,95,46,77,21,73,253,114,27,55,110,172,117,107,182,0,124,42,99,99,99,143,
223,126,251,173,95,90,215,45,37,52,121,128,218,29,59,118,172,99,112,112,112,233,
14,29,58,48,116,245,123,239,217,179,103,242,154,120,86,86,86,79,251,244,233,
115,250,83,199,68,227,170,65,62,86,191,126,253,168,234,213,171,255,145,146,146,
178,136,87,70,190,22,229,255,20,241,241,241,79,111,222,188,217,105,245,234,213,
174,253,251,247,31,119,237,218,181,66,105,47,169,117,93,10,128,140,254,248,227,
143,186,143,31,63,174,68,211,132,59,57,57,137,178,235,132,232,232,104,57,0,177,
176,176,72,180,183,183,223,138,238,87,144,31,56,56,56,68,100,8,62,0,52,194,211,
211,179,59,77,232,51,112,224,64,116,243,75,67,45,144,52,51,108,177,98,197,142,
12,25,50,228,147,135,37,32,0,201,231,54,111,222,188,245,221,187,119,63,253,245,
215,95,107,167,77,155,246,141,40,127,118,53,104,208,32,137,167,249,252,7,89,133,
31,132,43,71,140,24,113,157,255,48,199,79,159,62,221,146,33,8,1,13,114,117,117,
237,27,26,26,42,247,203,165,230,113,96,242,76,125,212,28,94,169,82,165,251,11,
22,44,240,20,229,7,0,128,204,241,122,141,157,175,175,111,83,234,222,219,177,99,
71,81,118,157,64,211,95,239,221,187,151,38,169,74,106,218,180,233,167,53,125,
164,65,0,162,3,158,62,125,186,48,49,49,241,135,115,231,206,45,172,93,187,246,9,
39,39,167,33,179,103,207,110,179,108,217,50,43,246,239,241,58,202,49,58,217,10,
239,191,255,254,251,171,181,106,213,58,66,87,5,158,60,121,82,237,216,177,99,43,
14,30,60,120,81,79,79,207,74,180,45,128,42,220,191,127,191,204,203,151,47,191,
224,39,65,214,167,79,31,81,118,157,64,131,37,119,238,220,73,253,114,89,243,230,
205,79,41,20,10,204,195,13,0,144,67,207,158,61,251,38,42,42,202,178,103,207,158,
180,214,133,40,187,78,184,126,253,58,149,191,204,214,214,214,99,194,132,9,159,
54,248,35,77,182,198,128,64,222,231,234,234,250,59,15,58,206,92,187,118,109,
180,187,187,123,143,119,239,222,41,2,2,2,252,120,229,36,149,87,88,148,19,10,80,
74,127,63,203,41,94,169,91,135,153,153,89,113,154,21,141,6,35,81,68,236,237,
237,45,207,205,78,247,35,34,34,88,161,66,202,158,89,0,170,183,109,219,182,54,
188,112,40,70,93,175,106,212,168,33,202,174,19,120,64,198,78,159,62,77,43,193,
135,242,0,100,219,210,165,75,69,155,0,0,64,38,60,60,60,204,122,244,232,209,137,
214,151,193,52,230,255,160,69,137,105,166,197,18,37,74,172,229,101,111,140,40,
127,102,16,128,232,144,153,51,103,210,170,217,19,232,126,72,72,8,53,157,25,234,
235,235,27,38,39,39,211,113,144,113,230,50,122,156,101,75,8,255,65,42,234,214,
173,59,159,71,194,85,232,49,5,34,150,150,150,177,225,225,225,70,38,38,38,6,5,10,
20,200,106,115,128,207,194,143,91,189,134,13,27,246,138,143,143,151,251,229,26,
24,224,116,70,142,28,57,194,248,111,144,181,111,223,254,74,159,62,125,94,136,
242,3,0,64,230,166,79,159,94,155,215,151,106,52,106,212,136,213,169,131,85,13,
72,64,64,128,188,246,71,177,98,197,94,183,107,215,238,44,13,68,207,9,116,193,
210,97,113,113,113,73,188,18,23,203,239,70,242,20,198,83,8,123,191,178,246,75,
158,188,120,122,158,85,186,112,225,66,114,96,96,96,107,154,125,200,218,218,58,
190,121,243,230,187,122,112,169,169,169,193,212,253,131,18,128,186,236,221,187,
215,222,223,223,191,117,169,82,165,88,167,78,157,68,217,117,2,5,99,251,246,237,
147,23,139,109,217,178,101,142,250,229,2,0,128,220,157,85,17,26,26,58,52,54,54,
86,175,111,223,190,116,209,85,180,137,78,56,123,246,44,123,253,250,53,171,82,
165,202,173,25,51,102,248,137,242,127,12,2,16,200,177,165,75,151,254,16,17,17,
97,222,172,89,179,221,195,135,15,111,225,226,226,50,120,211,166,77,127,243,151,
244,168,31,58,128,58,157,58,117,170,63,63,9,22,232,210,165,11,117,55,18,101,215,
9,119,238,220,145,83,165,74,149,252,39,78,156,152,179,203,82,0,0,192,230,206,
157,107,29,28,28,220,191,88,177,98,172,107,215,174,162,236,58,33,41,41,73,94,
224,214,196,196,36,181,102,205,154,219,69,249,179,130,0,4,114,196,221,221,189,
170,173,173,173,126,187,118,237,90,186,186,186,14,90,184,112,225,237,180,151,
140,179,220,16,64,5,120,37,219,234,225,195,135,189,169,219,213,224,193,131,69,
217,117,198,254,253,251,229,126,185,118,118,118,187,10,22,44,24,34,202,15,0,0,
153,187,117,235,86,215,192,192,64,75,106,97,47,83,166,140,40,187,78,160,129,231,
180,24,183,181,181,245,243,33,67,134,28,19,229,207,10,2,16,200,17,94,241,123,
181,120,241,226,145,60,18,190,33,202,11,240,169,66,66,66,76,179,122,253,244,233,
211,157,94,188,120,225,80,171,86,45,90,239,38,171,172,26,65,149,254,220,70,227,
186,210,250,229,198,245,236,217,243,168,40,63,0,128,174,226,21,105,3,73,146,62,
58,112,240,224,193,131,230,175,94,189,250,31,117,37,255,226,139,47,176,246,71,
154,3,7,14,80,247,125,86,173,90,53,90,224,54,78,148,63,43,24,181,9,57,226,224,
224,16,45,202,163,105,180,248,218,255,253,223,255,177,208,208,208,15,207,81,197,
112,236,216,177,242,115,212,45,140,250,113,166,119,254,252,121,246,252,249,115,
57,143,210,165,75,151,228,53,20,198,143,31,207,46,95,190,204,30,63,126,44,191,
190,102,205,26,121,234,57,26,108,79,39,35,190,15,216,87,95,125,197,138,20,41,
194,64,181,60,61,61,7,252,242,203,47,85,156,156,156,150,181,105,211,38,56,227,
235,127,255,253,119,103,90,0,169,127,255,254,52,153,66,102,111,241,217,126,255,
253,119,26,200,205,28,29,29,63,154,231,221,187,119,108,214,172,89,242,177,96,
101,101,37,31,23,77,154,52,97,219,183,111,103,19,38,76,160,149,155,59,89,67,238,
0,0,32,0,73,68,65,84,63,186,173,170,209,177,74,51,96,213,173,91,215,101,208,
160,65,183,208,50,4,144,187,104,6,58,90,55,34,42,42,138,102,162,100,223,126,251,
109,166,249,104,198,200,101,203,150,177,25,51,102,96,156,129,134,240,243,181,
213,226,197,139,191,255,223,255,254,183,115,245,234,213,119,51,190,206,207,167,
85,159,61,123,102,79,171,158,55,111,222,60,179,183,200,20,141,137,93,184,112,
161,188,74,184,114,134,80,122,15,170,67,228,245,41,124,169,188,163,197,7,121,
153,27,205,255,167,77,103,206,156,17,109,146,37,180,128,64,190,65,3,112,169,11,
10,143,204,229,65,201,116,226,167,68,131,148,169,114,70,193,67,70,30,30,30,242,
148,165,233,61,120,240,224,195,115,244,186,242,71,118,226,196,9,57,136,233,214,
173,27,107,221,186,53,187,123,247,174,188,246,196,155,55,111,254,243,190,240,
121,248,9,238,34,47,176,71,241,194,225,22,63,113,255,244,228,201,147,146,202,
215,248,119,92,130,127,47,173,104,138,231,94,189,122,101,245,54,159,133,190,247,
160,160,160,44,243,184,185,185,81,48,196,218,181,107,199,108,108,108,88,233,210,
165,229,227,225,216,177,99,114,95,89,77,161,66,110,219,182,109,52,241,131,68,
139,66,241,64,40,247,155,100,0,116,28,149,25,126,126,126,172,104,209,162,52,46,
235,163,249,104,218,122,42,187,52,121,206,208,117,252,92,29,242,244,233,211,216,
35,71,142,92,231,229,249,198,249,243,231,215,76,255,58,175,51,116,139,137,137,
49,161,25,22,205,205,205,63,246,54,255,65,1,8,125,151,212,101,171,123,247,238,
172,67,135,14,114,240,57,113,226,68,150,215,199,198,210,108,87,188,44,166,181,
63,174,45,95,190,220,75,148,95,4,45,32,144,111,208,213,103,170,148,14,25,50,
132,149,43,87,238,95,175,209,149,8,67,67,195,255,108,67,99,8,50,94,165,78,255,
28,109,147,254,62,175,220,177,222,189,123,203,143,233,10,51,85,60,183,110,221,
202,166,78,157,202,64,117,26,55,110,236,63,123,246,236,37,139,22,45,154,203,247,
239,92,30,60,142,226,129,200,166,95,126,249,101,235,159,127,254,57,52,44,44,172,
4,13,10,180,179,179,19,189,85,142,81,203,10,245,119,165,22,49,106,114,166,22,
49,186,146,165,68,87,131,182,108,217,34,183,188,81,43,26,229,167,22,55,154,126,
218,196,196,68,158,5,142,90,105,214,173,91,39,95,13,171,87,175,30,27,58,116,168,
90,90,108,168,80,160,213,207,171,84,169,242,150,31,159,103,120,225,32,218,4,0,
212,140,202,14,58,15,80,165,148,22,236,37,107,215,174,149,43,167,52,147,16,149,
41,147,39,79,150,243,209,57,131,202,30,106,13,161,60,84,121,173,90,181,170,224,
47,64,78,81,125,225,214,173,91,43,111,220,184,241,37,63,199,127,253,248,241,
227,254,78,78,78,251,26,52,104,176,108,204,152,49,239,120,217,62,204,204,204,
236,63,189,38,178,131,206,241,116,241,179,89,179,102,242,99,186,40,74,221,184,
232,187,165,224,132,122,77,208,5,76,106,61,191,122,245,170,188,166,6,5,39,84,
167,104,213,170,149,188,13,5,45,52,163,33,149,113,116,17,149,159,219,229,201,86,
168,155,45,161,58,13,213,117,54,108,216,192,110,222,188,73,93,111,217,136,17,35,
228,214,120,58,182,232,66,24,5,191,111,223,190,149,223,87,217,155,131,214,50,
105,211,166,205,71,63,251,199,208,69,46,250,156,252,239,74,117,235,214,61,238,
233,233,41,218,68,8,45,32,144,175,208,73,126,243,230,205,242,143,146,210,193,
131,7,229,231,85,213,127,51,253,21,42,122,79,10,64,232,199,159,139,168,189,190,
112,126,76,230,230,230,7,248,73,247,101,76,76,12,181,52,148,229,129,200,172,158,
61,123,254,205,131,145,159,168,64,31,52,104,16,83,39,250,27,167,78,157,98,180,
200,33,85,20,166,76,153,34,159,132,149,168,144,161,66,193,218,218,90,46,36,168,
197,132,174,16,41,215,35,161,188,63,252,240,3,243,247,247,151,11,31,10,100,230,
207,159,255,177,63,247,89,232,56,167,253,100,111,111,127,178,101,203,150,175,68,
249,1,64,51,168,162,72,173,234,59,118,236,144,31,83,112,65,221,121,169,130,74,
227,182,126,249,229,23,249,156,65,129,10,85,22,199,141,27,39,95,212,40,95,190,
124,214,111,156,123,242,77,153,195,131,141,56,94,97,223,70,193,95,80,80,80,129,
43,87,174,124,189,109,219,182,43,60,40,116,229,223,77,5,58,247,83,240,240,169,
40,152,160,139,82,148,110,223,190,45,127,223,20,76,82,64,179,114,229,74,182,
126,253,122,86,179,102,77,249,181,153,51,103,202,193,38,205,230,56,125,250,116,
121,22,195,135,15,31,202,129,41,173,59,66,159,141,90,79,220,221,221,229,11,90,
212,77,143,238,211,194,187,123,247,238,149,203,21,186,56,70,221,187,148,93,252,
92,92,92,216,175,191,254,42,151,79,84,39,162,94,27,116,124,81,119,98,186,88,74,
239,243,169,124,124,124,216,133,11,23,104,225,65,63,126,236,30,17,229,207,14,
180,128,64,190,66,149,70,26,191,65,115,84,83,5,176,100,201,146,114,55,169,172,
100,12,78,232,113,118,3,22,106,113,161,171,227,185,168,61,79,103,69,153,242,162,
239,190,251,46,153,7,33,31,154,11,168,130,205,131,61,185,43,22,117,103,160,194,
65,221,70,142,28,41,119,231,163,202,0,181,94,208,119,173,108,142,167,171,150,
84,136,208,149,32,91,91,91,185,162,145,126,237,27,111,111,111,249,170,19,245,7,
166,66,132,174,108,253,249,231,159,114,80,66,5,145,170,40,187,111,20,46,92,152,
213,170,85,107,51,63,118,255,137,146,0,32,215,209,185,65,121,97,130,126,251,147,
38,77,146,175,66,211,69,12,170,40,210,121,133,206,111,52,166,141,174,118,211,
115,90,140,46,159,231,155,50,231,240,225,195,198,244,253,16,170,51,4,7,7,23,58,
118,236,88,33,122,220,175,95,191,108,215,5,210,163,109,86,173,90,37,95,24,74,76,
76,148,91,39,104,76,33,29,3,244,157,127,255,253,247,114,121,64,193,0,149,47,20,
32,16,10,28,168,219,30,149,23,212,122,50,124,248,112,249,121,154,117,138,234,
54,244,249,202,150,45,43,151,41,212,210,78,199,10,5,41,20,184,82,208,147,190,
203,48,189,39,245,214,160,238,127,116,145,148,130,24,10,108,41,16,166,133,4,45,
44,44,50,251,232,31,69,45,47,212,234,207,131,154,211,131,6,13,10,16,229,207,14,
4,32,144,175,208,201,125,206,156,57,114,228,159,222,199,250,94,210,143,152,
126,84,233,209,99,101,55,25,81,159,205,123,247,238,101,217,183,87,3,206,241,52,
78,148,41,47,250,233,167,159,44,143,31,63,126,222,195,195,67,94,228,131,22,215,
163,239,151,174,26,82,179,184,186,7,244,81,161,68,5,135,18,21,30,233,91,64,136,
178,80,200,12,93,101,162,99,137,174,80,209,182,148,168,64,17,29,83,159,138,154,
240,233,10,107,253,250,245,221,249,62,187,243,243,207,63,139,54,1,128,92,66,173,
169,202,137,75,148,129,9,157,19,168,18,73,149,201,167,79,159,50,95,95,95,109,
110,1,185,192,211,104,81,166,60,34,149,87,210,103,28,57,114,68,30,255,65,223,71,
137,18,37,228,73,107,168,162,223,185,115,103,209,246,153,162,239,147,130,72,10,
50,40,24,81,118,227,166,96,132,238,43,203,21,186,80,74,51,57,42,81,80,64,229,6,
5,163,233,187,145,43,203,58,42,107,232,216,81,214,79,40,96,161,128,130,186,93,
209,182,20,184,16,250,63,40,240,80,110,67,101,167,242,239,43,7,198,127,10,26,95,
75,107,127,240,191,155,196,203,153,189,170,234,245,129,46,88,144,175,208,15,
159,126,100,31,123,141,80,63,125,74,244,152,154,36,189,188,188,228,86,19,66,21,
70,154,25,171,97,195,134,153,190,135,242,106,8,85,60,169,57,146,186,220,80,63,
204,92,68,29,139,35,242,99,226,39,225,78,222,222,222,21,41,232,176,183,183,247,
28,61,122,244,28,91,91,219,68,58,129,211,149,41,117,160,239,159,174,14,41,41,
143,153,156,4,13,84,144,209,204,88,212,47,119,241,226,197,172,103,207,158,242,
113,243,41,3,26,69,168,32,161,130,129,90,94,202,148,41,179,158,31,159,90,55,59,
29,0,252,91,102,231,21,186,154,77,221,135,91,180,104,65,23,95,180,98,106,239,
143,160,2,86,120,254,206,11,137,151,251,230,15,31,62,28,74,221,148,108,108,108,
34,155,55,111,190,178,87,175,94,174,180,239,63,119,129,91,229,184,158,204,102,
66,84,6,0,52,166,144,38,49,81,62,71,19,229,208,180,242,21,43,86,148,199,136,
144,176,176,48,57,208,160,64,149,234,31,148,143,142,27,250,140,212,202,66,229,
11,181,174,80,240,74,129,66,70,148,55,39,229,87,122,183,110,221,146,39,92,225,
129,208,181,111,191,253,246,154,40,127,118,161,5,4,242,13,250,113,210,149,129,
204,154,76,169,18,75,253,37,233,7,174,60,177,127,247,221,119,172,71,143,30,114,
159,91,234,163,79,125,52,105,208,22,245,249,164,233,117,73,250,1,233,116,21,97,
197,138,21,242,251,208,73,128,18,93,229,160,31,126,46,250,244,246,225,60,224,
208,161,67,86,139,22,45,154,86,180,104,81,207,166,77,155,254,197,239,239,30,59,
118,108,229,219,183,111,255,72,87,149,170,87,175,46,122,139,28,57,124,248,176,
220,109,138,102,148,82,14,36,39,116,76,209,227,140,199,22,189,158,126,146,2,101,
33,65,207,209,21,52,58,182,168,233,155,62,47,181,82,80,215,11,85,162,105,119,
105,90,68,30,236,188,227,129,240,121,190,223,68,155,0,128,134,40,7,161,167,63,
79,208,173,178,203,15,221,210,99,101,217,69,23,40,168,143,63,77,176,65,93,94,
148,19,158,104,153,124,81,230,80,165,124,228,200,145,227,222,190,125,91,180,117,
235,214,235,59,118,236,184,98,218,180,105,15,74,150,44,233,76,83,33,211,236,87,
57,69,101,133,242,59,206,236,53,101,57,66,45,226,212,205,247,235,175,191,150,
131,7,26,79,72,93,167,40,32,162,114,136,186,143,83,185,66,249,233,24,82,150,67,
132,30,211,24,84,234,214,75,23,66,169,94,67,207,209,5,84,202,163,156,116,39,253,
177,247,177,114,44,43,84,207,217,181,107,151,124,91,163,70,141,67,118,118,118,
170,155,170,77,25,29,101,149,0,62,129,37,79,1,142,142,142,146,166,241,31,160,
244,234,213,43,137,255,120,255,243,26,63,201,72,94,94,94,210,147,39,79,62,164,
240,240,240,15,175,211,107,103,206,156,145,220,221,221,165,164,164,164,15,207,
71,70,70,74,161,161,161,242,125,186,125,254,252,185,188,237,211,167,79,255,181,
189,166,185,185,185,209,15,147,210,38,193,247,145,39,241,239,162,207,248,241,
227,167,172,95,191,94,238,139,203,255,101,131,6,13,26,236,167,187,27,55,110,20,
237,158,28,123,247,238,157,20,24,24,40,223,15,14,14,150,98,99,99,229,251,137,
137,137,242,243,116,140,165,23,19,19,243,225,248,160,99,140,182,167,188,65,65,
65,18,63,97,203,207,243,192,67,226,65,130,196,131,5,73,213,150,47,95,46,31,7,
221,187,119,63,47,225,92,13,186,137,58,179,251,217,219,219,127,248,205,105,11,
58,135,196,197,197,253,235,60,65,231,17,101,25,69,175,209,185,130,7,30,82,64,
64,192,135,207,255,250,245,107,41,36,36,228,163,239,155,27,232,60,198,222,151,
57,219,5,223,71,158,224,231,231,103,189,104,209,162,197,163,71,143,254,112,5,
113,194,132,9,29,120,32,152,210,180,105,83,137,7,4,162,93,146,41,250,14,233,59,
166,239,54,179,215,232,251,78,95,71,161,50,227,220,185,115,210,149,43,87,62,252,
77,58,22,238,222,189,43,61,126,252,88,126,175,161,67,135,74,60,32,253,80,182,
40,81,93,229,234,213,171,210,245,235,215,229,191,71,101,12,255,191,228,186,9,
189,47,81,30,99,132,202,175,244,199,95,118,208,251,241,160,76,42,94,188,120,196,
218,181,107,63,125,68,126,86,36,4,32,160,90,185,22,128,232,146,252,30,128,240,2,
216,36,253,227,111,191,253,182,60,63,1,70,218,216,216,200,39,103,120,31,20,181,
104,209,66,50,54,54,78,153,57,115,166,122,167,4,3,208,94,90,27,128,228,39,249,
45,0,185,119,239,30,173,132,254,175,166,128,134,13,27,110,228,55,242,133,157,
220,68,1,69,163,70,141,164,149,43,87,74,223,127,255,189,212,187,119,239,92,187,
224,185,105,211,38,249,123,175,93,187,246,30,73,197,241,0,198,128,0,128,214,41,
86,172,216,135,206,172,116,210,123,241,226,197,192,208,208,208,130,52,40,144,
22,252,3,38,79,215,72,131,1,43,86,172,232,207,3,180,227,162,252,0,0,240,94,157,
58,117,146,21,10,197,135,26,245,222,189,123,203,250,251,251,119,163,113,123,52,
45,110,110,226,193,7,91,182,108,153,220,173,138,186,239,210,52,190,52,203,161,
166,81,151,64,90,251,195,196,196,68,170,92,185,242,142,79,233,186,149,29,24,3,2,
0,90,237,238,221,187,38,190,190,190,67,105,124,5,141,213,129,247,104,145,42,
234,43,236,224,224,176,159,23,78,81,162,252,0,0,144,185,227,199,143,247,14,9,9,
41,70,11,245,101,92,200,56,55,52,104,208,64,78,185,137,198,45,210,130,136,60,
40,123,52,127,254,252,203,52,254,85,149,208,2,2,0,90,109,205,154,53,245,125,
124,124,108,233,74,80,227,198,141,69,217,117,2,77,223,72,131,84,121,224,17,233,
232,232,184,89,148,31,0,0,50,183,97,195,6,131,123,247,238,117,163,214,118,92,
228,250,7,173,99,66,235,76,241,0,100,167,157,157,93,140,40,255,167,66,0,2,0,90,
237,238,221,187,221,162,162,162,76,104,86,18,229,252,231,186,206,217,217,153,
186,165,209,140,109,247,126,250,233,167,231,162,252,0,0,144,185,91,183,110,85,
241,241,241,105,64,211,226,106,98,129,219,188,128,151,185,114,0,98,110,110,30,
221,177,99,71,181,116,241,69,0,2,0,90,235,228,201,147,54,225,225,225,131,169,
255,107,175,94,189,68,217,117,2,93,165,163,105,17,169,75,90,139,22,45,78,42,20,
10,213,77,139,8,0,160,99,252,252,252,70,197,199,199,23,160,105,111,105,113,98,
120,127,145,139,22,197,172,82,165,138,251,130,5,11,158,138,242,231,4,2,16,0,208,
90,171,87,175,110,22,20,20,100,211,182,109,219,220,94,113,94,107,60,123,246,76,
94,4,179,116,233,210,175,218,180,105,179,71,148,31,0,0,50,119,233,210,165,2,
143,30,61,234,76,107,133,245,239,223,95,148,93,39,208,154,31,52,248,156,102,193,
178,177,177,89,173,167,167,167,150,139,92,8,64,0,64,43,241,115,159,226,233,211,
167,3,147,146,146,24,13,12,84,245,12,28,121,213,254,253,251,89,116,116,52,205,
142,114,161,125,251,246,175,68,249,1,242,3,94,73,252,207,180,169,0,159,107,206,
156,57,77,95,191,126,93,161,121,243,230,52,161,135,40,187,78,160,238,189,167,79,
159,102,37,75,150,12,108,216,176,225,121,81,254,156,66,0,2,0,90,105,198,140,25,
118,33,33,33,78,182,182,182,140,86,63,7,198,34,35,35,217,129,3,7,152,165,165,37,
107,211,166,205,97,81,126,128,252,130,7,31,14,203,150,45,91,177,97,195,6,213,46,
134,6,58,139,2,218,208,208,208,47,226,226,226,244,105,140,33,173,26,14,114,215,
103,22,30,30,78,221,175,174,254,252,243,207,175,69,249,115,10,1,8,0,104,37,55,
55,183,161,188,194,109,217,179,103,79,86,164,72,17,81,118,157,240,247,223,127,
51,119,119,119,42,24,188,39,79,158,236,42,202,15,144,95,240,160,251,209,253,
251,247,237,231,206,157,123,125,248,240,225,43,206,157,59,87,37,237,37,181,116,
15,129,252,111,206,156,57,21,222,188,121,211,187,116,233,210,172,83,167,78,162,
236,58,33,49,49,145,237,222,189,155,6,159,167,54,105,210,100,87,250,181,82,84,
13,1,8,0,104,157,203,151,47,155,63,126,252,184,187,177,177,49,166,69,76,135,
214,254,160,171,116,149,43,87,222,194,11,134,183,162,252,0,249,133,141,141,77,
82,231,206,157,231,241,187,5,119,238,220,57,126,226,196,137,127,15,27,54,108,
25,175,68,86,229,207,165,136,182,7,200,232,202,149,43,221,66,66,66,10,246,232,
209,131,89,91,91,139,178,235,132,219,183,111,203,139,220,242,253,225,62,101,202,
148,115,162,252,159,3,1,8,0,104,157,35,71,142,116,10,13,13,173,69,235,126,56,58,
58,138,178,235,132,151,47,95,178,83,167,78,81,69,44,166,127,255,254,39,68,249,
1,242,2,73,146,244,54,111,222,172,95,180,104,81,90,24,217,136,39,99,158,76,
120,50,205,152,46,94,188,120,179,118,237,218,39,104,38,184,39,79,158,20,217,179,
103,207,196,141,27,55,94,208,211,211,43,145,246,94,31,251,51,0,255,194,143,165,
130,193,193,193,163,13,13,13,25,117,191,130,247,191,31,106,253,160,65,232,188,
220,61,204,127,147,9,162,109,62,7,86,66,135,28,187,119,239,158,93,80,80,80,114,
151,46,93,94,138,242,2,100,215,195,135,15,245,135,12,25,210,149,86,249,30,52,
104,144,60,221,44,48,121,80,96,72,72,8,107,214,172,217,41,254,155,115,23,229,7,
208,86,94,94,94,133,182,110,221,218,245,250,245,235,173,91,182,108,89,154,7,215,
49,225,225,225,201,236,159,224,131,210,127,126,248,107,215,174,149,76,76,76,
138,42,31,83,119,17,95,95,95,185,127,38,45,152,22,17,17,33,143,143,2,16,217,181,
107,87,77,126,28,86,173,91,183,46,171,95,191,190,40,187,78,224,245,57,90,17,158,
186,95,133,214,172,89,115,203,145,35,71,68,155,124,22,148,236,144,99,97,97,97,
201,107,214,172,217,192,15,212,163,243,230,205,219,222,181,107,215,8,254,116,
170,104,59,128,172,252,249,231,159,69,252,252,252,218,23,47,94,28,253,114,211,
36,39,39,203,211,34,242,202,87,106,227,198,141,15,171,179,95,46,128,58,13,29,
58,212,110,212,168,81,7,222,188,121,83,210,192,192,224,116,197,138,21,47,241,
74,224,117,254,187,167,5,53,149,199,117,166,199,55,63,238,83,155,55,111,190,
204,217,217,89,30,255,65,221,17,139,21,43,22,29,26,26,106,100,106,106,106,100,
97,97,145,217,102,0,255,113,227,198,141,30,241,241,241,138,190,125,251,50,234,
234,11,76,158,222,157,151,189,140,215,233,174,205,158,61,219,95,148,255,115,161,
11,22,228,88,187,118,237,94,242,138,209,85,47,47,175,21,227,198,141,251,187,99,
199,142,227,70,140,24,81,152,33,8,129,207,240,234,213,171,62,225,225,225,37,58,
119,238,76,107,93,136,178,235,4,55,55,55,118,253,250,117,86,181,106,213,96,254,
91,187,40,202,15,160,141,120,160,97,119,239,222,189,179,69,139,22,141,169,83,
167,78,45,126,255,171,125,251,246,45,228,193,199,21,254,114,16,79,193,105,41,36,
179,116,240,224,193,162,188,188,233,146,146,146,66,231,134,119,173,91,183,94,61,
96,192,128,54,169,169,169,65,52,77,183,158,30,170,52,32,182,124,249,242,146,
175,95,191,238,71,11,220,210,36,39,240,126,237,143,189,123,247,202,193,88,253,
250,245,213,219,244,161,68,125,190,68,9,224,99,146,146,146,10,87,169,82,229,25,
191,43,241,3,87,42,85,170,148,55,47,4,226,120,4,45,129,250,240,10,41,253,48,41,
109,18,124,69,121,10,255,215,244,236,237,237,111,232,235,235,75,103,207,158,21,
237,6,157,49,109,218,52,249,251,30,54,108,216,106,9,107,33,64,30,196,131,135,
242,245,234,213,123,62,113,226,196,171,252,24,206,81,83,69,239,222,189,183,22,
47,94,60,162,109,219,182,127,45,92,184,80,57,11,22,117,215,242,227,231,13,137,
87,162,68,63,37,200,161,7,15,30,40,203,156,237,31,255,134,242,134,78,157,58,
125,99,96,96,32,245,239,223,95,244,111,235,12,15,15,15,169,64,129,2,82,249,242,
229,95,92,187,118,173,40,211,0,116,193,210,65,43,87,174,44,180,120,241,98,211,
176,176,48,179,228,228,228,130,9,9,9,102,252,248,51,99,239,79,228,233,111,41,
101,121,73,201,208,208,80,42,91,182,108,40,175,48,86,162,62,251,1,1,1,182,244,
60,191,149,163,233,62,125,250,160,15,63,100,27,175,96,212,122,249,242,101,181,
234,213,171,51,90,24,10,24,123,253,250,53,85,222,24,13,8,172,83,167,206,38,116,
191,130,188,232,212,169,83,83,227,227,227,35,121,165,175,39,63,134,35,69,249,51,
226,21,164,170,188,76,9,183,178,178,106,186,126,253,250,135,212,93,36,141,81,86,
219,1,164,183,121,243,102,189,217,179,103,119,163,43,254,131,7,15,22,101,215,25,
212,197,151,22,184,117,116,116,220,215,180,105,211,55,162,252,170,128,246,74,29,
114,238,220,57,171,110,221,186,205,223,186,117,171,7,47,0,78,243,131,108,29,63,
153,119,230,193,71,67,254,114,45,158,170,243,84,137,167,10,60,217,240,68,81,176,
149,40,37,37,37,25,102,252,91,212,68,78,7,51,192,167,184,119,239,94,141,216,216,
88,139,94,189,122,49,83,83,83,81,118,157,112,226,196,9,230,227,227,195,236,237,
237,221,38,77,154,244,64,148,31,64,219,240,50,162,224,195,135,15,59,150,42,85,
106,85,179,102,205,194,68,249,51,99,96,96,224,59,111,222,188,201,20,124,136,242,
2,124,12,63,14,11,6,5,5,213,162,5,110,91,182,108,41,202,174,19,194,194,194,
228,41,222,11,22,44,24,239,228,228,116,72,148,95,85,112,105,90,71,52,104,208,
160,212,119,223,125,119,210,144,179,180,180,156,214,191,127,255,11,252,113,44,
15,68,226,69,219,102,133,7,47,166,14,14,14,221,105,246,4,154,206,142,7,52,65,
161,161,161,69,202,150,45,107,60,98,196,8,209,230,0,255,162,167,167,215,128,250,
160,182,110,221,90,148,85,39,4,6,6,178,185,115,231,178,66,133,10,49,94,48,172,
248,220,223,43,64,110,216,180,105,83,41,30,132,24,243,178,39,199,227,151,120,0,
142,99,31,62,219,221,187,119,171,166,164,164,20,107,218,180,169,124,94,5,198,22,
47,94,76,51,211,177,70,141,26,157,230,65,254,157,249,243,231,139,54,81,9,180,
128,232,128,239,191,255,190,116,76,76,204,81,234,210,178,107,215,174,182,23,46,
92,216,55,109,218,180,183,170,168,204,116,239,222,125,252,203,151,47,171,151,
42,85,202,135,191,255,143,29,59,118,108,149,154,154,250,90,194,216,33,77,201,
87,59,58,57,57,217,154,6,146,22,40,80,64,148,53,223,243,246,246,102,95,126,249,
165,220,250,65,205,226,179,103,207,214,216,149,41,0,85,90,181,106,149,145,185,
185,185,255,143,63,254,248,201,93,175,64,235,228,233,50,39,34,34,130,38,202,49,
65,25,195,88,124,124,60,91,182,108,25,251,227,143,63,104,225,193,208,78,157,58,
205,227,245,66,141,45,234,169,117,45,32,70,70,70,122,188,2,171,144,222,15,180,
252,112,155,33,177,12,247,115,139,114,80,86,250,251,114,74,235,167,45,223,82,50,
53,53,149,34,35,35,53,254,195,165,64,160,125,251,246,75,74,150,44,105,184,114,
229,202,142,252,179,4,137,182,201,174,179,103,207,218,240,131,183,83,133,10,21,
126,154,60,121,242,134,111,190,249,38,148,63,93,144,33,176,213,164,68,81,134,
188,196,198,198,198,45,32,32,160,207,188,121,243,216,15,63,252,192,168,153,156,
90,214,116,1,253,86,169,64,120,241,226,5,59,127,254,60,91,179,102,13,205,8,70,
179,205,61,26,60,120,240,55,170,184,96,0,144,27,248,49,109,146,146,146,114,151,
7,210,111,69,121,65,235,105,172,130,170,14,29,59,118,244,242,246,246,14,63,
116,232,80,145,22,45,90,48,93,107,9,161,238,241,161,161,161,242,204,138,155,55,
111,102,103,206,156,97,229,202,149,75,226,193,199,216,153,51,103,222,21,109,175,
74,185,18,128,204,159,63,223,234,226,197,139,189,111,221,186,85,62,57,57,217,
44,33,33,193,148,7,29,242,226,67,137,137,137,52,160,44,125,50,76,75,6,233,146,
126,90,162,251,185,85,217,165,169,102,83,210,82,114,186,91,74,73,236,125,197,80,
121,155,152,148,148,68,183,84,129,136,55,48,48,136,163,84,187,118,237,224,17,35,
70,108,231,21,119,181,157,148,103,205,154,229,192,15,182,54,188,98,215,66,149,
193,7,177,178,178,178,24,61,122,244,168,30,61,122,120,241,255,65,249,116,174,28,
83,58,44,95,5,32,78,78,78,135,121,160,254,213,193,131,7,237,104,225,61,154,38,
145,230,250,215,21,252,60,193,222,189,123,39,7,34,69,138,20,137,111,221,186,245,
129,229,203,151,255,82,173,90,181,40,209,182,0,218,42,42,42,202,64,66,179,120,
126,145,167,3,16,94,255,244,189,125,251,246,129,27,55,110,140,28,48,96,128,130,
214,155,210,165,117,64,104,240,61,45,218,25,30,30,78,93,158,165,202,149,43,223,
107,210,164,201,247,171,87,175,190,66,23,189,52,73,163,149,69,126,254,49,24,55,
110,92,155,45,91,182,252,254,252,249,243,234,116,62,178,182,182,102,180,120,144,
174,84,50,232,127,166,217,162,168,111,247,157,59,119,254,191,189,251,0,139,234,
232,250,0,62,139,82,20,68,176,16,197,94,147,216,176,107,176,247,30,107,84,68,
141,41,150,136,70,99,137,198,36,230,213,79,19,123,137,37,182,228,53,182,196,94,
80,172,24,84,236,29,81,193,2,136,74,85,164,73,135,251,205,153,176,188,88,7,112,
247,178,176,255,223,243,204,179,203,238,185,187,203,150,123,231,220,105,244,5,
232,246,224,193,131,94,60,3,141,147,109,155,19,107,215,174,173,104,101,101,117,
211,205,205,205,151,230,73,215,165,134,13,27,250,200,98,64,239,18,101,1,121,201,
220,185,115,111,45,88,176,160,51,223,25,118,230,191,11,43,254,59,161,153,216,10,
165,23,243,244,162,61,57,65,215,181,39,39,50,159,164,40,144,233,82,183,95,250,
87,209,116,162,150,236,223,53,12,178,130,78,92,36,191,169,240,253,65,74,165,74,
149,82,106,212,168,17,209,168,81,163,93,211,167,79,63,202,147,143,183,60,28,128,
225,227,199,61,250,45,230,214,201,66,208,173,20,89,128,33,163,46,70,252,251,232,
210,173,91,55,119,174,92,88,88,24,237,191,181,179,127,82,121,249,56,163,61,17,
94,240,165,82,32,83,201,13,169,236,197,147,224,153,75,198,201,239,244,146,152,
94,196,73,112,126,156,137,179,180,180,124,206,19,143,160,117,235,214,237,227,
245,207,231,188,94,254,154,167,208,47,85,19,144,79,63,253,180,131,167,167,167,
27,117,49,232,209,163,7,27,62,124,56,171,87,175,30,173,100,106,84,83,181,62,
127,254,92,52,127,241,100,140,93,184,112,161,221,140,25,51,104,246,169,11,178,
237,114,130,255,208,44,121,101,38,128,255,232,242,244,78,3,222,40,95,37,32,100,
210,164,73,247,248,197,114,89,220,27,100,78,56,244,157,124,144,79,120,233,196,
75,70,19,96,22,188,113,181,103,58,59,69,99,63,168,184,186,186,190,124,55,64,94,
101,194,144,128,228,23,121,190,46,145,94,31,218,38,139,123,11,205,75,151,185,
229,141,199,146,183,161,227,12,213,67,169,171,47,79,62,100,225,122,163,90,173,
127,206,156,57,181,151,47,95,190,62,52,52,148,45,90,180,136,141,25,51,198,168,
146,142,204,138,20,41,194,168,239,225,160,65,131,216,180,105,211,76,206,159,63,
79,11,42,233,37,1,225,95,50,139,184,184,184,99,12,242,171,124,151,128,188,163,
204,59,226,108,237,148,115,136,90,52,148,244,75,0,120,61,74,62,114,187,178,6,
186,145,231,19,16,29,200,81,197,31,94,164,202,25,137,128,128,128,130,174,174,
174,147,31,61,122,100,247,213,87,95,177,241,227,199,27,109,242,145,217,147,39,
98,173,151,20,91,91,219,16,89,108,78,197,198,198,22,58,114,228,136,159,44,14,
242,44,12,76,206,93,168,84,1,200,233,187,5,4,39,0,212,147,44,11,0,200,10,125,
238,16,50,252,249,231,159,53,111,223,190,221,187,116,233,210,236,219,111,191,
149,133,27,5,106,254,250,231,159,127,40,17,139,45,89,178,164,222,22,23,75,75,75,
163,254,141,170,124,206,144,43,242,213,32,116,0,200,151,244,153,128,80,242,129,
150,96,245,228,233,65,232,96,56,244,181,67,120,193,177,99,199,186,63,123,246,
204,170,111,223,190,172,76,153,50,178,112,163,112,225,194,5,230,229,229,197,74,
149,42,117,173,121,243,230,250,92,246,158,38,187,86,251,44,45,154,37,213,131,22,
16,0,48,116,250,236,130,69,9,72,188,44,8,116,6,39,189,64,39,244,158,128,248,
250,250,218,132,133,133,57,211,92,254,131,7,15,150,133,27,141,45,91,182,136,249,
152,235,212,169,227,58,113,226,68,125,246,169,180,148,5,232,24,253,47,145,178,
32,208,25,36,32,0,96,232,244,185,110,23,37,32,122,153,69,18,94,11,9,8,232,132,
222,19,144,5,11,22,180,12,14,14,254,160,113,227,198,172,126,253,250,178,112,163,
64,83,240,186,185,185,49,91,91,219,160,118,237,218,237,144,197,191,35,181,151,
251,164,4,68,111,235,154,192,43,208,245,0,0,12,157,62,91,64,168,197,29,45,32,
234,65,2,2,58,161,247,4,196,203,203,171,79,116,116,180,166,127,255,254,70,179,
162,177,12,173,60,73,73,136,157,157,221,225,137,19,39,6,202,226,223,17,181,128,
232,107,199,255,58,104,1,81,23,90,64,0,192,208,233,115,12,8,141,73,64,2,162,30,
156,244,2,157,208,215,14,65,88,184,112,225,123,247,238,221,107,95,170,84,41,214,
171,87,47,89,184,81,72,73,73,17,221,175,204,204,204,104,33,191,173,178,120,29,
80,187,5,132,14,6,209,88,244,86,53,56,24,0,128,161,211,103,23,44,58,216,96,63,
168,30,188,215,160,19,122,77,64,46,93,186,228,20,21,21,85,166,115,231,206,172,
92,185,114,178,112,163,112,227,198,13,118,234,212,41,86,190,124,121,191,209,
163,71,95,146,197,235,128,153,44,64,199,168,63,110,172,44,8,116,6,205,225,0,96,
232,244,153,128,96,22,44,117,225,189,6,157,208,91,2,18,23,23,103,126,245,234,
213,222,52,208,122,224,192,129,178,112,163,177,99,199,14,150,148,148,196,222,
123,239,189,63,154,53,107,246,84,22,159,71,97,64,160,122,144,128,0,128,161,211,
103,2,66,45,32,9,104,117,87,13,186,187,129,78,232,109,53,192,197,139,23,55,11,
14,14,118,172,83,167,14,115,116,116,204,184,253,210,165,75,204,198,198,70,180,
4,180,109,219,150,89,88,88,208,52,189,236,233,211,167,98,117,240,138,21,43,
138,56,63,63,63,177,76,188,149,149,21,235,212,169,19,43,81,162,132,88,62,158,
166,175,165,82,181,106,85,214,174,93,59,102,110,110,46,30,211,206,206,142,90,21,
88,66,66,2,59,119,238,156,120,172,59,119,238,48,218,41,221,191,127,159,57,56,
56,136,24,26,252,253,240,225,67,214,170,85,43,113,27,185,123,247,46,243,244,
244,100,246,246,246,172,117,235,214,226,49,99,98,98,68,108,68,68,132,120,172,
154,53,107,190,238,223,204,22,90,120,112,219,182,109,244,255,199,242,247,196,
245,244,233,211,178,77,116,65,187,82,179,154,196,25,18,122,239,53,26,125,29,115,
140,91,166,131,45,22,133,2,0,67,167,239,3,129,24,11,135,99,142,254,100,58,230,
32,1,1,157,208,75,11,8,255,162,106,60,60,60,122,71,69,69,21,164,181,63,138,20,
41,146,113,223,252,249,243,217,144,33,67,216,254,253,251,89,124,124,60,155,56,
113,34,251,251,239,191,69,18,64,183,211,218,24,161,161,161,108,212,168,81,226,
146,146,137,47,190,248,66,196,110,221,186,149,77,158,60,153,86,247,102,191,253,
246,27,251,207,127,254,35,30,115,209,162,69,34,137,33,148,200,76,152,48,129,37,
39,39,139,248,1,3,6,176,141,27,55,138,133,255,166,76,153,194,214,175,95,47,18,
1,103,103,103,118,253,250,117,118,237,218,53,54,98,196,8,246,224,193,3,113,31,
61,62,61,215,180,105,211,216,225,195,135,89,100,100,36,251,242,203,47,217,197,
139,23,95,247,175,102,11,117,189,186,119,239,30,43,94,188,248,177,121,243,230,
121,201,226,117,36,137,169,127,150,60,37,58,58,154,61,123,246,76,22,7,57,68,147,
24,164,211,231,20,206,0,0,186,160,207,22,16,18,79,39,13,113,204,209,31,237,49,
199,194,194,2,61,28,64,39,244,210,2,242,227,143,63,218,248,250,250,118,163,214,
11,74,64,50,75,76,76,100,29,58,116,96,51,103,206,100,199,143,31,23,173,23,123,
247,238,21,45,29,113,113,113,108,213,170,85,34,225,120,244,232,17,235,214,173,
27,171,85,171,22,163,150,2,237,125,179,103,207,22,45,18,193,193,193,162,101,
228,235,175,191,102,5,10,20,200,156,157,103,92,167,231,162,150,11,26,244,77,137,
141,187,187,187,88,125,156,90,83,42,84,168,192,194,195,195,105,149,118,214,163,
71,15,145,240,80,242,210,181,107,87,118,249,242,101,81,40,73,249,236,179,207,
24,141,97,177,182,182,102,239,138,18,45,254,90,211,202,151,47,191,89,197,179,
52,137,76,229,62,155,212,170,69,159,31,189,223,159,124,242,137,44,28,114,128,
190,75,244,29,226,201,125,26,37,123,0,0,198,138,215,31,18,168,130,124,228,200,
17,230,228,228,36,11,135,28,160,19,186,116,204,41,86,172,88,92,166,19,96,0,57,
166,151,22,144,27,55,110,180,229,21,208,10,212,205,233,131,15,62,120,225,62,74,
22,26,52,104,32,174,83,23,169,176,176,48,209,218,224,226,226,194,2,3,3,69,107,
73,221,186,117,69,171,4,181,70,116,236,216,81,36,15,212,234,65,9,69,237,218,
181,197,182,212,157,138,98,41,17,49,49,49,201,104,118,165,150,15,45,186,157,186,
89,209,125,212,194,242,222,123,239,137,228,131,80,146,67,93,184,110,221,186,37,
42,202,99,198,140,97,63,253,244,147,88,169,157,102,168,154,55,111,158,104,165,
161,228,99,237,218,181,172,80,161,66,236,93,208,243,83,151,178,146,37,75,134,
242,255,213,93,22,175,67,148,124,168,218,2,210,188,121,243,83,252,115,78,229,
137,40,187,125,251,182,44,28,178,105,195,134,13,226,96,192,191,203,183,191,250,
234,171,7,178,120,0,128,252,172,125,251,246,231,204,205,205,83,233,24,238,237,
237,45,11,135,108,218,188,121,179,40,165,74,149,10,28,54,108,152,191,44,30,32,
43,116,222,2,194,147,138,2,67,135,14,29,165,40,138,9,157,137,160,36,224,101,
218,22,10,74,6,120,133,156,22,43,20,149,126,26,219,65,104,252,71,163,70,141,24,
175,92,137,157,9,181,68,212,168,81,67,196,80,194,97,107,107,43,154,3,169,85,132,
18,134,130,5,11,138,228,68,187,45,221,254,242,243,210,243,80,243,44,37,50,212,
218,178,110,221,58,86,185,114,101,250,65,177,46,93,186,136,150,14,122,12,87,87,
87,17,75,99,84,232,250,227,199,143,217,183,223,126,203,126,253,245,87,54,103,
206,28,17,67,175,35,187,45,24,212,202,67,207,223,186,117,235,131,253,250,245,83,
179,157,153,234,227,76,0,0,32,0,73,68,65,84,88,245,22,16,158,104,185,243,3,194,
65,15,15,143,238,31,127,252,177,232,102,71,201,30,125,110,144,51,52,254,41,32,
32,64,180,230,81,75,32,181,200,117,239,222,125,241,220,185,115,177,232,35,0,24,
181,221,187,119,31,230,251,195,35,135,14,29,234,210,179,103,79,209,13,155,122,
90,20,43,86,76,182,41,188,1,213,211,232,152,67,173,237,43,87,174,100,150,150,
150,180,156,194,175,63,255,252,51,154,63,64,39,116,158,128,240,44,185,226,221,
187,119,27,80,98,64,173,7,47,163,10,60,173,133,65,120,37,149,173,94,189,90,180,
54,84,169,82,133,253,254,251,239,98,92,7,141,215,160,22,137,241,227,199,139,25,
163,40,81,169,94,189,186,120,60,186,109,240,224,193,236,224,193,131,98,192,56,
181,106,80,178,66,9,5,37,23,39,79,158,20,219,16,186,212,94,167,24,154,10,152,90,
85,170,85,171,38,198,123,208,15,235,243,207,63,167,1,243,34,41,161,150,22,127,
127,127,241,60,75,151,46,101,103,207,158,21,171,183,211,227,82,75,14,117,43,26,
55,110,156,168,0,82,146,146,85,52,48,158,102,191,226,137,75,98,217,178,101,87,
201,226,117,140,222,0,85,7,42,243,228,44,245,226,197,139,163,166,76,153,178,224,
204,153,51,189,120,34,105,65,173,85,52,184,95,11,131,5,223,46,115,151,66,122,
159,232,111,250,93,208,119,137,127,247,130,123,247,238,189,148,255,118,126,255,
239,127,255,251,150,71,1,181,241,253,151,185,183,183,119,17,190,143,73,184,115,
231,142,73,241,226,197,205,75,149,42,165,153,57,115,102,152,108,91,178,113,227,
198,130,126,126,126,101,235,214,173,27,194,43,82,178,69,38,53,221,186,117,43,85,
161,66,133,112,94,65,192,88,32,48,90,124,31,153,196,143,223,95,240,171,43,79,
156,56,209,141,215,31,76,95,62,230,64,246,100,62,230,148,46,93,58,146,31,115,
150,173,88,177,98,17,141,191,5,208,5,157,39,32,251,246,237,235,24,25,25,105,75,
173,31,252,224,251,202,253,52,16,92,59,211,21,205,134,69,221,73,54,109,218,36,
186,95,45,89,178,132,53,105,210,68,220,71,73,1,117,89,162,46,91,212,250,64,219,
76,154,52,73,140,221,240,241,241,17,73,2,13,48,39,212,122,65,59,27,122,140,239,
191,255,94,252,104,168,5,132,90,78,168,117,132,20,46,92,88,36,41,212,117,133,
250,204,211,192,116,106,85,161,66,219,210,0,113,106,17,153,62,125,186,120,93,84,
177,163,24,26,11,66,73,10,255,241,137,237,232,204,51,157,141,206,14,26,192,78,
143,195,255,135,107,163,70,141,242,162,255,87,69,137,180,115,86,123,138,66,158,
240,61,230,23,78,157,58,117,106,236,238,238,94,61,38,38,198,132,23,250,48,204,
210,139,121,166,98,193,75,161,244,75,179,76,151,230,153,174,155,50,253,14,98,84,
3,45,210,72,201,32,37,133,84,185,76,124,169,208,109,241,153,174,39,177,255,
117,161,163,237,82,120,50,158,50,108,216,48,207,249,243,231,63,92,179,102,205,
171,207,0,185,42,36,36,100,8,223,63,180,120,248,240,97,48,255,221,61,50,51,51,
107,98,106,106,106,201,239,234,35,219,150,240,237,202,243,253,219,45,59,59,59,
58,123,227,33,9,215,240,36,231,47,254,219,118,230,215,31,75,98,1,242,181,58,
117,234,4,243,139,222,125,251,246,109,113,228,200,145,106,252,120,99,73,133,253,
123,108,161,162,61,222,152,189,84,232,184,100,154,126,89,32,253,82,123,61,175,
163,3,127,42,251,223,177,135,46,83,210,175,107,139,246,24,147,249,88,68,199,161,
120,94,255,122,110,111,111,255,156,31,115,206,254,252,243,207,119,168,37,4,64,
87,52,89,169,152,102,245,76,117,64,64,64,225,182,109,219,158,8,10,10,106,72,
179,82,53,107,214,76,182,73,158,66,227,85,104,92,8,255,49,190,182,107,217,155,
140,30,61,90,204,218,213,191,127,255,153,219,182,109,251,73,22,175,43,252,179,
45,200,147,169,153,169,169,169,243,98,99,99,35,101,241,0,144,109,253,121,233,
196,127,107,95,240,253,164,201,39,159,124,226,106,101,101,117,229,233,211,167,
157,202,151,47,255,125,187,118,237,202,89,90,90,106,120,98,114,204,214,214,182,
156,155,155,219,211,208,208,80,90,156,213,115,196,136,17,180,118,129,217,240,
225,195,155,222,190,125,187,240,236,217,179,189,249,126,179,224,149,43,87,252,
59,118,236,216,190,72,145,34,41,252,49,66,58,116,232,224,235,234,234,218,148,
63,70,50,143,189,124,224,192,129,138,59,119,238,172,93,177,98,69,255,21,43,86,
172,174,86,173,218,0,79,79,207,71,11,23,46,172,121,234,212,169,74,61,123,246,
188,73,253,180,179,186,223,6,80,65,111,246,111,18,62,68,22,8,0,198,65,167,45,32,
83,167,78,109,28,30,30,94,159,186,59,53,108,216,80,22,158,231,80,127,210,79,63,
253,52,91,201,7,37,45,233,227,74,158,181,104,209,226,111,90,7,68,45,91,183,110,
173,248,193,7,31,188,127,254,252,249,40,89,44,0,188,19,171,137,19,39,238,225,9,
70,99,158,24,84,247,243,243,179,229,137,199,64,254,123,47,109,111,111,207,243,
255,88,211,128,128,128,95,121,220,249,164,164,164,114,75,150,44,113,231,49,95,
247,235,215,111,5,223,71,52,183,176,176,72,230,251,207,196,94,189,122,141,166,
46,140,230,230,230,38,251,247,239,95,211,164,73,147,93,124,155,239,248,111,120,
158,183,183,119,232,170,85,171,102,46,94,188,216,181,64,129,2,225,60,145,41,102,
102,102,102,193,247,75,207,251,115,123,246,236,249,133,111,247,112,211,166,77,
21,3,3,3,255,195,183,91,255,214,87,12,0,0,144,75,178,94,147,150,160,181,63,30,
60,120,224,76,93,109,104,234,213,252,216,247,146,186,115,81,151,176,236,160,
177,42,52,118,164,92,185,114,39,198,140,25,227,35,139,215,165,237,219,183,219,
242,231,166,193,42,242,102,46,0,200,49,158,52,196,90,91,91,207,234,216,177,99,
145,241,227,199,87,229,137,193,198,229,203,151,127,23,30,30,158,22,17,17,161,
121,246,236,89,106,112,112,48,37,10,189,102,207,158,189,210,198,198,166,203,143,
63,254,88,159,39,21,221,249,254,242,243,99,199,142,53,171,87,175,30,157,168,
232,156,154,154,42,6,174,241,109,147,163,162,162,196,216,14,126,153,204,147,152,
52,119,119,247,241,252,207,128,67,135,14,181,172,81,163,198,143,60,201,177,104,
222,188,185,221,147,39,79,22,240,215,176,114,232,208,161,195,249,126,234,236,
241,227,199,93,178,210,186,13,0,0,144,27,116,150,128,252,254,251,239,101,248,1,
246,19,106,37,232,222,189,187,44,252,21,116,176,204,111,7,76,26,0,79,179,22,241,
202,136,226,224,224,64,107,127,168,250,15,242,10,76,143,18,37,74,168,58,0,29,
192,8,165,140,28,57,178,235,186,117,235,70,211,66,163,212,221,146,239,7,59,204,
155,55,175,58,191,47,129,90,76,105,226,141,154,53,107,166,126,241,197,23,79,109,
109,109,253,121,146,96,206,127,155,125,248,101,244,216,177,99,207,243,125,67,
196,202,149,43,235,63,127,254,252,175,2,5,10,80,127,117,218,87,36,242,235,98,
159,193,47,173,204,205,205,105,60,84,83,254,88,71,121,124,188,147,147,147,7,255,
59,232,226,197,139,54,161,161,161,69,120,130,50,132,63,198,122,158,140,84,228,
9,11,77,149,137,62,88,0,0,96,144,116,214,5,203,213,213,181,125,96,96,96,209,
129,3,7,102,12,50,207,14,26,28,78,83,235,210,244,121,249,5,77,229,75,131,219,
109,108,108,110,241,247,229,128,154,51,22,241,202,80,205,133,11,23,126,89,173,
90,181,49,180,226,59,0,232,141,201,215,95,127,237,31,22,22,230,80,185,114,229,
21,87,175,94,237,220,187,119,239,223,122,245,234,21,196,19,14,106,50,125,97,
134,42,158,100,68,241,164,164,112,72,72,200,37,126,249,229,222,189,123,235,69,
71,71,63,170,87,175,222,244,238,221,187,159,83,20,37,201,204,204,44,141,146,
146,199,143,31,167,241,191,109,123,244,232,97,159,152,152,232,103,106,106,122,
151,39,34,52,64,125,54,223,174,49,255,187,98,169,82,165,158,248,248,248,132,56,
58,58,254,189,108,217,178,133,195,135,15,119,178,183,183,111,197,242,65,203,39,
181,172,79,157,58,181,213,229,203,151,91,240,68,171,16,79,172,50,15,24,206,60,
104,184,64,166,162,73,191,52,121,169,228,151,132,44,237,13,37,245,53,37,69,91,
120,18,155,204,191,159,41,13,26,52,8,234,223,191,191,107,159,62,125,30,190,246,
209,1,0,84,160,147,4,132,31,24,11,242,138,174,88,242,156,102,158,202,201,224,71,
26,55,66,235,119,16,154,101,138,206,26,166,166,166,102,116,121,162,235,153,23,
28,212,198,209,153,69,90,151,227,101,111,154,230,149,22,42,228,7,237,87,110,
163,88,237,140,89,186,178,115,231,78,22,31,31,207,26,55,110,188,183,83,167,78,
241,178,120,93,185,117,235,86,237,159,127,254,249,64,225,194,133,189,120,37,197,
53,39,159,7,0,100,153,9,175,24,63,228,251,163,103,69,139,22,245,178,182,182,
174,53,110,220,184,63,168,149,162,99,199,142,84,9,164,89,101,168,18,168,221,7,
80,114,145,192,247,109,103,106,213,170,117,102,233,210,165,91,214,174,93,107,
193,221,181,180,180,92,78,179,214,241,152,164,178,101,203,158,191,116,233,210,
151,253,250,245,27,20,19,19,83,130,239,167,34,120,82,179,123,243,230,205,127,
241,219,188,14,30,60,24,254,236,217,179,251,65,65,65,79,120,197,114,153,175,175,
239,28,158,240,56,243,4,200,132,239,147,231,191,241,213,230,17,135,15,31,126,
111,192,128,1,43,255,249,231,159,143,195,195,195,11,82,183,94,154,205,16,114,
134,142,137,180,78,22,21,111,111,239,31,166,79,159,254,127,51,103,206,196,156,
170,0,144,43,116,82,227,230,59,177,122,17,17,17,237,63,252,240,67,214,178,101,
75,89,248,107,209,74,225,79,158,60,17,235,129,204,158,61,91,76,225,75,83,215,
210,212,184,117,234,212,161,133,134,68,130,64,43,157,82,12,63,40,137,117,67,248,
129,95,196,208,106,234,180,38,8,109,67,211,246,210,193,138,214,238,224,21,2,177,
234,57,141,195,88,184,112,161,88,88,144,226,105,61,17,90,77,157,166,230,165,113,
26,148,148,240,131,58,163,241,43,186,168,176,211,162,131,123,246,236,161,214,
143,4,94,9,57,120,226,196,9,217,38,239,140,31,96,204,187,117,235,86,123,226,196,
137,91,249,65,230,182,189,189,125,127,254,191,160,11,22,128,158,241,125,72,252,
181,107,215,186,187,187,187,199,242,36,98,27,37,31,233,119,185,240,162,208,223,
252,247,121,60,253,182,211,188,212,219,178,101,203,3,158,84,244,93,178,100,201,
16,190,191,72,41,83,166,204,150,106,213,170,197,123,122,122,214,225,73,69,208,
140,25,51,46,110,223,190,253,86,92,92,92,193,18,37,74,156,225,251,192,168,49,99,
198,132,243,248,14,124,127,219,135,239,191,182,30,61,122,52,196,205,205,45,54,
62,62,126,37,255,221,223,226,207,211,186,115,231,206,59,127,249,229,151,27,52,
141,120,94,197,247,211,214,46,46,46,91,248,255,214,182,116,233,210,226,152,64,
83,175,99,49,211,156,163,147,120,60,73,101,127,254,249,39,157,28,43,205,143,
157,43,120,18,146,200,143,223,127,200,182,5,0,208,57,237,216,139,183,21,153,102,
205,154,205,166,135,250,241,199,31,149,156,154,55,111,158,50,122,244,104,37,38,
38,70,169,80,161,130,50,117,234,84,197,203,203,75,169,89,179,166,210,181,107,
87,229,202,149,43,202,224,193,131,149,41,83,166,40,124,71,170,244,237,219,87,
113,117,117,85,194,194,194,148,46,93,186,40,252,160,172,60,127,254,92,225,9,144,
178,108,217,50,229,210,165,75,74,155,54,109,148,62,125,250,40,41,41,41,138,147,
147,147,50,103,206,28,229,225,195,135,226,49,70,140,24,161,220,188,121,147,198,
102,40,183,110,221,18,143,223,187,119,111,133,31,247,101,47,53,75,246,237,219,
71,149,14,133,39,79,143,42,85,170,84,143,191,63,181,114,88,106,191,161,212,209,
150,161,67,135,126,202,19,143,53,252,185,78,214,170,85,43,180,83,167,78,235,151,
47,95,110,205,0,64,223,104,26,222,223,101,65,144,61,252,88,240,153,149,149,149,
194,247,157,202,213,171,87,101,187,91,200,134,180,180,52,101,214,172,89,116,96,
87,106,215,174,125,143,39,185,37,100,159,135,14,208,52,188,121,55,35,6,0,157,
123,231,22,144,221,187,119,219,125,243,205,55,3,168,105,156,90,15,114,138,90,55,
168,21,130,239,31,69,75,198,240,225,195,69,75,5,45,20,200,43,212,140,102,136,
105,215,174,29,115,119,119,23,93,177,104,245,244,219,183,111,211,202,235,180,
248,151,88,124,144,86,50,167,46,91,46,46,46,162,21,131,214,223,160,110,80,52,
182,228,220,185,115,172,69,139,22,140,90,34,104,160,60,181,78,80,92,161,66,133,
196,2,136,60,137,17,171,159,151,42,85,74,246,82,165,232,127,160,193,231,244,255,
240,215,154,228,239,239,191,88,182,205,107,80,203,133,118,177,186,4,246,191,133,
233,50,47,78,71,221,56,226,15,29,58,148,106,97,97,113,131,63,223,233,81,163,70,
93,157,60,121,178,215,225,195,135,223,248,192,0,0,134,42,44,44,204,188,125,251,
246,3,168,75,46,237,231,235,214,173,43,219,4,178,129,142,141,223,125,247,29,243,
244,244,164,197,126,171,28,57,114,164,53,191,121,135,108,59,0,0,93,210,69,2,210,
145,39,0,85,168,235,21,37,11,239,138,42,239,148,204,100,94,107,67,59,165,175,
118,108,8,117,213,226,73,15,77,109,43,22,59,172,85,171,150,184,157,14,88,212,
229,74,219,133,74,73,111,189,73,76,76,20,133,186,69,209,120,15,74,58,190,253,
246,91,86,173,90,53,246,215,95,127,137,117,58,214,175,95,207,230,204,153,35,18,
7,74,124,222,5,245,177,165,4,160,120,241,226,129,115,231,206,109,199,19,40,
127,217,54,57,69,205,234,180,214,136,22,79,62,222,18,13,0,96,216,38,76,152,80,
240,222,189,123,214,149,42,85,98,29,59,118,148,133,67,14,208,241,114,208,160,65,
236,208,161,67,236,248,241,227,197,100,241,0,0,186,246,206,211,240,94,191,126,
253,227,132,132,4,49,248,60,187,107,100,188,137,242,82,183,47,237,223,116,73,45,
37,84,193,191,127,255,190,232,23,220,163,71,15,209,194,65,131,189,171,87,175,
46,174,83,75,72,100,100,36,219,177,99,135,72,90,168,85,195,222,222,158,6,131,
179,175,191,254,154,85,173,90,85,140,57,161,241,34,52,46,132,90,66,182,111,223,
46,18,23,127,127,127,49,94,132,238,203,169,125,251,246,137,100,199,214,214,118,
135,62,147,15,0,128,252,230,175,191,254,50,137,139,139,43,80,162,68,9,102,109,
141,158,164,250,66,9,30,225,199,83,221,28,184,1,0,178,225,157,18,144,105,211,
166,149,121,240,224,65,75,170,220,83,23,166,119,81,164,72,17,49,192,144,206,204,
80,23,44,237,140,84,116,16,178,180,180,20,215,173,172,172,196,1,137,6,151,83,
161,51,56,99,199,142,101,14,14,14,236,226,197,139,204,194,194,66,76,227,75,133,
186,112,81,107,7,181,166,208,118,51,103,206,100,179,102,205,98,3,6,12,16,93,173,
40,113,161,193,237,161,161,161,98,240,57,221,94,179,102,77,246,209,71,31,137,
110,94,148,220,228,4,181,180,208,148,194,230,230,230,169,142,142,142,123,101,
241,0,0,240,63,169,169,169,212,132,93,80,23,147,129,192,155,101,234,41,240,206,
61,33,0,0,178,77,121,135,65,232,189,123,247,158,70,11,101,141,28,57,242,149,
129,110,217,197,147,5,37,41,41,73,92,231,149,120,49,80,78,123,157,6,145,19,186,
164,191,181,183,251,248,248,40,81,81,81,226,111,158,72,40,79,159,62,85,246,238,
221,171,60,123,246,76,60,222,162,69,139,148,113,227,198,101,60,7,221,127,253,
250,117,49,208,93,139,158,211,219,219,91,20,237,243,208,245,197,139,23,43,57,
225,233,233,169,240,228,73,169,81,163,198,45,158,20,225,244,29,64,254,134,65,
232,186,87,148,151,107,77,155,54,149,237,110,225,29,208,177,138,253,187,86,204,
55,146,207,67,23,48,8,29,0,94,144,227,51,31,247,239,223,55,239,212,169,83,111,
106,169,160,150,136,119,149,121,13,142,204,235,122,100,190,78,93,188,180,221,
188,232,246,247,223,127,63,227,62,154,82,151,186,97,209,160,116,106,129,160,191,
121,130,194,120,18,146,17,67,131,207,169,100,70,3,197,169,229,35,51,122,142,158,
61,123,178,156,160,231,166,181,73,202,148,41,179,182,81,163,70,209,178,120,0,0,
120,129,104,1,145,5,129,206,224,189,6,0,213,229,120,199,179,118,237,218,118,161,
161,161,245,27,52,104,192,154,52,105,34,11,87,5,13,46,255,227,143,63,216,217,
179,103,197,216,15,90,27,164,100,201,146,178,205,94,65,221,187,114,130,186,115,
237,218,181,139,186,141,69,55,107,214,108,223,209,163,71,101,155,0,64,30,114,
247,238,93,243,170,85,171,166,106,52,154,23,86,55,215,82,20,133,133,135,135,91,
218,217,217,61,127,221,253,144,37,148,128,188,83,247,96,200,22,140,1,1,0,213,
229,104,39,79,7,217,11,23,46,12,140,137,137,49,233,219,183,111,198,44,85,134,
128,198,139,180,111,223,94,204,158,146,147,228,227,93,28,59,118,76,44,116,200,
159,119,255,79,63,253,228,39,139,7,128,188,37,34,34,162,210,204,153,51,87,44,91,
182,172,89,250,77,52,29,54,173,118,206,110,222,188,89,115,214,172,89,191,95,185,
114,165,255,155,31,1,178,128,18,16,84,138,213,131,247,26,0,84,151,163,22,144,
121,243,230,21,247,241,241,105,103,99,99,35,6,115,3,19,221,174,104,74,95,51,51,
179,180,50,101,202,108,164,69,8,101,219,0,64,222,210,164,73,19,159,230,205,155,
167,4,6,6,122,244,235,215,111,115,64,64,64,224,253,251,247,237,134,13,27,54,119,
224,192,129,35,76,77,77,163,235,212,169,131,185,176,223,13,18,16,117,225,189,6,
0,245,41,57,24,132,222,189,123,119,39,218,116,192,128,1,98,85,114,67,49,105,
210,36,133,87,12,100,97,122,113,237,218,53,197,210,210,82,225,201,199,253,203,
151,47,91,190,250,78,3,64,126,48,107,214,172,42,252,119,254,196,196,196,68,41,
90,180,168,248,221,23,42,84,72,41,92,184,176,50,113,226,68,23,217,246,32,69,43,
115,251,97,16,186,126,101,26,132,62,67,242,121,232,2,6,161,3,192,11,178,221,5,
235,232,209,163,133,130,130,130,92,104,10,191,129,3,7,190,176,96,160,90,248,190,
147,93,185,114,69,116,121,138,136,136,16,183,209,186,30,187,119,239,102,39,79,
158,20,139,243,37,37,37,49,15,15,15,182,127,255,254,140,24,125,162,177,31,180,
26,123,157,58,117,14,54,104,208,0,253,191,1,242,169,31,126,248,225,190,131,131,
195,31,52,89,69,84,84,148,248,221,211,4,24,252,183,239,51,125,250,244,77,178,
237,33,75,112,86,94,61,120,175,1,64,117,217,206,30,118,236,216,81,205,215,215,
183,62,45,250,215,182,109,91,89,184,206,81,114,49,99,198,12,81,104,161,65,154,
129,235,206,157,59,180,32,34,139,141,141,101,158,158,158,44,58,58,90,44,46,184,
108,217,50,17,227,228,228,36,86,79,215,23,170,132,80,242,99,97,97,17,91,165,74,
149,85,178,120,0,200,219,122,245,234,245,155,189,189,125,184,246,111,107,107,
107,165,85,171,86,203,138,22,45,26,245,182,237,32,75,48,8,93,93,120,175,1,64,
125,74,54,187,96,213,174,93,123,10,109,54,117,234,212,55,181,236,234,213,185,
115,231,148,198,141,27,43,33,33,33,162,251,215,196,137,19,149,81,163,70,137,251,
28,29,29,149,91,183,110,41,7,15,30,84,26,53,106,164,196,197,197,137,219,39,76,
152,160,156,63,127,254,109,15,251,78,246,239,223,175,208,122,40,53,106,212,56,
193,255,196,206,28,192,8,116,235,214,109,1,173,249,195,175,42,77,155,54,245,141,
140,140,180,145,109,3,89,66,179,135,60,70,23,44,253,202,212,5,107,142,228,243,
208,5,116,193,2,128,23,100,107,16,186,187,187,187,213,103,159,125,230,76,43,142,
211,202,225,185,225,230,205,155,52,205,37,117,131,16,3,191,169,123,149,118,182,
43,37,61,89,162,238,89,117,235,214,21,211,242,146,133,11,23,190,241,241,222,21,
61,231,223,127,255,45,46,235,215,175,239,170,209,104,210,100,219,0,64,222,55,
113,226,196,197,222,222,222,206,79,159,62,181,107,221,186,245,92,27,27,155,72,
217,54,144,37,154,244,2,234,192,73,51,0,80,93,182,18,144,21,43,86,180,230,7,219,
90,205,154,53,163,254,206,178,112,189,176,178,178,98,197,139,23,103,211,167,79,
23,11,6,250,249,249,137,68,68,155,124,208,109,52,59,23,173,201,161,181,105,211,
38,214,176,97,195,28,175,239,241,54,129,129,129,236,208,161,67,172,84,169,82,
161,93,186,116,217,69,207,5,0,134,227,242,229,203,69,38,76,152,208,250,198,141,
27,54,9,9,9,150,241,241,241,133,248,254,130,206,78,80,161,9,35,10,103,42,244,
55,205,43,46,173,148,181,109,219,54,205,194,194,194,140,206,38,207,159,63,255,
51,126,211,80,217,54,239,128,78,108,40,233,151,47,151,212,76,37,37,211,101,138,
137,137,73,74,137,18,37,146,248,254,58,190,105,211,166,135,103,205,154,245,207,
107,31,221,240,72,223,127,208,25,188,215,0,160,186,44,39,32,252,24,171,169,95,
191,254,192,184,184,56,205,224,193,131,115,101,240,57,105,221,186,53,91,190,124,
57,219,187,119,175,88,9,125,193,130,5,108,232,208,161,140,6,197,211,122,36,52,
22,131,214,38,89,191,126,61,91,183,110,157,184,125,229,202,149,108,207,158,61,
98,154,92,158,64,177,49,99,198,200,158,38,203,104,144,59,141,47,105,220,184,
177,219,160,65,131,252,157,157,157,101,155,0,128,10,248,62,203,98,200,144,33,
109,156,156,156,102,5,6,6,214,79,76,76,100,133,11,23,102,69,139,22,21,251,5,93,
80,254,215,69,181,185,174,30,83,151,232,245,209,216,56,154,176,195,215,215,119,
60,127,63,198,110,216,176,97,157,129,79,19,142,49,32,234,194,123,13,0,170,203,
114,2,178,122,245,234,234,97,97,97,31,219,219,219,179,206,157,59,203,194,245,
198,206,206,142,94,11,91,179,102,13,243,246,246,102,35,71,142,100,189,123,247,
22,247,77,153,50,133,157,62,125,154,149,43,87,142,173,90,181,138,109,220,184,
81,36,74,20,75,183,81,203,137,169,169,169,228,25,178,46,57,57,89,36,53,22,22,
22,105,60,1,217,97,224,7,117,0,163,50,106,212,168,175,220,221,221,231,4,7,7,
155,209,194,164,116,114,192,193,193,129,149,40,81,34,215,78,160,168,45,45,45,
141,133,132,132,136,19,51,115,230,204,49,191,124,249,242,79,158,158,158,251,249,
93,193,178,109,115,17,18,16,117,225,189,6,0,245,41,89,28,132,222,169,83,39,23,
154,247,158,87,248,21,248,215,133,11,23,20,158,208,40,60,41,59,119,254,252,121,
11,201,91,13,0,42,113,113,113,105,111,107,107,251,204,220,220,92,89,179,102,
141,146,146,146,34,251,57,231,123,205,155,55,87,248,251,241,188,125,251,246,186,
239,139,170,91,165,120,121,138,65,232,250,149,105,16,250,82,201,231,241,206,52,
26,13,6,161,3,192,11,178,116,230,227,214,173,91,166,222,222,222,125,233,172,33,
173,253,1,255,38,110,91,182,108,17,173,32,53,107,214,220,219,164,73,147,4,217,
54,0,160,127,167,78,157,42,204,203,28,154,149,234,151,95,126,97,195,135,15,23,
99,195,140,25,141,147,163,214,144,130,5,11,38,243,196,44,69,22,15,160,75,166,
166,166,89,170,107,0,128,241,200,210,78,97,229,202,149,77,159,61,123,214,188,94,
189,122,140,87,180,101,225,70,129,6,185,83,183,134,146,37,75,198,247,232,209,
227,160,44,30,0,212,177,110,221,186,174,247,238,221,107,208,162,69,11,246,213,
87,95,201,194,141,2,77,214,65,93,86,139,22,45,250,112,202,148,41,79,101,241,0,
186,132,4,4,0,94,150,165,157,194,185,115,231,6,196,197,197,153,246,239,223,63,
99,106,91,99,119,244,232,81,246,224,193,3,26,91,226,62,118,236,88,47,89,60,0,
232,159,162,40,38,94,94,94,67,248,254,138,125,254,249,231,52,62,75,182,137,81,
160,201,50,104,129,214,10,21,42,156,111,216,176,225,51,89,60,128,46,153,153,153,
81,93,35,85,22,7,0,198,35,75,9,8,175,104,119,178,182,182,102,61,123,246,148,
133,26,5,234,202,64,107,127,240,157,42,171,92,185,242,38,172,253,1,96,24,86,175,
94,93,237,209,163,71,173,203,150,45,203,186,118,237,42,11,55,10,148,140,109,
219,182,141,21,41,82,132,181,108,217,114,183,44,30,64,215,76,77,77,105,98,1,28,
39,1,32,67,150,18,144,240,240,112,123,154,254,182,74,149,42,178,80,163,112,246,
236,89,246,207,63,255,208,218,31,1,46,46,46,71,100,241,0,160,142,227,199,143,15,
230,251,43,107,58,89,162,93,160,212,216,93,184,112,129,93,188,120,145,85,172,88,
209,231,251,239,191,63,45,139,7,208,181,244,22,16,140,61,2,128,12,89,74,64,56,
179,150,45,91,26,205,212,149,111,19,19,19,35,86,97,167,193,231,245,235,215,95,
221,166,77,27,116,103,0,48,0,219,183,111,183,184,114,229,74,39,154,106,123,192,
128,1,178,112,163,193,223,23,113,89,174,92,185,255,90,91,91,99,181,118,80,93,
250,24,16,36,32,0,144,33,171,25,133,134,102,81,49,118,247,239,223,23,253,202,61,
60,60,148,170,85,171,30,27,55,110,220,26,217,54,0,160,142,157,59,119,214,9,12,
12,172,219,176,97,67,214,168,81,35,89,184,81,160,53,64,246,237,219,71,107,159,
60,31,50,100,200,33,89,60,128,62,160,5,4,0,94,150,165,133,8,105,224,249,178,
101,203,152,173,173,45,251,232,163,143,68,95,98,99,65,171,39,243,74,141,232,114,
181,121,243,102,113,189,105,211,166,143,157,156,156,70,183,105,211,38,66,182,61,
0,232,159,162,40,26,254,123,28,145,148,148,100,218,183,111,95,12,62,79,71,43,
160,63,122,244,136,117,236,216,241,230,192,129,3,111,240,253,150,108,19,0,157,
67,2,2,0,47,203,82,2,210,186,117,235,63,78,157,58,245,229,200,145,35,53,52,159,
190,49,117,197,162,245,62,180,173,63,54,54,54,177,142,142,142,219,157,157,157,
167,185,184,184,132,72,54,5,0,149,44,90,180,168,164,175,175,111,15,254,27,101,
125,250,244,145,133,27,133,212,212,84,177,86,81,193,130,5,211,234,212,169,179,
70,163,209,40,178,109,0,244,193,220,220,156,22,226,65,2,2,0,25,178,148,128,184,
185,185,141,236,210,165,203,159,167,79,159,46,22,27,27,107,201,15,108,133,249,
205,116,138,145,230,228,53,231,197,44,189,104,175,155,178,127,31,251,229,66,59,
161,220,202,94,82,211,75,202,75,37,57,189,36,101,42,137,233,37,158,138,149,149,
85,156,165,165,229,243,126,253,250,61,92,177,98,197,141,51,103,206,188,238,241,
1,32,23,208,73,130,33,67,134,12,8,15,15,183,163,228,163,82,165,74,178,77,140,
2,173,251,113,242,228,73,154,169,47,232,227,143,63,222,179,96,193,2,217,38,0,
122,97,102,102,70,199,254,100,89,28,0,24,143,44,37,32,233,103,206,140,118,246,
20,158,116,137,194,147,15,89,40,0,168,207,196,215,215,119,8,77,143,237,236,236,
44,139,53,26,187,118,237,98,207,159,63,103,239,191,255,254,238,22,45,90,160,
187,40,228,26,115,115,115,58,241,152,36,139,3,0,227,145,91,173,17,0,0,58,49,121,
242,228,218,247,239,223,175,65,45,31,173,90,181,146,133,27,5,58,97,178,115,231,
78,26,175,151,92,163,70,141,245,232,126,5,185,41,189,5,4,9,8,0,100,64,2,2,0,
121,154,167,167,231,199,17,17,17,150,52,245,110,209,162,69,101,225,70,225,212,
169,83,236,230,205,155,172,122,245,234,215,230,204,153,115,75,22,15,160,79,60,1,
161,222,22,72,64,0,32,3,18,16,0,200,179,60,60,60,74,242,228,227,51,154,169,175,
95,191,126,178,112,163,64,99,98,104,198,62,154,48,164,121,243,230,110,26,141,
38,65,182,13,128,62,89,88,88,80,2,146,40,139,3,0,227,129,4,4,0,242,172,21,43,
86,52,10,12,12,172,68,11,165,214,174,93,91,22,110,20,104,170,240,131,7,15,50,
59,59,187,240,22,45,90,252,41,139,7,208,183,244,89,176,144,128,0,64,6,36,32,0,
144,39,209,218,31,94,94,94,3,19,18,18,24,173,111,81,176,96,150,230,212,200,247,
246,236,217,195,34,34,34,40,33,59,217,175,95,63,127,89,60,128,190,241,4,132,102,
198,68,75,28,0,100,64,2,2,0,121,210,194,133,11,203,134,134,134,118,46,83,166,12,
235,220,185,179,44,220,40,80,50,182,109,219,54,177,88,108,203,150,45,119,203,
226,1,212,80,160,64,1,51,14,9,8,0,100,64,2,2,0,121,210,241,227,199,63,137,140,
140,44,217,173,91,55,246,222,123,239,201,194,141,194,229,203,151,217,197,139,23,
89,213,170,85,31,142,29,59,214,93,22,15,160,134,212,212,212,170,180,158,150,44,
14,0,140,7,18,16,0,200,115,220,220,220,10,251,250,250,246,53,53,53,101,131,6,
13,146,133,27,141,237,219,183,139,21,208,121,2,178,165,104,209,162,33,178,120,
0,125,83,20,197,244,238,221,187,85,210,210,210,98,101,177,0,96,60,144,128,0,
64,158,115,236,216,177,118,161,161,161,77,28,28,28,88,227,198,141,101,225,70,
33,44,44,140,237,221,187,151,149,44,89,50,161,87,175,94,251,100,241,185,233,
198,141,27,166,188,98,90,64,22,7,121,223,186,117,235,42,199,199,199,127,80,171,
86,173,40,89,44,0,24,15,36,32,0,144,231,120,122,122,118,140,141,141,45,64,107,
127,208,20,188,250,70,51,75,253,248,227,143,44,37,37,69,22,154,107,142,31,63,
206,2,2,2,88,217,178,101,61,6,13,26,116,94,22,159,155,204,204,204,170,44,94,188,
120,237,162,69,139,26,202,98,243,139,184,184,56,54,115,230,76,22,18,18,66,211,
71,139,169,146,141,193,174,93,187,190,228,23,129,187,119,239,190,43,139,5,0,
227,129,4,4,0,242,148,133,11,23,22,241,247,247,239,70,139,14,246,234,213,75,22,
174,19,148,228,124,240,193,7,76,163,209,200,66,115,69,90,90,26,219,184,113,35,
13,246,85,28,29,29,247,240,215,153,42,219,38,55,217,217,217,221,189,117,235,86,
241,37,75,150,156,116,114,114,250,239,246,237,219,235,202,182,201,235,104,93,
150,234,213,171,179,194,133,11,179,235,215,175,179,19,39,78,200,54,201,243,182,
108,217,50,233,201,147,39,19,235,212,169,51,179,100,201,146,207,101,241,0,96,60,
48,111,37,0,228,41,167,79,159,238,21,21,21,85,177,71,143,30,52,214,65,22,158,
129,102,136,250,227,143,63,24,205,154,245,207,63,255,48,94,41,98,53,107,214,164,
74,146,152,53,106,252,248,241,172,68,137,18,236,222,189,123,108,245,234,213,
226,76,53,117,239,250,226,139,47,196,246,218,214,143,93,187,118,49,26,123,114,
254,252,121,198,95,7,27,49,98,196,43,107,144,196,198,198,178,181,107,215,138,24,
122,142,175,191,254,154,29,61,122,84,60,198,192,129,3,153,159,159,31,115,117,
117,101,173,91,183,22,107,118,184,184,184,48,75,75,75,182,106,213,42,214,164,73,
19,214,160,65,131,87,94,255,219,248,250,250,178,147,39,79,178,247,223,127,63,
162,119,239,222,135,150,45,91,38,219,36,87,217,218,218,166,186,185,185,253,204,
95,115,167,173,91,183,14,187,120,241,98,191,254,253,251,111,239,210,165,203,
178,185,115,231,62,244,241,241,81,100,143,161,75,151,46,93,98,191,255,254,187,
248,142,56,59,59,179,246,237,219,139,207,150,62,15,74,22,106,213,170,197,190,
250,234,43,241,25,209,231,90,182,108,217,87,190,67,86,86,86,236,155,111,190,161,
69,247,216,95,127,253,197,138,21,43,38,62,243,106,213,170,177,145,35,71,82,171,
143,248,252,41,89,164,239,15,253,77,238,222,189,43,190,151,244,157,225,159,29,
107,219,182,173,228,213,26,62,69,81,10,241,247,235,155,149,43,87,206,136,140,
140,28,193,223,219,29,178,109,0,192,184,32,1,1,128,60,131,87,108,76,28,28,28,62,
77,77,77,213,100,119,240,121,98,98,34,251,229,151,95,196,148,189,221,187,119,
103,83,167,78,101,229,203,151,103,163,70,141,18,149,74,94,89,18,221,172,190,251,
238,59,214,180,105,83,209,186,66,127,83,165,179,121,243,230,140,42,245,180,222,
200,206,157,59,69,133,159,226,104,214,169,73,147,38,137,177,23,84,241,36,180,18,
249,207,63,255,44,98,198,140,25,35,42,177,243,231,207,103,125,250,244,17,3,230,
43,86,172,72,11,40,178,74,149,42,137,4,138,18,135,228,228,100,86,163,70,13,81,
145,205,201,138,238,244,154,168,2,203,43,187,103,120,34,21,195,111,42,42,219,38,
183,241,74,185,79,163,70,141,246,248,251,251,15,224,73,159,85,64,64,192,103,87,
174,92,233,199,19,196,253,60,1,81,109,124,8,37,156,148,92,208,247,128,18,81,250,
60,105,48,255,175,191,254,42,6,244,211,103,248,231,159,127,138,219,23,45,90,
196,120,130,196,58,118,236,200,62,254,248,99,241,29,42,87,174,156,72,48,214,173,
91,39,190,67,244,88,83,166,76,17,137,102,207,158,61,197,109,207,158,61,99,211,
166,77,19,215,41,169,53,49,49,17,235,214,60,125,250,148,141,30,61,90,124,55,40,
49,254,254,251,239,217,255,253,223,255,137,4,72,69,148,9,189,245,251,98,99,99,
163,169,87,175,94,193,202,149,43,155,218,217,217,153,89,91,91,155,242,132,203,
172,80,161,66,166,60,145,50,229,255,139,233,243,231,207,173,121,50,85,49,48,48,
176,118,179,102,205,90,243,100,174,8,79,194,134,243,219,214,191,237,177,1,192,
56,33,1,1,128,60,99,198,140,25,181,31,61,122,212,132,42,238,237,218,181,147,
133,191,130,87,164,216,184,113,227,196,25,109,90,47,131,18,13,58,235,28,29,29,
45,90,34,168,139,213,244,233,211,69,5,241,193,131,7,162,219,204,195,135,15,197,
223,116,214,154,208,245,79,63,253,148,245,237,219,87,180,84,208,25,243,152,152,
152,140,4,132,174,187,185,185,177,245,235,215,179,186,117,235,138,174,91,183,
110,221,98,245,235,215,23,45,29,52,110,133,90,57,168,242,74,221,113,150,46,93,
42,30,139,206,140,83,34,196,43,120,111,251,23,94,65,99,11,168,194,108,107,107,
203,120,5,190,14,127,189,135,100,219,24,2,122,95,195,194,194,138,80,194,70,168,
117,128,39,3,69,248,251,238,68,127,171,213,221,141,90,162,40,41,212,182,116,81,
43,24,181,126,241,247,146,237,222,189,91,124,30,148,168,82,194,65,99,129,138,
23,47,46,190,67,212,234,69,223,33,74,67,120,248,161,0,0,11,233,73,68,65,84,40,
40,129,224,21,112,118,224,192,1,241,253,160,199,160,36,164,66,133,10,162,37,
132,90,70,232,179,55,55,55,207,248,191,232,251,116,248,240,97,145,124,210,247,
136,182,163,46,90,212,122,162,114,2,210,155,151,183,54,185,81,107,16,79,148,77,
78,159,62,157,204,127,19,9,84,120,210,161,45,137,252,127,73,228,201,72,10,45,
56,24,20,20,20,199,191,223,27,120,2,182,101,232,208,161,143,222,246,184,0,96,
188,144,128,0,64,158,113,237,218,181,207,34,34,34,172,232,140,51,141,1,201,46,
26,203,161,221,142,42,131,116,198,155,80,165,144,18,128,248,248,120,209,253,42,
56,56,152,213,171,87,79,116,171,161,138,97,102,84,113,164,74,168,22,157,201,
214,86,162,9,85,214,232,177,180,107,147,148,46,93,90,84,72,73,163,70,141,68,197,
155,87,204,68,242,65,168,37,132,158,39,60,60,92,36,70,217,229,233,233,201,188,
188,188,40,193,185,230,228,228,212,115,242,228,201,209,178,109,12,68,26,79,34,
151,28,61,122,244,3,250,131,222,71,123,123,251,103,101,203,150,221,123,230,204,
153,222,252,61,205,254,7,156,3,244,89,83,151,42,45,234,2,69,107,169,80,66,169,
253,126,208,103,78,223,3,234,162,69,223,33,74,100,73,230,239,16,161,207,157,190,
11,214,214,214,25,159,57,37,32,244,191,81,107,74,230,164,138,174,83,162,67,173,
32,212,130,69,247,211,119,229,229,238,124,42,216,195,203,212,183,5,208,255,68,
175,143,151,52,254,103,106,122,73,203,116,249,66,151,57,74,192,169,0,0,188,9,6,
161,3,64,158,112,224,192,129,34,60,1,105,79,149,190,156,116,83,122,25,85,170,
180,137,3,93,82,107,135,143,143,15,115,119,119,23,3,186,127,248,225,7,81,217,
164,251,94,62,27,159,57,225,32,84,57,165,86,148,199,143,31,139,138,39,37,23,52,
174,128,108,216,176,129,253,244,211,79,34,185,161,110,56,116,157,206,124,159,58,
117,74,220,79,221,179,168,226,249,209,71,31,137,46,95,217,65,175,131,206,152,
211,107,231,149,228,121,60,249,8,228,55,71,230,133,178,111,223,190,82,252,253,
238,69,21,219,114,229,202,61,229,21,255,165,252,245,127,196,19,130,111,248,253,
170,77,55,70,73,31,181,118,80,242,64,173,24,212,77,46,50,50,82,116,217,163,241,
25,132,18,60,122,143,169,155,20,189,222,204,223,155,151,191,11,244,93,161,100,
242,230,205,155,226,239,115,231,206,209,212,200,34,201,164,231,208,162,235,239,
191,255,190,72,86,168,107,224,130,5,11,88,229,202,149,95,72,104,84,66,43,148,75,
63,175,244,66,201,237,243,244,109,146,216,191,9,136,170,227,117,0,32,127,64,11,
8,0,228,9,43,87,174,108,16,20,20,84,179,85,171,86,57,58,75,76,21,195,204,93,
96,104,16,48,85,42,9,93,210,89,106,234,138,67,93,110,168,31,63,37,17,212,61,
134,206,134,183,104,209,34,163,197,34,243,118,218,199,164,219,232,140,47,117,
217,217,186,117,171,24,47,64,99,5,168,75,142,183,183,183,24,19,178,112,225,66,
241,216,148,128,80,69,150,250,250,83,55,44,234,62,69,219,80,197,179,107,215,174,
98,224,114,135,14,29,94,255,79,188,132,186,137,237,223,191,159,206,200,7,127,
254,249,231,39,104,208,123,94,240,228,201,19,141,139,139,203,183,212,125,172,
125,251,246,75,249,255,189,124,252,248,241,247,142,28,57,66,119,151,226,69,157,
254,87,28,117,159,58,116,232,144,24,179,65,73,1,181,110,208,119,108,240,224,193,
98,252,71,195,134,13,69,50,249,237,183,223,138,150,47,106,13,121,211,119,72,59,
176,156,146,146,217,179,103,139,196,146,39,205,34,185,208,126,79,104,91,109,171,
25,141,37,161,214,15,234,150,71,93,232,168,117,140,198,158,168,76,181,247,26,0,
32,131,246,12,206,219,10,0,64,110,242,243,243,51,107,210,164,201,54,126,85,89,
183,110,157,146,19,169,169,169,202,163,71,143,20,158,84,136,191,195,194,194,148,
232,232,104,113,157,46,67,66,66,196,117,186,60,120,240,160,226,235,235,43,98,
121,5,82,121,250,244,169,242,248,241,99,133,87,80,197,118,49,49,49,34,150,238,
167,219,233,177,35,35,35,21,94,129,204,120,190,123,247,238,41,60,153,16,207,73,
2,2,2,50,182,163,120,127,127,127,133,39,84,98,123,173,224,224,96,241,248,89,
181,108,217,50,218,65,43,173,91,183,222,41,123,15,13,201,237,219,183,171,206,
156,57,115,254,216,177,99,63,124,205,221,148,128,60,109,218,180,169,236,223,215,
153,132,132,4,229,212,169,83,202,217,179,103,51,190,31,228,250,245,235,202,190,
125,251,196,103,73,222,246,29,162,207,150,190,59,116,63,79,90,148,187,119,239,
42,60,161,122,97,91,250,172,147,146,146,148,168,168,40,37,60,60,92,220,158,152,
152,168,120,120,120,40,60,129,205,248,126,168,193,211,211,83,124,119,120,89,250,
154,207,0,0,64,191,20,36,32,0,96,224,38,76,152,80,193,206,206,46,170,116,233,
210,25,21,122,99,71,149,224,86,173,90,41,5,11,22,76,254,242,203,47,59,203,222,
67,67,226,237,237,109,246,150,187,85,79,64,116,41,48,48,80,249,240,195,15,149,
184,184,56,89,104,174,66,2,2,0,185,9,99,64,0,192,160,241,186,18,181,128,12,12,
11,11,179,166,46,74,212,125,41,63,81,114,120,146,135,186,134,209,248,130,242,
229,203,223,155,49,99,134,187,44,222,144,212,170,85,43,73,22,147,87,209,24,32,
154,217,76,59,107,26,0,0,188,10,99,64,0,192,160,93,189,122,213,60,32,32,96,8,
245,155,167,117,56,242,155,156,78,55,187,99,199,14,26,40,173,84,168,80,225,79,
158,148,37,203,226,65,29,52,113,65,86,199,240,0,0,24,43,180,128,0,128,65,251,
237,183,223,26,251,249,249,85,166,217,138,28,29,29,101,225,70,225,201,147,39,
108,207,158,61,52,131,18,77,91,187,89,22,15,0,0,96,72,144,128,0,128,65,187,124,
249,114,247,152,152,152,66,52,75,17,157,93,6,198,60,60,60,168,91,26,173,95,113,
98,195,134,13,143,101,241,0,0,0,134,4,9,8,0,24,44,55,55,55,251,136,136,136,193,
52,53,42,173,88,14,255,142,25,217,188,121,179,152,246,213,209,209,209,77,163,
209,252,111,113,9,0,0,128,60,0,9,8,0,24,172,223,126,251,173,121,112,112,176,125,
187,118,237,88,181,106,213,100,225,70,225,206,157,59,98,177,196,226,197,139,223,
105,211,166,205,110,89,60,0,0,128,161,65,2,2,0,6,73,81,20,141,143,143,207,192,
164,164,36,177,72,92,78,7,107,231,55,52,248,60,38,38,134,85,175,94,221,205,217,
217,249,169,44,30,0,0,192,208,32,1,1,0,131,52,110,220,184,106,33,33,33,173,169,
229,163,77,155,54,178,112,163,16,25,25,41,86,78,183,177,177,73,251,232,163,143,
242,212,226,131,0,0,0,90,72,64,0,192,32,249,248,248,12,138,137,137,177,237,222,
189,59,43,86,172,152,44,220,40,156,63,127,158,121,121,121,177,114,229,202,121,
205,155,55,239,154,44,30,0,0,192,16,33,1,1,0,131,115,242,228,73,75,158,128,244,
52,55,55,103,131,6,13,146,133,27,141,109,219,182,49,19,19,19,102,111,111,191,
78,163,209,196,202,226,1,0,0,12,17,18,16,0,48,56,187,118,237,234,18,26,26,90,
183,105,211,166,204,193,193,65,22,110,20,2,3,3,105,86,48,90,105,251,169,179,179,
243,97,89,60,0,0,128,161,66,2,2,0,6,229,206,157,59,5,60,60,60,186,37,38,38,138,
214,15,90,1,29,24,59,120,240,32,11,9,9,161,217,175,118,14,29,58,244,158,44,30,0,
0,192,80,33,1,1,0,131,50,111,222,188,98,15,31,62,236,100,103,103,199,186,118,
237,42,11,55,10,201,201,201,236,239,191,255,166,100,44,169,65,131,6,123,101,241,
0,0,0,134,12,9,8,0,24,20,158,124,244,137,136,136,40,221,165,75,23,90,233,91,
22,110,20,174,95,191,206,206,156,57,67,107,161,60,154,52,105,210,73,89,60,0,0,
128,33,67,2,2,0,6,67,81,20,19,158,128,12,163,129,214,78,78,78,178,112,163,65,
131,207,105,61,148,202,149,43,255,237,224,224,128,193,231,0,0,144,167,33,1,1,0,
131,209,183,111,95,135,7,15,30,212,168,85,171,22,107,217,178,165,44,220,40,132,
135,135,211,160,124,90,251,227,121,149,42,85,54,200,226,1,0,0,12,29,18,16,0,48,
24,151,47,95,174,29,23,23,103,221,171,87,47,86,168,80,33,89,184,81,56,112,224,
0,187,127,255,62,171,88,177,162,231,210,165,75,253,100,241,0,0,0,134,14,9,8,0,
24,140,2,5,10,52,54,51,51,99,237,218,181,147,133,26,133,224,224,96,54,123,246,
108,86,164,72,17,214,164,73,147,101,26,141,38,89,182,13,0,0,128,161,67,2,2,0,6,
35,41,41,169,20,79,66,68,133,219,216,249,251,251,179,97,195,134,177,123,247,
238,177,218,181,107,111,93,181,106,213,81,217,54,0,0,0,121,1,38,216,7,0,131,97,
111,111,127,53,40,40,168,47,157,245,255,238,187,239,104,208,53,51,53,53,149,109,
150,111,196,199,199,179,128,128,0,118,244,232,81,198,19,14,177,248,96,171,86,
173,188,248,251,240,153,70,163,73,146,109,159,79,40,188,164,202,130,64,103,240,
94,3,128,234,144,128,0,128,193,224,149,237,61,209,209,209,159,239,216,177,163,
50,45,188,103,107,107,75,221,178,100,155,229,11,138,162,176,148,148,20,22,25,
25,201,226,226,226,168,21,40,214,209,209,113,235,130,5,11,254,211,168,81,163,
120,217,246,249,76,154,44,0,116,6,9,8,0,168,14,9,8,0,24,140,249,243,231,223,228,
165,203,170,85,171,58,63,120,240,192,234,209,163,71,133,249,205,133,210,139,57,
47,102,153,46,169,152,166,151,130,153,74,129,76,151,154,87,159,69,239,180,103,
240,169,164,164,23,186,158,156,126,157,46,19,211,47,147,210,175,39,104,139,185,
185,121,92,217,178,101,159,247,236,217,243,236,138,21,43,206,241,228,227,53,79,
145,175,81,242,145,34,11,2,157,193,123,13,0,170,67,2,2,0,6,101,242,228,201,119,
248,197,29,89,220,75,52,47,93,190,124,61,55,40,111,184,124,171,196,196,68,198,
19,47,198,147,15,89,104,126,133,46,88,234,66,2,2,0,170,67,2,2,0,249,65,182,42,
249,96,208,232,51,68,165,88,61,120,175,1,64,117,152,5,11,0,0,12,9,18,16,117,225,
189,6,0,213,33,1,1,0,0,67,130,46,88,234,66,2,2,0,170,67,2,2,0,0,134,132,6,161,
99,193,69,245,224,189,6,0,213,33,1,1,0,0,67,66,9,136,177,172,121,98,8,240,94,3,
128,234,144,128,0,0,128,33,161,46,88,56,43,175,30,36,32,0,160,58,36,32,0,0,96,
72,208,5,75,93,72,64,0,64,117,72,64,0,0,192,144,136,46,88,180,50,60,168,2,9,8,
0,168,14,9,8,0,0,24,18,74,64,18,101,65,160,51,9,178,0,0,0,93,67,2,2,0,0,134,4,
9,136,122,168,153,9,9,8,0,168,14,9,8,0,0,24,12,83,83,83,90,3,36,1,93,176,244,
43,253,253,85,52,26,13,18,16,0,80,29,18,16,0,0,48,24,201,201,201,226,172,124,
84,84,20,139,139,139,147,133,67,14,5,5,5,209,133,98,105,105,137,55,25,0,84,135,
4,4,0,0,12,10,175,20,39,250,249,249,177,147,39,79,202,66,33,135,182,109,219,
198,76,76,76,52,197,138,21,67,2,2,0,170,67,2,2,0,0,6,165,85,171,86,103,52,26,13,
155,58,117,42,163,68,4,116,107,245,234,213,108,239,222,189,172,76,153,50,119,70,
141,26,21,36,139,7,0,208,53,77,86,250,217,210,129,0,0,0,64,13,33,33,33,150,131,
7,15,62,114,236,216,49,199,154,53,107,178,111,190,249,134,181,105,211,134,21,
45,90,84,182,41,188,65,90,90,26,187,127,255,62,219,180,105,147,72,64,108,108,
108,20,103,103,231,81,75,151,46,93,35,219,22,0,64,215,144,128,0,0,128,193,57,
116,232,80,165,5,11,22,172,242,244,244,236,144,144,144,160,161,228,195,204,204,
76,28,143,232,184,133,227,146,92,230,227,59,93,143,137,137,97,137,137,137,212,
242,241,180,95,191,126,139,150,44,89,242,11,127,31,229,149,0,0,0,29,67,2,2,0,0,
6,137,142,79,221,187,119,239,112,234,212,169,170,209,209,209,182,252,38,235,
244,98,197,75,225,244,82,40,83,49,79,47,102,233,197,52,211,101,1,94,242,250,193,
140,166,40,78,97,255,174,20,159,148,94,232,122,98,122,161,25,173,226,211,75,92,
166,18,195,75,180,185,185,121,84,233,210,165,159,13,31,62,220,227,251,239,191,
71,223,54,0,200,53,72,64,0,0,0,0,0,64,53,24,132,14,0,0,0,0,0,170,65,2,2,0,0,0,
0,0,170,65,2,2,0,0,0,0,0,170,65,2,2,0,0,0,0,0,170,65,2,2,0,0,0,0,0,170,65,2,2,
0,0,0,0,0,170,249,127,83,186,124,199,82,158,209,51,0,0,0,0,73,69,78,68,174,66,
96,130};
