/*
 * Decompiled with CFR 0.152.
 */
package com.beust.kobalt.wrapper;

import com.beust.kobalt.wrapper.Main;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Config {
    Config() {
    }

    static Proxy getProxy() {
        String string = Config.getConfigFilePath();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Config.getConfigFileContent(string));
            Document document = documentBuilder.parse(byteArrayInputStream);
            NodeList nodeList = document.getElementsByTagName("proxies");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                String string2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(string2 = (element = (Element)node).getElementsByTagName("type").item(0).getTextContent()).toLowerCase().equals("http")) continue;
                String string3 = element.getElementsByTagName("host").item(0).getTextContent();
                String string4 = element.getElementsByTagName("port").item(0).getTextContent();
                try {
                    int n = Integer.parseInt(string4);
                    Main.log(2, String.format("Using HTTP proxy: %s:%s", string3, n));
                    return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string3, n));
                }
                catch (NumberFormatException numberFormatException) {
                    Main.log(1, String.format("Invalid proxy port number: %s in config file: %s", string4, string));
                }
            }
        }
        catch (Exception exception) {
            Main.log(2, String.format("%s while parsing config file: %s", exception.getMessage(), string));
            return null;
        }
        Main.log(2, String.format("No HTTP proxy found in config file: %s", string));
        return null;
    }

    private static String getConfigFilePath() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        String string3 = ".config";
        String string4 = "kobalt";
        String string5 = "settings.xml";
        return string + string2 + string3 + string2 + string4 + string2 + string5;
    }

    private static byte[] getConfigFileContent(String string) throws IOException {
        Path path = Paths.get(string, new String[0]);
        return Files.readAllBytes(path);
    }
}

