/* SPDX-FileCopyrightText: 2023 Blender Authors
 *
 * SPDX-License-Identifier: GPL-2.0-or-later */

#include "gpu_shader_create_info.hh"

GPU_SHADER_CREATE_INFO(compositor_keying_extract_chroma)
LOCAL_GROUP_SIZE(16, 16)
SAMPLER(0, FLOAT_2D, input_tx)
IMAGE(0, GPU_RGBA16F, WRITE, FLOAT_2D, output_img)
COMPUTE_SOURCE("compositor_keying_extract_chroma.glsl")
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_replace_chroma)
LOCAL_GROUP_SIZE(16, 16)
SAMPLER(0, FLOAT_2D, input_tx)
SAMPLER(1, FLOAT_2D, new_chroma_tx)
IMAGE(0, GPU_RGBA16F, WRITE, FLOAT_2D, output_img)
COMPUTE_SOURCE("compositor_keying_replace_chroma.glsl")
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_compute_matte)
LOCAL_GROUP_SIZE(16, 16)
PUSH_CONSTANT(FLOAT, key_balance)
SAMPLER(0, FLOAT_2D, input_tx)
SAMPLER(1, FLOAT_2D, key_tx)
IMAGE(0, GPU_R16F, WRITE, FLOAT_2D, output_img)
COMPUTE_SOURCE("compositor_keying_compute_matte.glsl")
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_tweak_matte)
LOCAL_GROUP_SIZE(16, 16)
PUSH_CONSTANT(BOOL, compute_edges)
PUSH_CONSTANT(BOOL, apply_core_matte)
PUSH_CONSTANT(BOOL, apply_garbage_matte)
PUSH_CONSTANT(INT, edge_search_radius)
PUSH_CONSTANT(FLOAT, edge_tolerance)
PUSH_CONSTANT(FLOAT, black_level)
PUSH_CONSTANT(FLOAT, white_level)
SAMPLER(0, FLOAT_2D, input_matte_tx)
SAMPLER(1, FLOAT_2D, garbage_matte_tx)
SAMPLER(2, FLOAT_2D, core_matte_tx)
IMAGE(0, GPU_R16F, WRITE, FLOAT_2D, output_matte_img)
IMAGE(1, GPU_R16F, WRITE, FLOAT_2D, output_edges_img)
COMPUTE_SOURCE("compositor_keying_tweak_matte.glsl")
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()

GPU_SHADER_CREATE_INFO(compositor_keying_compute_image)
LOCAL_GROUP_SIZE(16, 16)
PUSH_CONSTANT(FLOAT, despill_factor)
PUSH_CONSTANT(FLOAT, despill_balance)
SAMPLER(0, FLOAT_2D, input_tx)
SAMPLER(1, FLOAT_2D, matte_tx)
SAMPLER(2, FLOAT_2D, key_tx)
IMAGE(0, GPU_RGBA16F, WRITE, FLOAT_2D, output_img)
COMPUTE_SOURCE("compositor_keying_compute_image.glsl")
DO_STATIC_COMPILATION()
GPU_SHADER_CREATE_END()
