/* SPDX-FileCopyrightText: 2024 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

import Model from 'gmp/model';
import {parseDate} from 'gmp/parser';
import {isDefined} from 'gmp/utils/identity';

class Vulnerability extends Model {
  static entityType = 'vulnerability';

  static parseElement(element) {
    const ret = super.parseElement(element);

    if (isDefined(ret.results)) {
      ret.results.newest = parseDate(ret.results.newest);
      ret.results.oldest = parseDate(ret.results.oldest);
    }

    return ret;
  }
}

export default Vulnerability;
