/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteRunner;
import org.testng.TestNGCommandLineArgs;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.internal.HostFile;
import org.testng.internal.Invoker;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationConfiguration;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.ITest;
import org.testng.internal.remote.SlavePool;
import org.testng.internal.thread.IPooledExecutor;
import org.testng.internal.thread.ThreadUtil;
import org.testng.remote.ConnectionInfo;
import org.testng.remote.RemoteSuiteWorker;
import org.testng.remote.RemoteTestWorker;
import org.testng.remote.RemoteWorker;
import org.testng.reporters.FailedReporter;
import org.testng.reporters.SuiteHTMLReporter;
import org.testng.xml.Parser;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestNG {
    public static final String DEFAULT_SUITE_NAME = "Command line suite";
    public static final String DEFAULT_TEST_NAME = "Command line test";
    public static final String DEFAULT_OUTPUTDIR = "test-output";
    public static final String SRC_SEPARATOR = ";";
    public static final String JDK5_ANNOTATION_TYPE = "JDK5";
    public static final String JAVADOC_ANNOTATION_TYPE = "javadoc";
    private static TestNG m_instance;
    private static boolean m_isJdk14;
    protected List<XmlSuite> m_suites = new ArrayList<XmlSuite>();
    protected XmlSuite[] m_cmdlineSuite;
    protected String m_outputDir;
    protected String[] m_sourceDirs;
    protected String m_target;
    protected String[] m_groups;
    private Boolean m_isJUnit = Boolean.FALSE;
    private boolean m_useDefaultListeners = true;
    protected ITestRunnerFactory m_testRunnerFactory;
    protected List<ITestListener> m_testListeners = new ArrayList<ITestListener>();
    protected List<ISuiteListener> m_suiteListeners = new ArrayList<ISuiteListener>();
    private List<IReporter> m_reporters = new ArrayList<IReporter>();
    public static final int HAS_FAILURE = 1;
    public static final int HAS_SKIPPED = 2;
    public static final int HAS_FSP = 4;
    public static final int HAS_NO_TEST = 8;
    protected int m_status;
    private int m_clientPort = 0;
    private String m_hostFile;
    private SlavePool m_slavePool = new SlavePool();
    private Integer m_verbose;

    public TestNG() {
        this.init(true);
    }

    public TestNG(boolean useDefaultListeners) {
        this.init(useDefaultListeners);
    }

    private void init(boolean useDefaultListeners) {
        m_instance = this;
        TestNG.setTestNGVersion();
        String string = this.m_target = m_isJdk14 ? JAVADOC_ANNOTATION_TYPE : JDK5_ANNOTATION_TYPE;
        if (useDefaultListeners) {
            this.m_reporters.add(new SuiteHTMLReporter());
            this.m_reporters.add(new FailedReporter());
            this.m_outputDir = DEFAULT_OUTPUTDIR;
        }
        this.m_useDefaultListeners = useDefaultListeners;
    }

    public static TestNG getDefault() {
        return m_instance;
    }

    public int getStatus() {
        return this.m_status;
    }

    protected void setStatus(int status) {
        this.m_status |= status;
    }

    public void setOutputDirectory(String outputdir) {
        if (null != outputdir && !"".equals(outputdir)) {
            this.m_outputDir = outputdir;
        }
    }

    public void setUseDefaultListeners(boolean useDefaultListeners) {
        this.m_useDefaultListeners = useDefaultListeners;
    }

    public void setTarget(String target) {
        if (null == target) {
            return;
        }
        if (target.equals(JAVADOC_ANNOTATION_TYPE)) {
            this.m_target = JAVADOC_ANNOTATION_TYPE;
        } else if (target.equals(JDK5_ANNOTATION_TYPE)) {
            this.m_target = JDK5_ANNOTATION_TYPE;
        } else if (target.equals("1.4") || target.toLowerCase().equals(JAVADOC_ANNOTATION_TYPE.toLowerCase())) {
            this.m_target = JAVADOC_ANNOTATION_TYPE;
            TestNG.log("Illegal target type " + target + " defaulting to " + JAVADOC_ANNOTATION_TYPE);
        } else if ("1.5".equals(target) || target.toLowerCase().equals(JDK5_ANNOTATION_TYPE.toLowerCase())) {
            this.m_target = JDK5_ANNOTATION_TYPE;
            TestNG.log("Illegal target type " + target + " defaulting to " + JDK5_ANNOTATION_TYPE);
        } else if (target.toLowerCase().equals("jdk15")) {
            this.m_target = JDK5_ANNOTATION_TYPE;
            TestNG.log("Illegal target type " + target + " defaulting to " + JDK5_ANNOTATION_TYPE);
        } else {
            this.m_target = JDK5_ANNOTATION_TYPE;
            TestNG.log("Illegal target type " + target + " defaulting to " + JDK5_ANNOTATION_TYPE);
        }
    }

    public void setSourcePath(String sourcePaths) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-sourcedir-override.properties");
        if (is != null) {
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            sourcePaths = props.getProperty("sourcedir");
        }
        if (null == sourcePaths || "".equals(sourcePaths.trim())) {
            return;
        }
        this.m_sourceDirs = Utils.split(sourcePaths, SRC_SEPARATOR);
    }

    public void setTestJar(String jarPath) {
        if (null == jarPath || "".equals(jarPath)) {
            return;
        }
        File jarFile = new File(jarPath);
        try {
            URL jarfile = new URL("jar", "", "file:" + jarFile.getAbsolutePath() + "!/");
            URLClassLoader jarLoader = new URLClassLoader(new URL[]{jarfile});
            Thread.currentThread().setContextClassLoader(jarLoader);
            this.m_suites.add(new Parser().parse());
        }
        catch (MalformedURLException mfurle) {
            System.err.println("could not find jar file named: " + jarFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            System.out.println("An exception occurred while trying to load testng.xml from within jar " + jarFile.getAbsolutePath());
        }
        catch (SAXException saxe) {
            System.out.println("testng.xml from within jar " + jarFile.getAbsolutePath() + " is not well formatted");
            saxe.printStackTrace(System.out);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace(System.out);
        }
    }

    public void setThreadCount(int threadCount) {
        for (XmlSuite s : this.m_cmdlineSuite) {
            s.setThreadCount(threadCount);
        }
    }

    public void setParallel(boolean parallel) {
        for (XmlSuite s : this.m_cmdlineSuite) {
            s.setParallel(parallel);
        }
    }

    public void setCommandLineSuite(XmlSuite suite) {
        this.m_cmdlineSuite = new XmlSuite[]{suite};
        this.m_suites.add(this.m_cmdlineSuite[0]);
    }

    public void setTestClasses(Class[] classes) {
        for (XmlSuite s : this.m_cmdlineSuite = this.createCommandLineSuites(classes)) {
            this.m_suites.add(s);
        }
    }

    public XmlSuite[] createCommandLineSuites(Class[] classes) {
        XmlClass[] xmlClasses = Utils.classesToXmlClasses(classes);
        HashMap<String, XmlSuite> suites = new HashMap<String, XmlSuite>();
        IAnnotationFinder finder = SuiteRunner.getAnnotationFinder(1);
        for (int i = 0; i < classes.length; ++i) {
            XmlSuite xmlSuite;
            Class c = classes[i];
            ITest test = (ITest)finder.findAnnotation(c, ITest.class);
            String suiteName = DEFAULT_SUITE_NAME;
            String testName = DEFAULT_TEST_NAME;
            if (test != null) {
                suiteName = test.getSuiteName();
                testName = test.getTestName();
            }
            if ((xmlSuite = (XmlSuite)suites.get(suiteName)) == null) {
                xmlSuite = new XmlSuite();
                xmlSuite.setName(suiteName);
                suites.put(suiteName, xmlSuite);
            }
            XmlTest xmlTest = null;
            for (XmlTest xt : xmlSuite.getTests()) {
                if (!xt.getName().equals(testName)) continue;
                xmlTest = xt;
                break;
            }
            if (xmlTest == null) {
                xmlTest = new XmlTest(xmlSuite);
                xmlTest.setName(testName);
            }
            xmlTest.getXmlClasses().add(xmlClasses[i]);
        }
        XmlSuite[] result = suites.values().toArray(new XmlSuite[suites.size()]);
        return result;
    }

    public void setTestSuites(List<String> suites) {
        for (String suiteXmlPath : suites) {
            try {
                XmlSuite s = new Parser(suiteXmlPath).parse();
                this.m_suites.add(s);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.out);
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace(System.out);
            }
            catch (SAXException e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void setXmlSuites(List<XmlSuite> suites) {
        this.m_suites = suites;
    }

    public void setExcludedGroups(String groups) {
        this.m_groups = Utils.split(groups, ",");
        if (null != this.m_cmdlineSuite) {
            for (XmlSuite s : this.m_cmdlineSuite) {
                s.getTests().get(0).setExcludedGroups(Arrays.asList(this.m_groups));
            }
        }
    }

    public void setGroups(String groups) {
        this.m_groups = Utils.split(groups, ",");
        if (null != this.m_cmdlineSuite) {
            for (XmlSuite s : this.m_cmdlineSuite) {
                s.getTests().get(0).setIncludedGroups(Arrays.asList(this.m_groups));
            }
        }
    }

    private void setTestRunnerFactoryClass(Class testRunnerFactoryClass) {
        this.setTestRunnerFactory((ITestRunnerFactory)this.newInstance(testRunnerFactoryClass));
    }

    private void setTestRunnerFactory(ITestRunnerFactory itrf) {
        this.m_testRunnerFactory = itrf;
    }

    public void setListenerClasses(List<Class> classes) {
        for (Class cls : classes) {
            this.addListener(this.newInstance(cls));
        }
    }

    private void setListeners(List<Object> itls) {
        for (Object obj : itls) {
            this.addListener(obj);
        }
    }

    public void addListener(Object listener) {
        if (!(listener instanceof ISuiteListener || listener instanceof ITestListener || listener instanceof IReporter)) {
            TestNG.exitWithError("Listener " + listener + " is neither an ITestListener, ISuiteListener nor IReporter");
        } else {
            if (listener instanceof ISuiteListener) {
                this.addListener((ISuiteListener)listener);
            }
            if (listener instanceof ITestListener) {
                this.addListener((ITestListener)listener);
            }
            if (listener instanceof IReporter) {
                this.addListener((IReporter)listener);
            }
        }
    }

    public void addListener(ISuiteListener listener) {
        if (null != listener) {
            this.m_suiteListeners.add(listener);
        }
    }

    public void addListener(ITestListener listener) {
        if (null != listener) {
            this.m_testListeners.add(listener);
        }
    }

    public void addListener(IReporter listener) {
        if (null != listener) {
            this.m_reporters.add(listener);
        }
    }

    public List<IReporter> getReporters() {
        return this.m_reporters;
    }

    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    public List<ISuiteListener> getSuiteListeners() {
        return this.m_suiteListeners;
    }

    public void setVerbose(int verbose) {
        this.m_verbose = new Integer(verbose);
    }

    public void run() {
        if (TestNG.isJdk14() || JAVADOC_ANNOTATION_TYPE.equals(this.m_target)) {
            AnnotationConfiguration.getInstance().getAnnotationFinder().addSourceDirs(this.m_sourceDirs);
        }
        List<ISuite> suiteRunners = null;
        if (this.m_clientPort != 0) {
            this.waitForSuites();
        } else if (this.m_hostFile == null) {
            suiteRunners = this.runSuitesLocally();
            for (IReporter reporter : this.m_reporters) {
                reporter.generateReport(this.m_suites, suiteRunners, this.m_outputDir);
            }
        } else {
            suiteRunners = this.runSuitesRemotely();
            for (IReporter reporter : this.m_reporters) {
                reporter.generateReport(this.m_suites, suiteRunners, this.m_outputDir);
            }
        }
        int runMethodsCount = 0;
        if (null != suiteRunners) {
            for (ISuite suite : suiteRunners) {
                runMethodsCount += suite.getInvokedMethods().size();
            }
        }
        if (runMethodsCount == 0) {
            this.setStatus(8);
            if (TestRunner.getVerbose() > 1) {
                System.err.println("[TestNG] No tests found. Nothing was run");
            }
        }
    }

    private static ConnectionInfo resetSocket(int clientPort, ConnectionInfo oldCi) throws IOException {
        ConnectionInfo result = new ConnectionInfo();
        ServerSocket serverSocket = new ServerSocket(clientPort);
        serverSocket.setReuseAddress(true);
        TestNG.log("Waiting for connections on port " + clientPort);
        Socket socket = serverSocket.accept();
        result.setSocket(socket);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void waitForSuites() {
        try {
            ci = TestNG.resetSocket(this.m_clientPort, null);
            while (true) lbl-1000:
            // 4 sources

            {
                try {
                    while (true) {
                        s = (XmlSuite)ci.getOis().readObject();
                        TestNG.log("Processing " + s.getName());
                        this.m_suites = new ArrayList<XmlSuite>();
                        this.m_suites.add(s);
                        suiteRunners = this.runSuitesLocally();
                        sr = suiteRunners.get(0);
                        TestNG.log("Done processing " + s.getName());
                        ci.getOos().writeObject(sr);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace(System.out);
                }
                catch (EOFException ex) {
                    TestNG.log("Connection closed " + ex.getMessage());
                    ci = TestNG.resetSocket(this.m_clientPort, ci);
                }
                catch (SocketException ex) {
                    TestNG.log("Connection closed " + ex.getMessage());
                    ci = TestNG.resetSocket(this.m_clientPort, ci);
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
            return;
        }
        ** GOTO lbl-1000
    }

    private static void log(String string) {
        Utils.log("", 2, string);
    }

    private List<ISuite> runSuitesRemotely() {
        ArrayList<ISuite> result = new ArrayList<ISuite>();
        HostFile hostFile = new HostFile(this.m_hostFile);
        String[] hosts = hostFile.getHosts();
        Socket[] sockets = new Socket[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            String host = hosts[i];
            String[] s = host.split(":");
            try {
                sockets[i] = new Socket(s[0], Integer.parseInt(s[1]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace(System.out);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                unknownHostException.printStackTrace(System.out);
                continue;
            }
            catch (IOException iOException) {
                Utils.error("Couldn't connect to " + host + ": " + iOException.getMessage());
            }
        }
        try {
            this.m_slavePool.addSlaves(sockets);
        }
        catch (IOException e1) {
            e1.printStackTrace(System.out);
        }
        ArrayList<RemoteWorker> workers = new ArrayList<RemoteWorker>();
        if (hostFile.isStrategyTest()) {
            for (XmlSuite suite : this.m_suites) {
                suite.setVerbose(hostFile.getVerbose());
                SuiteRunner suiteRunner = new SuiteRunner(suite, this.m_outputDir);
                for (XmlTest test : suite.getTests()) {
                    XmlSuite tmpSuite = new XmlSuite();
                    tmpSuite.setXmlPackages(suite.getXmlPackages());
                    tmpSuite.setAnnotations(suite.getAnnotations());
                    tmpSuite.setJUnit(suite.isJUnit());
                    tmpSuite.setName("Temporary suite for " + test.getName());
                    tmpSuite.setParallel(suite.isParallel());
                    tmpSuite.setParameters(suite.getParameters());
                    tmpSuite.setThreadCount(suite.getThreadCount());
                    tmpSuite.setVerbose(suite.getVerbose());
                    XmlTest tmpTest = new XmlTest(tmpSuite);
                    tmpTest.setAnnotations(test.getAnnotations());
                    tmpTest.setBeanShellExpression(test.getExpression());
                    tmpTest.setClassNames(test.getXmlClasses());
                    tmpTest.setExcludedGroups(test.getExcludedGroups());
                    tmpTest.setIncludedGroups(test.getIncludedGroups());
                    tmpTest.setJUnit(test.isJUnit());
                    tmpTest.setMethodSelectors(test.getMethodSelectors());
                    tmpTest.setName(test.getName());
                    tmpTest.setParallel(test.isParallel());
                    tmpTest.setParameters(test.getParameters());
                    tmpTest.setVerbose(test.getVerbose());
                    tmpTest.setXmlClasses(test.getXmlClasses());
                    tmpTest.setXmlPackages(test.getXmlPackages());
                    workers.add(new RemoteTestWorker(tmpSuite, this.m_slavePool, suiteRunner, result));
                }
                result.add(suiteRunner);
            }
        } else {
            for (XmlSuite suite : this.m_suites) {
                workers.add(new RemoteSuiteWorker(suite, this.m_slavePool, result));
            }
        }
        IPooledExecutor executor = ThreadUtil.createPooledExecutor(1);
        for (Runnable runnable : workers) {
            executor.execute(runnable);
        }
        executor.shutdown();
        long maxTimeOut = 10000L;
        try {
            executor.awaitTermination(maxTimeOut);
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.out);
        }
        for (ISuite suite : result) {
            for (ISuiteResult suiteResult : suite.getResults().values()) {
                Collection[] allTests;
                for (Collection all : allTests = new Collection[]{suiteResult.getTestContext().getPassedTests().getAllResults(), suiteResult.getTestContext().getFailedTests().getAllResults(), suiteResult.getTestContext().getSkippedTests().getAllResults(), suiteResult.getTestContext().getFailedButWithinSuccessPercentageTests().getAllResults()}) {
                    for (ITestResult tr : all) {
                        Invoker.runTestListeners(tr, this.m_testListeners);
                    }
                }
            }
        }
        return result;
    }

    public List<ISuite> runSuitesLocally() {
        ArrayList<ISuite> result = new ArrayList<ISuite>();
        if (this.m_suites.size() > 0) {
            for (XmlSuite xmlSuite : this.m_suites) {
                if (null != this.m_isJUnit) {
                    xmlSuite.setJUnit(this.m_isJUnit);
                }
                if (null != this.m_verbose) {
                    xmlSuite.setVerbose(this.m_verbose);
                }
                result.add(this.createAndRunSuiteRunners(xmlSuite));
            }
        } else {
            this.setStatus(8);
            System.err.println("[ERROR]: No test suite found.  Nothing to run");
        }
        return result;
    }

    private SuiteRunner createAndRunSuiteRunners(XmlSuite xmlSuite) {
        SuiteRunner result = null;
        result = null != this.m_testRunnerFactory ? new SuiteRunner(xmlSuite, this.m_outputDir, this.m_testRunnerFactory, this.m_useDefaultListeners) : new SuiteRunner(xmlSuite, this.m_outputDir, this.m_useDefaultListeners);
        for (ISuiteListener isl : this.m_suiteListeners) {
            result.addListener(isl);
        }
        result.setTestListeners(this.m_testListeners);
        if (this.m_clientPort != 0) {
            try {
                result.setHost(InetAddress.getLocalHost() + ":" + this.m_clientPort);
            }
            catch (UnknownHostException e) {
                e.printStackTrace(System.out);
            }
        }
        result.run();
        return result;
    }

    private Object newInstance(Class clazz) {
        try {
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (IllegalAccessException iae) {
            throw new TestNGException("Class " + clazz.getName() + " does not have a no-args constructor", iae);
        }
        catch (InstantiationException ie) {
            throw new TestNGException("Cannot instantiate class " + clazz.getName(), ie);
        }
        catch (ExceptionInInitializerError eiierr) {
            throw new TestNGException("An exception occurred in static initialization of class " + clazz.getName(), eiierr);
        }
        catch (SecurityException se) {
            throw new TestNGException(se);
        }
    }

    public static void main(String[] argv) {
        TestNG testng = TestNG.privateMain(argv, null);
        System.exit(testng.getStatus());
    }

    public static TestNG privateMain(String[] argv, ITestListener listener) {
        Map cmdLineArgs = TestNGCommandLineArgs.parseCommandLine(argv);
        TestNG.setTestNGVersion();
        TestNG result = new TestNG();
        if (null != listener) {
            result.addListener(listener);
        }
        try {
            List listenerClasses;
            List testNgXml;
            TestNG.checkConditions(cmdLineArgs);
            Integer verbose = (Integer)cmdLineArgs.get("-log");
            if (null != verbose) {
                result.setVerbose(verbose);
            }
            result.setOutputDirectory((String)cmdLineArgs.get("-d"));
            result.setSourcePath((String)cmdLineArgs.get("-sourcedir"));
            List testClasses = (List)cmdLineArgs.get("-testclass");
            if (null != testClasses) {
                Class[] classes = testClasses.toArray(new Class[testClasses.size()]);
                result.setTestClasses(classes);
            }
            if (null != (testNgXml = (List)cmdLineArgs.get("testng.suite.definitions"))) {
                result.setTestSuites(testNgXml);
            }
            result.setGroups((String)cmdLineArgs.get("-groups"));
            result.setExcludedGroups((String)cmdLineArgs.get("-excludegroups"));
            result.setTarget((String)cmdLineArgs.get("-target"));
            result.setTestJar((String)cmdLineArgs.get("-testjar"));
            result.setJUnit((Boolean)cmdLineArgs.get("-junit"));
            result.setHostFile((String)cmdLineArgs.get("-hostfile"));
            String client = (String)cmdLineArgs.get("-slave");
            if (client != null) {
                result.setClientPort(Integer.parseInt(client));
            }
            if (null != (listenerClasses = (List)cmdLineArgs.get("-listener"))) {
                result.setListenerClasses(listenerClasses);
            }
            result.run();
        }
        catch (TestNGException ex) {
            if (TestRunner.getVerbose() > 1) {
                ex.printStackTrace(System.out);
            } else {
                System.err.println("[ERROR]: " + ex.getMessage());
            }
            System.exit(1);
        }
        return result;
    }

    private void setClientPort(int clientPort) {
        this.m_clientPort = clientPort;
    }

    public void setHostFile(String hostFile) {
        this.m_hostFile = hostFile;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public static void setTestNGVersion() {
        try {
            Class.forName("org.testng.annotations.Test");
            m_isJdk14 = false;
        }
        catch (ClassNotFoundException ex) {
            m_isJdk14 = true;
        }
    }

    public static boolean isJdk14() {
        return m_isJdk14;
    }

    private static void checkConditions(Map params) {
        String srcPath;
        List testClasses = (List)params.get("-testclass");
        List testNgXml = (List)params.get("testng.suite.definitions");
        Object testJar = params.get("-testjar");
        Object port = params.get("-slave");
        if (testClasses == null && testNgXml == null && port == null && testJar == null) {
            System.err.println("You need to specify at least one testng.xml or one class");
            TestNG.usage();
            System.exit(-1);
        }
        if (TestNG.isJdk14() && (null == (srcPath = (String)params.get("-sourcedir")) || "".equals(srcPath))) {
            throw new TestNGException("No sourcedir was specified");
        }
        String groups = (String)params.get("-groups");
        String excludedGroups = (String)params.get("-excludegroups");
        if ((null != groups || null != excludedGroups) && null == testClasses) {
            throw new TestNGException("Groups option should be used with testclass option");
        }
    }

    private static void ppp(String s) {
        System.out.println("[TestNG] " + s);
    }

    public boolean hasFailure() {
        return (this.getStatus() & 1) == 1;
    }

    public void setHasFailure(boolean hasFailure) {
        this.m_status |= 1;
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return (this.getStatus() & 4) == 4;
    }

    public void setHasFailureWithinSuccessPercentage(boolean hasFailureWithinSuccessPercentage) {
        this.m_status |= 4;
    }

    public boolean hasSkip() {
        return (this.getStatus() & 2) == 2;
    }

    public void setHasSkip(boolean hasSkip) {
        this.m_status |= 2;
    }

    public static void usage() {
        TestNGCommandLineArgs.usage();
    }

    public static void exitWithError(String msg) {
        System.err.println(msg);
        TestNG.usage();
        System.exit(0);
    }

    public String getOutputDirectory() {
        return this.m_outputDir;
    }
}

