/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.ExecutableStatement;
import org.mvel.ast.Assignment;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class TypedVarNode
extends ASTNode
implements Assignment {
    private String name;
    private ExecutableStatement statement;

    public TypedVarNode(char[] expr, int fields, Class type) {
        super(expr, fields);
        this.egressType = type;
        int assignStart = PropertyTools.find(expr, '=');
        if (assignStart != -1) {
            fields |= 0x800;
            this.name = new String(expr, 0, assignStart).trim();
            ParseTools.checkNameSafety(this.name);
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(expr, assignStart + 1));
        } else {
            this.name = new String(expr);
            ParseTools.checkNameSafety(this.name);
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement != null) {
            Object o = this.statement.getValue(ctx, thisValue, factory);
            ParseTools.finalLocalVariableFactory(factory).createVariable(this.name, o, this.egressType);
            return o;
        }
        factory.createVariable(this.name, null, this.egressType);
        return Void.class;
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAssignmentVar() {
        return this.name;
    }
}

