%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x4008000000000000", "0x4008000000000000", "0x4008000000000000", "0x4008000000000000"],
    "XMM1": ["0x4000000000000000", "0x4000000000000000", "0x4000000000000000", "0x4000000000000000"],
    "XMM3": ["0x3FF0000000000000", "0x3FF0000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4": ["0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000"],
    "XMM5": ["0x3FF0000000000000", "0x3FF0000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM6": ["0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000", "0x3FF0000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 0]
vmovapd ymm1, [rdx + 32]

; Register only
vsubpd xmm3, xmm0, xmm1
vsubpd ymm4, ymm0, ymm1

; Memory operand
vsubpd xmm5, xmm0, [rdx + 32]
vsubpd ymm6, ymm0, [rdx + 32]

hlt

align 32
.data:
dq 0x4008000000000000
dq 0x4008000000000000
dq 0x4008000000000000
dq 0x4008000000000000

dq 0x4000000000000000
dq 0x4000000000000000
dq 0x4000000000000000
dq 0x4000000000000000
