﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/application-insights/model/UpdateStatus.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace ApplicationInsights {
namespace Model {
namespace UpdateStatusMapper {

static const int RESOLVED_HASH = HashingUtils::HashString("RESOLVED");

UpdateStatus GetUpdateStatusForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == RESOLVED_HASH) {
    return UpdateStatus::RESOLVED;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<UpdateStatus>(hashCode);
  }

  return UpdateStatus::NOT_SET;
}

Aws::String GetNameForUpdateStatus(UpdateStatus enumValue) {
  switch (enumValue) {
    case UpdateStatus::NOT_SET:
      return {};
    case UpdateStatus::RESOLVED:
      return "RESOLVED";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace UpdateStatusMapper
}  // namespace Model
}  // namespace ApplicationInsights
}  // namespace Aws
