﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/arc-region-switch/ARCRegionswitch_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ARCRegionswitch {
namespace Model {
class StartPlanExecutionResult {
 public:
  AWS_ARCREGIONSWITCH_API StartPlanExecutionResult() = default;
  AWS_ARCREGIONSWITCH_API StartPlanExecutionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ARCREGIONSWITCH_API StartPlanExecutionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The execution identifier of a plan execution.</p>
   */
  inline const Aws::String& GetExecutionId() const { return m_executionId; }
  template <typename ExecutionIdT = Aws::String>
  void SetExecutionId(ExecutionIdT&& value) {
    m_executionIdHasBeenSet = true;
    m_executionId = std::forward<ExecutionIdT>(value);
  }
  template <typename ExecutionIdT = Aws::String>
  StartPlanExecutionResult& WithExecutionId(ExecutionIdT&& value) {
    SetExecutionId(std::forward<ExecutionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The details of the Region switch plan.</p>
   */
  inline const Aws::String& GetPlan() const { return m_plan; }
  template <typename PlanT = Aws::String>
  void SetPlan(PlanT&& value) {
    m_planHasBeenSet = true;
    m_plan = std::forward<PlanT>(value);
  }
  template <typename PlanT = Aws::String>
  StartPlanExecutionResult& WithPlan(PlanT&& value) {
    SetPlan(std::forward<PlanT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the plan, a unique number generated by Region switch.</p>
   */
  inline const Aws::String& GetPlanVersion() const { return m_planVersion; }
  template <typename PlanVersionT = Aws::String>
  void SetPlanVersion(PlanVersionT&& value) {
    m_planVersionHasBeenSet = true;
    m_planVersion = std::forward<PlanVersionT>(value);
  }
  template <typename PlanVersionT = Aws::String>
  StartPlanExecutionResult& WithPlanVersion(PlanVersionT&& value) {
    SetPlanVersion(std::forward<PlanVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services Region to activate.</p>
   */
  inline const Aws::String& GetActivateRegion() const { return m_activateRegion; }
  template <typename ActivateRegionT = Aws::String>
  void SetActivateRegion(ActivateRegionT&& value) {
    m_activateRegionHasBeenSet = true;
    m_activateRegion = std::forward<ActivateRegionT>(value);
  }
  template <typename ActivateRegionT = Aws::String>
  StartPlanExecutionResult& WithActivateRegion(ActivateRegionT&& value) {
    SetActivateRegion(std::forward<ActivateRegionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services Region to deactivate.</p>
   */
  inline const Aws::String& GetDeactivateRegion() const { return m_deactivateRegion; }
  template <typename DeactivateRegionT = Aws::String>
  void SetDeactivateRegion(DeactivateRegionT&& value) {
    m_deactivateRegionHasBeenSet = true;
    m_deactivateRegion = std::forward<DeactivateRegionT>(value);
  }
  template <typename DeactivateRegionT = Aws::String>
  StartPlanExecutionResult& WithDeactivateRegion(DeactivateRegionT&& value) {
    SetDeactivateRegion(std::forward<DeactivateRegionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartPlanExecutionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_executionId;
  bool m_executionIdHasBeenSet = false;

  Aws::String m_plan;
  bool m_planHasBeenSet = false;

  Aws::String m_planVersion;
  bool m_planVersionHasBeenSet = false;

  Aws::String m_activateRegion;
  bool m_activateRegionHasBeenSet = false;

  Aws::String m_deactivateRegion;
  bool m_deactivateRegionHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ARCRegionswitch
}  // namespace Aws
