﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-runtime/model/GuardrailConverseImageBlock.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace BedrockRuntime {
namespace Model {

GuardrailConverseImageBlock::GuardrailConverseImageBlock(JsonView jsonValue) { *this = jsonValue; }

GuardrailConverseImageBlock& GuardrailConverseImageBlock::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("format")) {
    m_format = GuardrailConverseImageFormatMapper::GetGuardrailConverseImageFormatForName(jsonValue.GetString("format"));
    m_formatHasBeenSet = true;
  }
  if (jsonValue.ValueExists("source")) {
    m_source = jsonValue.GetObject("source");
    m_sourceHasBeenSet = true;
  }
  return *this;
}

JsonValue GuardrailConverseImageBlock::Jsonize() const {
  JsonValue payload;

  if (m_formatHasBeenSet) {
    payload.WithString("format", GuardrailConverseImageFormatMapper::GetNameForGuardrailConverseImageFormat(m_format));
  }

  if (m_sourceHasBeenSet) {
    payload.WithObject("source", m_source.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace BedrockRuntime
}  // namespace Aws
