﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ce/CostExplorer_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CostExplorer {
namespace Model {
class CreateCostCategoryDefinitionResult {
 public:
  AWS_COSTEXPLORER_API CreateCostCategoryDefinitionResult() = default;
  AWS_COSTEXPLORER_API CreateCostCategoryDefinitionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_COSTEXPLORER_API CreateCostCategoryDefinitionResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique identifier for your newly created Cost Category. </p>
   */
  inline const Aws::String& GetCostCategoryArn() const { return m_costCategoryArn; }
  template <typename CostCategoryArnT = Aws::String>
  void SetCostCategoryArn(CostCategoryArnT&& value) {
    m_costCategoryArnHasBeenSet = true;
    m_costCategoryArn = std::forward<CostCategoryArnT>(value);
  }
  template <typename CostCategoryArnT = Aws::String>
  CreateCostCategoryDefinitionResult& WithCostCategoryArn(CostCategoryArnT&& value) {
    SetCostCategoryArn(std::forward<CostCategoryArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Cost Category's effective start date. It can only be a billing start date
   * (first day of the month).</p>
   */
  inline const Aws::String& GetEffectiveStart() const { return m_effectiveStart; }
  template <typename EffectiveStartT = Aws::String>
  void SetEffectiveStart(EffectiveStartT&& value) {
    m_effectiveStartHasBeenSet = true;
    m_effectiveStart = std::forward<EffectiveStartT>(value);
  }
  template <typename EffectiveStartT = Aws::String>
  CreateCostCategoryDefinitionResult& WithEffectiveStart(EffectiveStartT&& value) {
    SetEffectiveStart(std::forward<EffectiveStartT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateCostCategoryDefinitionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_costCategoryArn;
  bool m_costCategoryArnHasBeenSet = false;

  Aws::String m_effectiveStart;
  bool m_effectiveStartHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostExplorer
}  // namespace Aws
