﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime-sdk-identity/model/TargetedMessages.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace ChimeSDKIdentity {
namespace Model {
namespace TargetedMessagesMapper {

static const int ALL_HASH = HashingUtils::HashString("ALL");
static const int NONE_HASH = HashingUtils::HashString("NONE");

TargetedMessages GetTargetedMessagesForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ALL_HASH) {
    return TargetedMessages::ALL;
  } else if (hashCode == NONE_HASH) {
    return TargetedMessages::NONE;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<TargetedMessages>(hashCode);
  }

  return TargetedMessages::NOT_SET;
}

Aws::String GetNameForTargetedMessages(TargetedMessages enumValue) {
  switch (enumValue) {
    case TargetedMessages::NOT_SET:
      return {};
    case TargetedMessages::ALL:
      return "ALL";
    case TargetedMessages::NONE:
      return "NONE";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace TargetedMessagesMapper
}  // namespace Model
}  // namespace ChimeSDKIdentity
}  // namespace Aws
