﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ChimeSDKVoice {
namespace Model {

/**
 * <p>A high-level overview of a voice profile domain.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/VoiceProfileDomainSummary">AWS
 * API Reference</a></p>
 */
class VoiceProfileDomainSummary {
 public:
  AWS_CHIMESDKVOICE_API VoiceProfileDomainSummary() = default;
  AWS_CHIMESDKVOICE_API VoiceProfileDomainSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIMESDKVOICE_API VoiceProfileDomainSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CHIMESDKVOICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ID of the voice profile domain summary.</p>
   */
  inline const Aws::String& GetVoiceProfileDomainId() const { return m_voiceProfileDomainId; }
  inline bool VoiceProfileDomainIdHasBeenSet() const { return m_voiceProfileDomainIdHasBeenSet; }
  template <typename VoiceProfileDomainIdT = Aws::String>
  void SetVoiceProfileDomainId(VoiceProfileDomainIdT&& value) {
    m_voiceProfileDomainIdHasBeenSet = true;
    m_voiceProfileDomainId = std::forward<VoiceProfileDomainIdT>(value);
  }
  template <typename VoiceProfileDomainIdT = Aws::String>
  VoiceProfileDomainSummary& WithVoiceProfileDomainId(VoiceProfileDomainIdT&& value) {
    SetVoiceProfileDomainId(std::forward<VoiceProfileDomainIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of a voice profile in a voice profile domain summary.</p>
   */
  inline const Aws::String& GetVoiceProfileDomainArn() const { return m_voiceProfileDomainArn; }
  inline bool VoiceProfileDomainArnHasBeenSet() const { return m_voiceProfileDomainArnHasBeenSet; }
  template <typename VoiceProfileDomainArnT = Aws::String>
  void SetVoiceProfileDomainArn(VoiceProfileDomainArnT&& value) {
    m_voiceProfileDomainArnHasBeenSet = true;
    m_voiceProfileDomainArn = std::forward<VoiceProfileDomainArnT>(value);
  }
  template <typename VoiceProfileDomainArnT = Aws::String>
  VoiceProfileDomainSummary& WithVoiceProfileDomainArn(VoiceProfileDomainArnT&& value) {
    SetVoiceProfileDomainArn(std::forward<VoiceProfileDomainArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the voice profile domain summary.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  VoiceProfileDomainSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Describes the voice profile domain summary.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  VoiceProfileDomainSummary& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the voice profile domain summary was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTimestamp() const { return m_createdTimestamp; }
  inline bool CreatedTimestampHasBeenSet() const { return m_createdTimestampHasBeenSet; }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  void SetCreatedTimestamp(CreatedTimestampT&& value) {
    m_createdTimestampHasBeenSet = true;
    m_createdTimestamp = std::forward<CreatedTimestampT>(value);
  }
  template <typename CreatedTimestampT = Aws::Utils::DateTime>
  VoiceProfileDomainSummary& WithCreatedTimestamp(CreatedTimestampT&& value) {
    SetCreatedTimestamp(std::forward<CreatedTimestampT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time at which the voice profile domain summary was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdatedTimestamp() const { return m_updatedTimestamp; }
  inline bool UpdatedTimestampHasBeenSet() const { return m_updatedTimestampHasBeenSet; }
  template <typename UpdatedTimestampT = Aws::Utils::DateTime>
  void SetUpdatedTimestamp(UpdatedTimestampT&& value) {
    m_updatedTimestampHasBeenSet = true;
    m_updatedTimestamp = std::forward<UpdatedTimestampT>(value);
  }
  template <typename UpdatedTimestampT = Aws::Utils::DateTime>
  VoiceProfileDomainSummary& WithUpdatedTimestamp(UpdatedTimestampT&& value) {
    SetUpdatedTimestamp(std::forward<UpdatedTimestampT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_voiceProfileDomainId;
  bool m_voiceProfileDomainIdHasBeenSet = false;

  Aws::String m_voiceProfileDomainArn;
  bool m_voiceProfileDomainArnHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::Utils::DateTime m_createdTimestamp{};
  bool m_createdTimestampHasBeenSet = false;

  Aws::Utils::DateTime m_updatedTimestamp{};
  bool m_updatedTimestampHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
