﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanroomsml/CleanRoomsML_EXPORTS.h>
#include <aws/cleanroomsml/model/AudienceModelStatus.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CleanRoomsML {
namespace Model {

/**
 * <p>Information about the audience model.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/AudienceModelSummary">AWS
 * API Reference</a></p>
 */
class AudienceModelSummary {
 public:
  AWS_CLEANROOMSML_API AudienceModelSummary() = default;
  AWS_CLEANROOMSML_API AudienceModelSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMSML_API AudienceModelSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMSML_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The time at which the audience model was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateTime() const { return m_createTime; }
  inline bool CreateTimeHasBeenSet() const { return m_createTimeHasBeenSet; }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  void SetCreateTime(CreateTimeT&& value) {
    m_createTimeHasBeenSet = true;
    m_createTime = std::forward<CreateTimeT>(value);
  }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  AudienceModelSummary& WithCreateTime(CreateTimeT&& value) {
    SetCreateTime(std::forward<CreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The most recent time at which the audience model was updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTime() const { return m_updateTime; }
  inline bool UpdateTimeHasBeenSet() const { return m_updateTimeHasBeenSet; }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  void SetUpdateTime(UpdateTimeT&& value) {
    m_updateTimeHasBeenSet = true;
    m_updateTime = std::forward<UpdateTimeT>(value);
  }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  AudienceModelSummary& WithUpdateTime(UpdateTimeT&& value) {
    SetUpdateTime(std::forward<UpdateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the audience model.</p>
   */
  inline const Aws::String& GetAudienceModelArn() const { return m_audienceModelArn; }
  inline bool AudienceModelArnHasBeenSet() const { return m_audienceModelArnHasBeenSet; }
  template <typename AudienceModelArnT = Aws::String>
  void SetAudienceModelArn(AudienceModelArnT&& value) {
    m_audienceModelArnHasBeenSet = true;
    m_audienceModelArn = std::forward<AudienceModelArnT>(value);
  }
  template <typename AudienceModelArnT = Aws::String>
  AudienceModelSummary& WithAudienceModelArn(AudienceModelArnT&& value) {
    SetAudienceModelArn(std::forward<AudienceModelArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the audience model.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  AudienceModelSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the training dataset that was used for the
   * audience model.</p>
   */
  inline const Aws::String& GetTrainingDatasetArn() const { return m_trainingDatasetArn; }
  inline bool TrainingDatasetArnHasBeenSet() const { return m_trainingDatasetArnHasBeenSet; }
  template <typename TrainingDatasetArnT = Aws::String>
  void SetTrainingDatasetArn(TrainingDatasetArnT&& value) {
    m_trainingDatasetArnHasBeenSet = true;
    m_trainingDatasetArn = std::forward<TrainingDatasetArnT>(value);
  }
  template <typename TrainingDatasetArnT = Aws::String>
  AudienceModelSummary& WithTrainingDatasetArn(TrainingDatasetArnT&& value) {
    SetTrainingDatasetArn(std::forward<TrainingDatasetArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the audience model.</p>
   */
  inline AudienceModelStatus GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  inline void SetStatus(AudienceModelStatus value) {
    m_statusHasBeenSet = true;
    m_status = value;
  }
  inline AudienceModelSummary& WithStatus(AudienceModelStatus value) {
    SetStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the audience model.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  AudienceModelSummary& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createTime{};
  bool m_createTimeHasBeenSet = false;

  Aws::Utils::DateTime m_updateTime{};
  bool m_updateTimeHasBeenSet = false;

  Aws::String m_audienceModelArn;
  bool m_audienceModelArnHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_trainingDatasetArn;
  bool m_trainingDatasetArnHasBeenSet = false;

  AudienceModelStatus m_status{AudienceModelStatus::NOT_SET};
  bool m_statusHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRoomsML
}  // namespace Aws
