﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/comprehendmedical/ComprehendMedical_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ComprehendMedical {
namespace Model {

/**
 * <p>The output properties for a detection job.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/OutputDataConfig">AWS
 * API Reference</a></p>
 */
class OutputDataConfig {
 public:
  AWS_COMPREHENDMEDICAL_API OutputDataConfig() = default;
  AWS_COMPREHENDMEDICAL_API OutputDataConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_COMPREHENDMEDICAL_API OutputDataConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COMPREHENDMEDICAL_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>When you use the <code>OutputDataConfig</code> object with asynchronous
   * operations, you specify the Amazon S3 location where you want to write the
   * output data. The URI must be in the same region as the API endpoint that you are
   * calling. The location is used as the prefix for the actual location of the
   * output.</p>
   */
  inline const Aws::String& GetS3Bucket() const { return m_s3Bucket; }
  inline bool S3BucketHasBeenSet() const { return m_s3BucketHasBeenSet; }
  template <typename S3BucketT = Aws::String>
  void SetS3Bucket(S3BucketT&& value) {
    m_s3BucketHasBeenSet = true;
    m_s3Bucket = std::forward<S3BucketT>(value);
  }
  template <typename S3BucketT = Aws::String>
  OutputDataConfig& WithS3Bucket(S3BucketT&& value) {
    SetS3Bucket(std::forward<S3BucketT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The path to the output data files in the S3 bucket. Amazon Comprehend Medical
   * creates an output directory using the job ID so that the output from one job
   * does not overwrite the output of another.</p>
   */
  inline const Aws::String& GetS3Key() const { return m_s3Key; }
  inline bool S3KeyHasBeenSet() const { return m_s3KeyHasBeenSet; }
  template <typename S3KeyT = Aws::String>
  void SetS3Key(S3KeyT&& value) {
    m_s3KeyHasBeenSet = true;
    m_s3Key = std::forward<S3KeyT>(value);
  }
  template <typename S3KeyT = Aws::String>
  OutputDataConfig& WithS3Key(S3KeyT&& value) {
    SetS3Key(std::forward<S3KeyT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_s3Bucket;
  bool m_s3BucketHasBeenSet = false;

  Aws::String m_s3Key;
  bool m_s3KeyHasBeenSet = false;
};

}  // namespace Model
}  // namespace ComprehendMedical
}  // namespace Aws
