/*
 * Decompiled with CFR 0.152.
 */
package org.virtuslab.yaml.internal.load.reader;

import java.io.Serializable;
import org.virtuslab.yaml.internal.load.reader.Reader;
import org.virtuslab.yaml.internal.load.reader.TokenizerContext$;
import org.virtuslab.yaml.internal.load.reader.token.Token;
import org.virtuslab.yaml.internal.load.reader.token.Token$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$BlockEnd$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$DocumentEnd$;
import org.virtuslab.yaml.internal.load.reader.token.TokenKind$DocumentStart$;
import scala.Option;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TokenizerContext
implements Product,
Serializable {
    private final Reader reader;
    private final ArrayDeque tokens;
    private boolean isPlainKeyAllowed;
    private final ArrayDeque<Object> indentations;
    private int flowSequenceLevel;
    private int flowMappingLevel;
    private final ArrayDeque potentialKeys;

    public static TokenizerContext apply(Reader reader) {
        return TokenizerContext$.MODULE$.apply(reader);
    }

    public static TokenizerContext apply(String string2) {
        return TokenizerContext$.MODULE$.apply(string2);
    }

    public static TokenizerContext fromProduct(Product product) {
        return TokenizerContext$.MODULE$.fromProduct(product);
    }

    public static TokenizerContext unapply(TokenizerContext tokenizerContext) {
        return TokenizerContext$.MODULE$.unapply(tokenizerContext);
    }

    public TokenizerContext(Reader reader) {
        this.reader = reader;
        this.tokens = ArrayDeque$.MODULE$.empty();
        this.isPlainKeyAllowed = true;
        this.indentations = ArrayDeque$.MODULE$.empty();
        this.flowSequenceLevel = 0;
        this.flowMappingLevel = 0;
        this.potentialKeys = ArrayDeque$.MODULE$.empty();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TokenizerContext)) return false;
        TokenizerContext tokenizerContext = (TokenizerContext)object;
        Reader reader = this.reader();
        Reader reader2 = tokenizerContext.reader();
        if (reader == null) {
            if (reader2 != null) {
                return false;
            }
        } else if (!reader.equals(reader2)) return false;
        if (!tokenizerContext.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof TokenizerContext;
    }

    @Override
    public int productArity() {
        return 1;
    }

    @Override
    public String productPrefix() {
        return "TokenizerContext";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "reader";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public Reader reader() {
        return this.reader;
    }

    public ArrayDeque<Token> tokens() {
        return this.tokens;
    }

    public boolean isPlainKeyAllowed() {
        return this.isPlainKeyAllowed;
    }

    public void isPlainKeyAllowed_$eq(boolean x$1) {
        this.isPlainKeyAllowed = x$1;
    }

    public int indent() {
        return BoxesRunTime.unboxToInt(this.indentations.lastOption().getOrElse(TokenizerContext::indent$$anonfun$1));
    }

    public void addIndent(int newIndent) {
        this.indentations.append(BoxesRunTime.boxToInteger(newIndent));
    }

    public void removeLastIndent() {
        if (this.indentations.nonEmpty()) {
            this.indentations.removeLast(this.indentations.removeLast$default$1());
            return;
        }
    }

    public ArrayDeque<Token> potentialKeys() {
        return this.potentialKeys;
    }

    public void addPotentialKey(Token key) {
        this.potentialKeys().addOne((Object)key);
    }

    public List<Token> popPotentialKeys() {
        return this.potentialKeys().removeAll().toList();
    }

    public Option<Token> potentialKeyOpt() {
        return this.potentialKeys().headOption();
    }

    public boolean needMoreTokens() {
        return this.tokens().isEmpty() || this.potentialKeys().nonEmpty();
    }

    public List<Token> checkIndents(int current) {
        if (current < this.indent()) {
            this.indentations.removeLast(this.indentations.removeLast$default$1());
            Token token = Token$.MODULE$.apply(TokenKind$BlockEnd$.MODULE$, this.reader().range());
            return (List)this.checkIndents(current).$plus$colon(token);
        }
        return package$.MODULE$.Nil();
    }

    public void enterFlowSequence() {
        ++this.flowSequenceLevel;
    }

    public void leaveFlowSequence() {
        --this.flowSequenceLevel;
    }

    public void enterFlowMapping() {
        ++this.flowMappingLevel;
    }

    public void leaveFlowMapping() {
        --this.flowMappingLevel;
    }

    public boolean isAllowedSpecialCharacter(char c) {
        if ((c == ',' || c == '}') && this.flowMappingLevel > 0) {
            return false;
        }
        return c != ',' && c != ']' || this.flowSequenceLevel <= 0;
    }

    public boolean isInFlowMapping() {
        return this.flowMappingLevel > 0;
    }

    public boolean isInFlowSequence() {
        return this.flowSequenceLevel > 0;
    }

    public boolean isInFlowCollection() {
        return this.isInFlowMapping() || this.isInFlowSequence();
    }

    public boolean isInBlockCollection() {
        return !this.isInFlowCollection();
    }

    public List<Token> parseDocumentStart(int indent) {
        return (List)this.checkIndents(-1).$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$DocumentStart$.MODULE$, this.reader().range())})));
    }

    public List<Token> parseDocumentEnd() {
        return (List)((IterableOps)this.popPotentialKeys().$plus$plus(this.checkIndents(-1))).$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Token[]{Token$.MODULE$.apply(TokenKind$DocumentEnd$.MODULE$, this.reader().range())})));
    }

    public TokenizerContext copy(Reader reader) {
        return new TokenizerContext(reader);
    }

    public Reader copy$default$1() {
        return this.reader();
    }

    public Reader _1() {
        return this.reader();
    }

    private static final int indent$$anonfun$1() {
        return -1;
    }
}

