#!/bin/bash

file=$1
project=$(echo "$2" | cut -d = -f 2)

if [[ "$file" = "" ]] ; then
    echo "Usage:  $0 <file with smatch messages> -p=<project>"
    exit 1
fi

if [[ "$project" != "kernel" ]] ; then
    exit 0
fi

bin_dir=$(dirname $0)
remove=$(echo ${bin_dir}/../smatch_data/kernel.allocation_funcs.remove)
tmp=$(mktemp /tmp/smatch.XXXX)

echo "// list of functions that return a new allocation." \
    > kernel.allocation_funcs
echo '// generated by `gen_allocation_list.sh`' >> kernel.allocation_funcs
grep "allocation func$" $file | cut -s -d ' ' -f 2 | cut -d '(' -f 1 | \
    sort -u > $tmp
echo "kmalloc" >> $tmp
echo "kzalloc" >> $tmp
echo "kcalloc" >> $tmp
echo "__alloc_skb" >> $tmp
cat $tmp $remove $remove 2> /dev/null | sort | uniq -u \
    >> kernel.allocation_funcs
rm $tmp
echo "Done.  List saved as 'kernel.allocation_funcs'"

