"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDraggableDimensions = getDraggableDimensions;
exports.useDraggableDimensions = useDraggableDimensions;
var _internalContext = require("../drag-drop-context/internal-context");
function getDraggableDimensions(element) {
  var _window$getComputedSt = window.getComputedStyle(element),
    margin = _window$getComputedSt.margin;
  var rect = element.getBoundingClientRect();
  return {
    margin: margin,
    rect: rect
  };
}

/**
 * Returns the captured dimensions of the item being dragged.
 */
function useDraggableDimensions() {
  var _useDragDropContext = (0, _internalContext.useDragDropContext)(),
    getDragState = _useDragDropContext.getDragState;
  var dragState = getDragState();
  if (!dragState.isDragging) {
    return null;
  }
  return dragState.draggableDimensions;
}