/*
 * Utility functions
 *
 * Copyright (C) 2000-2005, Olaf Kirch <okir@suse.de>
 *
 * License: GPL 2.0 or later. See COPYING.GPL for details.
 */

#ifndef UTILS_H
#define UTILS_H

typedef union {
	struct sockaddr		any;
	struct sockaddr_in	sin;
	struct sockaddr_in6	sin6;
} sockaddr_any;

extern unsigned int	getnum(const char *, const char *,
				unsigned int, unsigned int);
extern int		getaddr(const char *, int, sockaddr_any *);
extern const char *	straddr(sockaddr_any *);
extern int		sameaddr(sockaddr_any *, sockaddr_any *);
extern void		printaddr(sockaddr_any *, int) ;
extern void		fatal(const char *, ...);

#endif /* UTILS_H */
