/* Function: text_box_path
**
** Author: Paul W. Carlson	March 1992
*/

#include "ps_info.h"
#include "string.h"
#include "stdlib.h"
#include "iconv.h"

#define LEFT 0
#define RIGHT 1
#define LOWER 0
#define UPPER 1
#define CENTER 2

char *kconv(char *in, const char *tocode, const char *fromcode)
{
    iconv_t cd;
    char *inp;
    char *outp;
    char *out;
    int inlen;
    int outlen;
    int inleft;
    int outleft;
    int ret;

    if(strcmp(fromcode, "JA-AUTO") == 0){
        out = kconv(in, tocode, "EUC-JP");
        if(out != NULL){
            return out;
        }
        out = kconv(in, tocode, "Shift_JIS");
        if(out != NULL){
            return out;
        }
        out = kconv(in, tocode, "UTF-8");
        if(out != NULL){
            return out;
        }
        return NULL;
    }

    cd = iconv_open(tocode, fromcode);
    if(cd == (iconv_t)(-1)){
        return NULL;
    }

    inlen = strlen(in);
    outlen = inlen * 4 + 1;
    out = (char *)malloc(outlen);
    if(out == NULL){
        return NULL;
    }
    inp = in;
    outp = out;
    inleft = inlen;
    outleft = outlen;

    while(inleft > 0){
        ret = iconv(cd, &inp, &inleft, &outp, &outleft);
        if(ret == -1){
            return NULL;
        }
    }

    iconv_close(cd);

    out[outlen - outleft] = '\0';
    return out;
}

int 
text_box_path (double x, double y, int xref, int yref, char *text, int fontsize, float rotate)
{
    /* get relative box coordinates */

    if(strncmp(getenv("LANG"), "ja", 2) != 0){
        fprintf(PS.fp, "ZB (%s) PB\n", text);
    }else{
	int i;
	unsigned char *text2;

	text2 = kconv(text, "Shift_JIS", "JA-AUTO");
	if(text2 != NULL){
            fprintf(PS.fp, "ZB <");
	    for(i = 0; i < strlen(text); i++){
	    	fprintf(PS.fp, "%02x", text2[i]);
	    }
	    fprintf(PS.fp, "> PB\n");
	    free(text2);
	}
    }

    /* set box x coordinate */
    fprintf(PS.fp, "%.2f ", x);
    
    /* set box y coordinate */
    fprintf(PS.fp, " %.2f ", y);
    
    fprintf(PS.fp, "translate %.2f rotate ", rotate); 
    
    fprintf(PS.fp, " 0 ");     
    
    switch (xref)
    {
   	case LEFT: fprintf(PS.fp, "LTX");  break;
	case RIGHT: fprintf(PS.fp, "RTX"); break;
	case CENTER:
	default:
		fprintf(PS.fp, "CTX"); break;
    }

    fprintf(PS.fp, " 0 ");
    
    switch (yref)
    {
	case UPPER: fprintf(PS.fp, "UTY");  break;

	case LOWER: fprintf(PS.fp, "LTY");  break;

	case CENTER:
	default:
		fprintf(PS.fp, "CTY"); break;
    }
    fprintf(PS.fp, " TR TB\n");

    return 0;
}

