/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "anthyplugin.h"

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif


#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif

HonokaPluginRegister(AnthyPlugin);
HonokaPluginSetup(AnthyPlugin);

HonokaSetupCorePage *AnthyPlugin::setup()
{
    bindtextdomain (GETTEXT_PACKAGE, HONOKA_LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    HonokaSetupPage *page = new HonokaSetupPage(_("Anthy-plugin"),"","");
    HonokaSetupPage *sc = new HonokaSetupPage(_("shortcut keys: "),"","");
    sc->append(new HonokaSetupKeyItem(
        _("Anthy Conversion: "),
        String(HONOKA_CONFIG_KEY_CONVERTOR_PREFIX) + String("/Anthy"),
        "",
        ""
    ));
    sc->append(new HonokaSetupKeyItem(
        _("Anthy Prediction: "),
        String(HONOKA_CONFIG_KEY_PREDICTOR_PREFIX) + String("/AnthyPrediction"),
        "",
        ""
    ));
    page->append(sc);
    return page;
};

AnthyPlugin::AnthyPlugin(ConfigPointer cfg) : HonokaMultiplePluginBase(cfg)
{
    bindtextdomain (GETTEXT_PACKAGE, HONOKA_LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    convertor = new AnthyConversion(cfg);
    #ifdef HAS_ANTHY_PREDICTION
    predictor = new AnthyPrediction(cfg,convertor);
    #else
    predictor = 0;
    #endif
}


AnthyPlugin::~AnthyPlugin()
{
    if (predictor) delete predictor;
    delete convertor;
}

/*!
    \fn AnthyPlugin::getPluginInstanceAt(int p)
 */
HonokaPluginBase * AnthyPlugin::getPluginInstanceAt(int p)
{
    if (p == 0) return convertor;
    if ((p == 1) && predictor) return predictor;
    return 0;
}


/*!
    \fn AnthyPlugin::getPluginCount()
 */
int AnthyPlugin::getPluginCount()
{
    if (predictor) return 2;
    return 1;
}

/*!
    \fn AnthyPlugin::getName()
 */
String AnthyPlugin::getName()
{
    return String("AnthyPlugin");
}

