#! /bin/sh
# cree_index_man Christophe Blaess 2003
#                Alain Portal 2005-2006

  REVISION_DAY=`date '+%d'`
  REVISION_MONTH_STRING=`date '+%B'`
  REVISION_YEAR=`date '+%Y'`

  if [ $REVISION_DAY == "01" ]
  then
    REVISION_DAY_STRING=1er
  elif [ $REVISION_DAY == "02" ]
  then
    REVISION_DAY_STRING=2
  elif [ $REVISION_DAY == "03" ]
  then
    REVISION_DAY_STRING=3
  elif [ $REVISION_DAY == "04" ]
  then
    REVISION_DAY_STRING=4
  elif [ $REVISION_DAY == "05" ]
  then
    REVISION_DAY_STRING=5
  elif [ $REVISION_DAY == "06" ]
  then
    REVISION_DAY_STRING=6
  elif [ $REVISION_DAY == "07" ]
  then
    REVISION_DAY_STRING=7
  elif [ $REVISION_DAY == "08" ]
  then
    REVISION_DAY_STRING=9
  elif [ $REVISION_DAY == "09" ]
  then
    REVISION_DAY_STRING=9
  else
    REVISION_DAY_STRING=$REVISION_DAY
  fi

  date="$REVISION_DAY_STRING $REVISION_MONTH_STRING $REVISION_YEAR"

function index_files
{

  dir="$1"
  section="$2"
  title="$3"
  volume="$4"
  file="${dir}"/Index.${section}
  rm -f "${file}"
  echo ".\\\" Do not edit this file, it was created by" >> "$file"
  echo ".\\\" the script $0" >> "$file"
  echo ".TH Index ${section} \"${date}\" LDP \"${volume}\"" >> "$file"
  echo ".SH ${Name}" >> "$file"
  echo "$title" >> "$file"
  echo ".SH ${List}" >> "$file"
  for f in $(ls "${dir}"/* | sort)
  do
    if [ "$f" != "$file" ]
    then
      cat $f | sed -n "/^\.SH \"\?NOM\"\?/,/^\.\|^$/{
/^\.SH \"\?NOM\"\?/b
/^\.\|^$/b
:boucle
N
/\n\./! b boucle
s/\n/ /g
s/[[:blank:]]*\.[^\.]*$//
s/\ \\\- /\n/g
p
}
/^\.Nm/{
s/\([[:alnum:]_]*\) ,/\1,/g
s/^\.Nm //
p
}
/^\.Nd/{
s/^\.Nd //
p
}" | sed -n "1{
i\
.TP
s/^/.B /g
p} 
2{
p
}" >> "$file"
    fi
  done

  cat ${file} | sed -e "
/.SH LISTE/{
i\
.SH DESCRIPTION\n\
Lorsque l'on débute sous Linux (et même après quelques années\n\
de pratique :-)), on ne se rend pas toujours compte des commandes\n\
possibles mises à disposition de l'utilisateur. Aussi, un index\n\
devient fort utile pour consulter la liste de ces commandes.\n\
\n\
C'est la raison d'être de cette page.
}" | sed -e "
\$a\
.SH AUTEUR\n\
Un script mis au point par\\\ :\n\
.TP 4\n\
\n\
- Christophe BLAESS, pour la partie création proprement dite de cette page\n\
de manuel à partir des pages de manuels disponibles dans la section\\\ ;\n\
.TP 4\n\
\n\
- Alain PORTAL, pour l'adaptation dudit script à la création et mise en page\n\
de la version html à des fins de publication\n\
sur le site web des pages françaises.
" > ${file}.tmp

  mv ${file}.tmp ${file}
  chmod 0644 "${file}"

}

function index_dir
{
  [ -d "$1" ] || return 1
  case $(basename "$1") in
    man1 ) index_files "$1" 1 "$User_commands" "$Linux_user_manual" ;;
    man2 ) index_files "$1" 2 "$System_calls" "$Linux_programmer_manual" ;;
    man3 ) index_files "$1" 3 "$Library_functions" "$Linux_programmer_manual" ;;
    man4 ) index_files "$1" 4 "$Devices" "$Linux_programmer_manual" ;;
    man5 ) index_files "$1" 5 "$Files" "$Linux_programmer_manual" ;;
    man6 ) index_files "$1" 6 "$Games" "$Linux_user_manual" ;;
    man7 ) index_files "$1" 7 "$Misc" "$Linux_administrator_manual" ;;
    man8 ) index_files "$1" 8 "$Administration" "$Linux_administrator_manual" ;;
    man9 ) index_files "$1" 9 "$Kernel" "$Linux_programmer_manual" ;;
    mann ) index_files "$1" n "$New" "$Linux_user_manual" ;;
    * ) local i; for i in "$1"/*; do index_dir "$i"; done ;;
  esac
}


#### internationalisation #####

# Default strings

User_commands="User commands"
System_calls="System calls"
Library_functions="Library functions"
Devices="Devices"
Files="Files"
Games="Games"
Misc="Misc"
Administration="Administration"
Kernel="Kernel"
New="New"
Linux_user_manual="Linux User Manual"
Linux_programmer_manual="Linux Programmer Manual"
Linux_administrator_manual="Linux Administrator Manual"
Name="NAME"
List="LIST"

if [ "${LANG#fr}" != "${LANG}" ] || [ "${LC_ALL#fr}" != "${LC_ALL}" ]; then
  User_commands="Commandes utilisateur"
  System_calls="Appels-système"
  Library_functions="Fonctions de bibliothèque"
  Devices="Périphériques"
  Files="Fichiers"
  Games="Jeux"
  Misc="Divers"
  Administration="Administration"
  Kernel="Noyau"
  New="Nouveau"
  Linux_user_manual="Manuel de l'utilisateur Linux"
  Linux_programmer_manual="Manuel du programmeur Linux"
  Linux_administrator_manual="Manuel de l'administrateur Linux"
  Name="NOM"
  List="LISTE"
fi


if [ -z "$1" ]; then
  echo "usage: $0 <man_directory>" >&2
  exit 1
fi


while [ ! -z "$1" ]; do
  index_dir $1
  shift
done
