/***************************************************************************
 *   Copyright (C) 2007 by Francesco Cecconi                               *
 *   francesco.cecconi@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../mainwin.h"


void nmapClass::update_portCombo()
{
	switch(portCombo->currentIndex())
	{
		case 0:
// 			Normal
			portEdit->setEnabled(FALSE);
			break;
		case 1:
// 			All
			portEdit->setEnabled(FALSE);
			break;
		case 2:
// 			Most Important
			portEdit->setEnabled(FALSE);
			break;
		case 3:
// 			Range
			portEdit->setEnabled(TRUE);
			break;
		default:
			portEdit->setEnabled(FALSE);
			break;
	}

}


void nmapClass::update_scanCombo()
{

	switch(comboScan->currentIndex())
	{
		case 0:
// 			Connect Scan
			bounceEdit->setEnabled(FALSE);
			break;
		case 1:
// 			Ping Sweep
			bounceEdit->setEnabled(FALSE);
			break;
		case 2:
// 			Host List
			bounceEdit->setEnabled(FALSE);
			break;
		case 3:
// 			FTP Bounce Attack
			bounceEdit->setEnabled(TRUE);
			break;
		case 4:
// 			Idle Scan
			bounceEdit->setEnabled(TRUE);
			break;
		case 5:
// 			SYN Stealth Scan
			bounceEdit->setEnabled(FALSE);
			break;
		case 6:
// 			ACK Stealth Scan
			bounceEdit->setEnabled(FALSE);
			break;
		case 7:
// 			FIN|ACK Stealth Scan
			bounceEdit->setEnabled(FALSE);
			break;
		case 8:
// 			FIN Stealth Scan
			bounceEdit->setEnabled(FALSE);
			break;
		case 9:
// 			NULL Stealth Scan
			bounceEdit->setEnabled(FALSE);
			break;
		case 10:
// 			XMAS Tree Stealth Scan
			bounceEdit->setEnabled(FALSE);
			break;
		case 11:
// 			TCP Window Scan
			bounceEdit->setEnabled(FALSE);
			break;
		case 12:
// 			UDP Ports Scan
			bounceEdit->setEnabled(FALSE);
			break;
		case 13:
// 			IP Protocol Scan
			bounceEdit->setEnabled(FALSE);
			break;
		default:
			bounceEdit->setEnabled(FALSE);
			break;

	}
}

void nmapClass::rootMode(int uid)
{

	if( !uid ) // if root
	{
		comboScan->addItem( QApplication::translate("nmapClass", "SYN Stealth Scan", 0, QApplication::UnicodeUTF8));
		comboScan->addItem( QApplication::translate("nmapClass", "ACK Stealth Scan", 0, QApplication::UnicodeUTF8));
		comboScan->addItem( QApplication::translate("nmapClass", "FIN|ACK Stealth Scan", 0, QApplication::UnicodeUTF8));
		comboScan->addItem( QApplication::translate("nmapClass", "FIN Stealth Scan", 0, QApplication::UnicodeUTF8));
		comboScan->addItem( QApplication::translate("nmapClass", "NULL Stealth Scan", 0, QApplication::UnicodeUTF8));
		comboScan->addItem( QApplication::translate("nmapClass", "XMAS Tree Stealth Scan", 0, QApplication::UnicodeUTF8));
		comboScan->addItem( QApplication::translate("nmapClass", "TCP Window Scan", 0, QApplication::UnicodeUTF8));
		comboScan->addItem( QApplication::translate("nmapClass", "UDP Ports Scan", 0, QApplication::UnicodeUTF8));
		comboScan->addItem( QApplication::translate("nmapClass", "IP Protocol Scan", 0, QApplication::UnicodeUTF8));

		comboScan->setCurrentIndex(5);
		//checkOS->setChecked(TRUE);

	} else {
		checkIcmpEcho->setVisible(FALSE);
		checkIcmpTimestamp->setVisible(FALSE);
 		checkIcmpNetmask->setVisible(FALSE);
		checkOS->setVisible(FALSE);

		// discover Udp Ping
 		checkUdpPing->setVisible(FALSE);
		lineUdpPing->setVisible(FALSE);
		label_7->setVisible(FALSE);

		// Misc Option
 		checkFrag->setVisible(FALSE);
		checkDecoy->setVisible(FALSE);
		lineDecoy->setVisible(FALSE);
		checkSourcePort->setVisible(FALSE);
		lineSourcePort->setVisible(FALSE);

	}

}

void nmapClass::update_inputcheck() // control the input object update
{
	if(checkInputFile->isChecked())
	{
		lineInputFile->setEnabled(TRUE);
		buttonBrowser->setEnabled(TRUE);
		lineInputFile->clear();
		hostEdit->clear();
	} else {
		lineInputFile->setEnabled(FALSE);
		buttonBrowser->setEnabled(FALSE);
		lineInputFile->clear();
		hostEdit->setText("127.0.0.1");
	}
}

void nmapClass::update_discover()
{
	if(checkTcpPing->isChecked())
	{
		lineTcpPing->setEnabled(TRUE);
		lineTcpPing->clear();
	} else {
		lineTcpPing->setEnabled(FALSE);
		lineTcpPing->clear();
	}

	if(checkTcpSyn->isChecked())
	{
		lineSynPing->setEnabled(TRUE);
		lineSynPing->clear();
	} else {
		lineSynPing->setEnabled(FALSE);
		lineSynPing->clear();
	}

	if(checkUdpPing->isChecked())
	{
		lineUdpPing->setEnabled(TRUE);
		lineUdpPing->clear();
	} else {
		lineUdpPing->setEnabled(FALSE);
		lineUdpPing->clear();
	}


}

void nmapClass::update_timing()
{
	if(TcheckIpv4ttl->isChecked())
		spinBoxIpv4ttl->setEnabled(TRUE);
	else
		spinBoxIpv4ttl->setEnabled(FALSE);

	if(TcheckMinPar->isChecked())
		TspinBoxMinP->setEnabled(TRUE);
	else
		TspinBoxMinP->setEnabled(FALSE);

	if(TcheckMaxPar->isChecked())
		spinBoxMaxPar->setEnabled(TRUE);
	else
		spinBoxMaxPar->setEnabled(FALSE);

	if(TcheckInitRtt->isChecked())
		spinBoxInitRtt->setEnabled(TRUE);
	else
		spinBoxInitRtt->setEnabled(FALSE);

	if(TcheckMinRtt->isChecked())
		spinBoxMinRtt->setEnabled(TRUE);
	else
		spinBoxMinRtt->setEnabled(FALSE);

	if(TcheckMaxRtt->isChecked())
		spinBoxMaxRtt->setEnabled(TRUE);
	else
		spinBoxMaxRtt->setEnabled(FALSE);

	if(TcheckHostTime->isChecked())
		spinBoxHostTime->setEnabled(TRUE);
	else
		spinBoxHostTime->setEnabled(FALSE);

	if(TcheckScanDelay->isChecked())
		spinBoxScanDelay->setEnabled(TRUE);
	else
		spinBoxScanDelay->setEnabled(FALSE);
}

void nmapClass::update_options()
{
	if(checkBoxDevice->isChecked())
		OlineDevice->setEnabled(TRUE);
	else {
		OlineDevice->setEnabled(FALSE);
		OlineDevice->clear();
	}

	if(checkDecoy->isChecked())
		lineDecoy->setEnabled(TRUE);
	else {
		lineDecoy->setEnabled(FALSE);
		lineDecoy->clear();
	}

	if(checkSpoof->isChecked()) {
		lineEditSpoof->setEnabled(TRUE);
		comboScan->setCurrentIndex(0);
		notpingBox->setChecked(TRUE);
		checkBoxDevice->setChecked(TRUE);
	}
	else {
		lineEditSpoof->setEnabled(FALSE);
		lineEditSpoof->clear();
		checkBoxDevice->setCheckState(Qt::Unchecked);
		notpingBox->setChecked(FALSE);

	}

	if(checkSourcePort->isChecked()) {
		lineSourcePort->setEnabled(TRUE);
		comboScan->setCurrentIndex(5);
	}
	else {
		lineSourcePort->setEnabled(FALSE);
		lineSourcePort->clear();

	}
}

void nmapClass::update_comboVerbosity() {

	if(comboVerbosity->currentIndex() == 4) {
		QMessageBox::warning(this, "NmapSI4",tr("Warning: Operation very expansive.\n"),tr("Close"));
	}
}

void nmapClass::widget_clear() {
	listWscan->clear();
	listScanError->clear();
	treeWinfo->clear();
	buttonClearHistory->setEnabled(FALSE);
}

