/***************************************************************************
 *   Copyright (C) 2007 by Francesco Cecconi                               *
 *   francesco.cecconi@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mainwin.h"

nmapClass::nmapClass()
{
	int uid = 0;

#ifndef Q_WS_WIN
	uid = getuid();
#endif

	QFont serifFont("Sans", 9);
	QApplication::setFont (serifFont);
//   	QApplication::setStyle(new QPlastiqueStyle); // only for my tests ;)

	setupUi(this);
	PFile = NULL; // file pointer init
	proc = 0; // set process variable to 0 default value

 	this->setNmapsiSlot();

	// Init function
 	this->rootMode(uid); // send uid value
 	this->checkProfile();
}

void nmapClass::scan()
{
	if(checkLog)
		this->fileSession();

	if(hostEdit->text().isEmpty() && lineInputFile->text().isEmpty()) {
		QMessageBox::warning(this, "NmapSI4",tr("No Host Target\n"),tr("Close"));
		return;
	}

	QStringList parametri; //parameters list declaration
	QString hostname = hostEdit->text();
	QString *title = new QString;
	*title = "NmapSI4 ";

	buttonScan->setEnabled(FALSE);
	action_Scan_menu->setEnabled(FALSE);
	hostEdit->setEnabled(FALSE);
	stopButton->setEnabled(TRUE);

	proc = new QProcess(); // Scan Process declaration
	connect(proc, SIGNAL(finished(int, QProcess::ExitStatus)), this, SLOT(readBuffer())); // nmapParser.cpp

	parametri = this->check_extensions(parametri,title); // extensions.cpp

	QString tmp_token;

	foreach(QString token, parametri) { // print scan options
		tmp_token.append(token);
		tmp_token.append(" "); // add simple space in option string
	}

	lineOptions->setText(tmp_token);

	parametri << hostname; // parameters list
	proc->start("nmap",parametri);

	if(proc->exitStatus() == 0)
	    qDebug() << "ProcExitCode::" << proc->exitCode();
	else {
	    qFatal( "Error with nmap process\n");
	    this->stop_scan();
	}

	progressScan->setValue(60);
	this->setWindowTitle((*title).replace("(55%)","(60%)"));

	delete title;

}

nmapClass::~nmapClass()
{
	delete proc;
 	delete PFile;
	delete root;
	delete item2;
	delete infoItem;
	delete infoItemObj;
	delete root2;
	delete item_root2;
	delete error;
	delete item_error;
}
