/***************************************************************************
 *   Copyright (C) 2007 by Francesco Cecconi                               *
 *   francesco.cecconi@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "profilemain.h"

mainProfile::mainProfile()
{
	QFont serifFont("Sans", 9);
	QApplication::setFont (serifFont);

	setupUi(this);

 	ptrMain = new nmapClass(); // pointer to nmapClass
 	ptrFile = new nmapsi4File(); // pointer to nmapsi4File

	connect( buttonSave, SIGNAL( clicked(bool) ), this, SLOT( quit()) );
	connect( checkNormalScan, SIGNAL( toggled(bool) ), this, SLOT(updateNormalCheck()));
	connect( checkQuickScan, SIGNAL( toggled(bool) ), this, SLOT(updateQuickCheck()));
	connect( checkFullVersion, SIGNAL( toggled(bool) ), this, SLOT(updateFullVersionCheck()));
	connect( checkQuickVersion, SIGNAL( toggled(bool) ), this, SLOT(updateQuickVersionCheck()));
  	connect( checkLogOn, SIGNAL(pressed()), this, SLOT(update_saveButton()));

	this->setProfile(); // set profile preference

	// create a read log config
	QString path = ptrFile->readToken("confPath");
	QString logCheck = ptrFile->readToken("logCheck");
	lineEditPath->setText(path);

	if(logCheck.contains("NO")) {
		checkLogOn->setChecked(FALSE);
		lineEditPath->setDisabled(TRUE);
		buttonLogB->setDisabled(TRUE);
	}
	else
		checkLogOn->setChecked(TRUE);

	// Create listview items
 	listViewOptions->setIconSize(QSize::QSize (52, 52));

	profileItem = new QListWidgetItem(listViewOptions);
	profileItem->setIcon(QIcon(QString::fromUtf8(":/images/images/preferences-system-windows.png")));
	profileItem->setText("Profiles");

	logItem = new QListWidgetItem(listViewOptions);
	logItem->setIcon(QIcon(QString::fromUtf8(":/images/images/utilities-log-viewer.png")));
	logItem->setText("Log");

 	profileItem->setSelected(TRUE);
	labelTitle->setText("<h3>Profiles Scan</h3>");

	connect( listViewOptions, SIGNAL(itemSelectionChanged()), this, SLOT(updateItem()));
  	connect( buttonLogB, SIGNAL( clicked() ), this, SLOT( log_browser() ) ); // Log file Browser slot

}

void mainProfile::saveProfile(QString ProfileType) {
	ptrFile->updateToken("configProfile", ProfileType); // update type of profile
}

QString mainProfile::readProfile() {
	QString tmpProfile = ptrFile->readToken("configProfile");
 	return tmpProfile;
}

void mainProfile::setScan() {
      ptrFile->updateToken("configProfile", ScanActive);
      ptrFile->updateToken("confPath", lineEditPath->text());

      if(checkLogOn->isChecked()) // update checklog from configuration file
		ptrFile->updateToken("logCheck", "YES");
      else
		ptrFile->updateToken("logCheck", "NO");
}


void mainProfile::updateItem() {
	QString itemText = listViewOptions->currentItem()->text();

	if(itemText.contains("Profiles")) {
	      labelTitle->setText("<h3>Profiles Scan</h3>");
	      stackPref->setCurrentIndex(0);
	}

	if(itemText.contains("Log")) {
	      labelTitle->setText("<h3>Logs Options</h3>");
	      stackPref->setCurrentIndex(1);
	}
}

void mainProfile::log_browser() { // call browser for input file
	ptrMain->show_log_browser(lineEditPath);
}

void mainProfile::setProfile() {

	int uid = 0;

#ifndef Q_WS_WIN
	uid = getuid();
#endif

	QString tmpProfile = this->readProfile();

	if(tmpProfile.contains("normal")) {
		checkNormalScan->setChecked(TRUE);
		ScanActive = "normal";
	}

	if(tmpProfile.contains("quick")) {
		checkQuickScan->setChecked(TRUE);
		ScanActive = "quick";
	}


	if(tmpProfile.contains("fullversion") && !uid) {
		checkFullVersion->setChecked(TRUE);
		ScanActive = "fullversion";
	} else if(uid)
			checkFullVersion->setEnabled(FALSE);

	if(tmpProfile.contains( "quickversion") && !uid) {
		checkQuickVersion->setEnabled(TRUE);
		ScanActive = "quickversion";
	} else if(uid)
			checkQuickVersion->setEnabled(FALSE);

}

void mainProfile::quit() {
	this->setScan();
	emit accept();
}

mainProfile::~mainProfile() {
	delete profileItem;
	delete logItem;
  	delete ptrFile;
	delete ptrMain;
}
