#
# Copyright 2007 Fedora Unity
#
# Jonathan Steffan <jon a fedoraunity.org>
# Jeroen van Meeuwen <kanarip a fedoraunity.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 only
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from ConfigParser import SafeConfigParser

from rhpl.translate import _, N_, getDefaultLangs
from rhpl import translate

class RevisorCLI():
    def __init__(self, base, log):
        self.base = base
        self.cfg = self.base.cfg
        self.log = log

    def run(self):
        self.log.info(_("Running..."))
        self.load_kickstart()
        self.cfg.model_options_reload_from_config()
        # Let's check for the existance of the directories we are going to work with:
        # Since there may be mounts in there, if it fails we *need* to cancel
        if not self.cfg.check_working_directory():
            sys.exit(1)

        # Let's check for the existance of the directories in which our products go:
        self.cfg.check_destination_directory()


        pbar = self.base.progress_bar(_("Setting up yum"), callback=True)
        self.base.setup_yum(pbar)
        self.base.pkglist_from_ksdata()
        self.base.populate_stats()
        self.base.lift_off()

    def load_kickstart(self):
        self.cfg.ksparser.readKickstart(self.cfg.kickstart_file)

