#
# Copyright 2007 Fedora Unity
#
# Jonathan Steffan <jon a fedoraunity.org>
# Jeroen van Meeuwen <kanarip a fedoraunity.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 only
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# Import python classes
import sys
import urllib2
import time
import os
import urlgrabber, urlgrabber.progress
from ConfigParser import SafeConfigParser
import string
import subprocess
import math
import shutil

# Import GTK classes
import gtk
import gtk.glade
import gobject
import gtk.gdk as gdk

import pykickstart.constants

# Import revisor classes
from revisor import build_media
from revisor import build_type
from revisor import finished_screen
from revisor import load_kickstart
from revisor import lm_auth
from revisor import lm_basic
from revisor import lm_bootloader
from revisor import lm_display
from revisor import lm_network
from revisor import lm_security
from revisor import lm_usercustomize
from revisor import package_selection
from revisor import repository_configuration
from revisor import revisor_configuration
from revisor import select_media
from revisor import welcome_screen
from revisor import ready_screen

# External tools
from revisor import lm_optical
from revisor import pungi

# Import revisor constants and errors
from revisor.constants import *
from revisor.errors import *

# Import yum.Errors for reporting errors
import yum.Errors

## Try and disable gtk threading
#try:
#    from gtk import _disable_gdk_threading
#    _disable_gdk_threading()
#except ImportError:
#    pass

## Import pirut's progress and details dialogs
#from pirut import Progress
#from pirut import DetailsDialog
## Alias those dialogs
#RevisorProgress = Progress.PirutProgress
#RevisorProgressCallback = Progress.PirutProgressCallback
#RevisorDetailsDialog = DetailsDialog.PirutDetailsDialog

# Translation
from rhpl.translate import _, N_, getDefaultLangs
import rhpl.translate as translate
translate.textdomain(domain)
gtk.glade.bindtextdomain(domain)

# Try and disable gtk threading
try:
    from gtk import _disable_gdk_threading
    _disable_gdk_threading()
except ImportError:
    pass

# Master GTK Interface update routine
def _runGtkMain(*args):
    while gtk.events_pending():
        gtk.main_iteration()

class RevisorGUI:
    """Master GUI Class for Revisor. This baby has legs, arms and a fully functional brain"""
    def __init__(self, base, log):
        """Initialize the RevisorGUI class instance and create a ConfigStore object"""
        self.base = base
        self.cfg = self.base.cfg
        self.log = log

    def run(self):
        self.build_main_window()
        self.displayWelcomeScreen()
        self.main_window.show()
        _runGtkMain()
        gtk.main()

    def build_main_window(self):
        base_screen_xml = gtk.glade.XML(GLADE_FILES + "base_screen.glade", domain=domain)
        self.base_screen_xml = base_screen_xml
        self.main_window = base_screen_xml.get_widget("main_window")
        self.main_vbox = base_screen_xml.get_widget("main_vbox")
        self.main_window.connect("destroy", self.destroy)

    def connect_button_signals(self, frame):
        sigs = { "on_button_back_clicked": self.button_back_clicked,
                 "on_button_forward_clicked": self.button_forward_clicked,
                 "on_button_cancel_clicked": self.button_cancel_clicked,
                 "on_button_information_clicked": self.button_information_clicked }
        self.base_buttons_xml.signal_autoconnect(sigs)

    def add_buttons(self):
        base_buttons_xml = gtk.glade.XML(GLADE_FILES + "base_buttons.glade", domain=domain)
        self.base_buttons_xml = base_buttons_xml
        self.button_hbox = base_buttons_xml.get_widget("button_hbox")

        self.button_vbox = self.frame_xml.get_widget("button_vbox")
        self.button_vbox.add(self.button_hbox)
        base_statusbar_xml = gtk.glade.XML(GLADE_FILES + "base_statusbar.glade", domain=domain)
        self.base_statusbar_xml = base_statusbar_xml
        self.statusbar = base_statusbar_xml.get_widget("statusbar")
        self.button_vbox.pack_end(self.statusbar,expand=False,fill=False)

    def button_back_clicked(self, button):
        pass

    def button_forward_clicked(self, button):
        pass

    def button_information_clicked(self, button, keyword):
        self.base.show_help(keyword)

    def button_cancel_clicked(self, button):
        # Destroy ConfigStore
        self.cfg = ""
        gtk.main_quit()
        sys.exit(1)

    def destroy(self, args):
        # Destroy ConfigStore
        self.cfg = ""
        gtk.main_quit()

    def load_frame(self, frame):
        try:
            self.outer_frame.hide()
            self.outer_frame.destroy()
        except:
            pass

        self.frame_xml = gtk.glade.XML(os.path.join(GLADE_FILES, frame), domain=domain)
        self.outer_frame = self.frame_xml.get_widget("outer_frame")
        self.main_vbox.add(self.outer_frame)


    def displayWelcomeScreen(self):
        self.load_frame("welcome_screen.glade")
        self.WelcomeScreen = welcome_screen.WelcomeScreen(self)

    def displaySelectMediaAdvanced(self):
        self.load_frame("select_media_advanced.glade")
        self.SelectMediaTypes = select_media.SelectMediaAdvanced(self)

    def displaySelectMedia(self):
        self.load_frame("select_media.glade")
        self.SelectMedia = select_media.SelectMedia(self)

    def displaySelectMediaInstallation(self):
        self.load_frame("select_media_installation.glade")
        self.SelectMedia = select_media.SelectMediaInstallation(self)

    def displaySelectMediaLive(self):
        self.load_frame("select_media_live.glade")
        self.SelectMedia = select_media.SelectMediaLive(self)

    def displaySelectMediaVirtualization(self):
       self.load_frame("select_media_virtualization.glade")
       self.SelectMedia = select_media.SelectMediaVirtualization(self)

    def displaySelectMediaUtility(self):
        self.load_frame("select_media_utility.glade")
        self.SelectMedia = select_media.SelectMediaUtility(self)

    def displayBuildType(self):
        self.load_frame("build_type.glade")
        self.BuildType = build_type.BuildType(self)

    def displayRevisorConfiguration(self):
        self.load_frame("revisor_configuration.glade")
        self.RevisorConf = revisor_configuration.RevisorConfiguration(self)

    def displayPackageSelection(self):
        self.load_frame("package_selection.glade")
        self.PackageSelection = package_selection.PackageSelection(self)

    def displayLoadKickstart(self):
        self.load_frame("load_kickstart.glade")
        self.loadKickstart = load_kickstart.LoadKickstart(self)

    def displayLMBasic(self):
        self.load_frame("lm_basic.glade")
        self.LMConfBasic = lm_basic.LMBasic(self)

    def displayLMBootloader(self):
        self.load_frame("lm_bootloader.glade")
        self.LMConfBootloader = lm_bootloader.LMBootloader(self)

    def displayLMNetwork(self):
        self.load_frame("lm_network.glade")
        self.LMConfNetwork = lm_network.LMNetwork(self)

    def displayLMAuth(self):
        self.load_frame("lm_auth.glade")
        self.LMAuth = lm_auth.LMAuth(self)

    def displayLMSecurity(self):
        self.load_frame("lm_security.glade")
        self.LMSecurity = lm_security.LMSecurity(self)

    def displayLMDisplay(self):
        self.load_frame("lm_display.glade")
        self.LMDisplay = lm_display.LMDisplay(self)

    def displayLMUserCustomize(self):
        self.load_frame("lm_usercustomize.glade")
        self.LMUserCustomize = lm_usercustomize.LMUserCustomize(self)

    def displayReadyScreen(self):
        self.load_frame("ready_screen.glade")
        self.ReadyScreen = ready_screen.ReadyScreen(self)

    def displayBuildMedia(self):
        self.load_frame("build_media.glade")
        self.BuildMedia = build_media.BuildMedia(self)
        self.BuildMedia.start()

    def displayFinished(self):
        self.load_frame("finished_screen.glade")
        self.FinishedScreen = finished_screen.FinishedScreen(self)

    def downloadErrorDialog(mainwin, secondary, details = None):
        d = RevisorDetailsDialog(mainwin, gtk.MESSAGE_ERROR,
                               [('gtk-ok', gtk.RESPONSE_OK)],
                               _("Error downloading packages"),
                               secondary)
        if details:
            d.set_details("%s" %(details,))
        d.run()
        d.destroy()
        raise RevisorDownloadError

    def depDetails(self, mainwin):
        self.cfg.yumobj.tsInfo.makelists()
        if (len(self.cfg.yumobj.tsInfo.depinstalled) > 0 or
            len(self.cfg.yumobj.tsInfo.depupdated) > 0 or
            len(self.cfg.yumobj.tsInfo.depremoved) > 0):
            d = RevisorDetailsDialog(mainwin, gtk.MESSAGE_INFO,
                                 [('gtk-cancel', gtk.RESPONSE_CANCEL),
                                  (_("Continue"), gtk.RESPONSE_OK, 'gtk-ok')],
                                 _("Dependencies added"),
                                 _("Updating these packages requires "
                                   "additional package changes for proper "
                                   "operation."))

            b = gtk.TextBuffer()
            tag = b.create_tag('bold')
            tag.set_property('weight', pango.WEIGHT_BOLD)
            tag = b.create_tag('indented')
            tag.set_property('left-margin', 10)
            types=[(self.cfg.yumobj.tsInfo.depinstalled,_("Adding for dependencies:\n")),
                   (self.cfg.yumobj.tsInfo.depremoved, _("Removing for dependencies:\n")),
                   (self.cfg.yumobj.tsInfo.depupdated, _("Updating for dependencies:\n"))]
            for (lst, strng) in types:
                if len(lst) > 0:
                    i = b.get_end_iter()
                    b.insert_with_tags_by_name(i, strng, "bold")
                    for txmbr in lst:
                        i = b.get_end_iter()
                        (n,a,e,v,r) = txmbr.pkgtup
                        b.insert_with_tags_by_name(i, "%s-%s-%s\n" % (n,v,r),
                                                   "indented")
            d.set_details(buffer = b)
            timeout = 20
            if len(self.cfg.yumobj.tsInfo.depremoved) > 0:
                d.expand_details()
                timeout = None
            rc = d.run(timeout=timeout)
            d.destroy()
# FIXME!
#            if rc != gtk.RESPONSE_OK:
#                self._undoDepInstalls()
#                raise PirutError
