#
# Copyright 2007 Fedora Unity
#
# Jonathan Steffan <jon a fedoraunity.org>
# Jeroen van Meeuwen <kanarip a fedoraunity.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 only
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

import sys
import pykickstart
import pykickstart.constants
import gtk
import gtk.glade
import gobject
import gtk.gdk as gdk
import logging
import time

import yum
from yum.constants import *
from yum.packages import comparePoEVR
import yum.Errors

import revisor

from revisor.errors import *
from revisor.constants import *

# Translation
from rhpl.translate import _, N_, getDefaultLangs
import rhpl.translate as translate

# Master GTK Interface update routine
def _runGtkMain(*args):
    while gtk.events_pending():
        gtk.main_iteration()

class ReadyScreen:
    def __init__(self, gui):
        self.gui = gui
        self.base = gui.base
        self.log = gui.log
        self.cfg = gui.cfg
        self.frame_xml = gui.frame_xml

        self.number_packages = self.frame_xml.get_widget("number_packages")
        self.package_payload = self.frame_xml.get_widget("payload_size")
        self.package_installpayload = self.frame_xml.get_widget("installpayload_size")

        gui.add_buttons()

        self.connect_button_signals()

        self.pkgFilter = None
        self.sortedStore = None

        self.header_image = gui.base_screen_xml.get_widget("header_image")
        self.header_image.set_from_file(PIXMAPS_FILES + "header_packages.png")

        self.button_vbox = self.frame_xml.get_widget("button_vbox")

        self.gui.base_buttons_xml.get_widget("button_forward").set_sensitive(False)
        self.gui.base_buttons_xml.get_widget("button_back").set_sensitive(False)

        # Hey, we did not come past any depsolving... How do we know the statistics?
        if not self.cfg.kickstart_manifest and not self.cfg.kickstart_options_customize:
            # We should have selected packages by hand, and depsolved on "next"
            self.populate_stats()
        elif self.cfg.kickstart_manifest and self.cfg.kickstart_manifest_customize:
            # We should have selected packages by hand, and depsolved on "next"
            self.populate_stats()
        elif self.cfg.kickstart_manifest:
            # We haven't selected anything manually, but we do have a list of stuff we wanna add
            pbar = self.base.progress_bar(title = _("Loading Repository Information"), parent = self.gui, callback = True)
            if not self.base.setup_yum(pbar):
                # It's already doing a notice... We're gonna wanna return to revisor_configuration
                self.cfg.i_did_all_this = False
                self.cfg.yumobj = yum.YumBase()
                self.cfg.repos = {}
                pbar.destroy()
                self.gui.displayRevisorConfiguration()
            else:
                self.cfg.i_did_all_this = True

            msg_id = self.gui.statusbar.push(0,"Adding in packages from Kickstart Data, please wait")
            _runGtkMain()
            self.base.pkglist_from_ksdata()
            self.gui.statusbar.remove(0,msg_id)
            self.base.check_dependencies()
            self.populate_stats()
        elif self.cfg.kickstart_options_customize:
            # We should have selected packages by hand, and customized the media further... need to depsolve
            self.base.check_dependencies()
            self.populate_stats()

        self.gui.base_buttons_xml.get_widget("button_forward").set_sensitive(True)
        self.gui.base_buttons_xml.get_widget("button_back").set_sensitive(True)

    def connect_button_signals(self):
        sigs = { "on_button_back_clicked": self.button_back_clicked,
                 "on_button_forward_clicked": self.button_forward_clicked,
                 "on_button_cancel_clicked": self.gui.button_cancel_clicked }
        self.gui.base_buttons_xml.signal_autoconnect(sigs)

    def check_options(self):
        """Check the options specified"""
        # No options enabled yet
        return True

    def button_back_clicked(self, button):
        if self.cfg.kickstart_manifest:
           # Using kickstart file
           if not self.cfg.kickstart_manifest_customize and not self.cfg.kickstart_options_customize:
              # No customize, go back to kickstart config
              self.gui.displayLoadKickstart()
           elif self.cfg.kickstart_options_customize:
              # No package customization, but we are customizing kickstart data
              self.gui.displayLMUserCustomize()
           else:
              # Customizing package selection, go back to package selection
              self.gui.displayPackageSelection()
        elif self.cfg.kickstart_options_customize:
           # Not using kickstart manifest, but customizing options
           self.gui.displayLMUserCustomize()
        else:
           # Not using kickstart, go back to package selection
           self.gui.displayPackageSelection()

    def button_forward_clicked(self, button):
        if not self.check_options():
#            print "Failed Checking Options..."
            pass
        else:
#            print >> sys.stdout, "Here's a before: " + str(self.cfg.kshandler.packages.packageList)
            # Destroy self.cfg.kshandler.packages.packageList and
            # self.cfg.kshandler.packages.groupList
            self.cfg.kshandler.packages.packageList = []
            self.cfg.kshandler.packages.groupList = []
            self.cfg.yumobj.tsInfo.makelists()
            txmbrs = self.cfg.yumobj.tsInfo.installed + self.cfg.yumobj.tsInfo.depinstalled
            for txmbr in txmbrs:
                self.cfg.kshandler.packages.packageList.append(txmbr.name)
#                print >> sys.stdout, "Packages: " + str(txmbr.name)

#            print >> sys.stdout, "Here's an after: " + str(self.cfg.kshandler.packages.packageList)
#            self.store_options(self.gui.cfg)
            if self.cfg.advanced_configuration:
                if self.cfg.media_installation and not self.cfg.media_live and not self.cfg.media_virtualization and not self.cfg.media_utility:
                    self.gui.displayBuildMedia()
                else:
                    self.gui.displayLMBasic()
            else:
                if self.cfg.use_kickstart_file:
                    self.gui.displayBuildMedia()
                else:
                    self.gui.displayLMBasic()

    def populate_stats(self):
        """ Populate the stats displayed on the ready screen, based on our yum transaction. """
        self.base.populate_stats()

        self.number_packages.set_text(str(self.cfg.payload_packages))
        self.package_payload.set_text(str(self.cfg.payload_livemedia))
        self.package_installpayload.set_text(str(self.cfg.payload_installmedia))
