//////////////////////////////////////////////////////////////////////////////
// Name:        Elements_SetAttribute.cpp
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by genSetAttribute.py
//////////////////////////////////////////////////////////////////////////////

#include "String.h"
#include "SVGAElement.h"
#include "SVGElement.h"
#include "SVGURIReference.h"
#include "SVGTests.h"
#include "SVGLangSpace.h"
#include "SVGExternalResourcesRequired.h"
#include "SVGStylable.h"
#include "SVGTransformable.h"
#include "SVGAltGlyphDefElement.h"
#include "SVGAltGlyphElement.h"
#include "SVGTextPositioningElement.h"
#include "SVGTextContentElement.h"
#include "SVGAltGlyphItemElement.h"
#include "SVGAnimationElement.h"
#include "SVGAnimateColorElement.h"
#include "SVGAnimateElement.h"
#include "SVGAnimateMotionElement.h"
#include "SVGAnimateTransformElement.h"
#include "SVGAnimatedPathData.h"
#include "SVGAnimatedPoints.h"
#include "SVGCircleElement.h"
#include "SVGClipPathElement.h"
#include "SVGColorProfileElement.h"
#include "SVGComponentTransferFunctionElement.h"
#include "SVGCursorElement.h"
#include "SVGDefinitionSrcElement.h"
#include "SVGDefsElement.h"
#include "SVGDescElement.h"
#include "SVGEllipseElement.h"
#include "SVGFEBlendElement.h"
#include "SVGFilterPrimitiveStandardAttributes.h"
#include "SVGFEColorMatrixElement.h"
#include "SVGFEComponentTransferElement.h"
#include "SVGFECompositeElement.h"
#include "SVGFEConvolveMatrixElement.h"
#include "SVGFEDiffuseLightingElement.h"
#include "SVGFEDisplacementMapElement.h"
#include "SVGFEDistantLightElement.h"
#include "SVGFEFloodElement.h"
#include "SVGFEFuncAElement.h"
#include "SVGFEFuncBElement.h"
#include "SVGFEFuncGElement.h"
#include "SVGFEFuncRElement.h"
#include "SVGFEGaussianBlurElement.h"
#include "SVGFEImageElement.h"
#include "SVGFEMergeElement.h"
#include "SVGFEMergeNodeElement.h"
#include "SVGFEMorphologyElement.h"
#include "SVGFEOffsetElement.h"
#include "SVGFEPointLightElement.h"
#include "SVGFESpecularLightingElement.h"
#include "SVGFESpotLightElement.h"
#include "SVGFETileElement.h"
#include "SVGFETurbulenceElement.h"
#include "SVGFilterElement.h"
#include "SVGFitToViewBox.h"
#include "SVGFontElement.h"
#include "SVGFontFaceElement.h"
#include "SVGFontFaceFormatElement.h"
#include "SVGFontFaceNameElement.h"
#include "SVGFontFaceSrcElement.h"
#include "SVGFontFaceUriElement.h"
#include "SVGForeignObjectElement.h"
#include "SVGGElement.h"
#include "SVGGlyphElement.h"
#include "SVGGlyphRefElement.h"
#include "SVGGradientElement.h"
#include "SVGHKernElement.h"
#include "SVGImageElement.h"
#include "SVGLineElement.h"
#include "SVGLinearGradientElement.h"
#include "SVGMPathElement.h"
#include "SVGMarkerElement.h"
#include "SVGMaskElement.h"
#include "SVGMetadataElement.h"
#include "SVGMissingGlyphElement.h"
#include "SVGPathElement.h"
#include "SVGPatternElement.h"
#include "SVGPolygonElement.h"
#include "SVGPolylineElement.h"
#include "SVGRadialGradientElement.h"
#include "SVGRectElement.h"
#include "SVGSVGElement.h"
#include "SVGZoomAndPan.h"
#include "SVGScriptElement.h"
#include "SVGSetElement.h"
#include "SVGStopElement.h"
#include "SVGStyleElement.h"
#include "SVGSwitchElement.h"
#include "SVGSymbolElement.h"
#include "SVGTRefElement.h"
#include "SVGTSpanElement.h"
#include "SVGTextElement.h"
#include "SVGTextPathElement.h"
#include "SVGTitleElement.h"
#include "SVGUseElement.h"
#include "SVGVKernElement.h"
#include "SVGVideoElement.h"
#include "SVGViewElement.h"
#include "SVGViewSpec.h"

// wxSVGAnimateMotionElement
bool wxSVGAnimateMotionElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAnimateMotionElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFontFaceUriElement
bool wxSVGFontFaceUriElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceUriElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFontFaceElement
bool wxSVGFontFaceElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEFuncBElement
bool wxSVGFEFuncBElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGComponentTransferFunctionElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFuncBElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEFuncAElement
bool wxSVGFEFuncAElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGComponentTransferFunctionElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFuncAElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEFuncRElement
bool wxSVGFEFuncRElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGComponentTransferFunctionElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFuncRElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGForeignObjectElement
bool wxSVGForeignObjectElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGForeignObjectElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEMorphologyElement
bool wxSVGFEMorphologyElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("operator"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_operator.SetBaseVal((char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEMorphologyElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGMarkerElement
bool wxSVGMarkerElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("refX"))
    m_refX.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("refY"))
    m_refY.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("markerUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_markerUnits.SetBaseVal((char) value);
  }
  else if (attrName == wxT("markerWidth"))
    m_markerWidth.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("markerHeight"))
    m_markerHeight.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMarkerElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFETileElement
bool wxSVGFETileElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFETileElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGPathElement
bool wxSVGPathElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("pathLength"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_pathLength.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else if (wxSVGAnimatedPathData::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGPathElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGTSpanElement
bool wxSVGTSpanElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGTextPositioningElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTSpanElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEColorMatrixElement
bool wxSVGFEColorMatrixElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("type"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_type.SetBaseVal((char) value);
  }
  else if (attrName == wxT("values"))
    m_values.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEColorMatrixElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFontFaceFormatElement
bool wxSVGFontFaceFormatElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceFormatElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEOffsetElement
bool wxSVGFEOffsetElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("dx"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dx.SetBaseVal(value);
  }
  else if (attrName == wxT("dy"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dy.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEOffsetElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGSymbolElement
bool wxSVGSymbolElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGSymbolElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEMergeNodeElement
bool wxSVGFEMergeNodeElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEMergeNodeElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGTransformable
bool wxSVGTransformable::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("transform"))
    m_transform.GetBaseVal().SetValueAsString(attrValue);
  else 
      return false;

  return true;
}      

// wxSVGStyleElement
bool wxSVGStyleElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("xml:space"))
	m_xmlspace = attrValue;
  else if (attrName == wxT("type"))
	m_type = attrValue;
  else if (attrName == wxT("media"))
	m_media = attrValue;
  else if (attrName == wxT("title"))
	m_title = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGStyleElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGPolygonElement
bool wxSVGPolygonElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else if (wxSVGAnimatedPoints::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGPolygonElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGCursorElement
bool wxSVGCursorElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGCursorElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFECompositeElement
bool wxSVGFECompositeElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("in2"))
	m_in2.GetBaseVal() = attrValue;
  else if (attrName == wxT("operator"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_operator.SetBaseVal((char) value);
  }
  else if (attrName == wxT("k1"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_k1.SetBaseVal(value);
  }
  else if (attrName == wxT("k2"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_k2.SetBaseVal(value);
  }
  else if (attrName == wxT("k3"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_k3.SetBaseVal(value);
  }
  else if (attrName == wxT("k4"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_k4.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFECompositeElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGGradientElement
bool wxSVGGradientElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("gradientUnits"))
  {
    wxSVG_UNIT_TYPE value = wxSVG_UNIT_TYPE_UNKNOWN;
    if (attrValue.Lower() == wxT("userspaceonuse"))
        value = wxSVG_UNIT_TYPE_USERSPACEONUSE;
    else if (attrValue.Lower() == wxT("objectboundingbox"))
        value = wxSVG_UNIT_TYPE_OBJECTBOUNDINGBOX;
    m_gradientUnits.SetBaseVal((char) value);
  }
  else if (attrName == wxT("gradientTransform"))
    m_gradientTransform.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("spreadMethod"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_spreadMethod.SetBaseVal((char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}      

// wxSVGLinearGradientElement
bool wxSVGLinearGradientElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x1"))
    m_x1.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y1"))
    m_y1.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("x2"))
    m_x2.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y2"))
    m_y2.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGGradientElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGLinearGradientElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGTextElement
bool wxSVGTextElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGTextPositioningElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTextElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEPointLightElement
bool wxSVGFEPointLightElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_x.SetBaseVal(value);
  }
  else if (attrName == wxT("y"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_y.SetBaseVal(value);
  }
  else if (attrName == wxT("z"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_z.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEPointLightElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGHKernElement
bool wxSVGHKernElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGHKernElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGStopElement
bool wxSVGStopElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("offset"))
  {
    double value;
    if (attrValue.Last() == wxT('%') && attrValue.Left(attrValue.Length()-1).ToDouble(&value))
    {
      value = value/100;
      m_offset.SetBaseVal(value);
    }
    else if (attrValue.ToDouble(&value))
      m_offset.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGStopElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEDisplacementMapElement
bool wxSVGFEDisplacementMapElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("in2"))
	m_in2.GetBaseVal() = attrValue;
  else if (attrName == wxT("scale"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_scale.SetBaseVal(value);
  }
  else if (attrName == wxT("xChannelSelector"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_xChannelSelector.SetBaseVal((char) value);
  }
  else if (attrName == wxT("yChannelSelector"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_yChannelSelector.SetBaseVal((char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEDisplacementMapElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGLineElement
bool wxSVGLineElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x1"))
    m_x1.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y1"))
    m_y1.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("x2"))
    m_x2.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y2"))
    m_y2.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGLineElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFontFaceNameElement
bool wxSVGFontFaceNameElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceNameElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGPatternElement
bool wxSVGPatternElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("patternUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_patternUnits.SetBaseVal((char) value);
  }
  else if (attrName == wxT("patternContentUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_patternContentUnits.SetBaseVal((char) value);
  }
  else if (attrName == wxT("patternTransform"))
    m_patternTransform.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGPatternElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGExternalResourcesRequired
bool wxSVGExternalResourcesRequired::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("externalResourcesRequired"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_externalResourcesRequired.SetBaseVal((bool) value);
  }
  else 
      return false;

  return true;
}      

// wxSVGScriptElement
bool wxSVGScriptElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("type"))
	m_type = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGScriptElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGStylable
bool wxSVGStylable::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("class"))
	m_className.GetBaseVal() = attrValue;
  else if (attrName == wxT("style"))
    m_style.SetCSSText(attrValue);
  else if (SetCustomAttribute(attrName, attrValue));
  else
      return false;

  return true;
}      

// wxSVGFitToViewBox
bool wxSVGFitToViewBox::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("viewBox"))
    m_viewBox.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("preserveAspectRatio"))
    m_preserveAspectRatio.GetBaseVal().SetValueAsString(attrValue);
  else 
      return false;

  return true;
}      

// wxSVGTests
bool wxSVGTests::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("requiredFeatures"))
    m_requiredFeatures.SetValueAsString(attrValue);
  else if (attrName == wxT("requiredExtensions"))
    m_requiredExtensions.SetValueAsString(attrValue);
  else if (attrName == wxT("systemLanguage"))
    m_systemLanguage.SetValueAsString(attrValue);
  else 
      return false;

  return true;
}      

// wxSVGSVGElement
bool wxSVGSVGElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("contentScriptType"))
	m_contentScriptType = attrValue;
  else if (attrName == wxT("contentStyleType"))
	m_contentStyleType = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else if (wxSVGZoomAndPan::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGSVGElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGViewSpec
bool wxSVGViewSpec::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGZoomAndPan::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}      

// wxSVGVKernElement
bool wxSVGVKernElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGVKernElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGMetadataElement
bool wxSVGMetadataElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMetadataElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGAElement
bool wxSVGAElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("target"))
	m_target.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGAltGlyphElement
bool wxSVGAltGlyphElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("glyphRef"))
	m_glyphRef = attrValue;
  else if (attrName == wxT("format"))
	m_format = attrValue;
  else if (wxSVGTextPositioningElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAltGlyphElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGURIReference
bool wxSVGURIReference::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("xlink:href"))
	m_href.GetBaseVal() = attrValue;
  else 
      return false;

  return true;
}      

// wxSVGAnimateTransformElement
bool wxSVGAnimateTransformElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAnimateTransformElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEComponentTransferElement
bool wxSVGFEComponentTransferElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEComponentTransferElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEBlendElement
bool wxSVGFEBlendElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("in2"))
	m_in2.GetBaseVal() = attrValue;
  else if (attrName == wxT("mode"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_mode.SetBaseVal((char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEBlendElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEMergeElement
bool wxSVGFEMergeElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEMergeElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGTextPositioningElement
bool wxSVGTextPositioningElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("dx"))
    m_dx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("dy"))
    m_dy.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("rotate"))
    m_rotate.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGTextContentElement::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}      

// wxSVGEllipseElement
bool wxSVGEllipseElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("cx"))
    m_cx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("cy"))
    m_cy.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("rx"))
    m_rx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("ry"))
    m_ry.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGEllipseElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFilterElement
bool wxSVGFilterElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("filterUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_filterUnits.SetBaseVal((char) value);
  }
  else if (attrName == wxT("primitiveUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_primitiveUnits.SetBaseVal((char) value);
  }
  else if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFilterElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGClipPathElement
bool wxSVGClipPathElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("clipPathUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_clipPathUnits.SetBaseVal((char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGClipPathElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGSwitchElement
bool wxSVGSwitchElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGSwitchElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGMaskElement
bool wxSVGMaskElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("maskUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_maskUnits.SetBaseVal((char) value);
  }
  else if (attrName == wxT("maskContentUnits"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_maskContentUnits.SetBaseVal((char) value);
  }
  else if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMaskElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGViewElement
bool wxSVGViewElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("viewTarget"))
    m_viewTarget.SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGFitToViewBox::SetAttribute(attrName, attrValue));
  else if (wxSVGZoomAndPan::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGViewElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGDefinitionSrcElement
bool wxSVGDefinitionSrcElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGDefinitionSrcElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFilterPrimitiveStandardAttributes
bool wxSVGFilterPrimitiveStandardAttributes::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("result"))
	m_result.GetBaseVal() = attrValue;
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}      

// wxSVGFEDistantLightElement
bool wxSVGFEDistantLightElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("azimuth"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_azimuth.SetBaseVal(value);
  }
  else if (attrName == wxT("elevation"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_elevation.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEDistantLightElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEDiffuseLightingElement
bool wxSVGFEDiffuseLightingElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("surfaceScale"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_surfaceScale.SetBaseVal(value);
  }
  else if (attrName == wxT("diffuseConstant"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_diffuseConstant.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEDiffuseLightingElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGAnimatedPathData
bool wxSVGAnimatedPathData::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("d"))
    m_pathSegList.SetValueAsString(attrValue);
  else 
      return false;

  return true;
}      

// wxSVGFontFaceSrcElement
bool wxSVGFontFaceSrcElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontFaceSrcElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGZoomAndPan
bool wxSVGZoomAndPan::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("zoomAndPan"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_zoomAndPan = (wxSVG_ZOOMANDPAN) value;
  }
  else 
      return false;

  return true;
}      

// wxSVGDescElement
bool wxSVGDescElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGDescElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGSetElement
bool wxSVGSetElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGSetElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGAnimateElement
bool wxSVGAnimateElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAnimateElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGLangSpace
bool wxSVGLangSpace::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("xml:lang"))
	m_xmllang = attrValue;
  else if (attrName == wxT("xml:space"))
	m_xmlspace = attrValue;
  else 
      return false;

  return true;
}      

// wxSVGGlyphRefElement
bool wxSVGGlyphRefElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("glyphRef"))
	m_glyphRef = attrValue;
  else if (attrName == wxT("format"))
	m_format = attrValue;
  else if (attrName == wxT("x"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_x = value;
  }
  else if (attrName == wxT("y"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_y = value;
  }
  else if (attrName == wxT("dx"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dx = value;
  }
  else if (attrName == wxT("dy"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_dy = value;
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGGlyphRefElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFESpotLightElement
bool wxSVGFESpotLightElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_x.SetBaseVal(value);
  }
  else if (attrName == wxT("y"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_y.SetBaseVal(value);
  }
  else if (attrName == wxT("z"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_z.SetBaseVal(value);
  }
  else if (attrName == wxT("pointsAtX"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_pointsAtX.SetBaseVal(value);
  }
  else if (attrName == wxT("pointsAtY"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_pointsAtY.SetBaseVal(value);
  }
  else if (attrName == wxT("pointsAtZ"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_pointsAtZ.SetBaseVal(value);
  }
  else if (attrName == wxT("specularExponent"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_specularExponent.SetBaseVal(value);
  }
  else if (attrName == wxT("limitingConeAngle"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_limitingConeAngle.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFESpotLightElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGAnimationElement
bool wxSVGAnimationElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}      

// wxSVGAltGlyphDefElement
bool wxSVGAltGlyphDefElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAltGlyphDefElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFETurbulenceElement
bool wxSVGFETurbulenceElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("numOctaves"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_numOctaves.SetBaseVal((long int) value);
  }
  else if (attrName == wxT("seed"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_seed.SetBaseVal(value);
  }
  else if (attrName == wxT("stitchTiles"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_stitchTiles.SetBaseVal((char) value);
  }
  else if (attrName == wxT("type"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_type.SetBaseVal((char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFETurbulenceElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGComponentTransferFunctionElement
bool wxSVGComponentTransferFunctionElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("type"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_type.SetBaseVal((char) value);
  }
  else if (attrName == wxT("tableValues"))
    m_tableValues.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("slope"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_slope.SetBaseVal(value);
  }
  else if (attrName == wxT("intercept"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_intercept.SetBaseVal(value);
  }
  else if (attrName == wxT("amplitude"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_amplitude.SetBaseVal(value);
  }
  else if (attrName == wxT("exponent"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_exponent.SetBaseVal(value);
  }
  else if (attrName == wxT("offset"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_offset.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}      

// wxSVGMPathElement
bool wxSVGMPathElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMPathElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGDefsElement
bool wxSVGDefsElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGDefsElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGRectElement
bool wxSVGRectElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("rx"))
    m_rx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("ry"))
    m_ry.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGRectElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGPolylineElement
bool wxSVGPolylineElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else if (wxSVGAnimatedPoints::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGPolylineElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGColorProfileElement
bool wxSVGColorProfileElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("local"))
	m_local = attrValue;
  else if (attrName == wxT("name"))
	m_name = attrValue;
  else if (attrName == wxT("rendering-intent"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_renderingIntent = (wxRENDERING_INTENT) value;
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGColorProfileElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGAnimatedPoints
bool wxSVGAnimatedPoints::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("points"))
    m_points.SetValueAsString(attrValue);
  else 
      return false;

  return true;
}      

// wxSVGCircleElement
bool wxSVGCircleElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("cx"))
    m_cx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("cy"))
    m_cy.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("r"))
    m_r.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGCircleElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGTextContentElement
bool wxSVGTextContentElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("textLength"))
    m_textLength.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("lengthAdjust"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_lengthAdjust.SetBaseVal((char) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
      return false;

  return true;
}      

// wxSVGUseElement
bool wxSVGUseElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGUseElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGMissingGlyphElement
bool wxSVGMissingGlyphElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGMissingGlyphElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGImageElement
bool wxSVGImageElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("preserveAspectRatio"))
    m_preserveAspectRatio.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGImageElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEImageElement
bool wxSVGFEImageElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEImageElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGTextPathElement
bool wxSVGTextPathElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("startOffset"))
    m_startOffset.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("method"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_method.SetBaseVal((char) value);
  }
  else if (attrName == wxT("spacing"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_spacing.SetBaseVal((char) value);
  }
  else if (wxSVGTextContentElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTextPathElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEFloodElement
bool wxSVGFEFloodElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFloodElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFontElement
bool wxSVGFontElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFontElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGVideoElement
bool wxSVGVideoElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("x"))
    m_x.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("y"))
    m_y.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("width"))
    m_width.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("height"))
    m_height.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("preserveAspectRatio"))
    m_preserveAspectRatio.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGVideoElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGRadialGradientElement
bool wxSVGRadialGradientElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("cx"))
    m_cx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("cy"))
    m_cy.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("r"))
    m_r.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("fx"))
    m_fx.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("fy"))
    m_fy.GetBaseVal().SetValueAsString(attrValue);
  else if (wxSVGGradientElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGRadialGradientElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGElement
bool wxSVGElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("id"))
	m_id = attrValue;
  else 
      return false;

  return true;
}      

// wxSVGTitleElement
bool wxSVGTitleElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTitleElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEConvolveMatrixElement
bool wxSVGFEConvolveMatrixElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("kernelMatrix"))
    m_kernelMatrix.GetBaseVal().SetValueAsString(attrValue);
  else if (attrName == wxT("divisor"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_divisor.SetBaseVal(value);
  }
  else if (attrName == wxT("bias"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_bias.SetBaseVal(value);
  }
  else if (attrName == wxT("targetX"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_targetX.SetBaseVal((long int) value);
  }
  else if (attrName == wxT("targetY"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_targetY.SetBaseVal((long int) value);
  }
  else if (attrName == wxT("edgeMode"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_edgeMode.SetBaseVal((char) value);
  }
  else if (attrName == wxT("preserveAlpha"))
  {
    long value;
    if (attrValue.ToLong(&value))
      m_preserveAlpha.SetBaseVal((bool) value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEConvolveMatrixElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEGaussianBlurElement
bool wxSVGFEGaussianBlurElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEGaussianBlurElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGGlyphElement
bool wxSVGGlyphElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGGlyphElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGGElement
bool wxSVGGElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGTests::SetAttribute(attrName, attrValue));
  else if (wxSVGLangSpace::SetAttribute(attrName, attrValue));
  else if (wxSVGExternalResourcesRequired::SetAttribute(attrName, attrValue));
  else if (wxSVGStylable::SetAttribute(attrName, attrValue));
  else if (wxSVGTransformable::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGGElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGAnimateColorElement
bool wxSVGAnimateColorElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGAnimationElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAnimateColorElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFEFuncGElement
bool wxSVGFEFuncGElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGComponentTransferFunctionElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFEFuncGElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGAltGlyphItemElement
bool wxSVGAltGlyphItemElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGElement::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGAltGlyphItemElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGFESpecularLightingElement
bool wxSVGFESpecularLightingElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("in"))
	m_in1.GetBaseVal() = attrValue;
  else if (attrName == wxT("surfaceScale"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_surfaceScale.SetBaseVal(value);
  }
  else if (attrName == wxT("specularConstant"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_specularConstant.SetBaseVal(value);
  }
  else if (attrName == wxT("specularExponent"))
  {
    double value;
    if (attrValue.ToDouble(&value))
      m_specularExponent.SetBaseVal(value);
  }
  else if (wxSVGElement::SetAttribute(attrName, attrValue));
  else if (wxSVGFilterPrimitiveStandardAttributes::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGFESpecularLightingElement::") + attrName);
    return false;
  }

  return true;
}      

// wxSVGTRefElement
bool wxSVGTRefElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (wxSVGTextPositioningElement::SetAttribute(attrName, attrValue));
  else if (wxSVGURIReference::SetAttribute(attrName, attrValue));
  else 
  {
    //wxLogDebug(wxT("unknown attribute SVGTRefElement::") + attrName);
    return false;
  }

  return true;
}      

