/*
Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

*/

#include <QDebug>
#include <QFile>
#include <QFileInfo>

#include "audiofile.h"

AudioFile::AudioFile(const QString& filename)
{
    if (!QFile(filename).exists()) {
        qDebug() << "AudioFile::AudioFile --- " << filename << "does not exist.";
        return;
    }
    m_filename = filename;
    m_tagFileRef = TagLib::FileRef(filename.toAscii().data());
    m_tagFileTags = m_tagFileRef.tag();
    m_tagFileProperties = m_tagFileRef.audioProperties();
}

QString AudioFile::trackArtist()
{
    return TStringToQString(m_tagFileTags->artist());
}

QString AudioFile::trackTitle()
{
    return TStringToQString(m_tagFileTags->title());
}

QString AudioFile::trackLength()
{
    int secs = m_tagFileProperties->length();
    int mins = secs / 60;
    int rsecs = secs - (mins * 60);

    return QString::number(mins) + ":" + QString::number(rsecs);
}

int AudioFile::trackLengthInSecs()
{
    return m_tagFileProperties->length();
}

QString AudioFile::trackSize()
{
    return QString::number(QFileInfo(m_filename).size() / 1024 / 1024) + " MB";
}

QString AudioFile::trackType() 
{
    if (m_filename.right(4) == ".mp3") {
        return "MP3";
    } else if (m_filename.right(4) == ".wav") {
        return "WAV";      
    } else if (m_filename.right(4) == ".ogg") {
        return "OGG";
    } else if (m_filename.right(4) == ".wma") {
        return "WMA";
    } else if (m_filename.right(4) == ".m4a") {
        return "M4A";
    } else if (m_filename.right(4) == ".mp4") {
        return "MP4";
    }
    
    return QString();
}
