/*
Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

*/

#ifndef AUDIOFILE_H
#define AUDIOFILE_H

#include <QTime>

#include <taglib/fileref.h>
#include <taglib/tag.h>

class AudioFile : public QObject
{
    Q_OBJECT
    public:
        AudioFile(const QString& filename);

        QString trackArtist();
        QString trackTitle();
        QString trackLength();
        int trackLengthInSecs();
        QString trackSize();
        QString trackType();

    private:
        TagLib::FileRef m_tagFileRef;
        TagLib::Tag *m_tagFileTags;
        TagLib::AudioProperties *m_tagFileProperties;
        
        QString m_filename;
};

#endif // AUDIOFILE_H
