/*
Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
*/

#ifndef FORMATTHREAD_H
#define FORMATTHREAD_H

#include <QProcess>
#include <QTimer>
#include <QThread>

class FormatThread : public QThread
{
    Q_OBJECT

public:
    FormatThread(QObject* parent, const QString& device_path, int disc_size);
    void run();

private slots:
    void processFinished(int);
    void processUpdate();
    void processError(QProcess::ProcessError);
    void cancelProcess();

signals:
    void jobStatus(QString status);
    
private:
    QString m_device;

    QProcess m_process;

    QTimer m_timer;

    int m_discSize;

    bool m_hadError;
    bool m_wasCanceled;
};

#endif // FORMATTHREAD_H
