/*

Copyright (c) 2010 by Drake Justice <djustice.kde@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

*/

#ifndef PROJECTMODEL_H
#define PROJECTMODEL_H

#include <QStandardItemModel>


class ProjectModel : public QStandardItemModel
{
  Q_OBJECT

  public:
    virtual bool dropMimeData(const QMimeData* data, Qt::DropAction action, int row, int column, const QModelIndex& parent);

  public slots:
    void setCurrentItem(const QModelIndex& item);

  private:
    QModelIndex m_currentItem;
    QString m_currentItemText;
    QString m_currentItemData;

};

#endif // PROJECTMODEL_H
