/***************************************************************************
                          character.cpp  -  description
                             -------------------
    begin                : 11. December 2010
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#include <QLabel>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QApplication>
#include <QDebug>

#include "character.h"


Character::Character(QTrans *parent)
    : QDialog(parent)
{
	Par = parent;
	
	Par->readConfig_3();
	
	QLabel *fontLabel = new QLabel(tr("Font:"));
	fontCombo = new QFontComboBox;
	QLabel *sizeLabel = new QLabel(tr("Size:"));
	sizeCombo = new QComboBox;
	QLabel *styleLabel = new QLabel(tr("Style:"));
	styleCombo = new QComboBox;
	QLabel *fontMergingLabel = new QLabel(tr("Automatic Font Merging:"));
	fontMerging = new QCheckBox;
	fontMerging->setChecked(true);
	
	scrollArea = new QScrollArea;
	characterWidget = new Character_widget(this);
	scrollArea->setWidget(characterWidget);
	
	//characterWidget->updateSize("20");							//ooo
	//characterWidget->updateSize(QString("%1").arg(Par->characterFontType.pointSize()));	//ooo
	
	findStyles(fontCombo->currentFont());
	//findStyles(Par->characterFontType);		//ooo
	
	findSizes(fontCombo->currentFont());
	//findSizes(Par->characterFontType);
	
	lineEdit = new QLineEdit;
	QPushButton *clipboardButton = new QPushButton(tr("&To clipboard"));
	
	clipboard = QApplication::clipboard();
	
	connect(fontCombo, SIGNAL(currentFontChanged(QFont)),
		this, SLOT(findStyles(QFont)));
		
	connect(fontCombo, SIGNAL(currentFontChanged(QFont)),
		this, SLOT(findSizes(QFont)));
		
	connect(fontCombo, SIGNAL(currentFontChanged(QFont)),
		characterWidget, SLOT(updateFont(QFont)));
		
	connect(sizeCombo, SIGNAL(currentIndexChanged(QString)),
		characterWidget, SLOT(updateSize(QString)));
		
	connect(styleCombo, SIGNAL(currentIndexChanged(QString)),
		characterWidget, SLOT(updateStyle(QString)));
		
	connect(characterWidget, SIGNAL(characterSelected(QString)),
		this, SLOT(insertCharacter(QString)));
		
	connect(clipboardButton, SIGNAL(clicked()), this, SLOT(updateClipboard()));
	
	connect(fontMerging, SIGNAL(toggled(bool)), characterWidget, SLOT(updateFontMerging(bool)));
	
	QHBoxLayout *controlsLayout = new QHBoxLayout;
	controlsLayout->addWidget(fontLabel);
	controlsLayout->addWidget(fontCombo, 1);
	controlsLayout->addWidget(sizeLabel);
	controlsLayout->addWidget(sizeCombo, 1);
	controlsLayout->addWidget(styleLabel);
	controlsLayout->addWidget(styleCombo, 1);
	controlsLayout->addWidget(fontMergingLabel);
	controlsLayout->addWidget(fontMerging, 1);
	controlsLayout->addStretch(1);
	
	QHBoxLayout *lineLayout = new QHBoxLayout;
	lineLayout->addWidget(lineEdit, 1);
	lineLayout->addSpacing(12);
	lineLayout->addWidget(clipboardButton);
	
	QVBoxLayout *centralLayout = new QVBoxLayout;
	centralLayout->addLayout(controlsLayout);
	centralLayout->addWidget(scrollArea, 1);
	centralLayout->addSpacing(4);
	centralLayout->addLayout(lineLayout);
	setLayout(centralLayout);
	
	setWindowTitle(tr("Character Map"));
	
	fontCombo->setCurrentIndex(fontCombo->findText(QString("%1")
		.arg(Par->characterFontType.family()), Qt::MatchCaseSensitive));		//ooo
	sizeCombo->setCurrentIndex(sizeCombo->findText(QString("%1")
		.arg(Par->characterFontType.pointSize()), Qt::MatchCaseSensitive));		//ooo
	
	/*for (int i=styleCombo->currentIndex(); i<=styleCombo->count(); i++) {
		//qDebug() << "styleCombo->itemText(i=" << i << ") = " << styleCombo->itemText(i);
		if (styleCombo->itemText(i) == QString("%1").arg(Par->characterFontType.style())) {
			styleCombo->setCurrentIndex(i);
		}
	}*/
	
	QString styleStr;
	styleStr.clear();
	
	if (Par->characterFontType.style() == QFont::StyleNormal) {
	  
		if (Par->characterFontType.weight() == QFont::Bold) {
			styleCombo->setCurrentIndex(styleCombo->findText(QString("%1").arg("Bold")));		//ooo
			styleStr = QString("%1").arg("Bold");
		} else {
			styleCombo->setCurrentIndex(styleCombo->findText(QString("%1").arg("Normal")));		//ooo
			styleStr = QString("%1").arg("Normal");
		}
		
	} else if (Par->characterFontType.style() == QFont::StyleItalic) {
	  
		if (Par->characterFontType.weight() == QFont::Bold) {
			styleCombo->setCurrentIndex(styleCombo->findText(QString("%1").arg("Bold Italic")));	//ooo
			styleStr = QString("%1").arg("Bold Italic");
		} else {
			styleCombo->setCurrentIndex(styleCombo->findText(QString("%1").arg("Italic")));		//ooo
			styleStr = QString("%1").arg("Italic");
		}
		
	} else if (Par->characterFontType.style() == QFont::StyleOblique) {
	  
		if (Par->characterFontType.weight() == QFont::Bold) {
			styleCombo->setCurrentIndex(styleCombo->findText(QString("%1").arg("Bold Oblique")));	//ooo
			styleStr = QString("%1").arg("Bold Oblique");
		} else {
			styleCombo->setCurrentIndex(styleCombo->findText(QString("%1").arg("Oblique")));	//ooo
			styleStr = QString("%1").arg("Oblique");
		}
		
	} 
	
	//styleCombo->setCurrentIndex(styleCombo->findText(QString("%1")
	//	.arg(Par->characterFontType.style()), Qt::MatchCaseSensitive));			//ooo
	//styleCombo->setCurrentIndex(styleCombo->findText(QString("%1")
	//	.arg(Par->characterFontType.style()), Qt::MatchCaseSensitive));			//ooo
	//styleCombo->setCurrentIndex(Par->characterFontType.style());				//ooo
	
	characterWidget->updateFont(Par->characterFontType.family());				//ooo
	characterWidget->updateSize(QString("%1").arg(Par->characterFontType.pointSize()));	//ooo
	//characterWidget->updateStyle(QString("%1").arg(Par->characterFontType.style()));	//ooo
	//characterWidget->updateStyle(QString("%1").arg(Par->characterFontType.style()));	//ooo
	characterWidget->updateStyle(styleStr);							//ooo
	//characterWidget->updateStyle(QFont::Style(Par->characterFontType.style()));		//ooo
	
	
}


Character::~Character()
{
}


void Character::findStyles(const QFont &font)
{
	QFontDatabase fontDatabase;
	QString currentItem = styleCombo->currentText();
	styleCombo->clear();

	QString style;
	foreach (style, fontDatabase.styles(font.family()))
		styleCombo->addItem(style);

	int styleIndex = styleCombo->findText(currentItem);

	if (styleIndex == -1) {
		styleCombo->setCurrentIndex(0);
	} else {
		styleCombo->setCurrentIndex(styleIndex);
	}
}


void Character::findSizes(const QFont &font)
{
	QFontDatabase fontDatabase;
	//QString currentSize = sizeCombo->currentText();
	QString currentSize = QString("%1").arg(font.pointSize());
	sizeCombo->blockSignals(true);
	sizeCombo->clear();

	int size;
	if(fontDatabase.isSmoothlyScalable(font.family(), fontDatabase.styleString(font))) {
		foreach(size, QFontDatabase::standardSizes()) {
			sizeCombo->addItem(QVariant(size).toString());
			sizeCombo->setEditable(true);
		}
	} else {
		foreach(size, fontDatabase.smoothSizes(font.family(), fontDatabase.styleString(font))) {
			sizeCombo->addItem(QVariant(size).toString());
			sizeCombo->setEditable(false);
		}
	}

	sizeCombo->blockSignals(false);

	int sizeIndex = sizeCombo->findText(currentSize);

	if(sizeIndex == -1) {
		sizeCombo->setCurrentIndex(qMax(0, sizeCombo->count() / 3));
	} else {
		sizeCombo->setCurrentIndex(sizeIndex);
	}
}


void Character::insertCharacter(const QString &character)
{
	lineEdit->insert(character);
}


void Character::updateClipboard()
{
	clipboard->setText(lineEdit->text(), QClipboard::Clipboard);
	clipboard->setText(lineEdit->text(), QClipboard::Selection);
}


void Character::closeEvent(QCloseEvent *event)
{
	
	//Par->characterFontType = fontCombo->currentFont();
	Par->characterFontType = characterWidget->displayFont;
	//Par->characterFontType = fontCombo->currentText();
	Par->writeConfig_3();
}

#include "character.moc"
