/***************************************************************************
                          character_widget.cpp  -  description
                             -------------------
    begin                : 12. December 2010
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/ 

#include <QFontDatabase>
#include <QPainter>
#include <QToolTip>
#include <QRect>	//ooo

#include <QDebug>

#include "character_widget.h"


Character_widget::Character_widget(QWidget *parent)
    : QWidget(parent)
{
	Par = parent;		//ooo
	squareSize = 24;
	columns = 16;
	lastKey = -1;
	setMouseTracking(true);
}


Character_widget::~Character_widget()
{
}


void Character_widget::updateFont(const QFont &font)
{

	displayFont.setFamily(font.family());
	squareSize = qMax(24, QFontMetrics(displayFont).xHeight() * 3);
	adjustSize();
	update();
}


void Character_widget::updateSize(const QString &fontSize)
{
  
	displayFont.setPointSize(fontSize.toInt());
	squareSize = qMax(24, QFontMetrics(displayFont).xHeight() * 3);
	adjustSize();
	update();
}


void Character_widget::updateStyle(const QString &fontStyle)
{

	QFontDatabase fontDatabase;
	const QFont::StyleStrategy oldStrategy = displayFont.styleStrategy();
	displayFont = fontDatabase.font(displayFont.family(), fontStyle, displayFont.pointSize());	/// !!!
	displayFont.setStyleStrategy(oldStrategy);
	squareSize = qMax(24, QFontMetrics(displayFont).xHeight() * 3);
	adjustSize();
	update();

}


void Character_widget::updateFontMerging(bool enable)
{

	if (enable) {

		displayFont.setStyleStrategy(QFont::PreferDefault);
	} else {

		displayFont.setStyleStrategy(QFont::NoFontMerging);
	}
	
	adjustSize();
	update();
}


QSize Character_widget::sizeHint() const
{

    return QSize(columns*squareSize, (65536/columns)*squareSize);
}


void Character_widget::mouseMoveEvent(QMouseEvent *event)
{
  
	QPoint widgetPosition = mapFromGlobal(event->globalPos());
	uint key = (widgetPosition.y()/squareSize)*columns + widgetPosition.x()/squareSize;

	QString text = QString::fromLatin1("<p>Character: <span style=\"font-size: 24pt; font-family: %1\">").arg(displayFont.family())
	//QString text = QString::fromLatin1("<p>Character: <span style=\"font-size: 24pt; font-family: %1\">").arg("Helvetica")		//ooo
	//QString text = QString::fromLatin1("<p>Character: <span style='white-space:pre; font-size: 24pt; font-family: %1'>").arg(displayFont.family())		//ooo
		+ QChar(key)
		+ QString::fromLatin1("</span><p>Value: 0x")
		+ QString::number(key, 16);
		//QString("<p style='white-space:pre'>");							//ooo
	//QFont serifFont("Times", 24, QFont::Bold);					//ooo
	//QToolTip::setFont(serifFont);							//ooo
	//QToolTip::showText(event->globalPos(), text, this, QRect(10,10,20,10));	//ooo
	//QToolTip::showText(event->globalPos(), "No text visible", this);				//ooo
	QToolTip::showText(event->globalPos(), text, this);
	//QToolTip::setPalette(QColor(255, 255, 255, 127));					//ooo
}


void Character_widget::mousePressEvent(QMouseEvent *event)
{
  
	if (event->button() == Qt::LeftButton) {
		lastKey = (event->y()/squareSize)*columns + event->x()/squareSize;
		if (QChar(lastKey).category() != QChar::NoCategory)
			emit characterSelected(QString(QChar(lastKey)));
		update();
	} else {
		QWidget::mousePressEvent(event);
	}
}


void Character_widget::paintEvent(QPaintEvent *event)
{
  
	QPainter painter(this);
	painter.fillRect(event->rect(), QBrush(Qt::white));
	//painter.fillRect(event->rect(), QBrush(Qt::yellow));		//ooo
	painter.setFont(displayFont);
	//painter.setFont(QFont("Courier",16,-1,false));		//ooo

	QRect redrawRect = event->rect();
	int beginRow = redrawRect.top()/squareSize;
	int endRow = redrawRect.bottom()/squareSize;
	int beginColumn = redrawRect.left()/squareSize;
	int endColumn = redrawRect.right()/squareSize;

	painter.setPen(QPen(Qt::gray));
	//painter.setPen(QPen(Qt::red));					//ooo
	for (int row = beginRow; row <= endRow; ++row) {
		for (int column = beginColumn; column <= endColumn; ++column) {
			painter.drawRect(column*squareSize, row*squareSize, squareSize, squareSize);
		}
	}
	
	QFontMetrics fontMetrics(displayFont);
	//QFontMetrics fontMetrics(QFont("Liberation Sans",16,-1,false));		//ooo
	painter.setPen(QPen(Qt::black));
	//painter.setPen(QPen(Qt::green));	//ooo
	for (int row = beginRow; row <= endRow; ++row) {

		for (int column = beginColumn; column <= endColumn; ++column) {

			int key = row*columns + column;
			painter.setClipRect(column*squareSize, row*squareSize, squareSize, squareSize);

			if (key == lastKey)
				painter.fillRect(column*squareSize + 1, row*squareSize + 1, squareSize, squareSize, QBrush(Qt::red));

			//if (QChar(key).isNull()) {
			//if (!QChar(key).isLetterOrNumber()) {
			if (!QChar(key).isPrint()) {
				painter.drawText(column*squareSize + (squareSize / 2) - fontMetrics.width(QChar(key))/2,
				row*squareSize + 4 + fontMetrics.ascent(),
				QString(""));
			} else {
				painter.drawText(column*squareSize + (squareSize / 2) - fontMetrics.width(QChar(key))/2,
				row*squareSize + 4 + fontMetrics.ascent(),
				QString(QChar(key)));
				//QString("%1 *").arg(QChar(key)) );		//ooo
			}
		}
	}
}

#include "character_widget.moc"
