/***************************************************************************
                          qtrans.h  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Iven Wold - 526f6c616e642053756368616e
    email                : hour.glass2@yahoo.com
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#ifndef _QTRANS_H_
#define _QTRANS_H_

#include <KMainWindow>

#include <KToolBar>
#include <KMenu>

#include <QClipboard>
#include <QTimer>
#include <QSystemTrayIcon>
#include <KHelpMenu>
#include <QMouseEvent>		//ooo
#include <QTextEdit>		//ooo
#include <QWebView>		//ooo
//#include <QtWebKit/QWebView>	//ooo
#include <QKeyEvent>		//ooo

#include <QMenu>		//ooo
#include <QMenuBar>		//ooo
#include <QStatusBar>		//ooo
#include <QTime>		//ooo
#include <QProgressBar>		//ooo
#include <QDir>			//ooo
#include <KToolBarPopupAction>	//ooo
#include <QToolButton>		//ooo
#include <QMenu>		//ooo
#include <KAction>		//ooo
#include <QAction>		//ooo

#include "systemtray.h"
#include "settings_widg.h"
#include "html_widget.h"
#include "babylon.h"		//ooo

//#include "previewer.h"	//ooo

//class KComboBox;
//class QComboBox;
//class QAction;
//class QLabel;
//class QMenu;
//class KMenuBar;

//class QComboBox;

class QTrans : public QMainWindow
{
    Q_OBJECT
public:

	QTrans(QWidget* parent=0, KAboutData *aboutData=0);
	~QTrans();

	Html_Widget *Out;
	Babylon *Dic;			//ooo
	//Previewer *centralWidget;	//ooo

public slots:
	void Popup();

	void slot_Quit();
	void slot_Left();			//ooo
	void slot_Right();			//ooo
	void slot_Exit(bool ask = true);
	void slot_Ok();
	void slot_About();
	void slot_Help();

	void slot_ClipChanged();
	void slot_Enable();
	void slot_ShortCut();
	void toggleMode();
	void slot_OnTop();
	void slot_Alternates();			//ooo
	void slot_WordStartsWith();		//ooo
	void slot_WholeWordsOnly();		//ooo
	void slot_Combo(const QString &);
	void slot_Combo_2(int);			//ooo
	void slot_Combo_3(int);			//ooo
	void slot_Combo_4(int);			//ooo

	void chooseLibrary(QAction *action);
	void chooseLibrary_2(int i);		//ooo
	void slot_searchInAllDictionaries();	//ooo
	void slot_searchInEveryDictionary();	//ooo
	void slot_LookUpInWholeDictionary();	//ooo
	void slot_statusBarMessage();		//ooo
	void slot_aboutKDE();
	void slot_Donation();			//ooo
	void slot_Config();
	void slot_Character();			//ooo

	void slot_Copy();			//ooo
	void slot_saveTranslation();		//ooo


	//void iconActivated(QSystemTrayIcon::ActivationReason reason);

signals:
	void compactModeSelected();		//ooo

public:
	//void Translate(QString ,int ind=0);
	void Translate(QString ,int ind=0, bool allDict=false, bool inEveryDict=false);	//ooo
	void readConfig();
	void readConfig_1();	//ooo
	void writeConfig();
	void writeConfig_2();
	void readConfig_3();
	void writeConfig_3();
	void Default();

	SystemTray *Dock;
	KAboutData* Par_aboutData;

	QClipboard *clip;
	QString Prev_Clip;

	KAction *translateAct;
	KAction *settingsAct;
	KAction *exitAct_;
	KAction *closeAct;
	KAction *leftAct;		//ooo
	KAction *rightAct;		//ooo
	KAction *characterAct;		//ooo
	KToolBar *toolBar;
	//QStatusBar *statusBar_;	//ooo
	KHelpMenu *HelpMenu;

	QTimer *Time;
	QString English_Path;
	QTime t;			//ooo
	int NumOfLines;			//ooo
	int SearchTime;			//ooo
	int FinishedTime;		//ooo
	QString DictionaryName;		//ooo
	QDir homeDir;			//ooo
	QDir qtransDir;			//ooo
	QDir indexDir;			//ooo
	QString strQtransDir;		//ooo
	QString strIndexDir;		//ooo
	QList<QString> list;		//ooo
	int leftRightCounter;		//ooo

	QList<Dictionary> *bab_dict;
	QWebView *view;
	QList<Dictionary>::const_iterator itr;
	QActionGroup *languageGroup;

	bool enabled;
	/*-- Boolean Controls --*/
	bool AutoPopUp,
		DontClose,
		DockIcon,
		StartMin,
		MouseSelected,			//ooo
		StatusBarSelected,		//ooo
		EnableRecording,		//ooo
		saveTranslation,		//ooo
		comboCurrentIndexChanged,	//ooo
		translationExecuted,		//ooo
		enableTranslation_2,		//ooo
		translationEnabled,		//ooo
		enableShortCut,
		compactMode,
		hideTask,
		stayOnTop,
		wordStartsWith,			//ooo
		wordContains,			//ooo
		wordEndsWith,			//ooo
		wholeWordsOnly,			//ooo
		wholeStarDict,			//ooo
		enableAlternates,		//ooo
		clipHasChanged;			//ooo
	/*-- --*/

	QFont fontType;
	QFont characterFontType;
	QString ShortKey;
	QString Charset;
	QString widgetStyle;			//ooo
	QString numberRecodings;		//ooo
	QString bgColor, txtColor;
	QString expressionTxtColor;		//ooo
	QString sentencePartTxtColor;		//ooo
	//KComboBox *combo;
	QComboBox *combo;
	int comboCurrentIndexIfChanged;		//ooo
	int comboActivatedIndexStack;		//ooo
	QProgressBar *progressBar;		//ooo
	QString strStatusBar;			//ooo
	QMenu *languageMenu;
	KToolBarPopupAction *helpPopupAct;	//ooo
	KAction *helpAct;			//ooo
	KAction *reportBugAct;			//ooo
	KAction *aboutApplicationAct;		//ooo
	KAction *aboutKdeAct;			//ooo
	KAction *donationAct;			//ooo
	QToolButton *tb;			//ooo
	QMenu *qMenu;				//ooo

	QList<QAction*> actionsList;

	QSystemTrayIcon *trayIcon;

	QString text;				//ooo

private:
	void createActions();
	void createMenus();
	void setupActions();
	void createStatusBar();			//ooo

	void createTrayIcon();
	QAction *exitAct;
	QAction *trayExitAct;
	QAction *trayAboutAct;
	QAction *aboutAct;
	QAction *configAct;

	QAction *normalModeAct;
	QAction *compactModeAct;
	QAction *stayOnTopAct;
	QAction *alternatesAct;			//ooo
	QAction *wordStartsWithAct;		//ooo
	QAction *wholeWordsOnlyAct;		//ooo
	QAction *searchAllAct;			//ooo
	QAction *searchEveryDictAct;		//ooo
	QAction *lookUpInWholeStarDictAct;	//ooo
	QAction *disableAct;
	QAction *enableAct;

	QAction *copyAct;			//ooo
	QTextEdit *textEdit;			//ooo
	//Previewer *centralWidget;		//ooo

	//QCheckBox *showIconCheckBox;

	//QSystemTrayIcon *trayIcon;   //because of Settings::slot_apply()
	//QMenu *trayIconMenu;   //no addTitle possible
	KMenu *trayIconMenu;

	QMenu *helpMenu;			//ooo
	QMenuBar *menubar;			//ooo

protected:
	void closeEvent(QCloseEvent *event);
	//void closeEvent(QEvent *event);
	void keyPressEvent(QKeyEvent * event);
	void contextMenuEvent(QContextMenuEvent *event);
	void mousePressEvent(QMouseEvent *event);	//ooo
	//bool queryClose();

	int xPos;
	int yPos;

};

#endif // _QTRANS_H_
