"""
File:		List.py
Purpose:	List handler

Author:		Copyright 2006-2010 Xavion

License:	This file is part of Q7Z.

			Q7Z is free software: you can redistribute it and/or modify
			it under the terms of the GNU Lesser General Public License as published by
			the Free Software Foundation, either version 3 of the License, or
			(at your option) any later version.

			Q7Z is distributed in the hope that it will be useful,
			but WITHOUT ANY WARRANTY; without even the implied warranty of
			MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
			GNU Lesser General Public License for more details.

			You should have received a copy of the GNU Lesser General Public License
			along with Q7Z.  If not, see <http://www.gnu.org/licenses/>.
"""


### Imports

# App 1
import	Import

# PyQt4
try :
	from	PyQt4	import QtCore
	# Visible?
	if not Import.Init.bInvisible :
		from	PyQt4	import QtGui
except :
	Import.slException("PyQt4")

# App 2
import	Display, Help, Settings


### Variables


### Slots

# Load list
def slLoad(sName) :

	sPath = Settings.Path.App.sConfig + "/Lists/"

	# Append filename
	if len(sName) :
		sPath += sName + ".txt"
	# Choose filename
	else :
		sPath = QtGui.QFileDialog.getOpenFileName(None, Settings.Application.sName + " - Open File", sPath, "Lists (*.txt)")

	if len(sPath) :

		# Forget current files
		Settings.List.slFiles = []

		if not sPath.lower().endswith(".txt") :
			sPath += ".txt"

		# List file
		fList = QtCore.QFile(sPath)

		# Determine filename
		sName = fList.fileName().rsplit("/", 1)[1].rsplit('.', 1)[0]

		if not fList.open(QtCore.QIODevice.ReadOnly | QtCore.QIODevice.Text) :

			# Messages
			Display.slMessage(Settings.Message.iError, "Can't load the '" + sName + "' list")

		else :

			# Prepare text stream
			tsList = QtCore.QTextStream(fList)

			while not tsList.atEnd() :
				sLine = tsList.readLine()

				# Test the path validity
				if QtCore.QFile.exists(sLine) :
					Settings.List.slFiles.append(sLine)

			fList.close()

			# Messages
			Display.slMessage(Settings.Message.iStatus, "Loaded the '" + sName + "' list")

			Display.slGUIExternal(Settings.Operation.iCreate)

# Load 'Other' list
def slLoadOther() :
	slLoad("")


# Edit list
def slEdit(sName) :

	sPath = Settings.Path.App.sConfig + "/Lists/"

	# Append filename
	if len(sName) :
		sPath += sName + ".txt"
	# Choose filename
	else :
		sPath = QtGui.QFileDialog.getOpenFileName(None, Settings.Application.sName + " - Open File", sPath, "Lists (*.txt)")

	if len(sPath) :

		if not sPath.lower().endswith(".txt") :
			sPath += ".txt"

		# List file
		fList = QtCore.QFile(sPath)

		# Determine filename
		sName = fList.fileName().rsplit("/", 1)[1].rsplit('.', 1)[0]

		# Test existence
		if not fList.exists() :
			# Messages
			Display.slMessage(Settings.Message.iError, "Can't edit the '" + sName + "' list")
		else :
			Help.slUOpen(QtCore.QUrl("file:" + sPath))

# Edit 'Other' list
def slEditOther() :
	slEdit("")


# Save list
def slSave(sName) :

	sPath = Settings.Path.App.sConfig + "/Lists/"

	# Append filename
	if len(sName) :
		sPath += sName + ".txt"
	# Choose filename
	else :
		sPath = QtGui.QFileDialog.getSaveFileName(None, Settings.Application.sName + " - Save File", sPath, "Lists (*.txt)", QtGui.QFileDialog.DontConfirmOverwrite)

	if len(sPath) :

		if not sPath.lower().endswith(".txt") :
			sPath += ".txt"

		# List file
		fList = QtCore.QFile(sPath)

		# Determine filename
		sName = fList.fileName().rsplit("/", 1)[1].rsplit('.', 1)[0]

		if not fList.open(QtCore.QIODevice.WriteOnly | QtCore.QIODevice.Text) :

			# Messages
			Display.slMessage(Settings.Message.iError, "Can't save the '" + sName + "' list")

		else :

			# Prepare text stream
			tsList = QtCore.QTextStream(fList)

			# Header
			tsList << "### " + Settings.Application.sName + " v" + Settings.Application.sVersion + ": List\n"
			tsList << "\n# Directories and/or files\n"

			# List of files to archive
			for iEntry in range(0, len(Settings.List.slFiles)) :
				tsList << Settings.List.slFiles[iEntry] + "\n"

			fList.close()

			# Messages
			Display.slMessage(Settings.Message.iStatus, "Saved the '" + sName + "' list")

# Save 'Other' list
def slSaveOther() :
	slSave("")
