package Rast;

use strict;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'flags' => [ qw(
				     RAST_LITTLE_ENDIAN
				     RAST_BIG_ENDIAN
				     RAST_NATIVE_ENDIAN
				     RAST_TYPE_STRING
				     RAST_TYPE_DATE
				     RAST_TYPE_DATETIME
				     RAST_TYPE_UINT
				     RAST_PROPERTY_FLAG_SEARCH
				     RAST_PROPERTY_FLAG_TEXT_SEARCH
				     RAST_PROPERTY_FLAG_FULL_TEXT_SEARCH
				     RAST_PROPERTY_FLAG_UNIQUE	
				     RAST_PROPERTY_FLAG_OMIT
				     RAST_RDWR
				     RAST_RDONLY
				     RAST_DB_RDWR
				     RAST_DB_RDONLY
				     RAST_RESULT_ALL_ITEMS
				     RAST_SORT_METHOD_SCORE
				     RAST_SORT_METHOD_PROPERTY
				     RAST_SORT_ORDER_DEFAULT
				     RAST_SORT_ORDER_ASCENDING
				     RAST_SORT_ORDER_DESCENDING
				     RAST_SCORE_METHOD_NONE
				     RAST_SCORE_METHOD_TFIDF
) ] );
our @EXPORT_OK = ();
our @EXPORT = (@{ $EXPORT_TAGS{'flags'} });

our $VERSION = '0.04';

our $RAST_HANDLE;

require XSLoader;
XSLoader::load('Rast', $VERSION);

use Carp;

use Rast::Db;
use Rast::Merger;

DESTROY {
    my $self = shift;
    $self->finalize();
}

# Preloaded methods go here.

sub new {
    my $class = shift;
    my $self = bless {}, $class;
    $self->initialize();
    return $self;
}

sub create {
    my $class = shift;
    $RAST_HANDLE = $class->new
	unless $RAST_HANDLE;
    $RAST_HANDLE->db_create(@_);
}

sub open {
    my $class = shift;
    $RAST_HANDLE = $class->new
	unless $RAST_HANDLE;
    $RAST_HANDLE->db_open(@_);
}

sub db_create {
    my $self = shift;
    my $dbpath = shift;
    my $options = shift;

    Carp::croak("no dbpath")
	unless $dbpath;

    $options->{byte_order} = RAST_NATIVE_ENDIAN()
	unless $options->{byte_order} =~ /^\d+$/;

    $options->{pos_block_size} = 512
	unless $options->{pos_block_size} =~ /^\d+$/;

    $options->{encoding} = "utf8"
	unless $options->{encoding} =~ /^(utf8|euc_jp)$/;

    $options->{preserve_text} = 0
	unless $options->{preserve_text} eq "1";

    Carp::croak("can't find properties")
      unless $options->{properties};

    $options->{num_properties} = 0;
    foreach my $p (@{$options->{properties}}) {
	unless ($p->[0]) {
	    Carp::croak("no property name:" . $options->{num_properties})
	}
	unless ($p->[0] =~ /^[\_\-a-zA-Z]+$/) {
	    Carp::croak("property name pattern error:" . $options->{num_properties})
	}
	if ($p->[1] ne RAST_TYPE_STRING() &&
	    $p->[1] ne RAST_TYPE_DATE() &&
	    $p->[1] ne RAST_TYPE_UINT()
	    ) {    
	    Carp::croak("no property type:" . $options->{num_properties})
	}
	unless ($p->[2] =~ /^\d+$/) {    
	    Carp::croak("no property flags:" . $options->{num_properties})
	}
	$options->{num_properties}++;
    }

    Carp::croak("can't find properties")
      unless $options->{num_properties};
    
    $self->_db_create($dbpath, $options);
}

sub db_open {
    my $self    = shift;
    my $dbpath  = shift;
    my $flags   = shift;
    my $options = shift;

    Carp::croak("no dbpath")
	unless $dbpath;

    Carp::croak("merger is read only")
	if (ref($dbpath) eq 'ARRAY' && ($flags eq RAST_DB_RDWR() || $flags eq RAST_RDWR()));

    $flags = RAST_DB_RDONLY()
	if ($flags ne RAST_DB_RDWR() && $flags ne RAST_DB_RDONLY() &&
	    $flags ne RAST_RDWR() && $flags ne RAST_RDONLY());
    
    $options = {}
    if (ref($options) ne 'HASH');

    $self->_db_open($dbpath, $flags, $options);
}

1;
__END__

=head1 NAME

Rast - Interface to Rast

=head1 SYNOPSIS

  See. example/*.pl

=head1 DESCRIPTION

Rast$B$N(Bperl API$B$G$9!#(B

=head1 SEE ALSO

rast web site: http://www.netlab.jp/rast/

=head1 AUTHOR

kazuhiro osawa, E<lt>ko@yappo.ne.jpE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2005 by kazuhiro osawa


=cut
