/*
 * Example of using Glyph Keeper in text mode
 *
 * Copyright (c) 2003-2007 Kirill Kryukov
 *
 * This file is part of Glyph Keeper library, and may only be used,
 * modified, and distributed under the terms of the Glyph Keeper
 * license, located in the file 'license.txt' within this package.
 */


/*
 * This example shows how to use Glyph Keeper in text mode to test
 * FreeType/GK installation without adding extra dependencies like Allegro.
 */

#include <stdio.h>
#include "glyph.h"


int main()
{
    char *fontfile = "../fonts/DejaVuSans.ttf";
    GLYPH_FACE *face;
    GLYPH_REND *rend;

    /* Loading a font face from file. */
    face = gk_load_face_from_file(fontfile,0);
    if (!face) { printf("Can't load font from \"%s\"\n",fontfile); return 1; }

    /* Setting up a renderer object. */
    rend = gk_create_renderer(face,0);
    if (!rend) { printf("Can't create font renderer object\n"); return 1; }

    /* Setting font size. */
    gk_rend_set_size_pixels(rend,45,30);

    /* Rendering a single character '@' to console. */
    gk_put_char(stdout,rend,'@',0,0);

    return 0;
}
