/* test-serializer.c generated by valac 0.32.1, the Vala compiler
 * generated from test-serializer.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "libcalculator.h"
#include <locale.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))


extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;

#define thousand_separator ","
#define radix_string "."
void pass (const gchar* text);
void fail (const gchar* text);
void test_number (Serializer* s, const gchar* number, gint base_value, gint representation_base, const gchar* expected_string);
void test_fixed (Serializer* s);
void test_automatic (Serializer* s);
void test_scientific (Serializer* s);
void test_engineering (Serializer* s);
void test_base_conversion (Serializer* s);
gint _vala_main (gchar** args, int args_length1);


void pass (const gchar* text) {
	gint _tmp0_ = 0;
	_tmp0_ = pass_count;
	pass_count = _tmp0_ + 1;
}


void fail (const gchar* text) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (text != NULL);
	_tmp0_ = stdout;
	_tmp1_ = text;
	fprintf (_tmp0_, "*FAIL: %s\n", _tmp1_);
	_tmp2_ = fail_count;
	fail_count = _tmp2_ + 1;
}


void test_number (Serializer* s, const gchar* number, gint base_value, gint representation_base, const gchar* expected_string) {
	Number* n = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Serializer* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Serializer* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (s != NULL);
	g_return_if_fail (number != NULL);
	g_return_if_fail (expected_string != NULL);
	_tmp0_ = number;
	_tmp1_ = base_value;
	_tmp2_ = mp_set_from_string (_tmp0_, _tmp1_);
	n = _tmp2_;
	_tmp3_ = s;
	_tmp4_ = base_value;
	serializer_set_base (_tmp3_, _tmp4_);
	_tmp5_ = s;
	_tmp6_ = representation_base;
	serializer_set_representation_base (_tmp5_, (guint) _tmp6_);
	_tmp7_ = s;
	_tmp8_ = n;
	_tmp9_ = serializer_to_string (_tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = expected_string;
	_tmp12_ = g_strcmp0 (_tmp10_, _tmp11_) == 0;
	_g_free0 (_tmp10_);
	if (_tmp12_) {
		pass (NULL);
	} else {
		Serializer* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp13_ = s;
		_tmp14_ = n;
		_tmp15_ = serializer_to_string (_tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = expected_string;
		_tmp18_ = g_strdup_printf ("Serializer returned (%s) => expected value (%s)", _tmp16_, _tmp17_);
		_tmp19_ = _tmp18_;
		fail (_tmp19_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp16_);
	}
	_g_object_unref0 (n);
}


void test_fixed (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_FIXED);
	_tmp1_ = s;
	test_number (_tmp1_, "123456789012345678901234", 10, 10, "123,456,789,012,345,678,901,234");
	_tmp2_ = s;
	test_number (_tmp2_, "0.1234567890123456789012", 10, 10, "0.123456789");
	_tmp3_ = s;
	test_number (_tmp3_, "101010101010101010101010", 2, 2, "101010101010101010101010");
	_tmp4_ = s;
	test_number (_tmp4_, "0.1010101010101010101010", 2, 2, "0.101010101");
	_tmp5_ = s;
	test_number (_tmp5_, "123456701234567012345670", 8, 8, "123456701234567012345670");
	_tmp6_ = s;
	test_number (_tmp6_, "0.1234567012345670123456", 8, 8, "0.123456701");
	_tmp7_ = s;
	test_number (_tmp7_, "123456789ABCDEF012345678", 16, 16, "123456789ABCDEF012345678");
	_tmp8_ = s;
	test_number (_tmp8_, "0.ABCDEF0123456789ABCDEF", 16, 16, "0.ABCDEF012");
}


void test_automatic (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
	Serializer* _tmp12_ = NULL;
	Serializer* _tmp13_ = NULL;
	Serializer* _tmp14_ = NULL;
	Serializer* _tmp15_ = NULL;
	Serializer* _tmp16_ = NULL;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_AUTOMATIC);
	_tmp1_ = s;
	test_number (_tmp1_, "0.10", 10, 10, "0.1");
	_tmp2_ = s;
	test_number (_tmp2_, "0.12345678901234567890", 10, 10, "0.123456789");
	_tmp3_ = s;
	test_number (_tmp3_, "123456789012", 10, 10, "123,456,789,012");
	_tmp4_ = s;
	test_number (_tmp4_, "12345678901234567890", 10, 10, "1.23456789×10¹⁹");
	_tmp5_ = s;
	test_number (_tmp5_, ".10", 2, 2, "0.1");
	_tmp6_ = s;
	test_number (_tmp6_, "0.10101010101010101010", 2, 2, "0.101010101");
	_tmp7_ = s;
	test_number (_tmp7_, "1010101010101010101010101010101010101010101010101010101010101010", 2, 2, "1010101010101010101010101010101010101010101010101010101010101010");
	_tmp8_ = s;
	test_number (_tmp8_, "10101010101010101010101010101010101010101010101010101010101010101", 2, 2, "1.010101011×10⁶⁴");
	_tmp9_ = s;
	test_number (_tmp9_, "0.10", 8, 8, "0.1");
	_tmp10_ = s;
	test_number (_tmp10_, "0.12345670123456701234", 8, 8, "0.123456701");
	_tmp11_ = s;
	test_number (_tmp11_, "1234567012345670123456", 8, 8, "1234567012345670123456");
	_tmp12_ = s;
	test_number (_tmp12_, "12345670123456701234567", 8, 8, "1.234567012×10²²");
	_tmp13_ = s;
	test_number (_tmp13_, "0.10", 16, 16, "0.1");
	_tmp14_ = s;
	test_number (_tmp14_, "0.123456789ABCDEF01234", 16, 16, "0.12345678A");
	_tmp15_ = s;
	test_number (_tmp15_, "123456789ABCDEF0", 16, 16, "123456789ABCDEF0");
	_tmp16_ = s;
	test_number (_tmp16_, "123456789ABCEDF01", 16, 16, "1.23456789B×10¹⁶");
}


void test_scientific (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_SCIENTIFIC);
	_tmp1_ = s;
	test_number (_tmp1_, "1", 10, 10, "1");
	_tmp2_ = s;
	test_number (_tmp2_, "10", 10, 10, "1×10¹");
	_tmp3_ = s;
	test_number (_tmp3_, "1234567890", 10, 10, "1.23456789×10⁹");
	_tmp4_ = s;
	test_number (_tmp4_, "0.1", 10, 10, "1×10⁻¹");
	_tmp5_ = s;
	test_number (_tmp5_, "0.1234567890", 10, 10, "1.23456789×10⁻¹");
	_tmp6_ = s;
	test_number (_tmp6_, "101010", 2, 2, "101010");
	_tmp7_ = s;
	test_number (_tmp7_, "12345670", 8, 8, "12345670");
	_tmp8_ = s;
	test_number (_tmp8_, "123456789ABCDEF0", 16, 16, "123456789ABCDEF0");
	_tmp9_ = s;
	test_number (_tmp9_, "0.010101", 2, 2, "0.010101");
	_tmp10_ = s;
	test_number (_tmp10_, "0.1234567", 8, 8, "0.1234567");
	_tmp11_ = s;
	test_number (_tmp11_, "0.123ABCDEF", 16, 16, "0.123ABCDEF");
}


void test_engineering (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	serializer_set_number_format (_tmp0_, DISPLAY_FORMAT_ENGINEERING);
	_tmp1_ = s;
	test_number (_tmp1_, "1", 10, 10, "1");
	_tmp2_ = s;
	test_number (_tmp2_, "10", 10, 10, "10");
	_tmp3_ = s;
	test_number (_tmp3_, "1234567890", 10, 10, "1.23456789×10⁹");
	_tmp4_ = s;
	test_number (_tmp4_, "0.1", 10, 10, "100×10⁻³");
	_tmp5_ = s;
	test_number (_tmp5_, "0.1234567890", 10, 10, "123.456789×10⁻³");
	_tmp6_ = s;
	test_number (_tmp6_, "101010", 2, 2, "101010");
	_tmp7_ = s;
	test_number (_tmp7_, "12345670", 8, 8, "12345670");
	_tmp8_ = s;
	test_number (_tmp8_, "123456789ABCDEF0", 16, 16, "123456789ABCDEF0");
	_tmp9_ = s;
	test_number (_tmp9_, "0.10101", 2, 2, "0.10101");
	_tmp10_ = s;
	test_number (_tmp10_, "0.1234567", 8, 8, "0.1234567");
	_tmp11_ = s;
	test_number (_tmp11_, "0.123ABCDEF", 16, 16, "0.123ABCDEF");
}


void test_base_conversion (Serializer* s) {
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	Serializer* _tmp2_ = NULL;
	Serializer* _tmp3_ = NULL;
	Serializer* _tmp4_ = NULL;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
	Serializer* _tmp12_ = NULL;
	Serializer* _tmp13_ = NULL;
	Serializer* _tmp14_ = NULL;
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	test_number (_tmp0_, "12₈", 10, 2, "1010₂");
	_tmp1_ = s;
	test_number (_tmp1_, "10", 10, 2, "1010₂");
	_tmp2_ = s;
	test_number (_tmp2_, "A₁₆", 10, 2, "1010₂");
	_tmp3_ = s;
	test_number (_tmp3_, "1234567890123456789012345678901234567890", 10, 2, "1110100000110010010010000001110101110000001101101111110011101110001010" \
"110010111100010111111001011011001110001111110000101011010010₂");
	_tmp4_ = s;
	test_number (_tmp4_, "1010₂", 10, 8, "12₈");
	_tmp5_ = s;
	test_number (_tmp5_, "10", 10, 8, "12₈");
	_tmp6_ = s;
	test_number (_tmp6_, "A₁₆", 10, 8, "12₈");
	_tmp7_ = s;
	test_number (_tmp7_, "1234567890123456789012345678901234567890", 10, 8, "16406222016560155763561262742771331617605322₈");
	_tmp8_ = s;
	test_number (_tmp8_, "1010₂", 10, 10, "10");
	_tmp9_ = s;
	test_number (_tmp9_, "12₈", 10, 10, "10");
	_tmp10_ = s;
	test_number (_tmp10_, "A₁₆", 10, 10, "10");
	_tmp11_ = s;
	test_number (_tmp11_, "1010₂", 10, 16, "A₁₆");
	_tmp12_ = s;
	test_number (_tmp12_, "12₈", 10, 16, "A₁₆");
	_tmp13_ = s;
	test_number (_tmp13_, "10", 10, 16, "A₁₆");
	_tmp14_ = s;
	test_number (_tmp14_, "1234567890123456789012345678901234567890", 10, 16, "3A0C92075C0DBF3B8ACBC5F96CE3F0AD2₁₆");
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Serializer* serializer = NULL;
	Serializer* _tmp0_ = NULL;
	Serializer* _tmp1_ = NULL;
	gunichar _tmp2_ = 0U;
	Serializer* _tmp3_ = NULL;
	gunichar _tmp4_ = 0U;
	Serializer* _tmp5_ = NULL;
	Serializer* _tmp6_ = NULL;
	Serializer* _tmp7_ = NULL;
	Serializer* _tmp8_ = NULL;
	Serializer* _tmp9_ = NULL;
	Serializer* _tmp10_ = NULL;
	Serializer* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp19_ = 0;
	setlocale (LC_ALL, "C");
	_tmp0_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
	serializer = _tmp0_;
	_tmp1_ = serializer;
	_tmp2_ = string_get_char (thousand_separator, (glong) 0);
	serializer_set_thousands_separator (_tmp1_, _tmp2_);
	_tmp3_ = serializer;
	_tmp4_ = string_get_char (radix_string, (glong) 0);
	serializer_set_radix (_tmp3_, _tmp4_);
	_tmp5_ = serializer;
	serializer_set_show_thousands_separators (_tmp5_, TRUE);
	_tmp6_ = serializer;
	serializer_set_thousands_separator_count (_tmp6_, 3);
	_tmp7_ = serializer;
	test_fixed (_tmp7_);
	_tmp8_ = serializer;
	test_automatic (_tmp8_);
	_tmp9_ = serializer;
	test_scientific (_tmp9_);
	_tmp10_ = serializer;
	test_engineering (_tmp10_);
	_tmp11_ = serializer;
	test_base_conversion (_tmp11_);
	_tmp12_ = fail_count;
	if (_tmp12_ == 0) {
		FILE* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		_tmp13_ = stdout;
		_tmp14_ = pass_count;
		fprintf (_tmp13_, "Passed all %i tests\n", _tmp14_);
	} else {
		FILE* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		_tmp15_ = stdout;
		_tmp16_ = fail_count;
		_tmp17_ = pass_count;
		_tmp18_ = fail_count;
		fprintf (_tmp15_, "Failed %i/%d tests\n", _tmp16_, _tmp17_ + _tmp18_);
	}
	_tmp19_ = fail_count;
	result = _tmp19_;
	_g_object_unref0 (serializer);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}



