/* DvbTParameter.c generated by valac 0.25.1, the Vala compiler
 * generated from DvbTParameter.vala, do not modify */

/*
 * DvbTParameter.vala
 *
 * Copyright (C) 2014 Stefan Ringel
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>
#include <gst/mpegts/mpegts.h>


#define DVB_TYPE_PARAMETER (dvb_parameter_get_type ())
#define DVB_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PARAMETER, DVBParameter))
#define DVB_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PARAMETER, DVBParameterClass))
#define DVB_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PARAMETER))
#define DVB_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PARAMETER))
#define DVB_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PARAMETER, DVBParameterClass))

typedef struct _DVBParameter DVBParameter;
typedef struct _DVBParameterClass DVBParameterClass;
typedef struct _DVBParameterPrivate DVBParameterPrivate;

#define DVB_TYPE_DVB_TPARAMETER (dvb_dvb_tparameter_get_type ())
#define DVB_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter))
#define DVB_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))
#define DVB_IS_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_TPARAMETER))
#define DVB_IS_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_TPARAMETER))
#define DVB_DVB_TPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))

typedef struct _DVBDvbTParameter DVBDvbTParameter;
typedef struct _DVBDvbTParameterClass DVBDvbTParameterClass;
typedef struct _DVBDvbTParameterPrivate DVBDvbTParameterPrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;

#define DVB_TYPE_DVB_SRC_DELSYS (dvb_dvb_src_delsys_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBParameter {
	GObject parent_instance;
	DVBParameterPrivate * priv;
};

struct _DVBParameterClass {
	GObjectClass parent_class;
	void (*prepare) (DVBParameter* self, GstElement* source);
	gboolean (*add_scanning_data) (DVBParameter* self, GHashTable* data);
	gboolean (*equal) (DVBParameter* self, DVBParameter* param);
	gchar* (*to_string) (DVBParameter* self);
};

struct _DVBDvbTParameter {
	DVBParameter parent_instance;
	DVBDvbTParameterPrivate * priv;
};

struct _DVBDvbTParameterClass {
	DVBParameterClass parent_class;
};

struct _DVBDvbTParameterPrivate {
	guint _Bandwidth;
	GstMpegtsTerrestrialGuardInterval _GuardInterval;
	GstMpegtsTerrestrialTransmissionMode _TransmissionMode;
	GstMpegtsTerrestrialHierarchy _Hierarchy;
	GstMpegtsModulationType _Constellation;
	GstMpegtsDVBCodeRate _CodeRateLP;
	GstMpegtsDVBCodeRate _CodeRateHP;
};

typedef enum  {
	DVB_DVB_SRC_DELSYS_SYS_UNDEFINED,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_A,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_B,
	DVB_DVB_SRC_DELSYS_SYS_DVBT,
	DVB_DVB_SRC_DELSYS_SYS_DSS,
	DVB_DVB_SRC_DELSYS_SYS_DVBS,
	DVB_DVB_SRC_DELSYS_SYS_DVBS2,
	DVB_DVB_SRC_DELSYS_SYS_DVBH,
	DVB_DVB_SRC_DELSYS_SYS_ISDBT,
	DVB_DVB_SRC_DELSYS_SYS_ISDBS,
	DVB_DVB_SRC_DELSYS_SYS_ISDBC,
	DVB_DVB_SRC_DELSYS_SYS_ATSC,
	DVB_DVB_SRC_DELSYS_SYS_ATSCMH,
	DVB_DVB_SRC_DELSYS_SYS_DTMB,
	DVB_DVB_SRC_DELSYS_SYS_CMMB,
	DVB_DVB_SRC_DELSYS_SYS_DAB,
	DVB_DVB_SRC_DELSYS_SYS_DVBT2,
	DVB_DVB_SRC_DELSYS_SYS_TURBO,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_C
} DVBDvbSrcDelsys;


static gpointer dvb_dvb_tparameter_parent_class = NULL;
static DVBLoggingLogger* dvb_dvb_tparameter_log;
static DVBLoggingLogger* dvb_dvb_tparameter_log = NULL;

GType dvb_parameter_get_type (void) G_GNUC_CONST;
GType dvb_dvb_tparameter_get_type (void) G_GNUC_CONST;
#define DVB_DVB_TPARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterPrivate))
enum  {
	DVB_DVB_TPARAMETER_DUMMY_PROPERTY,
	DVB_DVB_TPARAMETER_BANDWIDTH,
	DVB_DVB_TPARAMETER_GUARD_INTERVAL,
	DVB_DVB_TPARAMETER_TRANSMISSION_MODE,
	DVB_DVB_TPARAMETER_HIERARCHY,
	DVB_DVB_TPARAMETER_CONSTELLATION,
	DVB_DVB_TPARAMETER_CODE_RATE_LP,
	DVB_DVB_TPARAMETER_CODE_RATE_HP
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBDvbTParameter* dvb_dvb_tparameter_new (void);
DVBDvbTParameter* dvb_dvb_tparameter_construct (GType object_type);
GType dvb_dvb_src_delsys_get_type (void) G_GNUC_CONST;
DVBParameter* dvb_parameter_construct (GType object_type, DVBDvbSrcDelsys delsys);
DVBDvbTParameter* dvb_dvb_tparameter_new_with_parameter (guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp);
DVBDvbTParameter* dvb_dvb_tparameter_construct_with_parameter (GType object_type, guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp);
void dvb_parameter_set_Frequency (DVBParameter* self, guint value);
static void dvb_dvb_tparameter_set_Bandwidth (DVBDvbTParameter* self, guint value);
static void dvb_dvb_tparameter_set_GuardInterval (DVBDvbTParameter* self, GstMpegtsTerrestrialGuardInterval value);
static void dvb_dvb_tparameter_set_TransmissionMode (DVBDvbTParameter* self, GstMpegtsTerrestrialTransmissionMode value);
static void dvb_dvb_tparameter_set_Hierarchy (DVBDvbTParameter* self, GstMpegtsTerrestrialHierarchy value);
static void dvb_dvb_tparameter_set_Constellation (DVBDvbTParameter* self, GstMpegtsModulationType value);
static void dvb_dvb_tparameter_set_CodeRateLP (DVBDvbTParameter* self, GstMpegtsDVBCodeRate value);
static void dvb_dvb_tparameter_set_CodeRateHP (DVBDvbTParameter* self, GstMpegtsDVBCodeRate value);
static gboolean dvb_dvb_tparameter_real_add_scanning_data (DVBParameter* base, GHashTable* data);
GstMpegtsTerrestrialHierarchy dvb_getHierarchyEnum (const gchar* val);
GstMpegtsTerrestrialTransmissionMode dvb_getTransmissionModeEnum (const gchar* val);
GstMpegtsDVBCodeRate dvb_getCodeRateEnum (const gchar* val);
GstMpegtsModulationType dvb_getModulationEnum (const gchar* val);
GstMpegtsTerrestrialGuardInterval dvb_getGuardIntervalEnum (const gchar* val);
static gboolean dvb_dvb_tparameter_real_equal (DVBParameter* base, DVBParameter* param);
DVBDvbSrcDelsys dvb_parameter_get_Delsys (DVBParameter* self);
guint dvb_parameter_get_Frequency (DVBParameter* self);
guint dvb_dvb_tparameter_get_Bandwidth (DVBDvbTParameter* self);
GstMpegtsTerrestrialHierarchy dvb_dvb_tparameter_get_Hierarchy (DVBDvbTParameter* self);
GstMpegtsTerrestrialTransmissionMode dvb_dvb_tparameter_get_TransmissionMode (DVBDvbTParameter* self);
GstMpegtsDVBCodeRate dvb_dvb_tparameter_get_CodeRateHP (DVBDvbTParameter* self);
GstMpegtsDVBCodeRate dvb_dvb_tparameter_get_CodeRateLP (DVBDvbTParameter* self);
GstMpegtsModulationType dvb_dvb_tparameter_get_Constellation (DVBDvbTParameter* self);
GstMpegtsTerrestrialGuardInterval dvb_dvb_tparameter_get_GuardInterval (DVBDvbTParameter* self);
static void dvb_dvb_tparameter_real_prepare (DVBParameter* base, GstElement* source);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
static gchar* dvb_dvb_tparameter_real_to_string (DVBParameter* base);
gchar* dvb_getCodeRateString (GstMpegtsDVBCodeRate val);
gchar* dvb_getModulationString (GstMpegtsModulationType val);
gchar* dvb_getTransmissionModeString (GstMpegtsTerrestrialTransmissionMode val);
gchar* dvb_getGuardIntervalString (GstMpegtsTerrestrialGuardInterval val);
gchar* dvb_getHierarchyString (GstMpegtsTerrestrialHierarchy val);
static void dvb_dvb_tparameter_finalize (GObject* obj);
static void _vala_dvb_dvb_tparameter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_dvb_tparameter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


DVBDvbTParameter* dvb_dvb_tparameter_construct (GType object_type) {
	DVBDvbTParameter * self = NULL;
	self = (DVBDvbTParameter*) dvb_parameter_construct (object_type, DVB_DVB_SRC_DELSYS_SYS_DVBT);
	return self;
}


DVBDvbTParameter* dvb_dvb_tparameter_new (void) {
	return dvb_dvb_tparameter_construct (DVB_TYPE_DVB_TPARAMETER);
}


DVBDvbTParameter* dvb_dvb_tparameter_construct_with_parameter (GType object_type, guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp) {
	DVBDvbTParameter * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	GstMpegtsTerrestrialGuardInterval _tmp2_ = 0;
	GstMpegtsTerrestrialTransmissionMode _tmp3_ = 0;
	GstMpegtsTerrestrialHierarchy _tmp4_ = 0;
	GstMpegtsModulationType _tmp5_ = 0;
	GstMpegtsDVBCodeRate _tmp6_ = 0;
	GstMpegtsDVBCodeRate _tmp7_ = 0;
	self = (DVBDvbTParameter*) dvb_parameter_construct (object_type, DVB_DVB_SRC_DELSYS_SYS_DVBT);
	_tmp0_ = frequency;
	dvb_parameter_set_Frequency ((DVBParameter*) self, _tmp0_);
	_tmp1_ = bandwidth;
	dvb_dvb_tparameter_set_Bandwidth (self, _tmp1_);
	_tmp2_ = interval;
	dvb_dvb_tparameter_set_GuardInterval (self, _tmp2_);
	_tmp3_ = transmission;
	dvb_dvb_tparameter_set_TransmissionMode (self, _tmp3_);
	_tmp4_ = hierarchy;
	dvb_dvb_tparameter_set_Hierarchy (self, _tmp4_);
	_tmp5_ = constellation;
	dvb_dvb_tparameter_set_Constellation (self, _tmp5_);
	_tmp6_ = code_rate_lp;
	dvb_dvb_tparameter_set_CodeRateLP (self, _tmp6_);
	_tmp7_ = code_rate_hp;
	dvb_dvb_tparameter_set_CodeRateHP (self, _tmp7_);
	return self;
}


DVBDvbTParameter* dvb_dvb_tparameter_new_with_parameter (guint frequency, guint bandwidth, GstMpegtsTerrestrialGuardInterval interval, GstMpegtsTerrestrialTransmissionMode transmission, GstMpegtsTerrestrialHierarchy hierarchy, GstMpegtsModulationType constellation, GstMpegtsDVBCodeRate code_rate_lp, GstMpegtsDVBCodeRate code_rate_hp) {
	return dvb_dvb_tparameter_construct_with_parameter (DVB_TYPE_DVB_TPARAMETER, frequency, bandwidth, interval, transmission, hierarchy, constellation, code_rate_lp, code_rate_hp);
}


static gboolean dvb_dvb_tparameter_real_add_scanning_data (DVBParameter* base, GHashTable* data) {
	DVBDvbTParameter * self;
	gboolean result = FALSE;
	GVariant* _var = NULL;
	GHashTable* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	GHashTable* _tmp5_ = NULL;
	gconstpointer _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GstMpegtsTerrestrialHierarchy _tmp10_ = 0;
	GHashTable* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	GVariant* _tmp13_ = NULL;
	GVariant* _tmp14_ = NULL;
	guint32 _tmp15_ = 0U;
	GHashTable* _tmp16_ = NULL;
	gconstpointer _tmp17_ = NULL;
	GVariant* _tmp18_ = NULL;
	GVariant* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GstMpegtsTerrestrialTransmissionMode _tmp21_ = 0;
	GHashTable* _tmp22_ = NULL;
	gconstpointer _tmp23_ = NULL;
	GVariant* _tmp24_ = NULL;
	GVariant* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GstMpegtsDVBCodeRate _tmp27_ = 0;
	GHashTable* _tmp28_ = NULL;
	gconstpointer _tmp29_ = NULL;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	GstMpegtsDVBCodeRate _tmp33_ = 0;
	GHashTable* _tmp34_ = NULL;
	gconstpointer _tmp35_ = NULL;
	GVariant* _tmp36_ = NULL;
	GVariant* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	GstMpegtsModulationType _tmp39_ = 0;
	GHashTable* _tmp40_ = NULL;
	gconstpointer _tmp41_ = NULL;
	GVariant* _tmp42_ = NULL;
	GVariant* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GstMpegtsTerrestrialGuardInterval _tmp45_ = 0;
	self = (DVBDvbTParameter*) base;
	g_return_val_if_fail (data != NULL, FALSE);
	_tmp0_ = data;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "frequency");
	_var = (GVariant*) _tmp1_;
	_tmp2_ = _var;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = _var;
	_tmp4_ = g_variant_get_uint32 (_tmp3_);
	dvb_parameter_set_Frequency ((DVBParameter*) self, (guint) _tmp4_);
	_tmp5_ = data;
	_tmp6_ = g_hash_table_lookup (_tmp5_, "hierarchy");
	_var = (GVariant*) _tmp6_;
	_tmp7_ = _var;
	if (_tmp7_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp8_ = _var;
	_tmp9_ = g_variant_get_string (_tmp8_, NULL);
	_tmp10_ = dvb_getHierarchyEnum (_tmp9_);
	dvb_dvb_tparameter_set_Hierarchy (self, _tmp10_);
	_tmp11_ = data;
	_tmp12_ = g_hash_table_lookup (_tmp11_, "bandwidth");
	_var = (GVariant*) _tmp12_;
	_tmp13_ = _var;
	if (_tmp13_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp14_ = _var;
	_tmp15_ = g_variant_get_uint32 (_tmp14_);
	dvb_dvb_tparameter_set_Bandwidth (self, (guint) (_tmp15_ * 1000000));
	_tmp16_ = data;
	_tmp17_ = g_hash_table_lookup (_tmp16_, "transmission-mode");
	_var = (GVariant*) _tmp17_;
	_tmp18_ = _var;
	if (_tmp18_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp19_ = _var;
	_tmp20_ = g_variant_get_string (_tmp19_, NULL);
	_tmp21_ = dvb_getTransmissionModeEnum (_tmp20_);
	dvb_dvb_tparameter_set_TransmissionMode (self, _tmp21_);
	_tmp22_ = data;
	_tmp23_ = g_hash_table_lookup (_tmp22_, "code-rate-hp");
	_var = (GVariant*) _tmp23_;
	_tmp24_ = _var;
	if (_tmp24_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp25_ = _var;
	_tmp26_ = g_variant_get_string (_tmp25_, NULL);
	_tmp27_ = dvb_getCodeRateEnum (_tmp26_);
	dvb_dvb_tparameter_set_CodeRateHP (self, _tmp27_);
	_tmp28_ = data;
	_tmp29_ = g_hash_table_lookup (_tmp28_, "code-rate-lp");
	_var = (GVariant*) _tmp29_;
	_tmp30_ = _var;
	if (_tmp30_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp31_ = _var;
	_tmp32_ = g_variant_get_string (_tmp31_, NULL);
	_tmp33_ = dvb_getCodeRateEnum (_tmp32_);
	dvb_dvb_tparameter_set_CodeRateLP (self, _tmp33_);
	_tmp34_ = data;
	_tmp35_ = g_hash_table_lookup (_tmp34_, "constellation");
	_var = (GVariant*) _tmp35_;
	_tmp36_ = _var;
	if (_tmp36_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp37_ = _var;
	_tmp38_ = g_variant_get_string (_tmp37_, NULL);
	_tmp39_ = dvb_getModulationEnum (_tmp38_);
	dvb_dvb_tparameter_set_Constellation (self, _tmp39_);
	_tmp40_ = data;
	_tmp41_ = g_hash_table_lookup (_tmp40_, "guard-interval");
	_var = (GVariant*) _tmp41_;
	_tmp42_ = _var;
	if (_tmp42_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp43_ = _var;
	_tmp44_ = g_variant_get_string (_tmp43_, NULL);
	_tmp45_ = dvb_getGuardIntervalEnum (_tmp44_);
	dvb_dvb_tparameter_set_GuardInterval (self, _tmp45_);
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean dvb_dvb_tparameter_real_equal (DVBParameter* base, DVBParameter* param) {
	DVBDvbTParameter * self;
	gboolean result = FALSE;
	DVBParameter* _tmp0_ = NULL;
	DVBParameter* _tmp1_ = NULL;
	DVBDvbSrcDelsys _tmp2_ = 0;
	DVBDvbSrcDelsys _tmp3_ = 0;
	DVBDvbSrcDelsys _tmp4_ = 0;
	DVBDvbSrcDelsys _tmp5_ = 0;
	DVBDvbTParameter* tparam = NULL;
	DVBParameter* _tmp6_ = NULL;
	DVBDvbTParameter* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	DVBDvbTParameter* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	self = (DVBDvbTParameter*) base;
	g_return_val_if_fail (param != NULL, FALSE);
	_tmp0_ = param;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = param;
	_tmp2_ = dvb_parameter_get_Delsys (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = dvb_parameter_get_Delsys ((DVBParameter*) self);
	_tmp5_ = _tmp4_;
	if (_tmp3_ != _tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = param;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter));
	tparam = _tmp7_;
	_tmp15_ = tparam;
	_tmp16_ = dvb_parameter_get_Frequency ((DVBParameter*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = dvb_parameter_get_Frequency ((DVBParameter*) self);
	_tmp19_ = _tmp18_;
	if (_tmp17_ == _tmp19_) {
		DVBDvbTParameter* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		guint _tmp22_ = 0U;
		_tmp20_ = tparam;
		_tmp21_ = _tmp20_->priv->_Bandwidth;
		_tmp22_ = self->priv->_Bandwidth;
		_tmp14_ = _tmp21_ == _tmp22_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		DVBDvbTParameter* _tmp23_ = NULL;
		GstMpegtsTerrestrialHierarchy _tmp24_ = 0;
		GstMpegtsTerrestrialHierarchy _tmp25_ = 0;
		_tmp23_ = tparam;
		_tmp24_ = _tmp23_->priv->_Hierarchy;
		_tmp25_ = self->priv->_Hierarchy;
		_tmp13_ = _tmp24_ == _tmp25_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		DVBDvbTParameter* _tmp26_ = NULL;
		GstMpegtsTerrestrialTransmissionMode _tmp27_ = 0;
		GstMpegtsTerrestrialTransmissionMode _tmp28_ = 0;
		_tmp26_ = tparam;
		_tmp27_ = _tmp26_->priv->_TransmissionMode;
		_tmp28_ = self->priv->_TransmissionMode;
		_tmp12_ = _tmp27_ == _tmp28_;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		DVBDvbTParameter* _tmp29_ = NULL;
		GstMpegtsDVBCodeRate _tmp30_ = 0;
		GstMpegtsDVBCodeRate _tmp31_ = 0;
		_tmp29_ = tparam;
		_tmp30_ = _tmp29_->priv->_CodeRateHP;
		_tmp31_ = self->priv->_CodeRateHP;
		_tmp11_ = _tmp30_ == _tmp31_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		DVBDvbTParameter* _tmp32_ = NULL;
		GstMpegtsDVBCodeRate _tmp33_ = 0;
		GstMpegtsDVBCodeRate _tmp34_ = 0;
		_tmp32_ = tparam;
		_tmp33_ = _tmp32_->priv->_CodeRateLP;
		_tmp34_ = self->priv->_CodeRateLP;
		_tmp10_ = _tmp33_ == _tmp34_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		DVBDvbTParameter* _tmp35_ = NULL;
		GstMpegtsModulationType _tmp36_ = 0;
		GstMpegtsModulationType _tmp37_ = 0;
		_tmp35_ = tparam;
		_tmp36_ = _tmp35_->priv->_Constellation;
		_tmp37_ = self->priv->_Constellation;
		_tmp9_ = _tmp36_ == _tmp37_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		DVBDvbTParameter* _tmp38_ = NULL;
		GstMpegtsTerrestrialGuardInterval _tmp39_ = 0;
		GstMpegtsTerrestrialGuardInterval _tmp40_ = 0;
		_tmp38_ = tparam;
		_tmp39_ = _tmp38_->priv->_GuardInterval;
		_tmp40_ = self->priv->_GuardInterval;
		_tmp8_ = _tmp39_ == _tmp40_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		result = TRUE;
		_g_object_unref0 (tparam);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (tparam);
	return result;
}


static void dvb_dvb_tparameter_real_prepare (DVBParameter* base, GstElement* source) {
	DVBDvbTParameter * self;
	DVBLoggingLogger* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	GstElement* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GstElement* _tmp6_ = NULL;
	GstMpegtsTerrestrialHierarchy _tmp7_ = 0;
	GstElement* _tmp8_ = NULL;
	GstMpegtsModulationType _tmp9_ = 0;
	GstElement* _tmp10_ = NULL;
	GstMpegtsDVBCodeRate _tmp11_ = 0;
	GstElement* _tmp12_ = NULL;
	GstMpegtsDVBCodeRate _tmp13_ = 0;
	GstElement* _tmp14_ = NULL;
	GstMpegtsTerrestrialGuardInterval _tmp15_ = 0;
	GstElement* _tmp16_ = NULL;
	GstMpegtsTerrestrialTransmissionMode _tmp17_ = 0;
	GstElement* _tmp18_ = NULL;
	DVBDvbSrcDelsys _tmp19_ = 0;
	DVBDvbSrcDelsys _tmp20_ = 0;
	self = (DVBDvbTParameter*) base;
	g_return_if_fail (source != NULL);
	_tmp0_ = dvb_dvb_tparameter_log;
	dvb_logging_logger_debug (_tmp0_, "DvbTParameter.vala:125: Prepare DVB-T Scanning Parameter");
	_tmp1_ = source;
	_tmp2_ = dvb_parameter_get_Frequency ((DVBParameter*) self);
	_tmp3_ = _tmp2_;
	g_object_set ((GObject*) _tmp1_, "frequency", _tmp3_, NULL);
	_tmp4_ = source;
	_tmp5_ = self->priv->_Bandwidth;
	g_object_set ((GObject*) _tmp4_, "bandwidth-hz", _tmp5_, NULL);
	_tmp6_ = source;
	_tmp7_ = self->priv->_Hierarchy;
	g_object_set ((GObject*) _tmp6_, "hierarchy", _tmp7_, NULL);
	_tmp8_ = source;
	_tmp9_ = self->priv->_Constellation;
	g_object_set ((GObject*) _tmp8_, "modulation", _tmp9_, NULL);
	_tmp10_ = source;
	_tmp11_ = self->priv->_CodeRateHP;
	g_object_set ((GObject*) _tmp10_, "code-rate-hp", _tmp11_, NULL);
	_tmp12_ = source;
	_tmp13_ = self->priv->_CodeRateLP;
	g_object_set ((GObject*) _tmp12_, "code-rate-lp", _tmp13_, NULL);
	_tmp14_ = source;
	_tmp15_ = self->priv->_GuardInterval;
	g_object_set ((GObject*) _tmp14_, "guard", _tmp15_, NULL);
	_tmp16_ = source;
	_tmp17_ = self->priv->_TransmissionMode;
	g_object_set ((GObject*) _tmp16_, "trans-mode", _tmp17_, NULL);
	_tmp18_ = source;
	_tmp19_ = dvb_parameter_get_Delsys ((DVBParameter*) self);
	_tmp20_ = _tmp19_;
	g_object_set ((GObject*) _tmp18_, "delsys", _tmp20_, NULL);
}


static gchar* dvb_dvb_tparameter_real_to_string (DVBParameter* base) {
	DVBDvbTParameter * self;
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GstMpegtsDVBCodeRate _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GstMpegtsDVBCodeRate _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GstMpegtsModulationType _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GstMpegtsTerrestrialTransmissionMode _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GstMpegtsTerrestrialGuardInterval _tmp15_ = 0;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GstMpegtsTerrestrialHierarchy _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	self = (DVBDvbTParameter*) base;
	_tmp0_ = dvb_parameter_get_Frequency ((DVBParameter*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_Bandwidth;
	_tmp3_ = self->priv->_CodeRateLP;
	_tmp4_ = dvb_getCodeRateString (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_CodeRateHP;
	_tmp7_ = dvb_getCodeRateString (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_Constellation;
	_tmp10_ = dvb_getModulationString (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->_TransmissionMode;
	_tmp13_ = dvb_getTransmissionModeString (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_GuardInterval;
	_tmp16_ = dvb_getGuardIntervalString (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->_Hierarchy;
	_tmp19_ = dvb_getHierarchyString (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf ("DVBT:%u:%u:%s:%s:%s:%s:%s:%s", _tmp1_, _tmp2_, _tmp5_, _tmp8_, _tmp11_, _tmp14_, _tmp17_, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	result = _tmp22_;
	return result;
}


guint dvb_dvb_tparameter_get_Bandwidth (DVBDvbTParameter* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_Bandwidth;
	result = _tmp0_;
	return result;
}


static void dvb_dvb_tparameter_set_Bandwidth (DVBDvbTParameter* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Bandwidth = _tmp0_;
	g_object_notify ((GObject *) self, "Bandwidth");
}


GstMpegtsTerrestrialGuardInterval dvb_dvb_tparameter_get_GuardInterval (DVBDvbTParameter* self) {
	GstMpegtsTerrestrialGuardInterval result;
	GstMpegtsTerrestrialGuardInterval _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_GuardInterval;
	result = _tmp0_;
	return result;
}


static void dvb_dvb_tparameter_set_GuardInterval (DVBDvbTParameter* self, GstMpegtsTerrestrialGuardInterval value) {
	GstMpegtsTerrestrialGuardInterval _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_GuardInterval = _tmp0_;
	g_object_notify ((GObject *) self, "GuardInterval");
}


GstMpegtsTerrestrialTransmissionMode dvb_dvb_tparameter_get_TransmissionMode (DVBDvbTParameter* self) {
	GstMpegtsTerrestrialTransmissionMode result;
	GstMpegtsTerrestrialTransmissionMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_TransmissionMode;
	result = _tmp0_;
	return result;
}


static void dvb_dvb_tparameter_set_TransmissionMode (DVBDvbTParameter* self, GstMpegtsTerrestrialTransmissionMode value) {
	GstMpegtsTerrestrialTransmissionMode _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_TransmissionMode = _tmp0_;
	g_object_notify ((GObject *) self, "TransmissionMode");
}


GstMpegtsTerrestrialHierarchy dvb_dvb_tparameter_get_Hierarchy (DVBDvbTParameter* self) {
	GstMpegtsTerrestrialHierarchy result;
	GstMpegtsTerrestrialHierarchy _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_Hierarchy;
	result = _tmp0_;
	return result;
}


static void dvb_dvb_tparameter_set_Hierarchy (DVBDvbTParameter* self, GstMpegtsTerrestrialHierarchy value) {
	GstMpegtsTerrestrialHierarchy _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Hierarchy = _tmp0_;
	g_object_notify ((GObject *) self, "Hierarchy");
}


GstMpegtsModulationType dvb_dvb_tparameter_get_Constellation (DVBDvbTParameter* self) {
	GstMpegtsModulationType result;
	GstMpegtsModulationType _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_Constellation;
	result = _tmp0_;
	return result;
}


static void dvb_dvb_tparameter_set_Constellation (DVBDvbTParameter* self, GstMpegtsModulationType value) {
	GstMpegtsModulationType _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_Constellation = _tmp0_;
	g_object_notify ((GObject *) self, "Constellation");
}


GstMpegtsDVBCodeRate dvb_dvb_tparameter_get_CodeRateLP (DVBDvbTParameter* self) {
	GstMpegtsDVBCodeRate result;
	GstMpegtsDVBCodeRate _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_CodeRateLP;
	result = _tmp0_;
	return result;
}


static void dvb_dvb_tparameter_set_CodeRateLP (DVBDvbTParameter* self, GstMpegtsDVBCodeRate value) {
	GstMpegtsDVBCodeRate _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_CodeRateLP = _tmp0_;
	g_object_notify ((GObject *) self, "CodeRateLP");
}


GstMpegtsDVBCodeRate dvb_dvb_tparameter_get_CodeRateHP (DVBDvbTParameter* self) {
	GstMpegtsDVBCodeRate result;
	GstMpegtsDVBCodeRate _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_CodeRateHP;
	result = _tmp0_;
	return result;
}


static void dvb_dvb_tparameter_set_CodeRateHP (DVBDvbTParameter* self, GstMpegtsDVBCodeRate value) {
	GstMpegtsDVBCodeRate _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_CodeRateHP = _tmp0_;
	g_object_notify ((GObject *) self, "CodeRateHP");
}


static void dvb_dvb_tparameter_class_init (DVBDvbTParameterClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_dvb_tparameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDvbTParameterPrivate));
	((DVBParameterClass *) klass)->add_scanning_data = dvb_dvb_tparameter_real_add_scanning_data;
	((DVBParameterClass *) klass)->equal = dvb_dvb_tparameter_real_equal;
	((DVBParameterClass *) klass)->prepare = dvb_dvb_tparameter_real_prepare;
	((DVBParameterClass *) klass)->to_string = dvb_dvb_tparameter_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_dvb_tparameter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_dvb_tparameter_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_dvb_tparameter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DVB_TPARAMETER_BANDWIDTH, g_param_spec_uint ("Bandwidth", "Bandwidth", "Bandwidth", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DVB_TPARAMETER_GUARD_INTERVAL, g_param_spec_int ("GuardInterval", "GuardInterval", "GuardInterval", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DVB_TPARAMETER_TRANSMISSION_MODE, g_param_spec_int ("TransmissionMode", "TransmissionMode", "TransmissionMode", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DVB_TPARAMETER_HIERARCHY, g_param_spec_int ("Hierarchy", "Hierarchy", "Hierarchy", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DVB_TPARAMETER_CONSTELLATION, g_param_spec_int ("Constellation", "Constellation", "Constellation", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DVB_TPARAMETER_CODE_RATE_LP, g_param_spec_int ("CodeRateLP", "CodeRateLP", "CodeRateLP", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DVB_TPARAMETER_CODE_RATE_HP, g_param_spec_int ("CodeRateHP", "CodeRateHP", "CodeRateHP", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_dvb_tparameter_log = _tmp1_;
}


static void dvb_dvb_tparameter_instance_init (DVBDvbTParameter * self) {
	self->priv = DVB_DVB_TPARAMETER_GET_PRIVATE (self);
}


static void dvb_dvb_tparameter_finalize (GObject* obj) {
	DVBDvbTParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter);
	G_OBJECT_CLASS (dvb_dvb_tparameter_parent_class)->finalize (obj);
}


GType dvb_dvb_tparameter_get_type (void) {
	static volatile gsize dvb_dvb_tparameter_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_dvb_tparameter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDvbTParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_dvb_tparameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDvbTParameter), 0, (GInstanceInitFunc) dvb_dvb_tparameter_instance_init, NULL };
		GType dvb_dvb_tparameter_type_id;
		dvb_dvb_tparameter_type_id = g_type_register_static (DVB_TYPE_PARAMETER, "DVBDvbTParameter", &g_define_type_info, 0);
		g_once_init_leave (&dvb_dvb_tparameter_type_id__volatile, dvb_dvb_tparameter_type_id);
	}
	return dvb_dvb_tparameter_type_id__volatile;
}


static void _vala_dvb_dvb_tparameter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDvbTParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter);
	switch (property_id) {
		case DVB_DVB_TPARAMETER_BANDWIDTH:
		g_value_set_uint (value, dvb_dvb_tparameter_get_Bandwidth (self));
		break;
		case DVB_DVB_TPARAMETER_GUARD_INTERVAL:
		g_value_set_int (value, dvb_dvb_tparameter_get_GuardInterval (self));
		break;
		case DVB_DVB_TPARAMETER_TRANSMISSION_MODE:
		g_value_set_int (value, dvb_dvb_tparameter_get_TransmissionMode (self));
		break;
		case DVB_DVB_TPARAMETER_HIERARCHY:
		g_value_set_int (value, dvb_dvb_tparameter_get_Hierarchy (self));
		break;
		case DVB_DVB_TPARAMETER_CONSTELLATION:
		g_value_set_int (value, dvb_dvb_tparameter_get_Constellation (self));
		break;
		case DVB_DVB_TPARAMETER_CODE_RATE_LP:
		g_value_set_int (value, dvb_dvb_tparameter_get_CodeRateLP (self));
		break;
		case DVB_DVB_TPARAMETER_CODE_RATE_HP:
		g_value_set_int (value, dvb_dvb_tparameter_get_CodeRateHP (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_dvb_tparameter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBDvbTParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter);
	switch (property_id) {
		case DVB_DVB_TPARAMETER_BANDWIDTH:
		dvb_dvb_tparameter_set_Bandwidth (self, g_value_get_uint (value));
		break;
		case DVB_DVB_TPARAMETER_GUARD_INTERVAL:
		dvb_dvb_tparameter_set_GuardInterval (self, g_value_get_int (value));
		break;
		case DVB_DVB_TPARAMETER_TRANSMISSION_MODE:
		dvb_dvb_tparameter_set_TransmissionMode (self, g_value_get_int (value));
		break;
		case DVB_DVB_TPARAMETER_HIERARCHY:
		dvb_dvb_tparameter_set_Hierarchy (self, g_value_get_int (value));
		break;
		case DVB_DVB_TPARAMETER_CONSTELLATION:
		dvb_dvb_tparameter_set_Constellation (self, g_value_get_int (value));
		break;
		case DVB_DVB_TPARAMETER_CODE_RATE_LP:
		dvb_dvb_tparameter_set_CodeRateLP (self, g_value_get_int (value));
		break;
		case DVB_DVB_TPARAMETER_CODE_RATE_HP:
		dvb_dvb_tparameter_set_CodeRateHP (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



