/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.testng.ITestNGMethod;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IConfiguration;
import org.testng.internal.annotations.ITest;

public class ConfigurationMethod
extends BaseTestMethod {
    private final boolean m_isBeforeSuiteConfiguration;
    private final boolean m_isAfterSuiteConfiguration;
    private final boolean m_isBeforeTestConfiguration;
    private final boolean m_isAfterTestConfiguration;
    private final boolean m_isBeforeClassConfiguration;
    private final boolean m_isAfterClassConfiguration;
    private final boolean m_isBeforeMethodConfiguration;
    private final boolean m_isAfterMethodConfiguration;
    private boolean m_inheritGroupsFromTestClass = false;

    public ConfigurationMethod(Method method, IAnnotationFinder annotationFinder, boolean isBeforeSuite, boolean isAfterSuite, boolean isBeforeTest, boolean isAfterTest, boolean isBeforeClass, boolean isAfterClass, boolean isBeforeMethod, boolean isAfterMethod) {
        super(method, annotationFinder);
        this.init();
        this.m_isBeforeSuiteConfiguration = isBeforeSuite;
        this.m_isAfterSuiteConfiguration = isAfterSuite;
        this.m_isBeforeTestConfiguration = isBeforeTest;
        this.m_isAfterTestConfiguration = isAfterSuite;
        this.m_isBeforeClassConfiguration = isBeforeClass;
        this.m_isAfterClassConfiguration = isAfterClass;
        this.m_isBeforeMethodConfiguration = isBeforeMethod;
        this.m_isAfterMethodConfiguration = isAfterMethod;
    }

    public static ITestNGMethod[] createSuiteConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore) {
        ITestNGMethod[] result = new ITestNGMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new ConfigurationMethod(methods[i].getMethod(), annotationFinder, isBefore, !isBefore, false, false, false, false, false, false);
        }
        return result;
    }

    public static ITestNGMethod[] createTestConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore) {
        ITestNGMethod[] result = new ITestNGMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new ConfigurationMethod(methods[i].getMethod(), annotationFinder, false, false, isBefore, !isBefore, false, false, false, false);
        }
        return result;
    }

    public static ITestNGMethod[] createClassConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore) {
        ITestNGMethod[] result = new ITestNGMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new ConfigurationMethod(methods[i].getMethod(), annotationFinder, false, false, false, false, isBefore, !isBefore, false, false);
        }
        return result;
    }

    public static ITestNGMethod[] createTestMethodConfigurationMethods(ITestNGMethod[] methods, IAnnotationFinder annotationFinder, boolean isBefore) {
        ITestNGMethod[] result = new ITestNGMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            result[i] = new ConfigurationMethod(methods[i].getMethod(), annotationFinder, false, false, false, false, false, false, isBefore, !isBefore);
        }
        return result;
    }

    public boolean isAfterClassConfiguration() {
        return this.m_isAfterClassConfiguration;
    }

    public boolean isAfterMethodConfiguration() {
        return this.m_isAfterMethodConfiguration;
    }

    public boolean isBeforeClassConfiguration() {
        return this.m_isBeforeClassConfiguration;
    }

    public boolean isBeforeMethodConfiguration() {
        return this.m_isBeforeMethodConfiguration;
    }

    public boolean isAfterSuiteConfiguration() {
        return this.m_isAfterSuiteConfiguration;
    }

    public boolean isBeforeSuiteConfiguration() {
        return this.m_isBeforeSuiteConfiguration;
    }

    public boolean isBeforeTestConfiguration() {
        return this.m_isBeforeTestConfiguration;
    }

    public boolean isAfterTestConfiguration() {
        return this.m_isAfterTestConfiguration;
    }

    private boolean inheritGroupsFromTestClass() {
        return this.m_inheritGroupsFromTestClass;
    }

    private void init() {
        ITest classAnnotation;
        IAnnotation a = this.m_annotationFinder.findAnnotation(this.m_method, IConfiguration.class);
        IConfiguration annotation = (IConfiguration)a;
        if (a != null) {
            this.m_inheritGroupsFromTestClass = annotation.getInheritGroups();
            this.setDescription(annotation.getDescription());
        }
        this.initGroups(IConfiguration.class);
        if (this.inheritGroupsFromTestClass() && (classAnnotation = (ITest)this.m_annotationFinder.findAnnotation(this.m_methodClass, ITest.class)) != null) {
            String[] groups = classAnnotation.getGroups();
            HashMap<String, String> newGroups = new HashMap<String, String>();
            for (String g : this.getGroups()) {
                newGroups.put(g, g);
            }
            if (groups != null) {
                for (String g : groups) {
                    newGroups.put(g, g);
                }
                this.setGroups(newGroups.values().toArray(new String[newGroups.size()]));
            }
        }
    }

    private static void ppp(String s) {
        System.out.println("[ConfigurationMethod] " + s);
    }
}

