/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.util.List;
import junit.framework.AssertionFailedError;
import org.jmock.core.Constraint;
import org.jmock.core.DynamicMock;
import org.jmock.core.DynamicMockError;
import org.jmock.core.Formatting;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationDispatcher;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.InvocationMocker;
import org.jmock.core.Invokable;
import org.jmock.core.LIFOInvocationDispatcher;
import org.jmock.core.Stub;
import org.jmock.core.constraint.IsAnything;
import org.jmock.core.matcher.ArgumentsMatcher;
import org.jmock.core.matcher.MethodNameMatcher;
import org.jmock.core.matcher.NoArgumentsMatcher;
import org.jmock.core.stub.CustomStub;
import org.jmock.core.stub.ReturnStub;

public abstract class AbstractDynamicMock
implements DynamicMock {
    private InvocationDispatcher invocationDispatcher;
    private Class mockedType;
    private String name;
    private DynamicMockError failure = null;
    private static final InvocationMocker.Describer NO_DESCRIPTION = new InvocationMocker.Describer(){

        public boolean hasDescription() {
            return false;
        }

        public void describeTo(StringBuffer buffer, List matchers, Stub stub, String name) {
        }
    };

    public AbstractDynamicMock(Class mockedType, String name) {
        this(mockedType, name, new LIFOInvocationDispatcher());
    }

    public AbstractDynamicMock(Class mockedType, String name, InvocationDispatcher invocationDispatcher) {
        this.mockedType = mockedType;
        this.name = name;
        this.invocationDispatcher = invocationDispatcher;
        this.setupDefaultBehaviour();
    }

    public abstract Object proxy();

    public Class getMockedType() {
        return this.mockedType;
    }

    public void setDefaultStub(Stub newDefaultStub) {
        this.invocationDispatcher.setDefaultStub(newDefaultStub);
    }

    public void addInvokable(Invokable invokable) {
        this.invocationDispatcher.add(invokable);
    }

    public void reset() {
        this.invocationDispatcher.clear();
        this.forgetFailure();
        this.setupDefaultBehaviour();
    }

    public void verify() {
        this.forgetFailure();
        try {
            this.invocationDispatcher.verify();
        }
        catch (AssertionFailedError ex) {
            throw new AssertionFailedError("mock object " + this.name + ": " + ex.getMessage());
        }
    }

    public String toString() {
        return this.name;
    }

    public String getMockName() {
        return this.name;
    }

    public static String mockNameFromClass(Class c) {
        return "mock" + Formatting.classShortName(c);
    }

    protected Object mockInvocation(Invocation invocation) throws Throwable {
        if (this.failure != null && invocation.invokedMethod.getDeclaringClass() != Object.class) {
            throw this.failure;
        }
        try {
            Object result = this.invocationDispatcher.dispatch(invocation);
            invocation.checkReturnTypeCompatibility(result);
            return result;
        }
        catch (AssertionFailedError error) {
            this.failure = new DynamicMockError(this, invocation, this.invocationDispatcher, error.getMessage());
            this.failure.fillInStackTrace();
            throw this.failure;
        }
    }

    private void setupDefaultBehaviour() {
        this.addInvokable(this.hiddenInvocationMocker("toString", NoArgumentsMatcher.INSTANCE, new ReturnStub(this.name)));
        this.addInvokable(this.hiddenInvocationMocker("equals", new ArgumentsMatcher(new Constraint[]{new IsAnything()}), new IsSameAsProxyStub()));
        this.addInvokable(this.hiddenInvocationMocker("hashCode", NoArgumentsMatcher.INSTANCE, new HashCodeStub()));
    }

    private void forgetFailure() {
        this.failure = null;
    }

    private InvocationMocker hiddenInvocationMocker(String methodName, InvocationMatcher arguments, Stub stub) {
        InvocationMocker invocationMocker = new InvocationMocker(NO_DESCRIPTION);
        invocationMocker.addMatcher(new MethodNameMatcher(methodName));
        invocationMocker.addMatcher(arguments);
        invocationMocker.setStub(stub);
        return invocationMocker;
    }

    private class HashCodeStub
    extends CustomStub {
        public HashCodeStub() {
            super("returns hashCode for proxy");
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return new Integer(AbstractDynamicMock.this.hashCode());
        }
    }

    private class IsSameAsProxyStub
    extends CustomStub {
        public IsSameAsProxyStub() {
            super("returns whether equal to proxy");
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return new Boolean(invocation.parameterValues.get(0) == AbstractDynamicMock.this.proxy());
        }
    }
}

