/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "skkdicconversion.h"


#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#ifdef HAVE_GETTEXT
  #include <libintl.h>
  #define _(String) dgettext(GETTEXT_PACKAGE,String)
  #define N_(String) (String)
#else
  #define _(String) (String)
  #define N_(String) (String)
  #define bindtextdomain(Package,Directory)
  #define textdomain(domain)
  #define bind_textdomain_codeset(domain,codeset)
#endif

// プライグイン化のおまじないです。
HonokaPluginRegister(SKKDicConversion);
HonokaPluginSetup(SKKDicConversion);

HonokaSetupCorePage *SKKDicConversion::setup()
{
    bindtextdomain (GETTEXT_PACKAGE, HONOKA_LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    HonokaSetupPage *page = new HonokaSetupPage(_("SKKDic-plugin"),"","");
    page->append(new HonokaSetupFileItem(
        _("_SKKDic file: "),
        HONOKA_CONFIG_SKKDIC_DICFILE,
        _("set SKKDic file in this entry."),
        HONOKA_DEFAULT_SKKDIC_DICFILE
    ));
    HonokaSetupPage *sc = new HonokaSetupPage(_("shortcut keys: "),"","");
    sc->append(new HonokaSetupKeyItem(
        _("SKKDic: "),
        String(HONOKA_CONFIG_KEY_CONVERTOR_PREFIX) + String("/SKKDic"),
        "",
        ""
    ));
    page->append(sc);

    return page;
};

SKKDicConversion::SKKDicConversion(ConfigPointer cfg) : Convertor(cfg)
{
    bindtextdomain (GETTEXT_PACKAGE, HONOKA_LOCALEDIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    String file = cfg->read(String(HONOKA_CONFIG_SKKDIC_DICFILE),
            String(HONOKA_DEFAULT_SKKDIC_DICFILE));
    dic = new SKKDic(file);
    pos = 0;
}


SKKDicConversion::~SKKDicConversion()
{
    delete(dic);
}

bool SKKDicConversion::isConnected() {
    return true;
}

void SKKDicConversion::reset(){
    buns.clear();
    texts.clear();
    pos = 0;
    return;
}

void SKKDicConversion::setYomiText(WideString yomi) {
    buns.clear();
    texts.clear();
    pos = 0;
    buns.push_back(yomi);
    return;
}

int SKKDicConversion::ren_conversion() {
    texts.push_back(buns[0]);
    pos = 0;
    return 1;
}

const vector<Segment> SKKDicConversion::getSegmentList() {
    vector<Segment> result;
    for(unsigned int i = 0;i < texts.size();i ++) result.push_back(Segment(texts[i],buns[i]));
    return result;
}

int SKKDicConversion::setPos(int p){
    if ((p >= 0) && (p < buns.size())) pos = p;
    return pos;
}

int SKKDicConversion::getPos() {
    return pos;
}

ResultList SKKDicConversion::getResultList(int p,ResultType kt){
    list.Yomi.clear();
    list.kouho.clear();
    list.Title = utf8_mbstowcs(String(_("lookup result")));
    //list.count = 0;
    ResultEntry e;
    if (kt != DEFAULT) return list;
    if (p == -1) p = pos;
    else if (setPos(p) != p) return list;
    e.kanji = buns[pos];
    list.Yomi = buns[pos];
    list.kouho.push_back(e);
    //list.count = 1;
    vector<SKKDicEntryData> es = dic->find(buns[p]);
    for(unsigned int i = 0;i < es.size();i ++) {
        e.label.clear();
        e.kanji = es[i].kouho;
        if (es[i].annotation.length()) {
            e.label = es[i].kouho + utf8_mbstowcs(" (") + es[i].annotation + utf8_mbstowcs(")");
        }
        list.kouho.push_back(e);
    }
    //list.count = list.kouho.size();
    return list;
}


bool SKKDicConversion::select(int p) {
    if ((p < list.kouho.size()) && (p >= 0)) {
        texts[pos] = list.kouho[p].kanji;
        return true;
    }
    return false;
}

bool SKKDicConversion::resizeRegion(int w) {
    if ((buns[pos].length() + w) < 1) return false;
    if ((pos >= (buns.size() - 1)) && (w > 0)) return false;
    
    int s = buns[pos].length();
    WideString t;
    vector<WideString> ws;
    for(unsigned int i = pos;i < buns.size();i ++) t = t + buns[i];
    for(unsigned int i = 0;i < pos;i ++) {
        ws.push_back(buns[i]);
    }
    ws.push_back(t.substr(0,s + w));
    if ((s + w) < t.length()) ws.push_back(t.substr(s + w));
    buns.clear();
    texts.clear();
    buns = ws;
    texts = ws;
    return true;
}

void SKKDicConversion::updateFrequency() {
    return;
}

bool SKKDicConversion::connect() {
    return true;
}
void SKKDicConversion::disconnect() {
    return;
}


String SKKDicConversion::getName()
{
    return String("SKKDic");
}

String SKKDicConversion::getPropertyName()
{
    return String(_("SKKDic"));
}
