// -*- c-basic-offset: 4 -*-

/** @file emor.cpp
 *
 *  $Id$
 *
 *
 * Copyright (c) 2004 Computer Vision Laboratory, Columbia University
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * The EMoR model is described in this paper
 *  "Modeling the Space of Camera Response Functions,"
 *  M.D. Grossberg and S.K. Nayar,
 *  IEEE Transactions on Pattern Analysis and Machine Intelligence,
 *  Vol.26, No.10, pp.1272-1282, Oct, 2004.
 */

#include <vigra_ext/emor.h>

double vigra_ext::EMoR::f0[1024] =
{
    0.000000e+00, 8.833750e-03, 1.497601e-02, 2.023710e-02, 2.498590e-02, 2.937536e-02, 3.348347e-02, 3.740247e-02, 
    4.116645e-02, 4.481240e-02, 4.835121e-02, 5.178991e-02, 5.514774e-02, 5.843527e-02, 6.167138e-02, 6.485830e-02, 
    6.799864e-02, 7.109369e-02, 7.414113e-02, 7.714684e-02, 8.011208e-02, 8.303313e-02, 8.591695e-02, 8.876004e-02, 
    9.156913e-02, 9.434381e-02, 9.708718e-02, 9.980128e-02, 1.024881e-01, 1.051487e-01, 1.077847e-01, 1.103984e-01, 
    1.129923e-01, 1.155692e-01, 1.181306e-01, 1.206751e-01, 1.232042e-01, 1.257223e-01, 1.282268e-01, 1.307177e-01, 
    1.331949e-01, 1.356606e-01, 1.381127e-01, 1.405497e-01, 1.429754e-01, 1.453869e-01, 1.477816e-01, 1.501633e-01, 
    1.525314e-01, 1.548870e-01, 1.572343e-01, 1.595739e-01, 1.619041e-01, 1.642287e-01, 1.665419e-01, 1.688466e-01, 
    1.711441e-01, 1.734281e-01, 1.757041e-01, 1.779716e-01, 1.802266e-01, 1.824685e-01, 1.847028e-01, 1.869270e-01, 
    1.891430e-01, 1.913527e-01, 1.935541e-01, 1.957470e-01, 1.979323e-01, 2.001116e-01, 2.022840e-01, 2.044483e-01, 
    2.066046e-01, 2.087546e-01, 2.108964e-01, 2.130336e-01, 2.151646e-01, 2.172897e-01, 2.194090e-01, 2.215230e-01, 
    2.236334e-01, 2.257399e-01, 2.278428e-01, 2.299395e-01, 2.320352e-01, 2.341277e-01, 2.362148e-01, 2.383003e-01, 
    2.403819e-01, 2.424598e-01, 2.445341e-01, 2.466031e-01, 2.486695e-01, 2.507313e-01, 2.527875e-01, 2.548405e-01, 
    2.568878e-01, 2.589288e-01, 2.609657e-01, 2.629976e-01, 2.650239e-01, 2.670452e-01, 2.690614e-01, 2.710740e-01, 
    2.730820e-01, 2.750845e-01, 2.770829e-01, 2.790768e-01, 2.810665e-01, 2.830520e-01, 2.850325e-01, 2.870062e-01, 
    2.889752e-01, 2.909403e-01, 2.929002e-01, 2.948523e-01, 2.967999e-01, 2.987424e-01, 3.006780e-01, 3.026081e-01, 
    3.045304e-01, 3.064477e-01, 3.083587e-01, 3.102641e-01, 3.121645e-01, 3.140588e-01, 3.159478e-01, 3.178321e-01, 
    3.197115e-01, 3.215854e-01, 3.234539e-01, 3.253173e-01, 3.271750e-01, 3.290263e-01, 3.308733e-01, 3.327147e-01, 
    3.345507e-01, 3.363827e-01, 3.382077e-01, 3.400275e-01, 3.418430e-01, 3.436523e-01, 3.454572e-01, 3.472560e-01, 
    3.490492e-01, 3.508357e-01, 3.526168e-01, 3.543927e-01, 3.561617e-01, 3.579243e-01, 3.596821e-01, 3.614338e-01, 
    3.631794e-01, 3.649187e-01, 3.666514e-01, 3.683797e-01, 3.701042e-01, 3.718237e-01, 3.735390e-01, 3.752482e-01, 
    3.769527e-01, 3.786515e-01, 3.803469e-01, 3.820369e-01, 3.837210e-01, 3.853998e-01, 3.870728e-01, 3.887416e-01, 
    3.904061e-01, 3.920668e-01, 3.937225e-01, 3.953728e-01, 3.970202e-01, 3.986625e-01, 4.003001e-01, 4.019333e-01, 
    4.035619e-01, 4.051867e-01, 4.068054e-01, 4.084197e-01, 4.100310e-01, 4.116374e-01, 4.132398e-01, 4.148394e-01, 
    4.164354e-01, 4.180263e-01, 4.196143e-01, 4.211982e-01, 4.227779e-01, 4.243544e-01, 4.259255e-01, 4.274937e-01, 
    4.290582e-01, 4.306178e-01, 4.321742e-01, 4.337241e-01, 4.352709e-01, 4.368133e-01, 4.383513e-01, 4.398857e-01, 
    4.414162e-01, 4.429419e-01, 4.444639e-01, 4.459815e-01, 4.474938e-01, 4.490017e-01, 4.505049e-01, 4.520032e-01, 
    4.534963e-01, 4.549859e-01, 4.564702e-01, 4.579507e-01, 4.594252e-01, 4.608951e-01, 4.623603e-01, 4.638208e-01, 
    4.652769e-01, 4.667274e-01, 4.681745e-01, 4.696162e-01, 4.710546e-01, 4.724894e-01, 4.739204e-01, 4.753461e-01, 
    4.767679e-01, 4.781860e-01, 4.795997e-01, 4.810095e-01, 4.824153e-01, 4.838171e-01, 4.852141e-01, 4.866072e-01, 
    4.879966e-01, 4.893811e-01, 4.907610e-01, 4.921370e-01, 4.935079e-01, 4.948743e-01, 4.962369e-01, 4.975940e-01, 
    4.989463e-01, 5.002944e-01, 5.016375e-01, 5.029762e-01, 5.043101e-01, 5.056411e-01, 5.069678e-01, 5.082890e-01, 
    5.096068e-01, 5.109207e-01, 5.122312e-01, 5.135380e-01, 5.148395e-01, 5.161376e-01, 5.174326e-01, 5.187239e-01, 
    5.200108e-01, 5.212956e-01, 5.225765e-01, 5.238539e-01, 5.251270e-01, 5.263976e-01, 5.276647e-01, 5.289288e-01, 
    5.301895e-01, 5.314460e-01, 5.326988e-01, 5.339488e-01, 5.351959e-01, 5.364394e-01, 5.376781e-01, 5.389128e-01, 
    5.401439e-01, 5.413711e-01, 5.425948e-01, 5.438155e-01, 5.450334e-01, 5.462481e-01, 5.474585e-01, 5.486653e-01, 
    5.498682e-01, 5.510679e-01, 5.522646e-01, 5.534584e-01, 5.546488e-01, 5.558350e-01, 5.570184e-01, 5.581970e-01, 
    5.593729e-01, 5.605464e-01, 5.617169e-01, 5.628855e-01, 5.640514e-01, 5.652144e-01, 5.663742e-01, 5.675307e-01, 
    5.686837e-01, 5.698335e-01, 5.709814e-01, 5.721262e-01, 5.732678e-01, 5.744062e-01, 5.755408e-01, 5.766719e-01, 
    5.777991e-01, 5.789228e-01, 5.800434e-01, 5.811608e-01, 5.822757e-01, 5.833864e-01, 5.844935e-01, 5.855962e-01, 
    5.866946e-01, 5.877900e-01, 5.888820e-01, 5.899714e-01, 5.910584e-01, 5.921409e-01, 5.932197e-01, 5.942954e-01, 
    5.953670e-01, 5.964353e-01, 5.975001e-01, 5.985620e-01, 5.996207e-01, 6.006759e-01, 6.017287e-01, 6.027787e-01, 
    6.038259e-01, 6.048711e-01, 6.059128e-01, 6.069513e-01, 6.079871e-01, 6.090199e-01, 6.100498e-01, 6.110774e-01, 
    6.121015e-01, 6.131222e-01, 6.141404e-01, 6.151544e-01, 6.161652e-01, 6.171720e-01, 6.181760e-01, 6.191776e-01, 
    6.201763e-01, 6.211720e-01, 6.221657e-01, 6.231560e-01, 6.241430e-01, 6.251274e-01, 6.261093e-01, 6.270888e-01, 
    6.280658e-01, 6.290399e-01, 6.300118e-01, 6.309817e-01, 6.319492e-01, 6.329147e-01, 6.338775e-01, 6.348380e-01, 
    6.357973e-01, 6.367547e-01, 6.377090e-01, 6.386612e-01, 6.396111e-01, 6.405584e-01, 6.415040e-01, 6.424475e-01, 
    6.433883e-01, 6.443268e-01, 6.452632e-01, 6.461974e-01, 6.471300e-01, 6.480595e-01, 6.489846e-01, 6.499076e-01, 
    6.508284e-01, 6.517463e-01, 6.526614e-01, 6.535751e-01, 6.544869e-01, 6.553963e-01, 6.563038e-01, 6.572084e-01, 
    6.581105e-01, 6.590103e-01, 6.599075e-01, 6.608029e-01, 6.616960e-01, 6.625868e-01, 6.634748e-01, 6.643607e-01, 
    6.652449e-01, 6.661269e-01, 6.670068e-01, 6.678847e-01, 6.687603e-01, 6.696338e-01, 6.705051e-01, 6.713738e-01, 
    6.722403e-01, 6.731052e-01, 6.739680e-01, 6.748279e-01, 6.756849e-01, 6.765397e-01, 6.773922e-01, 6.782424e-01, 
    6.790905e-01, 6.799357e-01, 6.807790e-01, 6.816211e-01, 6.824613e-01, 6.832992e-01, 6.841354e-01, 6.849693e-01, 
    6.858009e-01, 6.866306e-01, 6.874586e-01, 6.882845e-01, 6.891088e-01, 6.899312e-01, 6.907522e-01, 6.915713e-01, 
    6.923889e-01, 6.932055e-01, 6.940204e-01, 6.948331e-01, 6.956444e-01, 6.964545e-01, 6.972630e-01, 6.980709e-01, 
    6.988765e-01, 6.996802e-01, 7.004820e-01, 7.012829e-01, 7.020820e-01, 7.028784e-01, 7.036729e-01, 7.044662e-01, 
    7.052567e-01, 7.060448e-01, 7.068312e-01, 7.076163e-01, 7.084000e-01, 7.091818e-01, 7.099615e-01, 7.107392e-01, 
    7.115153e-01, 7.122902e-01, 7.130639e-01, 7.138360e-01, 7.146063e-01, 7.153750e-01, 7.161427e-01, 7.169086e-01, 
    7.176714e-01, 7.184334e-01, 7.191948e-01, 7.199551e-01, 7.207136e-01, 7.214710e-01, 7.222273e-01, 7.229821e-01, 
    7.237351e-01, 7.244873e-01, 7.252385e-01, 7.259878e-01, 7.267357e-01, 7.274823e-01, 7.282280e-01, 7.289722e-01, 
    7.297146e-01, 7.304559e-01, 7.311956e-01, 7.319334e-01, 7.326702e-01, 7.334058e-01, 7.341401e-01, 7.348725e-01, 
    7.356036e-01, 7.363326e-01, 7.370595e-01, 7.377838e-01, 7.385062e-01, 7.392276e-01, 7.399476e-01, 7.406657e-01, 
    7.413815e-01, 7.420955e-01, 7.428083e-01, 7.435197e-01, 7.442295e-01, 7.449381e-01, 7.456450e-01, 7.463493e-01, 
    7.470524e-01, 7.477545e-01, 7.484556e-01, 7.491544e-01, 7.498516e-01, 7.505475e-01, 7.512428e-01, 7.519365e-01, 
    7.526290e-01, 7.533205e-01, 7.540111e-01, 7.547005e-01, 7.553885e-01, 7.560757e-01, 7.567612e-01, 7.574450e-01, 
    7.581269e-01, 7.588078e-01, 7.594872e-01, 7.601647e-01, 7.608397e-01, 7.615131e-01, 7.621848e-01, 7.628556e-01, 
    7.635244e-01, 7.641918e-01, 7.648576e-01, 7.655221e-01, 7.661856e-01, 7.668478e-01, 7.675096e-01, 7.681704e-01, 
    7.688298e-01, 7.694874e-01, 7.701442e-01, 7.708006e-01, 7.714566e-01, 7.721111e-01, 7.727647e-01, 7.734175e-01, 
    7.740696e-01, 7.747209e-01, 7.753715e-01, 7.760213e-01, 7.766698e-01, 7.773165e-01, 7.779616e-01, 7.786055e-01, 
    7.792483e-01, 7.798897e-01, 7.805297e-01, 7.811681e-01, 7.818059e-01, 7.824431e-01, 7.830795e-01, 7.837143e-01, 
    7.843478e-01, 7.849804e-01, 7.856122e-01, 7.862434e-01, 7.868737e-01, 7.875034e-01, 7.881315e-01, 7.887587e-01, 
    7.893850e-01, 7.900109e-01, 7.906364e-01, 7.912619e-01, 7.918865e-01, 7.925099e-01, 7.931321e-01, 7.937540e-01, 
    7.943754e-01, 7.949960e-01, 7.956153e-01, 7.962338e-01, 7.968516e-01, 7.974686e-01, 7.980840e-01, 7.986981e-01, 
    7.993113e-01, 7.999234e-01, 8.005342e-01, 8.011433e-01, 8.017515e-01, 8.023587e-01, 8.029649e-01, 8.035695e-01, 
    8.041722e-01, 8.047736e-01, 8.053747e-01, 8.059753e-01, 8.065749e-01, 8.071730e-01, 8.077706e-01, 8.083676e-01, 
    8.089641e-01, 8.095600e-01, 8.101552e-01, 8.107499e-01, 8.113440e-01, 8.119368e-01, 8.125279e-01, 8.131183e-01, 
    8.137079e-01, 8.142971e-01, 8.148864e-01, 8.154749e-01, 8.160624e-01, 8.166492e-01, 8.172353e-01, 8.178209e-01, 
    8.184058e-01, 8.189893e-01, 8.195708e-01, 8.201507e-01, 8.207299e-01, 8.213078e-01, 8.218841e-01, 8.224596e-01, 
    8.230342e-01, 8.236078e-01, 8.241803e-01, 8.247514e-01, 8.253219e-01, 8.258914e-01, 8.264596e-01, 8.270267e-01, 
    8.275923e-01, 8.281567e-01, 8.287201e-01, 8.292832e-01, 8.298456e-01, 8.304071e-01, 8.309677e-01, 8.315275e-01, 
    8.320871e-01, 8.326465e-01, 8.332050e-01, 8.337630e-01, 8.343207e-01, 8.348772e-01, 8.354332e-01, 8.359882e-01, 
    8.365424e-01, 8.370960e-01, 8.376492e-01, 8.382020e-01, 8.387537e-01, 8.393034e-01, 8.398514e-01, 8.403982e-01, 
    8.409439e-01, 8.414888e-01, 8.420314e-01, 8.425724e-01, 8.431122e-01, 8.436513e-01, 8.441898e-01, 8.447275e-01, 
    8.452641e-01, 8.457995e-01, 8.463338e-01, 8.468673e-01, 8.474001e-01, 8.479313e-01, 8.484619e-01, 8.489916e-01, 
    8.495206e-01, 8.500489e-01, 8.505759e-01, 8.511019e-01, 8.516276e-01, 8.521532e-01, 8.526788e-01, 8.532041e-01, 
    8.537274e-01, 8.542500e-01, 8.547719e-01, 8.552934e-01, 8.558142e-01, 8.563345e-01, 8.568541e-01, 8.573727e-01, 
    8.578908e-01, 8.584080e-01, 8.589247e-01, 8.594402e-01, 8.599549e-01, 8.604689e-01, 8.609809e-01, 8.614913e-01, 
    8.620006e-01, 8.625081e-01, 8.630143e-01, 8.635199e-01, 8.640247e-01, 8.645286e-01, 8.650318e-01, 8.655342e-01, 
    8.660358e-01, 8.665362e-01, 8.670353e-01, 8.675341e-01, 8.680320e-01, 8.685293e-01, 8.690256e-01, 8.695210e-01, 
    8.700148e-01, 8.705079e-01, 8.710004e-01, 8.714923e-01, 8.719839e-01, 8.724751e-01, 8.729660e-01, 8.734568e-01, 
    8.739459e-01, 8.744347e-01, 8.749232e-01, 8.754115e-01, 8.758991e-01, 8.763859e-01, 8.768713e-01, 8.773560e-01, 
    8.778394e-01, 8.783218e-01, 8.788030e-01, 8.792834e-01, 8.797630e-01, 8.802419e-01, 8.807204e-01, 8.811979e-01, 
    8.816744e-01, 8.821505e-01, 8.826258e-01, 8.831009e-01, 8.835756e-01, 8.840499e-01, 8.845239e-01, 8.849976e-01, 
    8.854704e-01, 8.859428e-01, 8.864150e-01, 8.868866e-01, 8.873580e-01, 8.878287e-01, 8.882986e-01, 8.887683e-01, 
    8.892373e-01, 8.897059e-01, 8.901739e-01, 8.906407e-01, 8.911065e-01, 8.915716e-01, 8.920358e-01, 8.924988e-01, 
    8.929612e-01, 8.934233e-01, 8.938844e-01, 8.943450e-01, 8.948051e-01, 8.952646e-01, 8.957233e-01, 8.961818e-01, 
    8.966400e-01, 8.970972e-01, 8.975541e-01, 8.980107e-01, 8.984668e-01, 8.989224e-01, 8.993777e-01, 8.998324e-01, 
    9.002873e-01, 9.007422e-01, 9.011971e-01, 9.016515e-01, 9.021055e-01, 9.025588e-01, 9.030118e-01, 9.034647e-01, 
    9.039173e-01, 9.043691e-01, 9.048198e-01, 9.052697e-01, 9.057189e-01, 9.061676e-01, 9.066155e-01, 9.070628e-01, 
    9.075091e-01, 9.079547e-01, 9.083993e-01, 9.088430e-01, 9.092861e-01, 9.097289e-01, 9.101710e-01, 9.106125e-01, 
    9.110534e-01, 9.114935e-01, 9.119334e-01, 9.123729e-01, 9.128117e-01, 9.132502e-01, 9.136887e-01, 9.141261e-01, 
    9.145633e-01, 9.150005e-01, 9.154379e-01, 9.158750e-01, 9.163116e-01, 9.167482e-01, 9.171846e-01, 9.176209e-01, 
    9.180570e-01, 9.184931e-01, 9.189291e-01, 9.193650e-01, 9.198002e-01, 9.202344e-01, 9.206675e-01, 9.211001e-01, 
    9.215318e-01, 9.219623e-01, 9.223921e-01, 9.228206e-01, 9.232483e-01, 9.236752e-01, 9.241015e-01, 9.245273e-01, 
    9.249527e-01, 9.253776e-01, 9.258018e-01, 9.262260e-01, 9.266500e-01, 9.270736e-01, 9.274966e-01, 9.279189e-01, 
    9.283404e-01, 9.287611e-01, 9.291817e-01, 9.296025e-01, 9.300234e-01, 9.304442e-01, 9.308649e-01, 9.312853e-01, 
    9.317051e-01, 9.321247e-01, 9.325440e-01, 9.329630e-01, 9.333813e-01, 9.337989e-01, 9.342158e-01, 9.346318e-01, 
    9.350470e-01, 9.354616e-01, 9.358757e-01, 9.362891e-01, 9.367019e-01, 9.371142e-01, 9.375252e-01, 9.379359e-01, 
    9.383464e-01, 9.387562e-01, 9.391652e-01, 9.395733e-01, 9.399811e-01, 9.403880e-01, 9.407948e-01, 9.412017e-01, 
    9.416088e-01, 9.420160e-01, 9.424232e-01, 9.428301e-01, 9.432357e-01, 9.436407e-01, 9.440456e-01, 9.444499e-01, 
    9.448543e-01, 9.452587e-01, 9.456630e-01, 9.460668e-01, 9.464702e-01, 9.468731e-01, 9.472752e-01, 9.476769e-01, 
    9.480781e-01, 9.484789e-01, 9.488786e-01, 9.492763e-01, 9.496733e-01, 9.500697e-01, 9.504652e-01, 9.508601e-01, 
    9.512542e-01, 9.516477e-01, 9.520401e-01, 9.524325e-01, 9.528247e-01, 9.532167e-01, 9.536083e-01, 9.539985e-01, 
    9.543878e-01, 9.547762e-01, 9.551640e-01, 9.555517e-01, 9.559390e-01, 9.563265e-01, 9.567139e-01, 9.571011e-01, 
    9.574878e-01, 9.578741e-01, 9.582601e-01, 9.586452e-01, 9.590301e-01, 9.594146e-01, 9.597986e-01, 9.601827e-01, 
    9.605663e-01, 9.609499e-01, 9.613334e-01, 9.617168e-01, 9.621000e-01, 9.624829e-01, 9.628657e-01, 9.632470e-01, 
    9.636274e-01, 9.640080e-01, 9.643889e-01, 9.647693e-01, 9.651495e-01, 9.655296e-01, 9.659094e-01, 9.662882e-01, 
    9.666668e-01, 9.670450e-01, 9.674231e-01, 9.678013e-01, 9.681793e-01, 9.685573e-01, 9.689350e-01, 9.693117e-01, 
    9.696878e-01, 9.700628e-01, 9.704373e-01, 9.708112e-01, 9.711849e-01, 9.715584e-01, 9.719319e-01, 9.723043e-01, 
    9.726759e-01, 9.730465e-01, 9.734168e-01, 9.737866e-01, 9.741559e-01, 9.745245e-01, 9.748921e-01, 9.752583e-01, 
    9.756247e-01, 9.759911e-01, 9.763572e-01, 9.767229e-01, 9.770882e-01, 9.774521e-01, 9.778142e-01, 9.781752e-01, 
    9.785354e-01, 9.788955e-01, 9.792559e-01, 9.796167e-01, 9.799774e-01, 9.803373e-01, 9.806962e-01, 9.810546e-01, 
    9.814132e-01, 9.817717e-01, 9.821283e-01, 9.824845e-01, 9.828408e-01, 9.831978e-01, 9.835534e-01, 9.839081e-01, 
    9.842627e-01, 9.846173e-01, 9.849717e-01, 9.853253e-01, 9.856776e-01, 9.860290e-01, 9.863792e-01, 9.867276e-01, 
    9.870745e-01, 9.874211e-01, 9.877674e-01, 9.881133e-01, 9.884589e-01, 9.888046e-01, 9.891491e-01, 9.894908e-01, 
    9.898319e-01, 9.901736e-01, 9.905145e-01, 9.908552e-01, 9.911950e-01, 9.915323e-01, 9.918691e-01, 9.922037e-01, 
    9.925383e-01, 9.928728e-01, 9.932051e-01, 9.935379e-01, 9.938715e-01, 9.942054e-01, 9.945395e-01, 9.948709e-01, 
    9.952013e-01, 9.955306e-01, 9.958570e-01, 9.961821e-01, 9.965066e-01, 9.968276e-01, 9.971488e-01, 9.974682e-01, 
    9.977856e-01, 9.981028e-01, 9.984198e-01, 9.987365e-01, 9.990528e-01, 9.993689e-01, 9.996846e-01, 1.000000e+00
};

double vigra_ext::EMoR::h[25][1024] =
{
    {
        0.000000e+00, -1.452326e-03, -2.133227e-03, -2.674255e-03, -3.149903e-03, -3.582399e-03, -3.980914e-03, -4.359803e-03, 
        -4.725236e-03, -5.080627e-03, -5.427092e-03, -5.765801e-03, -6.098779e-03, -6.426347e-03, -6.750412e-03, -7.071325e-03, 
        -7.389887e-03, -7.705940e-03, -8.018821e-03, -8.329350e-03, -8.636635e-03, -8.939656e-03, -9.239358e-03, -9.535422e-03, 
        -9.828782e-03, -1.011918e-02, -1.040701e-02, -1.069241e-02, -1.097627e-02, -1.125855e-02, -1.153943e-02, -1.181888e-02, 
        -1.209722e-02, -1.237451e-02, -1.265082e-02, -1.292588e-02, -1.319994e-02, -1.347363e-02, -1.374673e-02, -1.401901e-02, 
        -1.429037e-02, -1.456117e-02, -1.483101e-02, -1.509930e-02, -1.536673e-02, -1.563288e-02, -1.589735e-02, -1.616107e-02, 
        -1.642365e-02, -1.668546e-02, -1.694699e-02, -1.720795e-02, -1.746800e-02, -1.772795e-02, -1.798663e-02, -1.824441e-02, 
        -1.850145e-02, -1.875670e-02, -1.901103e-02, -1.926427e-02, -1.951601e-02, -1.976624e-02, -2.001590e-02, -2.026443e-02, 
        -2.051216e-02, -2.075924e-02, -2.100532e-02, -2.125028e-02, -2.149434e-02, -2.173771e-02, -2.198008e-02, -2.222141e-02, 
        -2.246182e-02, -2.270150e-02, -2.293991e-02, -2.317745e-02, -2.341402e-02, -2.364972e-02, -2.388422e-02, -2.411771e-02, 
        -2.435039e-02, -2.458214e-02, -2.481298e-02, -2.504251e-02, -2.527139e-02, -2.549926e-02, -2.572567e-02, -2.595116e-02, 
        -2.617529e-02, -2.639808e-02, -2.661950e-02, -2.683932e-02, -2.705793e-02, -2.727509e-02, -2.749054e-02, -2.770478e-02, 
        -2.791765e-02, -2.812906e-02, -2.833907e-02, -2.854777e-02, -2.875515e-02, -2.896148e-02, -2.916651e-02, -2.937037e-02, 
        -2.957319e-02, -2.977480e-02, -2.997510e-02, -3.017387e-02, -3.037131e-02, -3.056735e-02, -3.076189e-02, -3.095487e-02, 
        -3.114650e-02, -3.133707e-02, -3.152595e-02, -3.171299e-02, -3.189852e-02, -3.208257e-02, -3.226478e-02, -3.244534e-02, 
        -3.262393e-02, -3.280084e-02, -3.297597e-02, -3.314928e-02, -3.332076e-02, -3.349039e-02, -3.365804e-02, -3.382414e-02, 
        -3.398861e-02, -3.415137e-02, -3.431267e-02, -3.447234e-02, -3.463056e-02, -3.478694e-02, -3.494207e-02, -3.509573e-02, 
        -3.524784e-02, -3.539876e-02, -3.554815e-02, -3.569617e-02, -3.584304e-02, -3.598837e-02, -3.613225e-02, -3.627470e-02, 
        -3.641544e-02, -3.655459e-02, -3.669223e-02, -3.682852e-02, -3.696315e-02, -3.709616e-02, -3.722770e-02, -3.735784e-02, 
        -3.748648e-02, -3.761366e-02, -3.773904e-02, -3.786323e-02, -3.798581e-02, -3.810706e-02, -3.822713e-02, -3.834571e-02, 
        -3.846347e-02, -3.857978e-02, -3.869504e-02, -3.880919e-02, -3.892227e-02, -3.903446e-02, -3.914561e-02, -3.925559e-02, 
        -3.936454e-02, -3.947248e-02, -3.957931e-02, -3.968514e-02, -3.978970e-02, -3.989321e-02, -3.999547e-02, -4.009679e-02, 
        -4.019671e-02, -4.029567e-02, -4.039327e-02, -4.048966e-02, -4.058472e-02, -4.067842e-02, -4.077072e-02, -4.086172e-02, 
        -4.095115e-02, -4.103928e-02, -4.112599e-02, -4.121130e-02, -4.129514e-02, -4.137745e-02, -4.145831e-02, -4.153784e-02, 
        -4.161594e-02, -4.169268e-02, -4.176806e-02, -4.184201e-02, -4.191495e-02, -4.198670e-02, -4.205730e-02, -4.212682e-02, 
        -4.219527e-02, -4.226271e-02, -4.232926e-02, -4.239516e-02, -4.246016e-02, -4.252416e-02, -4.258751e-02, -4.264987e-02, 
        -4.271121e-02, -4.277182e-02, -4.283147e-02, -4.289001e-02, -4.294758e-02, -4.300416e-02, -4.305989e-02, -4.311482e-02, 
        -4.316872e-02, -4.322183e-02, -4.327415e-02, -4.332560e-02, -4.337624e-02, -4.342598e-02, -4.347473e-02, -4.352182e-02, 
        -4.356825e-02, -4.361366e-02, -4.365823e-02, -4.370212e-02, -4.374504e-02, -4.378715e-02, -4.382844e-02, -4.386884e-02, 
        -4.390862e-02, -4.394763e-02, -4.398574e-02, -4.402313e-02, -4.405966e-02, -4.409571e-02, -4.413102e-02, -4.416548e-02, 
        -4.419924e-02, -4.423225e-02, -4.426458e-02, -4.429625e-02, -4.432721e-02, -4.435773e-02, -4.438731e-02, -4.441590e-02, 
        -4.444384e-02, -4.447094e-02, -4.449737e-02, -4.452283e-02, -4.454739e-02, -4.457123e-02, -4.459430e-02, -4.461653e-02, 
        -4.463811e-02, -4.465908e-02, -4.467913e-02, -4.469845e-02, -4.471662e-02, -4.473380e-02, -4.475009e-02, -4.476545e-02, 
        -4.477980e-02, -4.479333e-02, -4.480625e-02, -4.481868e-02, -4.483077e-02, -4.484231e-02, -4.485350e-02, -4.486444e-02, 
        -4.487481e-02, -4.488466e-02, -4.489428e-02, -4.490342e-02, -4.491209e-02, -4.492045e-02, -4.492805e-02, -4.493506e-02, 
        -4.494158e-02, -4.494787e-02, -4.495373e-02, -4.495914e-02, -4.496418e-02, -4.496864e-02, -4.497266e-02, -4.497585e-02, 
        -4.497837e-02, -4.498044e-02, -4.498202e-02, -4.498301e-02, -4.498330e-02, -4.498296e-02, -4.498195e-02, -4.498020e-02, 
        -4.497782e-02, -4.497470e-02, -4.497100e-02, -4.496672e-02, -4.496213e-02, -4.495708e-02, -4.495139e-02, -4.494517e-02, 
        -4.493846e-02, -4.493136e-02, -4.492396e-02, -4.491610e-02, -4.490805e-02, -4.489969e-02, -4.489106e-02, -4.488211e-02, 
        -4.487255e-02, -4.486277e-02, -4.485249e-02, -4.484181e-02, -4.483081e-02, -4.481932e-02, -4.480724e-02, -4.479465e-02, 
        -4.478147e-02, -4.476786e-02, -4.475389e-02, -4.473952e-02, -4.472469e-02, -4.470938e-02, -4.469373e-02, -4.467754e-02, 
        -4.466059e-02, -4.464314e-02, -4.462507e-02, -4.460638e-02, -4.458708e-02, -4.456743e-02, -4.454741e-02, -4.452720e-02, 
        -4.450653e-02, -4.448564e-02, -4.446457e-02, -4.444315e-02, -4.442160e-02, -4.439973e-02, -4.437771e-02, -4.435557e-02, 
        -4.433333e-02, -4.431076e-02, -4.428809e-02, -4.426507e-02, -4.424180e-02, -4.421827e-02, -4.419435e-02, -4.416995e-02, 
        -4.414517e-02, -4.411995e-02, -4.409431e-02, -4.406830e-02, -4.404176e-02, -4.401464e-02, -4.398713e-02, -4.395903e-02, 
        -4.393053e-02, -4.390148e-02, -4.387187e-02, -4.384186e-02, -4.381149e-02, -4.378073e-02, -4.374977e-02, -4.371862e-02, 
        -4.368725e-02, -4.365557e-02, -4.362372e-02, -4.359164e-02, -4.355944e-02, -4.352701e-02, -4.349412e-02, -4.346092e-02, 
        -4.342764e-02, -4.339421e-02, -4.336059e-02, -4.332684e-02, -4.329287e-02, -4.325861e-02, -4.322421e-02, -4.318963e-02, 
        -4.315485e-02, -4.311988e-02, -4.308463e-02, -4.304913e-02, -4.301337e-02, -4.297723e-02, -4.294067e-02, -4.290364e-02, 
        -4.286630e-02, -4.282879e-02, -4.279104e-02, -4.275296e-02, -4.271456e-02, -4.267588e-02, -4.263693e-02, -4.259777e-02, 
        -4.255827e-02, -4.251860e-02, -4.247873e-02, -4.243858e-02, -4.239825e-02, -4.235783e-02, -4.231732e-02, -4.227674e-02, 
        -4.223604e-02, -4.219519e-02, -4.215421e-02, -4.211319e-02, -4.207202e-02, -4.203058e-02, -4.198890e-02, -4.194710e-02, 
        -4.190514e-02, -4.186294e-02, -4.182052e-02, -4.177779e-02, -4.173476e-02, -4.169156e-02, -4.164812e-02, -4.160442e-02, 
        -4.156042e-02, -4.151617e-02, -4.147183e-02, -4.142717e-02, -4.138201e-02, -4.133632e-02, -4.129025e-02, -4.124396e-02, 
        -4.119736e-02, -4.115062e-02, -4.110383e-02, -4.105702e-02, -4.101012e-02, -4.096321e-02, -4.091652e-02, -4.086999e-02, 
        -4.082333e-02, -4.077658e-02, -4.072966e-02, -4.068264e-02, -4.063561e-02, -4.058844e-02, -4.054119e-02, -4.049385e-02, 
        -4.044649e-02, -4.039923e-02, -4.035198e-02, -4.030469e-02, -4.025731e-02, -4.020983e-02, -4.016225e-02, -4.011440e-02, 
        -4.006619e-02, -4.001770e-02, -3.996890e-02, -3.991991e-02, -3.987055e-02, -3.982097e-02, -3.977121e-02, -3.972128e-02, 
        -3.967103e-02, -3.962057e-02, -3.956995e-02, -3.951911e-02, -3.946820e-02, -3.941725e-02, -3.936621e-02, -3.931499e-02, 
        -3.926351e-02, -3.921183e-02, -3.915993e-02, -3.910795e-02, -3.905590e-02, -3.900372e-02, -3.895139e-02, -3.889896e-02, 
        -3.884661e-02, -3.879430e-02, -3.874202e-02, -3.868974e-02, -3.863756e-02, -3.858543e-02, -3.853330e-02, -3.848104e-02, 
        -3.842885e-02, -3.837659e-02, -3.832437e-02, -3.827206e-02, -3.821967e-02, -3.816718e-02, -3.811467e-02, -3.806202e-02, 
        -3.800927e-02, -3.795642e-02, -3.790338e-02, -3.785004e-02, -3.779642e-02, -3.774283e-02, -3.768910e-02, -3.763511e-02, 
        -3.758087e-02, -3.752642e-02, -3.747180e-02, -3.741704e-02, -3.736217e-02, -3.730733e-02, -3.725246e-02, -3.719750e-02, 
        -3.714247e-02, -3.708753e-02, -3.703262e-02, -3.697800e-02, -3.692337e-02, -3.686882e-02, -3.681430e-02, -3.675979e-02, 
        -3.670506e-02, -3.665026e-02, -3.659535e-02, -3.654034e-02, -3.648529e-02, -3.643007e-02, -3.637474e-02, -3.631929e-02, 
        -3.626369e-02, -3.620801e-02, -3.615226e-02, -3.609632e-02, -3.604017e-02, -3.598370e-02, -3.592686e-02, -3.586971e-02, 
        -3.581237e-02, -3.575475e-02, -3.569686e-02, -3.563889e-02, -3.558077e-02, -3.552268e-02, -3.546456e-02, -3.540657e-02, 
        -3.534881e-02, -3.529128e-02, -3.523379e-02, -3.517636e-02, -3.511898e-02, -3.506159e-02, -3.500414e-02, -3.494666e-02, 
        -3.488908e-02, -3.483150e-02, -3.477383e-02, -3.471608e-02, -3.465814e-02, -3.460010e-02, -3.454205e-02, -3.448395e-02, 
        -3.442572e-02, -3.436726e-02, -3.430844e-02, -3.424929e-02, -3.418989e-02, -3.413021e-02, -3.407043e-02, -3.401052e-02, 
        -3.395045e-02, -3.389023e-02, -3.382983e-02, -3.376928e-02, -3.370871e-02, -3.364813e-02, -3.358757e-02, -3.352692e-02, 
        -3.346630e-02, -3.340576e-02, -3.334525e-02, -3.328481e-02, -3.322440e-02, -3.316406e-02, -3.310386e-02, -3.304379e-02, 
        -3.298377e-02, -3.292377e-02, -3.286372e-02, -3.280355e-02, -3.274319e-02, -3.268266e-02, -3.262198e-02, -3.256111e-02, 
        -3.250009e-02, -3.243891e-02, -3.237754e-02, -3.231607e-02, -3.225447e-02, -3.219283e-02, -3.213101e-02, -3.206899e-02, 
        -3.200680e-02, -3.194430e-02, -3.188145e-02, -3.181831e-02, -3.175498e-02, -3.169153e-02, -3.162793e-02, -3.156425e-02, 
        -3.150052e-02, -3.143672e-02, -3.137295e-02, -3.130926e-02, -3.124574e-02, -3.118237e-02, -3.111912e-02, -3.105597e-02, 
        -3.099290e-02, -3.092988e-02, -3.086698e-02, -3.080408e-02, -3.074124e-02, -3.067840e-02, -3.061561e-02, -3.055281e-02, 
        -3.048987e-02, -3.042686e-02, -3.036359e-02, -3.030020e-02, -3.023671e-02, -3.017308e-02, -3.010935e-02, -3.004546e-02, 
        -2.998135e-02, -2.991703e-02, -2.985247e-02, -2.978771e-02, -2.972264e-02, -2.965720e-02, -2.959146e-02, -2.952556e-02, 
        -2.945951e-02, -2.939339e-02, -2.932716e-02, -2.926086e-02, -2.919452e-02, -2.912804e-02, -2.906153e-02, -2.899507e-02, 
        -2.892880e-02, -2.886262e-02, -2.879658e-02, -2.873073e-02, -2.866496e-02, -2.859924e-02, -2.853353e-02, -2.846785e-02, 
        -2.840220e-02, -2.833658e-02, -2.827092e-02, -2.820524e-02, -2.813952e-02, -2.807372e-02, -2.800790e-02, -2.794213e-02, 
        -2.787632e-02, -2.781050e-02, -2.774459e-02, -2.767845e-02, -2.761209e-02, -2.754545e-02, -2.747860e-02, -2.741149e-02, 
        -2.734402e-02, -2.727633e-02, -2.720847e-02, -2.714041e-02, -2.707219e-02, -2.700379e-02, -2.693523e-02, -2.686658e-02, 
        -2.679786e-02, -2.672913e-02, -2.666035e-02, -2.659160e-02, -2.652289e-02, -2.645426e-02, -2.638563e-02, -2.631707e-02, 
        -2.624859e-02, -2.618019e-02, -2.611194e-02, -2.604383e-02, -2.597575e-02, -2.590775e-02, -2.583979e-02, -2.577181e-02, 
        -2.570380e-02, -2.563576e-02, -2.556754e-02, -2.549921e-02, -2.543084e-02, -2.536250e-02, -2.529422e-02, -2.522590e-02, 
        -2.515742e-02, -2.508879e-02, -2.501993e-02, -2.495078e-02, -2.488133e-02, -2.481160e-02, -2.474170e-02, -2.467165e-02, 
        -2.460146e-02, -2.453125e-02, -2.446102e-02, -2.439082e-02, -2.432065e-02, -2.425063e-02, -2.418066e-02, -2.411074e-02, 
        -2.404082e-02, -2.397092e-02, -2.390089e-02, -2.383077e-02, -2.376058e-02, -2.369044e-02, -2.362035e-02, -2.355029e-02, 
        -2.348017e-02, -2.340993e-02, -2.333951e-02, -2.326897e-02, -2.319835e-02, -2.312768e-02, -2.305693e-02, -2.298606e-02, 
        -2.291496e-02, -2.284367e-02, -2.277219e-02, -2.270046e-02, -2.262853e-02, -2.255652e-02, -2.248440e-02, -2.241222e-02, 
        -2.234001e-02, -2.226780e-02, -2.219553e-02, -2.212314e-02, -2.205074e-02, -2.197841e-02, -2.190626e-02, -2.183424e-02, 
        -2.176229e-02, -2.169028e-02, -2.161810e-02, -2.154568e-02, -2.147305e-02, -2.140035e-02, -2.132762e-02, -2.125478e-02, 
        -2.118175e-02, -2.110860e-02, -2.103531e-02, -2.096183e-02, -2.088818e-02, -2.081438e-02, -2.074048e-02, -2.066639e-02, 
        -2.059209e-02, -2.051752e-02, -2.044265e-02, -2.036751e-02, -2.029207e-02, -2.021638e-02, -2.014058e-02, -2.006472e-02, 
        -1.998890e-02, -1.991314e-02, -1.983744e-02, -1.976183e-02, -1.968627e-02, -1.961074e-02, -1.953539e-02, -1.946019e-02, 
        -1.938501e-02, -1.930989e-02, -1.923479e-02, -1.915966e-02, -1.908452e-02, -1.900944e-02, -1.893439e-02, -1.885926e-02, 
        -1.878408e-02, -1.870884e-02, -1.863348e-02, -1.855796e-02, -1.848231e-02, -1.840652e-02, -1.833057e-02, -1.825440e-02, 
        -1.817798e-02, -1.810133e-02, -1.802449e-02, -1.794747e-02, -1.787021e-02, -1.779264e-02, -1.771478e-02, -1.763670e-02, 
        -1.755842e-02, -1.747999e-02, -1.740148e-02, -1.732291e-02, -1.724431e-02, -1.716563e-02, -1.708696e-02, -1.700842e-02, 
        -1.693010e-02, -1.685210e-02, -1.677433e-02, -1.669677e-02, -1.661930e-02, -1.654190e-02, -1.646447e-02, -1.638702e-02, 
        -1.630954e-02, -1.623204e-02, -1.615443e-02, -1.607676e-02, -1.599907e-02, -1.592144e-02, -1.584389e-02, -1.576632e-02, 
        -1.568863e-02, -1.561081e-02, -1.553288e-02, -1.545472e-02, -1.537633e-02, -1.529772e-02, -1.521894e-02, -1.513999e-02, 
        -1.506083e-02, -1.498161e-02, -1.490233e-02, -1.482310e-02, -1.474395e-02, -1.466488e-02, -1.458589e-02, -1.450702e-02, 
        -1.442836e-02, -1.434983e-02, -1.427133e-02, -1.419289e-02, -1.411455e-02, -1.403623e-02, -1.395785e-02, -1.387951e-02, 
        -1.380115e-02, -1.372280e-02, -1.364444e-02, -1.356610e-02, -1.348754e-02, -1.340874e-02, -1.332979e-02, -1.325070e-02, 
        -1.317143e-02, -1.309201e-02, -1.301245e-02, -1.293275e-02, -1.285271e-02, -1.277242e-02, -1.269182e-02, -1.261105e-02, 
        -1.253009e-02, -1.244900e-02, -1.236778e-02, -1.228641e-02, -1.220500e-02, -1.212366e-02, -1.204226e-02, -1.196090e-02, 
        -1.187970e-02, -1.179848e-02, -1.171736e-02, -1.163649e-02, -1.155585e-02, -1.147541e-02, -1.139521e-02, -1.131516e-02, 
        -1.123521e-02, -1.115536e-02, -1.107554e-02, -1.099559e-02, -1.091568e-02, -1.083583e-02, -1.075604e-02, -1.067644e-02, 
        -1.059687e-02, -1.051720e-02, -1.043748e-02, -1.035779e-02, -1.027803e-02, -1.019800e-02, -1.011781e-02, -1.003758e-02, 
        -9.957239e-03, -9.876816e-03, -9.796439e-03, -9.716210e-03, -9.636026e-03, -9.555834e-03, -9.475533e-03, -9.395003e-03, 
        -9.314153e-03, -9.233184e-03, -9.152170e-03, -9.071143e-03, -8.990137e-03, -8.909167e-03, -8.828271e-03, -8.747499e-03, 
        -8.666663e-03, -8.585664e-03, -8.504367e-03, -8.422923e-03, -8.341348e-03, -8.259648e-03, -8.177829e-03, -8.095776e-03, 
        -8.013583e-03, -7.931298e-03, -7.848872e-03, -7.766315e-03, -7.683466e-03, -7.600526e-03, -7.517544e-03, -7.434385e-03, 
        -7.351137e-03, -7.267938e-03, -7.184759e-03, -7.101645e-03, -7.018527e-03, -6.935418e-03, -6.851983e-03, -6.768426e-03, 
        -6.685034e-03, -6.601836e-03, -6.518750e-03, -6.435825e-03, -6.353018e-03, -6.270365e-03, -6.187727e-03, -6.105019e-03, 
        -6.022069e-03, -5.938993e-03, -5.855980e-03, -5.773054e-03, -5.690185e-03, -5.607578e-03, -5.525072e-03, -5.442573e-03, 
        -5.360150e-03, -5.277665e-03, -5.194958e-03, -5.111897e-03, -5.028772e-03, -4.945543e-03, -4.862157e-03, -4.778586e-03, 
        -4.694894e-03, -4.611060e-03, -4.527402e-03, -4.443631e-03, -4.359563e-03, -4.274865e-03, -4.189983e-03, -4.104942e-03, 
        -4.019846e-03, -3.934731e-03, -3.849588e-03, -3.764451e-03, -3.679434e-03, -3.594517e-03, -3.509579e-03, -3.424345e-03, 
        -3.339334e-03, -3.254477e-03, -3.169773e-03, -3.085151e-03, -3.000545e-03, -2.915934e-03, -2.831347e-03, -2.746836e-03, 
        -2.662332e-03, -2.577334e-03, -2.492046e-03, -2.406713e-03, -2.321474e-03, -2.236671e-03, -2.151859e-03, -2.066829e-03, 
        -1.981710e-03, -1.896570e-03, -1.811610e-03, -1.726102e-03, -1.639910e-03, -1.553454e-03, -1.466765e-03, -1.379805e-03, 
        -1.292726e-03, -1.205572e-03, -1.118955e-03, -1.032592e-03, -9.464431e-04, -8.607769e-04, -7.746067e-04, -6.883249e-04, 
        -6.019335e-04, -5.156037e-04, -4.293733e-04, -3.432325e-04, -2.572296e-04, -1.713395e-04, -8.560801e-05, -1.734677e-18
    },
    {
        0.000000e+00, -6.834736e-03, -1.030655e-02, -1.309653e-02, -1.550273e-02, -1.765338e-02, -1.961569e-02, -2.144469e-02, 
        -2.316949e-02, -2.480979e-02, -2.637446e-02, -2.787000e-02, -2.930205e-02, -3.067509e-02, -3.199528e-02, -3.326566e-02, 
        -3.448766e-02, -3.566654e-02, -3.680414e-02, -3.790353e-02, -3.896870e-02, -3.999961e-02, -4.099430e-02, -4.195820e-02, 
        -4.289104e-02, -4.379444e-02, -4.467011e-02, -4.551842e-02, -4.634050e-02, -4.713816e-02, -4.791264e-02, -4.866400e-02, 
        -4.939394e-02, -5.010301e-02, -5.079321e-02, -5.146556e-02, -5.212060e-02, -5.275808e-02, -5.338037e-02, -5.398612e-02, 
        -5.457620e-02, -5.515033e-02, -5.570914e-02, -5.625304e-02, -5.678294e-02, -5.729777e-02, -5.779807e-02, -5.828404e-02, 
        -5.875630e-02, -5.921497e-02, -5.966021e-02, -6.009192e-02, -6.051124e-02, -6.091733e-02, -6.131049e-02, -6.169107e-02, 
        -6.205854e-02, -6.241281e-02, -6.275280e-02, -6.307833e-02, -6.339045e-02, -6.368931e-02, -6.397532e-02, -6.424917e-02, 
        -6.450968e-02, -6.475804e-02, -6.499499e-02, -6.522048e-02, -6.543458e-02, -6.563702e-02, -6.582738e-02, -6.600698e-02, 
        -6.617651e-02, -6.633596e-02, -6.648488e-02, -6.662203e-02, -6.674955e-02, -6.686704e-02, -6.697447e-02, -6.707293e-02, 
        -6.716189e-02, -6.724087e-02, -6.731006e-02, -6.737121e-02, -6.742258e-02, -6.746481e-02, -6.749928e-02, -6.752386e-02, 
        -6.753829e-02, -6.754365e-02, -6.754009e-02, -6.752833e-02, -6.750745e-02, -6.747733e-02, -6.743835e-02, -6.738998e-02, 
        -6.733389e-02, -6.726971e-02, -6.719592e-02, -6.711396e-02, -6.702469e-02, -6.692758e-02, -6.682206e-02, -6.670795e-02, 
        -6.658773e-02, -6.646093e-02, -6.632665e-02, -6.618518e-02, -6.603761e-02, -6.588456e-02, -6.572434e-02, -6.555916e-02, 
        -6.538862e-02, -6.521215e-02, -6.502931e-02, -6.484248e-02, -6.464931e-02, -6.445091e-02, -6.424875e-02, -6.404104e-02, 
        -6.382964e-02, -6.361353e-02, -6.339300e-02, -6.316857e-02, -6.293894e-02, -6.270501e-02, -6.246678e-02, -6.222511e-02, 
        -6.198001e-02, -6.173081e-02, -6.147881e-02, -6.122315e-02, -6.096412e-02, -6.070220e-02, -6.043667e-02, -6.016932e-02, 
        -5.989955e-02, -5.962626e-02, -5.935165e-02, -5.907452e-02, -5.879482e-02, -5.851286e-02, -5.822720e-02, -5.793945e-02, 
        -5.764931e-02, -5.735722e-02, -5.706336e-02, -5.676615e-02, -5.646789e-02, -5.616717e-02, -5.586355e-02, -5.555858e-02, 
        -5.525142e-02, -5.494337e-02, -5.463375e-02, -5.432268e-02, -5.400878e-02, -5.369359e-02, -5.337638e-02, -5.305805e-02, 
        -5.273846e-02, -5.241742e-02, -5.209304e-02, -5.176789e-02, -5.144062e-02, -5.111253e-02, -5.078344e-02, -5.045272e-02, 
        -5.011944e-02, -4.978481e-02, -4.944995e-02, -4.911371e-02, -4.877491e-02, -4.843408e-02, -4.809225e-02, -4.774920e-02, 
        -4.740392e-02, -4.705772e-02, -4.671063e-02, -4.636272e-02, -4.601150e-02, -4.565978e-02, -4.530795e-02, -4.495361e-02, 
        -4.459696e-02, -4.424074e-02, -4.388182e-02, -4.352130e-02, -4.316080e-02, -4.279696e-02, -4.243225e-02, -4.206572e-02, 
        -4.169662e-02, -4.132640e-02, -4.095428e-02, -4.058141e-02, -4.020654e-02, -3.983143e-02, -3.945481e-02, -3.907752e-02, 
        -3.869863e-02, -3.831916e-02, -3.793909e-02, -3.755856e-02, -3.717837e-02, -3.679812e-02, -3.641870e-02, -3.603933e-02, 
        -3.566199e-02, -3.528460e-02, -3.490798e-02, -3.453196e-02, -3.415788e-02, -3.378426e-02, -3.341166e-02, -3.303988e-02, 
        -3.266905e-02, -3.229894e-02, -3.192930e-02, -3.156158e-02, -3.119414e-02, -3.082719e-02, -3.046210e-02, -3.009774e-02, 
        -2.973468e-02, -2.937301e-02, -2.901148e-02, -2.865136e-02, -2.829204e-02, -2.793274e-02, -2.757493e-02, -2.721877e-02, 
        -2.686271e-02, -2.650782e-02, -2.615378e-02, -2.580023e-02, -2.544731e-02, -2.509595e-02, -2.474575e-02, -2.439674e-02, 
        -2.404838e-02, -2.370154e-02, -2.335531e-02, -2.301049e-02, -2.266754e-02, -2.232499e-02, -2.198264e-02, -2.164178e-02, 
        -2.130193e-02, -2.096273e-02, -2.062418e-02, -2.028711e-02, -1.995205e-02, -1.961796e-02, -1.928439e-02, -1.895179e-02, 
        -1.862081e-02, -1.829111e-02, -1.796200e-02, -1.763426e-02, -1.730856e-02, -1.698441e-02, -1.666101e-02, -1.633836e-02, 
        -1.601732e-02, -1.569876e-02, -1.538064e-02, -1.506325e-02, -1.474730e-02, -1.443237e-02, -1.411902e-02, -1.380695e-02, 
        -1.349567e-02, -1.318542e-02, -1.287660e-02, -1.256888e-02, -1.226211e-02, -1.195664e-02, -1.165172e-02, -1.134866e-02, 
        -1.104682e-02, -1.074621e-02, -1.044633e-02, -1.014755e-02, -9.850819e-03, -9.554834e-03, -9.260157e-03, -8.967085e-03, 
        -8.674770e-03, -8.383864e-03, -8.094663e-03, -7.806046e-03, -7.518072e-03, -7.231338e-03, -6.945811e-03, -6.661126e-03, 
        -6.377697e-03, -6.095236e-03, -5.814124e-03, -5.534324e-03, -5.255688e-03, -4.978303e-03, -4.701866e-03, -4.426695e-03, 
        -4.152214e-03, -3.878992e-03, -3.607353e-03, -3.336666e-03, -3.067033e-03, -2.797994e-03, -2.529929e-03, -2.263697e-03, 
        -1.998356e-03, -1.733835e-03, -1.470706e-03, -1.208125e-03, -9.470783e-04, -6.878352e-04, -4.302868e-04, -1.744681e-04, 
        8.006053e-05, 3.337304e-04, 5.862463e-04, 8.373778e-04, 1.086435e-03, 1.334537e-03, 1.581397e-03, 1.826863e-03, 
        2.071398e-03, 2.314104e-03, 2.555159e-03, 2.794924e-03, 3.033519e-03, 3.270476e-03, 3.505720e-03, 3.739996e-03, 
        3.972842e-03, 4.204140e-03, 4.434708e-03, 4.664032e-03, 4.890714e-03, 5.116126e-03, 5.340849e-03, 5.564195e-03, 
        5.786559e-03, 6.007642e-03, 6.226949e-03, 6.444732e-03, 6.661478e-03, 6.876964e-03, 7.091547e-03, 7.304253e-03, 
        7.515924e-03, 7.726824e-03, 7.935763e-03, 8.142976e-03, 8.349168e-03, 8.553944e-03, 8.757340e-03, 8.959792e-03, 
        9.161106e-03, 9.361287e-03, 9.559349e-03, 9.756497e-03, 9.952685e-03, 1.014762e-02, 1.034074e-02, 1.053309e-02, 
        1.072541e-02, 1.091594e-02, 1.110504e-02, 1.129373e-02, 1.148156e-02, 1.166782e-02, 1.185313e-02, 1.203736e-02, 
        1.222075e-02, 1.240279e-02, 1.258331e-02, 1.276309e-02, 1.294256e-02, 1.312040e-02, 1.329677e-02, 1.347249e-02, 
        1.364706e-02, 1.382051e-02, 1.399266e-02, 1.416408e-02, 1.433441e-02, 1.450364e-02, 1.467111e-02, 1.483672e-02, 
        1.500138e-02, 1.516571e-02, 1.532860e-02, 1.549030e-02, 1.565125e-02, 1.581128e-02, 1.596967e-02, 1.612637e-02, 
        1.628214e-02, 1.643701e-02, 1.659115e-02, 1.674467e-02, 1.689665e-02, 1.704747e-02, 1.719766e-02, 1.734634e-02, 
        1.749310e-02, 1.763928e-02, 1.778497e-02, 1.792967e-02, 1.807319e-02, 1.821614e-02, 1.835842e-02, 1.849997e-02, 
        1.864049e-02, 1.878001e-02, 1.891777e-02, 1.905389e-02, 1.918975e-02, 1.932466e-02, 1.945806e-02, 1.959045e-02, 
        1.972178e-02, 1.985215e-02, 1.998132e-02, 2.010955e-02, 2.023659e-02, 2.036272e-02, 2.048797e-02, 2.061253e-02, 
        2.073551e-02, 2.085671e-02, 2.097730e-02, 2.109728e-02, 2.121611e-02, 2.133362e-02, 2.145057e-02, 2.156713e-02, 
        2.168222e-02, 2.179582e-02, 2.190811e-02, 2.201902e-02, 2.212963e-02, 2.223941e-02, 2.234774e-02, 2.245507e-02, 
        2.256168e-02, 2.266780e-02, 2.277300e-02, 2.287686e-02, 2.298009e-02, 2.308251e-02, 2.318447e-02, 2.328479e-02, 
        2.338382e-02, 2.348174e-02, 2.357885e-02, 2.367505e-02, 2.377069e-02, 2.386548e-02, 2.395961e-02, 2.405276e-02, 
        2.414502e-02, 2.423653e-02, 2.432725e-02, 2.441701e-02, 2.450582e-02, 2.459374e-02, 2.468095e-02, 2.476778e-02, 
        2.485295e-02, 2.493731e-02, 2.502082e-02, 2.510419e-02, 2.518703e-02, 2.526896e-02, 2.534992e-02, 2.543015e-02, 
        2.550961e-02, 2.558855e-02, 2.566690e-02, 2.574410e-02, 2.581993e-02, 2.589510e-02, 2.596982e-02, 2.604419e-02, 
        2.611726e-02, 2.618891e-02, 2.625982e-02, 2.633075e-02, 2.640090e-02, 2.646978e-02, 2.653755e-02, 2.660499e-02, 
        2.667202e-02, 2.673802e-02, 2.680315e-02, 2.686678e-02, 2.692976e-02, 2.699183e-02, 2.705374e-02, 2.711568e-02, 
        2.717667e-02, 2.723653e-02, 2.729552e-02, 2.735416e-02, 2.741264e-02, 2.747052e-02, 2.752731e-02, 2.758320e-02, 
        2.763833e-02, 2.769307e-02, 2.774696e-02, 2.780023e-02, 2.785280e-02, 2.790422e-02, 2.795501e-02, 2.800557e-02, 
        2.805546e-02, 2.810432e-02, 2.815198e-02, 2.819804e-02, 2.824345e-02, 2.828880e-02, 2.833374e-02, 2.837770e-02, 
        2.842043e-02, 2.846258e-02, 2.850428e-02, 2.854542e-02, 2.858598e-02, 2.862594e-02, 2.866495e-02, 2.870252e-02, 
        2.873966e-02, 2.877646e-02, 2.881295e-02, 2.884832e-02, 2.888255e-02, 2.891574e-02, 2.894903e-02, 2.898223e-02, 
        2.901508e-02, 2.904705e-02, 2.907791e-02, 2.910819e-02, 2.913826e-02, 2.916796e-02, 2.919735e-02, 2.922622e-02, 
        2.925391e-02, 2.928040e-02, 2.930629e-02, 2.933194e-02, 2.935745e-02, 2.938241e-02, 2.940608e-02, 2.942892e-02, 
        2.945141e-02, 2.947362e-02, 2.949535e-02, 2.951647e-02, 2.953636e-02, 2.955591e-02, 2.957522e-02, 2.959431e-02, 
        2.961273e-02, 2.963049e-02, 2.964725e-02, 2.966316e-02, 2.967857e-02, 2.969379e-02, 2.970889e-02, 2.972363e-02, 
        2.973772e-02, 2.975090e-02, 2.976332e-02, 2.977532e-02, 2.978702e-02, 2.979864e-02, 2.980987e-02, 2.982054e-02, 
        2.983048e-02, 2.983975e-02, 2.984855e-02, 2.985685e-02, 2.986464e-02, 2.987176e-02, 2.987795e-02, 2.988374e-02, 
        2.988937e-02, 2.989469e-02, 2.989998e-02, 2.990470e-02, 2.990875e-02, 2.991192e-02, 2.991424e-02, 2.991637e-02, 
        2.991777e-02, 2.991885e-02, 2.991928e-02, 2.991874e-02, 2.991738e-02, 2.991572e-02, 2.991373e-02, 2.991128e-02, 
        2.990860e-02, 2.990584e-02, 2.990235e-02, 2.989797e-02, 2.989336e-02, 2.988847e-02, 2.988322e-02, 2.987778e-02, 
        2.987201e-02, 2.986577e-02, 2.985911e-02, 2.985255e-02, 2.984558e-02, 2.983821e-02, 2.983035e-02, 2.982172e-02, 
        2.981263e-02, 2.980268e-02, 2.979215e-02, 2.978133e-02, 2.977045e-02, 2.975935e-02, 2.974743e-02, 2.973463e-02, 
        2.972134e-02, 2.970785e-02, 2.969386e-02, 2.967948e-02, 2.966457e-02, 2.964874e-02, 2.963212e-02, 2.961527e-02, 
        2.959817e-02, 2.958032e-02, 2.956216e-02, 2.954350e-02, 2.952412e-02, 2.950376e-02, 2.948252e-02, 2.946105e-02, 
        2.943933e-02, 2.941770e-02, 2.939591e-02, 2.937378e-02, 2.935096e-02, 2.932764e-02, 2.930405e-02, 2.928041e-02, 
        2.925683e-02, 2.923300e-02, 2.920860e-02, 2.918345e-02, 2.915766e-02, 2.913147e-02, 2.910496e-02, 2.907784e-02, 
        2.905027e-02, 2.902246e-02, 2.899426e-02, 2.896544e-02, 2.893613e-02, 2.890619e-02, 2.887590e-02, 2.884529e-02, 
        2.881411e-02, 2.878199e-02, 2.874931e-02, 2.871610e-02, 2.868268e-02, 2.864918e-02, 2.861521e-02, 2.858077e-02, 
        2.854600e-02, 2.851046e-02, 2.847440e-02, 2.843823e-02, 2.840170e-02, 2.836473e-02, 2.832715e-02, 2.828919e-02, 
        2.825080e-02, 2.821174e-02, 2.817164e-02, 2.813137e-02, 2.809064e-02, 2.804988e-02, 2.800906e-02, 2.796814e-02, 
        2.792655e-02, 2.788389e-02, 2.784049e-02, 2.779686e-02, 2.775313e-02, 2.770916e-02, 2.766488e-02, 2.762008e-02, 
        2.757387e-02, 2.752694e-02, 2.748006e-02, 2.743309e-02, 2.738562e-02, 2.733757e-02, 2.728918e-02, 2.724059e-02, 
        2.719126e-02, 2.714126e-02, 2.709101e-02, 2.704059e-02, 2.699002e-02, 2.693964e-02, 2.688949e-02, 2.683898e-02, 
        2.678728e-02, 2.673486e-02, 2.668206e-02, 2.662915e-02, 2.657626e-02, 2.652307e-02, 2.646954e-02, 2.641526e-02, 
        2.636039e-02, 2.630526e-02, 2.625021e-02, 2.619506e-02, 2.613945e-02, 2.608340e-02, 2.602684e-02, 2.596993e-02, 
        2.591262e-02, 2.585493e-02, 2.579680e-02, 2.573835e-02, 2.567970e-02, 2.562103e-02, 2.556225e-02, 2.550317e-02, 
        2.544336e-02, 2.538317e-02, 2.532253e-02, 2.526149e-02, 2.520069e-02, 2.513982e-02, 2.507873e-02, 2.501757e-02, 
        2.495623e-02, 2.489478e-02, 2.483325e-02, 2.477154e-02, 2.470957e-02, 2.464714e-02, 2.458375e-02, 2.451995e-02, 
        2.445596e-02, 2.439214e-02, 2.432815e-02, 2.426368e-02, 2.419895e-02, 2.413401e-02, 2.406879e-02, 2.400333e-02, 
        2.393762e-02, 2.387124e-02, 2.380421e-02, 2.373677e-02, 2.366924e-02, 2.360201e-02, 2.353462e-02, 2.346708e-02, 
        2.339930e-02, 2.333108e-02, 2.326216e-02, 2.319319e-02, 2.312445e-02, 2.305565e-02, 2.298672e-02, 2.291752e-02, 
        2.284820e-02, 2.277878e-02, 2.270904e-02, 2.263863e-02, 2.256796e-02, 2.249704e-02, 2.242582e-02, 2.235437e-02, 
        2.228287e-02, 2.221145e-02, 2.213982e-02, 2.206778e-02, 2.199519e-02, 2.192199e-02, 2.184854e-02, 2.177484e-02, 
        2.170073e-02, 2.162616e-02, 2.155125e-02, 2.147579e-02, 2.139931e-02, 2.132241e-02, 2.124553e-02, 2.116845e-02, 
        2.109140e-02, 2.101413e-02, 2.093653e-02, 2.085859e-02, 2.078051e-02, 2.070170e-02, 2.062251e-02, 2.054327e-02, 
        2.046379e-02, 2.038417e-02, 2.030452e-02, 2.022499e-02, 2.014550e-02, 2.006557e-02, 1.998500e-02, 1.990404e-02, 
        1.982261e-02, 1.974109e-02, 1.965972e-02, 1.957832e-02, 1.949669e-02, 1.941454e-02, 1.933192e-02, 1.924860e-02, 
        1.916515e-02, 1.908171e-02, 1.899820e-02, 1.891452e-02, 1.883073e-02, 1.874656e-02, 1.866178e-02, 1.857668e-02, 
        1.849097e-02, 1.840473e-02, 1.831818e-02, 1.823158e-02, 1.814483e-02, 1.805806e-02, 1.797132e-02, 1.788475e-02, 
        1.779823e-02, 1.771130e-02, 1.762377e-02, 1.753588e-02, 1.744771e-02, 1.735949e-02, 1.727150e-02, 1.718335e-02, 
        1.709513e-02, 1.700680e-02, 1.691792e-02, 1.682779e-02, 1.673734e-02, 1.664724e-02, 1.655709e-02, 1.646661e-02, 
        1.637596e-02, 1.628514e-02, 1.619373e-02, 1.610176e-02, 1.600926e-02, 1.591590e-02, 1.582272e-02, 1.572961e-02, 
        1.563630e-02, 1.554271e-02, 1.544886e-02, 1.535515e-02, 1.526130e-02, 1.516701e-02, 1.507180e-02, 1.497624e-02, 
        1.488052e-02, 1.478434e-02, 1.468826e-02, 1.459273e-02, 1.449716e-02, 1.440158e-02, 1.430571e-02, 1.420940e-02, 
        1.411214e-02, 1.401480e-02, 1.391760e-02, 1.382018e-02, 1.372267e-02, 1.362512e-02, 1.352760e-02, 1.343008e-02, 
        1.333228e-02, 1.323431e-02, 1.313591e-02, 1.303727e-02, 1.293852e-02, 1.283950e-02, 1.274032e-02, 1.264080e-02, 
        1.254123e-02, 1.244169e-02, 1.234195e-02, 1.224205e-02, 1.214193e-02, 1.204189e-02, 1.194184e-02, 1.184131e-02, 
        1.174076e-02, 1.164014e-02, 1.153936e-02, 1.143851e-02, 1.133759e-02, 1.123653e-02, 1.113548e-02, 1.103454e-02, 
        1.093387e-02, 1.083302e-02, 1.073188e-02, 1.063088e-02, 1.052970e-02, 1.042837e-02, 1.032659e-02, 1.022455e-02, 
        1.012248e-02, 1.002035e-02, 9.918116e-03, 9.815804e-03, 9.713331e-03, 9.610621e-03, 9.507541e-03, 9.404811e-03, 
        9.301925e-03, 9.198768e-03, 9.094977e-03, 8.991043e-03, 8.887070e-03, 8.782970e-03, 8.678326e-03, 8.573843e-03, 
        8.469633e-03, 8.365521e-03, 8.261370e-03, 8.157106e-03, 8.052351e-03, 7.947350e-03, 7.842282e-03, 7.737671e-03, 
        7.632770e-03, 7.527568e-03, 7.422291e-03, 7.316904e-03, 7.211409e-03, 7.106033e-03, 7.000307e-03, 6.894502e-03, 
        6.788705e-03, 6.682880e-03, 6.576743e-03, 6.470157e-03, 6.363435e-03, 6.256815e-03, 6.150156e-03, 6.043626e-03, 
        5.936934e-03, 5.829892e-03, 5.723172e-03, 5.616471e-03, 5.509550e-03, 5.401966e-03, 5.294037e-03, 5.186386e-03, 
        5.078716e-03, 4.971001e-03, 4.863286e-03, 4.755597e-03, 4.647307e-03, 4.538980e-03, 4.430595e-03, 4.322479e-03, 
        4.214607e-03, 4.106767e-03, 3.998947e-03, 3.891184e-03, 3.783453e-03, 3.675667e-03, 3.567486e-03, 3.459373e-03, 
        3.351252e-03, 3.242571e-03, 3.134150e-03, 3.025716e-03, 2.917545e-03, 2.810184e-03, 2.702678e-03, 2.595736e-03, 
        2.488716e-03, 2.381184e-03, 2.272856e-03, 2.164048e-03, 2.054665e-03, 1.945212e-03, 1.835736e-03, 1.726726e-03, 
        1.618062e-03, 1.509930e-03, 1.402651e-03, 1.295712e-03, 1.188421e-03, 1.080173e-03, 9.714036e-04, 8.630221e-04, 
        7.551179e-04, 6.472019e-04, 5.393068e-04, 4.314098e-04, 3.235321e-04, 2.156618e-04, 1.078233e-04, 1.817274e-18
    },
    {
        0.000000e+00, -1.492129e-02, -2.127088e-02, -2.618806e-02, -3.030776e-02, -3.390256e-02, -3.710799e-02, -4.003321e-02, 
        -4.274783e-02, -4.528460e-02, -4.765963e-02, -4.988519e-02, -5.197049e-02, -5.392217e-02, -5.575409e-02, -5.747167e-02, 
        -5.908103e-02, -6.059303e-02, -6.201298e-02, -6.335102e-02, -6.461079e-02, -6.579581e-02, -6.690524e-02, -6.794801e-02, 
        -6.892519e-02, -6.984189e-02, -7.069960e-02, -7.150041e-02, -7.224501e-02, -7.293687e-02, -7.357614e-02, -7.416297e-02, 
        -7.469762e-02, -7.517955e-02, -7.561567e-02, -7.600640e-02, -7.634987e-02, -7.664419e-02, -7.689663e-02, -7.710327e-02, 
        -7.726759e-02, -7.738455e-02, -7.745873e-02, -7.749457e-02, -7.748945e-02, -7.744165e-02, -7.735865e-02, -7.723364e-02, 
        -7.707189e-02, -7.687827e-02, -7.664647e-02, -7.637822e-02, -7.608302e-02, -7.575068e-02, -7.538839e-02, -7.499824e-02, 
        -7.457771e-02, -7.412979e-02, -7.364984e-02, -7.314172e-02, -7.260533e-02, -7.204270e-02, -7.145579e-02, -7.084881e-02, 
        -7.021362e-02, -6.955401e-02, -6.887651e-02, -6.817895e-02, -6.746294e-02, -6.672660e-02, -6.597115e-02, -6.519937e-02, 
        -6.441377e-02, -6.361464e-02, -6.280368e-02, -6.197680e-02, -6.113930e-02, -6.029036e-02, -5.943020e-02, -5.856084e-02, 
        -5.768074e-02, -5.678807e-02, -5.588325e-02, -5.497403e-02, -5.405088e-02, -5.311932e-02, -5.218269e-02, -5.123219e-02, 
        -5.027069e-02, -4.930252e-02, -4.832386e-02, -4.733829e-02, -4.634025e-02, -4.533376e-02, -4.432209e-02, -4.329936e-02, 
        -4.226919e-02, -4.123282e-02, -4.018882e-02, -3.913876e-02, -3.808507e-02, -3.702615e-02, -3.596504e-02, -3.490341e-02, 
        -3.384366e-02, -3.278206e-02, -3.171784e-02, -3.065539e-02, -2.959573e-02, -2.854068e-02, -2.748243e-02, -2.643014e-02, 
        -2.538179e-02, -2.433511e-02, -2.329353e-02, -2.225788e-02, -2.122554e-02, -2.019842e-02, -1.918127e-02, -1.816785e-02, 
        -1.716183e-02, -1.616060e-02, -1.516746e-02, -1.418151e-02, -1.320141e-02, -1.222747e-02, -1.126370e-02, -1.030776e-02, 
        -9.360055e-03, -8.420152e-03, -7.488138e-03, -6.566507e-03, -5.655479e-03, -4.756311e-03, -3.866571e-03, -2.990216e-03, 
        -2.126094e-03, -1.267782e-03, -4.210361e-04, 4.168841e-04, 1.246749e-03, 2.066966e-03, 2.877267e-03, 3.679979e-03, 
        4.472107e-03, 5.252754e-03, 6.023304e-03, 6.788588e-03, 7.544078e-03, 8.288665e-03, 9.025675e-03, 9.753873e-03, 
        1.047475e-02, 1.118661e-02, 1.188755e-02, 1.258288e-02, 1.326729e-02, 1.394282e-02, 1.461229e-02, 1.527265e-02, 
        1.592762e-02, 1.657146e-02, 1.720636e-02, 1.782967e-02, 1.844406e-02, 1.904969e-02, 1.964527e-02, 2.023076e-02, 
        2.081047e-02, 2.138261e-02, 2.194487e-02, 2.250196e-02, 2.304905e-02, 2.358819e-02, 2.411839e-02, 2.463960e-02, 
        2.514865e-02, 2.565030e-02, 2.614183e-02, 2.662619e-02, 2.710025e-02, 2.756598e-02, 2.802123e-02, 2.846987e-02, 
        2.891075e-02, 2.934243e-02, 2.976562e-02, 3.018131e-02, 3.058678e-02, 3.098458e-02, 3.137367e-02, 3.175329e-02, 
        3.212513e-02, 3.248639e-02, 3.283770e-02, 3.318035e-02, 3.351670e-02, 3.384299e-02, 3.416177e-02, 3.447175e-02, 
        3.477535e-02, 3.507138e-02, 3.536013e-02, 3.564247e-02, 3.591487e-02, 3.617964e-02, 3.643723e-02, 3.668991e-02, 
        3.693380e-02, 3.717302e-02, 3.740944e-02, 3.763660e-02, 3.785714e-02, 3.806982e-02, 3.827548e-02, 3.847419e-02, 
        3.866396e-02, 3.885067e-02, 3.903115e-02, 3.920685e-02, 3.937780e-02, 3.954491e-02, 3.970796e-02, 3.986178e-02, 
        4.001373e-02, 4.015855e-02, 4.029890e-02, 4.043529e-02, 4.056528e-02, 4.069092e-02, 4.081260e-02, 4.092676e-02, 
        4.103873e-02, 4.114570e-02, 4.124747e-02, 4.134345e-02, 4.143188e-02, 4.151645e-02, 4.159395e-02, 4.166355e-02, 
        4.173055e-02, 4.179073e-02, 4.184467e-02, 4.189187e-02, 4.193239e-02, 4.196968e-02, 4.200237e-02, 4.202886e-02, 
        4.205290e-02, 4.207137e-02, 4.208656e-02, 4.209566e-02, 4.209963e-02, 4.209968e-02, 4.209733e-02, 4.208945e-02, 
        4.207928e-02, 4.206520e-02, 4.204744e-02, 4.202663e-02, 4.199872e-02, 4.196584e-02, 4.193164e-02, 4.189285e-02, 
        4.184639e-02, 4.179631e-02, 4.174293e-02, 4.168768e-02, 4.162983e-02, 4.156668e-02, 4.149975e-02, 4.142993e-02, 
        4.135414e-02, 4.127279e-02, 4.119022e-02, 4.110327e-02, 4.101329e-02, 4.092093e-02, 4.082437e-02, 4.072230e-02, 
        4.061815e-02, 4.051180e-02, 4.040312e-02, 4.029203e-02, 4.017848e-02, 4.006180e-02, 3.994356e-02, 3.982271e-02, 
        3.969911e-02, 3.957502e-02, 3.945107e-02, 3.932636e-02, 3.919872e-02, 3.906977e-02, 3.893930e-02, 3.880742e-02, 
        3.867382e-02, 3.853734e-02, 3.839708e-02, 3.825433e-02, 3.811106e-02, 3.796525e-02, 3.781681e-02, 3.766634e-02, 
        3.751375e-02, 3.735865e-02, 3.720277e-02, 3.704359e-02, 3.688229e-02, 3.671925e-02, 3.655369e-02, 3.638574e-02, 
        3.621416e-02, 3.604147e-02, 3.586678e-02, 3.569232e-02, 3.551728e-02, 3.534102e-02, 3.516244e-02, 3.498119e-02, 
        3.479838e-02, 3.461231e-02, 3.442526e-02, 3.423686e-02, 3.404634e-02, 3.385433e-02, 3.366179e-02, 3.346944e-02, 
        3.327630e-02, 3.308278e-02, 3.288709e-02, 3.268883e-02, 3.248765e-02, 3.228683e-02, 3.208361e-02, 3.187810e-02, 
        3.166924e-02, 3.146022e-02, 3.124957e-02, 3.103519e-02, 3.081974e-02, 3.060306e-02, 3.038578e-02, 3.016596e-02, 
        2.994620e-02, 2.972404e-02, 2.949999e-02, 2.927360e-02, 2.904702e-02, 2.882051e-02, 2.859334e-02, 2.836347e-02, 
        2.813350e-02, 2.790291e-02, 2.767057e-02, 2.743701e-02, 2.720281e-02, 2.696625e-02, 2.673157e-02, 2.649659e-02, 
        2.626168e-02, 2.602569e-02, 2.578910e-02, 2.555118e-02, 2.531368e-02, 2.507698e-02, 2.484014e-02, 2.460235e-02, 
        2.436583e-02, 2.412815e-02, 2.388920e-02, 2.365033e-02, 2.341059e-02, 2.316970e-02, 2.292831e-02, 2.268420e-02, 
        2.244054e-02, 2.219756e-02, 2.195360e-02, 2.170899e-02, 2.146600e-02, 2.122240e-02, 2.097791e-02, 2.073426e-02, 
        2.049191e-02, 2.025015e-02, 2.000811e-02, 1.976600e-02, 1.952313e-02, 1.928183e-02, 1.904155e-02, 1.880019e-02, 
        1.855812e-02, 1.831728e-02, 1.807667e-02, 1.783590e-02, 1.759459e-02, 1.735397e-02, 1.711338e-02, 1.687298e-02, 
        1.663316e-02, 1.639232e-02, 1.615232e-02, 1.591339e-02, 1.567317e-02, 1.543240e-02, 1.519348e-02, 1.495407e-02, 
        1.471271e-02, 1.447120e-02, 1.423002e-02, 1.398939e-02, 1.374940e-02, 1.350901e-02, 1.326724e-02, 1.302598e-02, 
        1.278601e-02, 1.254618e-02, 1.230531e-02, 1.206388e-02, 1.182352e-02, 1.158297e-02, 1.134161e-02, 1.110085e-02, 
        1.085994e-02, 1.061897e-02, 1.037977e-02, 1.014137e-02, 9.901052e-03, 9.659893e-03, 9.419405e-03, 9.179110e-03, 
        8.937359e-03, 8.695699e-03, 8.456020e-03, 8.215845e-03, 7.975956e-03, 7.736163e-03, 7.496472e-03, 7.256680e-03, 
        7.015320e-03, 6.775422e-03, 6.534686e-03, 6.293493e-03, 6.053075e-03, 5.813559e-03, 5.574828e-03, 5.336566e-03, 
        5.099228e-03, 4.863776e-03, 4.628290e-03, 4.393131e-03, 4.158830e-03, 3.925326e-03, 3.692849e-03, 3.459805e-03, 
        3.227877e-03, 2.996216e-03, 2.765209e-03, 2.535830e-03, 2.308013e-03, 2.081011e-03, 1.854741e-03, 1.629909e-03, 
        1.406858e-03, 1.184176e-03, 9.618576e-04, 7.402950e-04, 5.197663e-04, 2.995273e-04, 8.047108e-05, -1.378609e-04, 
        -3.561288e-04, -5.742468e-04, -7.912948e-04, -1.006561e-03, -1.221347e-03, -1.436459e-03, -1.652513e-03, -1.867854e-03, 
        -2.082229e-03, -2.296697e-03, -2.511206e-03, -2.725272e-03, -2.938945e-03, -3.151963e-03, -3.364068e-03, -3.575356e-03, 
        -3.785537e-03, -3.996126e-03, -4.205662e-03, -4.413863e-03, -4.620833e-03, -4.828086e-03, -5.034579e-03, -5.239381e-03, 
        -5.442322e-03, -5.644325e-03, -5.846386e-03, -6.048032e-03, -6.249134e-03, -6.448037e-03, -6.646043e-03, -6.841923e-03, 
        -7.036523e-03, -7.230505e-03, -7.423379e-03, -7.614369e-03, -7.804266e-03, -7.992173e-03, -8.178170e-03, -8.364124e-03, 
        -8.549087e-03, -8.733346e-03, -8.918920e-03, -9.103168e-03, -9.287606e-03, -9.472283e-03, -9.655203e-03, -9.837420e-03, 
        -1.001970e-02, -1.020096e-02, -1.038267e-02, -1.056340e-02, -1.074229e-02, -1.091976e-02, -1.109704e-02, -1.127340e-02, 
        -1.144945e-02, -1.162365e-02, -1.179651e-02, -1.196920e-02, -1.214148e-02, -1.231243e-02, -1.248266e-02, -1.265180e-02, 
        -1.281936e-02, -1.298695e-02, -1.315444e-02, -1.332086e-02, -1.348694e-02, -1.365192e-02, -1.381604e-02, -1.398117e-02, 
        -1.414626e-02, -1.431091e-02, -1.447517e-02, -1.463846e-02, -1.480160e-02, -1.496485e-02, -1.512775e-02, -1.528922e-02, 
        -1.544980e-02, -1.560926e-02, -1.576820e-02, -1.592641e-02, -1.608491e-02, -1.624321e-02, -1.640017e-02, -1.655687e-02, 
        -1.671230e-02, -1.686651e-02, -1.702076e-02, -1.717454e-02, -1.732689e-02, -1.747800e-02, -1.762782e-02, -1.777712e-02, 
        -1.792688e-02, -1.807691e-02, -1.822576e-02, -1.837435e-02, -1.852222e-02, -1.866919e-02, -1.881573e-02, -1.896344e-02, 
        -1.911117e-02, -1.925852e-02, -1.940528e-02, -1.955111e-02, -1.969716e-02, -1.984384e-02, -1.999016e-02, -2.013557e-02, 
        -2.028047e-02, -2.042520e-02, -2.057056e-02, -2.071559e-02, -2.085892e-02, -2.100088e-02, -2.114227e-02, -2.128283e-02, 
        -2.142158e-02, -2.155918e-02, -2.169606e-02, -2.183246e-02, -2.196871e-02, -2.210460e-02, -2.223865e-02, -2.237185e-02, 
        -2.250417e-02, -2.263552e-02, -2.276588e-02, -2.289492e-02, -2.302223e-02, -2.314923e-02, -2.327584e-02, -2.340239e-02, 
        -2.352801e-02, -2.365306e-02, -2.377671e-02, -2.389804e-02, -2.401916e-02, -2.413960e-02, -2.425943e-02, -2.437922e-02, 
        -2.449893e-02, -2.461832e-02, -2.473598e-02, -2.485238e-02, -2.496896e-02, -2.508484e-02, -2.520058e-02, -2.531536e-02, 
        -2.542905e-02, -2.554121e-02, -2.565210e-02, -2.576196e-02, -2.586960e-02, -2.597567e-02, -2.608072e-02, -2.618498e-02, 
        -2.628824e-02, -2.639022e-02, -2.648999e-02, -2.658812e-02, -2.668522e-02, -2.678123e-02, -2.687642e-02, -2.696982e-02, 
        -2.706123e-02, -2.715124e-02, -2.724066e-02, -2.732941e-02, -2.741711e-02, -2.750363e-02, -2.758979e-02, -2.767590e-02, 
        -2.776181e-02, -2.784758e-02, -2.793144e-02, -2.801439e-02, -2.809756e-02, -2.818080e-02, -2.826359e-02, -2.834509e-02, 
        -2.842487e-02, -2.850355e-02, -2.858192e-02, -2.866000e-02, -2.873745e-02, -2.881340e-02, -2.888830e-02, -2.896095e-02, 
        -2.903270e-02, -2.910387e-02, -2.917398e-02, -2.924238e-02, -2.930963e-02, -2.937588e-02, -2.944073e-02, -2.950452e-02, 
        -2.956450e-02, -2.962310e-02, -2.968106e-02, -2.973823e-02, -2.979351e-02, -2.984713e-02, -2.989988e-02, -2.995041e-02, 
        -3.000066e-02, -3.005056e-02, -3.010012e-02, -3.014840e-02, -3.019567e-02, -3.024223e-02, -3.028617e-02, -3.032814e-02, 
        -3.036954e-02, -3.041102e-02, -3.045222e-02, -3.049327e-02, -3.053466e-02, -3.057574e-02, -3.061549e-02, -3.065404e-02, 
        -3.069146e-02, -3.072746e-02, -3.076229e-02, -3.079727e-02, -3.083157e-02, -3.086484e-02, -3.089665e-02, -3.092718e-02, 
        -3.095631e-02, -3.098415e-02, -3.101104e-02, -3.103658e-02, -3.106086e-02, -3.108326e-02, -3.110436e-02, -3.112487e-02, 
        -3.114376e-02, -3.116162e-02, -3.117918e-02, -3.119660e-02, -3.121399e-02, -3.123114e-02, -3.124711e-02, -3.126241e-02, 
        -3.127668e-02, -3.129050e-02, -3.130314e-02, -3.131486e-02, -3.132576e-02, -3.133567e-02, -3.134454e-02, -3.135222e-02, 
        -3.135904e-02, -3.136564e-02, -3.137218e-02, -3.137862e-02, -3.138390e-02, -3.138817e-02, -3.139153e-02, -3.139400e-02, 
        -3.139580e-02, -3.139690e-02, -3.139783e-02, -3.139858e-02, -3.139891e-02, -3.139831e-02, -3.139585e-02, -3.139237e-02, 
        -3.138806e-02, -3.138327e-02, -3.137886e-02, -3.137495e-02, -3.137116e-02, -3.136708e-02, -3.136174e-02, -3.135583e-02, 
        -3.135000e-02, -3.134365e-02, -3.133670e-02, -3.133094e-02, -3.132526e-02, -3.131825e-02, -3.130912e-02, -3.129914e-02, 
        -3.128862e-02, -3.127698e-02, -3.126509e-02, -3.125428e-02, -3.124434e-02, -3.123373e-02, -3.122201e-02, -3.120911e-02, 
        -3.119552e-02, -3.118113e-02, -3.116580e-02, -3.114961e-02, -3.113421e-02, -3.111750e-02, -3.110020e-02, -3.108284e-02, 
        -3.106499e-02, -3.104645e-02, -3.102719e-02, -3.100783e-02, -3.098805e-02, -3.096867e-02, -3.094856e-02, -3.092767e-02, 
        -3.090604e-02, -3.088390e-02, -3.086107e-02, -3.083835e-02, -3.081606e-02, -3.079334e-02, -3.076981e-02, -3.074538e-02, 
        -3.071995e-02, -3.069313e-02, -3.066548e-02, -3.063684e-02, -3.060647e-02, -3.057544e-02, -3.054392e-02, -3.051034e-02, 
        -3.047645e-02, -3.044176e-02, -3.040569e-02, -3.036833e-02, -3.032999e-02, -3.029101e-02, -3.025124e-02, -3.021057e-02, 
        -3.016863e-02, -3.012580e-02, -3.008211e-02, -3.003763e-02, -2.999231e-02, -2.994693e-02, -2.990135e-02, -2.985585e-02, 
        -2.980960e-02, -2.976303e-02, -2.971655e-02, -2.966943e-02, -2.962093e-02, -2.957121e-02, -2.952121e-02, -2.947046e-02, 
        -2.941903e-02, -2.936703e-02, -2.931414e-02, -2.926076e-02, -2.920690e-02, -2.915168e-02, -2.909498e-02, -2.903775e-02, 
        -2.897961e-02, -2.892032e-02, -2.886049e-02, -2.879999e-02, -2.873869e-02, -2.867589e-02, -2.861158e-02, -2.854613e-02, 
        -2.847926e-02, -2.841161e-02, -2.834415e-02, -2.827651e-02, -2.820831e-02, -2.813997e-02, -2.807145e-02, -2.800227e-02, 
        -2.793237e-02, -2.786218e-02, -2.779120e-02, -2.771971e-02, -2.764775e-02, -2.757554e-02, -2.750195e-02, -2.742777e-02, 
        -2.735320e-02, -2.727702e-02, -2.719959e-02, -2.712069e-02, -2.704102e-02, -2.695988e-02, -2.687810e-02, -2.679571e-02, 
        -2.671273e-02, -2.662901e-02, -2.654375e-02, -2.645708e-02, -2.636810e-02, -2.627746e-02, -2.618469e-02, -2.609053e-02, 
        -2.599556e-02, -2.589976e-02, -2.580349e-02, -2.570639e-02, -2.560821e-02, -2.550845e-02, -2.540844e-02, -2.530785e-02, 
        -2.520559e-02, -2.510217e-02, -2.499837e-02, -2.489339e-02, -2.478844e-02, -2.468330e-02, -2.457710e-02, -2.446992e-02, 
        -2.436192e-02, -2.425277e-02, -2.414230e-02, -2.403049e-02, -2.391828e-02, -2.380561e-02, -2.369251e-02, -2.357840e-02, 
        -2.346281e-02, -2.334630e-02, -2.322889e-02, -2.310974e-02, -2.298976e-02, -2.286840e-02, -2.274575e-02, -2.262220e-02, 
        -2.249813e-02, -2.237310e-02, -2.224729e-02, -2.212094e-02, -2.199337e-02, -2.186401e-02, -2.173349e-02, -2.160165e-02, 
        -2.146829e-02, -2.133448e-02, -2.119999e-02, -2.106507e-02, -2.092976e-02, -2.079391e-02, -2.065639e-02, -2.051733e-02, 
        -2.037726e-02, -2.023626e-02, -2.009377e-02, -1.995007e-02, -1.980568e-02, -1.966048e-02, -1.951412e-02, -1.936651e-02, 
        -1.921762e-02, -1.906792e-02, -1.891756e-02, -1.876641e-02, -1.861296e-02, -1.845867e-02, -1.830355e-02, -1.814728e-02, 
        -1.799036e-02, -1.783077e-02, -1.767085e-02, -1.751058e-02, -1.734999e-02, -1.718899e-02, -1.702579e-02, -1.686109e-02, 
        -1.669571e-02, -1.652990e-02, -1.636388e-02, -1.619736e-02, -1.603026e-02, -1.586195e-02, -1.569253e-02, -1.552149e-02, 
        -1.534850e-02, -1.517396e-02, -1.499892e-02, -1.482333e-02, -1.464706e-02, -1.446959e-02, -1.429032e-02, -1.410958e-02, 
        -1.392775e-02, -1.374517e-02, -1.356104e-02, -1.337471e-02, -1.318766e-02, -1.299876e-02, -1.280845e-02, -1.261703e-02, 
        -1.242486e-02, -1.223155e-02, -1.203656e-02, -1.184078e-02, -1.164411e-02, -1.144457e-02, -1.124374e-02, -1.104176e-02, 
        -1.083946e-02, -1.063695e-02, -1.043423e-02, -1.023041e-02, -1.002511e-02, -9.819270e-03, -9.612281e-03, -9.401320e-03, 
        -9.189639e-03, -8.978009e-03, -8.766439e-03, -8.554695e-03, -8.342656e-03, -8.130345e-03, -7.916270e-03, -7.699817e-03, 
        -7.482708e-03, -7.262805e-03, -7.040255e-03, -6.817261e-03, -6.593612e-03, -6.368892e-03, -6.143592e-03, -5.916395e-03, 
        -5.688754e-03, -5.459543e-03, -5.228324e-03, -4.994517e-03, -4.757789e-03, -4.520199e-03, -4.281770e-03, -4.040579e-03, 
        -3.798196e-03, -3.554220e-03, -3.309345e-03, -3.064056e-03, -2.817498e-03, -2.566793e-03, -2.312722e-03, -2.057098e-03, 
        -1.799981e-03, -1.542788e-03, -1.285585e-03, -1.028354e-03, -7.711852e-04, -5.140255e-04, -2.569877e-04, -7.472155e-18
    },
    {
        0.000000e+00, -3.686752e-02, -4.707916e-02, -5.424298e-02, -5.974686e-02, -6.421704e-02, -6.809730e-02, -7.150207e-02, 
        -7.456737e-02, -7.735639e-02, -7.991997e-02, -8.227440e-02, -8.439895e-02, -8.625641e-02, -8.779916e-02, -8.904610e-02, 
        -9.001451e-02, -9.072532e-02, -9.124275e-02, -9.158673e-02, -9.182539e-02, -9.200225e-02, -9.208038e-02, -9.210195e-02, 
        -9.201929e-02, -9.184150e-02, -9.158301e-02, -9.123810e-02, -9.083478e-02, -9.035514e-02, -8.977864e-02, -8.910458e-02, 
        -8.833068e-02, -8.745202e-02, -8.646511e-02, -8.537988e-02, -8.419200e-02, -8.287240e-02, -8.145336e-02, -7.994302e-02, 
        -7.834295e-02, -7.665127e-02, -7.490048e-02, -7.308915e-02, -7.122782e-02, -6.932175e-02, -6.738629e-02, -6.542944e-02, 
        -6.343609e-02, -6.141668e-02, -5.936762e-02, -5.726929e-02, -5.513005e-02, -5.294581e-02, -5.074574e-02, -4.853045e-02, 
        -4.630711e-02, -4.409634e-02, -4.189540e-02, -3.972582e-02, -3.758626e-02, -3.549378e-02, -3.341818e-02, -3.135686e-02, 
        -2.930771e-02, -2.727640e-02, -2.526127e-02, -2.327324e-02, -2.131527e-02, -1.937966e-02, -1.746311e-02, -1.557883e-02, 
        -1.372572e-02, -1.189704e-02, -1.009320e-02, -8.330456e-03, -6.600937e-03, -4.892731e-03, -3.204983e-03, -1.539323e-03, 
        1.087786e-04, 1.741523e-03, 3.357796e-03, 4.946539e-03, 6.526105e-03, 8.087222e-03, 9.623635e-03, 1.114311e-02, 
        1.263078e-02, 1.409044e-02, 1.553051e-02, 1.693758e-02, 1.832100e-02, 1.967297e-02, 2.099259e-02, 2.228373e-02, 
        2.354167e-02, 2.476117e-02, 2.593983e-02, 2.709688e-02, 2.822413e-02, 2.932345e-02, 3.039570e-02, 3.144278e-02, 
        3.247026e-02, 3.347581e-02, 3.445661e-02, 3.541730e-02, 3.635977e-02, 3.728128e-02, 3.817157e-02, 3.903504e-02, 
        3.988187e-02, 4.070002e-02, 4.147968e-02, 4.222756e-02, 4.294408e-02, 4.363506e-02, 4.429347e-02, 4.491849e-02, 
        4.550622e-02, 4.606525e-02, 4.659057e-02, 4.708795e-02, 4.755407e-02, 4.798880e-02, 4.839570e-02, 4.878390e-02, 
        4.914796e-02, 4.949170e-02, 4.981731e-02, 5.012803e-02, 5.041794e-02, 5.068709e-02, 5.093673e-02, 5.117082e-02, 
        5.139053e-02, 5.160546e-02, 5.180635e-02, 5.198778e-02, 5.216079e-02, 5.232146e-02, 5.245521e-02, 5.258058e-02, 
        5.268417e-02, 5.277219e-02, 5.284493e-02, 5.289987e-02, 5.294295e-02, 5.295232e-02, 5.293886e-02, 5.290820e-02, 
        5.285789e-02, 5.278694e-02, 5.269092e-02, 5.258416e-02, 5.245384e-02, 5.230755e-02, 5.215269e-02, 5.197809e-02, 
        5.179503e-02, 5.160154e-02, 5.138270e-02, 5.115835e-02, 5.092048e-02, 5.066528e-02, 5.040347e-02, 5.012365e-02, 
        4.983004e-02, 4.953082e-02, 4.922354e-02, 4.890520e-02, 4.855925e-02, 4.820714e-02, 4.784969e-02, 4.748517e-02, 
        4.708991e-02, 4.668237e-02, 4.626548e-02, 4.584670e-02, 4.539089e-02, 4.493146e-02, 4.446371e-02, 4.396844e-02, 
        4.345779e-02, 4.294188e-02, 4.240077e-02, 4.184042e-02, 4.127357e-02, 4.066929e-02, 4.005822e-02, 3.942501e-02, 
        3.876983e-02, 3.809920e-02, 3.740036e-02, 3.669153e-02, 3.595514e-02, 3.521205e-02, 3.445416e-02, 3.368468e-02, 
        3.290001e-02, 3.210693e-02, 3.130610e-02, 3.049788e-02, 2.969452e-02, 2.888758e-02, 2.808967e-02, 2.729010e-02, 
        2.650343e-02, 2.571092e-02, 2.492943e-02, 2.414864e-02, 2.338439e-02, 2.262252e-02, 2.186761e-02, 2.111868e-02, 
        2.037299e-02, 1.963561e-02, 1.889743e-02, 1.817550e-02, 1.745468e-02, 1.673810e-02, 1.603273e-02, 1.532968e-02, 
        1.463230e-02, 1.393855e-02, 1.324819e-02, 1.256748e-02, 1.189409e-02, 1.121913e-02, 1.055384e-02, 9.891197e-03, 
        9.226005e-03, 8.570603e-03, 7.924821e-03, 7.278813e-03, 6.636009e-03, 6.003245e-03, 5.370034e-03, 4.736873e-03, 
        4.114991e-03, 3.497752e-03, 2.884234e-03, 2.272889e-03, 1.669924e-03, 1.068295e-03, 4.689074e-04, -1.273354e-04, 
        -7.135699e-04, -1.299002e-03, -1.884465e-03, -2.465799e-03, -3.035150e-03, -3.602649e-03, -4.165791e-03, -4.726458e-03, 
        -5.272796e-03, -5.815489e-03, -6.352506e-03, -6.881806e-03, -7.399020e-03, -7.909706e-03, -8.412922e-03, -8.907683e-03, 
        -9.398501e-03, -9.875158e-03, -1.034606e-02, -1.081212e-02, -1.127346e-02, -1.172512e-02, -1.216630e-02, -1.260043e-02, 
        -1.302984e-02, -1.345338e-02, -1.386666e-02, -1.427369e-02, -1.467342e-02, -1.506746e-02, -1.545470e-02, -1.583157e-02, 
        -1.620119e-02, -1.656596e-02, -1.692563e-02, -1.728027e-02, -1.762665e-02, -1.796578e-02, -1.829915e-02, -1.862659e-02, 
        -1.894976e-02, -1.926897e-02, -1.958175e-02, -1.989009e-02, -2.019472e-02, -2.049394e-02, -2.078876e-02, -2.107657e-02, 
        -2.136162e-02, -2.164384e-02, -2.192293e-02, -2.219727e-02, -2.246562e-02, -2.273129e-02, -2.299395e-02, -2.325271e-02, 
        -2.351119e-02, -2.376432e-02, -2.401186e-02, -2.425936e-02, -2.450587e-02, -2.475234e-02, -2.500292e-02, -2.524975e-02, 
        -2.549221e-02, -2.573377e-02, -2.597303e-02, -2.620966e-02, -2.644458e-02, -2.667915e-02, -2.691132e-02, -2.714220e-02, 
        -2.736910e-02, -2.759550e-02, -2.782144e-02, -2.804273e-02, -2.826174e-02, -2.848028e-02, -2.869335e-02, -2.890189e-02, 
        -2.910718e-02, -2.930464e-02, -2.949511e-02, -2.968108e-02, -2.986668e-02, -3.004672e-02, -3.022181e-02, -3.039373e-02, 
        -3.056167e-02, -3.072471e-02, -3.088472e-02, -3.104097e-02, -3.119396e-02, -3.134184e-02, -3.148208e-02, -3.161625e-02, 
        -3.174617e-02, -3.187219e-02, -3.199329e-02, -3.210708e-02, -3.221758e-02, -3.232474e-02, -3.242694e-02, -3.252236e-02, 
        -3.261333e-02, -3.269782e-02, -3.277689e-02, -3.284772e-02, -3.291825e-02, -3.298548e-02, -3.304762e-02, -3.310467e-02, 
        -3.315795e-02, -3.320481e-02, -3.323905e-02, -3.327168e-02, -3.330400e-02, -3.333563e-02, -3.336245e-02, -3.338772e-02, 
        -3.341355e-02, -3.343043e-02, -3.344169e-02, -3.344942e-02, -3.345532e-02, -3.345876e-02, -3.346031e-02, -3.346090e-02, 
        -3.345749e-02, -3.344829e-02, -3.343847e-02, -3.342726e-02, -3.341415e-02, -3.340012e-02, -3.338378e-02, -3.336691e-02, 
        -3.334871e-02, -3.333131e-02, -3.330978e-02, -3.328701e-02, -3.326246e-02, -3.323938e-02, -3.321396e-02, -3.318061e-02, 
        -3.314734e-02, -3.311349e-02, -3.308041e-02, -3.304688e-02, -3.301147e-02, -3.297355e-02, -3.293685e-02, -3.289329e-02, 
        -3.284876e-02, -3.280400e-02, -3.276137e-02, -3.271631e-02, -3.266975e-02, -3.262341e-02, -3.257818e-02, -3.253365e-02, 
        -3.248434e-02, -3.243188e-02, -3.237650e-02, -3.232121e-02, -3.226633e-02, -3.220718e-02, -3.214571e-02, -3.208198e-02, 
        -3.201791e-02, -3.195090e-02, -3.187977e-02, -3.180300e-02, -3.172280e-02, -3.164116e-02, -3.155572e-02, -3.146735e-02, 
        -3.137357e-02, -3.127847e-02, -3.118422e-02, -3.108368e-02, -3.097873e-02, -3.087175e-02, -3.076270e-02, -3.065118e-02, 
        -3.053370e-02, -3.041047e-02, -3.028623e-02, -3.016156e-02, -3.003651e-02, -2.990797e-02, -2.977988e-02, -2.965398e-02, 
        -2.952611e-02, -2.939309e-02, -2.925492e-02, -2.911300e-02, -2.897271e-02, -2.883175e-02, -2.868896e-02, -2.854478e-02, 
        -2.839884e-02, -2.825371e-02, -2.810742e-02, -2.796095e-02, -2.781175e-02, -2.765748e-02, -2.750248e-02, -2.734364e-02, 
        -2.718256e-02, -2.701869e-02, -2.685742e-02, -2.669690e-02, -2.653339e-02, -2.637057e-02, -2.620674e-02, -2.603931e-02, 
        -2.586909e-02, -2.569720e-02, -2.552496e-02, -2.534904e-02, -2.517170e-02, -2.499340e-02, -2.481836e-02, -2.464383e-02, 
        -2.446611e-02, -2.428726e-02, -2.410204e-02, -2.391778e-02, -2.373298e-02, -2.354938e-02, -2.336368e-02, -2.317681e-02, 
        -2.298983e-02, -2.280452e-02, -2.262086e-02, -2.243574e-02, -2.224932e-02, -2.206124e-02, -2.187361e-02, -2.168629e-02, 
        -2.149628e-02, -2.130444e-02, -2.111423e-02, -2.092539e-02, -2.073661e-02, -2.054704e-02, -2.035571e-02, -2.016589e-02, 
        -1.997657e-02, -1.978525e-02, -1.959239e-02, -1.939691e-02, -1.920034e-02, -1.900579e-02, -1.881134e-02, -1.861693e-02, 
        -1.842240e-02, -1.822638e-02, -1.803051e-02, -1.783656e-02, -1.764623e-02, -1.745772e-02, -1.726663e-02, -1.707309e-02, 
        -1.687929e-02, -1.668741e-02, -1.649485e-02, -1.630447e-02, -1.611337e-02, -1.592193e-02, -1.572956e-02, -1.553841e-02, 
        -1.534620e-02, -1.515653e-02, -1.496662e-02, -1.477267e-02, -1.457842e-02, -1.438401e-02, -1.418770e-02, -1.399272e-02, 
        -1.379496e-02, -1.359669e-02, -1.340046e-02, -1.320370e-02, -1.300539e-02, -1.280573e-02, -1.260308e-02, -1.239963e-02, 
        -1.219630e-02, -1.198908e-02, -1.177731e-02, -1.156688e-02, -1.135609e-02, -1.114344e-02, -1.092908e-02, -1.071463e-02, 
        -1.049985e-02, -1.028499e-02, -1.006678e-02, -9.845976e-03, -9.624370e-03, -9.401041e-03, -9.175400e-03, -8.950493e-03, 
        -8.722643e-03, -8.491283e-03, -8.259034e-03, -8.025257e-03, -7.789180e-03, -7.551850e-03, -7.311113e-03, -7.066043e-03, 
        -6.818615e-03, -6.570490e-03, -6.322606e-03, -6.072834e-03, -5.820865e-03, -5.565984e-03, -5.309028e-03, -5.051837e-03, 
        -4.791712e-03, -4.528116e-03, -4.262771e-03, -3.996271e-03, -3.728189e-03, -3.461617e-03, -3.195312e-03, -2.928175e-03, 
        -2.661061e-03, -2.393332e-03, -2.125493e-03, -1.858081e-03, -1.590996e-03, -1.324668e-03, -1.058363e-03, -7.913172e-04, 
        -5.221920e-04, -2.510189e-04, 2.140818e-05, 2.928121e-04, 5.630597e-04, 8.352630e-04, 1.108931e-03, 1.383521e-03, 
        1.657981e-03, 1.932709e-03, 2.207605e-03, 2.482357e-03, 2.758673e-03, 3.037314e-03, 3.311569e-03, 3.585463e-03, 
        3.857855e-03, 4.131148e-03, 4.404711e-03, 4.682437e-03, 4.962140e-03, 5.241502e-03, 5.520677e-03, 5.798921e-03, 
        6.076529e-03, 6.355233e-03, 6.630229e-03, 6.896276e-03, 7.160813e-03, 7.423036e-03, 7.683619e-03, 7.942773e-03, 
        8.200177e-03, 8.456512e-03, 8.710720e-03, 8.964936e-03, 9.218669e-03, 9.469419e-03, 9.718448e-03, 9.967114e-03, 
        1.021657e-02, 1.046084e-02, 1.069793e-02, 1.093269e-02, 1.116588e-02, 1.139857e-02, 1.163240e-02, 1.186718e-02, 
        1.210047e-02, 1.233178e-02, 1.256112e-02, 1.278869e-02, 1.301435e-02, 1.324011e-02, 1.346778e-02, 1.369427e-02, 
        1.391720e-02, 1.413625e-02, 1.435342e-02, 1.457140e-02, 1.478901e-02, 1.500581e-02, 1.521804e-02, 1.542812e-02, 
        1.563485e-02, 1.583790e-02, 1.603386e-02, 1.622727e-02, 1.642084e-02, 1.661401e-02, 1.680573e-02, 1.699682e-02, 
        1.718835e-02, 1.737690e-02, 1.756313e-02, 1.774984e-02, 1.793515e-02, 1.811611e-02, 1.829717e-02, 1.847575e-02, 
        1.865394e-02, 1.883276e-02, 1.901329e-02, 1.919362e-02, 1.937381e-02, 1.955299e-02, 1.973262e-02, 1.991024e-02, 
        2.007569e-02, 2.023895e-02, 2.040218e-02, 2.056510e-02, 2.072457e-02, 2.088419e-02, 2.104356e-02, 2.119746e-02, 
        2.135005e-02, 2.150264e-02, 2.165576e-02, 2.180790e-02, 2.195855e-02, 2.210787e-02, 2.224657e-02, 2.237759e-02, 
        2.250815e-02, 2.263985e-02, 2.277238e-02, 2.290370e-02, 2.303282e-02, 2.315917e-02, 2.328280e-02, 2.340484e-02, 
        2.352691e-02, 2.364822e-02, 2.376566e-02, 2.388233e-02, 2.399686e-02, 2.410843e-02, 2.421724e-02, 2.432245e-02, 
        2.442169e-02, 2.451867e-02, 2.461635e-02, 2.471437e-02, 2.480897e-02, 2.490082e-02, 2.499110e-02, 2.508133e-02, 
        2.517542e-02, 2.527088e-02, 2.536616e-02, 2.546041e-02, 2.555259e-02, 2.564398e-02, 2.573504e-02, 2.582530e-02, 
        2.591610e-02, 2.600670e-02, 2.609049e-02, 2.616960e-02, 2.624690e-02, 2.632224e-02, 2.639638e-02, 2.646646e-02, 
        2.653611e-02, 2.660697e-02, 2.667836e-02, 2.674905e-02, 2.681822e-02, 2.688619e-02, 2.695308e-02, 2.701991e-02, 
        2.708692e-02, 2.715228e-02, 2.721881e-02, 2.728731e-02, 2.735443e-02, 2.741990e-02, 2.748351e-02, 2.754559e-02, 
        2.760754e-02, 2.766992e-02, 2.773132e-02, 2.778697e-02, 2.784087e-02, 2.789418e-02, 2.794661e-02, 2.799862e-02, 
        2.805053e-02, 2.810131e-02, 2.815085e-02, 2.820139e-02, 2.824903e-02, 2.829519e-02, 2.833650e-02, 2.837695e-02, 
        2.841817e-02, 2.846024e-02, 2.850330e-02, 2.854653e-02, 2.858834e-02, 2.862776e-02, 2.866714e-02, 2.870822e-02, 
        2.874992e-02, 2.879280e-02, 2.883658e-02, 2.887837e-02, 2.891985e-02, 2.896213e-02, 2.900452e-02, 2.904645e-02, 
        2.908751e-02, 2.912664e-02, 2.916125e-02, 2.919489e-02, 2.922734e-02, 2.925837e-02, 2.928688e-02, 2.931367e-02, 
        2.933987e-02, 2.936466e-02, 2.938917e-02, 2.941494e-02, 2.943962e-02, 2.946136e-02, 2.948006e-02, 2.949563e-02, 
        2.950960e-02, 2.952191e-02, 2.953362e-02, 2.954413e-02, 2.955414e-02, 2.956491e-02, 2.957439e-02, 2.957989e-02, 
        2.958568e-02, 2.959031e-02, 2.959346e-02, 2.959619e-02, 2.960041e-02, 2.960541e-02, 2.961041e-02, 2.961507e-02, 
        2.962047e-02, 2.962507e-02, 2.962887e-02, 2.963091e-02, 2.963218e-02, 2.963440e-02, 2.963310e-02, 2.963052e-02, 
        2.962576e-02, 2.961695e-02, 2.960482e-02, 2.959002e-02, 2.957304e-02, 2.955240e-02, 2.953086e-02, 2.950836e-02, 
        2.948497e-02, 2.946018e-02, 2.943453e-02, 2.940795e-02, 2.938030e-02, 2.935177e-02, 2.932053e-02, 2.928996e-02, 
        2.926032e-02, 2.923058e-02, 2.920033e-02, 2.916999e-02, 2.913908e-02, 2.910708e-02, 2.907456e-02, 2.904135e-02, 
        2.900909e-02, 2.897787e-02, 2.894670e-02, 2.891464e-02, 2.888131e-02, 2.884690e-02, 2.881171e-02, 2.877515e-02, 
        2.873658e-02, 2.869810e-02, 2.865913e-02, 2.861727e-02, 2.857394e-02, 2.852956e-02, 2.848188e-02, 2.843185e-02, 
        2.838120e-02, 2.832874e-02, 2.827399e-02, 2.821993e-02, 2.816489e-02, 2.810958e-02, 2.805411e-02, 2.800055e-02, 
        2.794712e-02, 2.789330e-02, 2.783867e-02, 2.778228e-02, 2.772642e-02, 2.767076e-02, 2.761538e-02, 2.755842e-02, 
        2.750172e-02, 2.744443e-02, 2.738648e-02, 2.732786e-02, 2.726752e-02, 2.720471e-02, 2.714402e-02, 2.708276e-02, 
        2.701978e-02, 2.695388e-02, 2.688552e-02, 2.681497e-02, 2.674168e-02, 2.666553e-02, 2.658529e-02, 2.650240e-02, 
        2.641919e-02, 2.633420e-02, 2.624774e-02, 2.615760e-02, 2.606572e-02, 2.597198e-02, 2.587634e-02, 2.577769e-02, 
        2.567703e-02, 2.557585e-02, 2.547455e-02, 2.537420e-02, 2.527359e-02, 2.517095e-02, 2.506483e-02, 2.495609e-02, 
        2.484646e-02, 2.473641e-02, 2.462477e-02, 2.451235e-02, 2.439961e-02, 2.428628e-02, 2.417314e-02, 2.405808e-02, 
        2.394161e-02, 2.382471e-02, 2.370691e-02, 2.358810e-02, 2.346806e-02, 2.334681e-02, 2.322358e-02, 2.309854e-02, 
        2.297210e-02, 2.284372e-02, 2.271237e-02, 2.258113e-02, 2.244906e-02, 2.231511e-02, 2.218007e-02, 2.204387e-02, 
        2.190615e-02, 2.176667e-02, 2.162626e-02, 2.148471e-02, 2.133846e-02, 2.119118e-02, 2.104237e-02, 2.089317e-02, 
        2.074246e-02, 2.058801e-02, 2.043430e-02, 2.027965e-02, 2.012410e-02, 1.996752e-02, 1.980653e-02, 1.964417e-02, 
        1.947994e-02, 1.931414e-02, 1.914714e-02, 1.897797e-02, 1.880728e-02, 1.863435e-02, 1.845874e-02, 1.828167e-02, 
        1.809997e-02, 1.791451e-02, 1.772691e-02, 1.753726e-02, 1.734495e-02, 1.714788e-02, 1.694687e-02, 1.674338e-02, 
        1.653714e-02, 1.632927e-02, 1.611793e-02, 1.590216e-02, 1.568510e-02, 1.546762e-02, 1.524848e-02, 1.502823e-02, 
        1.480667e-02, 1.458427e-02, 1.435927e-02, 1.413336e-02, 1.390664e-02, 1.367515e-02, 1.344395e-02, 1.321234e-02, 
        1.298018e-02, 1.274746e-02, 1.251421e-02, 1.228035e-02, 1.204704e-02, 1.181207e-02, 1.157563e-02, 1.133152e-02, 
        1.108539e-02, 1.083813e-02, 1.058951e-02, 1.033983e-02, 1.008932e-02, 9.837875e-03, 9.583791e-03, 9.327003e-03, 
        9.068603e-03, 8.805135e-03, 8.541302e-03, 8.276973e-03, 8.011151e-03, 7.741779e-03, 7.471056e-03, 7.199198e-03, 
        6.926701e-03, 6.652117e-03, 6.372945e-03, 6.090283e-03, 5.804499e-03, 5.518835e-03, 5.233289e-03, 4.946827e-03, 
        4.659788e-03, 4.373713e-03, 4.083638e-03, 3.791420e-03, 3.495903e-03, 3.187555e-03, 2.873031e-03, 2.557847e-03, 
        2.241773e-03, 1.924788e-03, 1.606810e-03, 1.287795e-03, 9.675759e-04, 6.462152e-04, 3.236570e-04, 7.435108e-18
    },
    {
        0.000000e+00, -6.469713e-02, -7.828328e-02, -8.686220e-02, -9.211825e-02, -9.558424e-02, -9.846409e-02, -1.007057e-01, 
        -1.024699e-01, -1.037916e-01, -1.047760e-01, -1.054649e-01, -1.057462e-01, -1.056053e-01, -1.049179e-01, -1.037458e-01, 
        -1.021393e-01, -1.002687e-01, -9.822223e-02, -9.594575e-02, -9.350405e-02, -9.096367e-02, -8.826829e-02, -8.553726e-02, 
        -8.273321e-02, -7.986001e-02, -7.690865e-02, -7.387185e-02, -7.074680e-02, -6.755361e-02, -6.429751e-02, -6.099197e-02, 
        -5.764445e-02, -5.425388e-02, -5.085381e-02, -4.744986e-02, -4.403984e-02, -4.058302e-02, -3.713389e-02, -3.370350e-02, 
        -3.029566e-02, -2.686463e-02, -2.344809e-02, -2.008649e-02, -1.671963e-02, -1.337802e-02, -1.010702e-02, -6.864855e-03, 
        -3.672138e-03, -5.307672e-04, 2.589418e-03, 5.674849e-03, 8.695555e-03, 1.171779e-02, 1.464808e-02, 1.752246e-02, 
        2.036470e-02, 2.309187e-02, 2.575660e-02, 2.832696e-02, 3.079189e-02, 3.314843e-02, 3.544774e-02, 3.764760e-02, 
        3.976008e-02, 4.179727e-02, 4.374745e-02, 4.559640e-02, 4.735952e-02, 4.903644e-02, 5.060058e-02, 5.208287e-02, 
        5.348482e-02, 5.480818e-02, 5.602395e-02, 5.716275e-02, 5.821523e-02, 5.920252e-02, 6.010275e-02, 6.094844e-02, 
        6.173664e-02, 6.243826e-02, 6.308983e-02, 6.368032e-02, 6.421476e-02, 6.469794e-02, 6.511787e-02, 6.548597e-02, 
        6.576099e-02, 6.598615e-02, 6.614675e-02, 6.624009e-02, 6.624674e-02, 6.618259e-02, 6.602643e-02, 6.579915e-02, 
        6.550360e-02, 6.512106e-02, 6.463925e-02, 6.409128e-02, 6.346120e-02, 6.275858e-02, 6.201425e-02, 6.120558e-02, 
        6.035688e-02, 5.946349e-02, 5.851048e-02, 5.750876e-02, 5.646295e-02, 5.539168e-02, 5.424992e-02, 5.308774e-02, 
        5.189343e-02, 5.066878e-02, 4.939702e-02, 4.810207e-02, 4.677344e-02, 4.542653e-02, 4.406433e-02, 4.265098e-02, 
        4.122814e-02, 3.978345e-02, 3.831821e-02, 3.683513e-02, 3.531468e-02, 3.378772e-02, 3.224818e-02, 3.070666e-02, 
        2.914897e-02, 2.758195e-02, 2.601353e-02, 2.445871e-02, 2.290973e-02, 2.136340e-02, 1.982237e-02, 1.829095e-02, 
        1.677156e-02, 1.525633e-02, 1.376226e-02, 1.226910e-02, 1.078235e-02, 9.318496e-03, 7.867929e-03, 6.432017e-03, 
        5.003915e-03, 3.604318e-03, 2.223420e-03, 8.547227e-04, -4.877055e-04, -1.807694e-03, -3.107970e-03, -4.385532e-03, 
        -5.638788e-03, -6.866865e-03, -8.074734e-03, -9.267347e-03, -1.042628e-02, -1.155523e-02, -1.266292e-02, -1.374568e-02, 
        -1.480350e-02, -1.582305e-02, -1.681563e-02, -1.776001e-02, -1.868603e-02, -1.958011e-02, -2.043513e-02, -2.125504e-02, 
        -2.205138e-02, -2.282605e-02, -2.356869e-02, -2.428369e-02, -2.496682e-02, -2.561731e-02, -2.624393e-02, -2.684944e-02, 
        -2.742411e-02, -2.797223e-02, -2.849773e-02, -2.900693e-02, -2.948752e-02, -2.994816e-02, -3.038768e-02, -3.081011e-02, 
        -3.121545e-02, -3.160541e-02, -3.197178e-02, -3.232573e-02, -3.266658e-02, -3.298497e-02, -3.328772e-02, -3.357785e-02, 
        -3.385232e-02, -3.411056e-02, -3.434806e-02, -3.457410e-02, -3.478713e-02, -3.498274e-02, -3.515363e-02, -3.531586e-02, 
        -3.546732e-02, -3.561505e-02, -3.574698e-02, -3.587096e-02, -3.596673e-02, -3.606402e-02, -3.614986e-02, -3.623441e-02, 
        -3.630137e-02, -3.636224e-02, -3.642192e-02, -3.646557e-02, -3.650864e-02, -3.652658e-02, -3.654059e-02, -3.653371e-02, 
        -3.651568e-02, -3.650123e-02, -3.647878e-02, -3.645327e-02, -3.641473e-02, -3.637458e-02, -3.633287e-02, -3.628509e-02, 
        -3.623413e-02, -3.617405e-02, -3.609516e-02, -3.601382e-02, -3.592722e-02, -3.584515e-02, -3.576005e-02, -3.566187e-02, 
        -3.555786e-02, -3.543635e-02, -3.532140e-02, -3.520260e-02, -3.506985e-02, -3.493287e-02, -3.477655e-02, -3.460915e-02, 
        -3.445059e-02, -3.428397e-02, -3.410934e-02, -3.392135e-02, -3.371533e-02, -3.350538e-02, -3.330485e-02, -3.308700e-02, 
        -3.286704e-02, -3.263976e-02, -3.240353e-02, -3.215252e-02, -3.190454e-02, -3.165636e-02, -3.140870e-02, -3.114935e-02, 
        -3.088873e-02, -3.062491e-02, -3.035330e-02, -3.008189e-02, -2.980032e-02, -2.950477e-02, -2.920876e-02, -2.890041e-02, 
        -2.857632e-02, -2.825969e-02, -2.793609e-02, -2.761030e-02, -2.728419e-02, -2.694444e-02, -2.659894e-02, -2.625316e-02, 
        -2.590819e-02, -2.555708e-02, -2.519867e-02, -2.482573e-02, -2.444520e-02, -2.405853e-02, -2.366800e-02, -2.327730e-02, 
        -2.289013e-02, -2.249635e-02, -2.209150e-02, -2.167495e-02, -2.125765e-02, -2.083612e-02, -2.041710e-02, -2.000520e-02, 
        -1.959938e-02, -1.919129e-02, -1.877985e-02, -1.835896e-02, -1.793262e-02, -1.751796e-02, -1.711021e-02, -1.671708e-02, 
        -1.633344e-02, -1.594612e-02, -1.554789e-02, -1.514211e-02, -1.473306e-02, -1.433118e-02, -1.393662e-02, -1.355774e-02, 
        -1.317637e-02, -1.279617e-02, -1.241989e-02, -1.203777e-02, -1.164872e-02, -1.125977e-02, -1.087416e-02, -1.050511e-02, 
        -1.014183e-02, -9.779162e-03, -9.419219e-03, -9.068369e-03, -8.724870e-03, -8.378705e-03, -8.025508e-03, -7.678557e-03, 
        -7.342223e-03, -7.004579e-03, -6.672211e-03, -6.340469e-03, -6.006833e-03, -5.667340e-03, -5.336685e-03, -5.008936e-03, 
        -4.681159e-03, -4.362073e-03, -4.048104e-03, -3.733661e-03, -3.409438e-03, -3.093370e-03, -2.775665e-03, -2.451900e-03, 
        -2.122110e-03, -1.808526e-03, -1.494753e-03, -1.172514e-03, -8.560255e-04, -5.530390e-04, -2.482669e-04, 6.327031e-05, 
        3.705023e-04, 6.780779e-04, 9.896990e-04, 1.303300e-03, 1.608933e-03, 1.903439e-03, 2.192033e-03, 2.478485e-03, 
        2.758963e-03, 3.041980e-03, 3.327492e-03, 3.612473e-03, 3.893617e-03, 4.170845e-03, 4.443882e-03, 4.714857e-03, 
        4.977444e-03, 5.232276e-03, 5.473099e-03, 5.719741e-03, 5.960384e-03, 6.197108e-03, 6.425966e-03, 6.652598e-03, 
        6.876645e-03, 7.096168e-03, 7.316715e-03, 7.532865e-03, 7.745077e-03, 7.954218e-03, 8.159821e-03, 8.371581e-03, 
        8.576753e-03, 8.777826e-03, 8.972151e-03, 9.174652e-03, 9.376912e-03, 9.576662e-03, 9.775730e-03, 9.973411e-03, 
        1.016606e-02, 1.035288e-02, 1.053215e-02, 1.071271e-02, 1.089768e-02, 1.107173e-02, 1.123799e-02, 1.141147e-02, 
        1.159198e-02, 1.177428e-02, 1.195221e-02, 1.212903e-02, 1.231008e-02, 1.249142e-02, 1.266480e-02, 1.283348e-02, 
        1.299771e-02, 1.316520e-02, 1.332222e-02, 1.347624e-02, 1.363001e-02, 1.378710e-02, 1.393893e-02, 1.409555e-02, 
        1.425783e-02, 1.442263e-02, 1.458512e-02, 1.474156e-02, 1.489157e-02, 1.503672e-02, 1.517820e-02, 1.531295e-02, 
        1.544401e-02, 1.557124e-02, 1.570071e-02, 1.582456e-02, 1.594279e-02, 1.606681e-02, 1.619073e-02, 1.631032e-02, 
        1.642245e-02, 1.652711e-02, 1.663151e-02, 1.673808e-02, 1.684839e-02, 1.694630e-02, 1.704264e-02, 1.714222e-02, 
        1.724219e-02, 1.734485e-02, 1.744845e-02, 1.755396e-02, 1.765652e-02, 1.775528e-02, 1.785925e-02, 1.796461e-02, 
        1.807811e-02, 1.819162e-02, 1.830988e-02, 1.843336e-02, 1.855691e-02, 1.868156e-02, 1.879863e-02, 1.891709e-02, 
        1.903567e-02, 1.915606e-02, 1.927826e-02, 1.940671e-02, 1.953632e-02, 1.966803e-02, 1.980208e-02, 1.993816e-02, 
        2.007503e-02, 2.021599e-02, 2.036183e-02, 2.050835e-02, 2.064794e-02, 2.079284e-02, 2.093873e-02, 2.108389e-02, 
        2.121629e-02, 2.134323e-02, 2.147300e-02, 2.160443e-02, 2.173438e-02, 2.186495e-02, 2.199561e-02, 2.212724e-02, 
        2.225363e-02, 2.237569e-02, 2.249110e-02, 2.260387e-02, 2.271555e-02, 2.282435e-02, 2.293389e-02, 2.303817e-02, 
        2.313783e-02, 2.323866e-02, 2.334169e-02, 2.344180e-02, 2.353482e-02, 2.362114e-02, 2.370497e-02, 2.378883e-02, 
        2.387323e-02, 2.395422e-02, 2.403218e-02, 2.410758e-02, 2.417310e-02, 2.423806e-02, 2.429789e-02, 2.435348e-02, 
        2.440469e-02, 2.445107e-02, 2.449678e-02, 2.454035e-02, 2.457773e-02, 2.460996e-02, 2.463956e-02, 2.466377e-02, 
        2.468411e-02, 2.469747e-02, 2.470441e-02, 2.470438e-02, 2.470047e-02, 2.468993e-02, 2.467398e-02, 2.466152e-02, 
        2.464754e-02, 2.463338e-02, 2.462103e-02, 2.461048e-02, 2.460505e-02, 2.460307e-02, 2.460096e-02, 2.460043e-02, 
        2.460160e-02, 2.460665e-02, 2.461550e-02, 2.462380e-02, 2.463099e-02, 2.463669e-02, 2.464766e-02, 2.465821e-02, 
        2.466327e-02, 2.466966e-02, 2.467323e-02, 2.467568e-02, 2.467941e-02, 2.468133e-02, 2.468430e-02, 2.468566e-02, 
        2.468287e-02, 2.468217e-02, 2.468345e-02, 2.468323e-02, 2.467766e-02, 2.466956e-02, 2.466029e-02, 2.465382e-02, 
        2.464682e-02, 2.463666e-02, 2.462295e-02, 2.460483e-02, 2.458508e-02, 2.456382e-02, 2.454258e-02, 2.452160e-02, 
        2.449445e-02, 2.446215e-02, 2.442702e-02, 2.438685e-02, 2.434432e-02, 2.429725e-02, 2.424789e-02, 2.419664e-02, 
        2.414239e-02, 2.408240e-02, 2.402071e-02, 2.395808e-02, 2.388684e-02, 2.381085e-02, 2.373556e-02, 2.365988e-02, 
        2.358518e-02, 2.351202e-02, 2.343433e-02, 2.335242e-02, 2.326923e-02, 2.318460e-02, 2.310367e-02, 2.302928e-02, 
        2.295453e-02, 2.287819e-02, 2.279826e-02, 2.271765e-02, 2.263280e-02, 2.254679e-02, 2.245907e-02, 2.236747e-02, 
        2.227408e-02, 2.217659e-02, 2.207895e-02, 2.197686e-02, 2.186393e-02, 2.174706e-02, 2.162682e-02, 2.150253e-02, 
        2.137813e-02, 2.124852e-02, 2.111178e-02, 2.097042e-02, 2.082634e-02, 2.067989e-02, 2.052427e-02, 2.036544e-02, 
        2.020594e-02, 2.004695e-02, 1.988641e-02, 1.972133e-02, 1.955308e-02, 1.938313e-02, 1.920888e-02, 1.903272e-02, 
        1.885401e-02, 1.867309e-02, 1.848854e-02, 1.829809e-02, 1.810801e-02, 1.791995e-02, 1.773515e-02, 1.754897e-02, 
        1.736490e-02, 1.718336e-02, 1.700188e-02, 1.681903e-02, 1.663972e-02, 1.646311e-02, 1.629235e-02, 1.612415e-02, 
        1.595575e-02, 1.578185e-02, 1.560191e-02, 1.542351e-02, 1.524853e-02, 1.507342e-02, 1.490000e-02, 1.472524e-02, 
        1.454808e-02, 1.436873e-02, 1.418834e-02, 1.400464e-02, 1.382014e-02, 1.363393e-02, 1.344717e-02, 1.325962e-02, 
        1.306770e-02, 1.287641e-02, 1.268371e-02, 1.248988e-02, 1.229512e-02, 1.209297e-02, 1.188538e-02, 1.168147e-02, 
        1.147991e-02, 1.127749e-02, 1.107289e-02, 1.086519e-02, 1.065663e-02, 1.044708e-02, 1.023466e-02, 1.001842e-02, 
        9.797728e-03, 9.575952e-03, 9.353547e-03, 9.130139e-03, 8.906888e-03, 8.680285e-03, 8.448413e-03, 8.210929e-03, 
        7.970192e-03, 7.728476e-03, 7.485796e-03, 7.241040e-03, 6.994088e-03, 6.743012e-03, 6.486717e-03, 6.228414e-03, 
        5.965036e-03, 5.703174e-03, 5.440872e-03, 5.178946e-03, 4.915254e-03, 4.649898e-03, 4.385245e-03, 4.119458e-03, 
        3.855736e-03, 3.593426e-03, 3.331036e-03, 3.070594e-03, 2.810871e-03, 2.551814e-03, 2.294389e-03, 2.038227e-03, 
        1.784816e-03, 1.536631e-03, 1.290172e-03, 1.044451e-03, 8.014830e-04, 5.612823e-04, 3.223942e-04, 8.606447e-05, 
        -1.492419e-04, -3.836474e-04, -6.161727e-04, -8.459682e-04, -1.072967e-03, -1.297765e-03, -1.521848e-03, -1.744353e-03, 
        -1.967006e-03, -2.189597e-03, -2.412024e-03, -2.634081e-03, -2.860468e-03, -3.088981e-03, -3.318789e-03, -3.549015e-03, 
        -3.781653e-03, -4.016864e-03, -4.253058e-03, -4.490186e-03, -4.729270e-03, -4.970168e-03, -5.211515e-03, -5.453856e-03, 
        -5.702097e-03, -5.950879e-03, -6.198840e-03, -6.446401e-03, -6.696393e-03, -6.948213e-03, -7.203690e-03, -7.461122e-03, 
        -7.718444e-03, -7.974375e-03, -8.228753e-03, -8.480625e-03, -8.735986e-03, -8.991849e-03, -9.247726e-03, -9.505388e-03, 
        -9.764156e-03, -1.002380e-02, -1.028405e-02, -1.054084e-02, -1.079839e-02, -1.105724e-02, -1.131689e-02, -1.157669e-02, 
        -1.183838e-02, -1.210115e-02, -1.236222e-02, -1.262037e-02, -1.288148e-02, -1.314344e-02, -1.340458e-02, -1.366718e-02, 
        -1.393092e-02, -1.419661e-02, -1.446416e-02, -1.472882e-02, -1.499741e-02, -1.527085e-02, -1.554702e-02, -1.582706e-02, 
        -1.610954e-02, -1.639179e-02, -1.667363e-02, -1.695181e-02, -1.722961e-02, -1.751060e-02, -1.779443e-02, -1.807916e-02, 
        -1.836610e-02, -1.865573e-02, -1.895005e-02, -1.924631e-02, -1.953794e-02, -1.982801e-02, -2.011786e-02, -2.040675e-02, 
        -2.069546e-02, -2.098438e-02, -2.127256e-02, -2.155927e-02, -2.184541e-02, -2.213186e-02, -2.241507e-02, -2.269731e-02, 
        -2.297683e-02, -2.325343e-02, -2.352645e-02, -2.379552e-02, -2.406015e-02, -2.432153e-02, -2.458049e-02, -2.483710e-02, 
        -2.509053e-02, -2.534055e-02, -2.558961e-02, -2.583631e-02, -2.608061e-02, -2.632558e-02, -2.656768e-02, -2.680694e-02, 
        -2.704260e-02, -2.727655e-02, -2.750937e-02, -2.774004e-02, -2.797067e-02, -2.820135e-02, -2.843305e-02, -2.866541e-02, 
        -2.889548e-02, -2.912432e-02, -2.935349e-02, -2.958233e-02, -2.981045e-02, -3.003581e-02, -3.025792e-02, -3.047710e-02, 
        -3.069430e-02, -3.090894e-02, -3.112030e-02, -3.132802e-02, -3.152953e-02, -3.172998e-02, -3.192716e-02, -3.212286e-02, 
        -3.231720e-02, -3.250905e-02, -3.269861e-02, -3.288566e-02, -3.307003e-02, -3.325347e-02, -3.343313e-02, -3.361087e-02, 
        -3.378396e-02, -3.395387e-02, -3.412284e-02, -3.429113e-02, -3.445767e-02, -3.462374e-02, -3.479154e-02, -3.495918e-02, 
        -3.512264e-02, -3.528609e-02, -3.544544e-02, -3.560309e-02, -3.575832e-02, -3.591354e-02, -3.606808e-02, -3.622087e-02, 
        -3.637071e-02, -3.651832e-02, -3.665980e-02, -3.679747e-02, -3.693382e-02, -3.706887e-02, -3.720216e-02, -3.733594e-02, 
        -3.747021e-02, -3.760209e-02, -3.773188e-02, -3.786154e-02, -3.798599e-02, -3.810754e-02, -3.822909e-02, -3.835180e-02, 
        -3.847460e-02, -3.859646e-02, -3.871935e-02, -3.884211e-02, -3.896610e-02, -3.909227e-02, -3.921192e-02, -3.932457e-02, 
        -3.943722e-02, -3.955001e-02, -3.966218e-02, -3.977233e-02, -3.988096e-02, -3.998759e-02, -4.009208e-02, -4.019456e-02, 
        -4.029081e-02, -4.037704e-02, -4.045696e-02, -4.052301e-02, -4.058132e-02, -4.063269e-02, -4.067976e-02, -4.072108e-02, 
        -4.075773e-02, -4.079054e-02, -4.081888e-02, -4.083108e-02, -4.083847e-02, -4.084045e-02, -4.083695e-02, -4.082632e-02, 
        -4.080907e-02, -4.078653e-02, -4.075970e-02, -4.073380e-02, -4.070558e-02, -4.066605e-02, -4.062168e-02, -4.057635e-02, 
        -4.053042e-02, -4.048439e-02, -4.043798e-02, -4.038752e-02, -4.033951e-02, -4.029268e-02, -4.024423e-02, -4.018799e-02, 
        -4.012350e-02, -4.005710e-02, -3.998893e-02, -3.991869e-02, -3.984632e-02, -3.977418e-02, -3.970271e-02, -3.962869e-02, 
        -3.955072e-02, -3.946492e-02, -3.936503e-02, -3.926086e-02, -3.915602e-02, -3.904906e-02, -3.894186e-02, -3.883076e-02, 
        -3.871626e-02, -3.860040e-02, -3.848227e-02, -3.835984e-02, -3.821386e-02, -3.806576e-02, -3.791635e-02, -3.776568e-02, 
        -3.761430e-02, -3.745988e-02, -3.730235e-02, -3.714267e-02, -3.698171e-02, -3.681943e-02, -3.663804e-02, -3.645160e-02, 
        -3.626004e-02, -3.606420e-02, -3.586515e-02, -3.566253e-02, -3.545444e-02, -3.524196e-02, -3.502434e-02, -3.479720e-02, 
        -3.454854e-02, -3.428425e-02, -3.401370e-02, -3.373672e-02, -3.345306e-02, -3.315869e-02, -3.285711e-02, -3.254918e-02, 
        -3.223500e-02, -3.191521e-02, -3.158003e-02, -3.122345e-02, -3.086254e-02, -3.049347e-02, -3.012136e-02, -2.974533e-02, 
        -2.936611e-02, -2.898553e-02, -2.859750e-02, -2.820706e-02, -2.781376e-02, -2.739560e-02, -2.697754e-02, -2.656104e-02, 
        -2.614437e-02, -2.572719e-02, -2.530948e-02, -2.488978e-02, -2.446722e-02, -2.404288e-02, -2.361898e-02, -2.315664e-02, 
        -2.268684e-02, -2.221551e-02, -2.174211e-02, -2.126660e-02, -2.078944e-02, -2.031042e-02, -1.983102e-02, -1.934786e-02, 
        -1.886225e-02, -1.834936e-02, -1.782041e-02, -1.728978e-02, -1.675420e-02, -1.620606e-02, -1.565660e-02, -1.510645e-02, 
        -1.455489e-02, -1.400285e-02, -1.344636e-02, -1.287052e-02, -1.227259e-02, -1.167410e-02, -1.107524e-02, -1.047727e-02, 
        -9.877835e-03, -9.273231e-03, -8.655532e-03, -8.031998e-03, -7.408098e-03, -6.768808e-03, -6.094122e-03, -5.420056e-03, 
        -4.746569e-03, -4.072105e-03, -3.396666e-03, -2.720035e-03, -2.041980e-03, -1.362527e-03, -6.818454e-04, -8.441329e-18
    },
    {
        0.000000e+00, -9.303034e-02, -1.043270e-01, -1.089305e-01, -1.112771e-01, -1.122107e-01, -1.115387e-01, -1.098958e-01, 
        -1.077653e-01, -1.051520e-01, -1.020536e-01, -9.863098e-02, -9.495198e-02, -9.115456e-02, -8.731258e-02, -8.346059e-02, 
        -7.950756e-02, -7.544519e-02, -7.124775e-02, -6.703300e-02, -6.278051e-02, -5.854203e-02, -5.428164e-02, -5.000572e-02, 
        -4.573679e-02, -4.148641e-02, -3.723481e-02, -3.300679e-02, -2.877581e-02, -2.457002e-02, -2.041787e-02, -1.635034e-02, 
        -1.237288e-02, -8.480525e-03, -4.738316e-03, -1.119081e-03, 2.362968e-03, 5.698824e-03, 8.898447e-03, 1.196393e-02, 
        1.487221e-02, 1.762636e-02, 2.027874e-02, 2.275033e-02, 2.510044e-02, 2.731678e-02, 2.936266e-02, 3.128832e-02, 
        3.306548e-02, 3.472033e-02, 3.624400e-02, 3.759164e-02, 3.879899e-02, 3.989232e-02, 4.084855e-02, 4.171747e-02, 
        4.254545e-02, 4.328453e-02, 4.397328e-02, 4.464648e-02, 4.525405e-02, 4.586957e-02, 4.648785e-02, 4.703341e-02, 
        4.750380e-02, 4.792682e-02, 4.829667e-02, 4.859971e-02, 4.886785e-02, 4.908528e-02, 4.920737e-02, 4.928087e-02, 
        4.932687e-02, 4.932539e-02, 4.923916e-02, 4.911107e-02, 4.893566e-02, 4.870492e-02, 4.839777e-02, 4.805972e-02, 
        4.765583e-02, 4.716266e-02, 4.660307e-02, 4.600542e-02, 4.529323e-02, 4.451696e-02, 4.369199e-02, 4.277729e-02, 
        4.177616e-02, 4.073652e-02, 3.962325e-02, 3.847811e-02, 3.722188e-02, 3.592511e-02, 3.456954e-02, 3.314710e-02, 
        3.167329e-02, 3.015168e-02, 2.855270e-02, 2.692613e-02, 2.527488e-02, 2.356581e-02, 2.184884e-02, 2.009119e-02, 
        1.831962e-02, 1.652453e-02, 1.469347e-02, 1.285258e-02, 1.099660e-02, 9.148225e-03, 7.268883e-03, 5.408934e-03, 
        3.540035e-03, 1.693736e-03, -1.236256e-04, -1.905663e-03, -3.687461e-03, -5.447510e-03, -7.154115e-03, -8.863895e-03, 
        -1.051590e-02, -1.215173e-02, -1.375109e-02, -1.530053e-02, -1.681718e-02, -1.828086e-02, -1.970373e-02, -2.109478e-02, 
        -2.244971e-02, -2.377175e-02, -2.506424e-02, -2.632043e-02, -2.752982e-02, -2.868364e-02, -2.978081e-02, -3.081732e-02, 
        -3.181841e-02, -3.279818e-02, -3.371280e-02, -3.459856e-02, -3.546493e-02, -3.628787e-02, -3.703949e-02, -3.776670e-02, 
        -3.846436e-02, -3.912116e-02, -3.975772e-02, -4.038634e-02, -4.098569e-02, -4.153772e-02, -4.205998e-02, -4.257041e-02, 
        -4.306705e-02, -4.355096e-02, -4.401686e-02, -4.447502e-02, -4.487894e-02, -4.525036e-02, -4.562979e-02, -4.598490e-02, 
        -4.634284e-02, -4.668134e-02, -4.696885e-02, -4.723291e-02, -4.749072e-02, -4.774066e-02, -4.796676e-02, -4.814433e-02, 
        -4.829204e-02, -4.844392e-02, -4.857639e-02, -4.868928e-02, -4.873343e-02, -4.876303e-02, -4.878049e-02, -4.878612e-02, 
        -4.870593e-02, -4.858596e-02, -4.845367e-02, -4.831608e-02, -4.807066e-02, -4.780161e-02, -4.750407e-02, -4.713799e-02, 
        -4.671949e-02, -4.627722e-02, -4.575552e-02, -4.518642e-02, -4.459805e-02, -4.389375e-02, -4.316171e-02, -4.236791e-02, 
        -4.150750e-02, -4.061161e-02, -3.961851e-02, -3.860121e-02, -3.749940e-02, -3.638053e-02, -3.518935e-02, -3.397700e-02, 
        -3.272644e-02, -3.146315e-02, -3.017875e-02, -2.888053e-02, -2.757329e-02, -2.625708e-02, -2.496456e-02, -2.366403e-02, 
        -2.238617e-02, -2.110061e-02, -1.985026e-02, -1.859525e-02, -1.739433e-02, -1.618445e-02, -1.500915e-02, -1.384491e-02, 
        -1.269358e-02, -1.158436e-02, -1.048297e-02, -9.424129e-03, -8.367092e-03, -7.325523e-03, -6.320015e-03, -5.322653e-03, 
        -4.352684e-03, -3.392985e-03, -2.433504e-03, -1.502217e-03, -5.995891e-04, 2.893460e-04, 1.154213e-03, 2.014878e-03, 
        2.881001e-03, 3.732345e-03, 4.538165e-03, 5.336501e-03, 6.127824e-03, 6.885954e-03, 7.658883e-03, 8.429773e-03, 
        9.159087e-03, 9.879434e-03, 1.058440e-02, 1.129046e-02, 1.198059e-02, 1.265760e-02, 1.330774e-02, 1.395927e-02, 
        1.457827e-02, 1.518631e-02, 1.579176e-02, 1.640320e-02, 1.697146e-02, 1.753342e-02, 1.808937e-02, 1.864566e-02, 
        1.916627e-02, 1.968177e-02, 2.019282e-02, 2.068944e-02, 2.116874e-02, 2.164423e-02, 2.210696e-02, 2.255649e-02, 
        2.300955e-02, 2.343174e-02, 2.384105e-02, 2.424369e-02, 2.463825e-02, 2.501927e-02, 2.537309e-02, 2.571329e-02, 
        2.603680e-02, 2.634311e-02, 2.663341e-02, 2.691613e-02, 2.718778e-02, 2.744777e-02, 2.768991e-02, 2.789870e-02, 
        2.807986e-02, 2.825501e-02, 2.842605e-02, 2.860068e-02, 2.875888e-02, 2.889413e-02, 2.901452e-02, 2.912205e-02, 
        2.921247e-02, 2.929385e-02, 2.937240e-02, 2.945516e-02, 2.953591e-02, 2.959643e-02, 2.964768e-02, 2.967629e-02, 
        2.969223e-02, 2.971112e-02, 2.973641e-02, 2.976402e-02, 2.978845e-02, 2.980206e-02, 2.981243e-02, 2.980830e-02, 
        2.980673e-02, 2.979774e-02, 2.977557e-02, 2.976568e-02, 2.975920e-02, 2.975318e-02, 2.975866e-02, 2.974631e-02, 
        2.972254e-02, 2.970313e-02, 2.968283e-02, 2.965906e-02, 2.963541e-02, 2.961749e-02, 2.961489e-02, 2.961390e-02, 
        2.959442e-02, 2.956762e-02, 2.954296e-02, 2.951549e-02, 2.948730e-02, 2.946392e-02, 2.943189e-02, 2.940184e-02, 
        2.936614e-02, 2.931923e-02, 2.926116e-02, 2.919633e-02, 2.914288e-02, 2.909262e-02, 2.904035e-02, 2.898404e-02, 
        2.892859e-02, 2.886306e-02, 2.879542e-02, 2.872363e-02, 2.865928e-02, 2.859319e-02, 2.852168e-02, 2.844157e-02, 
        2.836134e-02, 2.828691e-02, 2.821710e-02, 2.814341e-02, 2.805664e-02, 2.795905e-02, 2.785542e-02, 2.774758e-02, 
        2.763816e-02, 2.753532e-02, 2.744040e-02, 2.733492e-02, 2.724073e-02, 2.714756e-02, 2.705893e-02, 2.696322e-02, 
        2.686550e-02, 2.675897e-02, 2.663641e-02, 2.651716e-02, 2.640664e-02, 2.630038e-02, 2.619243e-02, 2.607988e-02, 
        2.597174e-02, 2.585216e-02, 2.573069e-02, 2.559872e-02, 2.546299e-02, 2.532555e-02, 2.518761e-02, 2.504809e-02, 
        2.489045e-02, 2.472366e-02, 2.455824e-02, 2.439427e-02, 2.422145e-02, 2.405232e-02, 2.388095e-02, 2.369445e-02, 
        2.349408e-02, 2.329504e-02, 2.308756e-02, 2.287485e-02, 2.265870e-02, 2.243203e-02, 2.219888e-02, 2.196137e-02, 
        2.171924e-02, 2.147157e-02, 2.122252e-02, 2.097307e-02, 2.072168e-02, 2.046219e-02, 2.020029e-02, 1.992333e-02, 
        1.963633e-02, 1.934764e-02, 1.905203e-02, 1.875611e-02, 1.845532e-02, 1.815623e-02, 1.785154e-02, 1.754728e-02, 
        1.725372e-02, 1.696278e-02, 1.666208e-02, 1.636052e-02, 1.605885e-02, 1.575126e-02, 1.543698e-02, 1.511962e-02, 
        1.479998e-02, 1.448403e-02, 1.417573e-02, 1.387004e-02, 1.355709e-02, 1.324904e-02, 1.295061e-02, 1.265536e-02, 
        1.235077e-02, 1.204275e-02, 1.173761e-02, 1.143932e-02, 1.114628e-02, 1.084266e-02, 1.053770e-02, 1.023308e-02, 
        9.930177e-03, 9.626567e-03, 9.322103e-03, 9.014777e-03, 8.704896e-03, 8.396409e-03, 8.091276e-03, 7.785713e-03, 
        7.486422e-03, 7.185851e-03, 6.881343e-03, 6.565880e-03, 6.247711e-03, 5.930411e-03, 5.602225e-03, 5.270708e-03, 
        4.935523e-03, 4.597738e-03, 4.252543e-03, 3.908867e-03, 3.560984e-03, 3.202739e-03, 2.842120e-03, 2.473756e-03, 
        2.107328e-03, 1.740755e-03, 1.375019e-03, 1.013677e-03, 6.468577e-04, 2.801418e-04, -9.032403e-05, -4.715020e-04, 
        -8.635331e-04, -1.265031e-03, -1.663909e-03, -2.054582e-03, -2.436957e-03, -2.817296e-03, -3.193600e-03, -3.567967e-03, 
        -3.939406e-03, -4.309288e-03, -4.694035e-03, -5.079178e-03, -5.461835e-03, -5.836651e-03, -6.207453e-03, -6.577243e-03, 
        -6.946944e-03, -7.310163e-03, -7.671361e-03, -8.024875e-03, -8.373197e-03, -8.732091e-03, -9.092484e-03, -9.449519e-03, 
        -9.793405e-03, -1.012953e-02, -1.046076e-02, -1.078905e-02, -1.111630e-02, -1.143436e-02, -1.175081e-02, -1.206400e-02, 
        -1.237265e-02, -1.268433e-02, -1.299383e-02, -1.329012e-02, -1.358470e-02, -1.387121e-02, -1.415897e-02, -1.444438e-02, 
        -1.471914e-02, -1.498634e-02, -1.525164e-02, -1.551813e-02, -1.578291e-02, -1.603966e-02, -1.629817e-02, -1.655223e-02, 
        -1.681210e-02, -1.707526e-02, -1.734172e-02, -1.760486e-02, -1.786187e-02, -1.811735e-02, -1.837155e-02, -1.862751e-02, 
        -1.888750e-02, -1.913764e-02, -1.937964e-02, -1.962844e-02, -1.988251e-02, -2.014016e-02, -2.039957e-02, -2.064958e-02, 
        -2.090213e-02, -2.115651e-02, -2.141170e-02, -2.166483e-02, -2.191784e-02, -2.216633e-02, -2.240626e-02, -2.263723e-02, 
        -2.286913e-02, -2.310855e-02, -2.335650e-02, -2.359114e-02, -2.381785e-02, -2.404510e-02, -2.427410e-02, -2.450184e-02, 
        -2.473072e-02, -2.495013e-02, -2.516223e-02, -2.537511e-02, -2.558991e-02, -2.580201e-02, -2.601053e-02, -2.621077e-02, 
        -2.640861e-02, -2.660771e-02, -2.679730e-02, -2.698717e-02, -2.717737e-02, -2.736315e-02, -2.753237e-02, -2.769801e-02, 
        -2.786297e-02, -2.802723e-02, -2.818645e-02, -2.834224e-02, -2.849099e-02, -2.864086e-02, -2.879140e-02, -2.893860e-02, 
        -2.908796e-02, -2.924236e-02, -2.939318e-02, -2.954162e-02, -2.969246e-02, -2.983721e-02, -2.997453e-02, -3.010417e-02, 
        -3.023105e-02, -3.035269e-02, -3.046869e-02, -3.058286e-02, -3.069480e-02, -3.080807e-02, -3.092121e-02, -3.102877e-02, 
        -3.112530e-02, -3.122324e-02, -3.131739e-02, -3.140554e-02, -3.148672e-02, -3.156605e-02, -3.163701e-02, -3.170708e-02, 
        -3.176903e-02, -3.182474e-02, -3.187429e-02, -3.192084e-02, -3.196329e-02, -3.199648e-02, -3.201448e-02, -3.202499e-02, 
        -3.202130e-02, -3.201297e-02, -3.200232e-02, -3.199325e-02, -3.198028e-02, -3.196750e-02, -3.195689e-02, -3.194324e-02, 
        -3.192755e-02, -3.191414e-02, -3.189178e-02, -3.185126e-02, -3.181082e-02, -3.176886e-02, -3.172515e-02, -3.168396e-02, 
        -3.164452e-02, -3.160541e-02, -3.156385e-02, -3.152518e-02, -3.148691e-02, -3.144838e-02, -3.141128e-02, -3.137727e-02, 
        -3.134623e-02, -3.130302e-02, -3.125093e-02, -3.119797e-02, -3.114230e-02, -3.108608e-02, -3.102881e-02, -3.097350e-02, 
        -3.091716e-02, -3.086050e-02, -3.079957e-02, -3.073195e-02, -3.066171e-02, -3.058957e-02, -3.051443e-02, -3.043771e-02, 
        -3.035529e-02, -3.026525e-02, -3.017571e-02, -3.009037e-02, -3.000084e-02, -2.989992e-02, -2.978251e-02, -2.965803e-02, 
        -2.952848e-02, -2.939706e-02, -2.926392e-02, -2.912811e-02, -2.899045e-02, -2.885192e-02, -2.870888e-02, -2.856516e-02, 
        -2.841528e-02, -2.825869e-02, -2.809769e-02, -2.792968e-02, -2.775836e-02, -2.758246e-02, -2.740393e-02, -2.722410e-02, 
        -2.704723e-02, -2.687288e-02, -2.668815e-02, -2.649755e-02, -2.630461e-02, -2.610554e-02, -2.590675e-02, -2.570347e-02, 
        -2.548978e-02, -2.526934e-02, -2.504801e-02, -2.482454e-02, -2.458784e-02, -2.435185e-02, -2.411539e-02, -2.387697e-02, 
        -2.364078e-02, -2.340161e-02, -2.316548e-02, -2.293494e-02, -2.270383e-02, -2.247407e-02, -2.223858e-02, -2.200098e-02, 
        -2.177069e-02, -2.154047e-02, -2.131269e-02, -2.108827e-02, -2.086330e-02, -2.064155e-02, -2.041804e-02, -2.019518e-02, 
        -1.996611e-02, -1.972738e-02, -1.948897e-02, -1.925106e-02, -1.901025e-02, -1.876611e-02, -1.852013e-02, -1.827487e-02, 
        -1.802381e-02, -1.777121e-02, -1.752035e-02, -1.726326e-02, -1.699705e-02, -1.672726e-02, -1.645387e-02, -1.618160e-02, 
        -1.591490e-02, -1.565007e-02, -1.538311e-02, -1.511497e-02, -1.484433e-02, -1.456734e-02, -1.428777e-02, -1.400771e-02, 
        -1.372098e-02, -1.343347e-02, -1.314654e-02, -1.285959e-02, -1.256813e-02, -1.227279e-02, -1.197082e-02, -1.166110e-02, 
        -1.134470e-02, -1.102884e-02, -1.071234e-02, -1.039400e-02, -1.006862e-02, -9.738795e-03, -9.403636e-03, -9.069431e-03, 
        -8.730534e-03, -8.388891e-03, -8.043898e-03, -7.701344e-03, -7.356372e-03, -7.013856e-03, -6.672303e-03, -6.330828e-03, 
        -5.985169e-03, -5.638881e-03, -5.292245e-03, -4.938486e-03, -4.579355e-03, -4.217080e-03, -3.849978e-03, -3.483144e-03, 
        -3.117564e-03, -2.752181e-03, -2.388346e-03, -2.022805e-03, -1.650467e-03, -1.269718e-03, -8.767821e-04, -4.776649e-04, 
        -7.623562e-05, 3.258055e-04, 7.280977e-04, 1.135383e-03, 1.547792e-03, 1.960457e-03, 2.375741e-03, 2.790709e-03, 
        3.212097e-03, 3.639058e-03, 4.070175e-03, 4.503332e-03, 4.939710e-03, 5.376668e-03, 5.813535e-03, 6.250691e-03, 
        6.688689e-03, 7.126667e-03, 7.570752e-03, 8.013479e-03, 8.453302e-03, 8.890125e-03, 9.323666e-03, 9.755337e-03, 
        1.018191e-02, 1.060611e-02, 1.102831e-02, 1.144729e-02, 1.186491e-02, 1.228139e-02, 1.269406e-02, 1.309953e-02, 
        1.350055e-02, 1.389704e-02, 1.428958e-02, 1.467723e-02, 1.506192e-02, 1.543798e-02, 1.581033e-02, 1.617856e-02, 
        1.654549e-02, 1.691711e-02, 1.729144e-02, 1.766769e-02, 1.804705e-02, 1.842600e-02, 1.880228e-02, 1.917798e-02, 
        1.955398e-02, 1.992866e-02, 2.030387e-02, 2.068121e-02, 2.105847e-02, 2.143718e-02, 2.181898e-02, 2.219875e-02, 
        2.257561e-02, 2.294921e-02, 2.331925e-02, 2.368520e-02, 2.405139e-02, 2.441641e-02, 2.478315e-02, 2.514632e-02, 
        2.550537e-02, 2.585931e-02, 2.620706e-02, 2.655227e-02, 2.689664e-02, 2.723573e-02, 2.757378e-02, 2.791125e-02, 
        2.824600e-02, 2.857588e-02, 2.890035e-02, 2.922019e-02, 2.953738e-02, 2.985432e-02, 3.017367e-02, 3.049323e-02, 
        3.080744e-02, 3.112068e-02, 3.143420e-02, 3.174726e-02, 3.206202e-02, 3.237597e-02, 3.268740e-02, 3.299781e-02, 
        3.330954e-02, 3.362071e-02, 3.392253e-02, 3.422280e-02, 3.452093e-02, 3.481696e-02, 3.511222e-02, 3.541007e-02, 
        3.570758e-02, 3.601007e-02, 3.631795e-02, 3.662938e-02, 3.693097e-02, 3.722511e-02, 3.751877e-02, 3.780648e-02, 
        3.809330e-02, 3.837956e-02, 3.866794e-02, 3.895995e-02, 3.925160e-02, 3.954178e-02, 3.982581e-02, 4.009569e-02, 
        4.036354e-02, 4.062970e-02, 4.089329e-02, 4.115284e-02, 4.141196e-02, 4.167269e-02, 4.192832e-02, 4.217854e-02, 
        4.241650e-02, 4.263374e-02, 4.284403e-02, 4.304530e-02, 4.324117e-02, 4.343132e-02, 4.361932e-02, 4.380622e-02, 
        4.399112e-02, 4.416706e-02, 4.433391e-02, 4.447581e-02, 4.461209e-02, 4.474297e-02, 4.486815e-02, 4.498548e-02, 
        4.510444e-02, 4.521904e-02, 4.532946e-02, 4.543084e-02, 4.552715e-02, 4.560322e-02, 4.567231e-02, 4.574352e-02, 
        4.581284e-02, 4.588116e-02, 4.595273e-02, 4.602118e-02, 4.608709e-02, 4.615217e-02, 4.621767e-02, 4.626827e-02, 
        4.630312e-02, 4.633656e-02, 4.636755e-02, 4.639629e-02, 4.642355e-02, 4.644679e-02, 4.646587e-02, 4.647318e-02, 
        4.647298e-02, 4.645929e-02, 4.642001e-02, 4.637724e-02, 4.632851e-02, 4.627617e-02, 4.621972e-02, 4.616037e-02, 
        4.609914e-02, 4.603108e-02, 4.595954e-02, 4.588228e-02, 4.576596e-02, 4.564738e-02, 4.552689e-02, 4.540092e-02, 
        4.527560e-02, 4.515920e-02, 4.503993e-02, 4.491476e-02, 4.478820e-02, 4.466109e-02, 4.449835e-02, 4.432483e-02, 
        4.414532e-02, 4.395967e-02, 4.377069e-02, 4.358043e-02, 4.338869e-02, 4.319033e-02, 4.298494e-02, 4.277253e-02, 
        4.252574e-02, 4.225473e-02, 4.197675e-02, 4.169117e-02, 4.139794e-02, 4.109385e-02, 4.078462e-02, 4.046842e-02, 
        4.014334e-02, 3.981247e-02, 3.945714e-02, 3.906555e-02, 3.866814e-02, 3.826758e-02, 3.786155e-02, 3.744989e-02, 
        3.703492e-02, 3.661620e-02, 3.618247e-02, 3.574338e-02, 3.529116e-02, 3.478797e-02, 3.428280e-02, 3.377420e-02, 
        3.326453e-02, 3.275462e-02, 3.224466e-02, 3.173934e-02, 3.123526e-02, 3.072762e-02, 3.021816e-02, 2.964021e-02, 
        2.905079e-02, 2.846012e-02, 2.786797e-02, 2.727414e-02, 2.667884e-02, 2.608199e-02, 2.548819e-02, 2.488706e-02, 
        2.428204e-02, 2.362702e-02, 2.295218e-02, 2.227662e-02, 2.159595e-02, 2.090188e-02, 2.020631e-02, 1.950435e-02, 
        1.880100e-02, 1.810477e-02, 1.740962e-02, 1.667748e-02, 1.590205e-02, 1.512578e-02, 1.434887e-02, 1.356570e-02, 
        1.277875e-02, 1.199463e-02, 1.119623e-02, 1.039175e-02, 9.595671e-03, 8.791325e-03, 7.919921e-03, 7.045715e-03, 
        6.167517e-03, 5.288726e-03, 4.409267e-03, 3.529053e-03, 2.647947e-03, 1.765928e-03, 8.832766e-04, 4.011034e-18
    },
    {
        0.000000e+00, -4.942774e-02, -5.620194e-02, -6.033508e-02, -5.956883e-02, -5.694401e-02, -5.641818e-02, -5.612780e-02, 
        -5.565626e-02, -5.512035e-02, -5.483838e-02, -5.472761e-02, -5.432260e-02, -5.318601e-02, -5.067231e-02, -4.704666e-02, 
        -4.284764e-02, -3.838921e-02, -3.397954e-02, -2.923316e-02, -2.429448e-02, -1.937010e-02, -1.465969e-02, -1.029320e-02, 
        -6.031593e-03, -1.927065e-03, 1.963398e-03, 5.518040e-03, 8.619470e-03, 1.143255e-02, 1.404786e-02, 1.645029e-02, 
        1.860436e-02, 2.056524e-02, 2.248132e-02, 2.437502e-02, 2.627858e-02, 2.807497e-02, 2.982601e-02, 3.151945e-02, 
        3.316860e-02, 3.468624e-02, 3.622281e-02, 3.772091e-02, 3.912694e-02, 4.043210e-02, 4.170604e-02, 4.286968e-02, 
        4.383504e-02, 4.481109e-02, 4.576937e-02, 4.675407e-02, 4.790732e-02, 4.898121e-02, 5.000870e-02, 5.093195e-02, 
        5.167297e-02, 5.217184e-02, 5.227566e-02, 5.205385e-02, 5.131330e-02, 5.008573e-02, 4.855362e-02, 4.685183e-02, 
        4.493919e-02, 4.285717e-02, 4.068231e-02, 3.840300e-02, 3.606937e-02, 3.367056e-02, 3.120329e-02, 2.870178e-02, 
        2.623596e-02, 2.376192e-02, 2.130460e-02, 1.887164e-02, 1.651063e-02, 1.418260e-02, 1.188893e-02, 9.681037e-03, 
        7.517575e-03, 5.432591e-03, 3.391561e-03, 1.538631e-03, -2.844528e-04, -2.015985e-03, -3.620587e-03, -5.208189e-03, 
        -6.690715e-03, -8.090300e-03, -9.482404e-03, -1.076560e-02, -1.206911e-02, -1.334254e-02, -1.455664e-02, -1.580701e-02, 
        -1.704343e-02, -1.825500e-02, -1.951005e-02, -2.078845e-02, -2.204449e-02, -2.325520e-02, -2.438905e-02, -2.545315e-02, 
        -2.642558e-02, -2.733950e-02, -2.818972e-02, -2.892898e-02, -2.958445e-02, -3.017323e-02, -3.072878e-02, -3.121372e-02, 
        -3.166043e-02, -3.205790e-02, -3.240439e-02, -3.272266e-02, -3.304446e-02, -3.336613e-02, -3.367364e-02, -3.402521e-02, 
        -3.438424e-02, -3.481048e-02, -3.524815e-02, -3.569441e-02, -3.614043e-02, -3.658523e-02, -3.702793e-02, -3.746327e-02, 
        -3.790564e-02, -3.835358e-02, -3.879603e-02, -3.924533e-02, -3.966620e-02, -4.009375e-02, -4.051143e-02, -4.088426e-02, 
        -4.125696e-02, -4.163597e-02, -4.201228e-02, -4.239476e-02, -4.277260e-02, -4.312579e-02, -4.338952e-02, -4.366793e-02, 
        -4.396312e-02, -4.420515e-02, -4.442900e-02, -4.464002e-02, -4.482948e-02, -4.495943e-02, -4.503289e-02, -4.506701e-02, 
        -4.506025e-02, -4.501793e-02, -4.494139e-02, -4.483739e-02, -4.463975e-02, -4.437333e-02, -4.408866e-02, -4.375725e-02, 
        -4.338542e-02, -4.296531e-02, -4.241919e-02, -4.182143e-02, -4.117225e-02, -4.050738e-02, -3.977809e-02, -3.895029e-02, 
        -3.804492e-02, -3.709414e-02, -3.609185e-02, -3.504401e-02, -3.386098e-02, -3.263345e-02, -3.139147e-02, -3.011820e-02, 
        -2.872601e-02, -2.728554e-02, -2.583946e-02, -2.438591e-02, -2.279293e-02, -2.118350e-02, -1.958839e-02, -1.792443e-02, 
        -1.623116e-02, -1.453449e-02, -1.277259e-02, -1.098264e-02, -9.226227e-03, -7.382607e-03, -5.560485e-03, -3.718502e-03, 
        -1.842124e-03, -5.982263e-06, 1.884596e-03, 3.715761e-03, 5.609214e-03, 7.455636e-03, 9.339029e-03, 1.119537e-02, 
        1.304122e-02, 1.484337e-02, 1.661710e-02, 1.836591e-02, 2.006511e-02, 2.174788e-02, 2.335466e-02, 2.494083e-02, 
        2.643510e-02, 2.791140e-02, 2.929740e-02, 3.065722e-02, 3.191392e-02, 3.314456e-02, 3.430343e-02, 3.540971e-02, 
        3.646118e-02, 3.743421e-02, 3.839122e-02, 3.926222e-02, 4.011405e-02, 4.093749e-02, 4.168461e-02, 4.242333e-02, 
        4.308857e-02, 4.372123e-02, 4.433603e-02, 4.488468e-02, 4.539105e-02, 4.588555e-02, 4.632587e-02, 4.674220e-02, 
        4.714128e-02, 4.748918e-02, 4.778586e-02, 4.806970e-02, 4.833884e-02, 4.855142e-02, 4.875623e-02, 4.894397e-02, 
        4.907882e-02, 4.918094e-02, 4.926698e-02, 4.934852e-02, 4.937562e-02, 4.939142e-02, 4.939379e-02, 4.937365e-02, 
        4.930145e-02, 4.922329e-02, 4.913717e-02, 4.905406e-02, 4.891887e-02, 4.877922e-02, 4.864691e-02, 4.850716e-02, 
        4.832685e-02, 4.816567e-02, 4.799680e-02, 4.783320e-02, 4.765780e-02, 4.745879e-02, 4.725898e-02, 4.705580e-02, 
        4.684707e-02, 4.661899e-02, 4.639545e-02, 4.617675e-02, 4.595969e-02, 4.572458e-02, 4.547079e-02, 4.523614e-02, 
        4.501944e-02, 4.481294e-02, 4.460572e-02, 4.441004e-02, 4.421824e-02, 4.403754e-02, 4.386717e-02, 4.368081e-02, 
        4.349568e-02, 4.332300e-02, 4.315284e-02, 4.298348e-02, 4.280567e-02, 4.261786e-02, 4.241911e-02, 4.223286e-02, 
        4.205297e-02, 4.185197e-02, 4.164386e-02, 4.143250e-02, 4.122115e-02, 4.099980e-02, 4.077129e-02, 4.053252e-02, 
        4.028345e-02, 4.003343e-02, 3.976313e-02, 3.947468e-02, 3.916118e-02, 3.882683e-02, 3.847438e-02, 3.810547e-02, 
        3.772306e-02, 3.730540e-02, 3.685602e-02, 3.638464e-02, 3.589005e-02, 3.536914e-02, 3.482636e-02, 3.425109e-02, 
        3.364158e-02, 3.301847e-02, 3.234993e-02, 3.164629e-02, 3.092118e-02, 3.014186e-02, 2.933030e-02, 2.851492e-02, 
        2.767072e-02, 2.679345e-02, 2.590840e-02, 2.500243e-02, 2.404951e-02, 2.306575e-02, 2.209714e-02, 2.112626e-02, 
        2.015158e-02, 1.917142e-02, 1.818766e-02, 1.719707e-02, 1.618570e-02, 1.519512e-02, 1.419316e-02, 1.317726e-02, 
        1.215139e-02, 1.114372e-02, 1.012906e-02, 9.111430e-03, 8.106138e-03, 7.095371e-03, 6.057204e-03, 5.009886e-03, 
        3.978694e-03, 2.942915e-03, 1.905639e-03, 8.895909e-04, -1.320180e-04, -1.177145e-03, -2.230970e-03, -3.260533e-03, 
        -4.289462e-03, -5.321955e-03, -6.345175e-03, -7.371445e-03, -8.383436e-03, -9.392233e-03, -1.039225e-02, -1.138916e-02, 
        -1.238843e-02, -1.339274e-02, -1.437815e-02, -1.536229e-02, -1.633839e-02, -1.730141e-02, -1.823734e-02, -1.917128e-02, 
        -2.011388e-02, -2.105184e-02, -2.196640e-02, -2.288619e-02, -2.380939e-02, -2.471618e-02, -2.559052e-02, -2.646637e-02, 
        -2.735472e-02, -2.822763e-02, -2.907988e-02, -2.992485e-02, -3.076427e-02, -3.158522e-02, -3.238191e-02, -3.318139e-02, 
        -3.397746e-02, -3.474015e-02, -3.547172e-02, -3.619741e-02, -3.691719e-02, -3.762212e-02, -3.828962e-02, -3.896476e-02, 
        -3.963787e-02, -4.028500e-02, -4.090150e-02, -4.150252e-02, -4.209054e-02, -4.266695e-02, -4.320766e-02, -4.374175e-02, 
        -4.427590e-02, -4.479413e-02, -4.526666e-02, -4.573208e-02, -4.618809e-02, -4.663705e-02, -4.705281e-02, -4.747072e-02, 
        -4.787753e-02, -4.827656e-02, -4.865137e-02, -4.900735e-02, -4.935996e-02, -4.970447e-02, -5.003527e-02, -5.033950e-02, 
        -5.064212e-02, -5.093999e-02, -5.122976e-02, -5.149338e-02, -5.174827e-02, -5.199781e-02, -5.223649e-02, -5.245069e-02, 
        -5.267392e-02, -5.289036e-02, -5.308399e-02, -5.323626e-02, -5.335505e-02, -5.344816e-02, -5.351148e-02, -5.354967e-02, 
        -5.354666e-02, -5.353814e-02, -5.351493e-02, -5.347344e-02, -5.342013e-02, -5.334387e-02, -5.325380e-02, -5.315332e-02, 
        -5.302734e-02, -5.286562e-02, -5.268859e-02, -5.251739e-02, -5.232002e-02, -5.209273e-02, -5.184579e-02, -5.159129e-02, 
        -5.132721e-02, -5.104986e-02, -5.074819e-02, -5.043375e-02, -5.010742e-02, -4.977912e-02, -4.944048e-02, -4.907736e-02, 
        -4.869887e-02, -4.830468e-02, -4.790432e-02, -4.748158e-02, -4.702665e-02, -4.656120e-02, -4.608877e-02, -4.562646e-02, 
        -4.514820e-02, -4.466099e-02, -4.417314e-02, -4.367368e-02, -4.316069e-02, -4.263195e-02, -4.210386e-02, -4.157405e-02, 
        -4.103127e-02, -4.047939e-02, -3.993559e-02, -3.939004e-02, -3.883940e-02, -3.828306e-02, -3.773155e-02, -3.717403e-02, 
        -3.661549e-02, -3.605951e-02, -3.551314e-02, -3.496430e-02, -3.440647e-02, -3.386595e-02, -3.333983e-02, -3.282090e-02, 
        -3.229771e-02, -3.175423e-02, -3.122185e-02, -3.069928e-02, -3.018090e-02, -2.967027e-02, -2.916218e-02, -2.866019e-02, 
        -2.816653e-02, -2.768821e-02, -2.722911e-02, -2.676853e-02, -2.631747e-02, -2.587422e-02, -2.543550e-02, -2.500765e-02, 
        -2.458189e-02, -2.415671e-02, -2.374382e-02, -2.334658e-02, -2.295395e-02, -2.256492e-02, -2.220331e-02, -2.185116e-02, 
        -2.150136e-02, -2.114806e-02, -2.077344e-02, -2.039209e-02, -2.001069e-02, -1.962643e-02, -1.924048e-02, -1.885211e-02, 
        -1.846616e-02, -1.808152e-02, -1.768378e-02, -1.729128e-02, -1.690856e-02, -1.651797e-02, -1.611085e-02, -1.569417e-02, 
        -1.526706e-02, -1.484520e-02, -1.442802e-02, -1.399961e-02, -1.356751e-02, -1.313351e-02, -1.269229e-02, -1.223855e-02, 
        -1.177302e-02, -1.130890e-02, -1.084769e-02, -1.038641e-02, -9.920370e-03, -9.459815e-03, -8.997027e-03, -8.539077e-03, 
        -8.080995e-03, -7.620812e-03, -7.154236e-03, -6.685203e-03, -6.201714e-03, -5.700616e-03, -5.192633e-03, -4.689251e-03, 
        -4.188658e-03, -3.691479e-03, -3.183011e-03, -2.668322e-03, -2.151657e-03, -1.628537e-03, -1.086054e-03, -5.227901e-04, 
        4.565609e-05, 6.164596e-04, 1.178995e-03, 1.747960e-03, 2.329319e-03, 2.914850e-03, 3.498697e-03, 4.084484e-03, 
        4.669223e-03, 5.253026e-03, 5.845171e-03, 6.442419e-03, 7.038177e-03, 7.633871e-03, 8.226937e-03, 8.821689e-03, 
        9.420432e-03, 1.002058e-02, 1.061902e-02, 1.121747e-02, 1.181805e-02, 1.241627e-02, 1.301694e-02, 1.362216e-02, 
        1.421938e-02, 1.478960e-02, 1.535054e-02, 1.590619e-02, 1.645529e-02, 1.700278e-02, 1.754731e-02, 1.808484e-02, 
        1.861915e-02, 1.915513e-02, 1.970014e-02, 2.024049e-02, 2.077330e-02, 2.130200e-02, 2.180283e-02, 2.229387e-02, 
        2.279252e-02, 2.328979e-02, 2.378641e-02, 2.427753e-02, 2.475956e-02, 2.523740e-02, 2.572076e-02, 2.620044e-02, 
        2.668112e-02, 2.715737e-02, 2.760834e-02, 2.801831e-02, 2.842659e-02, 2.883425e-02, 2.923489e-02, 2.962492e-02, 
        3.000631e-02, 3.038162e-02, 3.075594e-02, 3.113703e-02, 3.151418e-02, 3.188319e-02, 3.224468e-02, 3.259722e-02, 
        3.294979e-02, 3.327500e-02, 3.356624e-02, 3.385194e-02, 3.413390e-02, 3.441647e-02, 3.469609e-02, 3.497764e-02, 
        3.525620e-02, 3.553041e-02, 3.580024e-02, 3.606073e-02, 3.631222e-02, 3.655632e-02, 3.679405e-02, 3.702437e-02, 
        3.724145e-02, 3.744400e-02, 3.763503e-02, 3.780758e-02, 3.797359e-02, 3.811815e-02, 3.824159e-02, 3.835526e-02, 
        3.845868e-02, 3.854784e-02, 3.861961e-02, 3.868151e-02, 3.872866e-02, 3.875724e-02, 3.877605e-02, 3.878833e-02, 
        3.879805e-02, 3.880025e-02, 3.879599e-02, 3.878468e-02, 3.876084e-02, 3.873342e-02, 3.870528e-02, 3.867295e-02, 
        3.863528e-02, 3.858880e-02, 3.853180e-02, 3.846744e-02, 3.839832e-02, 3.832864e-02, 3.826046e-02, 3.819760e-02, 
        3.810429e-02, 3.800899e-02, 3.791874e-02, 3.782892e-02, 3.772060e-02, 3.761236e-02, 3.750538e-02, 3.739747e-02, 
        3.728814e-02, 3.717441e-02, 3.705464e-02, 3.693168e-02, 3.681214e-02, 3.669692e-02, 3.656380e-02, 3.640993e-02, 
        3.624536e-02, 3.607313e-02, 3.589502e-02, 3.571964e-02, 3.554758e-02, 3.537479e-02, 3.520112e-02, 3.502661e-02, 
        3.484793e-02, 3.464983e-02, 3.444898e-02, 3.424778e-02, 3.404516e-02, 3.384146e-02, 3.364158e-02, 3.343987e-02, 
        3.323213e-02, 3.302314e-02, 3.281397e-02, 3.259222e-02, 3.236374e-02, 3.212910e-02, 3.189317e-02, 3.165666e-02, 
        3.141257e-02, 3.116749e-02, 3.092317e-02, 3.067598e-02, 3.042475e-02, 3.016504e-02, 2.989867e-02, 2.962749e-02, 
        2.935065e-02, 2.906138e-02, 2.876405e-02, 2.846271e-02, 2.816342e-02, 2.786495e-02, 2.757206e-02, 2.727151e-02, 
        2.696350e-02, 2.664963e-02, 2.633198e-02, 2.601260e-02, 2.569912e-02, 2.538470e-02, 2.507121e-02, 2.476143e-02, 
        2.445594e-02, 2.414133e-02, 2.382350e-02, 2.349838e-02, 2.317493e-02, 2.285167e-02, 2.253187e-02, 2.221263e-02, 
        2.189212e-02, 2.157099e-02, 2.124493e-02, 2.090486e-02, 2.055575e-02, 2.020317e-02, 1.984898e-02, 1.949519e-02, 
        1.913724e-02, 1.877502e-02, 1.840690e-02, 1.803390e-02, 1.765454e-02, 1.728018e-02, 1.689616e-02, 1.651421e-02, 
        1.613230e-02, 1.574839e-02, 1.536175e-02, 1.497380e-02, 1.458848e-02, 1.420760e-02, 1.382438e-02, 1.343259e-02, 
        1.303983e-02, 1.265022e-02, 1.227147e-02, 1.188726e-02, 1.150222e-02, 1.112043e-02, 1.073746e-02, 1.035444e-02, 
        9.974270e-03, 9.594954e-03, 9.200553e-03, 8.800720e-03, 8.400698e-03, 8.004350e-03, 7.608551e-03, 7.216144e-03, 
        6.821407e-03, 6.426434e-03, 6.029861e-03, 5.628536e-03, 5.233361e-03, 4.845306e-03, 4.463979e-03, 4.083287e-03, 
        3.705020e-03, 3.327617e-03, 2.951562e-03, 2.576235e-03, 2.205662e-03, 1.838341e-03, 1.474079e-03, 1.108195e-03, 
        7.421916e-04, 3.808521e-04, 2.287793e-05, -3.265042e-04, -6.716933e-04, -1.008671e-03, -1.340826e-03, -1.668361e-03, 
        -1.995238e-03, -2.317955e-03, -2.635013e-03, -2.951551e-03, -3.266539e-03, -3.587078e-03, -3.920640e-03, -4.254221e-03, 
        -4.585536e-03, -4.916072e-03, -5.249222e-03, -5.584866e-03, -5.923222e-03, -6.261374e-03, -6.602499e-03, -6.942125e-03, 
        -7.277854e-03, -7.612200e-03, -7.946726e-03, -8.279381e-03, -8.611686e-03, -8.946173e-03, -9.271993e-03, -9.597305e-03, 
        -9.926970e-03, -1.025736e-02, -1.058713e-02, -1.091496e-02, -1.123693e-02, -1.154777e-02, -1.185163e-02, -1.215326e-02, 
        -1.244934e-02, -1.274713e-02, -1.304510e-02, -1.334134e-02, -1.363490e-02, -1.392559e-02, -1.421481e-02, -1.450545e-02, 
        -1.479699e-02, -1.509105e-02, -1.538179e-02, -1.567328e-02, -1.596203e-02, -1.625159e-02, -1.654580e-02, -1.684388e-02, 
        -1.714350e-02, -1.744390e-02, -1.774144e-02, -1.803897e-02, -1.832986e-02, -1.861655e-02, -1.890207e-02, -1.919060e-02, 
        -1.947551e-02, -1.975853e-02, -2.003435e-02, -2.030911e-02, -2.058764e-02, -2.087049e-02, -2.114509e-02, -2.140793e-02, 
        -2.166401e-02, -2.191575e-02, -2.216553e-02, -2.241441e-02, -2.266377e-02, -2.291306e-02, -2.316472e-02, -2.341229e-02, 
        -2.365436e-02, -2.387535e-02, -2.409555e-02, -2.431321e-02, -2.452835e-02, -2.474030e-02, -2.494991e-02, -2.515961e-02, 
        -2.536702e-02, -2.557086e-02, -2.576876e-02, -2.594413e-02, -2.611726e-02, -2.628871e-02, -2.645848e-02, -2.662294e-02, 
        -2.678332e-02, -2.694499e-02, -2.710695e-02, -2.726485e-02, -2.742393e-02, -2.756317e-02, -2.769724e-02, -2.783294e-02, 
        -2.796886e-02, -2.810566e-02, -2.824310e-02, -2.838025e-02, -2.851599e-02, -2.865608e-02, -2.879542e-02, -2.891674e-02, 
        -2.902496e-02, -2.913312e-02, -2.924063e-02, -2.934805e-02, -2.945552e-02, -2.955898e-02, -2.965715e-02, -2.975098e-02, 
        -2.984358e-02, -2.992523e-02, -2.998339e-02, -3.004271e-02, -3.009951e-02, -3.015406e-02, -3.019989e-02, -3.024388e-02, 
        -3.028488e-02, -3.031982e-02, -3.035221e-02, -3.037962e-02, -3.036888e-02, -3.035598e-02, -3.033809e-02, -3.031826e-02, 
        -3.029319e-02, -3.027401e-02, -3.026247e-02, -3.025223e-02, -3.024180e-02, -3.023034e-02, -3.018051e-02, -3.012447e-02, 
        -3.006679e-02, -3.000334e-02, -2.993978e-02, -2.987663e-02, -2.981411e-02, -2.974799e-02, -2.967617e-02, -2.960237e-02, 
        -2.949654e-02, -2.936942e-02, -2.923805e-02, -2.910164e-02, -2.896236e-02, -2.881608e-02, -2.866542e-02, -2.851460e-02, 
        -2.835908e-02, -2.820026e-02, -2.801855e-02, -2.780135e-02, -2.757821e-02, -2.735127e-02, -2.711877e-02, -2.688338e-02, 
        -2.664550e-02, -2.640613e-02, -2.616013e-02, -2.591142e-02, -2.565332e-02, -2.534148e-02, -2.501931e-02, -2.469332e-02, 
        -2.436732e-02, -2.404210e-02, -2.371715e-02, -2.339278e-02, -2.307412e-02, -2.275437e-02, -2.243056e-02, -2.204322e-02, 
        -2.164620e-02, -2.125142e-02, -2.085845e-02, -2.046642e-02, -2.007482e-02, -1.968302e-02, -1.928721e-02, -1.888776e-02, 
        -1.848611e-02, -1.803246e-02, -1.755346e-02, -1.707420e-02, -1.659252e-02, -1.610423e-02, -1.561354e-02, -1.511842e-02, 
        -1.462232e-02, -1.412584e-02, -1.362301e-02, -1.307952e-02, -1.248736e-02, -1.189278e-02, -1.129640e-02, -1.069338e-02, 
        -1.008949e-02, -9.484904e-03, -8.873625e-03, -8.260552e-03, -7.650085e-03, -7.016932e-03, -6.315541e-03, -5.610504e-03, 
        -4.902638e-03, -4.196229e-03, -3.491864e-03, -2.789194e-03, -2.088697e-03, -1.390051e-03, -6.939679e-04, 7.302615e-18
    },
    {
        0.000000e+00, 1.648656e-01, 1.665361e-01, 1.587156e-01, 1.482945e-01, 1.367121e-01, 1.248286e-01, 1.123901e-01, 
        1.003328e-01, 8.868965e-02, 7.747023e-02, 6.684091e-02, 5.697325e-02, 4.802379e-02, 3.948657e-02, 3.107607e-02, 
        2.273036e-02, 1.463456e-02, 7.107590e-03, 3.194369e-04, -5.674128e-03, -1.068986e-02, -1.490075e-02, -1.856333e-02, 
        -2.140829e-02, -2.369741e-02, -2.582885e-02, -2.797068e-02, -3.036549e-02, -3.301093e-02, -3.583747e-02, -3.874029e-02, 
        -4.151691e-02, -4.409961e-02, -4.654450e-02, -4.871264e-02, -5.055134e-02, -5.199464e-02, -5.342826e-02, -5.483972e-02, 
        -5.610964e-02, -5.707460e-02, -5.788090e-02, -5.844096e-02, -5.862796e-02, -5.841032e-02, -5.776606e-02, -5.671255e-02, 
        -5.530392e-02, -5.367291e-02, -5.185020e-02, -4.960074e-02, -4.698220e-02, -4.393180e-02, -4.064743e-02, -3.711994e-02, 
        -3.339834e-02, -2.964691e-02, -2.581521e-02, -2.207445e-02, -1.846601e-02, -1.502998e-02, -1.155335e-02, -8.126644e-03, 
        -4.756059e-03, -1.400728e-03, 1.962585e-03, 5.239039e-03, 8.424385e-03, 1.154155e-02, 1.452822e-02, 1.738345e-02, 
        2.007916e-02, 2.267727e-02, 2.507508e-02, 2.724398e-02, 2.918630e-02, 3.097799e-02, 3.251732e-02, 3.378478e-02, 
        3.479866e-02, 3.553151e-02, 3.607182e-02, 3.634344e-02, 3.642145e-02, 3.636087e-02, 3.614136e-02, 3.580433e-02, 
        3.526922e-02, 3.470799e-02, 3.413901e-02, 3.350797e-02, 3.284612e-02, 3.219442e-02, 3.155684e-02, 3.097272e-02, 
        3.048014e-02, 3.007404e-02, 2.974699e-02, 2.953383e-02, 2.933729e-02, 2.911774e-02, 2.896211e-02, 2.881185e-02, 
        2.870212e-02, 2.861064e-02, 2.853348e-02, 2.851805e-02, 2.856296e-02, 2.866926e-02, 2.866844e-02, 2.870975e-02, 
        2.878630e-02, 2.887089e-02, 2.890231e-02, 2.888916e-02, 2.880110e-02, 2.868867e-02, 2.852794e-02, 2.823901e-02, 
        2.785424e-02, 2.738615e-02, 2.681202e-02, 2.619428e-02, 2.553211e-02, 2.482031e-02, 2.403611e-02, 2.320999e-02, 
        2.231290e-02, 2.137543e-02, 2.035766e-02, 1.928418e-02, 1.815463e-02, 1.690966e-02, 1.558195e-02, 1.415801e-02, 
        1.263356e-02, 1.102963e-02, 9.399969e-03, 7.696888e-03, 5.979689e-03, 4.227131e-03, 2.499382e-03, 8.100498e-04, 
        -9.187090e-04, -2.584860e-03, -4.211633e-03, -5.814482e-03, -7.312234e-03, -8.750723e-03, -1.008900e-02, -1.132133e-02, 
        -1.245027e-02, -1.345079e-02, -1.439867e-02, -1.531712e-02, -1.616317e-02, -1.693821e-02, -1.768208e-02, -1.840368e-02, 
        -1.909185e-02, -1.975477e-02, -2.033744e-02, -2.081399e-02, -2.126617e-02, -2.172850e-02, -2.213712e-02, -2.249120e-02, 
        -2.279416e-02, -2.307447e-02, -2.332246e-02, -2.356600e-02, -2.376032e-02, -2.391474e-02, -2.406796e-02, -2.420042e-02, 
        -2.427748e-02, -2.432112e-02, -2.436340e-02, -2.440945e-02, -2.438278e-02, -2.435546e-02, -2.431735e-02, -2.425829e-02, 
        -2.414404e-02, -2.403202e-02, -2.386826e-02, -2.370082e-02, -2.356622e-02, -2.336001e-02, -2.315214e-02, -2.292051e-02, 
        -2.268686e-02, -2.246260e-02, -2.220474e-02, -2.197391e-02, -2.173555e-02, -2.152616e-02, -2.130609e-02, -2.114136e-02, 
        -2.099700e-02, -2.089786e-02, -2.081976e-02, -2.075867e-02, -2.072316e-02, -2.070624e-02, -2.071699e-02, -2.072785e-02, 
        -2.076722e-02, -2.082479e-02, -2.093703e-02, -2.105672e-02, -2.120003e-02, -2.133434e-02, -2.150244e-02, -2.168458e-02, 
        -2.189217e-02, -2.212635e-02, -2.237097e-02, -2.263425e-02, -2.289521e-02, -2.315157e-02, -2.341235e-02, -2.368894e-02, 
        -2.397271e-02, -2.425522e-02, -2.452157e-02, -2.478456e-02, -2.505032e-02, -2.530129e-02, -2.555797e-02, -2.581819e-02, 
        -2.603833e-02, -2.625279e-02, -2.647385e-02, -2.667508e-02, -2.686011e-02, -2.704261e-02, -2.719508e-02, -2.733054e-02, 
        -2.745848e-02, -2.756610e-02, -2.763009e-02, -2.767220e-02, -2.769987e-02, -2.770107e-02, -2.767007e-02, -2.760205e-02, 
        -2.750579e-02, -2.735505e-02, -2.716490e-02, -2.693854e-02, -2.668225e-02, -2.638386e-02, -2.607343e-02, -2.573004e-02, 
        -2.535863e-02, -2.498160e-02, -2.456642e-02, -2.412605e-02, -2.367505e-02, -2.319377e-02, -2.268316e-02, -2.213112e-02, 
        -2.155380e-02, -2.097018e-02, -2.036167e-02, -1.974150e-02, -1.909899e-02, -1.842746e-02, -1.772967e-02, -1.698337e-02, 
        -1.619778e-02, -1.538115e-02, -1.454251e-02, -1.365695e-02, -1.273126e-02, -1.175674e-02, -1.074279e-02, -9.707857e-03, 
        -8.649348e-03, -7.556388e-03, -6.432324e-03, -5.281657e-03, -4.109176e-03, -2.902809e-03, -1.669971e-03, -4.117346e-04, 
        8.621738e-04, 2.148278e-03, 3.458079e-03, 4.785930e-03, 6.133727e-03, 7.489635e-03, 8.865912e-03, 1.023105e-02, 
        1.158935e-02, 1.296441e-02, 1.434801e-02, 1.574195e-02, 1.713846e-02, 1.852877e-02, 1.991088e-02, 2.126416e-02, 
        2.261031e-02, 2.397137e-02, 2.531392e-02, 2.665901e-02, 2.798396e-02, 2.928033e-02, 3.054636e-02, 3.178414e-02, 
        3.300126e-02, 3.417977e-02, 3.534837e-02, 3.650872e-02, 3.762551e-02, 3.870045e-02, 3.976638e-02, 4.077133e-02, 
        4.173600e-02, 4.266960e-02, 4.355760e-02, 4.438432e-02, 4.514259e-02, 4.589849e-02, 4.662923e-02, 4.733018e-02, 
        4.801000e-02, 4.867431e-02, 4.931472e-02, 4.993573e-02, 5.052049e-02, 5.106986e-02, 5.160527e-02, 5.211652e-02, 
        5.260214e-02, 5.304062e-02, 5.346881e-02, 5.387821e-02, 5.420717e-02, 5.449126e-02, 5.474501e-02, 5.494970e-02, 
        5.511051e-02, 5.524536e-02, 5.535545e-02, 5.541000e-02, 5.541096e-02, 5.536532e-02, 5.530058e-02, 5.517370e-02, 
        5.502575e-02, 5.487469e-02, 5.469684e-02, 5.447889e-02, 5.422841e-02, 5.394265e-02, 5.359705e-02, 5.323359e-02, 
        5.286278e-02, 5.249040e-02, 5.208851e-02, 5.166377e-02, 5.124845e-02, 5.078865e-02, 5.028231e-02, 4.975251e-02, 
        4.920314e-02, 4.862747e-02, 4.804810e-02, 4.746467e-02, 4.687119e-02, 4.622861e-02, 4.555613e-02, 4.486221e-02, 
        4.416155e-02, 4.344962e-02, 4.270468e-02, 4.197747e-02, 4.125476e-02, 4.051170e-02, 3.976138e-02, 3.900479e-02, 
        3.822912e-02, 3.743441e-02, 3.663669e-02, 3.585483e-02, 3.509600e-02, 3.431744e-02, 3.353552e-02, 3.276933e-02, 
        3.200522e-02, 3.124753e-02, 3.048262e-02, 2.971426e-02, 2.897447e-02, 2.824838e-02, 2.750587e-02, 2.677799e-02, 
        2.606182e-02, 2.536254e-02, 2.464162e-02, 2.395793e-02, 2.330333e-02, 2.267578e-02, 2.203233e-02, 2.138238e-02, 
        2.074968e-02, 2.013979e-02, 1.952581e-02, 1.889132e-02, 1.823326e-02, 1.758423e-02, 1.692307e-02, 1.623585e-02, 
        1.551742e-02, 1.480768e-02, 1.409884e-02, 1.340131e-02, 1.271451e-02, 1.202882e-02, 1.135416e-02, 1.067201e-02, 
        9.968630e-03, 9.247445e-03, 8.509544e-03, 7.775959e-03, 7.038999e-03, 6.280407e-03, 5.523698e-03, 4.777245e-03, 
        4.030875e-03, 3.290009e-03, 2.543304e-03, 1.789783e-03, 1.011804e-03, 2.362518e-04, -5.346216e-04, -1.316201e-03, 
        -2.105008e-03, -2.886694e-03, -3.658983e-03, -4.446426e-03, -5.240270e-03, -6.035550e-03, -6.841524e-03, -7.655121e-03, 
        -8.459005e-03, -9.266256e-03, -1.009471e-02, -1.091878e-02, -1.173407e-02, -1.254942e-02, -1.335987e-02, -1.418019e-02, 
        -1.497996e-02, -1.576961e-02, -1.657450e-02, -1.737380e-02, -1.818221e-02, -1.897833e-02, -1.976453e-02, -2.054819e-02, 
        -2.133598e-02, -2.212494e-02, -2.290213e-02, -2.365877e-02, -2.439701e-02, -2.513541e-02, -2.589567e-02, -2.664362e-02, 
        -2.738065e-02, -2.811278e-02, -2.886028e-02, -2.959162e-02, -3.031390e-02, -3.103428e-02, -3.175000e-02, -3.245801e-02, 
        -3.316228e-02, -3.384967e-02, -3.453199e-02, -3.519807e-02, -3.586001e-02, -3.652391e-02, -3.718030e-02, -3.782117e-02, 
        -3.843542e-02, -3.904701e-02, -3.965390e-02, -4.024772e-02, -4.082225e-02, -4.137917e-02, -4.192935e-02, -4.246910e-02, 
        -4.300001e-02, -4.352846e-02, -4.404700e-02, -4.453667e-02, -4.500289e-02, -4.544391e-02, -4.587197e-02, -4.627895e-02, 
        -4.666678e-02, -4.703594e-02, -4.739371e-02, -4.774283e-02, -4.808899e-02, -4.841911e-02, -4.874365e-02, -4.905338e-02, 
        -4.935911e-02, -4.966440e-02, -4.996350e-02, -5.024957e-02, -5.050456e-02, -5.074863e-02, -5.098292e-02, -5.120698e-02, 
        -5.142354e-02, -5.161209e-02, -5.178359e-02, -5.195647e-02, -5.212073e-02, -5.227669e-02, -5.241440e-02, -5.252967e-02, 
        -5.264015e-02, -5.273358e-02, -5.281561e-02, -5.289321e-02, -5.296201e-02, -5.300858e-02, -5.303278e-02, -5.303784e-02, 
        -5.302831e-02, -5.300271e-02, -5.296007e-02, -5.289239e-02, -5.280832e-02, -5.271210e-02, -5.260884e-02, -5.249797e-02, 
        -5.238561e-02, -5.224753e-02, -5.208700e-02, -5.190544e-02, -5.170276e-02, -5.148356e-02, -5.125040e-02, -5.098638e-02, 
        -5.070225e-02, -5.040520e-02, -5.007878e-02, -4.973669e-02, -4.937999e-02, -4.901314e-02, -4.860741e-02, -4.817192e-02, 
        -4.771127e-02, -4.723127e-02, -4.673206e-02, -4.621924e-02, -4.568841e-02, -4.514000e-02, -4.457640e-02, -4.400028e-02, 
        -4.341116e-02, -4.280731e-02, -4.219416e-02, -4.157232e-02, -4.092678e-02, -4.025705e-02, -3.956513e-02, -3.885764e-02, 
        -3.815207e-02, -3.743736e-02, -3.671728e-02, -3.598237e-02, -3.524156e-02, -3.449909e-02, -3.376225e-02, -3.302115e-02, 
        -3.225729e-02, -3.147250e-02, -3.067132e-02, -2.987300e-02, -2.909771e-02, -2.831407e-02, -2.751718e-02, -2.670992e-02, 
        -2.589341e-02, -2.505947e-02, -2.422223e-02, -2.339326e-02, -2.255378e-02, -2.168102e-02, -2.083297e-02, -1.998217e-02, 
        -1.911538e-02, -1.824876e-02, -1.738020e-02, -1.650432e-02, -1.561513e-02, -1.473073e-02, -1.385448e-02, -1.296939e-02, 
        -1.208226e-02, -1.117867e-02, -1.029849e-02, -9.443680e-03, -8.587966e-03, -7.731475e-03, -6.874128e-03, -6.026714e-03, 
        -5.182423e-03, -4.338335e-03, -3.494409e-03, -2.646398e-03, -1.786433e-03, -9.332632e-04, -8.711178e-05, 7.550747e-04, 
        1.603341e-03, 2.435620e-03, 3.211347e-03, 3.983251e-03, 4.751629e-03, 5.523783e-03, 6.307042e-03, 7.080800e-03, 
        7.847702e-03, 8.614441e-03, 9.387861e-03, 1.015561e-02, 1.090676e-02, 1.164601e-02, 1.238417e-02, 1.312293e-02, 
        1.386531e-02, 1.460412e-02, 1.533420e-02, 1.605149e-02, 1.676201e-02, 1.744608e-02, 1.809224e-02, 1.872866e-02, 
        1.935607e-02, 1.995618e-02, 2.049669e-02, 2.100994e-02, 2.151096e-02, 2.199572e-02, 2.247969e-02, 2.296158e-02, 
        2.344297e-02, 2.392009e-02, 2.438694e-02, 2.485870e-02, 2.531045e-02, 2.573474e-02, 2.616205e-02, 2.655987e-02, 
        2.693471e-02, 2.731010e-02, 2.769128e-02, 2.805704e-02, 2.841248e-02, 2.877477e-02, 2.913777e-02, 2.950030e-02, 
        2.977982e-02, 3.004592e-02, 3.031101e-02, 3.057765e-02, 3.084844e-02, 3.112298e-02, 3.139820e-02, 3.162949e-02, 
        3.185257e-02, 3.208182e-02, 3.230989e-02, 3.253178e-02, 3.275634e-02, 3.297829e-02, 3.313283e-02, 3.323217e-02, 
        3.332072e-02, 3.341181e-02, 3.349416e-02, 3.356566e-02, 3.363237e-02, 3.370015e-02, 3.377932e-02, 3.386042e-02, 
        3.394486e-02, 3.403215e-02, 3.406932e-02, 3.409846e-02, 3.413776e-02, 3.418040e-02, 3.422501e-02, 3.424525e-02, 
        3.422114e-02, 3.417634e-02, 3.413455e-02, 3.408325e-02, 3.401298e-02, 3.392511e-02, 3.383990e-02, 3.375620e-02, 
        3.367675e-02, 3.358883e-02, 3.349950e-02, 3.340714e-02, 3.331938e-02, 3.323020e-02, 3.314692e-02, 3.305986e-02, 
        3.297870e-02, 3.289542e-02, 3.274754e-02, 3.256955e-02, 3.239759e-02, 3.222514e-02, 3.206015e-02, 3.185798e-02, 
        3.163931e-02, 3.142029e-02, 3.120606e-02, 3.099147e-02, 3.078312e-02, 3.058375e-02, 3.039738e-02, 3.020910e-02, 
        3.002362e-02, 2.981420e-02, 2.960401e-02, 2.938910e-02, 2.917766e-02, 2.897555e-02, 2.877144e-02, 2.856065e-02, 
        2.835637e-02, 2.815078e-02, 2.793368e-02, 2.769597e-02, 2.746005e-02, 2.722942e-02, 2.699053e-02, 2.675156e-02, 
        2.650981e-02, 2.625312e-02, 2.597252e-02, 2.569708e-02, 2.540580e-02, 2.511809e-02, 2.479944e-02, 2.448592e-02, 
        2.417578e-02, 2.387068e-02, 2.356427e-02, 2.325824e-02, 2.295043e-02, 2.263333e-02, 2.232220e-02, 2.202341e-02, 
        2.173364e-02, 2.144986e-02, 2.116938e-02, 2.086964e-02, 2.057378e-02, 2.028044e-02, 1.998937e-02, 1.969730e-02, 
        1.940195e-02, 1.909499e-02, 1.877959e-02, 1.846487e-02, 1.815038e-02, 1.783068e-02, 1.750917e-02, 1.718671e-02, 
        1.686427e-02, 1.654390e-02, 1.623152e-02, 1.592384e-02, 1.561504e-02, 1.530114e-02, 1.498188e-02, 1.465636e-02, 
        1.433815e-02, 1.403352e-02, 1.373639e-02, 1.342216e-02, 1.309391e-02, 1.275781e-02, 1.242559e-02, 1.207810e-02, 
        1.173428e-02, 1.140391e-02, 1.108416e-02, 1.077798e-02, 1.048570e-02, 1.020012e-02, 9.921276e-03, 9.644519e-03, 
        9.369857e-03, 9.098682e-03, 8.832246e-03, 8.574583e-03, 8.325964e-03, 8.081838e-03, 7.824745e-03, 7.566522e-03, 
        7.304365e-03, 7.025837e-03, 6.736105e-03, 6.452535e-03, 6.173803e-03, 5.874006e-03, 5.565829e-03, 5.253627e-03, 
        4.936111e-03, 4.619931e-03, 4.308389e-03, 3.997063e-03, 3.688517e-03, 3.384718e-03, 3.085927e-03, 2.790003e-03, 
        2.490607e-03, 2.193412e-03, 1.900456e-03, 1.610615e-03, 1.322726e-03, 1.037343e-03, 7.594792e-04, 4.910713e-04, 
        2.356175e-04, -1.957448e-05, -2.714582e-04, -5.211445e-04, -7.739405e-04, -1.036034e-03, -1.301894e-03, -1.563699e-03, 
        -1.819830e-03, -2.077159e-03, -2.332951e-03, -2.612326e-03, -2.895497e-03, -3.177904e-03, -3.472516e-03, -3.769982e-03, 
        -4.063370e-03, -4.352682e-03, -4.642165e-03, -4.926231e-03, -5.204860e-03, -5.470016e-03, -5.730434e-03, -5.995383e-03, 
        -6.259866e-03, -6.523060e-03, -6.781593e-03, -7.027385e-03, -7.271532e-03, -7.527287e-03, -7.778510e-03, -8.016796e-03, 
        -8.255041e-03, -8.493239e-03, -8.731262e-03, -8.963758e-03, -9.185029e-03, -9.395365e-03, -9.600169e-03, -9.808688e-03, 
        -1.001340e-02, -1.021733e-02, -1.041848e-02, -1.061300e-02, -1.080893e-02, -1.100560e-02, -1.119920e-02, -1.138785e-02, 
        -1.157160e-02, -1.175489e-02, -1.193350e-02, -1.210295e-02, -1.227393e-02, -1.244484e-02, -1.261508e-02, -1.278251e-02, 
        -1.294720e-02, -1.310460e-02, -1.325741e-02, -1.341275e-02, -1.356422e-02, -1.370696e-02, -1.385329e-02, -1.399826e-02, 
        -1.414139e-02, -1.428106e-02, -1.441340e-02, -1.454424e-02, -1.468369e-02, -1.482951e-02, -1.497436e-02, -1.511291e-02, 
        -1.523863e-02, -1.536186e-02, -1.548562e-02, -1.560976e-02, -1.573294e-02, -1.586050e-02, -1.599093e-02, -1.611575e-02, 
        -1.623399e-02, -1.634727e-02, -1.644925e-02, -1.655056e-02, -1.665475e-02, -1.676844e-02, -1.689201e-02, -1.701580e-02, 
        -1.713525e-02, -1.725052e-02, -1.736236e-02, -1.746980e-02, -1.755745e-02, -1.764517e-02, -1.773411e-02, -1.781477e-02, 
        -1.789968e-02, -1.798563e-02, -1.806995e-02, -1.815155e-02, -1.823102e-02, -1.831059e-02, -1.837418e-02, -1.842858e-02, 
        -1.847832e-02, -1.852947e-02, -1.858231e-02, -1.863194e-02, -1.867564e-02, -1.871700e-02, -1.875366e-02, -1.878402e-02, 
        -1.880018e-02, -1.880857e-02, -1.881712e-02, -1.882766e-02, -1.884144e-02, -1.885651e-02, -1.885886e-02, -1.884915e-02, 
        -1.883217e-02, -1.881215e-02, -1.878209e-02, -1.873678e-02, -1.869086e-02, -1.864542e-02, -1.859411e-02, -1.853495e-02, 
        -1.847190e-02, -1.840220e-02, -1.831816e-02, -1.822767e-02, -1.813060e-02, -1.801172e-02, -1.788443e-02, -1.775050e-02, 
        -1.761483e-02, -1.747844e-02, -1.734003e-02, -1.719173e-02, -1.703209e-02, -1.686579e-02, -1.669635e-02, -1.649078e-02, 
        -1.628269e-02, -1.607659e-02, -1.587214e-02, -1.566752e-02, -1.546166e-02, -1.525455e-02, -1.503455e-02, -1.478548e-02, 
        -1.452899e-02, -1.425048e-02, -1.396035e-02, -1.366830e-02, -1.337109e-02, -1.306368e-02, -1.275516e-02, -1.243027e-02, 
        -1.210254e-02, -1.175701e-02, -1.137430e-02, -1.096938e-02, -1.054174e-02, -1.010800e-02, -9.668676e-03, -9.208381e-03, 
        -8.736989e-03, -8.262726e-03, -7.778388e-03, -7.290102e-03, -6.785662e-03, -6.208459e-03, -5.604584e-03, -4.990339e-03, 
        -4.363681e-03, -3.737213e-03, -3.111566e-03, -2.486590e-03, -1.863048e-03, -1.240486e-03, -6.196939e-04, -1.779836e-17
    },
    {
        0.000000e+00, 1.502618e-01, 1.494584e-01, 1.430128e-01, 1.382886e-01, 1.342618e-01, 1.274038e-01, 1.198531e-01, 
        1.116745e-01, 1.029250e-01, 9.320480e-02, 8.278434e-02, 7.194458e-02, 6.109329e-02, 5.131315e-02, 4.285204e-02, 
        3.544078e-02, 2.829305e-02, 2.092176e-02, 1.369301e-02, 6.502255e-03, -8.276016e-04, -7.964621e-03, -1.509358e-02, 
        -2.246249e-02, -2.971735e-02, -3.654769e-02, -4.260653e-02, -4.772251e-02, -5.194169e-02, -5.541601e-02, -5.829437e-02, 
        -6.056519e-02, -6.236312e-02, -6.384026e-02, -6.505423e-02, -6.609224e-02, -6.669607e-02, -6.691516e-02, -6.685879e-02, 
        -6.652929e-02, -6.568700e-02, -6.463312e-02, -6.343984e-02, -6.202305e-02, -6.046732e-02, -5.893315e-02, -5.740302e-02, 
        -5.566495e-02, -5.387634e-02, -5.186860e-02, -4.975779e-02, -4.775799e-02, -4.562893e-02, -4.352805e-02, -4.137753e-02, 
        -3.912613e-02, -3.682632e-02, -3.439250e-02, -3.194815e-02, -2.930056e-02, -2.656167e-02, -2.379128e-02, -2.098688e-02, 
        -1.814850e-02, -1.536356e-02, -1.261164e-02, -9.868152e-03, -7.173675e-03, -4.525448e-03, -1.965084e-03, 6.168254e-04, 
        3.162284e-03, 5.707233e-03, 8.195772e-03, 1.068451e-02, 1.314364e-02, 1.564131e-02, 1.818456e-02, 2.084022e-02, 
        2.356551e-02, 2.624975e-02, 2.904896e-02, 3.188372e-02, 3.478474e-02, 3.770818e-02, 4.064820e-02, 4.359833e-02, 
        4.634738e-02, 4.909670e-02, 5.182554e-02, 5.439479e-02, 5.680792e-02, 5.902445e-02, 6.099067e-02, 6.269302e-02, 
        6.421239e-02, 6.544923e-02, 6.624927e-02, 6.681713e-02, 6.712631e-02, 6.726487e-02, 6.728269e-02, 6.704739e-02, 
        6.663485e-02, 6.611592e-02, 6.533447e-02, 6.431141e-02, 6.308573e-02, 6.175877e-02, 6.017576e-02, 5.847610e-02, 
        5.666525e-02, 5.469120e-02, 5.264451e-02, 5.057616e-02, 4.835811e-02, 4.606366e-02, 4.371613e-02, 4.122858e-02, 
        3.877405e-02, 3.628604e-02, 3.372210e-02, 3.113418e-02, 2.848793e-02, 2.586313e-02, 2.314775e-02, 2.041119e-02, 
        1.765324e-02, 1.487305e-02, 1.213176e-02, 9.380706e-03, 6.632160e-03, 3.951821e-03, 1.410248e-03, -1.076965e-03, 
        -3.498997e-03, -5.916821e-03, -8.197745e-03, -1.046101e-02, -1.269171e-02, -1.485863e-02, -1.688913e-02, -1.884015e-02, 
        -2.078778e-02, -2.267046e-02, -2.456608e-02, -2.648875e-02, -2.832836e-02, -3.014256e-02, -3.188720e-02, -3.363371e-02, 
        -3.542073e-02, -3.720799e-02, -3.900214e-02, -4.077968e-02, -4.242680e-02, -4.399767e-02, -4.555023e-02, -4.707265e-02, 
        -4.851820e-02, -4.998965e-02, -5.133481e-02, -5.257725e-02, -5.383985e-02, -5.509882e-02, -5.631151e-02, -5.737942e-02, 
        -5.833593e-02, -5.927504e-02, -6.015817e-02, -6.097732e-02, -6.158503e-02, -6.209689e-02, -6.255621e-02, -6.299116e-02, 
        -6.325338e-02, -6.337238e-02, -6.346345e-02, -6.351750e-02, -6.329521e-02, -6.299696e-02, -6.269109e-02, -6.218936e-02, 
        -6.156519e-02, -6.086646e-02, -5.996721e-02, -5.895799e-02, -5.793210e-02, -5.661305e-02, -5.521785e-02, -5.371145e-02, 
        -5.203058e-02, -5.033116e-02, -4.837816e-02, -4.639728e-02, -4.416284e-02, -4.188589e-02, -3.941294e-02, -3.689078e-02, 
        -3.423520e-02, -3.152978e-02, -2.875980e-02, -2.596427e-02, -2.318996e-02, -2.043350e-02, -1.773289e-02, -1.501457e-02, 
        -1.237982e-02, -9.745071e-03, -7.229239e-03, -4.708208e-03, -2.320967e-03, 8.070091e-05, 2.348366e-03, 4.591811e-03, 
        6.764018e-03, 8.850274e-03, 1.093949e-02, 1.288259e-02, 1.482072e-02, 1.670620e-02, 1.849338e-02, 2.026930e-02, 
        2.195358e-02, 2.358069e-02, 2.521621e-02, 2.674060e-02, 2.821928e-02, 2.967623e-02, 3.102724e-02, 3.234031e-02, 
        3.364976e-02, 3.489012e-02, 3.605705e-02, 3.720929e-02, 3.832424e-02, 3.933046e-02, 4.032283e-02, 4.129232e-02, 
        4.218216e-02, 4.300282e-02, 4.382003e-02, 4.460349e-02, 4.526021e-02, 4.588554e-02, 4.650034e-02, 4.707632e-02, 
        4.756497e-02, 4.802367e-02, 4.843365e-02, 4.881548e-02, 4.910217e-02, 4.937479e-02, 4.963733e-02, 4.988234e-02, 
        5.005874e-02, 5.020310e-02, 5.034665e-02, 5.049171e-02, 5.058967e-02, 5.064064e-02, 5.068562e-02, 5.073603e-02, 
        5.075845e-02, 5.072401e-02, 5.067237e-02, 5.058246e-02, 5.046650e-02, 5.031505e-02, 5.009900e-02, 4.984151e-02, 
        4.953146e-02, 4.916712e-02, 4.871084e-02, 4.821376e-02, 4.768106e-02, 4.711512e-02, 4.652647e-02, 4.585785e-02, 
        4.514133e-02, 4.439439e-02, 4.361535e-02, 4.280429e-02, 4.192881e-02, 4.102300e-02, 4.009239e-02, 3.913833e-02, 
        3.815946e-02, 3.713070e-02, 3.606890e-02, 3.499174e-02, 3.389942e-02, 3.279640e-02, 3.168237e-02, 3.051263e-02, 
        2.933234e-02, 2.815132e-02, 2.695674e-02, 2.575655e-02, 2.450979e-02, 2.324600e-02, 2.198786e-02, 2.073296e-02, 
        1.945922e-02, 1.819424e-02, 1.690579e-02, 1.560894e-02, 1.430015e-02, 1.299360e-02, 1.169695e-02, 1.037968e-02, 
        9.068149e-03, 7.741817e-03, 6.415321e-03, 5.105502e-03, 3.819000e-03, 2.531463e-03, 1.269096e-03, 2.384484e-05, 
        -1.193432e-03, -2.386539e-03, -3.560392e-03, -4.718147e-03, -5.815072e-03, -6.866752e-03, -7.887419e-03, -8.907708e-03, 
        -9.933379e-03, -1.095651e-02, -1.197075e-02, -1.296265e-02, -1.390421e-02, -1.481505e-02, -1.571800e-02, -1.662590e-02, 
        -1.752483e-02, -1.842051e-02, -1.930908e-02, -2.015003e-02, -2.094065e-02, -2.171573e-02, -2.250890e-02, -2.327995e-02, 
        -2.402365e-02, -2.473761e-02, -2.542798e-02, -2.608625e-02, -2.671729e-02, -2.732652e-02, -2.791842e-02, -2.848333e-02, 
        -2.903645e-02, -2.955853e-02, -3.003906e-02, -3.051089e-02, -3.095459e-02, -3.137805e-02, -3.176411e-02, -3.212434e-02, 
        -3.247152e-02, -3.278630e-02, -3.309353e-02, -3.339251e-02, -3.366102e-02, -3.388245e-02, -3.407782e-02, -3.427637e-02, 
        -3.445911e-02, -3.466297e-02, -3.481982e-02, -3.496659e-02, -3.511681e-02, -3.523699e-02, -3.530970e-02, -3.536507e-02, 
        -3.544618e-02, -3.551390e-02, -3.557507e-02, -3.561826e-02, -3.565932e-02, -3.567753e-02, -3.568320e-02, -3.567384e-02, 
        -3.567145e-02, -3.566303e-02, -3.565306e-02, -3.564454e-02, -3.561138e-02, -3.555141e-02, -3.548285e-02, -3.544837e-02, 
        -3.542393e-02, -3.537955e-02, -3.532114e-02, -3.525028e-02, -3.517465e-02, -3.508291e-02, -3.497593e-02, -3.490447e-02, 
        -3.483494e-02, -3.477417e-02, -3.471751e-02, -3.466583e-02, -3.460672e-02, -3.456024e-02, -3.448910e-02, -3.443390e-02, 
        -3.435854e-02, -3.427583e-02, -3.417394e-02, -3.407909e-02, -3.397054e-02, -3.384070e-02, -3.369647e-02, -3.355718e-02, 
        -3.340723e-02, -3.323516e-02, -3.303598e-02, -3.279781e-02, -3.254387e-02, -3.228604e-02, -3.201505e-02, -3.171318e-02, 
        -3.142293e-02, -3.114209e-02, -3.082772e-02, -3.045841e-02, -3.005733e-02, -2.964362e-02, -2.917462e-02, -2.867504e-02, 
        -2.813418e-02, -2.760626e-02, -2.707090e-02, -2.652276e-02, -2.593222e-02, -2.531618e-02, -2.469594e-02, -2.407103e-02, 
        -2.343334e-02, -2.277295e-02, -2.207018e-02, -2.138198e-02, -2.069594e-02, -1.998571e-02, -1.925349e-02, -1.849806e-02, 
        -1.773696e-02, -1.696485e-02, -1.618180e-02, -1.539289e-02, -1.459834e-02, -1.381856e-02, -1.303101e-02, -1.221188e-02, 
        -1.137027e-02, -1.050989e-02, -9.626323e-03, -8.732401e-03, -7.834357e-03, -6.930994e-03, -6.020929e-03, -5.141985e-03, 
        -4.256497e-03, -3.361107e-03, -2.465532e-03, -1.556973e-03, -6.467956e-04, 2.871382e-04, 1.237592e-03, 2.190082e-03, 
        3.133055e-03, 4.074881e-03, 4.983417e-03, 5.889459e-03, 6.791265e-03, 7.673202e-03, 8.542332e-03, 9.408963e-03, 
        1.026319e-02, 1.110473e-02, 1.194347e-02, 1.279316e-02, 1.365171e-02, 1.447525e-02, 1.527256e-02, 1.605954e-02, 
        1.683167e-02, 1.758684e-02, 1.831307e-02, 1.902876e-02, 1.972684e-02, 2.041050e-02, 2.108935e-02, 2.173923e-02, 
        2.237265e-02, 2.297090e-02, 2.354096e-02, 2.412886e-02, 2.471794e-02, 2.527551e-02, 2.581197e-02, 2.633118e-02, 
        2.683890e-02, 2.733438e-02, 2.780126e-02, 2.824413e-02, 2.865447e-02, 2.904084e-02, 2.937105e-02, 2.968539e-02, 
        2.998415e-02, 3.027428e-02, 3.054532e-02, 3.079764e-02, 3.106455e-02, 3.132506e-02, 3.156960e-02, 3.180857e-02, 
        3.205375e-02, 3.228896e-02, 3.252091e-02, 3.271934e-02, 3.289472e-02, 3.307206e-02, 3.324106e-02, 3.339448e-02, 
        3.353456e-02, 3.366045e-02, 3.377804e-02, 3.389761e-02, 3.401727e-02, 3.413144e-02, 3.425254e-02, 3.437081e-02, 
        3.448903e-02, 3.459243e-02, 3.467257e-02, 3.474069e-02, 3.480717e-02, 3.486153e-02, 3.491283e-02, 3.494985e-02, 
        3.497361e-02, 3.497508e-02, 3.495995e-02, 3.492369e-02, 3.485748e-02, 3.476868e-02, 3.467043e-02, 3.455774e-02, 
        3.441120e-02, 3.423531e-02, 3.406846e-02, 3.389805e-02, 3.372093e-02, 3.352094e-02, 3.330048e-02, 3.306500e-02, 
        3.281435e-02, 3.255679e-02, 3.229502e-02, 3.203285e-02, 3.176566e-02, 3.149615e-02, 3.120929e-02, 3.091477e-02, 
        3.059739e-02, 3.026246e-02, 2.991732e-02, 2.955209e-02, 2.916415e-02, 2.875910e-02, 2.835779e-02, 2.796257e-02, 
        2.755974e-02, 2.714536e-02, 2.672353e-02, 2.629519e-02, 2.584748e-02, 2.538733e-02, 2.492165e-02, 2.444579e-02, 
        2.396350e-02, 2.343459e-02, 2.287924e-02, 2.232696e-02, 2.178998e-02, 2.125035e-02, 2.070484e-02, 2.015387e-02, 
        1.959821e-02, 1.904552e-02, 1.848591e-02, 1.791866e-02, 1.735488e-02, 1.678414e-02, 1.623217e-02, 1.568497e-02, 
        1.513833e-02, 1.459029e-02, 1.404801e-02, 1.349753e-02, 1.293772e-02, 1.237014e-02, 1.180083e-02, 1.122481e-02, 
        1.064271e-02, 1.005560e-02, 9.476598e-03, 8.896534e-03, 8.304817e-03, 7.710918e-03, 7.115831e-03, 6.518919e-03, 
        5.918190e-03, 5.315373e-03, 4.709568e-03, 4.090631e-03, 3.465813e-03, 2.846576e-03, 2.226961e-03, 1.601896e-03, 
        9.867563e-04, 3.745772e-04, -2.105205e-04, -7.933030e-04, -1.371328e-03, -1.940325e-03, -2.511783e-03, -3.076740e-03, 
        -3.647312e-03, -4.213629e-03, -4.768049e-03, -5.306119e-03, -5.828920e-03, -6.336394e-03, -6.832906e-03, -7.320921e-03, 
        -7.797977e-03, -8.274190e-03, -8.748236e-03, -9.233121e-03, -9.707003e-03, -1.015312e-02, -1.057526e-02, -1.099189e-02, 
        -1.140492e-02, -1.180347e-02, -1.215806e-02, -1.249829e-02, -1.283284e-02, -1.316834e-02, -1.350417e-02, -1.383645e-02, 
        -1.416119e-02, -1.448808e-02, -1.481028e-02, -1.513343e-02, -1.544453e-02, -1.573912e-02, -1.603154e-02, -1.630950e-02, 
        -1.658602e-02, -1.687403e-02, -1.715366e-02, -1.742182e-02, -1.768665e-02, -1.795419e-02, -1.821771e-02, -1.846527e-02, 
        -1.864034e-02, -1.877560e-02, -1.891428e-02, -1.905052e-02, -1.918990e-02, -1.932156e-02, -1.944473e-02, -1.953402e-02, 
        -1.962136e-02, -1.971149e-02, -1.980488e-02, -1.989959e-02, -1.999073e-02, -2.008237e-02, -2.012979e-02, -2.014827e-02, 
        -2.018234e-02, -2.021430e-02, -2.025566e-02, -2.030232e-02, -2.035800e-02, -2.041849e-02, -2.047975e-02, -2.053755e-02, 
        -2.059503e-02, -2.066297e-02, -2.070026e-02, -2.073074e-02, -2.076274e-02, -2.079700e-02, -2.081766e-02, -2.081751e-02, 
        -2.078707e-02, -2.074217e-02, -2.068854e-02, -2.061840e-02, -2.053394e-02, -2.044232e-02, -2.034929e-02, -2.025436e-02, 
        -2.016599e-02, -2.008360e-02, -2.000049e-02, -1.992195e-02, -1.984999e-02, -1.977996e-02, -1.970968e-02, -1.963963e-02, 
        -1.957092e-02, -1.951273e-02, -1.941598e-02, -1.930148e-02, -1.919344e-02, -1.909173e-02, -1.898761e-02, -1.885601e-02, 
        -1.871118e-02, -1.856783e-02, -1.841840e-02, -1.826673e-02, -1.811925e-02, -1.797291e-02, -1.782092e-02, -1.766494e-02, 
        -1.750164e-02, -1.733041e-02, -1.715757e-02, -1.699718e-02, -1.684047e-02, -1.668598e-02, -1.652583e-02, -1.636523e-02, 
        -1.620326e-02, -1.604395e-02, -1.588348e-02, -1.571252e-02, -1.554306e-02, -1.537691e-02, -1.521382e-02, -1.505256e-02, 
        -1.489495e-02, -1.472986e-02, -1.454640e-02, -1.435792e-02, -1.415967e-02, -1.395707e-02, -1.372492e-02, -1.349921e-02, 
        -1.327217e-02, -1.304305e-02, -1.281467e-02, -1.258340e-02, -1.235459e-02, -1.212523e-02, -1.190113e-02, -1.168102e-02, 
        -1.145324e-02, -1.121639e-02, -1.097750e-02, -1.073424e-02, -1.049076e-02, -1.024075e-02, -9.991022e-03, -9.742739e-03, 
        -9.494931e-03, -9.245145e-03, -8.995961e-03, -8.752816e-03, -8.512593e-03, -8.277541e-03, -8.049587e-03, -7.826348e-03, 
        -7.608062e-03, -7.396156e-03, -7.185370e-03, -6.980983e-03, -6.777299e-03, -6.577432e-03, -6.382538e-03, -6.191508e-03, 
        -6.003896e-03, -5.816081e-03, -5.627869e-03, -5.427195e-03, -5.222663e-03, -5.037527e-03, -4.855783e-03, -4.649402e-03, 
        -4.440233e-03, -4.232805e-03, -4.024880e-03, -3.807483e-03, -3.588480e-03, -3.361602e-03, -3.132096e-03, -2.905517e-03, 
        -2.679254e-03, -2.452608e-03, -2.227449e-03, -2.008791e-03, -1.790952e-03, -1.573746e-03, -1.361542e-03, -1.157087e-03, 
        -9.609823e-04, -7.674150e-04, -5.797771e-04, -3.990046e-04, -2.239958e-04, -4.439211e-05, 1.396298e-04, 3.222211e-04, 
        5.008715e-04, 6.779647e-04, 8.601898e-04, 1.042781e-03, 1.220758e-03, 1.381251e-03, 1.538930e-03, 1.693212e-03, 
        1.843456e-03, 1.997282e-03, 2.155009e-03, 2.317536e-03, 2.481689e-03, 2.649820e-03, 2.819629e-03, 2.990812e-03, 
        3.162751e-03, 3.331905e-03, 3.507244e-03, 3.683785e-03, 3.861910e-03, 4.030485e-03, 4.198306e-03, 4.364774e-03, 
        4.524752e-03, 4.680467e-03, 4.821825e-03, 4.974119e-03, 5.126121e-03, 5.275984e-03, 5.445741e-03, 5.614988e-03, 
        5.783175e-03, 5.947920e-03, 6.113995e-03, 6.273493e-03, 6.426155e-03, 6.586598e-03, 6.749856e-03, 6.902632e-03, 
        7.059211e-03, 7.218763e-03, 7.379529e-03, 7.536365e-03, 7.705722e-03, 7.882556e-03, 8.061374e-03, 8.239117e-03, 
        8.422710e-03, 8.610220e-03, 8.796941e-03, 8.987158e-03, 9.176041e-03, 9.359229e-03, 9.540617e-03, 9.712234e-03, 
        9.883348e-03, 1.004536e-02, 1.020352e-02, 1.036267e-02, 1.051669e-02, 1.066336e-02, 1.079316e-02, 1.091487e-02, 
        1.102950e-02, 1.114212e-02, 1.125885e-02, 1.136107e-02, 1.145830e-02, 1.155206e-02, 1.164214e-02, 1.172806e-02, 
        1.180849e-02, 1.188952e-02, 1.196905e-02, 1.204584e-02, 1.211635e-02, 1.217674e-02, 1.223541e-02, 1.229263e-02, 
        1.234995e-02, 1.240863e-02, 1.246192e-02, 1.251184e-02, 1.256242e-02, 1.261874e-02, 1.267709e-02, 1.272766e-02, 
        1.277669e-02, 1.282692e-02, 1.287511e-02, 1.292109e-02, 1.296405e-02, 1.300595e-02, 1.304837e-02, 1.309052e-02, 
        1.313521e-02, 1.317410e-02, 1.320113e-02, 1.322924e-02, 1.325429e-02, 1.328400e-02, 1.332435e-02, 1.338605e-02, 
        1.345960e-02, 1.352992e-02, 1.360079e-02, 1.367062e-02, 1.372020e-02, 1.376942e-02, 1.381755e-02, 1.387327e-02, 
        1.393805e-02, 1.400128e-02, 1.405127e-02, 1.409417e-02, 1.413538e-02, 1.417545e-02, 1.419578e-02, 1.421460e-02, 
        1.422852e-02, 1.423914e-02, 1.424496e-02, 1.424318e-02, 1.423454e-02, 1.422075e-02, 1.420547e-02, 1.419162e-02, 
        1.415933e-02, 1.411267e-02, 1.406270e-02, 1.400903e-02, 1.395095e-02, 1.388625e-02, 1.381661e-02, 1.374747e-02, 
        1.367476e-02, 1.360097e-02, 1.351428e-02, 1.340822e-02, 1.330277e-02, 1.319812e-02, 1.309727e-02, 1.300067e-02, 
        1.290355e-02, 1.280535e-02, 1.270370e-02, 1.260333e-02, 1.250062e-02, 1.237286e-02, 1.226199e-02, 1.215275e-02, 
        1.204196e-02, 1.192944e-02, 1.181639e-02, 1.169824e-02, 1.156265e-02, 1.142394e-02, 1.128725e-02, 1.111601e-02, 
        1.093656e-02, 1.075112e-02, 1.055972e-02, 1.036437e-02, 1.016662e-02, 9.966574e-03, 9.764344e-03, 9.564577e-03, 
        9.363137e-03, 9.134555e-03, 8.895172e-03, 8.654333e-03, 8.410100e-03, 8.156153e-03, 7.901157e-03, 7.657088e-03, 
        7.412666e-03, 7.162834e-03, 6.905823e-03, 6.633215e-03, 6.343749e-03, 6.058495e-03, 5.776984e-03, 5.509354e-03, 
        5.244486e-03, 4.976913e-03, 4.696457e-03, 4.408548e-03, 4.108398e-03, 3.771421e-03, 3.395763e-03, 3.026870e-03, 
        2.665420e-03, 2.300077e-03, 1.929931e-03, 1.555189e-03, 1.174700e-03, 7.890409e-04, 3.971999e-04, -4.543580e-18
    },
    {
        0.000000e+00, 2.582338e-02, 2.788695e-02, 3.015120e-02, 1.992367e-02, 6.122007e-03, 1.873491e-03, 1.551893e-03, 
        1.851705e-03, 2.831383e-03, 5.649215e-03, 9.446452e-03, 1.257734e-02, 1.404221e-02, 1.265673e-02, 9.201761e-03, 
        5.724363e-03, 3.914090e-03, 3.643757e-03, 2.951421e-03, 1.069848e-03, -2.419836e-03, -6.426817e-03, -1.023838e-02, 
        -1.385503e-02, -1.724476e-02, -2.030696e-02, -2.291385e-02, -2.487775e-02, -2.614447e-02, -2.663786e-02, -2.650462e-02, 
        -2.580013e-02, -2.461288e-02, -2.313307e-02, -2.146232e-02, -1.965955e-02, -1.744552e-02, -1.463732e-02, -1.140667e-02, 
        -7.972878e-03, -4.575456e-03, -1.313533e-03, 1.588777e-03, 3.999687e-03, 5.835754e-03, 6.927453e-03, 7.243991e-03, 
        7.317584e-03, 7.073351e-03, 6.257333e-03, 4.874401e-03, 3.121776e-03, 1.038513e-03, -1.218678e-03, -3.454468e-03, 
        -5.575850e-03, -7.444446e-03, -8.954404e-03, -9.935053e-03, -1.031070e-02, -9.867237e-03, -8.816129e-03, -7.373982e-03, 
        -5.672227e-03, -3.845725e-03, -1.813834e-03, 3.513706e-04, 2.673189e-03, 5.083045e-03, 7.527808e-03, 1.002128e-02, 
        1.260762e-02, 1.524348e-02, 1.786674e-02, 2.050779e-02, 2.313621e-02, 2.573596e-02, 2.833679e-02, 3.108054e-02, 
        3.380981e-02, 3.642909e-02, 3.899303e-02, 4.142137e-02, 4.348831e-02, 4.530173e-02, 4.694105e-02, 4.820910e-02, 
        4.915036e-02, 4.982978e-02, 5.018315e-02, 5.023589e-02, 4.980763e-02, 4.905758e-02, 4.796739e-02, 4.640574e-02, 
        4.444484e-02, 4.207434e-02, 3.928124e-02, 3.635617e-02, 3.336321e-02, 3.010738e-02, 2.671548e-02, 2.312237e-02, 
        1.937084e-02, 1.547951e-02, 1.141165e-02, 7.274858e-03, 3.033589e-03, -1.220267e-03, -5.534770e-03, -9.847984e-03, 
        -1.415600e-02, -1.834604e-02, -2.239824e-02, -2.637304e-02, -3.025736e-02, -3.398421e-02, -3.748769e-02, -4.081280e-02, 
        -4.393477e-02, -4.686695e-02, -4.953000e-02, -5.187861e-02, -5.394374e-02, -5.574413e-02, -5.728003e-02, -5.858608e-02, 
        -5.961233e-02, -6.040203e-02, -6.099119e-02, -6.134030e-02, -6.140432e-02, -6.106806e-02, -6.028717e-02, -5.908612e-02, 
        -5.758131e-02, -5.579794e-02, -5.366737e-02, -5.135445e-02, -4.887707e-02, -4.625764e-02, -4.342870e-02, -4.054161e-02, 
        -3.765350e-02, -3.472359e-02, -3.186216e-02, -2.911793e-02, -2.650080e-02, -2.398324e-02, -2.159563e-02, -1.946005e-02, 
        -1.759561e-02, -1.603332e-02, -1.476296e-02, -1.354104e-02, -1.230068e-02, -1.108787e-02, -9.978465e-03, -8.980276e-03, 
        -8.103006e-03, -7.298285e-03, -6.463383e-03, -5.695816e-03, -5.031625e-03, -4.555449e-03, -4.164841e-03, -3.788624e-03, 
        -3.434260e-03, -3.225064e-03, -3.142920e-03, -3.208623e-03, -3.257603e-03, -3.399448e-03, -3.636708e-03, -3.937849e-03, 
        -4.162655e-03, -4.428913e-03, -4.778235e-03, -5.185898e-03, -5.409569e-03, -5.634282e-03, -5.892079e-03, -6.062179e-03, 
        -6.160839e-03, -6.230034e-03, -6.141727e-03, -5.946886e-03, -5.718027e-03, -5.266735e-03, -4.730247e-03, -4.026396e-03, 
        -3.133571e-03, -2.145805e-03, -8.841697e-04, 4.460122e-04, 1.962817e-03, 3.519369e-03, 5.228009e-03, 6.988262e-03, 
        8.859223e-03, 1.078435e-02, 1.276813e-02, 1.476935e-02, 1.679453e-02, 1.885455e-02, 2.088238e-02, 2.293859e-02, 
        2.493055e-02, 2.693966e-02, 2.883856e-02, 3.074620e-02, 3.254727e-02, 3.437391e-02, 3.610964e-02, 3.782007e-02, 
        3.946395e-02, 4.101541e-02, 4.256785e-02, 4.401362e-02, 4.546050e-02, 4.685832e-02, 4.814837e-02, 4.942355e-02, 
        5.059405e-02, 5.171846e-02, 5.282062e-02, 5.381627e-02, 5.475877e-02, 5.566143e-02, 5.646076e-02, 5.720148e-02, 
        5.790035e-02, 5.850898e-02, 5.901851e-02, 5.948157e-02, 5.988680e-02, 6.016002e-02, 6.038337e-02, 6.053420e-02, 
        6.057080e-02, 6.051355e-02, 6.037638e-02, 6.015988e-02, 5.980726e-02, 5.936905e-02, 5.885350e-02, 5.823953e-02, 
        5.747670e-02, 5.662954e-02, 5.568238e-02, 5.464153e-02, 5.345658e-02, 5.220852e-02, 5.092240e-02, 4.958150e-02, 
        4.812957e-02, 4.663464e-02, 4.510249e-02, 4.353549e-02, 4.190036e-02, 4.019099e-02, 3.843812e-02, 3.664865e-02, 
        3.481497e-02, 3.292826e-02, 3.101100e-02, 2.906868e-02, 2.709568e-02, 2.507404e-02, 2.299438e-02, 2.090159e-02, 
        1.879844e-02, 1.667227e-02, 1.449982e-02, 1.228980e-02, 1.006114e-02, 7.834112e-03, 5.600179e-03, 3.342738e-03, 
        1.067792e-03, -1.203849e-03, -3.480048e-03, -5.753192e-03, -8.040342e-03, -1.033072e-02, -1.260687e-02, -1.485605e-02, 
        -1.708884e-02, -1.932198e-02, -2.153992e-02, -2.374419e-02, -2.592434e-02, -2.807872e-02, -3.020181e-02, -3.231914e-02, 
        -3.438478e-02, -3.640979e-02, -3.841246e-02, -4.038254e-02, -4.233059e-02, -4.424713e-02, -4.610782e-02, -4.789066e-02, 
        -4.962434e-02, -5.132563e-02, -5.299403e-02, -5.459660e-02, -5.613912e-02, -5.761421e-02, -5.899103e-02, -6.030601e-02, 
        -6.157000e-02, -6.275918e-02, -6.387614e-02, -6.492458e-02, -6.588903e-02, -6.676407e-02, -6.755520e-02, -6.828829e-02, 
        -6.896337e-02, -6.957697e-02, -7.012728e-02, -7.063573e-02, -7.107170e-02, -7.145046e-02, -7.176842e-02, -7.202866e-02, 
        -7.224724e-02, -7.241784e-02, -7.254152e-02, -7.262095e-02, -7.263374e-02, -7.256884e-02, -7.246964e-02, -7.232437e-02, 
        -7.213061e-02, -7.187811e-02, -7.157505e-02, -7.116766e-02, -7.063421e-02, -6.999795e-02, -6.930333e-02, -6.851589e-02, 
        -6.761833e-02, -6.664138e-02, -6.560128e-02, -6.445090e-02, -6.324399e-02, -6.195046e-02, -6.058348e-02, -5.913489e-02, 
        -5.762982e-02, -5.607133e-02, -5.444229e-02, -5.276641e-02, -5.103873e-02, -4.928213e-02, -4.745380e-02, -4.556179e-02, 
        -4.362721e-02, -4.166393e-02, -3.966141e-02, -3.762823e-02, -3.554553e-02, -3.345927e-02, -3.134624e-02, -2.920581e-02, 
        -2.701512e-02, -2.481717e-02, -2.259149e-02, -2.034948e-02, -1.809695e-02, -1.585847e-02, -1.360849e-02, -1.136313e-02, 
        -9.135985e-03, -6.906143e-03, -4.648397e-03, -2.403261e-03, -1.620247e-04, 2.051146e-03, 4.246357e-03, 6.409294e-03, 
        8.536767e-03, 1.065861e-02, 1.276302e-02, 1.484251e-02, 1.690199e-02, 1.893074e-02, 2.093150e-02, 2.286372e-02, 
        2.473345e-02, 2.657574e-02, 2.838702e-02, 3.013479e-02, 3.184725e-02, 3.350079e-02, 3.507956e-02, 3.657114e-02, 
        3.802480e-02, 3.942060e-02, 4.074637e-02, 4.200214e-02, 4.318976e-02, 4.429811e-02, 4.531892e-02, 4.624901e-02, 
        4.715347e-02, 4.803189e-02, 4.890701e-02, 4.976844e-02, 5.060156e-02, 5.140311e-02, 5.218886e-02, 5.295747e-02, 
        5.365133e-02, 5.430922e-02, 5.492732e-02, 5.554098e-02, 5.613254e-02, 5.669940e-02, 5.723183e-02, 5.772675e-02, 
        5.819009e-02, 5.860019e-02, 5.891647e-02, 5.917831e-02, 5.939426e-02, 5.955203e-02, 5.964731e-02, 5.968833e-02, 
        5.969862e-02, 5.963703e-02, 5.948914e-02, 5.928945e-02, 5.901539e-02, 5.869905e-02, 5.832790e-02, 5.790845e-02, 
        5.745916e-02, 5.698327e-02, 5.645336e-02, 5.585263e-02, 5.522002e-02, 5.456399e-02, 5.386684e-02, 5.310711e-02, 
        5.231428e-02, 5.148238e-02, 5.063449e-02, 4.976438e-02, 4.886258e-02, 4.791742e-02, 4.695486e-02, 4.597573e-02, 
        4.496933e-02, 4.393220e-02, 4.284279e-02, 4.175212e-02, 4.065589e-02, 3.953443e-02, 3.840069e-02, 3.723112e-02, 
        3.605475e-02, 3.486881e-02, 3.367353e-02, 3.247582e-02, 3.128344e-02, 3.008618e-02, 2.885326e-02, 2.761403e-02, 
        2.637146e-02, 2.513492e-02, 2.388366e-02, 2.263708e-02, 2.139103e-02, 2.014758e-02, 1.890976e-02, 1.768721e-02, 
        1.647237e-02, 1.526169e-02, 1.405306e-02, 1.286517e-02, 1.169275e-02, 1.051736e-02, 9.343780e-03, 8.187537e-03, 
        7.059036e-03, 5.959319e-03, 4.881003e-03, 3.827071e-03, 2.803146e-03, 1.803574e-03, 8.336306e-04, -1.112889e-04, 
        -1.029277e-03, -1.942344e-03, -2.836194e-03, -3.677700e-03, -4.485395e-03, -5.262823e-03, -6.004349e-03, -6.702482e-03, 
        -7.349067e-03, -7.943895e-03, -8.494786e-03, -9.000597e-03, -9.459769e-03, -9.866974e-03, -1.025754e-02, -1.063083e-02, 
        -1.099423e-02, -1.135477e-02, -1.172834e-02, -1.209433e-02, -1.244451e-02, -1.278519e-02, -1.312057e-02, -1.345353e-02, 
        -1.378238e-02, -1.410562e-02, -1.440929e-02, -1.472319e-02, -1.504577e-02, -1.535873e-02, -1.568911e-02, -1.601979e-02, 
        -1.634087e-02, -1.665018e-02, -1.695646e-02, -1.725807e-02, -1.756278e-02, -1.785997e-02, -1.814962e-02, -1.842431e-02, 
        -1.869064e-02, -1.897816e-02, -1.928970e-02, -1.959482e-02, -1.989242e-02, -2.018911e-02, -2.047715e-02, -2.076220e-02, 
        -2.104346e-02, -2.132549e-02, -2.160666e-02, -2.187249e-02, -2.215183e-02, -2.244255e-02, -2.273536e-02, -2.302519e-02, 
        -2.332048e-02, -2.362422e-02, -2.392241e-02, -2.421397e-02, -2.450256e-02, -2.478739e-02, -2.506222e-02, -2.534028e-02, 
        -2.560466e-02, -2.586774e-02, -2.613478e-02, -2.640197e-02, -2.666248e-02, -2.691659e-02, -2.716008e-02, -2.740416e-02, 
        -2.767136e-02, -2.795510e-02, -2.822781e-02, -2.849630e-02, -2.874778e-02, -2.898433e-02, -2.922457e-02, -2.945505e-02, 
        -2.967060e-02, -2.988182e-02, -3.007252e-02, -3.025605e-02, -3.043270e-02, -3.060505e-02, -3.077101e-02, -3.093089e-02, 
        -3.109494e-02, -3.125094e-02, -3.140677e-02, -3.155636e-02, -3.167006e-02, -3.177725e-02, -3.188191e-02, -3.198533e-02, 
        -3.209000e-02, -3.219402e-02, -3.228849e-02, -3.237911e-02, -3.246861e-02, -3.253237e-02, -3.253422e-02, -3.250458e-02, 
        -3.246226e-02, -3.241514e-02, -3.236453e-02, -3.232251e-02, -3.228404e-02, -3.223931e-02, -3.218492e-02, -3.211922e-02, 
        -3.203205e-02, -3.192054e-02, -3.176521e-02, -3.156059e-02, -3.134152e-02, -3.111350e-02, -3.087894e-02, -3.063793e-02, 
        -3.038738e-02, -3.012938e-02, -2.986057e-02, -2.956141e-02, -2.923532e-02, -2.890091e-02, -2.855211e-02, -2.819847e-02, 
        -2.783067e-02, -2.743875e-02, -2.698010e-02, -2.651385e-02, -2.603993e-02, -2.554995e-02, -2.503188e-02, -2.449559e-02, 
        -2.394813e-02, -2.338839e-02, -2.281920e-02, -2.225099e-02, -2.167806e-02, -2.109607e-02, -2.050371e-02, -1.990144e-02, 
        -1.929286e-02, -1.867887e-02, -1.806404e-02, -1.745847e-02, -1.683969e-02, -1.619093e-02, -1.549554e-02, -1.478858e-02, 
        -1.406755e-02, -1.335079e-02, -1.267159e-02, -1.198672e-02, -1.129643e-02, -1.059907e-02, -9.898953e-03, -9.196647e-03, 
        -8.498074e-03, -7.794314e-03, -7.095248e-03, -6.396417e-03, -5.727504e-03, -5.095640e-03, -4.460635e-03, -3.838829e-03, 
        -3.227981e-03, -2.620730e-03, -2.017433e-03, -1.420021e-03, -8.220225e-04, -2.187297e-04, 3.900817e-04, 1.000093e-03, 
        1.582605e-03, 2.126356e-03, 2.676725e-03, 3.241377e-03, 3.804041e-03, 4.371819e-03, 4.942579e-03, 5.484599e-03, 
        6.031348e-03, 6.583482e-03, 7.143376e-03, 7.714608e-03, 8.292779e-03, 8.879410e-03, 9.377144e-03, 9.798808e-03, 
        1.020809e-02, 1.062327e-02, 1.104663e-02, 1.147767e-02, 1.191842e-02, 1.236953e-02, 1.282603e-02, 1.328764e-02, 
        1.375019e-02, 1.421328e-02, 1.466225e-02, 1.511258e-02, 1.556932e-02, 1.602989e-02, 1.648278e-02, 1.690894e-02, 
        1.727076e-02, 1.760933e-02, 1.795406e-02, 1.829887e-02, 1.867353e-02, 1.903998e-02, 1.940619e-02, 1.977776e-02, 
        2.014896e-02, 2.051914e-02, 2.088825e-02, 2.125882e-02, 2.162986e-02, 2.199536e-02, 2.235992e-02, 2.272515e-02, 
        2.309407e-02, 2.346409e-02, 2.377533e-02, 2.405118e-02, 2.432890e-02, 2.460762e-02, 2.489001e-02, 2.512178e-02, 
        2.532171e-02, 2.551999e-02, 2.571579e-02, 2.590933e-02, 2.610171e-02, 2.629283e-02, 2.648123e-02, 2.667615e-02, 
        2.687626e-02, 2.706187e-02, 2.723278e-02, 2.739052e-02, 2.754781e-02, 2.770775e-02, 2.786157e-02, 2.800788e-02, 
        2.815196e-02, 2.829371e-02, 2.841866e-02, 2.850806e-02, 2.859112e-02, 2.867208e-02, 2.875144e-02, 2.882869e-02, 
        2.890365e-02, 2.896650e-02, 2.900974e-02, 2.904810e-02, 2.910987e-02, 2.917881e-02, 2.917776e-02, 2.916975e-02, 
        2.915829e-02, 2.914576e-02, 2.912872e-02, 2.910170e-02, 2.906646e-02, 2.901714e-02, 2.896276e-02, 2.889193e-02, 
        2.881246e-02, 2.873334e-02, 2.865144e-02, 2.855451e-02, 2.845170e-02, 2.834675e-02, 2.823901e-02, 2.812772e-02, 
        2.801081e-02, 2.787629e-02, 2.771456e-02, 2.754716e-02, 2.737634e-02, 2.720424e-02, 2.703163e-02, 2.685442e-02, 
        2.667217e-02, 2.648514e-02, 2.629500e-02, 2.610084e-02, 2.591180e-02, 2.571996e-02, 2.551914e-02, 2.530547e-02, 
        2.509024e-02, 2.487238e-02, 2.464957e-02, 2.440947e-02, 2.415352e-02, 2.388243e-02, 2.360648e-02, 2.328907e-02, 
        2.296099e-02, 2.262688e-02, 2.228336e-02, 2.193198e-02, 2.157621e-02, 2.122087e-02, 2.085911e-02, 2.049128e-02, 
        2.011490e-02, 1.973083e-02, 1.933753e-02, 1.893406e-02, 1.852277e-02, 1.810294e-02, 1.766812e-02, 1.722695e-02, 
        1.678013e-02, 1.630866e-02, 1.582072e-02, 1.533606e-02, 1.485178e-02, 1.436312e-02, 1.389237e-02, 1.342056e-02, 
        1.295249e-02, 1.248761e-02, 1.202538e-02, 1.156448e-02, 1.110221e-02, 1.063403e-02, 1.016925e-02, 9.705857e-03, 
        9.241361e-03, 8.780186e-03, 8.320196e-03, 7.861386e-03, 7.404690e-03, 6.948702e-03, 6.492689e-03, 6.035016e-03, 
        5.588828e-03, 5.144262e-03, 4.700165e-03, 4.260471e-03, 3.820413e-03, 3.378009e-03, 2.936965e-03, 2.496685e-03, 
        2.056279e-03, 1.616401e-03, 1.191256e-03, 7.536394e-04, 3.129552e-04, -1.289709e-04, -5.984666e-04, -1.068986e-03, 
        -1.540534e-03, -2.018044e-03, -2.500498e-03, -2.979633e-03, -3.446692e-03, -3.905171e-03, -4.363551e-03, -4.831924e-03, 
        -5.299494e-03, -5.768363e-03, -6.238863e-03, -6.713220e-03, -7.188559e-03, -7.681969e-03, -8.167602e-03, -8.632872e-03, 
        -9.094300e-03, -9.556350e-03, -1.001708e-02, -1.047489e-02, -1.093133e-02, -1.138558e-02, -1.183474e-02, -1.227822e-02, 
        -1.271034e-02, -1.311342e-02, -1.351145e-02, -1.389745e-02, -1.427333e-02, -1.464059e-02, -1.500170e-02, -1.535901e-02, 
        -1.571338e-02, -1.606026e-02, -1.639657e-02, -1.669678e-02, -1.699257e-02, -1.728501e-02, -1.757322e-02, -1.785175e-02, 
        -1.812491e-02, -1.839617e-02, -1.866475e-02, -1.893234e-02, -1.920176e-02, -1.944210e-02, -1.968713e-02, -1.993595e-02, 
        -2.018648e-02, -2.043727e-02, -2.069106e-02, -2.094287e-02, -2.118790e-02, -2.142222e-02, -2.165966e-02, -2.187858e-02, 
        -2.207911e-02, -2.228202e-02, -2.248486e-02, -2.268916e-02, -2.289575e-02, -2.310060e-02, -2.330430e-02, -2.349982e-02, 
        -2.369265e-02, -2.387126e-02, -2.401661e-02, -2.416483e-02, -2.431245e-02, -2.446701e-02, -2.462648e-02, -2.480247e-02, 
        -2.498029e-02, -2.515447e-02, -2.532875e-02, -2.549896e-02, -2.561131e-02, -2.572436e-02, -2.583953e-02, -2.595272e-02, 
        -2.606886e-02, -2.620108e-02, -2.634142e-02, -2.648246e-02, -2.662419e-02, -2.676823e-02, -2.686031e-02, -2.693937e-02, 
        -2.701250e-02, -2.707716e-02, -2.713994e-02, -2.720194e-02, -2.726222e-02, -2.731722e-02, -2.736718e-02, -2.741234e-02, 
        -2.740787e-02, -2.736974e-02, -2.732665e-02, -2.727741e-02, -2.722798e-02, -2.717501e-02, -2.711777e-02, -2.705342e-02, 
        -2.698006e-02, -2.690410e-02, -2.679515e-02, -2.663376e-02, -2.646899e-02, -2.630447e-02, -2.613991e-02, -2.597426e-02, 
        -2.580972e-02, -2.564703e-02, -2.546739e-02, -2.528640e-02, -2.509463e-02, -2.482749e-02, -2.455954e-02, -2.429094e-02, 
        -2.402580e-02, -2.376498e-02, -2.350641e-02, -2.325066e-02, -2.300422e-02, -2.275431e-02, -2.250732e-02, -2.215493e-02, 
        -2.178699e-02, -2.142203e-02, -2.105955e-02, -2.069899e-02, -2.034095e-02, -1.998511e-02, -1.963402e-02, -1.927448e-02, 
        -1.891150e-02, -1.847149e-02, -1.799834e-02, -1.752812e-02, -1.705416e-02, -1.656324e-02, -1.607551e-02, -1.558619e-02, 
        -1.509975e-02, -1.461906e-02, -1.412681e-02, -1.357825e-02, -1.296390e-02, -1.235324e-02, -1.174679e-02, -1.114098e-02, 
        -1.053527e-02, -9.935998e-03, -9.318518e-03, -8.696637e-03, -8.082559e-03, -7.425515e-03, -6.664508e-03, -5.906687e-03, 
        -5.151437e-03, -4.401025e-03, -3.655789e-03, -2.915332e-03, -2.179478e-03, -1.448199e-03, -7.217395e-04, -2.567240e-18
    },
    {
        0.000000e+00, 1.994115e-01, 1.800203e-01, 1.545653e-01, 1.299366e-01, 1.062012e-01, 8.457450e-02, 6.488222e-02, 
        4.582496e-02, 2.772342e-02, 1.092794e-02, -4.723545e-03, -1.888470e-02, -3.061054e-02, -4.022590e-02, -4.805896e-02, 
        -5.397992e-02, -5.710701e-02, -5.818212e-02, -5.794322e-02, -5.703980e-02, -5.625454e-02, -5.561314e-02, -5.507816e-02, 
        -5.383257e-02, -5.228108e-02, -5.080053e-02, -4.990720e-02, -5.017243e-02, -5.112138e-02, -5.221414e-02, -5.336463e-02, 
        -5.449491e-02, -5.540424e-02, -5.577496e-02, -5.544910e-02, -5.427255e-02, -5.230961e-02, -4.962822e-02, -4.633362e-02, 
        -4.256385e-02, -3.847006e-02, -3.396507e-02, -2.927351e-02, -2.439569e-02, -1.943869e-02, -1.452581e-02, -9.778460e-03, 
        -5.048164e-03, -1.867567e-04, 4.743900e-03, 1.024199e-02, 1.640414e-02, 2.289655e-02, 2.956801e-02, 3.630103e-02, 
        4.300259e-02, 4.937217e-02, 5.518242e-02, 6.034856e-02, 6.452966e-02, 6.779443e-02, 7.070444e-02, 7.335252e-02, 
        7.567860e-02, 7.753827e-02, 7.907946e-02, 8.048497e-02, 8.177406e-02, 8.263777e-02, 8.302860e-02, 8.322929e-02, 
        8.325761e-02, 8.290563e-02, 8.207983e-02, 8.113907e-02, 7.997070e-02, 7.841454e-02, 7.645719e-02, 7.443928e-02, 
        7.219326e-02, 6.950285e-02, 6.676136e-02, 6.401585e-02, 6.073379e-02, 5.721529e-02, 5.361167e-02, 4.957851e-02, 
        4.550726e-02, 4.119757e-02, 3.645610e-02, 3.165577e-02, 2.635704e-02, 2.113759e-02, 1.574249e-02, 1.002620e-02, 
        4.174248e-03, -1.853029e-03, -7.871257e-03, -1.396751e-02, -2.000963e-02, -2.602361e-02, -3.180849e-02, -3.738520e-02, 
        -4.274972e-02, -4.784664e-02, -5.247224e-02, -5.661126e-02, -6.049407e-02, -6.402261e-02, -6.701596e-02, -6.961977e-02, 
        -7.210251e-02, -7.405991e-02, -7.591641e-02, -7.747944e-02, -7.872568e-02, -7.978812e-02, -8.066890e-02, -8.138986e-02, 
        -8.189995e-02, -8.244012e-02, -8.279679e-02, -8.292167e-02, -8.292392e-02, -8.268926e-02, -8.217472e-02, -8.144679e-02, 
        -8.054291e-02, -7.942496e-02, -7.812349e-02, -7.659656e-02, -7.481911e-02, -7.290770e-02, -7.088981e-02, -6.854076e-02, 
        -6.606341e-02, -6.348505e-02, -6.069982e-02, -5.779689e-02, -5.491708e-02, -5.183715e-02, -4.871784e-02, -4.574789e-02, 
        -4.267877e-02, -3.950965e-02, -3.634840e-02, -3.313373e-02, -3.010130e-02, -2.696456e-02, -2.397643e-02, -2.114233e-02, 
        -1.828296e-02, -1.541789e-02, -1.265875e-02, -9.858510e-03, -7.186767e-03, -4.550681e-03, -1.879534e-03, 7.951079e-04, 
        3.408193e-03, 6.183411e-03, 8.915607e-03, 1.160468e-02, 1.434871e-02, 1.722379e-02, 2.016723e-02, 2.305516e-02, 
        2.589494e-02, 2.867486e-02, 3.144102e-02, 3.430633e-02, 3.705611e-02, 3.971557e-02, 4.232671e-02, 4.498104e-02, 
        4.750010e-02, 4.985911e-02, 5.215897e-02, 5.443794e-02, 5.650808e-02, 5.849790e-02, 6.038815e-02, 6.207193e-02, 
        6.355134e-02, 6.496431e-02, 6.615325e-02, 6.713388e-02, 6.805462e-02, 6.856693e-02, 6.898120e-02, 6.919332e-02, 
        6.918685e-02, 6.901046e-02, 6.851246e-02, 6.787536e-02, 6.697997e-02, 6.590996e-02, 6.453573e-02, 6.300738e-02, 
        6.128590e-02, 5.939574e-02, 5.747478e-02, 5.545459e-02, 5.347508e-02, 5.145667e-02, 4.943969e-02, 4.738949e-02, 
        4.538466e-02, 4.335512e-02, 4.143163e-02, 3.944634e-02, 3.750252e-02, 3.558318e-02, 3.374665e-02, 3.195876e-02, 
        3.016734e-02, 2.841343e-02, 2.659634e-02, 2.495524e-02, 2.329459e-02, 2.163580e-02, 1.999798e-02, 1.832130e-02, 
        1.668069e-02, 1.511285e-02, 1.352915e-02, 1.196980e-02, 1.042156e-02, 8.812893e-03, 7.276352e-03, 5.816718e-03, 
        4.300734e-03, 2.831803e-03, 1.382030e-03, -8.584407e-05, -1.522037e-03, -2.899761e-03, -4.235273e-03, -5.575000e-03, 
        -6.914166e-03, -8.216285e-03, -9.569998e-03, -1.091799e-02, -1.213511e-02, -1.335990e-02, -1.462280e-02, -1.587424e-02, 
        -1.707880e-02, -1.830529e-02, -1.950721e-02, -2.066613e-02, -2.179987e-02, -2.294531e-02, -2.406942e-02, -2.516915e-02, 
        -2.621419e-02, -2.721940e-02, -2.819383e-02, -2.917306e-02, -3.005866e-02, -3.087541e-02, -3.166449e-02, -3.245383e-02, 
        -3.318760e-02, -3.383592e-02, -3.446329e-02, -3.503471e-02, -3.557826e-02, -3.604683e-02, -3.643831e-02, -3.671976e-02, 
        -3.689451e-02, -3.695002e-02, -3.685698e-02, -3.668621e-02, -3.641659e-02, -3.607950e-02, -3.566249e-02, -3.512920e-02, 
        -3.454340e-02, -3.392062e-02, -3.322512e-02, -3.244180e-02, -3.156596e-02, -3.064623e-02, -2.970363e-02, -2.873052e-02, 
        -2.772481e-02, -2.666664e-02, -2.554997e-02, -2.440148e-02, -2.322167e-02, -2.208665e-02, -2.089837e-02, -1.968317e-02, 
        -1.846749e-02, -1.722797e-02, -1.599427e-02, -1.479363e-02, -1.357495e-02, -1.239061e-02, -1.117971e-02, -9.989264e-03, 
        -8.805567e-03, -7.694404e-03, -6.612748e-03, -5.549787e-03, -4.500399e-03, -3.486171e-03, -2.464558e-03, -1.498954e-03, 
        -5.846051e-04, 2.768073e-04, 1.064311e-03, 1.770394e-03, 2.392970e-03, 2.977479e-03, 3.465503e-03, 3.890226e-03, 
        4.211557e-03, 4.426568e-03, 4.558136e-03, 4.627256e-03, 4.601091e-03, 4.490713e-03, 4.358354e-03, 4.239949e-03, 
        4.078649e-03, 3.891331e-03, 3.703991e-03, 3.485885e-03, 3.256289e-03, 3.030036e-03, 2.778938e-03, 2.542953e-03, 
        2.361275e-03, 2.156343e-03, 1.893464e-03, 1.614705e-03, 1.372374e-03, 1.136471e-03, 9.298647e-04, 7.181386e-04, 
        5.421042e-04, 4.016982e-04, 2.055644e-04, 4.693864e-05, -8.816619e-05, -2.384021e-04, -3.908703e-04, -5.145917e-04, 
        -6.438117e-04, -7.884539e-04, -9.246930e-04, -1.011938e-03, -1.033255e-03, -1.048758e-03, -1.041810e-03, -1.053986e-03, 
        -1.106793e-03, -1.210031e-03, -1.325548e-03, -1.437410e-03, -1.497819e-03, -1.491852e-03, -1.480585e-03, -1.470560e-03, 
        -1.434580e-03, -1.377257e-03, -1.381436e-03, -1.394461e-03, -1.423218e-03, -1.418667e-03, -1.316771e-03, -1.202684e-03, 
        -1.075200e-03, -9.376969e-04, -8.280971e-04, -7.796047e-04, -7.302366e-04, -6.624544e-04, -6.092372e-04, -5.252831e-04, 
        -4.008807e-04, -2.414486e-04, -9.781290e-05, 3.044945e-05, 8.284647e-05, 1.305904e-04, 1.623638e-04, 1.853695e-04, 
        2.317645e-04, 3.045913e-04, 3.990136e-04, 4.987041e-04, 6.220249e-04, 7.118130e-04, 7.676574e-04, 8.099047e-04, 
        8.294054e-04, 8.377904e-04, 8.822233e-04, 9.177472e-04, 9.379131e-04, 9.440616e-04, 9.810649e-04, 1.103409e-03, 
        1.176540e-03, 1.223098e-03, 1.259795e-03, 1.292701e-03, 1.335389e-03, 1.338652e-03, 1.339449e-03, 1.381085e-03, 
        1.488194e-03, 1.577164e-03, 1.630007e-03, 1.662634e-03, 1.693413e-03, 1.728487e-03, 1.728010e-03, 1.739054e-03, 
        1.765114e-03, 1.808860e-03, 1.860458e-03, 1.908194e-03, 1.959702e-03, 1.989123e-03, 1.976282e-03, 1.948353e-03, 
        1.938278e-03, 1.933186e-03, 1.959555e-03, 1.984207e-03, 2.007310e-03, 2.026893e-03, 2.054498e-03, 2.087436e-03, 
        2.153807e-03, 2.193039e-03, 2.173026e-03, 2.168770e-03, 2.171189e-03, 2.227901e-03, 2.244870e-03, 2.249290e-03, 
        2.244648e-03, 2.240134e-03, 2.243374e-03, 2.223341e-03, 2.195735e-03, 2.194777e-03, 2.192997e-03, 2.156069e-03, 
        2.079016e-03, 1.971312e-03, 1.890285e-03, 1.849775e-03, 1.811996e-03, 1.747163e-03, 1.654081e-03, 1.586662e-03, 
        1.509017e-03, 1.407003e-03, 1.287489e-03, 1.156615e-03, 1.029739e-03, 8.725774e-04, 7.514670e-04, 6.310717e-04, 
        4.668026e-04, 3.296253e-04, 2.472284e-04, 1.780564e-04, 9.813202e-05, 7.024856e-06, -8.364791e-05, -1.638346e-04, 
        -2.404041e-04, -3.261619e-04, -4.043435e-04, -4.712044e-04, -5.911881e-04, -6.915854e-04, -7.744435e-04, -8.497977e-04, 
        -9.347223e-04, -1.002663e-03, -1.062698e-03, -1.103743e-03, -1.166452e-03, -1.255231e-03, -1.361254e-03, -1.447649e-03, 
        -1.520915e-03, -1.574976e-03, -1.624774e-03, -1.682619e-03, -1.773881e-03, -1.863953e-03, -1.949136e-03, -2.033017e-03, 
        -2.107201e-03, -2.189812e-03, -2.275609e-03, -2.340071e-03, -2.386362e-03, -2.436182e-03, -2.468430e-03, -2.505986e-03, 
        -2.522184e-03, -2.528802e-03, -2.534709e-03, -2.542867e-03, -2.564423e-03, -2.597663e-03, -2.625108e-03, -2.651275e-03, 
        -2.675466e-03, -2.695150e-03, -2.700661e-03, -2.680944e-03, -2.636909e-03, -2.583672e-03, -2.532316e-03, -2.494897e-03, 
        -2.484584e-03, -2.458162e-03, -2.437826e-03, -2.417717e-03, -2.403159e-03, -2.387185e-03, -2.392382e-03, -2.406272e-03, 
        -2.431643e-03, -2.437993e-03, -2.413190e-03, -2.381726e-03, -2.339674e-03, -2.310178e-03, -2.261447e-03, -2.199916e-03, 
        -2.118498e-03, -2.026408e-03, -1.914556e-03, -1.771726e-03, -1.595517e-03, -1.386857e-03, -1.158363e-03, -9.254445e-04, 
        -6.746435e-04, -4.075848e-04, -1.382223e-04, 1.566729e-04, 4.775807e-04, 8.081464e-04, 1.152529e-03, 1.524407e-03, 
        1.907760e-03, 2.300949e-03, 2.688409e-03, 3.080793e-03, 3.476256e-03, 3.890289e-03, 4.314994e-03, 4.753486e-03, 
        5.211753e-03, 5.687781e-03, 6.179677e-03, 6.675471e-03, 7.169366e-03, 7.652750e-03, 8.130249e-03, 8.621879e-03, 
        9.142344e-03, 9.666380e-03, 1.020179e-02, 1.075643e-02, 1.131664e-02, 1.188455e-02, 1.247185e-02, 1.306803e-02, 
        1.366827e-02, 1.425815e-02, 1.484815e-02, 1.543804e-02, 1.603555e-02, 1.663695e-02, 1.721990e-02, 1.779312e-02, 
        1.836562e-02, 1.892609e-02, 1.949438e-02, 2.007326e-02, 2.062172e-02, 2.111005e-02, 2.160011e-02, 2.209030e-02, 
        2.259632e-02, 2.309821e-02, 2.358284e-02, 2.405531e-02, 2.451988e-02, 2.497966e-02, 2.542588e-02, 2.583990e-02, 
        2.624814e-02, 2.663117e-02, 2.699270e-02, 2.732745e-02, 2.764841e-02, 2.795764e-02, 2.826967e-02, 2.857269e-02, 
        2.885510e-02, 2.911152e-02, 2.935808e-02, 2.958524e-02, 2.975768e-02, 2.991022e-02, 3.009176e-02, 3.026225e-02, 
        3.040200e-02, 3.050378e-02, 3.059241e-02, 3.066170e-02, 3.070899e-02, 3.072240e-02, 3.067765e-02, 3.059507e-02, 
        3.048192e-02, 3.033001e-02, 3.015391e-02, 2.994818e-02, 2.971085e-02, 2.942712e-02, 2.909253e-02, 2.872605e-02, 
        2.830716e-02, 2.784749e-02, 2.735425e-02, 2.683947e-02, 2.628566e-02, 2.569121e-02, 2.508597e-02, 2.446298e-02, 
        2.381813e-02, 2.315801e-02, 2.252099e-02, 2.185049e-02, 2.113087e-02, 2.037404e-02, 1.959958e-02, 1.883099e-02, 
        1.807093e-02, 1.729770e-02, 1.652498e-02, 1.573159e-02, 1.495137e-02, 1.421379e-02, 1.346815e-02, 1.273341e-02, 
        1.201557e-02, 1.129502e-02, 1.057152e-02, 9.848899e-03, 9.129448e-03, 8.397180e-03, 7.642661e-03, 6.912411e-03, 
        6.261204e-03, 5.593916e-03, 4.907036e-03, 4.229196e-03, 3.540967e-03, 2.843428e-03, 2.145019e-03, 1.479969e-03, 
        8.144344e-04, 1.216311e-04, -5.833074e-04, -1.273385e-03, -1.970200e-03, -2.678760e-03, -3.305254e-03, -3.870133e-03, 
        -4.422037e-03, -4.977046e-03, -5.525795e-03, -6.075219e-03, -6.630161e-03, -7.192632e-03, -7.760078e-03, -8.326019e-03, 
        -8.906654e-03, -9.505481e-03, -1.003924e-02, -1.057216e-02, -1.110722e-02, -1.164026e-02, -1.218242e-02, -1.270181e-02, 
        -1.319003e-02, -1.365166e-02, -1.410855e-02, -1.455369e-02, -1.500198e-02, -1.545054e-02, -1.590635e-02, -1.637174e-02, 
        -1.683438e-02, -1.729068e-02, -1.775106e-02, -1.821105e-02, -1.867706e-02, -1.912882e-02, -1.956989e-02, -2.000570e-02, 
        -2.047037e-02, -2.094902e-02, -2.135494e-02, -2.171667e-02, -2.206925e-02, -2.241727e-02, -2.275526e-02, -2.304135e-02, 
        -2.331169e-02, -2.358582e-02, -2.385427e-02, -2.411570e-02, -2.437681e-02, -2.465152e-02, -2.494976e-02, -2.524366e-02, 
        -2.553070e-02, -2.580825e-02, -2.607810e-02, -2.632767e-02, -2.657636e-02, -2.684301e-02, -2.709067e-02, -2.732745e-02, 
        -2.757891e-02, -2.783068e-02, -2.806875e-02, -2.827531e-02, -2.846376e-02, -2.864872e-02, -2.881077e-02, -2.896882e-02, 
        -2.912747e-02, -2.927044e-02, -2.938489e-02, -2.949837e-02, -2.958264e-02, -2.966053e-02, -2.969128e-02, -2.972274e-02, 
        -2.975694e-02, -2.978394e-02, -2.980791e-02, -2.982642e-02, -2.982843e-02, -2.981198e-02, -2.978656e-02, -2.975477e-02, 
        -2.973172e-02, -2.970673e-02, -2.968467e-02, -2.965510e-02, -2.961405e-02, -2.955663e-02, -2.948887e-02, -2.941371e-02, 
        -2.932945e-02, -2.922619e-02, -2.911933e-02, -2.900568e-02, -2.887813e-02, -2.874517e-02, -2.859753e-02, -2.844296e-02, 
        -2.828284e-02, -2.812081e-02, -2.796222e-02, -2.781061e-02, -2.763165e-02, -2.743285e-02, -2.721977e-02, -2.699281e-02, 
        -2.676430e-02, -2.653488e-02, -2.631279e-02, -2.607819e-02, -2.582505e-02, -2.555764e-02, -2.529125e-02, -2.498855e-02, 
        -2.467981e-02, -2.437210e-02, -2.406614e-02, -2.378183e-02, -2.352124e-02, -2.325633e-02, -2.298571e-02, -2.270701e-02, 
        -2.241807e-02, -2.212651e-02, -2.183469e-02, -2.154408e-02, -2.125230e-02, -2.096461e-02, -2.066675e-02, -2.035571e-02, 
        -2.002522e-02, -1.965941e-02, -1.926862e-02, -1.886961e-02, -1.846221e-02, -1.803678e-02, -1.759340e-02, -1.714963e-02, 
        -1.669965e-02, -1.624895e-02, -1.579296e-02, -1.533473e-02, -1.487257e-02, -1.440648e-02, -1.394547e-02, -1.349306e-02, 
        -1.303329e-02, -1.256285e-02, -1.209812e-02, -1.163973e-02, -1.118525e-02, -1.073190e-02, -1.028767e-02, -9.853180e-03, 
        -9.444167e-03, -9.038903e-03, -8.646198e-03, -8.249178e-03, -7.837462e-03, -7.416346e-03, -6.988440e-03, -6.551874e-03, 
        -6.112431e-03, -5.675586e-03, -5.254285e-03, -4.810506e-03, -4.366722e-03, -3.922109e-03, -3.447888e-03, -2.980728e-03, 
        -2.515324e-03, -2.035227e-03, -1.534855e-03, -1.046957e-03, -5.773481e-04, -1.078402e-04, 3.594199e-04, 8.382999e-04, 
        1.313792e-03, 1.788263e-03, 2.258657e-03, 2.716756e-03, 3.174055e-03, 3.641204e-03, 4.096444e-03, 4.524308e-03, 
        4.949731e-03, 5.373405e-03, 5.795411e-03, 6.223141e-03, 6.644972e-03, 7.065756e-03, 7.464499e-03, 7.858962e-03, 
        8.237450e-03, 8.589952e-03, 8.945863e-03, 9.300365e-03, 9.666188e-03, 1.004092e-02, 1.042301e-02, 1.080405e-02, 
        1.117096e-02, 1.153361e-02, 1.190375e-02, 1.223310e-02, 1.256484e-02, 1.289871e-02, 1.323478e-02, 1.358060e-02, 
        1.394978e-02, 1.431581e-02, 1.467376e-02, 1.502842e-02, 1.538847e-02, 1.571083e-02, 1.603173e-02, 1.634546e-02, 
        1.666260e-02, 1.699210e-02, 1.731944e-02, 1.763995e-02, 1.796294e-02, 1.828430e-02, 1.861413e-02, 1.891148e-02, 
        1.918801e-02, 1.946620e-02, 1.974920e-02, 2.003498e-02, 2.032269e-02, 2.060757e-02, 2.089902e-02, 2.118249e-02, 
        2.147054e-02, 2.173628e-02, 2.195179e-02, 2.217109e-02, 2.239403e-02, 2.262547e-02, 2.286194e-02, 2.309923e-02, 
        2.334493e-02, 2.358237e-02, 2.381620e-02, 2.404114e-02, 2.418968e-02, 2.434190e-02, 2.449639e-02, 2.466359e-02, 
        2.486284e-02, 2.507680e-02, 2.528531e-02, 2.549299e-02, 2.570084e-02, 2.591056e-02, 2.604882e-02, 2.618800e-02, 
        2.632532e-02, 2.646491e-02, 2.661001e-02, 2.675594e-02, 2.688870e-02, 2.701337e-02, 2.714179e-02, 2.728166e-02, 
        2.736228e-02, 2.740784e-02, 2.745358e-02, 2.750195e-02, 2.755637e-02, 2.761526e-02, 2.766599e-02, 2.769690e-02, 
        2.771925e-02, 2.774145e-02, 2.772148e-02, 2.763421e-02, 2.754580e-02, 2.746702e-02, 2.739504e-02, 2.732600e-02, 
        2.725186e-02, 2.716142e-02, 2.704823e-02, 2.692614e-02, 2.677919e-02, 2.652559e-02, 2.627190e-02, 2.602732e-02, 
        2.578227e-02, 2.553829e-02, 2.530127e-02, 2.508215e-02, 2.485323e-02, 2.461848e-02, 2.439795e-02, 2.406492e-02, 
        2.372369e-02, 2.338799e-02, 2.305694e-02, 2.273056e-02, 2.240680e-02, 2.208303e-02, 2.175864e-02, 2.141452e-02, 
        2.106455e-02, 2.061398e-02, 2.012728e-02, 1.964071e-02, 1.915317e-02, 1.865905e-02, 1.816798e-02, 1.769839e-02, 
        1.722646e-02, 1.673997e-02, 1.620857e-02, 1.559720e-02, 1.489314e-02, 1.418567e-02, 1.347678e-02, 1.278654e-02, 
        1.209855e-02, 1.142005e-02, 1.073145e-02, 1.004071e-02, 9.344574e-03, 8.571980e-03, 7.670828e-03, 6.788875e-03, 
        5.927109e-03, 5.068001e-03, 4.212475e-03, 3.360459e-03, 2.513387e-03, 1.670471e-03, 8.330329e-04, -3.150190e-17
    },
    {
        0.000000e+00, 2.616309e-01, 2.187042e-01, 1.748157e-01, 1.417391e-01, 1.150747e-01, 8.688658e-02, 6.075912e-02, 
        3.646030e-02, 1.351882e-02, -8.209922e-03, -2.886362e-02, -4.766997e-02, -6.452617e-02, -7.749161e-02, -8.697334e-02, 
        -9.373771e-02, -9.940247e-02, -1.046593e-01, -1.083829e-01, -1.105832e-01, -1.117065e-01, -1.115141e-01, -1.105643e-01, 
        -1.090158e-01, -1.067233e-01, -1.030868e-01, -9.781883e-02, -9.039628e-02, -8.085284e-02, -6.991689e-02, -5.785499e-02, 
        -4.543213e-02, -3.286415e-02, -2.012794e-02, -7.606798e-03, 4.347646e-03, 1.524646e-02, 2.574387e-02, 3.608154e-02, 
        4.608898e-02, 5.483372e-02, 6.345248e-02, 7.156473e-02, 7.881243e-02, 8.527163e-02, 9.114060e-02, 9.636036e-02, 
        1.003114e-01, 1.040243e-01, 1.070431e-01, 1.086666e-01, 1.093005e-01, 1.084687e-01, 1.065810e-01, 1.037056e-01, 
        1.000408e-01, 9.550326e-02, 9.029829e-02, 8.517134e-02, 7.922808e-02, 7.320034e-02, 6.681099e-02, 5.971452e-02, 
        5.216704e-02, 4.456903e-02, 3.666625e-02, 2.850437e-02, 2.035880e-02, 1.231888e-02, 4.545512e-03, -3.166212e-03, 
        -1.053504e-02, -1.769757e-02, -2.434263e-02, -3.059878e-02, -3.629133e-02, -4.149259e-02, -4.613754e-02, -5.029473e-02, 
        -5.400154e-02, -5.679247e-02, -5.925371e-02, -6.098967e-02, -6.227302e-02, -6.300515e-02, -6.324049e-02, -6.323603e-02, 
        -6.252300e-02, -6.155722e-02, -6.043528e-02, -5.889734e-02, -5.721450e-02, -5.529738e-02, -5.307543e-02, -5.065763e-02, 
        -4.849789e-02, -4.620116e-02, -4.371069e-02, -4.139970e-02, -3.915118e-02, -3.688204e-02, -3.472676e-02, -3.240213e-02, 
        -3.007064e-02, -2.801528e-02, -2.602072e-02, -2.412263e-02, -2.228238e-02, -2.071468e-02, -1.904888e-02, -1.755147e-02, 
        -1.614635e-02, -1.473501e-02, -1.328342e-02, -1.202087e-02, -1.066777e-02, -9.281785e-03, -7.742223e-03, -5.960808e-03, 
        -4.257935e-03, -2.422493e-03, -3.195274e-04, 1.796373e-03, 3.828922e-03, 5.601601e-03, 7.425616e-03, 9.215458e-03, 
        1.106508e-02, 1.283224e-02, 1.448997e-02, 1.617500e-02, 1.783639e-02, 1.944480e-02, 2.086413e-02, 2.222284e-02, 
        2.349670e-02, 2.486960e-02, 2.604883e-02, 2.717056e-02, 2.830369e-02, 2.933500e-02, 3.015436e-02, 3.085847e-02, 
        3.161770e-02, 3.220586e-02, 3.279920e-02, 3.342561e-02, 3.381156e-02, 3.412947e-02, 3.437861e-02, 3.457182e-02, 
        3.473040e-02, 3.475502e-02, 3.469529e-02, 3.466792e-02, 3.451209e-02, 3.423636e-02, 3.394094e-02, 3.356073e-02, 
        3.308630e-02, 3.266903e-02, 3.204367e-02, 3.120684e-02, 3.039136e-02, 2.953746e-02, 2.864049e-02, 2.758818e-02, 
        2.647184e-02, 2.538506e-02, 2.434684e-02, 2.332702e-02, 2.209125e-02, 2.085895e-02, 1.967308e-02, 1.858240e-02, 
        1.731540e-02, 1.599940e-02, 1.474620e-02, 1.357118e-02, 1.207677e-02, 1.065390e-02, 9.352745e-03, 7.894652e-03, 
        6.400186e-03, 4.870625e-03, 3.202870e-03, 1.529805e-03, 3.449278e-06, -1.866329e-03, -3.732043e-03, -5.676562e-03, 
        -7.703822e-03, -9.642500e-03, -1.182382e-02, -1.392094e-02, -1.620490e-02, -1.833710e-02, -2.043938e-02, -2.239789e-02, 
        -2.430849e-02, -2.611203e-02, -2.794738e-02, -2.976166e-02, -3.143381e-02, -3.301074e-02, -3.445158e-02, -3.590805e-02, 
        -3.713095e-02, -3.831127e-02, -3.922851e-02, -4.008871e-02, -4.073530e-02, -4.131773e-02, -4.168150e-02, -4.192563e-02, 
        -4.203134e-02, -4.201026e-02, -4.200734e-02, -4.172996e-02, -4.140786e-02, -4.095624e-02, -4.035322e-02, -3.973137e-02, 
        -3.894405e-02, -3.810126e-02, -3.720283e-02, -3.614239e-02, -3.504046e-02, -3.396816e-02, -3.271543e-02, -3.142777e-02, 
        -3.012944e-02, -2.872402e-02, -2.730413e-02, -2.590909e-02, -2.447171e-02, -2.291314e-02, -2.133224e-02, -1.975593e-02, 
        -1.819254e-02, -1.656962e-02, -1.503513e-02, -1.345689e-02, -1.174644e-02, -1.005234e-02, -8.510246e-03, -6.953671e-03, 
        -5.323991e-03, -3.747955e-03, -2.126349e-03, -4.840920e-04, 1.115175e-03, 2.650654e-03, 4.186460e-03, 5.705632e-03, 
        7.272811e-03, 8.887157e-03, 1.040112e-02, 1.180232e-02, 1.329916e-02, 1.484239e-02, 1.635634e-02, 1.782388e-02, 
        1.928053e-02, 2.064900e-02, 2.197776e-02, 2.329312e-02, 2.455140e-02, 2.580663e-02, 2.695870e-02, 2.789678e-02, 
        2.865565e-02, 2.929528e-02, 2.991832e-02, 3.044219e-02, 3.087617e-02, 3.118649e-02, 3.134317e-02, 3.137674e-02, 
        3.132466e-02, 3.118910e-02, 3.101798e-02, 3.079929e-02, 3.053619e-02, 3.018039e-02, 2.966197e-02, 2.905223e-02, 
        2.836924e-02, 2.769439e-02, 2.701125e-02, 2.629913e-02, 2.558599e-02, 2.471208e-02, 2.374464e-02, 2.282130e-02, 
        2.183831e-02, 2.084821e-02, 1.984954e-02, 1.884930e-02, 1.792678e-02, 1.688622e-02, 1.582119e-02, 1.470698e-02, 
        1.365960e-02, 1.254829e-02, 1.146662e-02, 1.043918e-02, 9.432422e-03, 8.408720e-03, 7.361661e-03, 6.296192e-03, 
        5.237162e-03, 4.297232e-03, 3.340338e-03, 2.401789e-03, 1.485533e-03, 6.973520e-04, -9.765721e-05, -7.986929e-04, 
        -1.457459e-03, -2.051026e-03, -2.508999e-03, -2.823115e-03, -3.085576e-03, -3.301244e-03, -3.532309e-03, -3.759468e-03, 
        -3.939279e-03, -4.105624e-03, -4.257060e-03, -4.402302e-03, -4.524387e-03, -4.614262e-03, -4.709395e-03, -4.766498e-03, 
        -4.789093e-03, -4.838223e-03, -4.927303e-03, -5.075132e-03, -5.237850e-03, -5.343672e-03, -5.369815e-03, -5.385244e-03, 
        -5.385448e-03, -5.421267e-03, -5.451886e-03, -5.448310e-03, -5.548790e-03, -5.637334e-03, -5.718407e-03, -5.754008e-03, 
        -5.770676e-03, -5.760104e-03, -5.781192e-03, -5.772122e-03, -5.747847e-03, -5.744699e-03, -5.664803e-03, -5.564198e-03, 
        -5.508380e-03, -5.504042e-03, -5.430905e-03, -5.305196e-03, -5.246689e-03, -5.252686e-03, -5.248574e-03, -5.177898e-03, 
        -5.032330e-03, -4.853154e-03, -4.721768e-03, -4.628169e-03, -4.584288e-03, -4.565798e-03, -4.615826e-03, -4.702669e-03, 
        -4.776684e-03, -4.843721e-03, -4.803575e-03, -4.784674e-03, -4.752776e-03, -4.745525e-03, -4.743236e-03, -4.811438e-03, 
        -4.950630e-03, -5.125605e-03, -5.270802e-03, -5.411600e-03, -5.591552e-03, -5.763395e-03, -5.915234e-03, -6.008405e-03, 
        -6.098120e-03, -6.184349e-03, -6.332087e-03, -6.521344e-03, -6.718278e-03, -6.965978e-03, -7.265330e-03, -7.524359e-03, 
        -7.761833e-03, -7.987428e-03, -8.184914e-03, -8.384649e-03, -8.693130e-03, -9.019203e-03, -9.372612e-03, -9.725989e-03, 
        -1.009062e-02, -1.043568e-02, -1.076088e-02, -1.102721e-02, -1.128950e-02, -1.158322e-02, -1.188324e-02, -1.213739e-02, 
        -1.237289e-02, -1.259527e-02, -1.282652e-02, -1.311049e-02, -1.338502e-02, -1.361028e-02, -1.380472e-02, -1.397776e-02, 
        -1.408034e-02, -1.412290e-02, -1.413199e-02, -1.408977e-02, -1.400033e-02, -1.391448e-02, -1.383656e-02, -1.370991e-02, 
        -1.354660e-02, -1.330013e-02, -1.299053e-02, -1.265488e-02, -1.235031e-02, -1.202417e-02, -1.166323e-02, -1.129266e-02, 
        -1.087387e-02, -1.039377e-02, -9.934663e-03, -9.424126e-03, -8.834887e-03, -8.230009e-03, -7.702270e-03, -7.204794e-03, 
        -6.682111e-03, -6.144585e-03, -5.587094e-03, -5.002825e-03, -4.375693e-03, -3.722229e-03, -3.089703e-03, -2.465468e-03, 
        -1.800777e-03, -1.116030e-03, -4.498091e-04, 2.248057e-04, 9.706666e-04, 1.733746e-03, 2.505235e-03, 3.348760e-03, 
        4.171017e-03, 4.942018e-03, 5.728039e-03, 6.524442e-03, 7.318125e-03, 8.073822e-03, 8.783564e-03, 9.509737e-03, 
        1.026816e-02, 1.098915e-02, 1.173011e-02, 1.247034e-02, 1.322201e-02, 1.401679e-02, 1.480660e-02, 1.558687e-02, 
        1.634232e-02, 1.709538e-02, 1.781741e-02, 1.846771e-02, 1.902315e-02, 1.955720e-02, 2.007976e-02, 2.060608e-02, 
        2.113101e-02, 2.166041e-02, 2.218780e-02, 2.270317e-02, 2.316922e-02, 2.362090e-02, 2.403324e-02, 2.447493e-02, 
        2.488595e-02, 2.530160e-02, 2.572022e-02, 2.605959e-02, 2.633706e-02, 2.658410e-02, 2.679599e-02, 2.698466e-02, 
        2.715546e-02, 2.726182e-02, 2.731446e-02, 2.730675e-02, 2.731138e-02, 2.728518e-02, 2.726644e-02, 2.723452e-02, 
        2.717142e-02, 2.706998e-02, 2.695426e-02, 2.684809e-02, 2.668433e-02, 2.647758e-02, 2.625914e-02, 2.602748e-02, 
        2.578017e-02, 2.552078e-02, 2.526091e-02, 2.502719e-02, 2.479559e-02, 2.456060e-02, 2.428876e-02, 2.403608e-02, 
        2.376839e-02, 2.350502e-02, 2.320176e-02, 2.289762e-02, 2.259429e-02, 2.229809e-02, 2.198899e-02, 2.168862e-02, 
        2.138450e-02, 2.108281e-02, 2.078204e-02, 2.046311e-02, 2.010149e-02, 1.971926e-02, 1.933504e-02, 1.894218e-02, 
        1.851907e-02, 1.805759e-02, 1.757056e-02, 1.705722e-02, 1.650379e-02, 1.592092e-02, 1.531940e-02, 1.471146e-02, 
        1.408378e-02, 1.343434e-02, 1.271643e-02, 1.194604e-02, 1.115917e-02, 1.039148e-02, 9.613897e-03, 8.793899e-03, 
        7.978010e-03, 7.123317e-03, 6.245877e-03, 5.370102e-03, 4.476524e-03, 3.576845e-03, 2.676305e-03, 1.758402e-03, 
        8.446902e-04, -7.110065e-05, -9.733178e-04, -1.869164e-03, -2.762325e-03, -3.658872e-03, -4.569332e-03, -5.511076e-03, 
        -6.478237e-03, -7.459028e-03, -8.443705e-03, -9.467735e-03, -1.049145e-02, -1.153028e-02, -1.258350e-02, -1.364316e-02, 
        -1.469400e-02, -1.571618e-02, -1.671194e-02, -1.770642e-02, -1.864553e-02, -1.957009e-02, -2.048951e-02, -2.141449e-02, 
        -2.232687e-02, -2.323075e-02, -2.407870e-02, -2.492980e-02, -2.579019e-02, -2.664221e-02, -2.742733e-02, -2.814326e-02, 
        -2.885675e-02, -2.955288e-02, -3.022473e-02, -3.083768e-02, -3.140972e-02, -3.195704e-02, -3.249520e-02, -3.304792e-02, 
        -3.357974e-02, -3.409454e-02, -3.455706e-02, -3.494506e-02, -3.532302e-02, -3.568962e-02, -3.604982e-02, -3.643438e-02, 
        -3.682183e-02, -3.719656e-02, -3.755569e-02, -3.785514e-02, -3.814662e-02, -3.845371e-02, -3.875486e-02, -3.902183e-02, 
        -3.926361e-02, -3.948225e-02, -3.958732e-02, -3.967712e-02, -3.973963e-02, -3.975492e-02, -3.971670e-02, -3.965357e-02, 
        -3.953955e-02, -3.939289e-02, -3.920699e-02, -3.899348e-02, -3.875126e-02, -3.850175e-02, -3.820469e-02, -3.785769e-02, 
        -3.749264e-02, -3.710484e-02, -3.669338e-02, -3.621590e-02, -3.569464e-02, -3.508582e-02, -3.439865e-02, -3.368438e-02, 
        -3.295247e-02, -3.221960e-02, -3.151954e-02, -3.079015e-02, -3.003636e-02, -2.925127e-02, -2.845931e-02, -2.767171e-02, 
        -2.687716e-02, -2.608908e-02, -2.531272e-02, -2.452898e-02, -2.376143e-02, -2.298945e-02, -2.221931e-02, -2.149787e-02, 
        -2.078149e-02, -2.002688e-02, -1.924975e-02, -1.846294e-02, -1.766731e-02, -1.688026e-02, -1.609423e-02, -1.532322e-02, 
        -1.454264e-02, -1.379617e-02, -1.300885e-02, -1.222838e-02, -1.145498e-02, -1.067497e-02, -9.891558e-03, -9.175706e-03, 
        -8.465063e-03, -7.750555e-03, -7.045032e-03, -6.335894e-03, -5.622342e-03, -4.913743e-03, -4.320842e-03, -3.798131e-03, 
        -3.269022e-03, -2.734525e-03, -2.208693e-03, -1.682748e-03, -1.143876e-03, -6.081016e-04, -6.630030e-05, 4.881984e-04, 
        1.053882e-03, 1.605480e-03, 2.076789e-03, 2.544047e-03, 3.025428e-03, 3.513402e-03, 3.978367e-03, 4.386814e-03, 
        4.716371e-03, 5.014728e-03, 5.334329e-03, 5.662562e-03, 6.058405e-03, 6.446699e-03, 6.840161e-03, 7.241860e-03, 
        7.674519e-03, 8.123500e-03, 8.575565e-03, 9.019672e-03, 9.450103e-03, 9.876752e-03, 1.030647e-02, 1.072961e-02, 
        1.114144e-02, 1.154630e-02, 1.184170e-02, 1.207532e-02, 1.233833e-02, 1.261466e-02, 1.287894e-02, 1.308786e-02, 
        1.327828e-02, 1.348041e-02, 1.369956e-02, 1.392951e-02, 1.416685e-02, 1.440413e-02, 1.462540e-02, 1.484389e-02, 
        1.508447e-02, 1.532451e-02, 1.558096e-02, 1.586768e-02, 1.615642e-02, 1.643420e-02, 1.669900e-02, 1.694894e-02, 
        1.719108e-02, 1.743280e-02, 1.765179e-02, 1.781542e-02, 1.796699e-02, 1.811802e-02, 1.826513e-02, 1.841026e-02, 
        1.854011e-02, 1.864458e-02, 1.871480e-02, 1.879340e-02, 1.889738e-02, 1.901934e-02, 1.908576e-02, 1.916819e-02, 
        1.927523e-02, 1.940246e-02, 1.953514e-02, 1.967653e-02, 1.981623e-02, 1.992489e-02, 2.004373e-02, 2.018901e-02, 
        2.033955e-02, 2.048860e-02, 2.066218e-02, 2.083185e-02, 2.101261e-02, 2.120715e-02, 2.140490e-02, 2.160185e-02, 
        2.179537e-02, 2.195982e-02, 2.207417e-02, 2.217943e-02, 2.227547e-02, 2.234468e-02, 2.240482e-02, 2.244652e-02, 
        2.246348e-02, 2.246817e-02, 2.247667e-02, 2.247706e-02, 2.246136e-02, 2.243421e-02, 2.238140e-02, 2.228066e-02, 
        2.217668e-02, 2.207545e-02, 2.196340e-02, 2.182217e-02, 2.167603e-02, 2.155638e-02, 2.143114e-02, 2.127399e-02, 
        2.111776e-02, 2.097319e-02, 2.083404e-02, 2.069418e-02, 2.056094e-02, 2.042159e-02, 2.030101e-02, 2.019684e-02, 
        2.009938e-02, 2.000351e-02, 1.990383e-02, 1.979381e-02, 1.968590e-02, 1.957534e-02, 1.944928e-02, 1.931353e-02, 
        1.916016e-02, 1.895429e-02, 1.870555e-02, 1.844438e-02, 1.818109e-02, 1.789508e-02, 1.761845e-02, 1.732106e-02, 
        1.700858e-02, 1.669065e-02, 1.636746e-02, 1.604298e-02, 1.572119e-02, 1.540721e-02, 1.509434e-02, 1.477797e-02, 
        1.445579e-02, 1.413619e-02, 1.380992e-02, 1.347754e-02, 1.316513e-02, 1.287765e-02, 1.259116e-02, 1.230700e-02, 
        1.205244e-02, 1.179915e-02, 1.153887e-02, 1.127258e-02, 1.099731e-02, 1.072762e-02, 1.045186e-02, 1.017873e-02, 
        9.911024e-03, 9.643432e-03, 9.385897e-03, 9.097465e-03, 8.796735e-03, 8.491115e-03, 8.169308e-03, 7.835788e-03, 
        7.498905e-03, 7.156931e-03, 6.798763e-03, 6.448502e-03, 6.112574e-03, 5.807285e-03, 5.512039e-03, 5.244423e-03, 
        4.983049e-03, 4.727585e-03, 4.475615e-03, 4.223985e-03, 3.986483e-03, 3.722121e-03, 3.478817e-03, 3.264948e-03, 
        3.058838e-03, 2.844829e-03, 2.621190e-03, 2.401502e-03, 2.173198e-03, 1.935061e-03, 1.684484e-03, 1.443250e-03, 
        1.192445e-03, 9.358708e-04, 6.640067e-04, 3.911635e-04, 8.753651e-05, -2.324088e-04, -5.587866e-04, -8.957589e-04, 
        -1.240984e-03, -1.605898e-03, -1.969859e-03, -2.313585e-03, -2.669489e-03, -3.036341e-03, -3.412040e-03, -3.791887e-03, 
        -4.186591e-03, -4.576267e-03, -4.961596e-03, -5.339523e-03, -5.699528e-03, -6.032103e-03, -6.384200e-03, -6.746542e-03, 
        -7.111394e-03, -7.470422e-03, -7.830704e-03, -8.179860e-03, -8.525526e-03, -8.843227e-03, -9.150797e-03, -9.440520e-03, 
        -9.699417e-03, -9.955033e-03, -1.021250e-02, -1.047285e-02, -1.073737e-02, -1.102376e-02, -1.132571e-02, -1.162909e-02, 
        -1.192733e-02, -1.221872e-02, -1.248308e-02, -1.275180e-02, -1.302408e-02, -1.330674e-02, -1.361168e-02, -1.393081e-02, 
        -1.425966e-02, -1.456352e-02, -1.486341e-02, -1.515424e-02, -1.538027e-02, -1.560887e-02, -1.584675e-02, -1.607153e-02, 
        -1.631649e-02, -1.656848e-02, -1.680136e-02, -1.702400e-02, -1.724729e-02, -1.747449e-02, -1.765796e-02, -1.782648e-02, 
        -1.798849e-02, -1.814933e-02, -1.832042e-02, -1.850273e-02, -1.868757e-02, -1.887861e-02, -1.907686e-02, -1.926864e-02, 
        -1.942867e-02, -1.957442e-02, -1.973200e-02, -1.990341e-02, -2.009741e-02, -2.030249e-02, -2.051201e-02, -2.071748e-02, 
        -2.091934e-02, -2.112629e-02, -2.131107e-02, -2.145359e-02, -2.159981e-02, -2.173789e-02, -2.187444e-02, -2.200218e-02, 
        -2.213378e-02, -2.227790e-02, -2.239264e-02, -2.250166e-02, -2.260443e-02, -2.263148e-02, -2.266883e-02, -2.268151e-02, 
        -2.268970e-02, -2.269930e-02, -2.271236e-02, -2.271743e-02, -2.268455e-02, -2.264106e-02, -2.259842e-02, -2.243410e-02, 
        -2.224910e-02, -2.207414e-02, -2.191017e-02, -2.175289e-02, -2.159886e-02, -2.144884e-02, -2.129710e-02, -2.110407e-02, 
        -2.090125e-02, -2.062630e-02, -2.029199e-02, -1.995701e-02, -1.960875e-02, -1.921918e-02, -1.883493e-02, -1.842686e-02, 
        -1.801856e-02, -1.760148e-02, -1.713699e-02, -1.660590e-02, -1.599780e-02, -1.537926e-02, -1.475072e-02, -1.408667e-02, 
        -1.340152e-02, -1.269229e-02, -1.193805e-02, -1.116873e-02, -1.040116e-02, -9.555318e-03, -8.611026e-03, -7.648784e-03, 
        -6.666498e-03, -5.689759e-03, -4.719994e-03, -3.757357e-03, -2.804373e-03, -1.859909e-03, -9.256437e-04, -2.013541e-17
    },
    {
        0.000000e+00, 1.507455e-01, 1.207007e-01, 9.171221e-02, 6.179052e-02, 3.365747e-02, 1.332257e-02, -2.375174e-03, 
        -1.649751e-02, -2.877970e-02, -3.811668e-02, -4.527494e-02, -5.011530e-02, -5.315954e-02, -5.572485e-02, -5.786769e-02, 
        -5.867673e-02, -5.705429e-02, -5.326458e-02, -4.860399e-02, -4.401021e-02, -3.995093e-02, -3.576162e-02, -3.153032e-02, 
        -2.650787e-02, -2.115455e-02, -1.580126e-02, -1.088052e-02, -6.794520e-03, -3.031228e-03, 7.699568e-04, 4.962568e-03, 
        8.936494e-03, 1.270241e-02, 1.686004e-02, 2.118074e-02, 2.557811e-02, 2.970777e-02, 3.409884e-02, 3.867944e-02, 
        4.342115e-02, 4.733632e-02, 5.110933e-02, 5.475782e-02, 5.758125e-02, 5.941473e-02, 6.072315e-02, 6.154284e-02, 
        6.129292e-02, 6.065663e-02, 5.912191e-02, 5.703610e-02, 5.489733e-02, 5.218830e-02, 4.934198e-02, 4.593269e-02, 
        4.193563e-02, 3.756416e-02, 3.264069e-02, 2.791803e-02, 2.265526e-02, 1.703786e-02, 1.112656e-02, 5.029451e-03, 
        -8.870066e-04, -6.429659e-03, -1.209488e-02, -1.795477e-02, -2.389911e-02, -2.949066e-02, -3.445773e-02, -3.937190e-02, 
        -4.413430e-02, -4.874777e-02, -5.267152e-02, -5.633061e-02, -5.965567e-02, -6.268070e-02, -6.514167e-02, -6.739588e-02, 
        -6.926296e-02, -7.003671e-02, -7.108702e-02, -7.180639e-02, -7.177871e-02, -7.139445e-02, -7.100258e-02, -7.006411e-02, 
        -6.861398e-02, -6.684054e-02, -6.465894e-02, -6.219882e-02, -5.890686e-02, -5.571682e-02, -5.216535e-02, -4.807539e-02, 
        -4.392300e-02, -3.944633e-02, -3.483985e-02, -3.003443e-02, -2.491446e-02, -1.948053e-02, -1.414013e-02, -8.453057e-03, 
        -2.650175e-03, 2.943184e-03, 8.558212e-03, 1.401360e-02, 1.961674e-02, 2.476884e-02, 2.968361e-02, 3.432279e-02, 
        3.893293e-02, 4.288325e-02, 4.688597e-02, 5.040807e-02, 5.363671e-02, 5.646457e-02, 5.877778e-02, 6.074455e-02, 
        6.207494e-02, 6.318869e-02, 6.393809e-02, 6.410510e-02, 6.427001e-02, 6.421797e-02, 6.396191e-02, 6.349514e-02, 
        6.263445e-02, 6.143830e-02, 6.012655e-02, 5.865263e-02, 5.692138e-02, 5.520538e-02, 5.372955e-02, 5.203802e-02, 
        5.041504e-02, 4.895197e-02, 4.693858e-02, 4.490112e-02, 4.297358e-02, 4.090379e-02, 3.889292e-02, 3.695421e-02, 
        3.483684e-02, 3.238920e-02, 2.995791e-02, 2.748953e-02, 2.486904e-02, 2.199338e-02, 1.923505e-02, 1.644573e-02, 
        1.343826e-02, 1.006541e-02, 6.671872e-03, 3.071788e-03, -1.568400e-04, -3.428808e-03, -6.719075e-03, -1.009985e-02, 
        -1.350290e-02, -1.699157e-02, -2.015547e-02, -2.321278e-02, -2.628419e-02, -2.925985e-02, -3.237629e-02, -3.517825e-02, 
        -3.779963e-02, -4.038895e-02, -4.299644e-02, -4.581103e-02, -4.802005e-02, -5.008550e-02, -5.221627e-02, -5.448365e-02, 
        -5.639040e-02, -5.801093e-02, -5.961495e-02, -6.118521e-02, -6.217152e-02, -6.314675e-02, -6.408047e-02, -6.443810e-02, 
        -6.448580e-02, -6.461142e-02, -6.419266e-02, -6.336891e-02, -6.252112e-02, -6.082518e-02, -5.911583e-02, -5.709120e-02, 
        -5.450672e-02, -5.171306e-02, -4.822821e-02, -4.474604e-02, -4.082495e-02, -3.690032e-02, -3.247575e-02, -2.803771e-02, 
        -2.339857e-02, -1.884295e-02, -1.422596e-02, -9.614114e-03, -5.041266e-03, -4.446784e-04, 3.949733e-03, 8.251256e-03, 
        1.222173e-02, 1.612896e-02, 1.961673e-02, 2.321542e-02, 2.630637e-02, 2.935242e-02, 3.198098e-02, 3.446069e-02, 
        3.681257e-02, 3.883299e-02, 4.089755e-02, 4.232988e-02, 4.373358e-02, 4.497128e-02, 4.589218e-02, 4.695297e-02, 
        4.769053e-02, 4.810847e-02, 4.864462e-02, 4.883958e-02, 4.899831e-02, 4.918537e-02, 4.913879e-02, 4.890685e-02, 
        4.866293e-02, 4.829285e-02, 4.774044e-02, 4.718648e-02, 4.667514e-02, 4.581629e-02, 4.492544e-02, 4.411025e-02, 
        4.306915e-02, 4.196890e-02, 4.090352e-02, 3.991363e-02, 3.866343e-02, 3.735754e-02, 3.601406e-02, 3.474194e-02, 
        3.316444e-02, 3.158613e-02, 3.010587e-02, 2.853235e-02, 2.672790e-02, 2.493368e-02, 2.317910e-02, 2.145095e-02, 
        1.956620e-02, 1.767439e-02, 1.581577e-02, 1.394612e-02, 1.201088e-02, 1.008587e-02, 8.221889e-03, 6.389277e-03, 
        4.629087e-03, 2.666268e-03, 7.295213e-04, -1.079513e-03, -2.819868e-03, -4.586865e-03, -6.284481e-03, -7.956978e-03, 
        -9.595485e-03, -1.106582e-02, -1.253188e-02, -1.394419e-02, -1.520342e-02, -1.642875e-02, -1.756485e-02, -1.876650e-02, 
        -1.982803e-02, -2.077306e-02, -2.160304e-02, -2.234521e-02, -2.313108e-02, -2.382931e-02, -2.448592e-02, -2.504228e-02, 
        -2.553018e-02, -2.606546e-02, -2.660545e-02, -2.706670e-02, -2.741439e-02, -2.767432e-02, -2.801954e-02, -2.831347e-02, 
        -2.861195e-02, -2.887123e-02, -2.905667e-02, -2.911488e-02, -2.920747e-02, -2.926428e-02, -2.934518e-02, -2.945847e-02, 
        -2.944722e-02, -2.939849e-02, -2.937279e-02, -2.928941e-02, -2.914309e-02, -2.899382e-02, -2.901849e-02, -2.898158e-02, 
        -2.890917e-02, -2.873517e-02, -2.853805e-02, -2.831494e-02, -2.809450e-02, -2.802744e-02, -2.796440e-02, -2.783785e-02, 
        -2.766449e-02, -2.748631e-02, -2.720883e-02, -2.697823e-02, -2.691683e-02, -2.689137e-02, -2.686864e-02, -2.682734e-02, 
        -2.667790e-02, -2.654989e-02, -2.640144e-02, -2.616097e-02, -2.600905e-02, -2.580411e-02, -2.551551e-02, -2.526653e-02, 
        -2.508277e-02, -2.477066e-02, -2.440104e-02, -2.401076e-02, -2.361477e-02, -2.314140e-02, -2.265344e-02, -2.208807e-02, 
        -2.146436e-02, -2.084392e-02, -2.004937e-02, -1.918571e-02, -1.835898e-02, -1.768489e-02, -1.696431e-02, -1.613480e-02, 
        -1.519525e-02, -1.418729e-02, -1.319371e-02, -1.223807e-02, -1.129099e-02, -1.027270e-02, -9.288805e-03, -8.308808e-03, 
        -7.309813e-03, -6.267727e-03, -5.206320e-03, -4.083539e-03, -3.084312e-03, -2.086245e-03, -1.050033e-03, 4.998547e-05, 
        1.066313e-03, 2.021410e-03, 3.017337e-03, 4.026281e-03, 5.044716e-03, 6.124675e-03, 7.125214e-03, 8.115053e-03, 
        9.037940e-03, 1.002129e-02, 1.095755e-02, 1.192147e-02, 1.291961e-02, 1.395327e-02, 1.501197e-02, 1.597175e-02, 
        1.683475e-02, 1.765669e-02, 1.855457e-02, 1.946130e-02, 2.038072e-02, 2.122765e-02, 2.213247e-02, 2.296523e-02, 
        2.381279e-02, 2.462380e-02, 2.540353e-02, 2.615253e-02, 2.682719e-02, 2.750333e-02, 2.822515e-02, 2.887570e-02, 
        2.940916e-02, 2.993575e-02, 3.051099e-02, 3.111243e-02, 3.161910e-02, 3.209820e-02, 3.253353e-02, 3.279163e-02, 
        3.307110e-02, 3.333781e-02, 3.358343e-02, 3.384312e-02, 3.408320e-02, 3.431763e-02, 3.453719e-02, 3.471092e-02, 
        3.476957e-02, 3.482974e-02, 3.488886e-02, 3.487440e-02, 3.482113e-02, 3.477919e-02, 3.474281e-02, 3.470721e-02, 
        3.455085e-02, 3.435650e-02, 3.414889e-02, 3.386373e-02, 3.353237e-02, 3.318449e-02, 3.281683e-02, 3.238839e-02, 
        3.186102e-02, 3.127100e-02, 3.061074e-02, 2.993174e-02, 2.919960e-02, 2.844869e-02, 2.771817e-02, 2.695492e-02, 
        2.618520e-02, 2.542574e-02, 2.466143e-02, 2.379740e-02, 2.295379e-02, 2.204366e-02, 2.113896e-02, 2.022909e-02, 
        1.933885e-02, 1.845589e-02, 1.759167e-02, 1.672857e-02, 1.583019e-02, 1.481065e-02, 1.376404e-02, 1.279384e-02, 
        1.186478e-02, 1.094294e-02, 1.001004e-02, 9.012174e-03, 8.082517e-03, 7.169932e-03, 6.256297e-03, 5.244143e-03, 
        4.210156e-03, 3.173984e-03, 2.151424e-03, 1.129065e-03, 7.185728e-05, -9.537177e-04, -1.978641e-03, -2.996118e-03, 
        -3.948044e-03, -4.944983e-03, -6.060654e-03, -7.173239e-03, -8.263116e-03, -9.291362e-03, -1.028351e-02, -1.125762e-02, 
        -1.220515e-02, -1.312572e-02, -1.404869e-02, -1.498295e-02, -1.589178e-02, -1.687253e-02, -1.787364e-02, -1.883711e-02, 
        -1.978343e-02, -2.068520e-02, -2.153163e-02, -2.236686e-02, -2.320237e-02, -2.401354e-02, -2.479700e-02, -2.548873e-02, 
        -2.615126e-02, -2.685416e-02, -2.757484e-02, -2.829151e-02, -2.896108e-02, -2.956827e-02, -3.011979e-02, -3.064041e-02, 
        -3.115683e-02, -3.168951e-02, -3.216816e-02, -3.260952e-02, -3.298530e-02, -3.333476e-02, -3.373130e-02, -3.407092e-02, 
        -3.435486e-02, -3.461992e-02, -3.475103e-02, -3.483662e-02, -3.491736e-02, -3.496680e-02, -3.497289e-02, -3.496535e-02, 
        -3.493678e-02, -3.491557e-02, -3.492174e-02, -3.493524e-02, -3.496301e-02, -3.497345e-02, -3.487417e-02, -3.473014e-02, 
        -3.451913e-02, -3.426984e-02, -3.402763e-02, -3.377191e-02, -3.348873e-02, -3.317374e-02, -3.282796e-02, -3.245477e-02, 
        -3.208893e-02, -3.170444e-02, -3.129554e-02, -3.091144e-02, -3.055035e-02, -3.014052e-02, -2.970653e-02, -2.924689e-02, 
        -2.877350e-02, -2.827706e-02, -2.772609e-02, -2.714500e-02, -2.645422e-02, -2.567297e-02, -2.487842e-02, -2.406899e-02, 
        -2.328278e-02, -2.252632e-02, -2.179114e-02, -2.107730e-02, -2.035702e-02, -1.959177e-02, -1.879094e-02, -1.792391e-02, 
        -1.702358e-02, -1.612899e-02, -1.524853e-02, -1.435823e-02, -1.344119e-02, -1.249419e-02, -1.152394e-02, -1.054476e-02, 
        -9.584596e-03, -8.620266e-03, -7.604014e-03, -6.535475e-03, -5.434275e-03, -4.338105e-03, -3.207219e-03, -2.091769e-03, 
        -9.785595e-04, 1.698964e-04, 1.262579e-03, 2.340592e-03, 3.446993e-03, 4.561649e-03, 5.696582e-03, 6.855829e-03, 
        8.053227e-03, 9.199333e-03, 1.032752e-02, 1.140867e-02, 1.234371e-02, 1.330707e-02, 1.428309e-02, 1.526401e-02, 
        1.625672e-02, 1.723995e-02, 1.825994e-02, 1.929007e-02, 2.033209e-02, 2.140126e-02, 2.221302e-02, 2.293528e-02, 
        2.359944e-02, 2.426900e-02, 2.493809e-02, 2.555341e-02, 2.617221e-02, 2.682864e-02, 2.750845e-02, 2.817458e-02, 
        2.884649e-02, 2.954125e-02, 3.009369e-02, 3.042899e-02, 3.079001e-02, 3.116041e-02, 3.155298e-02, 3.195887e-02, 
        3.237526e-02, 3.281738e-02, 3.328424e-02, 3.380567e-02, 3.435142e-02, 3.490482e-02, 3.530946e-02, 3.568174e-02, 
        3.608347e-02, 3.641704e-02, 3.647525e-02, 3.654460e-02, 3.662770e-02, 3.670958e-02, 3.682143e-02, 3.695622e-02, 
        3.711807e-02, 3.727668e-02, 3.743557e-02, 3.758555e-02, 3.771415e-02, 3.785510e-02, 3.801110e-02, 3.816554e-02, 
        3.827483e-02, 3.837108e-02, 3.843883e-02, 3.841973e-02, 3.841019e-02, 3.830109e-02, 3.801662e-02, 3.771771e-02, 
        3.738390e-02, 3.702411e-02, 3.661568e-02, 3.618336e-02, 3.575402e-02, 3.532903e-02, 3.489354e-02, 3.446403e-02, 
        3.404808e-02, 3.361245e-02, 3.317832e-02, 3.275886e-02, 3.234730e-02, 3.196426e-02, 3.157168e-02, 3.114090e-02, 
        3.064398e-02, 3.008919e-02, 2.957976e-02, 2.907225e-02, 2.856804e-02, 2.805755e-02, 2.752631e-02, 2.694661e-02, 
        2.612992e-02, 2.530734e-02, 2.452570e-02, 2.372374e-02, 2.292920e-02, 2.213835e-02, 2.135455e-02, 2.052935e-02, 
        1.970821e-02, 1.890817e-02, 1.813941e-02, 1.741154e-02, 1.669089e-02, 1.597296e-02, 1.528024e-02, 1.456072e-02, 
        1.383897e-02, 1.317138e-02, 1.255615e-02, 1.196954e-02, 1.140584e-02, 1.083495e-02, 1.026730e-02, 9.715342e-03, 
        9.196408e-03, 8.719287e-03, 8.180861e-03, 7.649272e-03, 7.120772e-03, 6.596352e-03, 6.082540e-03, 5.603839e-03, 
        5.140709e-03, 4.708265e-03, 4.294533e-03, 3.880151e-03, 3.321137e-03, 2.743674e-03, 2.157028e-03, 1.568430e-03, 
        9.792462e-04, 3.859348e-04, -2.069354e-04, -8.029176e-04, -1.412156e-03, -1.998078e-03, -2.569707e-03, -3.126044e-03, 
        -3.671261e-03, -4.197133e-03, -4.703609e-03, -5.169262e-03, -5.612812e-03, -6.041460e-03, -6.525097e-03, -7.024805e-03, 
        -7.508268e-03, -7.966510e-03, -8.410419e-03, -8.841791e-03, -9.272304e-03, -9.702981e-03, -1.012522e-02, -1.054875e-02, 
        -1.096610e-02, -1.136526e-02, -1.176295e-02, -1.218526e-02, -1.261010e-02, -1.304709e-02, -1.343999e-02, -1.380190e-02, 
        -1.415720e-02, -1.450148e-02, -1.481715e-02, -1.511271e-02, -1.539437e-02, -1.567916e-02, -1.594710e-02, -1.621766e-02, 
        -1.649069e-02, -1.677384e-02, -1.706291e-02, -1.735078e-02, -1.778201e-02, -1.827519e-02, -1.877452e-02, -1.926988e-02, 
        -1.975993e-02, -2.023905e-02, -2.070333e-02, -2.115199e-02, -2.159680e-02, -2.201455e-02, -2.245062e-02, -2.293145e-02, 
        -2.341226e-02, -2.390530e-02, -2.439455e-02, -2.489573e-02, -2.538210e-02, -2.585069e-02, -2.631210e-02, -2.676656e-02, 
        -2.721564e-02, -2.764699e-02, -2.804987e-02, -2.843253e-02, -2.879446e-02, -2.914842e-02, -2.948872e-02, -2.981655e-02, 
        -3.011373e-02, -3.039260e-02, -3.063766e-02, -3.084019e-02, -3.105178e-02, -3.124592e-02, -3.140965e-02, -3.152888e-02, 
        -3.162988e-02, -3.171277e-02, -3.178741e-02, -3.185242e-02, -3.188986e-02, -3.193901e-02, -3.197612e-02, -3.201158e-02, 
        -3.203229e-02, -3.204133e-02, -3.204453e-02, -3.203612e-02, -3.199997e-02, -3.197920e-02, -3.193995e-02, -3.188434e-02, 
        -3.180956e-02, -3.173601e-02, -3.166591e-02, -3.159756e-02, -3.152534e-02, -3.142901e-02, -3.133299e-02, -3.122326e-02, 
        -3.109537e-02, -3.094049e-02, -3.076455e-02, -3.057683e-02, -3.036474e-02, -3.013159e-02, -2.995462e-02, -2.975585e-02, 
        -2.954206e-02, -2.931729e-02, -2.907734e-02, -2.882566e-02, -2.856925e-02, -2.836073e-02, -2.815740e-02, -2.792169e-02, 
        -2.764472e-02, -2.734216e-02, -2.703747e-02, -2.672691e-02, -2.640106e-02, -2.605751e-02, -2.571478e-02, -2.537412e-02, 
        -2.502843e-02, -2.465196e-02, -2.426497e-02, -2.389776e-02, -2.352990e-02, -2.313097e-02, -2.272339e-02, -2.230516e-02, 
        -2.188208e-02, -2.143910e-02, -2.100070e-02, -2.057200e-02, -2.014454e-02, -1.970938e-02, -1.927460e-02, -1.884924e-02, 
        -1.841703e-02, -1.796012e-02, -1.749917e-02, -1.699678e-02, -1.652079e-02, -1.605484e-02, -1.558911e-02, -1.516947e-02, 
        -1.474583e-02, -1.431388e-02, -1.387555e-02, -1.343679e-02, -1.297288e-02, -1.245838e-02, -1.196012e-02, -1.151270e-02, 
        -1.106075e-02, -1.060709e-02, -1.015104e-02, -9.682566e-03, -9.212216e-03, -8.731728e-03, -8.208278e-03, -7.643232e-03, 
        -7.087355e-03, -6.578601e-03, -6.048960e-03, -5.477234e-03, -4.897702e-03, -4.299889e-03, -3.662780e-03, -3.001082e-03, 
        -2.297310e-03, -1.584170e-03, -8.516245e-04, -1.952714e-04, 4.833759e-04, 1.183689e-03, 1.901444e-03, 2.626945e-03, 
        3.356069e-03, 4.121274e-03, 4.924593e-03, 5.701597e-03, 6.462709e-03, 7.150691e-03, 7.854372e-03, 8.555725e-03, 
        9.263497e-03, 9.983510e-03, 1.070692e-02, 1.144402e-02, 1.217113e-02, 1.284441e-02, 1.353203e-02, 1.415597e-02, 
        1.473274e-02, 1.531914e-02, 1.592020e-02, 1.653393e-02, 1.716095e-02, 1.779465e-02, 1.842422e-02, 1.903823e-02, 
        1.967016e-02, 2.027178e-02, 2.078086e-02, 2.131783e-02, 2.188602e-02, 2.246889e-02, 2.306096e-02, 2.366982e-02, 
        2.425589e-02, 2.485314e-02, 2.546142e-02, 2.606522e-02, 2.651181e-02, 2.697275e-02, 2.744145e-02, 2.792537e-02, 
        2.838825e-02, 2.886726e-02, 2.933813e-02, 2.978398e-02, 3.023047e-02, 3.068084e-02, 3.097320e-02, 3.124851e-02, 
        3.151979e-02, 3.179491e-02, 3.208364e-02, 3.238522e-02, 3.270960e-02, 3.304227e-02, 3.338576e-02, 3.376693e-02, 
        3.403786e-02, 3.424990e-02, 3.448659e-02, 3.475116e-02, 3.505739e-02, 3.539451e-02, 3.575027e-02, 3.611933e-02, 
        3.649073e-02, 3.688173e-02, 3.719951e-02, 3.738622e-02, 3.759411e-02, 3.784242e-02, 3.810564e-02, 3.838660e-02, 
        3.868005e-02, 3.898292e-02, 3.924536e-02, 3.950280e-02, 3.972558e-02, 3.973594e-02, 3.975274e-02, 3.978129e-02, 
        3.981270e-02, 3.984607e-02, 3.987135e-02, 3.986742e-02, 3.983345e-02, 3.977924e-02, 3.972687e-02, 3.939447e-02, 
        3.903504e-02, 3.868324e-02, 3.833726e-02, 3.799708e-02, 3.766243e-02, 3.733177e-02, 3.699997e-02, 3.663235e-02, 
        3.624944e-02, 3.564720e-02, 3.496800e-02, 3.429306e-02, 3.361142e-02, 3.290150e-02, 3.219412e-02, 3.149192e-02, 
        3.079306e-02, 3.008957e-02, 2.930615e-02, 2.835259e-02, 2.721108e-02, 2.606995e-02, 2.493019e-02, 2.379139e-02, 
        2.265073e-02, 2.153695e-02, 2.038014e-02, 1.920723e-02, 1.802808e-02, 1.663728e-02, 1.495627e-02, 1.327881e-02, 
        1.160589e-02, 9.935733e-03, 8.270407e-03, 6.608634e-03, 4.951101e-03, 3.297583e-03, 1.647433e-03, -6.357235e-17
    },
    {
        0.000000e+00, 4.681131e-02, 3.448546e-02, 2.787317e-02, 9.077404e-03, -1.252344e-02, -1.981374e-02, -2.022446e-02, 
        -1.977085e-02, -1.690704e-02, -1.085543e-02, -3.675414e-03, 3.000490e-03, 6.717629e-03, 5.669027e-03, 2.072485e-03, 
        -5.012936e-04, -1.170948e-03, -2.397314e-04, -7.352893e-05, -1.721719e-03, -5.648954e-03, -8.984094e-03, -1.196890e-02, 
        -1.556017e-02, -1.883280e-02, -2.117636e-02, -2.178414e-02, -2.045620e-02, -1.774205e-02, -1.351744e-02, -8.063788e-03, 
        -1.939619e-03, 4.290677e-03, 1.058171e-02, 1.655834e-02, 2.145392e-02, 2.635716e-02, 3.162410e-02, 3.651302e-02, 
        4.110853e-02, 4.530762e-02, 4.825638e-02, 5.006986e-02, 5.095183e-02, 5.020408e-02, 4.785951e-02, 4.428271e-02, 
        3.991452e-02, 3.477011e-02, 2.873794e-02, 2.134703e-02, 1.273631e-02, 3.663851e-03, -6.029854e-03, -1.575807e-02, 
        -2.491389e-02, -3.361578e-02, -4.141220e-02, -4.798057e-02, -5.285234e-02, -5.599161e-02, -5.772764e-02, -5.855767e-02, 
        -5.854105e-02, -5.801915e-02, -5.695607e-02, -5.533240e-02, -5.323196e-02, -5.069518e-02, -4.795854e-02, -4.473753e-02, 
        -4.117124e-02, -3.724427e-02, -3.321496e-02, -2.912680e-02, -2.482910e-02, -2.033936e-02, -1.569094e-02, -1.062176e-02, 
        -5.170073e-03, 3.437857e-04, 5.848103e-03, 1.125088e-02, 1.656631e-02, 2.169067e-02, 2.633630e-02, 3.086059e-02, 
        3.502068e-02, 3.873037e-02, 4.183588e-02, 4.451947e-02, 4.678120e-02, 4.859437e-02, 4.970678e-02, 5.023995e-02, 
        5.038301e-02, 4.983822e-02, 4.855151e-02, 4.718407e-02, 4.576427e-02, 4.390175e-02, 4.157071e-02, 3.880250e-02, 
        3.576013e-02, 3.229183e-02, 2.847238e-02, 2.440965e-02, 2.012665e-02, 1.559214e-02, 1.074161e-02, 5.951684e-03, 
        1.151384e-03, -3.585619e-03, -8.887757e-03, -1.384535e-02, -1.852657e-02, -2.288487e-02, -2.716061e-02, -3.125988e-02, 
        -3.473129e-02, -3.773333e-02, -4.020690e-02, -4.265230e-02, -4.493803e-02, -4.666470e-02, -4.805004e-02, -4.896643e-02, 
        -4.989895e-02, -5.036629e-02, -5.021192e-02, -4.963145e-02, -4.856864e-02, -4.738171e-02, -4.572717e-02, -4.331828e-02, 
        -4.020556e-02, -3.658248e-02, -3.273865e-02, -2.844455e-02, -2.379064e-02, -1.869489e-02, -1.358453e-02, -8.443050e-03, 
        -3.364645e-03, 1.860701e-03, 7.123102e-03, 1.238238e-02, 1.757942e-02, 2.234447e-02, 2.642148e-02, 3.020768e-02, 
        3.373309e-02, 3.683327e-02, 3.981301e-02, 4.254222e-02, 4.469727e-02, 4.665348e-02, 4.855023e-02, 5.049459e-02, 
        5.250306e-02, 5.419849e-02, 5.525308e-02, 5.609343e-02, 5.680514e-02, 5.758628e-02, 5.837509e-02, 5.863108e-02, 
        5.836131e-02, 5.798997e-02, 5.741974e-02, 5.695278e-02, 5.583392e-02, 5.458059e-02, 5.316203e-02, 5.172504e-02, 
        4.972813e-02, 4.758693e-02, 4.553395e-02, 4.351386e-02, 4.071082e-02, 3.784024e-02, 3.500919e-02, 3.172657e-02, 
        2.824462e-02, 2.487347e-02, 2.106127e-02, 1.698121e-02, 1.299358e-02, 8.379497e-03, 3.935987e-03, -6.608164e-04, 
        -5.529345e-03, -1.019073e-02, -1.535437e-02, -2.023319e-02, -2.546930e-02, -3.047127e-02, -3.571817e-02, -4.071906e-02, 
        -4.573477e-02, -5.051431e-02, -5.516725e-02, -5.948015e-02, -6.348838e-02, -6.729707e-02, -7.065566e-02, -7.376872e-02, 
        -7.635738e-02, -7.874548e-02, -8.043464e-02, -8.203416e-02, -8.298526e-02, -8.381424e-02, -8.403609e-02, -8.399522e-02, 
        -8.362292e-02, -8.280955e-02, -8.193264e-02, -8.045636e-02, -7.892246e-02, -7.713694e-02, -7.494625e-02, -7.286040e-02, 
        -7.045504e-02, -6.778598e-02, -6.515759e-02, -6.216961e-02, -5.912094e-02, -5.610186e-02, -5.278094e-02, -4.936363e-02, 
        -4.598159e-02, -4.242170e-02, -3.876846e-02, -3.519103e-02, -3.159487e-02, -2.771813e-02, -2.388344e-02, -2.015988e-02, 
        -1.638076e-02, -1.255269e-02, -8.791596e-03, -5.133212e-03, -1.274546e-03, 2.479637e-03, 6.032230e-03, 9.420152e-03, 
        1.288947e-02, 1.619042e-02, 1.927861e-02, 2.216957e-02, 2.501808e-02, 2.770244e-02, 3.024260e-02, 3.260544e-02, 
        3.508378e-02, 3.740506e-02, 3.952824e-02, 4.145633e-02, 4.331550e-02, 4.507710e-02, 4.664530e-02, 4.804002e-02, 
        4.922756e-02, 5.037657e-02, 5.138086e-02, 5.223361e-02, 5.295540e-02, 5.367978e-02, 5.436264e-02, 5.489276e-02, 
        5.520533e-02, 5.531303e-02, 5.539436e-02, 5.543604e-02, 5.532854e-02, 5.507301e-02, 5.464520e-02, 5.415568e-02, 
        5.354191e-02, 5.279835e-02, 5.193196e-02, 5.097215e-02, 5.002294e-02, 4.900709e-02, 4.786388e-02, 4.653563e-02, 
        4.507678e-02, 4.355459e-02, 4.199924e-02, 4.037431e-02, 3.864483e-02, 3.679183e-02, 3.490835e-02, 3.300271e-02, 
        3.090309e-02, 2.876163e-02, 2.660743e-02, 2.444052e-02, 2.240324e-02, 2.038992e-02, 1.831627e-02, 1.609441e-02, 
        1.387756e-02, 1.174006e-02, 9.751399e-03, 7.766189e-03, 5.844567e-03, 3.982798e-03, 2.117273e-03, 3.151913e-04, 
        -1.360628e-03, -2.939121e-03, -4.451436e-03, -5.858844e-03, -7.168514e-03, -8.499262e-03, -9.705243e-03, -1.081210e-02, 
        -1.189051e-02, -1.291298e-02, -1.387140e-02, -1.465477e-02, -1.550300e-02, -1.637613e-02, -1.719256e-02, -1.803177e-02, 
        -1.888324e-02, -1.968082e-02, -2.042611e-02, -2.116963e-02, -2.207949e-02, -2.299855e-02, -2.388119e-02, -2.467255e-02, 
        -2.531417e-02, -2.592913e-02, -2.644008e-02, -2.682552e-02, -2.718591e-02, -2.754750e-02, -2.765186e-02, -2.765523e-02, 
        -2.752406e-02, -2.726710e-02, -2.688072e-02, -2.640137e-02, -2.570285e-02, -2.515455e-02, -2.455274e-02, -2.390108e-02, 
        -2.319054e-02, -2.239094e-02, -2.154277e-02, -2.055979e-02, -1.945161e-02, -1.830144e-02, -1.730625e-02, -1.635173e-02, 
        -1.538551e-02, -1.442422e-02, -1.337190e-02, -1.235285e-02, -1.128799e-02, -1.006423e-02, -8.741049e-03, -7.472599e-03, 
        -6.401690e-03, -5.221186e-03, -3.989571e-03, -2.756025e-03, -1.520108e-03, -2.012723e-04, 1.237720e-03, 2.688091e-03, 
        4.202303e-03, 5.734698e-03, 7.020855e-03, 8.318617e-03, 9.573227e-03, 1.089393e-02, 1.223390e-02, 1.362433e-02, 
        1.507834e-02, 1.652139e-02, 1.792093e-02, 1.924950e-02, 2.042536e-02, 2.143528e-02, 2.239416e-02, 2.339400e-02, 
        2.438456e-02, 2.532135e-02, 2.616545e-02, 2.698230e-02, 2.770054e-02, 2.833202e-02, 2.894373e-02, 2.958028e-02, 
        2.991290e-02, 3.012259e-02, 3.028503e-02, 3.033722e-02, 3.030585e-02, 3.019283e-02, 3.007496e-02, 3.003720e-02, 
        2.999292e-02, 2.996758e-02, 2.993461e-02, 2.980423e-02, 2.955674e-02, 2.930377e-02, 2.897844e-02, 2.865083e-02, 
        2.848003e-02, 2.830830e-02, 2.813526e-02, 2.792500e-02, 2.766062e-02, 2.730710e-02, 2.693337e-02, 2.659270e-02, 
        2.614234e-02, 2.564160e-02, 2.515083e-02, 2.461619e-02, 2.395083e-02, 2.308640e-02, 2.211561e-02, 2.107071e-02, 
        1.996197e-02, 1.886544e-02, 1.785440e-02, 1.676589e-02, 1.567677e-02, 1.454009e-02, 1.342230e-02, 1.226866e-02, 
        1.104708e-02, 9.824566e-03, 8.595248e-03, 7.422231e-03, 6.177077e-03, 4.908154e-03, 3.637750e-03, 2.406062e-03, 
        1.150715e-03, -1.269682e-04, -1.485081e-03, -2.869399e-03, -4.230416e-03, -5.489638e-03, -6.794520e-03, -8.186402e-03, 
        -9.585763e-03, -1.098258e-02, -1.231384e-02, -1.370129e-02, -1.516476e-02, -1.662410e-02, -1.813693e-02, -1.958581e-02, 
        -2.108534e-02, -2.263624e-02, -2.422710e-02, -2.581051e-02, -2.737335e-02, -2.892406e-02, -3.039598e-02, -3.186074e-02, 
        -3.332416e-02, -3.478130e-02, -3.614510e-02, -3.751609e-02, -3.885534e-02, -4.018989e-02, -4.152692e-02, -4.283544e-02, 
        -4.410973e-02, -4.532101e-02, -4.642662e-02, -4.745378e-02, -4.839035e-02, -4.923504e-02, -4.999617e-02, -5.073088e-02, 
        -5.137246e-02, -5.192545e-02, -5.248106e-02, -5.302770e-02, -5.353326e-02, -5.397520e-02, -5.435785e-02, -5.470494e-02, 
        -5.502279e-02, -5.518973e-02, -5.527213e-02, -5.528006e-02, -5.526554e-02, -5.516498e-02, -5.497562e-02, -5.476407e-02, 
        -5.450516e-02, -5.418434e-02, -5.384248e-02, -5.348794e-02, -5.309449e-02, -5.261004e-02, -5.191361e-02, -5.118071e-02, 
        -5.048657e-02, -4.977398e-02, -4.888613e-02, -4.794007e-02, -4.695792e-02, -4.597193e-02, -4.497811e-02, -4.396739e-02, 
        -4.297801e-02, -4.197763e-02, -4.098473e-02, -3.996192e-02, -3.891484e-02, -3.788558e-02, -3.667123e-02, -3.541216e-02, 
        -3.419372e-02, -3.303450e-02, -3.191623e-02, -3.079176e-02, -2.967039e-02, -2.858740e-02, -2.754537e-02, -2.657461e-02, 
        -2.561912e-02, -2.452975e-02, -2.326314e-02, -2.199472e-02, -2.072116e-02, -1.944397e-02, -1.814401e-02, -1.681423e-02, 
        -1.546728e-02, -1.406499e-02, -1.265142e-02, -1.128272e-02, -9.781957e-03, -8.171467e-03, -6.557077e-03, -4.975358e-03, 
        -3.376001e-03, -1.754926e-03, -1.140562e-04, 1.509670e-03, 3.113203e-03, 4.681309e-03, 6.329369e-03, 8.145204e-03, 
        9.908321e-03, 1.162172e-02, 1.324871e-02, 1.482348e-02, 1.635826e-02, 1.785242e-02, 1.928703e-02, 2.069971e-02, 
        2.223961e-02, 2.387469e-02, 2.546514e-02, 2.701919e-02, 2.850560e-02, 2.993761e-02, 3.138086e-02, 3.283292e-02, 
        3.426880e-02, 3.571753e-02, 3.709773e-02, 3.850995e-02, 3.991266e-02, 4.131552e-02, 4.272713e-02, 4.417610e-02, 
        4.567907e-02, 4.713312e-02, 4.858780e-02, 4.994958e-02, 5.099983e-02, 5.202061e-02, 5.303529e-02, 5.402985e-02, 
        5.501470e-02, 5.601541e-02, 5.697689e-02, 5.788245e-02, 5.878455e-02, 5.960431e-02, 5.993314e-02, 6.004867e-02, 
        6.017560e-02, 6.025680e-02, 6.028332e-02, 6.036600e-02, 6.047204e-02, 6.054307e-02, 6.061440e-02, 6.066773e-02, 
        6.067408e-02, 6.064750e-02, 6.029579e-02, 5.948691e-02, 5.871027e-02, 5.798872e-02, 5.730511e-02, 5.662379e-02, 
        5.596847e-02, 5.535131e-02, 5.478482e-02, 5.418309e-02, 5.354282e-02, 5.290137e-02, 5.234137e-02, 5.183970e-02, 
        5.136903e-02, 5.066515e-02, 4.934083e-02, 4.801558e-02, 4.669566e-02, 4.537542e-02, 4.400899e-02, 4.263368e-02, 
        4.124278e-02, 3.983301e-02, 3.841035e-02, 3.697916e-02, 3.549100e-02, 3.397292e-02, 3.245419e-02, 3.094846e-02, 
        2.942530e-02, 2.787906e-02, 2.636620e-02, 2.494316e-02, 2.354671e-02, 2.191724e-02, 1.997041e-02, 1.806422e-02, 
        1.621102e-02, 1.446106e-02, 1.291231e-02, 1.143140e-02, 1.001174e-02, 8.622862e-03, 7.266216e-03, 5.909518e-03, 
        4.587831e-03, 3.242925e-03, 1.913073e-03, 6.163586e-04, -5.650576e-04, -1.612659e-03, -2.639918e-03, -3.609561e-03, 
        -4.506571e-03, -5.356361e-03, -6.214368e-03, -7.096796e-03, -8.025984e-03, -9.000385e-03, -1.000258e-02, -1.097974e-02, 
        -1.221216e-02, -1.331860e-02, -1.444947e-02, -1.561844e-02, -1.687950e-02, -1.814989e-02, -1.941037e-02, -2.055378e-02, 
        -2.170066e-02, -2.283110e-02, -2.395691e-02, -2.509341e-02, -2.618455e-02, -2.723229e-02, -2.801128e-02, -2.853404e-02, 
        -2.895595e-02, -2.932786e-02, -2.968468e-02, -2.999819e-02, -3.028305e-02, -3.054678e-02, -3.077979e-02, -3.100213e-02, 
        -3.122261e-02, -3.151470e-02, -3.172709e-02, -3.190430e-02, -3.204822e-02, -3.217858e-02, -3.222945e-02, -3.218066e-02, 
        -3.191587e-02, -3.156741e-02, -3.123162e-02, -3.102675e-02, -3.111331e-02, -3.125889e-02, -3.142315e-02, -3.160778e-02, 
        -3.177897e-02, -3.192405e-02, -3.203485e-02, -3.212855e-02, -3.218406e-02, -3.220427e-02, -3.218557e-02, -3.216532e-02, 
        -3.215987e-02, -3.217860e-02, -3.200768e-02, -3.171497e-02, -3.139800e-02, -3.107310e-02, -3.069901e-02, -3.017591e-02, 
        -2.955571e-02, -2.893570e-02, -2.830517e-02, -2.767579e-02, -2.702912e-02, -2.638762e-02, -2.575170e-02, -2.514445e-02, 
        -2.455085e-02, -2.401040e-02, -2.345075e-02, -2.286864e-02, -2.230433e-02, -2.174911e-02, -2.118840e-02, -2.062891e-02, 
        -2.006041e-02, -1.948396e-02, -1.885741e-02, -1.815325e-02, -1.744793e-02, -1.671256e-02, -1.596254e-02, -1.518492e-02, 
        -1.440409e-02, -1.360366e-02, -1.276341e-02, -1.192953e-02, -1.131855e-02, -1.075737e-02, -1.002369e-02, -9.305102e-03, 
        -8.616256e-03, -7.950955e-03, -7.311456e-03, -6.678224e-03, -6.041242e-03, -5.385214e-03, -4.747592e-03, -4.080719e-03, 
        -3.454269e-03, -2.879744e-03, -2.343424e-03, -1.879314e-03, -1.446905e-03, -1.032713e-03, -6.463152e-04, -2.763472e-04, 
        1.004613e-04, 5.282436e-04, 9.870480e-04, 1.455067e-03, 1.935803e-03, 2.427716e-03, 2.917809e-03, 3.426500e-03, 
        3.931207e-03, 4.440017e-03, 4.950393e-03, 5.456166e-03, 5.947855e-03, 6.439354e-03, 6.939765e-03, 7.429828e-03, 
        7.900502e-03, 8.348521e-03, 8.763991e-03, 9.170761e-03, 9.576973e-03, 9.994175e-03, 1.037298e-02, 1.083292e-02, 
        1.126701e-02, 1.165610e-02, 1.200309e-02, 1.231259e-02, 1.256936e-02, 1.277863e-02, 1.294129e-02, 1.304473e-02, 
        1.310577e-02, 1.313875e-02, 1.315785e-02, 1.315361e-02, 1.313038e-02, 1.307920e-02, 1.295946e-02, 1.283788e-02, 
        1.271356e-02, 1.268945e-02, 1.272269e-02, 1.280713e-02, 1.290529e-02, 1.295629e-02, 1.288772e-02, 1.280596e-02, 
        1.269083e-02, 1.255395e-02, 1.239690e-02, 1.222712e-02, 1.205917e-02, 1.194490e-02, 1.185235e-02, 1.175429e-02, 
        1.162861e-02, 1.147165e-02, 1.129526e-02, 1.107945e-02, 1.081822e-02, 1.051647e-02, 1.019372e-02, 9.856525e-03, 
        9.509824e-03, 9.129752e-03, 8.744128e-03, 8.371728e-03, 8.023015e-03, 7.691966e-03, 7.391482e-03, 7.127639e-03, 
        6.903494e-03, 6.689683e-03, 6.493887e-03, 6.357181e-03, 6.257253e-03, 6.180738e-03, 6.219192e-03, 6.258491e-03, 
        6.317628e-03, 6.409330e-03, 6.524055e-03, 6.616680e-03, 6.709712e-03, 6.805812e-03, 6.894513e-03, 7.026513e-03, 
        7.145610e-03, 7.248054e-03, 7.341368e-03, 7.414935e-03, 7.410269e-03, 7.413855e-03, 7.402326e-03, 7.374186e-03, 
        7.320299e-03, 7.248887e-03, 7.150171e-03, 7.035966e-03, 6.912878e-03, 6.768290e-03, 6.593352e-03, 6.397631e-03, 
        6.208808e-03, 6.046527e-03, 5.895229e-03, 5.753246e-03, 5.636468e-03, 5.535089e-03, 5.430815e-03, 5.316514e-03, 
        5.203072e-03, 5.076031e-03, 4.947930e-03, 4.858131e-03, 4.762396e-03, 4.663724e-03, 4.563925e-03, 4.459467e-03, 
        4.345069e-03, 4.217650e-03, 4.068917e-03, 3.934200e-03, 3.804770e-03, 3.696061e-03, 3.609597e-03, 3.501340e-03, 
        3.383188e-03, 3.251549e-03, 3.140899e-03, 3.032227e-03, 2.881046e-03, 2.619986e-03, 2.350280e-03, 2.104944e-03, 
        1.873185e-03, 1.630876e-03, 1.369334e-03, 1.105577e-03, 8.510127e-04, 5.952370e-04, 3.385831e-04, 7.613545e-05, 
        -1.933397e-04, -4.570994e-04, -6.873165e-04, -9.421861e-04, -1.240337e-03, -1.545867e-03, -1.854179e-03, -2.132665e-03, 
        -2.397875e-03, -2.687182e-03, -3.000602e-03, -3.331590e-03, -3.607402e-03, -3.912631e-03, -4.228442e-03, -4.552572e-03, 
        -4.847655e-03, -5.128624e-03, -5.387860e-03, -5.629705e-03, -5.868755e-03, -6.102562e-03, -6.256287e-03, -6.404354e-03, 
        -6.538640e-03, -6.654996e-03, -6.759347e-03, -6.844263e-03, -6.931231e-03, -7.024069e-03, -7.124276e-03, -7.238232e-03, 
        -7.307320e-03, -7.359717e-03, -7.417052e-03, -7.477403e-03, -7.537770e-03, -7.577184e-03, -7.619149e-03, -7.685883e-03, 
        -7.766367e-03, -7.867068e-03, -7.951303e-03, -7.998447e-03, -8.066885e-03, -8.163488e-03, -8.280622e-03, -8.423789e-03, 
        -8.594658e-03, -8.810135e-03, -9.059259e-03, -9.338173e-03, -9.639212e-03, -9.877399e-03, -1.011859e-02, -1.036583e-02, 
        -1.061711e-02, -1.086555e-02, -1.110966e-02, -1.132911e-02, -1.150975e-02, -1.168918e-02, -1.185982e-02, -1.189004e-02, 
        -1.188348e-02, -1.184896e-02, -1.178765e-02, -1.170955e-02, -1.162512e-02, -1.154200e-02, -1.144819e-02, -1.134496e-02, 
        -1.125208e-02, -1.107638e-02, -1.085459e-02, -1.063878e-02, -1.042280e-02, -1.018981e-02, -9.957078e-03, -9.724109e-03, 
        -9.506621e-03, -9.299984e-03, -9.105711e-03, -8.882068e-03, -8.624317e-03, -8.406313e-03, -8.219835e-03, -8.026353e-03, 
        -7.835124e-03, -7.643890e-03, -7.422261e-03, -7.180429e-03, -6.900958e-03, -6.493511e-03, -5.934865e-03, -5.357188e-03, 
        -4.757886e-03, -4.144439e-03, -3.509118e-03, -2.855865e-03, -2.177809e-03, -1.479250e-03, -7.512174e-04, -1.016566e-17
    },
    {
        0.000000e+00, 9.337579e-02, 8.054700e-02, 6.256344e-02, 3.666294e-02, 8.144030e-03, -1.059384e-02, -2.663954e-02, 
        -3.935114e-02, -4.824101e-02, -5.237458e-02, -5.184092e-02, -4.726596e-02, -4.032197e-02, -3.534554e-02, -3.300175e-02, 
        -3.222506e-02, -3.109026e-02, -2.817204e-02, -2.516272e-02, -2.076238e-02, -1.440327e-02, -6.912883e-03, 1.941417e-03, 
        1.157612e-02, 2.126827e-02, 3.039692e-02, 3.774032e-02, 4.245606e-02, 4.444934e-02, 4.460454e-02, 4.343607e-02, 
        4.107697e-02, 3.760178e-02, 3.386266e-02, 2.996247e-02, 2.615551e-02, 2.180640e-02, 1.697367e-02, 1.177458e-02, 
        6.244900e-03, 5.070997e-04, -5.046233e-03, -1.037382e-02, -1.509954e-02, -1.909733e-02, -2.221596e-02, -2.381300e-02, 
        -2.486913e-02, -2.565004e-02, -2.611091e-02, -2.613241e-02, -2.550826e-02, -2.404751e-02, -2.226260e-02, -2.009056e-02, 
        -1.753187e-02, -1.486596e-02, -1.213645e-02, -9.042711e-03, -5.815066e-03, -2.922695e-03, 6.328107e-05, 3.130231e-03, 
        6.150614e-03, 9.359206e-03, 1.243885e-02, 1.544246e-02, 1.827674e-02, 2.096147e-02, 2.357433e-02, 2.594095e-02, 
        2.801248e-02, 2.966496e-02, 3.101287e-02, 3.224910e-02, 3.311050e-02, 3.338042e-02, 3.301061e-02, 3.168125e-02, 
        2.988833e-02, 2.758315e-02, 2.447003e-02, 2.050972e-02, 1.628483e-02, 1.147938e-02, 6.069612e-03, 4.319296e-04, 
        -5.188078e-03, -1.082200e-02, -1.641430e-02, -2.201648e-02, -2.710552e-02, -3.195749e-02, -3.649277e-02, -4.012370e-02, 
        -4.320136e-02, -4.551116e-02, -4.667907e-02, -4.724751e-02, -4.716803e-02, -4.660996e-02, -4.558051e-02, -4.405821e-02, 
        -4.220763e-02, -3.997135e-02, -3.723699e-02, -3.432818e-02, -3.108256e-02, -2.769270e-02, -2.381317e-02, -1.993181e-02, 
        -1.601529e-02, -1.215511e-02, -7.974437e-03, -3.711301e-03, 5.040333e-04, 4.524147e-03, 8.259167e-03, 1.191973e-02, 
        1.532632e-02, 1.848794e-02, 2.125973e-02, 2.375283e-02, 2.629281e-02, 2.892457e-02, 3.134179e-02, 3.340889e-02, 
        3.515550e-02, 3.656751e-02, 3.787512e-02, 3.893071e-02, 3.961539e-02, 3.981786e-02, 3.990924e-02, 3.939848e-02, 
        3.859373e-02, 3.751452e-02, 3.588884e-02, 3.405013e-02, 3.197804e-02, 2.972880e-02, 2.759941e-02, 2.546564e-02, 
        2.339918e-02, 2.093479e-02, 1.839426e-02, 1.594785e-02, 1.330018e-02, 1.090515e-02, 8.845472e-03, 6.767977e-03, 
        4.753374e-03, 2.727377e-03, 9.251994e-04, -1.073709e-03, -2.956624e-03, -4.900178e-03, -7.063213e-03, -9.318317e-03, 
        -1.150778e-02, -1.378903e-02, -1.568296e-02, -1.766367e-02, -1.971595e-02, -2.159365e-02, -2.352753e-02, -2.530709e-02, 
        -2.683944e-02, -2.855413e-02, -3.043345e-02, -3.230536e-02, -3.363735e-02, -3.500978e-02, -3.638806e-02, -3.793768e-02, 
        -3.901289e-02, -3.971353e-02, -4.039272e-02, -4.122470e-02, -4.127548e-02, -4.140999e-02, -4.167933e-02, -4.128496e-02, 
        -4.069180e-02, -4.036119e-02, -3.946187e-02, -3.827728e-02, -3.708067e-02, -3.509397e-02, -3.299071e-02, -3.067334e-02, 
        -2.770009e-02, -2.467655e-02, -2.094021e-02, -1.728392e-02, -1.298017e-02, -8.677546e-03, -4.119176e-03, 3.914347e-04, 
        4.987787e-03, 9.541484e-03, 1.406785e-02, 1.869771e-02, 2.319567e-02, 2.750408e-02, 3.160078e-02, 3.547548e-02, 
        3.906471e-02, 4.249579e-02, 4.547527e-02, 4.836086e-02, 5.055178e-02, 5.268234e-02, 5.420818e-02, 5.567213e-02, 
        5.675608e-02, 5.751439e-02, 5.827158e-02, 5.826996e-02, 5.820207e-02, 5.781884e-02, 5.704479e-02, 5.616921e-02, 
        5.498818e-02, 5.350800e-02, 5.202346e-02, 5.009597e-02, 4.806783e-02, 4.599423e-02, 4.364423e-02, 4.113364e-02, 
        3.866013e-02, 3.609612e-02, 3.335584e-02, 3.066471e-02, 2.806307e-02, 2.520214e-02, 2.247422e-02, 1.991643e-02, 
        1.722360e-02, 1.451583e-02, 1.193606e-02, 9.520540e-03, 6.953139e-03, 4.558911e-03, 2.287653e-03, 2.052085e-04, 
        -2.048454e-03, -4.205553e-03, -6.180249e-03, -8.077998e-03, -9.991269e-03, -1.182419e-02, -1.354970e-02, -1.522469e-02, 
        -1.701507e-02, -1.876009e-02, -2.043974e-02, -2.204278e-02, -2.365799e-02, -2.528322e-02, -2.681548e-02, -2.829378e-02, 
        -2.978555e-02, -3.129256e-02, -3.265782e-02, -3.381694e-02, -3.482830e-02, -3.577425e-02, -3.655835e-02, -3.712273e-02, 
        -3.751840e-02, -3.772809e-02, -3.777965e-02, -3.771771e-02, -3.748561e-02, -3.714185e-02, -3.671973e-02, -3.638967e-02, 
        -3.592087e-02, -3.524906e-02, -3.453363e-02, -3.367208e-02, -3.282128e-02, -3.192228e-02, -3.094828e-02, -2.996387e-02, 
        -2.895276e-02, -2.798544e-02, -2.699783e-02, -2.598904e-02, -2.505665e-02, -2.406740e-02, -2.317733e-02, -2.238234e-02, 
        -2.157464e-02, -2.079896e-02, -1.995379e-02, -1.901615e-02, -1.809261e-02, -1.710185e-02, -1.611102e-02, -1.509913e-02, 
        -1.404581e-02, -1.302115e-02, -1.200123e-02, -1.104464e-02, -9.955152e-03, -8.730752e-03, -7.477647e-03, -6.247350e-03, 
        -5.104490e-03, -3.869194e-03, -2.607954e-03, -1.385911e-03, -1.641177e-04, 9.854357e-04, 2.060707e-03, 3.154591e-03, 
        4.187122e-03, 5.179847e-03, 6.077607e-03, 6.777136e-03, 7.424068e-03, 8.014570e-03, 8.583143e-03, 9.165609e-03, 
        9.725707e-03, 1.012095e-02, 1.055190e-02, 1.093842e-02, 1.132863e-02, 1.166970e-02, 1.200443e-02, 1.232981e-02, 
        1.260928e-02, 1.288811e-02, 1.319934e-02, 1.342834e-02, 1.364720e-02, 1.389613e-02, 1.403256e-02, 1.419949e-02, 
        1.436808e-02, 1.450918e-02, 1.462757e-02, 1.474620e-02, 1.484067e-02, 1.488036e-02, 1.488585e-02, 1.485840e-02, 
        1.482058e-02, 1.478127e-02, 1.469202e-02, 1.440663e-02, 1.410424e-02, 1.374990e-02, 1.343710e-02, 1.311401e-02, 
        1.275624e-02, 1.228563e-02, 1.161193e-02, 1.090090e-02, 1.007068e-02, 9.343667e-03, 8.678377e-03, 8.033764e-03, 
        7.440297e-03, 6.761212e-03, 6.026261e-03, 5.338306e-03, 4.729615e-03, 4.308365e-03, 3.823137e-03, 3.389233e-03, 
        2.861451e-03, 2.335036e-03, 1.829381e-03, 1.309549e-03, 7.877082e-04, 3.416839e-04, -1.170449e-04, -6.148117e-04, 
        -1.155524e-03, -1.688575e-03, -2.237354e-03, -2.823631e-03, -3.452555e-03, -4.052090e-03, -4.615889e-03, -5.217007e-03, 
        -5.784518e-03, -6.373255e-03, -7.041528e-03, -7.614589e-03, -8.177274e-03, -8.712735e-03, -9.077423e-03, -9.461381e-03, 
        -9.785105e-03, -1.004130e-02, -1.020022e-02, -1.029365e-02, -1.033404e-02, -1.023723e-02, -9.933239e-03, -9.599172e-03, 
        -9.315980e-03, -9.005085e-03, -8.640219e-03, -8.236887e-03, -7.734047e-03, -7.192223e-03, -6.675314e-03, -6.214613e-03, 
        -5.635462e-03, -4.983051e-03, -4.247794e-03, -3.557568e-03, -2.866000e-03, -2.102296e-03, -1.298655e-03, -4.638119e-04, 
        3.587447e-04, 1.159503e-03, 2.088161e-03, 2.984260e-03, 3.770795e-03, 4.504367e-03, 5.192513e-03, 5.833605e-03, 
        6.431160e-03, 6.987493e-03, 7.534671e-03, 8.059066e-03, 8.699260e-03, 9.342952e-03, 9.986501e-03, 1.066711e-02, 
        1.132237e-02, 1.199838e-02, 1.260538e-02, 1.306040e-02, 1.348763e-02, 1.382594e-02, 1.414093e-02, 1.451043e-02, 
        1.484075e-02, 1.509472e-02, 1.529071e-02, 1.548732e-02, 1.561509e-02, 1.552972e-02, 1.534550e-02, 1.506998e-02, 
        1.477325e-02, 1.440358e-02, 1.408849e-02, 1.366535e-02, 1.314723e-02, 1.253122e-02, 1.186016e-02, 1.103214e-02, 
        1.015124e-02, 9.193284e-03, 8.199210e-03, 7.176804e-03, 6.115569e-03, 5.071359e-03, 4.173115e-03, 3.299768e-03, 
        2.476470e-03, 1.603802e-03, 5.976111e-04, -4.051276e-04, -1.385052e-03, -2.347748e-03, -3.232117e-03, -4.088827e-03, 
        -4.867963e-03, -5.591498e-03, -6.131005e-03, -6.627589e-03, -7.027709e-03, -7.474431e-03, -7.923041e-03, -8.315020e-03, 
        -8.613571e-03, -8.908797e-03, -9.122805e-03, -9.299557e-03, -9.409668e-03, -9.468532e-03, -9.445102e-03, -9.323435e-03, 
        -9.165683e-03, -9.024795e-03, -8.870623e-03, -8.762402e-03, -8.682179e-03, -8.592505e-03, -8.453258e-03, -8.263731e-03, 
        -8.087003e-03, -7.912042e-03, -7.736209e-03, -7.521169e-03, -7.249127e-03, -6.965512e-03, -6.762702e-03, -6.515550e-03, 
        -6.258677e-03, -6.013257e-03, -5.770505e-03, -5.493118e-03, -5.255936e-03, -5.034171e-03, -4.816254e-03, -4.629203e-03, 
        -4.449963e-03, -4.336181e-03, -4.268466e-03, -4.292624e-03, -4.391840e-03, -4.533672e-03, -4.736679e-03, -4.994259e-03, 
        -5.228097e-03, -5.456070e-03, -5.734247e-03, -6.046107e-03, -6.378313e-03, -6.736148e-03, -7.135370e-03, -7.632638e-03, 
        -8.178881e-03, -8.785749e-03, -9.447093e-03, -1.012371e-02, -1.083444e-02, -1.148722e-02, -1.206124e-02, -1.252398e-02, 
        -1.285561e-02, -1.306116e-02, -1.313299e-02, -1.311074e-02, -1.299841e-02, -1.280540e-02, -1.251108e-02, -1.210224e-02, 
        -1.164463e-02, -1.119139e-02, -1.073385e-02, -1.022790e-02, -9.616787e-03, -8.907662e-03, -8.118590e-03, -7.282146e-03, 
        -6.398673e-03, -5.506171e-03, -4.597237e-03, -3.703928e-03, -2.829107e-03, -1.932029e-03, -9.461520e-04, 3.753457e-05, 
        9.556617e-04, 1.818693e-03, 2.702970e-03, 3.613503e-03, 4.494044e-03, 5.315143e-03, 6.157584e-03, 7.025176e-03, 
        7.949765e-03, 8.926645e-03, 9.954034e-03, 1.104090e-02, 1.217455e-02, 1.336638e-02, 1.460108e-02, 1.591158e-02, 
        1.728392e-02, 1.855519e-02, 1.975071e-02, 2.093432e-02, 2.211945e-02, 2.334418e-02, 2.458248e-02, 2.581480e-02, 
        2.701267e-02, 2.815575e-02, 2.922650e-02, 3.031731e-02, 3.140689e-02, 3.236835e-02, 3.330991e-02, 3.419446e-02, 
        3.499449e-02, 3.576448e-02, 3.644604e-02, 3.699905e-02, 3.747390e-02, 3.793745e-02, 3.840063e-02, 3.881495e-02, 
        3.915204e-02, 3.937664e-02, 3.961970e-02, 3.988549e-02, 4.010040e-02, 4.030473e-02, 4.051671e-02, 4.069752e-02, 
        4.085415e-02, 4.096553e-02, 4.102323e-02, 4.093267e-02, 4.072444e-02, 4.047253e-02, 4.008965e-02, 3.958233e-02, 
        3.899244e-02, 3.831920e-02, 3.756706e-02, 3.672373e-02, 3.578440e-02, 3.472734e-02, 3.354933e-02, 3.231533e-02, 
        3.099715e-02, 2.955171e-02, 2.798917e-02, 2.632923e-02, 2.458800e-02, 2.278689e-02, 2.090699e-02, 1.898109e-02, 
        1.697175e-02, 1.492934e-02, 1.280709e-02, 1.057119e-02, 8.312012e-03, 6.028641e-03, 3.704349e-03, 1.368374e-03, 
        -9.636291e-04, -3.221179e-03, -5.194699e-03, -7.076719e-03, -8.911461e-03, -1.071179e-02, -1.249202e-02, -1.425596e-02, 
        -1.601797e-02, -1.774000e-02, -1.939483e-02, -2.099249e-02, -2.239130e-02, -2.357917e-02, -2.473676e-02, -2.570602e-02, 
        -2.661983e-02, -2.753098e-02, -2.845196e-02, -2.930966e-02, -3.015494e-02, -3.104343e-02, -3.194993e-02, -3.290752e-02, 
        -3.361877e-02, -3.420379e-02, -3.480905e-02, -3.549334e-02, -3.625962e-02, -3.708951e-02, -3.796340e-02, -3.869558e-02, 
        -3.943532e-02, -4.019785e-02, -4.099971e-02, -4.181653e-02, -4.268911e-02, -4.358275e-02, -4.417339e-02, -4.450766e-02, 
        -4.493635e-02, -4.532211e-02, -4.566009e-02, -4.599084e-02, -4.632297e-02, -4.665601e-02, -4.703642e-02, -4.745356e-02, 
        -4.792047e-02, -4.839403e-02, -4.870564e-02, -4.899779e-02, -4.928525e-02, -4.959662e-02, -4.987861e-02, -5.007376e-02, 
        -4.998058e-02, -4.982173e-02, -4.968543e-02, -4.964423e-02, -4.963048e-02, -4.957751e-02, -4.953594e-02, -4.950427e-02, 
        -4.951134e-02, -4.955110e-02, -4.957089e-02, -4.955461e-02, -4.950445e-02, -4.943094e-02, -4.931222e-02, -4.917423e-02, 
        -4.901950e-02, -4.879597e-02, -4.833046e-02, -4.779963e-02, -4.726231e-02, -4.670867e-02, -4.615839e-02, -4.538542e-02, 
        -4.447395e-02, -4.353573e-02, -4.258400e-02, -4.164180e-02, -4.072973e-02, -3.983688e-02, -3.899708e-02, -3.819590e-02, 
        -3.741894e-02, -3.659510e-02, -3.583894e-02, -3.516010e-02, -3.451904e-02, -3.388106e-02, -3.331450e-02, -3.278897e-02, 
        -3.228370e-02, -3.175822e-02, -3.114787e-02, -3.043007e-02, -2.970818e-02, -2.892343e-02, -2.808010e-02, -2.716863e-02, 
        -2.620993e-02, -2.517996e-02, -2.401188e-02, -2.280922e-02, -2.159224e-02, -2.035964e-02, -1.885166e-02, -1.732302e-02, 
        -1.577494e-02, -1.418543e-02, -1.255596e-02, -1.090489e-02, -9.229455e-03, -7.559030e-03, -5.879610e-03, -4.270280e-03, 
        -2.700607e-03, -1.172344e-03, 3.035896e-04, 1.853425e-03, 3.386585e-03, 4.889981e-03, 6.408420e-03, 7.933404e-03, 
        9.464477e-03, 1.105332e-02, 1.270783e-02, 1.437190e-02, 1.603634e-02, 1.770604e-02, 1.940208e-02, 2.107708e-02, 
        2.273079e-02, 2.435622e-02, 2.595365e-02, 2.754913e-02, 2.907069e-02, 3.053007e-02, 3.192599e-02, 3.322939e-02, 
        3.446752e-02, 3.562821e-02, 3.670819e-02, 3.778943e-02, 3.881524e-02, 3.972464e-02, 4.057232e-02, 4.154276e-02, 
        4.249255e-02, 4.333301e-02, 4.407401e-02, 4.471403e-02, 4.528109e-02, 4.575084e-02, 4.615970e-02, 4.653299e-02, 
        4.687983e-02, 4.719266e-02, 4.746699e-02, 4.770137e-02, 4.790248e-02, 4.812787e-02, 4.840149e-02, 4.868858e-02, 
        4.899610e-02, 4.939016e-02, 4.982599e-02, 5.028005e-02, 5.069078e-02, 5.100873e-02, 5.125548e-02, 5.143315e-02, 
        5.156982e-02, 5.165233e-02, 5.166331e-02, 5.161557e-02, 5.149329e-02, 5.126921e-02, 5.100872e-02, 5.071450e-02, 
        5.038752e-02, 5.001719e-02, 4.958009e-02, 4.906007e-02, 4.846992e-02, 4.778778e-02, 4.703981e-02, 4.624614e-02, 
        4.547481e-02, 4.470176e-02, 4.394577e-02, 4.321158e-02, 4.248757e-02, 4.180063e-02, 4.113622e-02, 4.051122e-02, 
        3.993146e-02, 3.939281e-02, 3.898187e-02, 3.868661e-02, 3.841846e-02, 3.816450e-02, 3.805861e-02, 3.797960e-02, 
        3.790789e-02, 3.782917e-02, 3.770065e-02, 3.755250e-02, 3.744995e-02, 3.735331e-02, 3.723614e-02, 3.703699e-02, 
        3.679838e-02, 3.650905e-02, 3.614840e-02, 3.571775e-02, 3.526075e-02, 3.483020e-02, 3.442124e-02, 3.409020e-02, 
        3.371572e-02, 3.329526e-02, 3.284643e-02, 3.236931e-02, 3.185238e-02, 3.129653e-02, 3.073311e-02, 3.016913e-02, 
        2.962126e-02, 2.916572e-02, 2.869517e-02, 2.825708e-02, 2.780402e-02, 2.732901e-02, 2.682298e-02, 2.626712e-02, 
        2.566305e-02, 2.499945e-02, 2.428835e-02, 2.372180e-02, 2.311835e-02, 2.246110e-02, 2.176425e-02, 2.104785e-02, 
        2.026311e-02, 1.941361e-02, 1.850893e-02, 1.753306e-02, 1.650973e-02, 1.561526e-02, 1.469558e-02, 1.372472e-02, 
        1.272100e-02, 1.170618e-02, 1.068380e-02, 9.679732e-03, 8.657886e-03, 7.651527e-03, 6.622926e-03, 5.681231e-03, 
        4.801839e-03, 3.873979e-03, 2.905915e-03, 1.896289e-03, 8.439484e-04, -2.630574e-04, -1.457973e-03, -2.676914e-03, 
        -3.964507e-03, -5.248744e-03, -6.417704e-03, -7.674556e-03, -9.026760e-03, -1.043564e-02, -1.191928e-02, -1.341661e-02, 
        -1.496836e-02, -1.657154e-02, -1.824421e-02, -1.995019e-02, -2.136379e-02, -2.283756e-02, -2.437045e-02, -2.595351e-02, 
        -2.755731e-02, -2.913923e-02, -3.074726e-02, -3.233955e-02, -3.391494e-02, -3.547784e-02, -3.672283e-02, -3.788117e-02, 
        -3.896046e-02, -3.997611e-02, -4.095671e-02, -4.191678e-02, -4.288731e-02, -4.386789e-02, -4.488039e-02, -4.593007e-02, 
        -4.677068e-02, -4.748846e-02, -4.825510e-02, -4.907650e-02, -4.996382e-02, -5.085780e-02, -5.178688e-02, -5.273962e-02, 
        -5.370904e-02, -5.475475e-02, -5.569017e-02, -5.640125e-02, -5.719480e-02, -5.804965e-02, -5.898991e-02, -6.001694e-02, 
        -6.113002e-02, -6.234433e-02, -6.349029e-02, -6.466185e-02, -6.581352e-02, -6.656992e-02, -6.738337e-02, -6.820166e-02, 
        -6.901374e-02, -6.981737e-02, -7.061313e-02, -7.141248e-02, -7.219523e-02, -7.291148e-02, -7.362366e-02, -7.366409e-02, 
        -7.354246e-02, -7.336383e-02, -7.313253e-02, -7.286657e-02, -7.258232e-02, -7.228563e-02, -7.201053e-02, -7.162843e-02, 
        -7.120132e-02, -7.033058e-02, -6.921598e-02, -6.808678e-02, -6.689582e-02, -6.550464e-02, -6.411324e-02, -6.274257e-02, 
        -6.137885e-02, -6.004870e-02, -5.860752e-02, -5.687383e-02, -5.481994e-02, -5.282281e-02, -5.087249e-02, -4.893320e-02, 
        -4.696397e-02, -4.496778e-02, -4.270812e-02, -4.032353e-02, -3.792581e-02, -3.517678e-02, -3.177874e-02, -2.838066e-02, 
        -2.497265e-02, -2.153301e-02, -1.805253e-02, -1.453713e-02, -1.097515e-02, -7.373098e-03, -3.712301e-03, 1.043064e-16
    },
    {
        0.000000e+00, -2.936768e-01, -2.015949e-01, -1.220699e-01, -5.804498e-02, -5.519080e-03, 3.533058e-02, 6.731481e-02, 
        9.339430e-02, 1.135458e-01, 1.279245e-01, 1.361439e-01, 1.374618e-01, 1.339212e-01, 1.257410e-01, 1.147397e-01, 
        1.013346e-01, 8.624868e-02, 6.842650e-02, 5.014312e-02, 3.088195e-02, 1.082044e-02, -8.111322e-03, -2.675255e-02, 
        -4.481194e-02, -6.168148e-02, -7.697756e-02, -8.950938e-02, -9.937547e-02, -1.063143e-01, -1.108610e-01, -1.130846e-01, 
        -1.137385e-01, -1.131079e-01, -1.103790e-01, -1.063397e-01, -1.017369e-01, -9.633422e-02, -8.980022e-02, -8.223918e-02, 
        -7.366070e-02, -6.456267e-02, -5.520378e-02, -4.477592e-02, -3.455095e-02, -2.477141e-02, -1.444846e-02, -5.134203e-03, 
        3.986291e-03, 1.358703e-02, 2.267270e-02, 3.193805e-02, 4.036000e-02, 4.722075e-02, 5.376914e-02, 5.927965e-02, 
        6.378966e-02, 6.772552e-02, 7.117900e-02, 7.475348e-02, 7.751042e-02, 7.978749e-02, 8.096580e-02, 8.104600e-02, 
        8.078002e-02, 7.946478e-02, 7.704405e-02, 7.472491e-02, 7.213703e-02, 6.846022e-02, 6.468923e-02, 6.072799e-02, 
        5.627498e-02, 5.105749e-02, 4.570861e-02, 4.156578e-02, 3.735507e-02, 3.269376e-02, 2.791665e-02, 2.311310e-02, 
        1.853042e-02, 1.394646e-02, 9.929325e-03, 6.043247e-03, 2.054935e-03, -1.841048e-03, -5.745632e-03, -1.016518e-02, 
        -1.330462e-02, -1.639998e-02, -1.984540e-02, -2.336333e-02, -2.704136e-02, -3.027176e-02, -3.354240e-02, -3.677033e-02, 
        -4.058446e-02, -4.484417e-02, -4.759682e-02, -5.084941e-02, -5.429818e-02, -5.774795e-02, -6.062470e-02, -6.250695e-02, 
        -6.459745e-02, -6.704703e-02, -6.857499e-02, -6.965070e-02, -7.074597e-02, -7.215960e-02, -7.211470e-02, -7.192852e-02, 
        -7.185874e-02, -7.066754e-02, -6.899936e-02, -6.736284e-02, -6.466165e-02, -6.164115e-02, -5.857296e-02, -5.436931e-02, 
        -5.010039e-02, -4.535452e-02, -3.988804e-02, -3.449618e-02, -2.836020e-02, -2.212858e-02, -1.547472e-02, -8.954541e-03, 
        -2.535012e-03, 4.128329e-03, 1.053920e-02, 1.711540e-02, 2.338534e-02, 2.924300e-02, 3.552279e-02, 4.168130e-02, 
        4.740185e-02, 5.301939e-02, 5.782601e-02, 6.240031e-02, 6.657105e-02, 7.024735e-02, 7.399709e-02, 7.689109e-02, 
        7.967738e-02, 8.158660e-02, 8.314143e-02, 8.457268e-02, 8.460744e-02, 8.478982e-02, 8.495112e-02, 8.412648e-02, 
        8.291248e-02, 8.144217e-02, 7.923192e-02, 7.676066e-02, 7.417096e-02, 7.119955e-02, 6.825478e-02, 6.457495e-02, 
        6.023473e-02, 5.575412e-02, 5.169566e-02, 4.693907e-02, 4.188323e-02, 3.685779e-02, 3.128173e-02, 2.569002e-02, 
        2.038308e-02, 1.483897e-02, 8.877003e-03, 2.688030e-03, -2.741197e-03, -8.290472e-03, -1.422623e-02, -2.001177e-02, 
        -2.543532e-02, -3.080157e-02, -3.633894e-02, -4.167820e-02, -4.606155e-02, -5.075269e-02, -5.540333e-02, -5.924835e-02, 
        -6.245726e-02, -6.600031e-02, -6.868650e-02, -7.084773e-02, -7.273671e-02, -7.389852e-02, -7.487878e-02, -7.524029e-02, 
        -7.474255e-02, -7.407999e-02, -7.259613e-02, -7.104394e-02, -6.841792e-02, -6.564814e-02, -6.238021e-02, -5.898563e-02, 
        -5.491038e-02, -5.065509e-02, -4.624402e-02, -4.203314e-02, -3.789913e-02, -3.363404e-02, -2.949475e-02, -2.549986e-02, 
        -2.178322e-02, -1.815861e-02, -1.504353e-02, -1.160480e-02, -8.864023e-03, -5.922494e-03, -3.420531e-03, -9.987396e-04, 
        1.230515e-03, 3.087195e-03, 5.056426e-03, 6.588084e-03, 8.046189e-03, 9.373976e-03, 1.040771e-02, 1.174158e-02, 
        1.282667e-02, 1.373572e-02, 1.468166e-02, 1.522524e-02, 1.584725e-02, 1.671026e-02, 1.724098e-02, 1.770623e-02, 
        1.801950e-02, 1.816463e-02, 1.827345e-02, 1.859983e-02, 1.898470e-02, 1.888698e-02, 1.894233e-02, 1.909027e-02, 
        1.901929e-02, 1.891470e-02, 1.885301e-02, 1.888202e-02, 1.860902e-02, 1.837130e-02, 1.826879e-02, 1.811034e-02, 
        1.765121e-02, 1.735133e-02, 1.716652e-02, 1.700131e-02, 1.656082e-02, 1.617117e-02, 1.570243e-02, 1.545613e-02, 
        1.510207e-02, 1.480608e-02, 1.441838e-02, 1.410778e-02, 1.377689e-02, 1.353286e-02, 1.343980e-02, 1.346744e-02, 
        1.345521e-02, 1.320992e-02, 1.306366e-02, 1.284477e-02, 1.271885e-02, 1.238879e-02, 1.200176e-02, 1.150655e-02, 
        1.109537e-02, 1.083720e-02, 1.031358e-02, 9.565111e-03, 8.801930e-03, 8.079452e-03, 7.271431e-03, 6.548226e-03, 
        6.026242e-03, 5.280815e-03, 4.592209e-03, 3.819072e-03, 2.880257e-03, 1.983226e-03, 1.140822e-03, 3.996909e-04, 
        -8.522758e-05, -6.494040e-04, -1.385765e-03, -2.153876e-03, -2.883218e-03, -3.819219e-03, -4.556017e-03, -5.188247e-03, 
        -5.653660e-03, -6.017518e-03, -6.380325e-03, -6.886456e-03, -7.514929e-03, -8.228115e-03, -8.785033e-03, -9.261756e-03, 
        -9.600018e-03, -9.878417e-03, -1.013148e-02, -1.031248e-02, -1.052252e-02, -1.085787e-02, -1.130320e-02, -1.173121e-02, 
        -1.204879e-02, -1.233928e-02, -1.245130e-02, -1.236927e-02, -1.221533e-02, -1.231641e-02, -1.271262e-02, -1.301432e-02, 
        -1.307163e-02, -1.291921e-02, -1.258418e-02, -1.223215e-02, -1.199725e-02, -1.178477e-02, -1.139687e-02, -1.105983e-02, 
        -1.071305e-02, -1.027994e-02, -9.744510e-03, -9.218520e-03, -8.857367e-03, -8.497478e-03, -7.943536e-03, -7.376532e-03, 
        -6.777619e-03, -6.115300e-03, -5.627660e-03, -5.233202e-03, -4.874954e-03, -4.407527e-03, -4.022906e-03, -3.526863e-03, 
        -3.070908e-03, -2.408599e-03, -1.908698e-03, -1.540239e-03, -1.271974e-03, -9.739660e-04, -5.589403e-04, -8.258355e-05, 
        5.415968e-04, 1.118237e-03, 1.569301e-03, 2.017566e-03, 2.445089e-03, 3.092905e-03, 3.609528e-03, 4.107092e-03, 
        4.654387e-03, 5.327793e-03, 5.773269e-03, 6.292694e-03, 6.977780e-03, 7.589159e-03, 8.230404e-03, 9.010027e-03, 
        9.713868e-03, 1.035827e-02, 1.075201e-02, 1.111499e-02, 1.140439e-02, 1.166118e-02, 1.198110e-02, 1.240441e-02, 
        1.278734e-02, 1.318441e-02, 1.349859e-02, 1.357861e-02, 1.365388e-02, 1.380309e-02, 1.403954e-02, 1.421868e-02, 
        1.418233e-02, 1.411611e-02, 1.416000e-02, 1.424730e-02, 1.409272e-02, 1.409251e-02, 1.419539e-02, 1.418713e-02, 
        1.421271e-02, 1.413665e-02, 1.403632e-02, 1.399163e-02, 1.399067e-02, 1.396313e-02, 1.371654e-02, 1.333010e-02, 
        1.293880e-02, 1.256885e-02, 1.224894e-02, 1.199725e-02, 1.175304e-02, 1.148493e-02, 1.119659e-02, 1.079604e-02, 
        1.015031e-02, 9.565293e-03, 9.019779e-03, 8.496733e-03, 8.051583e-03, 7.593983e-03, 7.200224e-03, 6.621290e-03, 
        5.890945e-03, 5.285071e-03, 4.630048e-03, 3.924453e-03, 3.315777e-03, 2.738697e-03, 2.238671e-03, 1.766340e-03, 
        1.187857e-03, 6.924309e-04, 2.707819e-04, -2.683250e-04, -8.025090e-04, -1.230826e-03, -1.817614e-03, -2.325287e-03, 
        -2.726808e-03, -3.156073e-03, -3.595694e-03, -3.975455e-03, -4.255906e-03, -4.455909e-03, -4.601438e-03, -4.721331e-03, 
        -4.926394e-03, -5.114726e-03, -5.453687e-03, -5.946068e-03, -6.374388e-03, -6.705998e-03, -6.979633e-03, -7.202080e-03, 
        -7.363996e-03, -7.512350e-03, -7.673691e-03, -7.799986e-03, -7.958815e-03, -8.296506e-03, -8.630880e-03, -9.057584e-03, 
        -9.380145e-03, -9.623917e-03, -9.764959e-03, -9.842687e-03, -9.841396e-03, -9.732894e-03, -9.586204e-03, -9.512504e-03, 
        -9.428227e-03, -9.238353e-03, -8.990154e-03, -8.803221e-03, -8.675061e-03, -8.784048e-03, -8.886083e-03, -8.957777e-03, 
        -8.930264e-03, -8.835069e-03, -8.864927e-03, -8.827950e-03, -8.760685e-03, -8.613337e-03, -8.493304e-03, -8.308700e-03, 
        -8.095132e-03, -7.842690e-03, -7.608056e-03, -7.521895e-03, -7.685235e-03, -7.866583e-03, -8.072438e-03, -8.285467e-03, 
        -8.510732e-03, -8.618677e-03, -8.687487e-03, -8.776203e-03, -8.794228e-03, -8.749712e-03, -8.656180e-03, -8.498556e-03, 
        -8.311921e-03, -8.176089e-03, -8.062720e-03, -8.131976e-03, -8.257884e-03, -8.278275e-03, -8.287908e-03, -8.303266e-03, 
        -8.259429e-03, -8.199778e-03, -8.113108e-03, -7.985273e-03, -7.836651e-03, -7.664828e-03, -7.661636e-03, -7.691789e-03, 
        -7.730387e-03, -7.757622e-03, -7.661235e-03, -7.541190e-03, -7.612368e-03, -7.805112e-03, -7.983787e-03, -8.132910e-03, 
        -8.288107e-03, -8.331002e-03, -8.281455e-03, -8.271275e-03, -8.264693e-03, -8.275415e-03, -8.236136e-03, -8.088917e-03, 
        -7.965373e-03, -7.827753e-03, -7.625517e-03, -7.388793e-03, -7.107577e-03, -6.794117e-03, -6.612974e-03, -6.477065e-03, 
        -6.242760e-03, -5.981966e-03, -5.764776e-03, -5.448761e-03, -5.044742e-03, -4.580647e-03, -4.150102e-03, -3.751930e-03, 
        -3.391930e-03, -3.000885e-03, -2.617643e-03, -2.231810e-03, -1.779358e-03, -1.298472e-03, -8.489956e-04, -4.351513e-04, 
        -1.041706e-04, 9.963910e-05, 1.274792e-04, 1.508024e-04, 1.850784e-04, 2.374298e-04, 3.362977e-04, 5.360913e-04, 
        7.358193e-04, 9.807954e-04, 1.232764e-03, 1.550029e-03, 1.955373e-03, 2.402896e-03, 2.840806e-03, 3.311111e-03, 
        3.769763e-03, 4.249881e-03, 4.768687e-03, 5.326996e-03, 5.924390e-03, 6.497732e-03, 6.930072e-03, 7.176890e-03, 
        7.361552e-03, 7.547584e-03, 7.707608e-03, 7.854872e-03, 8.028688e-03, 8.244274e-03, 8.449570e-03, 8.607686e-03, 
        8.791022e-03, 8.857488e-03, 8.906268e-03, 8.998656e-03, 9.000183e-03, 9.024599e-03, 9.095320e-03, 9.233406e-03, 
        9.386764e-03, 9.648181e-03, 9.944573e-03, 1.023837e-02, 1.053789e-02, 1.072921e-02, 1.068953e-02, 1.061984e-02, 
        1.061898e-02, 1.060712e-02, 1.067886e-02, 1.074872e-02, 1.085869e-02, 1.100744e-02, 1.115670e-02, 1.128521e-02, 
        1.140377e-02, 1.158208e-02, 1.163734e-02, 1.148630e-02, 1.132360e-02, 1.115935e-02, 1.098737e-02, 1.082004e-02, 
        1.068577e-02, 1.057331e-02, 1.046538e-02, 1.037540e-02, 1.021240e-02, 9.990249e-03, 9.671927e-03, 9.360159e-03, 
        9.098900e-03, 8.709533e-03, 8.166034e-03, 7.653474e-03, 7.140204e-03, 6.670485e-03, 6.258721e-03, 5.855775e-03, 
        5.526621e-03, 5.285678e-03, 5.136632e-03, 5.061678e-03, 5.032726e-03, 5.007274e-03, 5.036058e-03, 5.136255e-03, 
        5.269003e-03, 5.416654e-03, 5.604207e-03, 5.737814e-03, 5.906916e-03, 6.010574e-03, 5.934993e-03, 5.821985e-03, 
        5.680258e-03, 5.548788e-03, 5.412331e-03, 5.255356e-03, 5.126781e-03, 5.021458e-03, 4.969456e-03, 4.924835e-03, 
        4.848574e-03, 4.676046e-03, 4.482570e-03, 4.306927e-03, 4.143328e-03, 4.031528e-03, 3.957084e-03, 3.870657e-03, 
        3.743736e-03, 3.578103e-03, 3.399313e-03, 3.195686e-03, 3.003193e-03, 2.831148e-03, 2.651942e-03, 2.570384e-03, 
        2.414776e-03, 2.207626e-03, 2.028747e-03, 1.804843e-03, 1.437045e-03, 1.085409e-03, 7.768265e-04, 5.257356e-04, 
        2.832211e-04, 7.939926e-05, -8.185038e-05, -2.642934e-04, -3.893426e-04, -4.803039e-04, -5.583388e-04, -6.912243e-04, 
        -8.922830e-04, -1.103698e-03, -1.313241e-03, -1.539198e-03, -1.744262e-03, -1.898197e-03, -2.000999e-03, -2.089315e-03, 
        -2.188149e-03, -2.387017e-03, -2.549236e-03, -2.688044e-03, -2.787079e-03, -2.841859e-03, -2.930464e-03, -3.068594e-03, 
        -3.248214e-03, -3.437049e-03, -3.606165e-03, -3.747210e-03, -3.915627e-03, -4.083446e-03, -4.223562e-03, -4.342259e-03, 
        -4.500291e-03, -4.674399e-03, -4.828653e-03, -4.987135e-03, -5.080731e-03, -5.196160e-03, -5.313727e-03, -5.406999e-03, 
        -5.497271e-03, -5.611920e-03, -5.699726e-03, -5.774775e-03, -5.827751e-03, -5.860136e-03, -5.835875e-03, -5.812617e-03, 
        -5.794548e-03, -5.754962e-03, -5.696424e-03, -5.627999e-03, -5.525310e-03, -5.407427e-03, -5.340450e-03, -5.273184e-03, 
        -5.228324e-03, -5.194937e-03, -5.141431e-03, -5.166114e-03, -5.156070e-03, -5.140736e-03, -5.125548e-03, -5.113386e-03, 
        -5.027214e-03, -4.929130e-03, -4.829162e-03, -4.780176e-03, -4.767687e-03, -4.764598e-03, -4.805533e-03, -4.842525e-03, 
        -4.877159e-03, -4.903936e-03, -4.925239e-03, -4.910348e-03, -4.901364e-03, -4.865290e-03, -4.795979e-03, -4.682319e-03, 
        -4.548763e-03, -4.441000e-03, -4.335957e-03, -4.195996e-03, -4.026592e-03, -3.855323e-03, -3.679350e-03, -3.615158e-03, 
        -3.563790e-03, -3.507993e-03, -3.400825e-03, -3.313285e-03, -3.210967e-03, -3.132612e-03, -3.060857e-03, -2.992745e-03, 
        -2.928459e-03, -2.873708e-03, -2.890812e-03, -2.932178e-03, -3.007318e-03, -3.126197e-03, -3.259832e-03, -3.387900e-03, 
        -3.523348e-03, -3.674451e-03, -3.827247e-03, -3.969389e-03, -4.095850e-03, -4.199474e-03, -4.295658e-03, -4.376171e-03, 
        -4.451044e-03, -4.484057e-03, -4.466344e-03, -4.433656e-03, -4.410333e-03, -4.413169e-03, -4.379511e-03, -4.319999e-03, 
        -4.251073e-03, -4.117601e-03, -3.926462e-03, -3.756393e-03, -3.564936e-03, -3.376022e-03, -3.148865e-03, -2.893821e-03, 
        -2.669323e-03, -2.422560e-03, -2.149523e-03, -1.850924e-03, -1.550038e-03, -1.295857e-03, -1.137224e-03, -1.010534e-03, 
        -9.196924e-04, -8.734266e-04, -8.723178e-04, -8.866582e-04, -9.112268e-04, -9.921129e-04, -1.099246e-03, -1.222787e-03, 
        -1.362810e-03, -1.491410e-03, -1.596758e-03, -1.705382e-03, -1.814625e-03, -1.943649e-03, -2.043062e-03, -2.134246e-03, 
        -2.252688e-03, -2.374122e-03, -2.431223e-03, -2.439711e-03, -2.415068e-03, -2.330210e-03, -2.182512e-03, -1.979074e-03, 
        -1.746538e-03, -1.541191e-03, -1.402165e-03, -1.279310e-03, -1.192885e-03, -1.118719e-03, -1.065302e-03, -1.025728e-03, 
        -9.944830e-04, -9.799140e-04, -9.764293e-04, -9.627254e-04, -9.227947e-04, -8.766555e-04, -8.536206e-04, -8.899056e-04, 
        -9.019655e-04, -9.178436e-04, -9.004027e-04, -8.456344e-04, -7.583629e-04, -6.377012e-04, -4.864260e-04, -3.816787e-04, 
        -2.541675e-04, -9.779120e-05, 1.130500e-04, 3.961810e-04, 6.761234e-04, 9.783680e-04, 1.278447e-03, 1.638380e-03, 
        2.012629e-03, 2.421799e-03, 2.842232e-03, 3.264205e-03, 3.729394e-03, 4.231021e-03, 4.765229e-03, 5.282722e-03, 
        5.788358e-03, 6.289456e-03, 6.749198e-03, 7.024100e-03, 7.207942e-03, 7.334569e-03, 7.455426e-03, 7.560493e-03, 
        7.665876e-03, 7.734223e-03, 7.781479e-03, 7.816486e-03, 7.813068e-03, 7.785428e-03, 7.735542e-03, 7.681516e-03, 
        7.602725e-03, 7.524671e-03, 7.445705e-03, 7.304258e-03, 7.137539e-03, 6.980915e-03, 6.814667e-03, 6.628111e-03, 
        6.451876e-03, 6.272940e-03, 6.108483e-03, 5.931899e-03, 5.721106e-03, 5.449523e-03, 5.169551e-03, 4.928307e-03, 
        4.714848e-03, 4.510251e-03, 4.303939e-03, 4.094503e-03, 3.880572e-03, 3.621729e-03, 3.359829e-03, 3.141626e-03, 
        2.931855e-03, 2.740337e-03, 2.588937e-03, 2.431991e-03, 2.313353e-03, 2.210978e-03, 2.126756e-03, 1.990951e-03, 
        1.822069e-03, 1.731355e-03, 1.663912e-03, 1.608721e-03, 1.581127e-03, 1.560562e-03, 1.561507e-03, 1.570561e-03, 
        1.602764e-03, 1.614179e-03, 1.595199e-03, 1.595560e-03, 1.595194e-03, 1.592725e-03, 1.629488e-03, 1.653593e-03, 
        1.649492e-03, 1.604501e-03, 1.520757e-03, 1.413421e-03, 1.295971e-03, 1.182100e-03, 1.073205e-03, 9.057418e-04, 
        7.393787e-04, 5.609143e-04, 3.536729e-04, 1.109452e-04, -1.645280e-04, -4.681189e-04, -7.657539e-04, -1.086370e-03, 
        -1.387928e-03, -1.696252e-03, -1.997915e-03, -2.281441e-03, -2.574554e-03, -2.926901e-03, -3.256042e-03, -3.573890e-03, 
        -3.882270e-03, -4.177003e-03, -4.394570e-03, -4.577888e-03, -4.678746e-03, -4.708638e-03, -4.794129e-03, -4.880412e-03, 
        -4.958695e-03, -5.042706e-03, -5.125962e-03, -5.227551e-03, -5.354214e-03, -5.447163e-03, -5.527750e-03, -5.604583e-03, 
        -5.724183e-03, -5.882734e-03, -6.076476e-03, -6.297282e-03, -6.535573e-03, -6.785053e-03, -6.984168e-03, -7.067299e-03, 
        -7.118797e-03, -7.146493e-03, -7.278332e-03, -7.427251e-03, -7.589382e-03, -7.779550e-03, -7.965826e-03, -8.132341e-03, 
        -8.298978e-03, -8.408957e-03, -8.277868e-03, -8.085832e-03, -7.844389e-03, -7.576261e-03, -7.286521e-03, -6.935731e-03, 
        -6.579726e-03, -6.345295e-03, -6.136374e-03, -5.949192e-03, -5.728288e-03, -5.154815e-03, -4.592246e-03, -4.013779e-03, 
        -3.421577e-03, -2.848376e-03, -2.301668e-03, -1.778515e-03, -1.287604e-03, -8.249034e-04, -3.974324e-04, 6.021932e-18
    },
    {
        0.000000e+00, -1.419539e-01, -1.036124e-01, -6.792405e-02, -2.708800e-02, 1.517038e-02, 4.019696e-02, 5.969302e-02, 
        7.318021e-02, 7.955336e-02, 7.740017e-02, 6.786770e-02, 5.264640e-02, 3.606222e-02, 2.435019e-02, 1.902869e-02, 
        1.784040e-02, 2.015166e-02, 2.176854e-02, 2.380658e-02, 2.387411e-02, 1.935135e-02, 1.038963e-02, -1.001266e-03, 
        -1.433260e-02, -2.778570e-02, -4.081063e-02, -5.304675e-02, -6.476809e-02, -7.332503e-02, -7.868723e-02, -8.142049e-02, 
        -8.262070e-02, -8.287768e-02, -8.119369e-02, -7.735994e-02, -7.207675e-02, -6.624884e-02, -5.734553e-02, -4.611067e-02, 
        -3.305934e-02, -2.016471e-02, -6.374361e-03, 8.127395e-03, 2.130722e-02, 3.278650e-02, 4.353354e-02, 5.205411e-02, 
        5.887513e-02, 6.586277e-02, 7.168401e-02, 7.693746e-02, 8.264459e-02, 8.641797e-02, 9.037891e-02, 9.304619e-02, 
        9.399092e-02, 9.404765e-02, 9.111092e-02, 8.638032e-02, 7.929395e-02, 7.036889e-02, 5.953161e-02, 4.825266e-02, 
        3.633480e-02, 2.367534e-02, 1.052038e-02, -2.657346e-03, -1.589899e-02, -2.896741e-02, -4.152623e-02, -5.338227e-02, 
        -6.409219e-02, -7.406542e-02, -8.205233e-02, -9.017282e-02, -9.689866e-02, -1.023482e-01, -1.055274e-01, -1.067142e-01, 
        -1.067523e-01, -1.041731e-01, -1.007724e-01, -9.483050e-02, -8.787849e-02, -7.957985e-02, -6.943558e-02, -5.877117e-02, 
        -4.777642e-02, -3.635834e-02, -2.434076e-02, -1.169129e-02, 4.245005e-04, 1.149325e-02, 2.258445e-02, 3.241976e-02, 
        4.132175e-02, 4.970854e-02, 5.553423e-02, 6.049711e-02, 6.509272e-02, 6.927640e-02, 7.257623e-02, 7.518055e-02, 
        7.756234e-02, 7.945192e-02, 8.039453e-02, 8.097967e-02, 8.128767e-02, 8.108285e-02, 7.982047e-02, 7.824626e-02, 
        7.656209e-02, 7.350573e-02, 7.002981e-02, 6.663025e-02, 6.219666e-02, 5.728286e-02, 5.233078e-02, 4.657957e-02, 
        4.063100e-02, 3.430746e-02, 2.768315e-02, 2.085859e-02, 1.364530e-02, 6.248875e-03, -1.250127e-03, -8.652431e-03, 
        -1.588737e-02, -2.317202e-02, -2.976850e-02, -3.625468e-02, -4.235110e-02, -4.798755e-02, -5.290627e-02, -5.679774e-02, 
        -5.985921e-02, -6.230819e-02, -6.392358e-02, -6.487407e-02, -6.509388e-02, -6.480806e-02, -6.428655e-02, -6.324443e-02, 
        -6.185623e-02, -6.007233e-02, -5.821870e-02, -5.653940e-02, -5.441352e-02, -5.258841e-02, -5.119751e-02, -4.981180e-02, 
        -4.884794e-02, -4.856944e-02, -4.807488e-02, -4.738218e-02, -4.656297e-02, -4.545571e-02, -4.451550e-02, -4.302666e-02, 
        -4.098589e-02, -3.906619e-02, -3.745225e-02, -3.521159e-02, -3.305556e-02, -3.075919e-02, -2.816611e-02, -2.553889e-02, 
        -2.286192e-02, -2.012358e-02, -1.677399e-02, -1.321086e-02, -9.671028e-03, -6.194379e-03, -2.438305e-03, 1.305949e-03, 
        4.998369e-03, 9.002757e-03, 1.307251e-02, 1.685137e-02, 2.035346e-02, 2.406746e-02, 2.767851e-02, 3.103426e-02, 
        3.420898e-02, 3.733744e-02, 4.021906e-02, 4.268473e-02, 4.501986e-02, 4.693454e-02, 4.883143e-02, 5.010330e-02, 
        5.092922e-02, 5.144524e-02, 5.156375e-02, 5.134105e-02, 5.069609e-02, 4.997770e-02, 4.896712e-02, 4.802644e-02, 
        4.688289e-02, 4.557125e-02, 4.409246e-02, 4.265972e-02, 4.112532e-02, 3.964203e-02, 3.808217e-02, 3.666312e-02, 
        3.534755e-02, 3.392347e-02, 3.280277e-02, 3.155641e-02, 3.068470e-02, 2.954000e-02, 2.834969e-02, 2.719150e-02, 
        2.587153e-02, 2.505802e-02, 2.408689e-02, 2.314924e-02, 2.221252e-02, 2.126470e-02, 2.086830e-02, 2.040811e-02, 
        2.010343e-02, 1.988996e-02, 1.935163e-02, 1.899015e-02, 1.861569e-02, 1.821986e-02, 1.796585e-02, 1.752384e-02, 
        1.709545e-02, 1.650732e-02, 1.589593e-02, 1.520503e-02, 1.440425e-02, 1.365198e-02, 1.264166e-02, 1.127104e-02, 
        9.841914e-03, 8.339769e-03, 6.712574e-03, 4.933912e-03, 2.884468e-03, 5.985493e-04, -1.708059e-03, -3.991786e-03, 
        -6.257966e-03, -8.585060e-03, -1.100853e-02, -1.385632e-02, -1.659416e-02, -1.910374e-02, -2.157096e-02, -2.398674e-02, 
        -2.617890e-02, -2.825907e-02, -3.018520e-02, -3.190477e-02, -3.336141e-02, -3.466525e-02, -3.578901e-02, -3.680746e-02, 
        -3.771924e-02, -3.827121e-02, -3.877290e-02, -3.913692e-02, -3.950250e-02, -3.981678e-02, -4.004068e-02, -4.023469e-02, 
        -4.030622e-02, -4.033762e-02, -4.025896e-02, -4.013123e-02, -3.998137e-02, -3.978413e-02, -3.967819e-02, -3.939395e-02, 
        -3.883163e-02, -3.810040e-02, -3.757120e-02, -3.705130e-02, -3.640822e-02, -3.584473e-02, -3.522015e-02, -3.416148e-02, 
        -3.278193e-02, -3.134782e-02, -2.977984e-02, -2.829860e-02, -2.696610e-02, -2.551638e-02, -2.404139e-02, -2.224460e-02, 
        -2.022519e-02, -1.829419e-02, -1.649663e-02, -1.473209e-02, -1.310277e-02, -1.167724e-02, -1.034436e-02, -8.846850e-03, 
        -7.353908e-03, -5.725595e-03, -4.293107e-03, -3.148903e-03, -2.236444e-03, -1.645302e-03, -1.233031e-03, -4.919654e-04, 
        1.413101e-04, 5.636048e-04, 1.077949e-03, 1.506724e-03, 1.655457e-03, 1.694085e-03, 1.580385e-03, 1.407083e-03, 
        1.290979e-03, 1.241103e-03, 1.164737e-03, 7.979683e-04, 6.047147e-04, 5.998700e-04, 4.217476e-04, 2.288406e-04, 
        1.315521e-04, 1.019066e-04, 1.381810e-04, 4.759979e-04, 1.007209e-03, 1.238664e-03, 1.383367e-03, 1.443117e-03, 
        1.410411e-03, 1.365550e-03, 1.273418e-03, 1.424101e-03, 1.407576e-03, 1.630785e-03, 1.940799e-03, 2.176384e-03, 
        2.280105e-03, 2.394124e-03, 2.835923e-03, 3.174333e-03, 3.526331e-03, 3.968612e-03, 4.578331e-03, 5.055281e-03, 
        5.761884e-03, 6.541719e-03, 7.434230e-03, 8.211070e-03, 9.345373e-03, 1.054248e-02, 1.162063e-02, 1.261968e-02, 
        1.374627e-02, 1.506815e-02, 1.660291e-02, 1.806392e-02, 1.970821e-02, 2.139701e-02, 2.289452e-02, 2.448306e-02, 
        2.601973e-02, 2.743160e-02, 2.882312e-02, 3.021573e-02, 3.158087e-02, 3.285834e-02, 3.407062e-02, 3.516235e-02, 
        3.628794e-02, 3.720631e-02, 3.800676e-02, 3.885607e-02, 3.964268e-02, 4.028641e-02, 4.062831e-02, 4.108059e-02, 
        4.148136e-02, 4.168244e-02, 4.176866e-02, 4.181152e-02, 4.198007e-02, 4.218633e-02, 4.237012e-02, 4.253384e-02, 
        4.259278e-02, 4.243740e-02, 4.206305e-02, 4.150209e-02, 4.086748e-02, 4.016169e-02, 3.960730e-02, 3.887417e-02, 
        3.806509e-02, 3.697609e-02, 3.571246e-02, 3.438925e-02, 3.301974e-02, 3.150530e-02, 2.962946e-02, 2.769375e-02, 
        2.577277e-02, 2.379602e-02, 2.163412e-02, 1.946542e-02, 1.734635e-02, 1.509087e-02, 1.262924e-02, 1.015724e-02, 
        7.902637e-03, 5.665930e-03, 3.406363e-03, 1.172860e-03, -9.998845e-04, -3.263325e-03, -5.638867e-03, -8.192518e-03, 
        -1.071512e-02, -1.299464e-02, -1.505132e-02, -1.706454e-02, -1.902563e-02, -2.067841e-02, -2.190756e-02, -2.302112e-02, 
        -2.424621e-02, -2.530534e-02, -2.628679e-02, -2.722248e-02, -2.806121e-02, -2.894963e-02, -2.989156e-02, -3.077421e-02, 
        -3.140256e-02, -3.212894e-02, -3.264985e-02, -3.302154e-02, -3.324528e-02, -3.348531e-02, -3.370481e-02, -3.382639e-02, 
        -3.389419e-02, -3.400893e-02, -3.426127e-02, -3.452348e-02, -3.477738e-02, -3.491843e-02, -3.492807e-02, -3.476538e-02, 
        -3.436834e-02, -3.393744e-02, -3.331573e-02, -3.268536e-02, -3.194480e-02, -3.123312e-02, -3.047864e-02, -2.961140e-02, 
        -2.868011e-02, -2.774287e-02, -2.679371e-02, -2.586089e-02, -2.482176e-02, -2.366655e-02, -2.243803e-02, -2.125467e-02, 
        -1.989082e-02, -1.853484e-02, -1.720170e-02, -1.585174e-02, -1.459108e-02, -1.324508e-02, -1.193631e-02, -1.071926e-02, 
        -9.540640e-03, -8.517981e-03, -7.488759e-03, -6.416223e-03, -5.386322e-03, -4.353601e-03, -3.370936e-03, -2.506711e-03, 
        -1.788548e-03, -1.242683e-03, -6.646805e-04, -1.758541e-04, 3.037850e-04, 7.090468e-04, 9.946048e-04, 1.409651e-03, 
        1.777146e-03, 2.075085e-03, 2.318047e-03, 2.646397e-03, 3.001634e-03, 3.335471e-03, 3.609256e-03, 3.852900e-03, 
        3.941584e-03, 3.848084e-03, 3.729051e-03, 3.693554e-03, 3.659795e-03, 3.448675e-03, 3.068618e-03, 2.594031e-03, 
        2.213261e-03, 1.758666e-03, 1.230598e-03, 5.974798e-04, 1.002171e-04, -3.511939e-04, -7.997501e-04, -1.291263e-03, 
        -1.827102e-03, -2.317758e-03, -2.901357e-03, -3.432364e-03, -3.863615e-03, -4.343495e-03, -4.930273e-03, -5.421391e-03, 
        -5.859212e-03, -6.179578e-03, -6.463739e-03, -6.845580e-03, -7.266627e-03, -7.589516e-03, -7.702766e-03, -7.427188e-03, 
        -7.142174e-03, -6.800878e-03, -6.367102e-03, -5.864443e-03, -5.382831e-03, -4.881120e-03, -4.481691e-03, -4.207930e-03, 
        -4.041625e-03, -3.913481e-03, -3.798549e-03, -3.659885e-03, -3.447355e-03, -3.227707e-03, -3.052418e-03, -2.849870e-03, 
        -2.540188e-03, -2.169183e-03, -1.623437e-03, -9.806347e-04, -2.884090e-04, 4.951020e-04, 1.268905e-03, 2.020584e-03, 
        2.804607e-03, 3.686111e-03, 4.623393e-03, 5.558912e-03, 6.590802e-03, 7.683101e-03, 8.814030e-03, 9.926143e-03, 
        1.098814e-02, 1.202529e-02, 1.312637e-02, 1.433848e-02, 1.557870e-02, 1.672425e-02, 1.785887e-02, 1.900206e-02, 
        2.008627e-02, 2.110877e-02, 2.206490e-02, 2.294132e-02, 2.383328e-02, 2.463579e-02, 2.523893e-02, 2.572642e-02, 
        2.616126e-02, 2.653914e-02, 2.681667e-02, 2.698384e-02, 2.701180e-02, 2.705757e-02, 2.710002e-02, 2.717537e-02, 
        2.721729e-02, 2.722810e-02, 2.723821e-02, 2.725637e-02, 2.729546e-02, 2.723936e-02, 2.713780e-02, 2.694573e-02, 
        2.668998e-02, 2.644269e-02, 2.620186e-02, 2.597265e-02, 2.581422e-02, 2.569973e-02, 2.557705e-02, 2.544458e-02, 
        2.522740e-02, 2.494625e-02, 2.455333e-02, 2.410170e-02, 2.351828e-02, 2.282917e-02, 2.211129e-02, 2.135670e-02, 
        2.053562e-02, 1.963763e-02, 1.866019e-02, 1.760652e-02, 1.658837e-02, 1.564097e-02, 1.469566e-02, 1.369593e-02, 
        1.267910e-02, 1.164322e-02, 1.050212e-02, 9.382651e-03, 8.228941e-03, 7.003910e-03, 5.715816e-03, 4.385959e-03, 
        3.187868e-03, 2.077364e-03, 1.056469e-03, 1.056810e-04, -8.166558e-04, -1.749681e-03, -2.671533e-03, -3.560762e-03, 
        -4.396105e-03, -5.183609e-03, -5.961650e-03, -6.726190e-03, -7.532381e-03, -8.388815e-03, -9.148416e-03, -1.001064e-02, 
        -1.090672e-02, -1.186608e-02, -1.281656e-02, -1.391314e-02, -1.509008e-02, -1.630194e-02, -1.748983e-02, -1.866812e-02, 
        -1.990342e-02, -2.124323e-02, -2.266669e-02, -2.409413e-02, -2.540345e-02, -2.651204e-02, -2.759958e-02, -2.860726e-02, 
        -2.963686e-02, -3.066199e-02, -3.170440e-02, -3.271547e-02, -3.366741e-02, -3.451744e-02, -3.526645e-02, -3.597432e-02, 
        -3.654182e-02, -3.686749e-02, -3.708588e-02, -3.716189e-02, -3.717350e-02, -3.712003e-02, -3.705128e-02, -3.693900e-02, 
        -3.687041e-02, -3.681770e-02, -3.672809e-02, -3.663553e-02, -3.660483e-02, -3.660009e-02, -3.643445e-02, -3.608549e-02, 
        -3.582227e-02, -3.563342e-02, -3.544855e-02, -3.533970e-02, -3.521676e-02, -3.507009e-02, -3.489187e-02, -3.474534e-02, 
        -3.462618e-02, -3.442417e-02, -3.418774e-02, -3.397048e-02, -3.368356e-02, -3.338937e-02, -3.305459e-02, -3.269441e-02, 
        -3.198629e-02, -3.111630e-02, -3.022737e-02, -2.931267e-02, -2.834872e-02, -2.726518e-02, -2.609620e-02, -2.487626e-02, 
        -2.359541e-02, -2.236799e-02, -2.118645e-02, -2.003864e-02, -1.887809e-02, -1.777604e-02, -1.671133e-02, -1.569087e-02, 
        -1.470441e-02, -1.374682e-02, -1.284282e-02, -1.201802e-02, -1.114242e-02, -1.026903e-02, -9.444259e-03, -8.502198e-03, 
        -7.545191e-03, -6.625737e-03, -5.724872e-03, -4.875653e-03, -4.011697e-03, -3.114425e-03, -2.133028e-03, -1.132353e-03, 
        -7.581203e-06, 1.138889e-03, 2.263788e-03, 3.370658e-03, 4.518324e-03, 5.673439e-03, 6.774203e-03, 7.822776e-03, 
        8.848177e-03, 9.819092e-03, 1.071289e-02, 1.154698e-02, 1.233961e-02, 1.308728e-02, 1.368194e-02, 1.416295e-02, 
        1.455475e-02, 1.490606e-02, 1.526442e-02, 1.561591e-02, 1.594705e-02, 1.624214e-02, 1.677711e-02, 1.738704e-02, 
        1.801871e-02, 1.862352e-02, 1.921178e-02, 1.969546e-02, 2.012506e-02, 2.044887e-02, 2.084089e-02, 2.135367e-02, 
        2.194371e-02, 2.262269e-02, 2.341510e-02, 2.427020e-02, 2.509585e-02, 2.587514e-02, 2.668172e-02, 2.745540e-02, 
        2.812808e-02, 2.872863e-02, 2.924824e-02, 2.970274e-02, 3.004808e-02, 3.029362e-02, 3.046823e-02, 3.055698e-02, 
        3.058566e-02, 3.056395e-02, 3.047943e-02, 3.038018e-02, 3.015302e-02, 2.981492e-02, 2.940199e-02, 2.894101e-02, 
        2.849902e-02, 2.808541e-02, 2.770490e-02, 2.731710e-02, 2.688582e-02, 2.647155e-02, 2.608558e-02, 2.591296e-02, 
        2.581973e-02, 2.575380e-02, 2.571715e-02, 2.572992e-02, 2.577940e-02, 2.589100e-02, 2.607847e-02, 2.634906e-02, 
        2.659737e-02, 2.681429e-02, 2.698701e-02, 2.714503e-02, 2.725628e-02, 2.729188e-02, 2.723950e-02, 2.706785e-02, 
        2.679017e-02, 2.632206e-02, 2.570716e-02, 2.502466e-02, 2.428319e-02, 2.334337e-02, 2.231898e-02, 2.122946e-02, 
        2.013992e-02, 1.905499e-02, 1.799630e-02, 1.693870e-02, 1.588512e-02, 1.485546e-02, 1.376223e-02, 1.264511e-02, 
        1.151455e-02, 1.043219e-02, 9.414249e-03, 8.489298e-03, 7.670184e-03, 6.923129e-03, 6.231918e-03, 5.602638e-03, 
        5.008505e-03, 4.501276e-03, 4.072697e-03, 3.668189e-03, 3.220896e-03, 2.748418e-03, 2.191690e-03, 1.597310e-03, 
        9.583032e-04, 2.915937e-04, -3.414514e-04, -1.006103e-03, -1.716042e-03, -2.454044e-03, -3.131360e-03, -3.851934e-03, 
        -4.556372e-03, -5.288167e-03, -6.098473e-03, -6.879084e-03, -7.646168e-03, -8.386765e-03, -9.097550e-03, -9.790325e-03, 
        -1.046676e-02, -1.111886e-02, -1.174480e-02, -1.229662e-02, -1.275620e-02, -1.311655e-02, -1.344013e-02, -1.370861e-02, 
        -1.395867e-02, -1.419176e-02, -1.438439e-02, -1.452059e-02, -1.456022e-02, -1.447935e-02, -1.432253e-02, -1.405163e-02, 
        -1.376406e-02, -1.351821e-02, -1.326792e-02, -1.302730e-02, -1.276939e-02, -1.248687e-02, -1.210445e-02, -1.169238e-02, 
        -1.128910e-02, -1.087348e-02, -1.046596e-02, -1.003700e-02, -9.591587e-03, -9.137892e-03, -8.684494e-03, -8.265109e-03, 
        -7.879819e-03, -7.487533e-03, -7.078767e-03, -6.663434e-03, -6.218614e-03, -5.754517e-03, -5.350267e-03, -4.991624e-03, 
        -4.649861e-03, -4.300304e-03, -3.951166e-03, -3.712821e-03, -3.546430e-03, -3.414193e-03, -3.331016e-03, -3.299512e-03, 
        -3.278189e-03, -3.264178e-03, -3.251670e-03, -3.279345e-03, -3.358939e-03, -3.549348e-03, -3.799394e-03, -4.082149e-03, 
        -4.391320e-03, -4.710511e-03, -5.044619e-03, -5.410087e-03, -5.711682e-03, -5.996753e-03, -6.340770e-03, -6.584797e-03, 
        -6.727178e-03, -6.768959e-03, -6.777004e-03, -6.771874e-03, -6.786380e-03, -6.778971e-03, -6.805732e-03, -6.859159e-03, 
        -6.962634e-03, -7.052824e-03, -7.162723e-03, -7.256644e-03, -7.347714e-03, -7.450831e-03, -7.590599e-03, -7.678282e-03, 
        -7.770598e-03, -7.932179e-03, -8.099055e-03, -8.254360e-03, -8.401964e-03, -8.529252e-03, -8.638737e-03, -8.706753e-03, 
        -8.708989e-03, -8.640035e-03, -8.552731e-03, -8.461409e-03, -8.355552e-03, -8.320266e-03, -8.273267e-03, -8.183507e-03, 
        -8.035477e-03, -7.841541e-03, -7.603160e-03, -7.317098e-03, -7.023905e-03, -6.754152e-03, -6.494216e-03, -6.191246e-03, 
        -5.855130e-03, -5.490166e-03, -5.107889e-03, -4.692356e-03, -4.183558e-03, -3.597480e-03, -3.021860e-03, -2.368777e-03, 
        -1.732934e-03, -1.128342e-03, -5.544300e-04, -2.789279e-05, 4.621089e-04, 9.479503e-04, 1.355681e-03, 1.661723e-03, 
        1.846546e-03, 1.966050e-03, 2.029690e-03, 2.058399e-03, 2.069139e-03, 2.085198e-03, 2.086770e-03, 2.118438e-03, 
        2.191080e-03, 2.283026e-03, 2.280907e-03, 2.282985e-03, 2.254391e-03, 2.112161e-03, 1.946159e-03, 1.757909e-03, 
        1.599493e-03, 1.512843e-03, 1.589365e-03, 1.736455e-03, 1.947146e-03, 2.212924e-03, 2.511569e-03, 2.772376e-03, 
        3.034046e-03, 3.178168e-03, 3.165527e-03, 3.055279e-03, 2.938614e-03, 3.061092e-03, 3.094326e-03, 3.032048e-03, 
        2.882782e-03, 2.681154e-03, 2.409797e-03, 2.075953e-03, 1.665721e-03, 1.188743e-03, 6.284173e-04, 2.064357e-17
    },
    {
        0.000000e+00, -5.884035e-03, 1.206050e-02, 3.049206e-02, 3.003751e-02, 1.966938e-02, 1.709589e-02, 1.097572e-02, 
        5.710203e-03, 3.384460e-03, 5.629450e-03, 1.143536e-02, 1.917816e-02, 2.587902e-02, 2.589293e-02, 1.871079e-02, 
        5.688994e-03, -1.257538e-02, -3.206193e-02, -5.227155e-02, -6.826732e-02, -7.666923e-02, -7.778825e-02, -7.387267e-02, 
        -6.796031e-02, -5.995261e-02, -4.956054e-02, -3.672650e-02, -2.252167e-02, -8.694235e-03, 4.488508e-03, 1.696310e-02, 
        2.825635e-02, 3.791796e-02, 4.659577e-02, 5.390258e-02, 5.931234e-02, 6.192430e-02, 6.156818e-02, 5.863152e-02, 
        5.357603e-02, 4.669202e-02, 3.916060e-02, 3.117202e-02, 2.359120e-02, 1.704662e-02, 1.212091e-02, 8.710634e-03, 
        5.831097e-03, 3.360740e-03, 5.391114e-04, -3.764149e-03, -9.071557e-03, -1.531453e-02, -2.255599e-02, -2.966411e-02, 
        -3.601688e-02, -4.185548e-02, -4.654736e-02, -4.908090e-02, -4.971211e-02, -4.805107e-02, -4.496298e-02, -4.147839e-02, 
        -3.795349e-02, -3.409726e-02, -2.930175e-02, -2.347795e-02, -1.686408e-02, -1.021798e-02, -3.376739e-03, 3.754763e-03, 
        1.130456e-02, 1.885608e-02, 2.589634e-02, 3.323095e-02, 4.051716e-02, 4.714532e-02, 5.248908e-02, 5.655314e-02, 
        5.943179e-02, 6.044005e-02, 6.046374e-02, 5.946990e-02, 5.665442e-02, 5.263206e-02, 4.804912e-02, 4.197308e-02, 
        3.557421e-02, 2.879640e-02, 2.130866e-02, 1.412141e-02, 6.402630e-03, -3.954837e-04, -6.820323e-03, -1.268624e-02, 
        -1.766589e-02, -2.165018e-02, -2.393816e-02, -2.563379e-02, -2.677766e-02, -2.823566e-02, -2.937754e-02, -3.041117e-02, 
        -3.146949e-02, -3.267914e-02, -3.384882e-02, -3.490533e-02, -3.612919e-02, -3.728481e-02, -3.788315e-02, -3.844097e-02, 
        -3.912957e-02, -3.894780e-02, -3.844641e-02, -3.738447e-02, -3.592443e-02, -3.402646e-02, -3.156060e-02, -2.857174e-02, 
        -2.479943e-02, -2.073766e-02, -1.614759e-02, -1.124309e-02, -6.154171e-03, -8.895209e-04, 4.301080e-03, 9.167609e-03, 
        1.394155e-02, 1.858114e-02, 2.283719e-02, 2.696660e-02, 3.068767e-02, 3.329175e-02, 3.510834e-02, 3.621983e-02, 
        3.628220e-02, 3.552816e-02, 3.418535e-02, 3.208951e-02, 2.929572e-02, 2.604667e-02, 2.294167e-02, 1.937953e-02, 
        1.562590e-02, 1.189731e-02, 8.045938e-03, 4.237038e-03, 4.310596e-04, -2.706980e-03, -5.062185e-03, -7.028978e-03, 
        -8.336149e-03, -8.766212e-03, -8.931890e-03, -8.995374e-03, -9.001025e-03, -8.741414e-03, -8.518932e-03, -8.407627e-03, 
        -8.284246e-03, -8.117318e-03, -7.625531e-03, -7.526594e-03, -7.456860e-03, -7.662614e-03, -7.723305e-03, -7.689266e-03, 
        -7.542797e-03, -7.756374e-03, -8.293640e-03, -8.805057e-03, -9.057601e-03, -9.720454e-03, -1.066413e-02, -1.172893e-02, 
        -1.242470e-02, -1.312386e-02, -1.394897e-02, -1.488869e-02, -1.518750e-02, -1.563231e-02, -1.633437e-02, -1.684247e-02, 
        -1.722660e-02, -1.777575e-02, -1.780741e-02, -1.778761e-02, -1.763925e-02, -1.714208e-02, -1.649148e-02, -1.562869e-02, 
        -1.416601e-02, -1.295431e-02, -1.101993e-02, -8.948106e-03, -6.121230e-03, -3.173768e-03, 1.660451e-04, 3.487262e-03, 
        6.887342e-03, 1.031193e-02, 1.346142e-02, 1.656899e-02, 1.942181e-02, 2.240880e-02, 2.498714e-02, 2.751651e-02, 
        2.986261e-02, 3.191622e-02, 3.363757e-02, 3.495018e-02, 3.587321e-02, 3.667872e-02, 3.692653e-02, 3.719468e-02, 
        3.700629e-02, 3.650387e-02, 3.592412e-02, 3.520577e-02, 3.447157e-02, 3.337643e-02, 3.201951e-02, 3.043860e-02, 
        2.849360e-02, 2.664718e-02, 2.451794e-02, 2.237383e-02, 2.002122e-02, 1.757373e-02, 1.514208e-02, 1.270289e-02, 
        1.043545e-02, 8.049355e-03, 5.636358e-03, 3.536537e-03, 1.348231e-03, -8.218181e-04, -2.493908e-03, -3.951792e-03, 
        -5.248754e-03, -6.500497e-03, -7.593310e-03, -8.091750e-03, -8.625289e-03, -8.914666e-03, -8.996373e-03, -8.989998e-03, 
        -8.992182e-03, -8.942410e-03, -8.802284e-03, -8.096253e-03, -7.462768e-03, -6.823762e-03, -6.019022e-03, -5.316966e-03, 
        -4.808466e-03, -4.183201e-03, -3.691915e-03, -3.272723e-03, -2.804278e-03, -2.752393e-03, -2.858813e-03, -3.139648e-03, 
        -3.631077e-03, -4.178289e-03, -4.837927e-03, -5.415356e-03, -5.852108e-03, -6.244190e-03, -6.752684e-03, -7.179716e-03, 
        -7.599783e-03, -8.096081e-03, -8.604389e-03, -9.210337e-03, -9.832264e-03, -1.044150e-02, -1.105628e-02, -1.175909e-02, 
        -1.250079e-02, -1.318013e-02, -1.376539e-02, -1.421848e-02, -1.470018e-02, -1.535426e-02, -1.593455e-02, -1.644070e-02, 
        -1.696452e-02, -1.762929e-02, -1.828440e-02, -1.903388e-02, -1.977325e-02, -2.060567e-02, -2.139396e-02, -2.226622e-02, 
        -2.327479e-02, -2.422805e-02, -2.524178e-02, -2.625225e-02, -2.732794e-02, -2.848347e-02, -2.933124e-02, -3.004910e-02, 
        -3.077191e-02, -3.159298e-02, -3.236835e-02, -3.290230e-02, -3.331127e-02, -3.345762e-02, -3.320700e-02, -3.271422e-02, 
        -3.203304e-02, -3.113345e-02, -2.991892e-02, -2.850035e-02, -2.686171e-02, -2.504731e-02, -2.311087e-02, -2.094423e-02, 
        -1.855454e-02, -1.603842e-02, -1.345968e-02, -1.066311e-02, -7.677695e-03, -4.693214e-03, -1.804628e-03, 1.198819e-03, 
        4.050774e-03, 6.727898e-03, 9.258785e-03, 1.175012e-02, 1.410771e-02, 1.640370e-02, 1.872032e-02, 2.106224e-02, 
        2.347714e-02, 2.588787e-02, 2.832950e-02, 3.066889e-02, 3.292749e-02, 3.505272e-02, 3.707771e-02, 3.897498e-02, 
        4.074446e-02, 4.245702e-02, 4.395962e-02, 4.521019e-02, 4.619311e-02, 4.688558e-02, 4.750285e-02, 4.794766e-02, 
        4.816383e-02, 4.810482e-02, 4.792793e-02, 4.729618e-02, 4.652057e-02, 4.558017e-02, 4.452366e-02, 4.319393e-02, 
        4.170817e-02, 3.992725e-02, 3.788809e-02, 3.552905e-02, 3.306365e-02, 3.054822e-02, 2.812698e-02, 2.558530e-02, 
        2.297020e-02, 2.032699e-02, 1.759461e-02, 1.491980e-02, 1.230803e-02, 9.845191e-03, 7.546819e-03, 5.449565e-03, 
        3.372990e-03, 1.356474e-03, -6.244383e-04, -2.610921e-03, -4.586890e-03, -6.278519e-03, -7.890025e-03, -9.517659e-03, 
        -1.103433e-02, -1.232521e-02, -1.350277e-02, -1.452207e-02, -1.563505e-02, -1.662070e-02, -1.747172e-02, -1.809808e-02, 
        -1.868008e-02, -1.924296e-02, -1.972334e-02, -1.995173e-02, -1.992581e-02, -1.988442e-02, -1.969942e-02, -1.948009e-02, 
        -1.907908e-02, -1.854615e-02, -1.787303e-02, -1.699768e-02, -1.594111e-02, -1.459593e-02, -1.299512e-02, -1.109364e-02, 
        -9.132048e-03, -7.098413e-03, -5.133031e-03, -3.156067e-03, -1.176582e-03, 8.107661e-04, 2.753242e-03, 4.567266e-03, 
        6.461167e-03, 8.365149e-03, 1.023503e-02, 1.199766e-02, 1.367235e-02, 1.514784e-02, 1.654619e-02, 1.774623e-02, 
        1.876584e-02, 1.959939e-02, 2.027723e-02, 2.075191e-02, 2.098424e-02, 2.090633e-02, 2.048742e-02, 1.985573e-02, 
        1.914052e-02, 1.828560e-02, 1.722887e-02, 1.606533e-02, 1.494413e-02, 1.375048e-02, 1.252149e-02, 1.132415e-02, 
        1.021822e-02, 9.142808e-03, 7.972039e-03, 6.717654e-03, 5.346377e-03, 4.066137e-03, 2.773927e-03, 1.623577e-03, 
        5.727074e-04, -4.577180e-04, -1.420504e-03, -2.300119e-03, -3.070242e-03, -3.835211e-03, -4.607136e-03, -5.486896e-03, 
        -6.424022e-03, -7.375626e-03, -8.289346e-03, -9.244838e-03, -1.026491e-02, -1.143799e-02, -1.272087e-02, -1.413782e-02, 
        -1.564241e-02, -1.723947e-02, -1.889180e-02, -2.051288e-02, -2.204456e-02, -2.367888e-02, -2.526027e-02, -2.691839e-02, 
        -2.851257e-02, -3.000154e-02, -3.161105e-02, -3.331999e-02, -3.503159e-02, -3.662259e-02, -3.805864e-02, -3.942737e-02, 
        -4.068278e-02, -4.189856e-02, -4.286019e-02, -4.363595e-02, -4.429410e-02, -4.496614e-02, -4.568508e-02, -4.638920e-02, 
        -4.690511e-02, -4.718796e-02, -4.740586e-02, -4.759310e-02, -4.774237e-02, -4.767961e-02, -4.749608e-02, -4.723799e-02, 
        -4.696139e-02, -4.672770e-02, -4.646786e-02, -4.610451e-02, -4.578019e-02, -4.551681e-02, -4.523970e-02, -4.497662e-02, 
        -4.461293e-02, -4.408986e-02, -4.344115e-02, -4.269466e-02, -4.190986e-02, -4.101344e-02, -4.001374e-02, -3.877195e-02, 
        -3.730987e-02, -3.576281e-02, -3.404682e-02, -3.226266e-02, -3.029614e-02, -2.812401e-02, -2.579066e-02, -2.340318e-02, 
        -2.092865e-02, -1.838213e-02, -1.568175e-02, -1.289884e-02, -1.017833e-02, -7.495431e-03, -4.834545e-03, -2.142456e-03, 
        5.920163e-04, 3.337825e-03, 5.959578e-03, 8.519402e-03, 1.102971e-02, 1.344931e-02, 1.576932e-02, 1.796100e-02, 
        1.991082e-02, 2.168644e-02, 2.337365e-02, 2.504023e-02, 2.678373e-02, 2.862147e-02, 3.049878e-02, 3.241890e-02, 
        3.436431e-02, 3.641611e-02, 3.856386e-02, 4.073100e-02, 4.283885e-02, 4.490802e-02, 4.689472e-02, 4.871002e-02, 
        5.046645e-02, 5.204726e-02, 5.343029e-02, 5.472832e-02, 5.599236e-02, 5.721597e-02, 5.839899e-02, 5.957367e-02, 
        6.056500e-02, 6.136720e-02, 6.186965e-02, 6.211838e-02, 6.226175e-02, 6.229212e-02, 6.214178e-02, 6.190056e-02, 
        6.152783e-02, 6.101349e-02, 6.050825e-02, 6.002261e-02, 5.945987e-02, 5.870049e-02, 5.780476e-02, 5.684328e-02, 
        5.594430e-02, 5.514625e-02, 5.451345e-02, 5.392397e-02, 5.337463e-02, 5.275612e-02, 5.213341e-02, 5.162743e-02, 
        5.126525e-02, 5.069816e-02, 5.000647e-02, 4.919533e-02, 4.829488e-02, 4.734442e-02, 4.636469e-02, 4.530876e-02, 
        4.408834e-02, 4.273445e-02, 4.124301e-02, 3.971368e-02, 3.816382e-02, 3.635555e-02, 3.442473e-02, 3.242237e-02, 
        3.032685e-02, 2.810918e-02, 2.570025e-02, 2.315001e-02, 2.051721e-02, 1.781774e-02, 1.504993e-02, 1.223533e-02, 
        9.403792e-03, 6.614334e-03, 3.961789e-03, 1.352513e-03, -1.142669e-03, -3.556329e-03, -5.808669e-03, -7.896957e-03, 
        -9.784636e-03, -1.150217e-02, -1.308122e-02, -1.463586e-02, -1.613689e-02, -1.753596e-02, -1.880683e-02, -1.998000e-02, 
        -2.100789e-02, -2.209715e-02, -2.315729e-02, -2.421098e-02, -2.529663e-02, -2.641581e-02, -2.758166e-02, -2.869584e-02, 
        -2.979604e-02, -3.095794e-02, -3.225884e-02, -3.361836e-02, -3.503545e-02, -3.645276e-02, -3.783637e-02, -3.929751e-02, 
        -4.089781e-02, -4.259918e-02, -4.432874e-02, -4.607143e-02, -4.773009e-02, -4.920081e-02, -5.047505e-02, -5.164006e-02, 
        -5.269007e-02, -5.353123e-02, -5.403724e-02, -5.434575e-02, -5.443941e-02, -5.436548e-02, -5.425290e-02, -5.409159e-02, 
        -5.387804e-02, -5.379968e-02, -5.374968e-02, -5.360891e-02, -5.324331e-02, -5.274358e-02, -5.222948e-02, -5.160853e-02, 
        -5.102097e-02, -5.055632e-02, -5.009110e-02, -4.961392e-02, -4.919782e-02, -4.890147e-02, -4.865878e-02, -4.853132e-02, 
        -4.840425e-02, -4.825781e-02, -4.817701e-02, -4.814303e-02, -4.827690e-02, -4.839454e-02, -4.851642e-02, -4.853947e-02, 
        -4.851070e-02, -4.835915e-02, -4.806847e-02, -4.772811e-02, -4.735464e-02, -4.686800e-02, -4.616908e-02, -4.515623e-02, 
        -4.409057e-02, -4.273307e-02, -4.112326e-02, -3.938006e-02, -3.749485e-02, -3.557317e-02, -3.367075e-02, -3.179954e-02, 
        -2.987817e-02, -2.790936e-02, -2.572261e-02, -2.346290e-02, -2.115555e-02, -1.891577e-02, -1.679818e-02, -1.477311e-02, 
        -1.243367e-02, -1.002242e-02, -7.706430e-03, -5.560307e-03, -3.565738e-03, -1.700999e-03, 4.548754e-05, 1.703930e-03, 
        3.307118e-03, 4.857230e-03, 6.397235e-03, 7.923882e-03, 9.460259e-03, 1.106621e-02, 1.270158e-02, 1.435002e-02, 
        1.601426e-02, 1.764552e-02, 1.926211e-02, 2.078512e-02, 2.229888e-02, 2.374488e-02, 2.518172e-02, 2.686031e-02, 
        2.867680e-02, 3.047771e-02, 3.223375e-02, 3.387937e-02, 3.545273e-02, 3.691159e-02, 3.824734e-02, 3.954426e-02, 
        4.082855e-02, 4.204487e-02, 4.314479e-02, 4.410489e-02, 4.499020e-02, 4.571630e-02, 4.630931e-02, 4.683214e-02, 
        4.735618e-02, 4.790854e-02, 4.847886e-02, 4.893745e-02, 4.941052e-02, 4.991920e-02, 5.043605e-02, 5.094296e-02, 
        5.148773e-02, 5.203289e-02, 5.260084e-02, 5.310336e-02, 5.352573e-02, 5.382221e-02, 5.425348e-02, 5.457538e-02, 
        5.479892e-02, 5.487953e-02, 5.487374e-02, 5.468993e-02, 5.432971e-02, 5.377583e-02, 5.311632e-02, 5.224699e-02, 
        5.121794e-02, 5.003129e-02, 4.869618e-02, 4.720427e-02, 4.546396e-02, 4.364570e-02, 4.182177e-02, 4.002437e-02, 
        3.824361e-02, 3.652127e-02, 3.481240e-02, 3.322805e-02, 3.166959e-02, 3.018601e-02, 2.874048e-02, 2.740325e-02, 
        2.617446e-02, 2.505664e-02, 2.406591e-02, 2.328137e-02, 2.266331e-02, 2.205704e-02, 2.146733e-02, 2.085548e-02, 
        2.027054e-02, 1.963182e-02, 1.899520e-02, 1.840720e-02, 1.782242e-02, 1.715968e-02, 1.646351e-02, 1.588462e-02, 
        1.533953e-02, 1.475195e-02, 1.402474e-02, 1.309852e-02, 1.207905e-02, 1.095860e-02, 9.732415e-03, 8.430559e-03, 
        7.069104e-03, 5.627828e-03, 4.144554e-03, 2.612547e-03, 1.078197e-03, -3.333381e-04, -1.660112e-03, -2.819464e-03, 
        -3.856188e-03, -4.675506e-03, -5.290251e-03, -5.731264e-03, -6.131214e-03, -6.553499e-03, -6.806265e-03, -7.035203e-03, 
        -7.211436e-03, -7.395562e-03, -7.599733e-03, -7.776983e-03, -7.917681e-03, -8.115935e-03, -8.351167e-03, -8.462478e-03, 
        -8.520384e-03, -8.543514e-03, -8.582004e-03, -8.686430e-03, -8.921784e-03, -9.378241e-03, -9.984562e-03, -1.070819e-02, 
        -1.144842e-02, -1.216734e-02, -1.286840e-02, -1.355399e-02, -1.423771e-02, -1.485368e-02, -1.539165e-02, -1.587404e-02, 
        -1.635753e-02, -1.671768e-02, -1.694643e-02, -1.704845e-02, -1.708001e-02, -1.707063e-02, -1.693722e-02, -1.683292e-02, 
        -1.669635e-02, -1.663055e-02, -1.664120e-02, -1.659552e-02, -1.662302e-02, -1.674169e-02, -1.693562e-02, -1.723151e-02, 
        -1.759452e-02, -1.803317e-02, -1.857834e-02, -1.926417e-02, -2.000791e-02, -2.079699e-02, -2.178555e-02, -2.305588e-02, 
        -2.442474e-02, -2.587617e-02, -2.736611e-02, -2.886701e-02, -3.039988e-02, -3.194743e-02, -3.332878e-02, -3.456006e-02, 
        -3.567533e-02, -3.674389e-02, -3.767837e-02, -3.860935e-02, -3.928897e-02, -3.975846e-02, -4.005642e-02, -4.022738e-02, 
        -4.019999e-02, -4.001636e-02, -3.973286e-02, -3.941271e-02, -3.895531e-02, -3.836477e-02, -3.766485e-02, -3.697775e-02, 
        -3.620546e-02, -3.534119e-02, -3.439193e-02, -3.339706e-02, -3.244995e-02, -3.156241e-02, -3.081037e-02, -3.013177e-02, 
        -2.946770e-02, -2.880825e-02, -2.812245e-02, -2.744323e-02, -2.669691e-02, -2.591785e-02, -2.518238e-02, -2.454735e-02, 
        -2.400416e-02, -2.345074e-02, -2.286687e-02, -2.222466e-02, -2.150362e-02, -2.072564e-02, -1.985872e-02, -1.896279e-02, 
        -1.805334e-02, -1.713478e-02, -1.627721e-02, -1.540866e-02, -1.449563e-02, -1.353659e-02, -1.258583e-02, -1.161945e-02, 
        -1.064567e-02, -9.697183e-03, -8.766315e-03, -7.884624e-03, -7.248590e-03, -6.613830e-03, -5.981632e-03, -5.358558e-03, 
        -4.684666e-03, -4.061358e-03, -3.394395e-03, -2.704937e-03, -1.992494e-03, -1.265195e-03, -6.845468e-04, -1.080782e-04, 
        4.257485e-04, 9.852376e-04, 1.683515e-03, 2.508954e-03, 3.467462e-03, 4.520353e-03, 5.608052e-03, 6.758289e-03, 
        7.913474e-03, 9.121853e-03, 1.047055e-02, 1.199733e-02, 1.366311e-02, 1.525929e-02, 1.684295e-02, 1.845380e-02, 
        2.008954e-02, 2.181070e-02, 2.352426e-02, 2.516126e-02, 2.685818e-02, 2.855091e-02, 3.021117e-02, 3.187322e-02, 
        3.354269e-02, 3.517659e-02, 3.652914e-02, 3.774941e-02, 3.887767e-02, 3.973597e-02, 4.048107e-02, 4.117310e-02, 
        4.185933e-02, 4.257679e-02, 4.334223e-02, 4.412559e-02, 4.484661e-02, 4.553661e-02, 4.620972e-02, 4.647402e-02, 
        4.666042e-02, 4.698923e-02, 4.745676e-02, 4.803383e-02, 4.868036e-02, 4.937314e-02, 4.998720e-02, 5.037414e-02, 
        5.070796e-02, 5.085181e-02, 5.089037e-02, 5.094595e-02, 5.090955e-02, 5.051478e-02, 5.013270e-02, 4.969428e-02, 
        4.925393e-02, 4.869329e-02, 4.782868e-02, 4.668914e-02, 4.525280e-02, 4.372563e-02, 4.212665e-02, 4.033387e-02, 
        3.845674e-02, 3.655031e-02, 3.419669e-02, 3.170815e-02, 2.924282e-02, 2.647364e-02, 2.354786e-02, 2.060480e-02, 
        1.765068e-02, 1.477969e-02, 1.201827e-02, 9.359265e-03, 6.832206e-03, 4.422553e-03, 2.152366e-03, 1.115139e-16
    },
    {
        0.000000e+00, -2.579398e-01, -1.209567e-01, -1.932490e-02, 2.504666e-02, 3.760578e-02, 5.783333e-02, 6.761293e-02, 
        7.434871e-02, 7.908871e-02, 8.784226e-02, 9.907153e-02, 1.101218e-01, 1.189280e-01, 1.136878e-01, 9.264423e-02, 
        6.011690e-02, 2.173496e-02, -1.755617e-02, -5.624576e-02, -8.941955e-02, -1.129872e-01, -1.263236e-01, -1.315514e-01, 
        -1.303526e-01, -1.240840e-01, -1.136003e-01, -9.992641e-02, -8.610108e-02, -7.163968e-02, -5.759440e-02, -4.251288e-02, 
        -2.767609e-02, -1.359326e-02, 7.703830e-04, 1.501648e-02, 2.836959e-02, 3.884818e-02, 4.631836e-02, 5.056561e-02, 
        5.256275e-02, 5.108808e-02, 4.837986e-02, 4.531974e-02, 4.190391e-02, 3.886251e-02, 3.834583e-02, 3.955288e-02, 
        4.053713e-02, 4.172433e-02, 3.956807e-02, 3.614354e-02, 3.136865e-02, 2.491181e-02, 1.852397e-02, 1.143958e-02, 
        4.409165e-03, -2.266289e-03, -8.557574e-03, -1.352364e-02, -1.756921e-02, -1.901168e-02, -1.933776e-02, -2.004519e-02, 
        -2.022225e-02, -1.937490e-02, -1.828170e-02, -1.674618e-02, -1.469506e-02, -1.204811e-02, -8.579812e-03, -4.427528e-03, 
        3.616970e-04, 5.099766e-03, 1.097479e-02, 1.545632e-02, 1.975683e-02, 2.381555e-02, 2.770366e-02, 3.035031e-02, 
        3.069347e-02, 3.000374e-02, 2.646521e-02, 2.213796e-02, 1.632744e-02, 9.611939e-03, 2.464927e-03, -5.452643e-03, 
        -1.477599e-02, -2.404947e-02, -3.276840e-02, -4.067040e-02, -4.763239e-02, -5.479383e-02, -5.999768e-02, -6.344228e-02, 
        -6.477467e-02, -6.281421e-02, -5.982008e-02, -5.487841e-02, -4.827628e-02, -4.055054e-02, -3.342795e-02, -2.628211e-02, 
        -1.818398e-02, -9.700948e-03, -2.041464e-03, 5.061294e-03, 1.255927e-02, 2.012797e-02, 2.589389e-02, 3.187245e-02, 
        3.843609e-02, 4.340302e-02, 4.789767e-02, 5.259461e-02, 5.620754e-02, 5.940958e-02, 6.281688e-02, 6.470254e-02, 
        6.624533e-02, 6.730981e-02, 6.758890e-02, 6.759588e-02, 6.630336e-02, 6.442698e-02, 6.216506e-02, 5.918142e-02, 
        5.575290e-02, 5.118315e-02, 4.674005e-02, 4.178763e-02, 3.653629e-02, 3.068895e-02, 2.349925e-02, 1.581754e-02, 
        7.878387e-03, -6.886181e-04, -9.249308e-03, -1.821434e-02, -2.673689e-02, -3.492459e-02, -4.339498e-02, -5.120203e-02, 
        -5.873327e-02, -6.544557e-02, -7.133148e-02, -7.676154e-02, -8.055690e-02, -8.398265e-02, -8.641409e-02, -8.696943e-02, 
        -8.643045e-02, -8.427497e-02, -8.095234e-02, -7.756008e-02, -7.407493e-02, -7.043029e-02, -6.678125e-02, -6.298851e-02, 
        -5.833634e-02, -5.378697e-02, -4.955872e-02, -4.419111e-02, -3.872515e-02, -3.292736e-02, -2.664201e-02, -2.033412e-02, 
        -1.446422e-02, -8.907711e-03, -2.955067e-03, 2.399817e-03, 7.114083e-03, 1.193007e-02, 1.690367e-02, 2.174539e-02, 
        2.561761e-02, 2.978104e-02, 3.374028e-02, 3.771790e-02, 4.051783e-02, 4.374519e-02, 4.664450e-02, 4.870739e-02, 
        4.993152e-02, 5.142378e-02, 5.211863e-02, 5.224159e-02, 5.236009e-02, 5.158623e-02, 5.080987e-02, 4.946461e-02, 
        4.774334e-02, 4.624232e-02, 4.478164e-02, 4.325651e-02, 4.093693e-02, 3.838341e-02, 3.583514e-02, 3.326730e-02, 
        3.064711e-02, 2.774813e-02, 2.511689e-02, 2.258792e-02, 2.041250e-02, 1.831328e-02, 1.624659e-02, 1.420284e-02, 
        1.216297e-02, 9.958626e-03, 7.791126e-03, 5.516001e-03, 3.696278e-03, 1.620315e-03, -8.438702e-05, -1.743089e-03, 
        -3.159685e-03, -4.207882e-03, -5.405470e-03, -6.339237e-03, -7.585506e-03, -8.845937e-03, -1.026351e-02, -1.217476e-02, 
        -1.430957e-02, -1.664366e-02, -1.902981e-02, -2.118980e-02, -2.320684e-02, -2.539996e-02, -2.752148e-02, -2.937368e-02, 
        -3.133944e-02, -3.315962e-02, -3.472621e-02, -3.607433e-02, -3.697657e-02, -3.724698e-02, -3.727162e-02, -3.702979e-02, 
        -3.667382e-02, -3.569018e-02, -3.416013e-02, -3.221873e-02, -2.982019e-02, -2.719112e-02, -2.453182e-02, -2.166123e-02, 
        -1.833190e-02, -1.485849e-02, -1.131786e-02, -7.878930e-03, -4.391772e-03, -6.966317e-04, 2.750646e-03, 5.956787e-03, 
        9.095940e-03, 1.203525e-02, 1.447489e-02, 1.655321e-02, 1.843273e-02, 1.982740e-02, 2.076265e-02, 2.118521e-02, 
        2.141936e-02, 2.128287e-02, 2.087018e-02, 2.035876e-02, 1.991192e-02, 1.983346e-02, 2.005756e-02, 2.033808e-02, 
        2.060518e-02, 2.108593e-02, 2.154459e-02, 2.217383e-02, 2.276094e-02, 2.327822e-02, 2.352310e-02, 2.370586e-02, 
        2.398790e-02, 2.436696e-02, 2.459088e-02, 2.467673e-02, 2.485049e-02, 2.487367e-02, 2.447821e-02, 2.417875e-02, 
        2.377879e-02, 2.299162e-02, 2.185145e-02, 2.032041e-02, 1.863735e-02, 1.653366e-02, 1.419286e-02, 1.180981e-02, 
        9.317537e-03, 6.749421e-03, 4.055280e-03, 1.357940e-03, -1.281496e-03, -4.161932e-03, -6.926867e-03, -9.448191e-03, 
        -1.177807e-02, -1.358487e-02, -1.520972e-02, -1.654234e-02, -1.753675e-02, -1.846182e-02, -1.911281e-02, -1.888710e-02, 
        -1.808285e-02, -1.712806e-02, -1.613268e-02, -1.494508e-02, -1.364783e-02, -1.235170e-02, -1.107139e-02, -9.711666e-03, 
        -8.429320e-03, -7.124912e-03, -5.589019e-03, -3.905409e-03, -2.196126e-03, -3.586341e-04, 1.586919e-03, 2.722414e-03, 
        3.098131e-03, 3.316094e-03, 3.332841e-03, 3.213552e-03, 3.178998e-03, 3.364780e-03, 3.439043e-03, 3.404151e-03, 
        3.610437e-03, 4.061402e-03, 4.446161e-03, 5.030620e-03, 5.955267e-03, 6.882735e-03, 7.661038e-03, 8.398200e-03, 
        9.215394e-03, 9.814869e-03, 1.068802e-02, 1.164980e-02, 1.234742e-02, 1.293027e-02, 1.321345e-02, 1.358017e-02, 
        1.360308e-02, 1.332827e-02, 1.292256e-02, 1.253662e-02, 1.193453e-02, 1.097354e-02, 9.608262e-03, 7.727396e-03, 
        5.181497e-03, 2.498065e-03, 8.392901e-05, -2.753614e-03, -5.874013e-03, -9.066884e-03, -1.221922e-02, -1.530662e-02, 
        -1.841245e-02, -2.134858e-02, -2.361042e-02, -2.593328e-02, -2.841748e-02, -3.068935e-02, -3.268556e-02, -3.460273e-02, 
        -3.637718e-02, -3.784616e-02, -3.897207e-02, -3.989913e-02, -4.084184e-02, -4.161193e-02, -4.224743e-02, -4.272912e-02, 
        -4.332241e-02, -4.402182e-02, -4.452376e-02, -4.506558e-02, -4.528480e-02, -4.546102e-02, -4.559239e-02, -4.611191e-02, 
        -4.668735e-02, -4.709852e-02, -4.723655e-02, -4.745577e-02, -4.775760e-02, -4.783295e-02, -4.757291e-02, -4.731658e-02, 
        -4.693088e-02, -4.636473e-02, -4.527026e-02, -4.392313e-02, -4.232921e-02, -4.058036e-02, -3.830428e-02, -3.563550e-02, 
        -3.252757e-02, -2.947177e-02, -2.609116e-02, -2.252321e-02, -1.882878e-02, -1.536624e-02, -1.178465e-02, -7.949011e-03, 
        -4.070393e-03, -2.169144e-04, 3.653688e-03, 7.723708e-03, 1.168033e-02, 1.546843e-02, 1.906044e-02, 2.267620e-02, 
        2.635240e-02, 2.999622e-02, 3.326988e-02, 3.609206e-02, 3.854707e-02, 4.039571e-02, 4.218781e-02, 4.365848e-02, 
        4.492490e-02, 4.587969e-02, 4.670635e-02, 4.746898e-02, 4.822103e-02, 4.922597e-02, 5.035996e-02, 5.168701e-02, 
        5.302462e-02, 5.431828e-02, 5.574555e-02, 5.716833e-02, 5.851182e-02, 5.970190e-02, 6.062621e-02, 6.131199e-02, 
        6.187983e-02, 6.242391e-02, 6.307774e-02, 6.358222e-02, 6.392120e-02, 6.404110e-02, 6.397023e-02, 6.414935e-02, 
        6.390093e-02, 6.311954e-02, 6.182869e-02, 6.025462e-02, 5.846745e-02, 5.627545e-02, 5.370097e-02, 5.086212e-02, 
        4.779427e-02, 4.450851e-02, 4.093421e-02, 3.710409e-02, 3.311468e-02, 2.955969e-02, 2.605301e-02, 2.247117e-02, 
        1.871255e-02, 1.477813e-02, 1.093143e-02, 7.142533e-03, 3.338119e-03, -4.218725e-04, -4.152341e-03, -7.620255e-03, 
        -1.079695e-02, -1.377148e-02, -1.649072e-02, -1.882488e-02, -2.069452e-02, -2.226946e-02, -2.359193e-02, -2.482650e-02, 
        -2.621025e-02, -2.742695e-02, -2.847715e-02, -2.931658e-02, -3.001557e-02, -3.069451e-02, -3.125401e-02, -3.177524e-02, 
        -3.219790e-02, -3.247020e-02, -3.272664e-02, -3.279779e-02, -3.263522e-02, -3.244683e-02, -3.222611e-02, -3.213730e-02, 
        -3.209843e-02, -3.227508e-02, -3.256853e-02, -3.275860e-02, -3.273513e-02, -3.249075e-02, -3.201190e-02, -3.153708e-02, 
        -3.095856e-02, -3.013429e-02, -2.898258e-02, -2.755313e-02, -2.572948e-02, -2.360818e-02, -2.141612e-02, -1.911493e-02, 
        -1.679410e-02, -1.461674e-02, -1.256759e-02, -1.060445e-02, -8.690035e-03, -6.837316e-03, -5.127986e-03, -3.560941e-03, 
        -2.282790e-03, -1.246488e-03, -2.973902e-04, 6.036451e-04, 1.307093e-03, 1.665978e-03, 1.747005e-03, 1.506567e-03, 
        9.812409e-04, 2.203542e-04, -6.531253e-04, -1.681214e-03, -2.734614e-03, -3.757117e-03, -4.544129e-03, -4.963993e-03, 
        -4.966266e-03, -4.609048e-03, -4.097634e-03, -3.432080e-03, -2.618152e-03, -1.660368e-03, -7.237833e-04, 6.128496e-05, 
        7.160381e-04, 1.312671e-03, 2.144561e-03, 3.002123e-03, 3.878402e-03, 4.715605e-03, 5.403221e-03, 5.927875e-03, 
        6.323630e-03, 6.462751e-03, 6.248945e-03, 5.646920e-03, 4.782494e-03, 3.694970e-03, 2.381798e-03, 1.009759e-03, 
        -3.573277e-04, -1.749128e-03, -3.192651e-03, -4.741605e-03, -6.371721e-03, -8.005634e-03, -9.490331e-03, -1.071508e-02, 
        -1.170148e-02, -1.247470e-02, -1.319494e-02, -1.387452e-02, -1.429349e-02, -1.441293e-02, -1.413480e-02, -1.355052e-02, 
        -1.277048e-02, -1.187251e-02, -1.086824e-02, -9.790924e-03, -8.634118e-03, -7.568894e-03, -6.702131e-03, -6.024374e-03, 
        -5.571644e-03, -5.145867e-03, -4.660619e-03, -4.168417e-03, -3.612648e-03, -2.891409e-03, -2.164632e-03, -1.474701e-03, 
        -1.017929e-03, -8.793184e-04, -1.119031e-03, -1.625717e-03, -2.389485e-03, -3.264484e-03, -4.157508e-03, -5.140339e-03, 
        -5.965895e-03, -6.638305e-03, -7.134637e-03, -7.518238e-03, -7.531199e-03, -7.281284e-03, -6.756853e-03, -6.034889e-03, 
        -5.124576e-03, -4.092030e-03, -2.867205e-03, -1.451115e-03, 2.239897e-04, 2.110914e-03, 4.097981e-03, 6.129396e-03, 
        8.113317e-03, 9.938029e-03, 1.170526e-02, 1.338156e-02, 1.488051e-02, 1.625691e-02, 1.735182e-02, 1.821789e-02, 
        1.884886e-02, 1.927077e-02, 1.943597e-02, 1.930072e-02, 1.876736e-02, 1.770444e-02, 1.630472e-02, 1.469489e-02, 
        1.287807e-02, 1.086195e-02, 8.783380e-03, 6.777411e-03, 4.842621e-03, 2.984875e-03, 1.441480e-03, 9.822667e-05, 
        -9.469432e-04, -1.556145e-03, -1.622938e-03, -1.253699e-03, -6.320784e-04, 1.547057e-04, 1.161875e-03, 2.363016e-03, 
        3.635548e-03, 4.995336e-03, 6.441811e-03, 7.925154e-03, 9.416030e-03, 1.112582e-02, 1.294499e-02, 1.477188e-02, 
        1.673515e-02, 1.875369e-02, 2.061192e-02, 2.226624e-02, 2.370853e-02, 2.478138e-02, 2.551645e-02, 2.603810e-02, 
        2.642191e-02, 2.662482e-02, 2.660716e-02, 2.629400e-02, 2.560136e-02, 2.468079e-02, 2.366704e-02, 2.259868e-02, 
        2.147261e-02, 2.027612e-02, 1.906563e-02, 1.796267e-02, 1.695637e-02, 1.601241e-02, 1.507960e-02, 1.423999e-02, 
        1.361573e-02, 1.327799e-02, 1.318320e-02, 1.335855e-02, 1.365530e-02, 1.403293e-02, 1.446425e-02, 1.491372e-02, 
        1.518441e-02, 1.508684e-02, 1.482889e-02, 1.460668e-02, 1.439235e-02, 1.421736e-02, 1.418394e-02, 1.423821e-02, 
        1.396676e-02, 1.354445e-02, 1.298255e-02, 1.212716e-02, 1.097619e-02, 9.402749e-03, 7.573798e-03, 5.595428e-03, 
        3.515146e-03, 1.485177e-03, -4.882044e-04, -2.362990e-03, -4.052034e-03, -5.482022e-03, -6.651650e-03, -7.596364e-03, 
        -8.507816e-03, -9.470378e-03, -1.028909e-02, -1.093851e-02, -1.143958e-02, -1.179755e-02, -1.208581e-02, -1.236813e-02, 
        -1.272414e-02, -1.309716e-02, -1.345903e-02, -1.385009e-02, -1.428607e-02, -1.479398e-02, -1.527407e-02, -1.575459e-02, 
        -1.633419e-02, -1.703189e-02, -1.787018e-02, -1.887978e-02, -2.003423e-02, -2.136734e-02, -2.269959e-02, -2.400660e-02, 
        -2.528676e-02, -2.652036e-02, -2.762633e-02, -2.855865e-02, -2.922374e-02, -2.966257e-02, -2.971810e-02, -2.947755e-02, 
        -2.904298e-02, -2.847870e-02, -2.780494e-02, -2.710601e-02, -2.637022e-02, -2.562690e-02, -2.505907e-02, -2.454080e-02, 
        -2.409288e-02, -2.375043e-02, -2.345757e-02, -2.311544e-02, -2.272731e-02, -2.229195e-02, -2.188252e-02, -2.141581e-02, 
        -2.111549e-02, -2.106495e-02, -2.132958e-02, -2.186872e-02, -2.253665e-02, -2.326625e-02, -2.399170e-02, -2.463249e-02, 
        -2.508957e-02, -2.535475e-02, -2.552324e-02, -2.543599e-02, -2.506226e-02, -2.446855e-02, -2.356986e-02, -2.241903e-02, 
        -2.114630e-02, -1.971796e-02, -1.818763e-02, -1.663143e-02, -1.495635e-02, -1.309890e-02, -1.118190e-02, -9.284025e-03, 
        -7.421051e-03, -5.629939e-03, -3.948830e-03, -2.429027e-03, -1.061970e-03, 2.193347e-04, 1.338235e-03, 2.240275e-03, 
        2.909313e-03, 3.341588e-03, 3.507632e-03, 3.431855e-03, 2.972452e-03, 2.230958e-03, 1.300598e-03, 1.916446e-04, 
        -1.096381e-03, -2.459304e-03, -3.894535e-03, -5.393157e-03, -6.819771e-03, -8.182386e-03, -9.446314e-03, -1.037507e-02, 
        -1.090151e-02, -1.082440e-02, -1.025120e-02, -9.172517e-03, -7.938720e-03, -6.504267e-03, -5.105796e-03, -3.747840e-03, 
        -2.432724e-03, -1.143524e-03, 1.246597e-04, 1.377356e-03, 2.640967e-03, 4.002917e-03, 5.459114e-03, 6.838093e-03, 
        8.104481e-03, 9.337010e-03, 1.050151e-02, 1.142605e-02, 1.202659e-02, 1.226805e-02, 1.219793e-02, 1.191685e-02, 
        1.143601e-02, 1.088010e-02, 1.042566e-02, 1.008632e-02, 9.938196e-03, 1.003155e-02, 1.038871e-02, 1.101200e-02, 
        1.182630e-02, 1.280232e-02, 1.389360e-02, 1.515404e-02, 1.652723e-02, 1.800978e-02, 1.957076e-02, 2.120760e-02, 
        2.293185e-02, 2.460919e-02, 2.622679e-02, 2.760060e-02, 2.880274e-02, 2.991452e-02, 3.087578e-02, 3.175920e-02, 
        3.247300e-02, 3.299391e-02, 3.326776e-02, 3.321213e-02, 3.278646e-02, 3.195643e-02, 3.073559e-02, 2.922576e-02, 
        2.752823e-02, 2.569974e-02, 2.371693e-02, 2.170333e-02, 1.964248e-02, 1.757875e-02, 1.543505e-02, 1.332448e-02, 
        1.135122e-02, 9.568384e-03, 8.017653e-03, 6.721457e-03, 5.781147e-03, 5.137044e-03, 4.789883e-03, 4.564974e-03, 
        4.333416e-03, 4.154308e-03, 4.117791e-03, 4.174322e-03, 4.336080e-03, 4.586243e-03, 4.934014e-03, 5.360635e-03, 
        5.687154e-03, 5.939883e-03, 6.078859e-03, 6.193818e-03, 6.233641e-03, 6.230615e-03, 6.171828e-03, 6.037512e-03, 
        5.889675e-03, 5.794554e-03, 5.789711e-03, 5.835376e-03, 5.987347e-03, 6.108669e-03, 6.164964e-03, 6.139106e-03, 
        6.042786e-03, 5.886521e-03, 5.720929e-03, 5.610427e-03, 5.596352e-03, 5.689164e-03, 5.873301e-03, 6.044754e-03, 
        6.199628e-03, 6.303955e-03, 6.357360e-03, 6.267259e-03, 6.137201e-03, 5.919732e-03, 5.632784e-03, 5.270683e-03, 
        4.763314e-03, 4.151010e-03, 3.381284e-03, 2.459789e-03, 1.415645e-03, 2.846581e-04, -9.016040e-04, -2.072679e-03, 
        -3.195387e-03, -4.372159e-03, -5.493731e-03, -6.489536e-03, -7.410036e-03, -8.249778e-03, -9.020135e-03, -9.679026e-03, 
        -1.024993e-02, -1.059533e-02, -1.069940e-02, -1.057291e-02, -1.037040e-02, -1.008951e-02, -9.803875e-03, -9.588151e-03, 
        -9.352192e-03, -9.079449e-03, -8.737069e-03, -8.270414e-03, -7.721555e-03, -7.106008e-03, -6.552974e-03, -6.071447e-03, 
        -5.627334e-03, -5.260632e-03, -4.940564e-03, -4.680510e-03, -4.493115e-03, -4.518905e-03, -4.674544e-03, -4.982171e-03, 
        -5.456682e-03, -6.227990e-03, -7.194331e-03, -8.369432e-03, -9.673612e-03, -1.104694e-02, -1.238453e-02, -1.370461e-02, 
        -1.498773e-02, -1.617976e-02, -1.726968e-02, -1.835257e-02, -1.944410e-02, -2.039484e-02, -2.120457e-02, -2.177195e-02, 
        -2.207613e-02, -2.203223e-02, -2.166245e-02, -2.106259e-02, -2.032756e-02, -1.951773e-02, -1.870273e-02, -1.789780e-02, 
        -1.709755e-02, -1.626338e-02, -1.553065e-02, -1.478031e-02, -1.399874e-02, -1.316922e-02, -1.227253e-02, -1.133702e-02, 
        -1.044539e-02, -9.706953e-03, -9.170190e-03, -8.882478e-03, -8.908699e-03, -9.208948e-03, -9.718379e-03, -1.033312e-02, 
        -1.101671e-02, -1.187972e-02, -1.258727e-02, -1.310278e-02, -1.339329e-02, -1.341135e-02, -1.308742e-02, -1.263665e-02, 
        -1.201478e-02, -1.118051e-02, -1.006663e-02, -8.698361e-03, -7.000645e-03, -5.014099e-03, -2.661863e-03, -9.504265e-17
    },
    {
        0.000000e+00, -2.469714e-02, -2.473741e-02, -2.405222e-02, -3.741649e-03, 2.191523e-02, 3.004823e-02, 3.490736e-02, 
        3.573678e-02, 3.198222e-02, 2.153496e-02, 5.702981e-03, -1.289214e-02, -2.994308e-02, -3.871065e-02, -3.894194e-02, 
        -3.340419e-02, -2.426176e-02, -1.466523e-02, -3.085266e-03, 7.732097e-03, 1.503688e-02, 1.859290e-02, 1.864447e-02, 
        1.710718e-02, 1.421894e-02, 1.018549e-02, 5.587017e-03, 1.192989e-03, -1.994035e-03, -4.262802e-03, -6.295929e-03, 
        -7.636204e-03, -8.170831e-03, -8.616133e-03, -8.658765e-03, -8.173853e-03, -6.305262e-03, -3.508473e-03, 4.313680e-05, 
        4.071673e-03, 8.678984e-03, 1.303724e-02, 1.668072e-02, 1.909616e-02, 1.994462e-02, 1.870585e-02, 1.551111e-02, 
        1.160449e-02, 7.490275e-03, 4.442047e-03, 2.945680e-03, 2.356617e-03, 2.250466e-03, 2.092284e-03, 1.829290e-03, 
        1.088032e-03, -1.959431e-04, -1.711074e-03, -4.201147e-03, -7.821432e-03, -1.258203e-02, -1.716226e-02, -2.097909e-02, 
        -2.367560e-02, -2.557019e-02, -2.671241e-02, -2.731694e-02, -2.703611e-02, -2.607524e-02, -2.432872e-02, -2.218602e-02, 
        -1.956096e-02, -1.642157e-02, -1.306824e-02, -9.128684e-03, -5.022810e-03, -9.088909e-04, 3.112213e-03, 7.408376e-03, 
        1.207519e-02, 1.677878e-02, 2.180218e-02, 2.659783e-02, 3.138106e-02, 3.598792e-02, 3.984319e-02, 4.272506e-02, 
        4.433416e-02, 4.461072e-02, 4.327752e-02, 4.044258e-02, 3.630138e-02, 3.116601e-02, 2.491316e-02, 1.780005e-02, 
        9.515282e-03, 2.064248e-04, -9.068661e-03, -1.837233e-02, -2.730946e-02, -3.490568e-02, -4.063500e-02, -4.392272e-02, 
        -4.557725e-02, -4.587873e-02, -4.485252e-02, -4.275832e-02, -4.008398e-02, -3.694630e-02, -3.304749e-02, -2.867330e-02, 
        -2.397167e-02, -1.852278e-02, -1.271055e-02, -6.908028e-03, -9.235115e-04, 4.936529e-03, 1.046311e-02, 1.555157e-02, 
        1.956183e-02, 2.223251e-02, 2.328826e-02, 2.283432e-02, 2.121724e-02, 1.820797e-02, 1.445283e-02, 1.005728e-02, 
        5.757214e-03, 1.708169e-03, -2.368862e-03, -5.969397e-03, -8.953819e-03, -1.091631e-02, -1.153879e-02, -1.093272e-02, 
        -9.583846e-03, -7.227005e-03, -4.264415e-03, -6.332222e-04, 3.563772e-03, 8.025719e-03, 1.287193e-02, 1.782613e-02, 
        2.253753e-02, 2.677626e-02, 3.036717e-02, 3.329387e-02, 3.537673e-02, 3.672864e-02, 3.757941e-02, 3.725171e-02, 
        3.591777e-02, 3.347496e-02, 2.979634e-02, 2.495512e-02, 1.884777e-02, 1.194969e-02, 4.639894e-03, -2.832655e-03, 
        -1.030999e-02, -1.717243e-02, -2.310889e-02, -2.816440e-02, -3.175951e-02, -3.384981e-02, -3.451982e-02, -3.438689e-02, 
        -3.356070e-02, -3.223152e-02, -3.060941e-02, -2.874502e-02, -2.639277e-02, -2.348729e-02, -1.991079e-02, -1.568495e-02, 
        -1.065097e-02, -5.328739e-03, 3.436562e-04, 6.088442e-03, 1.190536e-02, 1.717460e-02, 2.168178e-02, 2.516354e-02, 
        2.763609e-02, 2.888219e-02, 2.930595e-02, 2.878452e-02, 2.710643e-02, 2.461488e-02, 2.113023e-02, 1.695251e-02, 
        1.212703e-02, 6.948012e-03, 1.508608e-03, -3.814585e-03, -8.648795e-03, -1.315810e-02, -1.760640e-02, -2.184816e-02, 
        -2.575361e-02, -2.903948e-02, -3.116364e-02, -3.165045e-02, -3.033117e-02, -2.780772e-02, -2.431087e-02, -2.053059e-02, 
        -1.683747e-02, -1.331233e-02, -1.008198e-02, -7.237729e-03, -4.673095e-03, -1.874590e-03, 1.184268e-03, 4.574012e-03, 
        8.403873e-03, 1.233318e-02, 1.643578e-02, 2.011707e-02, 2.310985e-02, 2.494469e-02, 2.490363e-02, 2.320294e-02, 
        2.020001e-02, 1.665536e-02, 1.270204e-02, 8.612392e-03, 4.478917e-03, 1.571016e-04, -4.365922e-03, -9.130007e-03, 
        -1.384645e-02, -1.828565e-02, -2.235556e-02, -2.575146e-02, -2.834808e-02, -3.020620e-02, -3.106271e-02, -3.114853e-02, 
        -3.020945e-02, -2.813767e-02, -2.501593e-02, -2.099232e-02, -1.602425e-02, -1.064933e-02, -5.045817e-03, 1.254503e-04, 
        4.967998e-03, 9.552591e-03, 1.366735e-02, 1.710611e-02, 1.998054e-02, 2.231760e-02, 2.432907e-02, 2.600744e-02, 
        2.726502e-02, 2.819859e-02, 2.863906e-02, 2.822755e-02, 2.653581e-02, 2.294667e-02, 1.778420e-02, 1.143211e-02, 
        4.104702e-03, -4.014319e-03, -1.202931e-02, -1.958348e-02, -2.631378e-02, -3.174873e-02, -3.564200e-02, -3.743810e-02, 
        -3.769528e-02, -3.679272e-02, -3.530662e-02, -3.303707e-02, -3.029167e-02, -2.702925e-02, -2.327617e-02, -1.888226e-02, 
        -1.401580e-02, -8.596156e-03, -2.685436e-03, 3.539384e-03, 1.005315e-02, 1.680412e-02, 2.360350e-02, 3.004834e-02, 
        3.575538e-02, 4.032734e-02, 4.376997e-02, 4.607003e-02, 4.731562e-02, 4.740315e-02, 4.663758e-02, 4.480173e-02, 
        4.201254e-02, 3.841397e-02, 3.402428e-02, 2.922936e-02, 2.436055e-02, 1.965072e-02, 1.519454e-02, 1.091344e-02, 
        6.779922e-03, 2.651729e-03, -1.142556e-03, -4.355308e-03, -6.874424e-03, -8.187367e-03, -8.004693e-03, -6.653978e-03, 
        -4.675131e-03, -2.412549e-03, -1.801794e-04, 1.960451e-03, 3.827486e-03, 5.336422e-03, 6.455668e-03, 7.130686e-03, 
        7.704794e-03, 8.426043e-03, 9.196559e-03, 9.846271e-03, 1.034433e-02, 1.058532e-02, 1.013297e-02, 8.621587e-03, 
        5.706139e-03, 1.455167e-03, -4.188250e-03, -1.052945e-02, -1.721039e-02, -2.394485e-02, -3.058344e-02, -3.662466e-02, 
        -4.184156e-02, -4.620814e-02, -4.926624e-02, -5.120101e-02, -5.182468e-02, -5.133663e-02, -4.946614e-02, -4.645581e-02, 
        -4.243800e-02, -3.769361e-02, -3.224662e-02, -2.612433e-02, -1.953594e-02, -1.264116e-02, -5.611731e-03, 1.309327e-03, 
        7.759884e-03, 1.360613e-02, 1.873400e-02, 2.334811e-02, 2.703138e-02, 2.983114e-02, 3.161283e-02, 3.257043e-02, 
        3.243703e-02, 3.129269e-02, 2.910848e-02, 2.596110e-02, 2.211607e-02, 1.783682e-02, 1.363941e-02, 9.775343e-03, 
        6.289424e-03, 3.168244e-03, 5.442142e-04, -1.432615e-03, -2.882379e-03, -3.757345e-03, -4.019791e-03, -3.602201e-03, 
        -2.572118e-03, -9.670831e-04, 9.029681e-04, 2.872666e-03, 4.880329e-03, 7.085902e-03, 9.357564e-03, 1.165989e-02, 
        1.398067e-02, 1.630992e-02, 1.856286e-02, 2.061765e-02, 2.214967e-02, 2.288716e-02, 2.274893e-02, 2.155210e-02, 
        1.984837e-02, 1.773392e-02, 1.526252e-02, 1.250028e-02, 9.520906e-03, 6.080876e-03, 2.117947e-03, -2.154828e-03, 
        -6.470547e-03, -1.082293e-02, -1.511478e-02, -1.901925e-02, -2.252049e-02, -2.537071e-02, -2.770976e-02, -2.932445e-02, 
        -3.033750e-02, -3.050300e-02, -3.011630e-02, -2.915869e-02, -2.780598e-02, -2.603283e-02, -2.395820e-02, -2.171752e-02, 
        -1.941299e-02, -1.700557e-02, -1.478619e-02, -1.284328e-02, -1.111396e-02, -9.706651e-03, -8.524213e-03, -7.608755e-03, 
        -6.815194e-03, -6.397150e-03, -6.352473e-03, -7.017941e-03, -8.643011e-03, -1.161232e-02, -1.560416e-02, -2.014740e-02, 
        -2.488373e-02, -2.963286e-02, -3.410267e-02, -3.790953e-02, -4.083287e-02, -4.222920e-02, -4.184246e-02, -3.988442e-02, 
        -3.704735e-02, -3.362409e-02, -3.007321e-02, -2.650582e-02, -2.295975e-02, -1.922940e-02, -1.514926e-02, -1.058975e-02, 
        -5.348284e-03, 5.125951e-04, 6.877922e-03, 1.373155e-02, 2.097317e-02, 2.830371e-02, 3.544873e-02, 4.198773e-02, 
        4.748402e-02, 5.180024e-02, 5.471164e-02, 5.658613e-02, 5.737312e-02, 5.727197e-02, 5.622846e-02, 5.430131e-02, 
        5.140708e-02, 4.792081e-02, 4.392795e-02, 3.975572e-02, 3.543148e-02, 3.099325e-02, 2.642971e-02, 2.175544e-02, 
        1.688887e-02, 1.171612e-02, 6.227816e-03, 5.519335e-04, -5.072114e-03, -1.046543e-02, -1.551374e-02, -1.999188e-02, 
        -2.362500e-02, -2.643011e-02, -2.782810e-02, -2.796351e-02, -2.697521e-02, -2.543845e-02, -2.346073e-02, -2.116862e-02, 
        -1.848509e-02, -1.557067e-02, -1.227826e-02, -8.675187e-03, -4.761031e-03, -4.820634e-04, 3.906117e-03, 8.156725e-03, 
        1.215343e-02, 1.572166e-02, 1.891351e-02, 2.172695e-02, 2.402011e-02, 2.574990e-02, 2.674857e-02, 2.698458e-02, 
        2.647294e-02, 2.525541e-02, 2.335007e-02, 2.088851e-02, 1.799333e-02, 1.499020e-02, 1.216037e-02, 9.681682e-03, 
        7.817044e-03, 6.748233e-03, 6.583826e-03, 7.596197e-03, 9.844509e-03, 1.315159e-02, 1.710790e-02, 2.134541e-02, 
        2.553117e-02, 2.967176e-02, 3.352215e-02, 3.695839e-02, 4.001679e-02, 4.261101e-02, 4.475191e-02, 4.648808e-02, 
        4.778138e-02, 4.860870e-02, 4.909802e-02, 4.895594e-02, 4.811304e-02, 4.619319e-02, 4.286583e-02, 3.757626e-02, 
        3.078569e-02, 2.270371e-02, 1.387770e-02, 4.779164e-03, -4.092503e-03, -1.223514e-02, -1.943952e-02, -2.501403e-02, 
        -2.890377e-02, -3.074296e-02, -3.146610e-02, -3.118263e-02, -3.031050e-02, -2.902008e-02, -2.750036e-02, -2.575038e-02, 
        -2.389904e-02, -2.210426e-02, -2.036294e-02, -1.863248e-02, -1.669441e-02, -1.452353e-02, -1.226031e-02, -1.015735e-02, 
        -8.429232e-03, -7.551904e-03, -7.805462e-03, -9.591092e-03, -1.251954e-02, -1.624616e-02, -2.042288e-02, -2.489127e-02, 
        -2.961188e-02, -3.457365e-02, -3.974123e-02, -4.515161e-02, -5.066904e-02, -5.605736e-02, -6.114674e-02, -6.562307e-02, 
        -6.922415e-02, -7.189946e-02, -7.361066e-02, -7.433874e-02, -7.405536e-02, -7.270721e-02, -7.012071e-02, -6.611841e-02, 
        -6.100698e-02, -5.502489e-02, -4.868240e-02, -4.232679e-02, -3.612787e-02, -3.028428e-02, -2.487482e-02, -1.998584e-02, 
        -1.574838e-02, -1.197147e-02, -8.556320e-03, -5.313683e-03, -2.056393e-03, 1.300921e-03, 4.759251e-03, 7.977133e-03, 
        1.041292e-02, 1.159322e-02, 1.095794e-02, 8.868775e-03, 5.720589e-03, 1.987927e-03, -2.142447e-03, -6.294556e-03, 
        -1.019883e-02, -1.354720e-02, -1.568827e-02, -1.662010e-02, -1.626665e-02, -1.495183e-02, -1.263052e-02, -9.424037e-03, 
        -5.214581e-03, -3.637457e-04, 5.184059e-03, 1.123331e-02, 1.783394e-02, 2.477580e-02, 3.196704e-02, 3.925451e-02, 
        4.636777e-02, 5.324160e-02, 5.970919e-02, 6.560096e-02, 7.076938e-02, 7.526375e-02, 7.894620e-02, 8.173836e-02, 
        8.338935e-02, 8.389413e-02, 8.295499e-02, 8.052404e-02, 7.633860e-02, 7.064882e-02, 6.368782e-02, 5.574961e-02, 
        4.712387e-02, 3.798304e-02, 2.847083e-02, 1.876894e-02, 9.199882e-03, 8.134982e-05, -8.292884e-03, -1.578281e-02, 
        -2.208553e-02, -2.686247e-02, -2.986153e-02, -3.109736e-02, -3.103209e-02, -3.000446e-02, -2.835409e-02, -2.610663e-02, 
        -2.350317e-02, -2.038541e-02, -1.674303e-02, -1.252272e-02, -7.866186e-03, -2.851779e-03, 2.492958e-03, 8.033557e-03, 
        1.367719e-02, 1.931524e-02, 2.477433e-02, 2.961346e-02, 3.353311e-02, 3.612810e-02, 3.755714e-02, 3.776986e-02, 
        3.696566e-02, 3.494299e-02, 3.198361e-02, 2.795162e-02, 2.309764e-02, 1.740483e-02, 1.108238e-02, 4.356670e-03, 
        -2.321363e-03, -8.611773e-03, -1.452709e-02, -2.007548e-02, -2.534522e-02, -3.017915e-02, -3.470007e-02, -3.849996e-02, 
        -4.131858e-02, -4.254531e-02, -4.249640e-02, -4.128506e-02, -3.936655e-02, -3.702202e-02, -3.448186e-02, -3.190818e-02, 
        -2.934765e-02, -2.684640e-02, -2.460685e-02, -2.221496e-02, -1.964941e-02, -1.697355e-02, -1.424889e-02, -1.160120e-02, 
        -9.247429e-03, -7.441464e-03, -6.361837e-03, -6.528129e-03, -8.050804e-03, -1.102172e-02, -1.492772e-02, -1.948966e-02, 
        -2.436264e-02, -2.923087e-02, -3.383541e-02, -3.788422e-02, -4.107220e-02, -4.299821e-02, -4.374500e-02, -4.370206e-02, 
        -4.299503e-02, -4.176135e-02, -4.030828e-02, -3.855888e-02, -3.641545e-02, -3.388490e-02, -3.092344e-02, -2.770441e-02, 
        -2.423872e-02, -2.068526e-02, -1.718202e-02, -1.392786e-02, -1.103860e-02, -8.474431e-03, -6.318499e-03, -4.599155e-03, 
        -3.422108e-03, -2.864479e-03, -3.108889e-03, -4.030147e-03, -5.601586e-03, -7.665182e-03, -1.009093e-02, -1.265057e-02, 
        -1.499711e-02, -1.699155e-02, -1.836148e-02, -1.901478e-02, -1.855544e-02, -1.709955e-02, -1.429007e-02, -1.041143e-02, 
        -5.460287e-03, -1.261665e-04, 5.386747e-03, 1.089976e-02, 1.626002e-02, 2.136863e-02, 2.598781e-02, 3.025222e-02, 
        3.411378e-02, 3.765520e-02, 4.092193e-02, 4.407766e-02, 4.711565e-02, 5.002545e-02, 5.253883e-02, 5.441827e-02, 
        5.516846e-02, 5.452273e-02, 5.231446e-02, 4.903327e-02, 4.494703e-02, 4.041311e-02, 3.570318e-02, 3.118171e-02, 
        2.717054e-02, 2.386149e-02, 2.160893e-02, 2.049939e-02, 2.038334e-02, 2.116251e-02, 2.286725e-02, 2.550860e-02, 
        2.894125e-02, 3.308738e-02, 3.792023e-02, 4.331846e-02, 4.918008e-02, 5.532373e-02, 6.159011e-02, 6.779338e-02, 
        7.374011e-02, 7.924353e-02, 8.423250e-02, 8.856909e-02, 9.221454e-02, 9.504767e-02, 9.707952e-02, 9.807293e-02, 
        9.799350e-02, 9.672070e-02, 9.415504e-02, 9.002348e-02, 8.450535e-02, 7.751431e-02, 6.940370e-02, 6.022578e-02, 
        5.033211e-02, 3.981972e-02, 2.890956e-02, 1.780620e-02, 6.837274e-03, -3.649866e-03, -1.346158e-02, -2.202409e-02, 
        -2.927461e-02, -3.418701e-02, -3.712054e-02, -3.801048e-02, -3.799177e-02, -3.726162e-02, -3.619610e-02, -3.506033e-02, 
        -3.400738e-02, -3.308499e-02, -3.234542e-02, -3.170849e-02, -3.109412e-02, -3.025806e-02, -2.916112e-02, -2.775150e-02, 
        -2.622987e-02, -2.484602e-02, -2.393411e-02, -2.409971e-02, -2.573158e-02, -2.916639e-02, -3.379603e-02, -3.916467e-02, 
        -4.486303e-02, -5.070799e-02, -5.639171e-02, -6.160724e-02, -6.602924e-02, -6.921359e-02, -7.122981e-02, -7.199898e-02, 
        -7.168501e-02, -7.024902e-02, -6.776982e-02, -6.444134e-02, -6.037314e-02, -5.562864e-02, -5.029028e-02, -4.437816e-02, 
        -3.802252e-02, -3.145502e-02, -2.485232e-02, -1.840639e-02, -1.235996e-02, -6.777109e-03, -1.772432e-03, 2.620537e-03, 
        6.263084e-03, 9.094347e-03, 1.090423e-02, 1.170086e-02, 1.140007e-02, 1.000376e-02, 7.240458e-03, 3.183850e-03, 
        -1.888138e-03, -7.616923e-03, -1.385779e-02, -2.034156e-02, -2.700623e-02, -3.368848e-02, -4.017702e-02, -4.643075e-02, 
        -5.220429e-02, -5.740459e-02, -6.166947e-02, -6.508270e-02, -6.702545e-02, -6.779592e-02, -6.742814e-02, -6.647366e-02, 
        -6.500989e-02, -6.315287e-02, -6.095275e-02, -5.846067e-02, -5.555226e-02, -5.228052e-02, -4.860444e-02, -4.471134e-02, 
        -4.066064e-02, -3.656729e-02, -3.265045e-02, -2.903471e-02, -2.584128e-02, -2.297362e-02, -2.040460e-02, -1.796517e-02, 
        -1.557589e-02, -1.311999e-02, -1.026399e-02, -6.838540e-03, -3.021240e-03, 8.577324e-04, 4.517220e-03, 7.792295e-03, 
        1.059834e-02, 1.309582e-02, 1.548577e-02, 1.807547e-02, 2.106829e-02, 2.450881e-02, 2.821024e-02, 3.197372e-02, 
        3.565061e-02, 3.905510e-02, 4.210720e-02, 4.478590e-02, 4.702872e-02, 4.874047e-02, 4.982489e-02, 5.008851e-02, 
        4.962144e-02, 4.843749e-02, 4.653002e-02, 4.392504e-02, 4.065179e-02, 3.687196e-02, 3.284988e-02, 2.874829e-02, 
        2.468267e-02, 2.080937e-02, 1.727332e-02, 1.404233e-02, 1.108063e-02, 8.401815e-03, 5.919254e-03, 3.778594e-03, 
        2.106801e-03, 1.245779e-03, 1.378594e-03, 2.542308e-03, 4.343873e-03, 6.437735e-03, 8.610165e-03, 1.076727e-02, 
        1.291231e-02, 1.512545e-02, 1.763357e-02, 2.059015e-02, 2.385508e-02, 2.733745e-02, 3.091171e-02, 3.446772e-02, 
        3.781009e-02, 4.082006e-02, 4.347937e-02, 4.566470e-02, 4.742892e-02, 4.858360e-02, 4.916511e-02, 4.900863e-02, 
        4.814129e-02, 4.638987e-02, 4.362059e-02, 3.988572e-02, 3.532695e-02, 2.990024e-02, 2.397584e-02, 1.788353e-02, 
        1.186827e-02, 6.180271e-03, 8.880984e-04, -3.978949e-03, -8.481564e-03, -1.262243e-02, -1.627360e-02, -1.929416e-02, 
        -2.138942e-02, -2.203095e-02, -2.130047e-02, -1.960012e-02, -1.735257e-02, -1.482877e-02, -1.222444e-02, -9.705679e-03, 
        -7.346903e-03, -5.179196e-03, -2.998641e-03, -7.377860e-04, 1.586075e-03, 3.984716e-03, 6.592354e-03, 9.220608e-03, 
        1.159025e-02, 1.343546e-02, 1.426936e-02, 1.371354e-02, 1.144513e-02, 7.906687e-03, 3.383170e-03, -1.721122e-03, 
        -7.078401e-03, -1.232085e-02, -1.725658e-02, -2.157435e-02, -2.485614e-02, -2.723712e-02, -2.853628e-02, -2.936226e-02, 
        -2.956426e-02, -2.892067e-02, -2.713533e-02, -2.432830e-02, -2.018329e-02, -1.487482e-02, -8.065705e-03, -4.364645e-16
    },
    {
        0.000000e+00, 2.809420e-03, -1.018166e-02, -1.607233e-02, -6.531790e-03, 9.806124e-03, 1.547079e-02, 1.789322e-02, 
        2.090920e-02, 2.277750e-02, 2.272582e-02, 2.096861e-02, 1.861513e-02, 1.398930e-02, 9.723537e-03, 6.832688e-03, 
        4.442118e-03, -3.286288e-03, -1.543934e-02, -2.795253e-02, -3.955612e-02, -4.810746e-02, -5.207969e-02, -5.463485e-02, 
        -5.850764e-02, -6.197131e-02, -6.348723e-02, -6.040675e-02, -5.143065e-02, -3.913079e-02, -2.436117e-02, -8.321060e-03, 
        7.847207e-03, 2.324741e-02, 3.768372e-02, 4.978536e-02, 5.901839e-02, 6.590013e-02, 7.029410e-02, 7.237472e-02, 
        7.293774e-02, 7.211752e-02, 6.999381e-02, 6.665861e-02, 6.280686e-02, 5.910306e-02, 5.514026e-02, 5.083006e-02, 
        4.657457e-02, 4.226260e-02, 3.811827e-02, 3.144685e-02, 2.234341e-02, 1.130665e-02, -1.228664e-03, -1.412547e-02, 
        -2.665243e-02, -3.848116e-02, -4.958071e-02, -5.857460e-02, -6.477188e-02, -6.806169e-02, -6.988016e-02, -7.073277e-02, 
        -7.151384e-02, -7.239182e-02, -7.174895e-02, -7.010280e-02, -6.744340e-02, -6.444957e-02, -6.164063e-02, -5.812576e-02, 
        -5.367930e-02, -4.848620e-02, -4.297960e-02, -3.657945e-02, -2.995950e-02, -2.296909e-02, -1.597946e-02, -8.585166e-03, 
        -1.697770e-03, 4.594097e-03, 1.148932e-02, 1.864880e-02, 2.454625e-02, 2.995974e-02, 3.540992e-02, 4.048432e-02, 
        4.511239e-02, 4.926768e-02, 5.268009e-02, 5.575321e-02, 5.734974e-02, 5.920056e-02, 6.032806e-02, 5.995693e-02, 
        5.969690e-02, 5.902042e-02, 5.781207e-02, 5.622053e-02, 5.381067e-02, 5.049819e-02, 4.761916e-02, 4.397071e-02, 
        3.998229e-02, 3.513161e-02, 2.942715e-02, 2.346468e-02, 1.659425e-02, 9.489434e-03, 2.247064e-03, -4.686881e-03, 
        -1.174621e-02, -1.771552e-02, -2.386280e-02, -2.966788e-02, -3.437926e-02, -3.819551e-02, -4.163036e-02, -4.412448e-02, 
        -4.555780e-02, -4.623978e-02, -4.544021e-02, -4.476229e-02, -4.358747e-02, -4.207403e-02, -4.058685e-02, -3.819245e-02, 
        -3.615695e-02, -3.405509e-02, -3.179835e-02, -2.949527e-02, -2.648948e-02, -2.369028e-02, -2.114936e-02, -1.836444e-02, 
        -1.591602e-02, -1.363393e-02, -1.136803e-02, -9.137404e-03, -7.535997e-03, -5.620719e-03, -3.213874e-03, -1.470036e-03, 
        -1.923592e-04, 1.624043e-03, 3.547500e-03, 5.339353e-03, 6.709763e-03, 8.519441e-03, 1.007765e-02, 1.163250e-02, 
        1.367996e-02, 1.581156e-02, 1.724416e-02, 1.839022e-02, 1.950540e-02, 2.023805e-02, 2.076328e-02, 2.068973e-02, 
        1.967446e-02, 1.825632e-02, 1.712688e-02, 1.629514e-02, 1.496719e-02, 1.384224e-02, 1.222421e-02, 1.104391e-02, 
        9.688910e-03, 8.311743e-03, 6.099691e-03, 4.040970e-03, 2.728207e-03, 1.296239e-03, -3.271050e-04, -1.922908e-03, 
        -3.056780e-03, -4.447362e-03, -6.021394e-03, -7.704061e-03, -8.476206e-03, -9.592973e-03, -1.139000e-02, -1.291937e-02, 
        -1.483325e-02, -1.662574e-02, -1.839277e-02, -1.977263e-02, -2.159780e-02, -2.298761e-02, -2.444793e-02, -2.541764e-02, 
        -2.607849e-02, -2.653594e-02, -2.625631e-02, -2.607451e-02, -2.522690e-02, -2.381982e-02, -2.209074e-02, -1.965890e-02, 
        -1.650331e-02, -1.267991e-02, -8.316619e-03, -4.122197e-03, 6.139747e-04, 5.426511e-03, 1.008538e-02, 1.478529e-02, 
        1.908357e-02, 2.327826e-02, 2.681402e-02, 3.041813e-02, 3.346004e-02, 3.662196e-02, 3.956993e-02, 4.235200e-02, 
        4.478214e-02, 4.653939e-02, 4.830894e-02, 4.948398e-02, 5.054973e-02, 5.105857e-02, 5.050251e-02, 4.961175e-02, 
        4.782370e-02, 4.582569e-02, 4.386202e-02, 4.110515e-02, 3.822829e-02, 3.546672e-02, 3.212723e-02, 2.876827e-02, 
        2.521422e-02, 2.131439e-02, 1.761771e-02, 1.397709e-02, 1.067392e-02, 7.543316e-03, 4.366291e-03, 1.737139e-03, 
        -7.447393e-04, -3.013053e-03, -4.591211e-03, -5.725243e-03, -6.626321e-03, -7.209248e-03, -7.683898e-03, -7.636667e-03, 
        -7.853054e-03, -7.986021e-03, -7.726953e-03, -7.367519e-03, -6.967053e-03, -6.343483e-03, -5.740733e-03, -5.276809e-03, 
        -4.778452e-03, -4.480262e-03, -4.075902e-03, -3.580844e-03, -3.453706e-03, -3.529391e-03, -3.686823e-03, -4.354754e-03, 
        -5.070101e-03, -5.457422e-03, -6.091960e-03, -6.374289e-03, -6.448705e-03, -6.388631e-03, -5.845405e-03, -4.843681e-03, 
        -3.979188e-03, -3.074580e-03, -2.277702e-03, -1.925746e-03, -1.628717e-03, -1.406584e-03, -1.278687e-03, -1.262424e-03, 
        -1.415470e-03, -1.777537e-03, -2.472035e-03, -3.214778e-03, -3.956296e-03, -4.650500e-03, -5.418870e-03, -6.527017e-03, 
        -7.932233e-03, -9.894023e-03, -1.201590e-02, -1.445854e-02, -1.729280e-02, -2.017117e-02, -2.323385e-02, -2.645051e-02, 
        -2.976934e-02, -3.354606e-02, -3.716312e-02, -4.084034e-02, -4.469100e-02, -4.802205e-02, -5.104382e-02, -5.378772e-02, 
        -5.643616e-02, -5.879358e-02, -6.113698e-02, -6.347768e-02, -6.499656e-02, -6.606218e-02, -6.666706e-02, -6.644076e-02, 
        -6.592303e-02, -6.526618e-02, -6.405506e-02, -6.249396e-02, -6.097593e-02, -5.937146e-02, -5.764781e-02, -5.538720e-02, 
        -5.260856e-02, -4.966647e-02, -4.619167e-02, -4.256092e-02, -3.869885e-02, -3.498655e-02, -3.147448e-02, -2.776321e-02, 
        -2.440123e-02, -2.141686e-02, -1.823270e-02, -1.508519e-02, -1.260855e-02, -1.029625e-02, -7.651348e-03, -5.079844e-03, 
        -2.508632e-03, 3.713189e-04, 3.481791e-03, 6.670783e-03, 9.664226e-03, 1.295243e-02, 1.639668e-02, 1.963827e-02, 
        2.294923e-02, 2.659309e-02, 3.039730e-02, 3.433333e-02, 3.817145e-02, 4.179942e-02, 4.539036e-02, 4.862560e-02, 
        5.183228e-02, 5.502648e-02, 5.808067e-02, 6.084900e-02, 6.341277e-02, 6.574665e-02, 6.741887e-02, 6.867368e-02, 
        6.959052e-02, 7.031543e-02, 7.042482e-02, 7.021797e-02, 7.007120e-02, 7.006946e-02, 6.961916e-02, 6.908332e-02, 
        6.829339e-02, 6.748685e-02, 6.637344e-02, 6.538728e-02, 6.473878e-02, 6.422098e-02, 6.387686e-02, 6.329067e-02, 
        6.286465e-02, 6.251631e-02, 6.188805e-02, 6.105184e-02, 6.027457e-02, 5.917069e-02, 5.799086e-02, 5.699766e-02, 
        5.628580e-02, 5.530932e-02, 5.426259e-02, 5.306346e-02, 5.151547e-02, 4.933541e-02, 4.663960e-02, 4.381481e-02, 
        4.088084e-02, 3.784104e-02, 3.480345e-02, 3.164293e-02, 2.852055e-02, 2.516690e-02, 2.142936e-02, 1.767626e-02, 
        1.381035e-02, 9.869841e-03, 5.840078e-03, 1.961443e-03, -1.358005e-03, -4.485878e-03, -7.844382e-03, -1.106633e-02, 
        -1.413394e-02, -1.704586e-02, -1.989014e-02, -2.259185e-02, -2.510935e-02, -2.738712e-02, -2.965424e-02, -3.162825e-02, 
        -3.340499e-02, -3.516393e-02, -3.685782e-02, -3.853843e-02, -3.995720e-02, -4.124214e-02, -4.253524e-02, -4.369096e-02, 
        -4.475482e-02, -4.585656e-02, -4.689625e-02, -4.779712e-02, -4.873259e-02, -4.978599e-02, -5.109208e-02, -5.227883e-02, 
        -5.339013e-02, -5.436726e-02, -5.517795e-02, -5.562611e-02, -5.606504e-02, -5.596047e-02, -5.523544e-02, -5.410832e-02, 
        -5.231778e-02, -5.051189e-02, -4.865704e-02, -4.707922e-02, -4.551303e-02, -4.370392e-02, -4.186493e-02, -3.984977e-02, 
        -3.772692e-02, -3.534138e-02, -3.281257e-02, -3.043038e-02, -2.817283e-02, -2.586624e-02, -2.348127e-02, -2.129979e-02, 
        -1.967071e-02, -1.839842e-02, -1.758337e-02, -1.692628e-02, -1.655944e-02, -1.635380e-02, -1.630859e-02, -1.657208e-02, 
        -1.692339e-02, -1.738999e-02, -1.809193e-02, -1.884559e-02, -1.934509e-02, -1.997869e-02, -2.068653e-02, -2.147315e-02, 
        -2.232529e-02, -2.288271e-02, -2.354313e-02, -2.417639e-02, -2.481200e-02, -2.556814e-02, -2.596303e-02, -2.634337e-02, 
        -2.627289e-02, -2.605863e-02, -2.562108e-02, -2.464726e-02, -2.362012e-02, -2.237576e-02, -2.099902e-02, -1.956252e-02, 
        -1.798387e-02, -1.623161e-02, -1.425377e-02, -1.219557e-02, -1.007178e-02, -8.158232e-03, -6.325662e-03, -4.402081e-03, 
        -2.443807e-03, -5.249522e-04, 1.116050e-03, 2.573652e-03, 3.830355e-03, 5.231720e-03, 6.668176e-03, 7.899824e-03, 
        8.566820e-03, 9.086328e-03, 9.565302e-03, 1.009236e-02, 1.041448e-02, 1.049655e-02, 1.023852e-02, 1.014630e-02, 
        1.049090e-02, 1.106715e-02, 1.201162e-02, 1.303328e-02, 1.423878e-02, 1.573134e-02, 1.754041e-02, 1.944909e-02, 
        2.130418e-02, 2.279024e-02, 2.414751e-02, 2.561326e-02, 2.707436e-02, 2.834315e-02, 2.955795e-02, 3.041365e-02, 
        3.138294e-02, 3.250166e-02, 3.341287e-02, 3.403989e-02, 3.457351e-02, 3.486614e-02, 3.486823e-02, 3.454881e-02, 
        3.386356e-02, 3.300952e-02, 3.216468e-02, 3.105147e-02, 2.995258e-02, 2.907563e-02, 2.836722e-02, 2.807916e-02, 
        2.819382e-02, 2.838264e-02, 2.874392e-02, 2.930124e-02, 3.000012e-02, 3.082115e-02, 3.160027e-02, 3.202467e-02, 
        3.221299e-02, 3.213385e-02, 3.201174e-02, 3.195233e-02, 3.182716e-02, 3.149019e-02, 3.104207e-02, 3.067949e-02, 
        3.034484e-02, 2.983977e-02, 2.880255e-02, 2.726677e-02, 2.528284e-02, 2.307693e-02, 2.086115e-02, 1.852106e-02, 
        1.601943e-02, 1.343327e-02, 1.065968e-02, 7.784080e-03, 5.057599e-03, 2.257712e-03, -5.166272e-04, -3.099734e-03, 
        -5.503263e-03, -7.692548e-03, -9.775971e-03, -1.143168e-02, -1.273145e-02, -1.379694e-02, -1.453645e-02, -1.485248e-02, 
        -1.478715e-02, -1.456329e-02, -1.416304e-02, -1.378568e-02, -1.367538e-02, -1.346707e-02, -1.338091e-02, -1.337350e-02, 
        -1.344266e-02, -1.353764e-02, -1.371793e-02, -1.369050e-02, -1.370878e-02, -1.354285e-02, -1.367127e-02, -1.380686e-02, 
        -1.389728e-02, -1.409517e-02, -1.467250e-02, -1.566821e-02, -1.688552e-02, -1.812636e-02, -1.934493e-02, -2.040972e-02, 
        -2.125185e-02, -2.191478e-02, -2.265382e-02, -2.379584e-02, -2.447061e-02, -2.483882e-02, -2.466953e-02, -2.419094e-02, 
        -2.354120e-02, -2.269191e-02, -2.169821e-02, -2.041436e-02, -1.892845e-02, -1.727855e-02, -1.540800e-02, -1.364184e-02, 
        -1.184800e-02, -1.046199e-02, -9.719390e-03, -8.879728e-03, -8.060939e-03, -7.387932e-03, -6.826069e-03, -6.333804e-03, 
        -6.051961e-03, -5.931181e-03, -5.879742e-03, -6.004457e-03, -6.466059e-03, -7.343483e-03, -8.425080e-03, -9.639188e-03, 
        -1.103471e-02, -1.231647e-02, -1.353618e-02, -1.470765e-02, -1.584574e-02, -1.708902e-02, -1.832268e-02, -1.910493e-02, 
        -1.925496e-02, -1.898867e-02, -1.843157e-02, -1.736933e-02, -1.577318e-02, -1.370763e-02, -1.132518e-02, -8.694927e-03, 
        -5.833429e-03, -2.880202e-03, 1.200538e-04, 3.182671e-03, 6.302583e-03, 9.494026e-03, 1.294633e-02, 1.644557e-02, 
        1.981930e-02, 2.316515e-02, 2.634589e-02, 2.937961e-02, 3.235725e-02, 3.509975e-02, 3.762362e-02, 4.001504e-02, 
        4.158814e-02, 4.258871e-02, 4.334019e-02, 4.405809e-02, 4.443160e-02, 4.448508e-02, 4.444019e-02, 4.393559e-02, 
        4.338478e-02, 4.269724e-02, 4.207625e-02, 4.169790e-02, 4.121821e-02, 4.074979e-02, 4.020284e-02, 3.948899e-02, 
        3.893418e-02, 3.868117e-02, 3.893758e-02, 3.943516e-02, 3.980624e-02, 4.027181e-02, 4.080484e-02, 4.131376e-02, 
        4.164916e-02, 4.183542e-02, 4.159049e-02, 4.116916e-02, 4.056963e-02, 3.999757e-02, 3.944882e-02, 3.891403e-02, 
        3.807400e-02, 3.720542e-02, 3.616425e-02, 3.469979e-02, 3.260476e-02, 3.017073e-02, 2.754672e-02, 2.477863e-02, 
        2.195307e-02, 1.907490e-02, 1.629220e-02, 1.371438e-02, 1.123741e-02, 9.049839e-03, 7.219714e-03, 5.585377e-03, 
        3.969487e-03, 2.484008e-03, 8.596376e-04, -5.845881e-04, -1.981340e-03, -3.207072e-03, -4.217189e-03, -5.311963e-03, 
        -6.446577e-03, -7.501763e-03, -8.535742e-03, -9.563127e-03, -1.065290e-02, -1.175375e-02, -1.291877e-02, -1.412201e-02, 
        -1.544301e-02, -1.693868e-02, -1.861178e-02, -2.036392e-02, -2.227662e-02, -2.422983e-02, -2.606564e-02, -2.775785e-02, 
        -2.954101e-02, -3.116040e-02, -3.252434e-02, -3.383050e-02, -3.498702e-02, -3.587027e-02, -3.633093e-02, -3.639564e-02, 
        -3.618091e-02, -3.586866e-02, -3.559997e-02, -3.533912e-02, -3.522113e-02, -3.522200e-02, -3.540567e-02, -3.554025e-02, 
        -3.575823e-02, -3.593865e-02, -3.603758e-02, -3.603350e-02, -3.588265e-02, -3.557097e-02, -3.522465e-02, -3.501552e-02, 
        -3.505161e-02, -3.529570e-02, -3.580193e-02, -3.648309e-02, -3.721433e-02, -3.805832e-02, -3.878846e-02, -3.944967e-02, 
        -3.998897e-02, -4.028615e-02, -4.051445e-02, -4.050024e-02, -4.014576e-02, -3.959262e-02, -3.869401e-02, -3.755213e-02, 
        -3.617108e-02, -3.462522e-02, -3.303161e-02, -3.128883e-02, -2.941250e-02, -2.744797e-02, -2.531693e-02, -2.305536e-02, 
        -2.085937e-02, -1.874498e-02, -1.677514e-02, -1.508296e-02, -1.364214e-02, -1.237144e-02, -1.124997e-02, -1.046911e-02, 
        -9.808205e-03, -9.511396e-03, -9.490375e-03, -9.878623e-03, -1.065723e-02, -1.170485e-02, -1.295802e-02, -1.434085e-02, 
        -1.576909e-02, -1.729681e-02, -1.886865e-02, -2.043805e-02, -2.197814e-02, -2.342369e-02, -2.479661e-02, -2.582199e-02, 
        -2.637706e-02, -2.631817e-02, -2.577374e-02, -2.476469e-02, -2.347682e-02, -2.193465e-02, -2.036816e-02, -1.871834e-02, 
        -1.691508e-02, -1.507779e-02, -1.329426e-02, -1.154331e-02, -9.832614e-03, -8.087838e-03, -6.224715e-03, -4.325074e-03, 
        -2.329493e-03, -3.341823e-04, 1.549680e-03, 3.178575e-03, 4.457852e-03, 5.302413e-03, 5.862484e-03, 6.293863e-03, 
        6.533263e-03, 6.768137e-03, 6.924227e-03, 7.212002e-03, 7.725657e-03, 8.505379e-03, 9.444463e-03, 1.057038e-02, 
        1.193028e-02, 1.346425e-02, 1.525876e-02, 1.691790e-02, 1.866684e-02, 2.049635e-02, 2.218015e-02, 2.373882e-02, 
        2.531557e-02, 2.699776e-02, 2.875195e-02, 3.036702e-02, 3.189079e-02, 3.327291e-02, 3.447763e-02, 3.540290e-02, 
        3.607898e-02, 3.651880e-02, 3.672107e-02, 3.670173e-02, 3.634252e-02, 3.574405e-02, 3.487347e-02, 3.377866e-02, 
        3.239732e-02, 3.085258e-02, 2.919181e-02, 2.744419e-02, 2.560025e-02, 2.383301e-02, 2.204382e-02, 2.027120e-02, 
        1.866113e-02, 1.723227e-02, 1.596429e-02, 1.488236e-02, 1.413082e-02, 1.364276e-02, 1.345665e-02, 1.339082e-02, 
        1.339199e-02, 1.336845e-02, 1.334505e-02, 1.345700e-02, 1.366851e-02, 1.391576e-02, 1.421393e-02, 1.463397e-02, 
        1.518057e-02, 1.562639e-02, 1.594114e-02, 1.608331e-02, 1.614689e-02, 1.625631e-02, 1.642853e-02, 1.646063e-02, 
        1.647893e-02, 1.658519e-02, 1.673895e-02, 1.697354e-02, 1.719142e-02, 1.732659e-02, 1.746007e-02, 1.763408e-02, 
        1.779985e-02, 1.791608e-02, 1.807997e-02, 1.831716e-02, 1.863347e-02, 1.902103e-02, 1.942895e-02, 1.983889e-02, 
        2.020219e-02, 2.053772e-02, 2.089104e-02, 2.118801e-02, 2.146233e-02, 2.153422e-02, 2.140011e-02, 2.093561e-02, 
        2.026548e-02, 1.942257e-02, 1.840138e-02, 1.722718e-02, 1.609799e-02, 1.489345e-02, 1.364427e-02, 1.231308e-02, 
        1.101310e-02, 9.770681e-03, 8.442610e-03, 7.183730e-03, 5.965439e-03, 4.779826e-03, 3.802337e-03, 2.959676e-03, 
        2.220901e-03, 1.621127e-03, 1.216553e-03, 9.882911e-04, 7.562584e-04, 5.403305e-04, 2.496082e-04, -1.623190e-04, 
        -5.324524e-04, -8.451632e-04, -1.211276e-03, -1.583089e-03, -1.895811e-03, -2.109040e-03, -2.431405e-03, -2.975188e-03, 
        -3.585077e-03, -4.352275e-03, -5.128317e-03, -5.850866e-03, -6.757719e-03, -7.814969e-03, -9.050739e-03, -1.051684e-02, 
        -1.216976e-02, -1.401496e-02, -1.592177e-02, -1.802597e-02, -2.026878e-02, -2.242096e-02, -2.465691e-02, -2.685876e-02, 
        -2.900694e-02, -3.107607e-02, -3.304047e-02, -3.487575e-02, -3.665964e-02, -3.828642e-02, -3.978452e-02, -4.072626e-02, 
        -4.138006e-02, -4.170846e-02, -4.175056e-02, -4.160614e-02, -4.136515e-02, -4.109265e-02, -4.082368e-02, -4.048039e-02, 
        -4.011434e-02, -3.952376e-02, -3.882572e-02, -3.812580e-02, -3.738514e-02, -3.647261e-02, -3.553116e-02, -3.463221e-02, 
        -3.381664e-02, -3.312101e-02, -3.244309e-02, -3.185788e-02, -3.142738e-02, -3.129164e-02, -3.138592e-02, -3.153924e-02, 
        -3.167297e-02, -3.174434e-02, -3.150999e-02, -3.102688e-02, -3.028653e-02, -2.890663e-02, -2.690131e-02, -2.480032e-02, 
        -2.257537e-02, -2.016211e-02, -1.749404e-02, -1.459472e-02, -1.138792e-02, -7.915766e-03, -4.100576e-03, -9.188738e-17
    },
    {
        0.000000e+00, 1.775357e-01, 7.979680e-02, 1.352792e-02, -4.181026e-02, -8.132769e-02, -9.404215e-02, -9.455916e-02, 
        -8.989608e-02, -7.985256e-02, -6.352006e-02, -4.249475e-02, -2.158452e-02, -2.144340e-03, 1.387942e-02, 2.614182e-02, 
        3.623704e-02, 4.952434e-02, 6.440980e-02, 7.656527e-02, 8.532643e-02, 9.006238e-02, 8.925514e-02, 8.553569e-02, 
        8.001661e-02, 7.234274e-02, 6.292727e-02, 5.081386e-02, 3.455084e-02, 1.628341e-02, -9.577941e-04, -1.710321e-02, 
        -3.364821e-02, -4.937845e-02, -6.160547e-02, -7.215006e-02, -7.944840e-02, -8.551187e-02, -8.850542e-02, -8.786581e-02, 
        -8.574996e-02, -8.164471e-02, -7.543580e-02, -6.745867e-02, -5.972414e-02, -5.113554e-02, -4.158569e-02, -3.217542e-02, 
        -2.235508e-02, -1.259558e-02, -4.125795e-03, 4.980666e-03, 1.542817e-02, 2.425986e-02, 3.323126e-02, 4.138104e-02, 
        4.786503e-02, 5.384034e-02, 5.833674e-02, 5.985009e-02, 6.008450e-02, 5.856717e-02, 5.535562e-02, 5.217350e-02, 
        4.939453e-02, 4.647304e-02, 4.302402e-02, 3.869665e-02, 3.376300e-02, 2.895096e-02, 2.508852e-02, 2.138382e-02, 
        1.790209e-02, 1.397248e-02, 1.085247e-02, 7.112188e-03, 4.141784e-03, 1.008189e-03, -1.734751e-03, -4.170502e-03, 
        -5.749999e-03, -6.565894e-03, -8.863328e-03, -1.047774e-02, -1.134416e-02, -1.237537e-02, -1.359732e-02, -1.499437e-02, 
        -1.656193e-02, -1.875878e-02, -2.116694e-02, -2.377183e-02, -2.583156e-02, -2.972528e-02, -3.352681e-02, -3.652694e-02, 
        -3.924507e-02, -4.137043e-02, -4.400875e-02, -4.597247e-02, -4.615330e-02, -4.443518e-02, -4.269496e-02, -3.992261e-02, 
        -3.606324e-02, -3.078620e-02, -2.500238e-02, -1.934453e-02, -1.294978e-02, -5.985306e-03, 6.514435e-04, 7.523569e-03, 
        1.469514e-02, 2.019589e-02, 2.646191e-02, 3.300599e-02, 3.863131e-02, 4.337335e-02, 4.811716e-02, 5.140081e-02, 
        5.356248e-02, 5.459523e-02, 5.348807e-02, 5.220604e-02, 4.915858e-02, 4.542092e-02, 4.126595e-02, 3.610679e-02, 
        3.093757e-02, 2.501628e-02, 1.937139e-02, 1.391436e-02, 8.183900e-03, 3.182525e-03, -1.561228e-03, -6.152567e-03, 
        -1.003398e-02, -1.312406e-02, -1.580312e-02, -1.801383e-02, -1.940371e-02, -2.016203e-02, -2.105435e-02, -2.114119e-02, 
        -2.037169e-02, -1.994137e-02, -1.934457e-02, -1.869300e-02, -1.806662e-02, -1.770362e-02, -1.741813e-02, -1.694187e-02, 
        -1.680878e-02, -1.744478e-02, -1.743596e-02, -1.789348e-02, -1.848119e-02, -1.931411e-02, -2.069512e-02, -2.212333e-02, 
        -2.299142e-02, -2.329873e-02, -2.367479e-02, -2.315248e-02, -2.254663e-02, -2.116020e-02, -1.878980e-02, -1.636173e-02, 
        -1.359265e-02, -1.084110e-02, -7.631074e-03, -4.656106e-03, -2.122915e-03, 8.894334e-04, 4.645573e-03, 8.285496e-03, 
        1.132095e-02, 1.480997e-02, 1.825488e-02, 2.156204e-02, 2.443520e-02, 2.778102e-02, 3.067893e-02, 3.261212e-02, 
        3.396389e-02, 3.433366e-02, 3.416079e-02, 3.297483e-02, 3.162678e-02, 2.971160e-02, 2.783266e-02, 2.509069e-02, 
        2.207689e-02, 1.883806e-02, 1.577284e-02, 1.242304e-02, 8.554981e-03, 4.585555e-03, 6.295037e-04, -3.454476e-03, 
        -7.768312e-03, -1.168489e-02, -1.528311e-02, -1.806253e-02, -1.981329e-02, -2.133462e-02, -2.190818e-02, -2.226976e-02, 
        -2.224323e-02, -2.247921e-02, -2.243741e-02, -2.190444e-02, -2.096512e-02, -1.985596e-02, -1.875623e-02, -1.726679e-02, 
        -1.558051e-02, -1.292094e-02, -1.037565e-02, -8.147544e-03, -6.437165e-03, -5.227895e-03, -4.158536e-03, -3.732459e-03, 
        -3.722019e-03, -4.418284e-03, -5.350611e-03, -6.384840e-03, -7.369892e-03, -8.086721e-03, -8.829875e-03, -9.976483e-03, 
        -1.128610e-02, -1.227019e-02, -1.288059e-02, -1.316039e-02, -1.299378e-02, -1.232223e-02, -1.129450e-02, -1.033996e-02, 
        -8.544031e-03, -6.416954e-03, -3.781462e-03, -5.711857e-04, 3.006480e-03, 6.724098e-03, 1.076401e-02, 1.491517e-02, 
        1.895882e-02, 2.256829e-02, 2.590205e-02, 2.861946e-02, 3.150810e-02, 3.415531e-02, 3.629499e-02, 3.811590e-02, 
        3.945154e-02, 4.027185e-02, 4.107981e-02, 4.160502e-02, 4.122586e-02, 3.995920e-02, 3.781511e-02, 3.466041e-02, 
        3.106434e-02, 2.731750e-02, 2.336091e-02, 1.926572e-02, 1.498141e-02, 1.066941e-02, 6.827950e-03, 3.929504e-03, 
        1.759070e-03, 5.049203e-06, -1.236753e-03, -2.031242e-03, -3.023990e-03, -3.997621e-03, -4.846515e-03, -5.539956e-03, 
        -5.614635e-03, -5.390870e-03, -5.293738e-03, -4.959130e-03, -4.652576e-03, -4.340632e-03, -4.029976e-03, -3.551811e-03, 
        -2.873659e-03, -2.737576e-03, -3.096771e-03, -3.675966e-03, -4.912411e-03, -6.339363e-03, -8.262740e-03, -1.008501e-02, 
        -1.186835e-02, -1.416567e-02, -1.651681e-02, -1.885461e-02, -2.101977e-02, -2.302081e-02, -2.520444e-02, -2.701756e-02, 
        -2.872377e-02, -2.963996e-02, -3.049702e-02, -3.142430e-02, -3.186568e-02, -3.136799e-02, -3.013262e-02, -2.838334e-02, 
        -2.608881e-02, -2.367548e-02, -2.104875e-02, -1.850133e-02, -1.626662e-02, -1.424306e-02, -1.216910e-02, -1.007748e-02, 
        -8.601265e-03, -7.327093e-03, -6.156899e-03, -5.263699e-03, -4.500261e-03, -3.868689e-03, -3.471726e-03, -3.621955e-03, 
        -4.361121e-03, -5.825650e-03, -7.523705e-03, -9.524831e-03, -1.113932e-02, -1.300857e-02, -1.443190e-02, -1.598567e-02, 
        -1.755453e-02, -1.858104e-02, -1.876336e-02, -1.890419e-02, -1.853937e-02, -1.717003e-02, -1.518982e-02, -1.340745e-02, 
        -1.166089e-02, -9.369656e-03, -6.375983e-03, -3.794227e-03, -9.063803e-04, 2.630407e-03, 5.814687e-03, 8.457891e-03, 
        1.113809e-02, 1.383462e-02, 1.630567e-02, 1.795249e-02, 1.923565e-02, 2.063875e-02, 2.170862e-02, 2.202251e-02, 
        2.190855e-02, 2.131468e-02, 2.012651e-02, 1.837314e-02, 1.611885e-02, 1.369061e-02, 1.112773e-02, 8.527285e-03, 
        6.354191e-03, 4.498634e-03, 3.205042e-03, 2.104224e-03, 1.452466e-03, 1.030718e-03, 8.000544e-04, 8.816518e-04, 
        1.198639e-03, 1.529135e-03, 2.624371e-03, 4.219281e-03, 5.570242e-03, 6.871363e-03, 8.345820e-03, 9.974319e-03, 
        1.168317e-02, 1.370895e-02, 1.566419e-02, 1.728765e-02, 1.910706e-02, 2.073761e-02, 2.189938e-02, 2.300193e-02, 
        2.397654e-02, 2.428721e-02, 2.408840e-02, 2.403179e-02, 2.375233e-02, 2.336199e-02, 2.326847e-02, 2.302351e-02, 
        2.278487e-02, 2.246375e-02, 2.221760e-02, 2.205809e-02, 2.194189e-02, 2.205544e-02, 2.226019e-02, 2.240831e-02, 
        2.316443e-02, 2.446934e-02, 2.578075e-02, 2.708407e-02, 2.885995e-02, 3.097414e-02, 3.285330e-02, 3.454499e-02, 
        3.600295e-02, 3.718985e-02, 3.845224e-02, 3.961443e-02, 4.031147e-02, 4.055667e-02, 4.062118e-02, 4.058071e-02, 
        4.039952e-02, 3.970058e-02, 3.854700e-02, 3.684086e-02, 3.427955e-02, 3.125401e-02, 2.787866e-02, 2.395604e-02, 
        1.942683e-02, 1.482693e-02, 1.048785e-02, 6.045669e-03, 1.982673e-03, -1.302004e-03, -3.899580e-03, -5.886104e-03, 
        -7.842257e-03, -9.674443e-03, -1.105018e-02, -1.237017e-02, -1.361624e-02, -1.502766e-02, -1.603838e-02, -1.661329e-02, 
        -1.706196e-02, -1.710428e-02, -1.716246e-02, -1.704844e-02, -1.664906e-02, -1.602535e-02, -1.540476e-02, -1.505375e-02, 
        -1.475886e-02, -1.478372e-02, -1.529264e-02, -1.635865e-02, -1.777904e-02, -1.943414e-02, -2.142450e-02, -2.368372e-02, 
        -2.625104e-02, -2.898016e-02, -3.201301e-02, -3.513431e-02, -3.830305e-02, -4.121431e-02, -4.401926e-02, -4.682618e-02, 
        -4.941242e-02, -5.210793e-02, -5.493625e-02, -5.790831e-02, -6.089795e-02, -6.379123e-02, -6.650859e-02, -6.910548e-02, 
        -7.126689e-02, -7.298534e-02, -7.419012e-02, -7.499471e-02, -7.476631e-02, -7.414241e-02, -7.328070e-02, -7.232296e-02, 
        -7.106393e-02, -6.968162e-02, -6.801872e-02, -6.629371e-02, -6.421620e-02, -6.203182e-02, -5.979665e-02, -5.726520e-02, 
        -5.468427e-02, -5.205914e-02, -4.954892e-02, -4.721034e-02, -4.493305e-02, -4.271330e-02, -4.077976e-02, -3.902642e-02, 
        -3.774334e-02, -3.660856e-02, -3.561699e-02, -3.464784e-02, -3.360078e-02, -3.245776e-02, -3.106918e-02, -2.941113e-02, 
        -2.756369e-02, -2.518323e-02, -2.236100e-02, -1.906614e-02, -1.513502e-02, -1.066250e-02, -5.681722e-03, -3.627199e-04, 
        4.849522e-03, 9.939384e-03, 1.493057e-02, 1.974156e-02, 2.450762e-02, 2.918955e-02, 3.348365e-02, 3.766386e-02, 
        4.191393e-02, 4.577118e-02, 4.961030e-02, 5.326948e-02, 5.665471e-02, 5.960551e-02, 6.212528e-02, 6.362037e-02, 
        6.463237e-02, 6.510611e-02, 6.501099e-02, 6.478102e-02, 6.437586e-02, 6.401700e-02, 6.395799e-02, 6.448419e-02, 
        6.546915e-02, 6.707784e-02, 6.892822e-02, 7.064042e-02, 7.225311e-02, 7.377380e-02, 7.524948e-02, 7.637023e-02, 
        7.737744e-02, 7.797798e-02, 7.851166e-02, 7.888344e-02, 7.909658e-02, 7.911198e-02, 7.878248e-02, 7.778447e-02, 
        7.639693e-02, 7.467471e-02, 7.215210e-02, 6.866437e-02, 6.455535e-02, 5.989722e-02, 5.492741e-02, 4.986163e-02, 
        4.466924e-02, 3.919746e-02, 3.343930e-02, 2.759372e-02, 2.154575e-02, 1.548573e-02, 9.867207e-03, 4.594771e-03, 
        -4.861828e-04, -5.317351e-03, -9.733447e-03, -1.373598e-02, -1.712451e-02, -1.994701e-02, -2.240120e-02, -2.426787e-02, 
        -2.553491e-02, -2.681574e-02, -2.795392e-02, -2.874376e-02, -2.909890e-02, -2.966294e-02, -3.030858e-02, -3.103860e-02, 
        -3.196441e-02, -3.287562e-02, -3.385058e-02, -3.484905e-02, -3.569129e-02, -3.637912e-02, -3.649371e-02, -3.642645e-02, 
        -3.634688e-02, -3.652791e-02, -3.765951e-02, -3.941217e-02, -4.160522e-02, -4.403155e-02, -4.650886e-02, -4.882421e-02, 
        -5.100350e-02, -5.296732e-02, -5.371197e-02, -5.339855e-02, -5.269341e-02, -5.153556e-02, -4.975909e-02, -4.759429e-02, 
        -4.500084e-02, -4.201360e-02, -3.873806e-02, -3.510419e-02, -3.104240e-02, -2.663765e-02, -2.225724e-02, -1.802804e-02, 
        -1.384412e-02, -9.820509e-03, -5.050622e-03, -4.289706e-04, 4.052347e-03, 8.205976e-03, 1.192988e-02, 1.524583e-02, 
        1.807433e-02, 2.038908e-02, 2.202368e-02, 2.313006e-02, 2.338327e-02, 2.299727e-02, 2.193849e-02, 2.026913e-02, 
        1.817884e-02, 1.570489e-02, 1.309728e-02, 1.032596e-02, 7.360666e-03, 4.936064e-03, 3.377962e-03, 2.120746e-03, 
        1.173231e-03, 8.454707e-04, 1.201537e-03, 2.048667e-03, 3.265170e-03, 4.649957e-03, 6.221985e-03, 7.788325e-03, 
        9.483841e-03, 1.107598e-02, 1.252047e-02, 1.402649e-02, 1.551110e-02, 1.708970e-02, 1.877187e-02, 2.067124e-02, 
        2.263600e-02, 2.437845e-02, 2.573648e-02, 2.668888e-02, 2.715850e-02, 2.706352e-02, 2.640040e-02, 2.515413e-02, 
        2.428459e-02, 2.305134e-02, 2.144984e-02, 1.924720e-02, 1.642339e-02, 1.321792e-02, 9.807667e-03, 6.797553e-03, 
        3.735818e-03, 7.514496e-04, -2.166591e-03, -4.979942e-03, -7.600587e-03, -9.896762e-03, -1.157031e-02, -1.263526e-02, 
        -1.341388e-02, -1.373675e-02, -1.361667e-02, -1.293288e-02, -1.186383e-02, -1.051878e-02, -8.980802e-03, -7.485443e-03, 
        -6.153049e-03, -5.251272e-03, -4.228142e-03, -3.160194e-03, -2.085850e-03, -1.061451e-03, 1.950122e-04, 1.459818e-03, 
        2.644450e-03, 3.392209e-03, 3.663072e-03, 3.417374e-03, 3.087652e-03, 2.184496e-03, 9.372766e-04, -7.760320e-04, 
        -2.820221e-03, -5.122270e-03, -7.301273e-03, -9.263047e-03, -1.080978e-02, -1.194177e-02, -1.257250e-02, -1.309406e-02, 
        -1.360562e-02, -1.414431e-02, -1.414208e-02, -1.386393e-02, -1.342487e-02, -1.288935e-02, -1.209866e-02, -1.123930e-02, 
        -1.027309e-02, -9.341628e-03, -8.439419e-03, -7.611592e-03, -6.857919e-03, -6.202253e-03, -5.447803e-03, -4.974656e-03, 
        -4.786738e-03, -4.817972e-03, -5.098632e-03, -5.534286e-03, -6.200894e-03, -6.997894e-03, -7.957233e-03, -8.975942e-03, 
        -9.901044e-03, -1.069107e-02, -1.110689e-02, -1.127027e-02, -1.109272e-02, -1.050726e-02, -9.507492e-03, -8.115713e-03, 
        -6.430399e-03, -4.421938e-03, -2.272362e-03, -1.816417e-04, 2.030257e-03, 4.134755e-03, 6.023023e-03, 7.810538e-03, 
        9.156440e-03, 1.024259e-02, 1.111831e-02, 1.189350e-02, 1.259942e-02, 1.310139e-02, 1.327879e-02, 1.315171e-02, 
        1.252567e-02, 1.112800e-02, 8.994592e-03, 6.421979e-03, 3.538716e-03, 3.993954e-04, -2.835571e-03, -6.087859e-03, 
        -9.221628e-03, -1.197625e-02, -1.434723e-02, -1.632804e-02, -1.784148e-02, -1.888035e-02, -1.948038e-02, -1.954604e-02, 
        -1.911668e-02, -1.829814e-02, -1.730183e-02, -1.598150e-02, -1.446889e-02, -1.274503e-02, -1.078627e-02, -8.696629e-03, 
        -6.663931e-03, -4.758186e-03, -2.985306e-03, -1.346903e-03, 1.714629e-04, 1.503688e-03, 2.620473e-03, 3.419879e-03, 
        3.913133e-03, 3.983803e-03, 3.627704e-03, 2.761205e-03, 1.373365e-03, -7.614991e-04, -3.359978e-03, -6.327332e-03, 
        -9.489271e-03, -1.285245e-02, -1.628861e-02, -1.966313e-02, -2.305150e-02, -2.635355e-02, -2.939505e-02, -3.182279e-02, 
        -3.366256e-02, -3.428710e-02, -3.390725e-02, -3.269257e-02, -3.094919e-02, -2.875207e-02, -2.632205e-02, -2.374175e-02, 
        -2.108559e-02, -1.842597e-02, -1.582152e-02, -1.321845e-02, -1.054523e-02, -7.588319e-03, -4.343790e-03, -1.007493e-03, 
        2.452652e-03, 5.753544e-03, 8.825611e-03, 1.144666e-02, 1.342857e-02, 1.460600e-02, 1.527906e-02, 1.564168e-02, 
        1.556156e-02, 1.525283e-02, 1.497526e-02, 1.477464e-02, 1.477853e-02, 1.529520e-02, 1.616800e-02, 1.737829e-02, 
        1.898786e-02, 2.082708e-02, 2.292831e-02, 2.539158e-02, 2.815409e-02, 3.113407e-02, 3.422539e-02, 3.734651e-02, 
        4.054805e-02, 4.381825e-02, 4.694746e-02, 4.979756e-02, 5.248548e-02, 5.485682e-02, 5.697983e-02, 5.879039e-02, 
        6.025996e-02, 6.138572e-02, 6.213849e-02, 6.254298e-02, 6.213726e-02, 6.111987e-02, 5.961144e-02, 5.760319e-02, 
        5.506664e-02, 5.217947e-02, 4.898028e-02, 4.545073e-02, 4.171353e-02, 3.784315e-02, 3.368698e-02, 2.941330e-02, 
        2.514378e-02, 2.112067e-02, 1.730015e-02, 1.380694e-02, 1.074233e-02, 8.111265e-03, 5.932291e-03, 3.967943e-03, 
        2.124484e-03, 2.590918e-04, -1.614750e-03, -3.221389e-03, -4.685661e-03, -5.996490e-03, -7.168788e-03, -8.353833e-03, 
        -9.407996e-03, -1.060870e-02, -1.197320e-02, -1.347213e-02, -1.502766e-02, -1.650786e-02, -1.807159e-02, -1.972657e-02, 
        -2.140553e-02, -2.310271e-02, -2.455948e-02, -2.595821e-02, -2.726262e-02, -2.829948e-02, -2.929560e-02, -3.016580e-02, 
        -3.104933e-02, -3.194615e-02, -3.275305e-02, -3.329386e-02, -3.348462e-02, -3.323642e-02, -3.268994e-02, -3.197261e-02, 
        -3.115347e-02, -3.014446e-02, -2.882002e-02, -2.734648e-02, -2.583023e-02, -2.425473e-02, -2.271960e-02, -2.135692e-02, 
        -2.021249e-02, -1.921181e-02, -1.840541e-02, -1.780193e-02, -1.708260e-02, -1.653625e-02, -1.605120e-02, -1.573433e-02, 
        -1.542857e-02, -1.488292e-02, -1.426872e-02, -1.356561e-02, -1.284821e-02, -1.216225e-02, -1.119633e-02, -1.033367e-02, 
        -9.469171e-03, -8.475329e-03, -7.252268e-03, -5.751224e-03, -4.212961e-03, -2.722542e-03, -1.440589e-03, -4.467704e-04, 
        6.579989e-04, 1.813995e-03, 2.956321e-03, 4.202859e-03, 5.523915e-03, 6.832496e-03, 7.916275e-03, 8.690821e-03, 
        9.389211e-03, 9.914250e-03, 1.047504e-02, 1.115510e-02, 1.163301e-02, 1.186959e-02, 1.178835e-02, 1.136925e-02, 
        1.073839e-02, 9.806369e-03, 8.580976e-03, 7.023311e-03, 5.227929e-03, 3.581448e-03, 1.674001e-03, -2.985087e-04, 
        -2.187038e-03, -3.948673e-03, -5.603546e-03, -7.083235e-03, -8.440955e-03, -9.694266e-03, -1.092461e-02, -1.151291e-02, 
        -1.176717e-02, -1.150360e-02, -1.078362e-02, -9.779732e-03, -8.650834e-03, -7.540768e-03, -6.564140e-03, -5.746833e-03, 
        -5.044707e-03, -4.079054e-03, -2.880693e-03, -1.766820e-03, -7.531407e-04, 1.536002e-04, 9.972695e-04, 1.514170e-03, 
        1.794759e-03, 1.766574e-03, 1.399637e-03, 7.233265e-04, -3.432990e-04, -1.971344e-03, -4.029041e-03, -6.459820e-03, 
        -8.946882e-03, -1.117553e-02, -1.336150e-02, -1.533071e-02, -1.677262e-02, -1.736740e-02, -1.696338e-02, -1.647855e-02, 
        -1.588990e-02, -1.499175e-02, -1.364992e-02, -1.191554e-02, -9.664514e-03, -6.972047e-03, -3.712297e-03, 1.604006e-16
    },
    {
        0.000000e+00, 2.038977e-01, 5.986865e-02, -2.943833e-02, -7.799666e-02, -9.455111e-02, -9.181085e-02, -8.392553e-02, 
        -7.199876e-02, -5.644654e-02, -3.877417e-02, -1.894875e-02, 1.009213e-03, 1.790310e-02, 3.261412e-02, 4.651401e-02, 
        5.801635e-02, 6.683222e-02, 7.214600e-02, 7.485705e-02, 7.358793e-02, 6.958921e-02, 6.187436e-02, 5.197944e-02, 
        3.971716e-02, 2.704245e-02, 1.407361e-02, 1.397047e-03, -9.703171e-03, -1.932254e-02, -2.683198e-02, -3.274516e-02, 
        -3.789992e-02, -4.282698e-02, -4.668334e-02, -4.931934e-02, -5.059847e-02, -5.211500e-02, -5.158548e-02, -4.862963e-02, 
        -4.493928e-02, -4.019584e-02, -3.521807e-02, -2.887773e-02, -2.261393e-02, -1.728430e-02, -1.101569e-02, -4.683203e-03, 
        1.118357e-03, 7.670594e-03, 1.411585e-02, 1.895433e-02, 2.304213e-02, 2.609218e-02, 2.919360e-02, 3.087543e-02, 
        3.124964e-02, 3.164525e-02, 3.109008e-02, 3.038019e-02, 3.022243e-02, 3.008269e-02, 2.843726e-02, 2.660720e-02, 
        2.479568e-02, 2.230414e-02, 1.947827e-02, 1.670303e-02, 1.323369e-02, 9.039395e-03, 5.287494e-03, 1.356397e-03, 
        -2.354074e-03, -6.225131e-03, -9.184846e-03, -1.151499e-02, -1.356011e-02, -1.546715e-02, -1.719785e-02, -1.903340e-02, 
        -2.042553e-02, -2.092884e-02, -2.167044e-02, -2.157935e-02, -2.112037e-02, -2.044625e-02, -1.954117e-02, -1.821105e-02, 
        -1.605512e-02, -1.398371e-02, -1.200372e-02, -9.451352e-03, -6.988076e-03, -4.615986e-03, -2.342345e-03, 1.613535e-04, 
        2.904732e-03, 4.932203e-03, 6.368238e-03, 7.562709e-03, 9.143085e-03, 1.008219e-02, 1.080866e-02, 1.151120e-02, 
        1.251888e-02, 1.319438e-02, 1.336476e-02, 1.308933e-02, 1.267152e-02, 1.174073e-02, 1.118541e-02, 1.032100e-02, 
        9.654384e-03, 8.508705e-03, 7.499380e-03, 6.289018e-03, 4.965812e-03, 3.897420e-03, 2.870485e-03, 1.839803e-03, 
        1.197311e-03, 3.646383e-04, -1.088043e-04, -1.641654e-03, -2.939876e-03, -4.559207e-03, -6.083721e-03, -7.883860e-03, 
        -1.042554e-02, -1.267706e-02, -1.501106e-02, -1.577742e-02, -1.642432e-02, -1.637608e-02, -1.584167e-02, -1.460733e-02, 
        -1.253995e-02, -1.029386e-02, -7.819679e-03, -5.157811e-03, -2.415107e-03, 1.666464e-04, 2.251748e-03, 4.320920e-03, 
        6.234691e-03, 7.793974e-03, 9.442236e-03, 1.080505e-02, 1.236911e-02, 1.337776e-02, 1.377380e-02, 1.412727e-02, 
        1.386806e-02, 1.331523e-02, 1.270956e-02, 1.149312e-02, 1.025597e-02, 8.388563e-03, 6.375204e-03, 3.815845e-03, 
        1.012968e-03, -1.399721e-03, -3.834535e-03, -6.341051e-03, -7.555108e-03, -8.631437e-03, -9.460954e-03, -1.000364e-02, 
        -1.074642e-02, -1.168537e-02, -1.193079e-02, -1.182945e-02, -1.195279e-02, -1.132751e-02, -1.085958e-02, -9.892540e-03, 
        -8.961343e-03, -7.922163e-03, -6.631306e-03, -4.882750e-03, -3.767355e-03, -2.535538e-03, -1.054977e-03, -2.860438e-05, 
        5.330343e-04, 1.292331e-03, 1.433929e-03, 1.731070e-03, 2.259687e-03, 2.852055e-03, 2.403100e-03, 1.752836e-03, 
        4.696530e-04, -1.098445e-03, -2.427891e-03, -2.971284e-03, -3.481177e-03, -4.161724e-03, -3.073227e-03, -2.428219e-03, 
        -1.484795e-03, -8.435546e-04, -3.580265e-04, 1.018132e-05, 1.240260e-03, 3.431439e-03, 5.212790e-03, 7.105515e-03, 
        9.362173e-03, 1.160303e-02, 1.368285e-02, 1.625282e-02, 1.966779e-02, 2.221942e-02, 2.447969e-02, 2.651007e-02, 
        2.855703e-02, 3.070740e-02, 3.202880e-02, 3.379481e-02, 3.485243e-02, 3.496797e-02, 3.460821e-02, 3.433300e-02, 
        3.361378e-02, 3.179794e-02, 2.918193e-02, 2.663118e-02, 2.328188e-02, 1.964777e-02, 1.595553e-02, 1.204813e-02, 
        7.612108e-03, 2.669550e-03, -2.293426e-03, -6.832927e-03, -1.186429e-02, -1.712440e-02, -2.201673e-02, -2.599345e-02, 
        -2.957282e-02, -3.361600e-02, -3.744508e-02, -3.962718e-02, -4.222042e-02, -4.502838e-02, -4.789559e-02, -4.996224e-02, 
        -5.196838e-02, -5.421404e-02, -5.678315e-02, -5.764661e-02, -5.799532e-02, -5.869838e-02, -5.931909e-02, -5.932131e-02, 
        -5.875619e-02, -5.790336e-02, -5.684888e-02, -5.537023e-02, -5.258649e-02, -5.004176e-02, -4.763360e-02, -4.517555e-02, 
        -4.185483e-02, -3.785347e-02, -3.337568e-02, -2.899931e-02, -2.452926e-02, -1.914155e-02, -1.346341e-02, -7.615584e-03, 
        -1.541612e-03, 5.020995e-03, 1.176112e-02, 1.802937e-02, 2.344018e-02, 2.861669e-02, 3.380264e-02, 3.889844e-02, 
        4.339233e-02, 4.731591e-02, 5.146970e-02, 5.537960e-02, 5.839466e-02, 6.065892e-02, 6.231486e-02, 6.378404e-02, 
        6.523854e-02, 6.607171e-02, 6.599560e-02, 6.527617e-02, 6.461802e-02, 6.320286e-02, 6.117599e-02, 5.881066e-02, 
        5.590146e-02, 5.301861e-02, 5.013788e-02, 4.702900e-02, 4.370030e-02, 3.995248e-02, 3.586635e-02, 3.153618e-02, 
        2.725323e-02, 2.291460e-02, 1.838014e-02, 1.460601e-02, 1.102648e-02, 8.120367e-03, 5.065249e-03, 1.737932e-03, 
        -1.011730e-03, -3.147316e-03, -4.481536e-03, -6.074214e-03, -7.514559e-03, -9.156324e-03, -1.037794e-02, -1.107405e-02, 
        -1.172200e-02, -1.252735e-02, -1.315486e-02, -1.272022e-02, -1.234652e-02, -1.223645e-02, -1.227328e-02, -1.235086e-02, 
        -1.277333e-02, -1.371944e-02, -1.478117e-02, -1.577827e-02, -1.730560e-02, -1.900038e-02, -2.038587e-02, -2.174282e-02, 
        -2.266705e-02, -2.333158e-02, -2.362447e-02, -2.329662e-02, -2.261270e-02, -2.224872e-02, -2.129169e-02, -2.035654e-02, 
        -1.924514e-02, -1.809091e-02, -1.676887e-02, -1.579749e-02, -1.455195e-02, -1.367036e-02, -1.293713e-02, -1.217810e-02, 
        -1.140223e-02, -1.048087e-02, -9.495843e-03, -8.751255e-03, -8.063505e-03, -7.037342e-03, -6.107426e-03, -5.328495e-03, 
        -4.449697e-03, -3.911455e-03, -3.501307e-03, -2.831702e-03, -2.412742e-03, -2.426512e-03, -2.280264e-03, -2.254412e-03, 
        -2.310929e-03, -1.822689e-03, -1.055015e-03, -3.095796e-04, 1.004677e-03, 2.104851e-03, 3.309984e-03, 4.953510e-03, 
        6.465559e-03, 7.755958e-03, 8.856977e-03, 1.001807e-02, 1.103338e-02, 1.215749e-02, 1.314452e-02, 1.380485e-02, 
        1.416623e-02, 1.468435e-02, 1.466699e-02, 1.437880e-02, 1.387350e-02, 1.273483e-02, 1.128784e-02, 1.034932e-02, 
        8.903706e-03, 7.120053e-03, 5.308982e-03, 3.312845e-03, 7.750683e-04, -1.671693e-03, -3.925227e-03, -6.748509e-03, 
        -1.007054e-02, -1.328866e-02, -1.663213e-02, -2.007830e-02, -2.329442e-02, -2.628339e-02, -2.895602e-02, -3.120966e-02, 
        -3.309309e-02, -3.483582e-02, -3.656914e-02, -3.812007e-02, -3.989632e-02, -4.157040e-02, -4.268643e-02, -4.308429e-02, 
        -4.314905e-02, -4.322757e-02, -4.281862e-02, -4.203354e-02, -4.116743e-02, -4.007474e-02, -3.883531e-02, -3.774353e-02, 
        -3.678234e-02, -3.533250e-02, -3.360346e-02, -3.176519e-02, -2.928535e-02, -2.624132e-02, -2.304734e-02, -2.001894e-02, 
        -1.712506e-02, -1.383000e-02, -1.047400e-02, -6.833856e-03, -2.938309e-03, 8.382916e-04, 4.974584e-03, 9.608949e-03, 
        1.516981e-02, 2.059556e-02, 2.563920e-02, 3.080621e-02, 3.584224e-02, 4.029793e-02, 4.446684e-02, 4.853835e-02, 
        5.248158e-02, 5.603093e-02, 5.952553e-02, 6.279237e-02, 6.560385e-02, 6.823341e-02, 7.069727e-02, 7.317271e-02, 
        7.509902e-02, 7.611028e-02, 7.630491e-02, 7.590466e-02, 7.521284e-02, 7.388243e-02, 7.185528e-02, 6.955907e-02, 
        6.667665e-02, 6.357474e-02, 6.020980e-02, 5.652693e-02, 5.274491e-02, 4.893944e-02, 4.515162e-02, 4.131544e-02, 
        3.726452e-02, 3.299605e-02, 2.885540e-02, 2.475995e-02, 2.068679e-02, 1.675184e-02, 1.320004e-02, 9.920054e-03, 
        6.617535e-03, 3.704446e-03, 9.802665e-04, -1.769586e-03, -3.985101e-03, -6.020592e-03, -7.922071e-03, -9.781234e-03, 
        -1.151929e-02, -1.278941e-02, -1.399082e-02, -1.505156e-02, -1.600855e-02, -1.702415e-02, -1.779437e-02, -1.822644e-02, 
        -1.871108e-02, -1.949713e-02, -2.045065e-02, -2.174309e-02, -2.328937e-02, -2.504176e-02, -2.692291e-02, -2.895548e-02, 
        -3.104563e-02, -3.331170e-02, -3.556487e-02, -3.782073e-02, -3.994800e-02, -4.193592e-02, -4.369154e-02, -4.495409e-02, 
        -4.600990e-02, -4.683610e-02, -4.704017e-02, -4.684475e-02, -4.634755e-02, -4.547854e-02, -4.442972e-02, -4.334853e-02, 
        -4.186357e-02, -4.037194e-02, -3.857011e-02, -3.668145e-02, -3.504295e-02, -3.350181e-02, -3.171778e-02, -2.997645e-02, 
        -2.839207e-02, -2.668402e-02, -2.491234e-02, -2.330417e-02, -2.193242e-02, -2.077107e-02, -1.994255e-02, -1.935393e-02, 
        -1.910959e-02, -1.895475e-02, -1.879883e-02, -1.872891e-02, -1.875136e-02, -1.871446e-02, -1.857140e-02, -1.825883e-02, 
        -1.767523e-02, -1.681002e-02, -1.596656e-02, -1.487790e-02, -1.344102e-02, -1.162909e-02, -9.852538e-03, -8.113489e-03, 
        -6.445951e-03, -4.641957e-03, -2.885425e-03, -1.083789e-03, 7.257122e-04, 2.550678e-03, 4.469009e-03, 6.470269e-03, 
        8.153632e-03, 9.612265e-03, 1.071153e-02, 1.152931e-02, 1.198704e-02, 1.222847e-02, 1.250427e-02, 1.286550e-02, 
        1.323518e-02, 1.352264e-02, 1.366316e-02, 1.368216e-02, 1.356630e-02, 1.348990e-02, 1.352584e-02, 1.366536e-02, 
        1.389662e-02, 1.424056e-02, 1.468941e-02, 1.525777e-02, 1.599095e-02, 1.712325e-02, 1.853401e-02, 2.015504e-02, 
        2.234412e-02, 2.463301e-02, 2.708933e-02, 2.953201e-02, 3.158713e-02, 3.339768e-02, 3.509685e-02, 3.687388e-02, 
        3.882640e-02, 4.059849e-02, 4.202608e-02, 4.339748e-02, 4.472859e-02, 4.602700e-02, 4.676366e-02, 4.696798e-02, 
        4.685429e-02, 4.655567e-02, 4.590091e-02, 4.486815e-02, 4.356470e-02, 4.214784e-02, 4.049342e-02, 3.877558e-02, 
        3.702745e-02, 3.532785e-02, 3.350575e-02, 3.150888e-02, 2.967715e-02, 2.799735e-02, 2.661135e-02, 2.535264e-02, 
        2.432964e-02, 2.326283e-02, 2.237897e-02, 2.161819e-02, 2.090879e-02, 2.010783e-02, 1.930238e-02, 1.835758e-02, 
        1.725111e-02, 1.584139e-02, 1.379933e-02, 1.157148e-02, 9.268491e-03, 6.705655e-03, 3.715205e-03, 4.107081e-04, 
        -3.087601e-03, -6.798565e-03, -1.095160e-02, -1.540491e-02, -2.002156e-02, -2.449577e-02, -2.919329e-02, -3.395445e-02, 
        -3.868531e-02, -4.353909e-02, -4.844245e-02, -5.329503e-02, -5.809130e-02, -6.290737e-02, -6.772933e-02, -7.189172e-02, 
        -7.551542e-02, -7.850489e-02, -8.063716e-02, -8.220160e-02, -8.336836e-02, -8.406753e-02, -8.441841e-02, -8.444045e-02, 
        -8.391728e-02, -8.295204e-02, -8.152658e-02, -7.973977e-02, -7.751409e-02, -7.500005e-02, -7.228445e-02, -6.906917e-02, 
        -6.537511e-02, -6.141198e-02, -5.724726e-02, -5.284759e-02, -4.848487e-02, -4.401123e-02, -3.970338e-02, -3.573580e-02, 
        -3.260237e-02, -2.964431e-02, -2.677199e-02, -2.404109e-02, -2.135362e-02, -1.888864e-02, -1.624491e-02, -1.332417e-02, 
        -1.031546e-02, -7.261665e-03, -4.268121e-03, -1.508795e-03, 1.134295e-03, 3.619571e-03, 5.828011e-03, 8.110666e-03, 
        1.040704e-02, 1.319549e-02, 1.620710e-02, 1.916553e-02, 2.209625e-02, 2.500756e-02, 2.775402e-02, 3.036326e-02, 
        3.288114e-02, 3.527847e-02, 3.786179e-02, 4.037397e-02, 4.285528e-02, 4.534341e-02, 4.758996e-02, 4.938518e-02, 
        5.116656e-02, 5.275974e-02, 5.416225e-02, 5.535033e-02, 5.590618e-02, 5.616684e-02, 5.619416e-02, 5.602111e-02, 
        5.555202e-02, 5.494568e-02, 5.425079e-02, 5.352648e-02, 5.294317e-02, 5.251581e-02, 5.223673e-02, 5.199132e-02, 
        5.166691e-02, 5.134220e-02, 5.096302e-02, 5.033949e-02, 4.969348e-02, 4.905626e-02, 4.825902e-02, 4.749799e-02, 
        4.673475e-02, 4.582434e-02, 4.472824e-02, 4.351704e-02, 4.223126e-02, 4.085643e-02, 3.937696e-02, 3.769328e-02, 
        3.580202e-02, 3.366185e-02, 3.121069e-02, 2.864057e-02, 2.601440e-02, 2.338889e-02, 2.062021e-02, 1.769810e-02, 
        1.490952e-02, 1.217546e-02, 9.358863e-03, 6.301049e-03, 3.555297e-03, 1.238527e-03, -6.116535e-04, -2.176547e-03, 
        -3.355215e-03, -4.286351e-03, -4.988579e-03, -5.747776e-03, -6.681510e-03, -7.600147e-03, -8.416422e-03, -9.151412e-03, 
        -9.772220e-03, -1.020583e-02, -1.056118e-02, -1.089222e-02, -1.116069e-02, -1.135084e-02, -1.147240e-02, -1.158118e-02, 
        -1.179887e-02, -1.230994e-02, -1.298814e-02, -1.377298e-02, -1.466114e-02, -1.544403e-02, -1.615037e-02, -1.670681e-02, 
        -1.709712e-02, -1.754141e-02, -1.800747e-02, -1.828585e-02, -1.838731e-02, -1.832312e-02, -1.813977e-02, -1.784323e-02, 
        -1.741100e-02, -1.691073e-02, -1.632508e-02, -1.554783e-02, -1.460601e-02, -1.365363e-02, -1.288288e-02, -1.231089e-02, 
        -1.190100e-02, -1.169113e-02, -1.170780e-02, -1.183701e-02, -1.194267e-02, -1.225889e-02, -1.279041e-02, -1.359520e-02, 
        -1.433554e-02, -1.504622e-02, -1.605093e-02, -1.738929e-02, -1.904751e-02, -2.101755e-02, -2.325450e-02, -2.573629e-02, 
        -2.829256e-02, -3.092450e-02, -3.360584e-02, -3.626469e-02, -3.879736e-02, -4.076347e-02, -4.205671e-02, -4.287240e-02, 
        -4.339240e-02, -4.352638e-02, -4.320936e-02, -4.234417e-02, -4.109221e-02, -3.982037e-02, -3.851914e-02, -3.699785e-02, 
        -3.534256e-02, -3.359361e-02, -3.176071e-02, -2.988578e-02, -2.780529e-02, -2.552479e-02, -2.306791e-02, -2.042006e-02, 
        -1.752280e-02, -1.463915e-02, -1.188046e-02, -9.355941e-03, -7.073806e-03, -5.058920e-03, -3.291251e-03, -1.717509e-03, 
        -2.524424e-04, 1.023075e-03, 2.260394e-03, 3.567657e-03, 5.079620e-03, 6.856197e-03, 8.699813e-03, 1.063617e-02, 
        1.267506e-02, 1.475928e-02, 1.687259e-02, 1.910209e-02, 2.126923e-02, 2.329358e-02, 2.521197e-02, 2.701610e-02, 
        2.863762e-02, 3.010457e-02, 3.123741e-02, 3.206594e-02, 3.262429e-02, 3.282690e-02, 3.267768e-02, 3.219683e-02, 
        3.132763e-02, 3.004464e-02, 2.832705e-02, 2.626040e-02, 2.379265e-02, 2.081880e-02, 1.762662e-02, 1.424133e-02, 
        1.065133e-02, 6.965864e-03, 3.232117e-03, -5.094708e-04, -4.106098e-03, -7.623158e-03, -1.100570e-02, -1.415960e-02, 
        -1.697216e-02, -1.938143e-02, -2.133751e-02, -2.265492e-02, -2.348320e-02, -2.383396e-02, -2.366856e-02, -2.325705e-02, 
        -2.271105e-02, -2.193964e-02, -2.098082e-02, -1.980062e-02, -1.843948e-02, -1.692524e-02, -1.523926e-02, -1.334551e-02, 
        -1.118717e-02, -8.944406e-03, -6.764265e-03, -4.646752e-03, -2.614082e-03, -6.296331e-04, 1.150117e-03, 2.828635e-03, 
        4.412365e-03, 5.928408e-03, 7.507944e-03, 9.290022e-03, 1.114943e-02, 1.287923e-02, 1.454201e-02, 1.611053e-02, 
        1.758332e-02, 1.898921e-02, 2.024133e-02, 2.141627e-02, 2.256373e-02, 2.373198e-02, 2.496664e-02, 2.614804e-02, 
        2.716888e-02, 2.804019e-02, 2.875792e-02, 2.945554e-02, 2.996165e-02, 3.036138e-02, 3.063906e-02, 3.067688e-02, 
        3.028947e-02, 2.953769e-02, 2.852818e-02, 2.737068e-02, 2.620999e-02, 2.488068e-02, 2.340507e-02, 2.180249e-02, 
        2.007300e-02, 1.846771e-02, 1.687297e-02, 1.529707e-02, 1.374633e-02, 1.223441e-02, 1.080189e-02, 9.363292e-03, 
        8.066254e-03, 7.057066e-03, 6.279500e-03, 5.748732e-03, 5.397326e-03, 5.210849e-03, 5.058444e-03, 5.004529e-03, 
        4.988791e-03, 4.955283e-03, 4.933273e-03, 4.963275e-03, 4.974368e-03, 5.099264e-03, 5.254558e-03, 5.312861e-03, 
        5.220178e-03, 5.047695e-03, 4.838553e-03, 4.549059e-03, 4.117503e-03, 3.671899e-03, 3.046092e-03, 2.163210e-03, 
        1.101814e-03, -7.744071e-05, -1.194064e-03, -2.514380e-03, -4.079641e-03, -5.848599e-03, -7.838580e-03, -1.010623e-02, 
        -1.239045e-02, -1.463796e-02, -1.681831e-02, -1.882169e-02, -2.062006e-02, -2.234526e-02, -2.399241e-02, -2.525671e-02, 
        -2.616381e-02, -2.677689e-02, -2.711283e-02, -2.724403e-02, -2.725471e-02, -2.720445e-02, -2.713185e-02, -2.731374e-02, 
        -2.753442e-02, -2.771595e-02, -2.758083e-02, -2.738584e-02, -2.701981e-02, -2.619481e-02, -2.531688e-02, -2.447496e-02, 
        -2.366043e-02, -2.289788e-02, -2.225163e-02, -2.187533e-02, -2.181494e-02, -2.199627e-02, -2.237662e-02, -2.311109e-02, 
        -2.399615e-02, -2.451233e-02, -2.442773e-02, -2.398563e-02, -2.323590e-02, -2.194075e-02, -2.036509e-02, -1.876638e-02, 
        -1.714303e-02, -1.538013e-02, -1.342394e-02, -1.128224e-02, -8.859936e-03, -6.198258e-03, -3.229861e-03, -1.215553e-16
    },
    {
        0.000000e+00, -4.426256e-01, -9.788617e-02, 1.103052e-01, 2.074472e-01, 2.236316e-01, 1.905781e-01, 1.553585e-01, 
        1.162719e-01, 7.326630e-02, 2.565355e-02, -2.661771e-02, -7.898507e-02, -1.232298e-01, -1.535677e-01, -1.707928e-01, 
        -1.718427e-01, -1.543418e-01, -1.242447e-01, -8.760311e-02, -4.904209e-02, -1.852978e-02, 5.422101e-03, 2.645649e-02, 
        4.626530e-02, 6.276776e-02, 7.470737e-02, 7.947473e-02, 7.874632e-02, 7.476442e-02, 6.710252e-02, 5.668877e-02, 
        4.690894e-02, 3.583451e-02, 2.376012e-02, 1.339382e-02, 3.719670e-03, -2.079770e-03, -3.446964e-03, -2.730284e-03, 
        1.204935e-03, 4.354620e-03, 7.186059e-03, 8.658222e-03, 9.326182e-03, 7.479452e-03, 9.300147e-04, -7.350316e-03, 
        -1.560447e-02, -2.437501e-02, -3.139798e-02, -3.580118e-02, -3.681373e-02, -3.280146e-02, -2.755347e-02, -2.027133e-02, 
        -1.204846e-02, -4.985635e-03, 1.326156e-03, 7.075843e-03, 1.094889e-02, 9.658565e-03, 8.698411e-03, 8.313470e-03, 
        7.450266e-03, 6.850333e-03, 6.251132e-03, 4.996391e-03, 2.673786e-03, 6.534366e-04, -1.342255e-03, -3.754922e-03, 
        -7.308775e-03, -9.656508e-03, -1.154943e-02, -1.340400e-02, -1.549289e-02, -1.689364e-02, -1.784053e-02, -1.864461e-02, 
        -1.790010e-02, -1.531855e-02, -1.206865e-02, -9.881805e-03, -5.823708e-03, -1.604496e-03, 1.683076e-03, 5.385228e-03, 
        8.287201e-03, 1.130908e-02, 1.484023e-02, 1.658365e-02, 1.917724e-02, 2.101180e-02, 2.081750e-02, 2.011015e-02, 
        1.746059e-02, 1.414899e-02, 1.046083e-02, 5.986478e-03, 1.928149e-03, -8.264124e-04, -3.367271e-03, -5.848097e-03, 
        -7.483155e-03, -8.553182e-03, -8.197007e-03, -8.442523e-03, -7.854757e-03, -6.368900e-03, -3.748691e-03, -1.691001e-03, 
        7.225895e-04, 2.886092e-03, 5.741766e-03, 8.288244e-03, 1.017717e-02, 1.150823e-02, 1.195427e-02, 1.274806e-02, 
        1.227997e-02, 1.115023e-02, 9.023154e-03, 6.439063e-03, 4.560128e-03, 2.083562e-03, -1.255635e-03, -5.060332e-03, 
        -8.679987e-03, -1.290611e-02, -1.681560e-02, -2.084523e-02, -2.492939e-02, -2.789864e-02, -2.882802e-02, -2.912818e-02, 
        -2.756511e-02, -2.559286e-02, -2.262439e-02, -1.854269e-02, -1.365014e-02, -9.728028e-03, -5.351973e-03, 1.151219e-05, 
        6.367849e-03, 1.130888e-02, 1.637912e-02, 2.062565e-02, 2.460765e-02, 2.775190e-02, 3.047390e-02, 3.243981e-02, 
        3.265326e-02, 3.152360e-02, 2.963271e-02, 2.767579e-02, 2.551175e-02, 2.312655e-02, 2.055888e-02, 1.765303e-02, 
        1.522919e-02, 1.197632e-02, 9.233995e-03, 6.499312e-03, 4.264982e-03, 2.984319e-03, 1.050249e-03, -1.987282e-04, 
        -1.507741e-03, -2.796039e-03, -4.056193e-03, -4.976315e-03, -5.481622e-03, -6.175870e-03, -6.526531e-03, -6.919749e-03, 
        -7.450196e-03, -7.121866e-03, -6.505571e-03, -6.143038e-03, -5.438646e-03, -5.219527e-03, -4.999457e-03, -4.246250e-03, 
        -3.941065e-03, -3.994740e-03, -4.182282e-03, -3.993894e-03, -3.789955e-03, -3.646234e-03, -4.460992e-03, -5.310140e-03, 
        -6.485153e-03, -7.686435e-03, -8.934210e-03, -1.057511e-02, -1.211719e-02, -1.315324e-02, -1.447711e-02, -1.581320e-02, 
        -1.730214e-02, -1.873890e-02, -1.965352e-02, -1.958190e-02, -1.957804e-02, -1.890122e-02, -1.840664e-02, -1.790402e-02, 
        -1.621263e-02, -1.418810e-02, -1.228494e-02, -1.019742e-02, -7.162075e-03, -4.457602e-03, -1.529338e-03, 1.791121e-03, 
        4.794344e-03, 7.650136e-03, 1.038940e-02, 1.372243e-02, 1.673587e-02, 1.964875e-02, 2.229075e-02, 2.369957e-02, 
        2.534590e-02, 2.645219e-02, 2.719062e-02, 2.762791e-02, 2.759310e-02, 2.718226e-02, 2.641654e-02, 2.535439e-02, 
        2.468030e-02, 2.270722e-02, 2.095719e-02, 1.912157e-02, 1.641603e-02, 1.370782e-02, 1.107192e-02, 9.226676e-03, 
        7.001006e-03, 4.527941e-03, 2.405401e-03, 1.095899e-03, -7.735699e-04, -2.655811e-03, -4.735180e-03, -6.672915e-03, 
        -8.651625e-03, -1.120396e-02, -1.365487e-02, -1.591794e-02, -1.860750e-02, -2.098193e-02, -2.306572e-02, -2.525036e-02, 
        -2.654935e-02, -2.787005e-02, -2.960896e-02, -3.188759e-02, -3.304582e-02, -3.362509e-02, -3.421006e-02, -3.493158e-02, 
        -3.527951e-02, -3.541151e-02, -3.616275e-02, -3.667030e-02, -3.645722e-02, -3.534547e-02, -3.384610e-02, -3.192936e-02, 
        -3.007744e-02, -2.816464e-02, -2.599383e-02, -2.364519e-02, -2.056853e-02, -1.721039e-02, -1.379104e-02, -1.101966e-02, 
        -8.279911e-03, -5.622427e-03, -3.033445e-03, -3.456622e-05, 3.156631e-03, 6.854350e-03, 1.036193e-02, 1.319639e-02, 
        1.547752e-02, 1.801207e-02, 2.066166e-02, 2.227310e-02, 2.414273e-02, 2.664079e-02, 2.869163e-02, 3.030688e-02, 
        3.128613e-02, 3.210737e-02, 3.323065e-02, 3.430051e-02, 3.496578e-02, 3.573864e-02, 3.690582e-02, 3.775529e-02, 
        3.815364e-02, 3.812283e-02, 3.809212e-02, 3.835298e-02, 3.836190e-02, 3.849059e-02, 3.875257e-02, 3.914174e-02, 
        3.934953e-02, 3.915474e-02, 3.886012e-02, 3.830582e-02, 3.761627e-02, 3.683023e-02, 3.518517e-02, 3.367588e-02, 
        3.253379e-02, 3.106042e-02, 2.882998e-02, 2.622605e-02, 2.310408e-02, 2.041273e-02, 1.741670e-02, 1.413832e-02, 
        1.057358e-02, 6.703073e-03, 3.278225e-03, 1.649775e-04, -3.372965e-03, -7.129515e-03, -1.079104e-02, -1.454826e-02, 
        -1.792318e-02, -2.190900e-02, -2.550286e-02, -2.851237e-02, -3.107104e-02, -3.305261e-02, -3.461994e-02, -3.612647e-02, 
        -3.740351e-02, -3.872915e-02, -3.959441e-02, -4.057913e-02, -4.139544e-02, -4.191170e-02, -4.162979e-02, -4.134529e-02, 
        -4.105334e-02, -4.031408e-02, -3.923497e-02, -3.834592e-02, -3.734537e-02, -3.683082e-02, -3.657909e-02, -3.589161e-02, 
        -3.498336e-02, -3.395033e-02, -3.273263e-02, -3.183399e-02, -3.094509e-02, -2.983059e-02, -2.840917e-02, -2.697139e-02, 
        -2.530493e-02, -2.424594e-02, -2.312261e-02, -2.148955e-02, -1.930896e-02, -1.706080e-02, -1.525190e-02, -1.337980e-02, 
        -1.124707e-02, -8.980724e-03, -6.313428e-03, -3.738550e-03, -1.155300e-03, 1.462800e-03, 4.117725e-03, 6.576173e-03, 
        9.156960e-03, 1.127338e-02, 1.330129e-02, 1.552762e-02, 1.760814e-02, 1.996352e-02, 2.202453e-02, 2.414522e-02, 
        2.611037e-02, 2.795979e-02, 2.932229e-02, 3.054205e-02, 3.140910e-02, 3.166134e-02, 3.185657e-02, 3.184578e-02, 
        3.196037e-02, 3.198783e-02, 3.158186e-02, 3.074272e-02, 2.957877e-02, 2.857800e-02, 2.762290e-02, 2.656386e-02, 
        2.538639e-02, 2.389762e-02, 2.246380e-02, 2.096857e-02, 1.937127e-02, 1.802197e-02, 1.668617e-02, 1.476751e-02, 
        1.326889e-02, 1.232738e-02, 1.173407e-02, 1.098063e-02, 1.018137e-02, 8.966329e-03, 7.971853e-03, 7.195106e-03, 
        6.592168e-03, 5.924248e-03, 5.587663e-03, 4.914722e-03, 3.926392e-03, 2.833351e-03, 1.739622e-03, 7.716546e-04, 
        -1.380842e-04, -7.569115e-04, -1.178506e-03, -1.528822e-03, -1.645077e-03, -1.569529e-03, -1.275292e-03, -7.566247e-04, 
        -2.034698e-04, 5.606138e-04, 1.390843e-03, 2.289548e-03, 3.109334e-03, 3.698633e-03, 4.000512e-03, 4.394167e-03, 
        5.186160e-03, 6.097267e-03, 6.857379e-03, 7.680091e-03, 8.616599e-03, 8.980693e-03, 8.861837e-03, 8.835621e-03, 
        9.021308e-03, 8.928020e-03, 8.789753e-03, 8.395309e-03, 7.397421e-03, 6.203323e-03, 4.886902e-03, 3.676173e-03, 
        2.702861e-03, 1.350104e-03, -2.499577e-05, -1.655689e-03, -3.220519e-03, -4.921209e-03, -6.453772e-03, -7.723878e-03, 
        -9.124404e-03, -1.084593e-02, -1.325368e-02, -1.553902e-02, -1.763123e-02, -1.977015e-02, -2.151874e-02, -2.297458e-02, 
        -2.406587e-02, -2.473961e-02, -2.485753e-02, -2.495961e-02, -2.472564e-02, -2.456694e-02, -2.428995e-02, -2.371211e-02, 
        -2.352511e-02, -2.351498e-02, -2.332999e-02, -2.282696e-02, -2.226596e-02, -2.177532e-02, -2.128669e-02, -2.076872e-02, 
        -2.050420e-02, -2.019321e-02, -1.987545e-02, -1.972984e-02, -1.932872e-02, -1.885399e-02, -1.850600e-02, -1.837970e-02, 
        -1.833540e-02, -1.839107e-02, -1.843416e-02, -1.862415e-02, -1.869155e-02, -1.873371e-02, -1.912060e-02, -1.936999e-02, 
        -1.925480e-02, -1.895933e-02, -1.855780e-02, -1.807826e-02, -1.735073e-02, -1.647183e-02, -1.582349e-02, -1.481334e-02, 
        -1.282715e-02, -1.087725e-02, -8.901899e-03, -6.841317e-03, -4.661811e-03, -2.376884e-03, -3.888844e-04, 1.512233e-03, 
        3.396649e-03, 5.589986e-03, 7.739855e-03, 9.897991e-03, 1.213807e-02, 1.422586e-02, 1.585109e-02, 1.718941e-02, 
        1.834364e-02, 1.934096e-02, 2.030101e-02, 2.100210e-02, 2.160543e-02, 2.235764e-02, 2.316455e-02, 2.402791e-02, 
        2.489666e-02, 2.581245e-02, 2.680838e-02, 2.806215e-02, 2.921748e-02, 3.009971e-02, 3.071540e-02, 3.143973e-02, 
        3.207420e-02, 3.255228e-02, 3.285824e-02, 3.299576e-02, 3.321511e-02, 3.318542e-02, 3.234970e-02, 3.111225e-02, 
        2.985794e-02, 2.849297e-02, 2.731962e-02, 2.595160e-02, 2.429608e-02, 2.257101e-02, 2.040358e-02, 1.816682e-02, 
        1.598018e-02, 1.377310e-02, 1.156882e-02, 9.352989e-03, 7.217448e-03, 5.121836e-03, 3.106883e-03, 1.026752e-03, 
        -1.154152e-03, -3.090965e-03, -4.711256e-03, -6.128800e-03, -7.401729e-03, -8.748151e-03, -1.005783e-02, -1.134497e-02, 
        -1.191050e-02, -1.211458e-02, -1.228022e-02, -1.230333e-02, -1.198417e-02, -1.150072e-02, -1.105589e-02, -1.059785e-02, 
        -1.065774e-02, -1.056733e-02, -1.061557e-02, -1.064500e-02, -1.053697e-02, -1.033711e-02, -9.531796e-03, -8.518715e-03, 
        -7.761465e-03, -7.395734e-03, -7.076393e-03, -6.666961e-03, -6.179050e-03, -5.830931e-03, -5.689979e-03, -5.596322e-03, 
        -5.533289e-03, -5.495375e-03, -5.351921e-03, -4.527135e-03, -3.682631e-03, -2.747405e-03, -1.492281e-03, -2.266926e-04, 
        1.077606e-03, 2.516098e-03, 3.965081e-03, 5.034290e-03, 5.899161e-03, 6.721525e-03, 7.365934e-03, 7.930988e-03, 
        8.618543e-03, 9.532525e-03, 1.080112e-02, 1.184946e-02, 1.232808e-02, 1.268872e-02, 1.273024e-02, 1.253847e-02, 
        1.210405e-02, 1.142066e-02, 1.060681e-02, 9.827226e-03, 8.979523e-03, 7.749134e-03, 6.172073e-03, 4.464178e-03, 
        2.671899e-03, 6.769367e-04, -1.444927e-03, -3.662987e-03, -5.961754e-03, -7.891737e-03, -9.788798e-03, -1.196441e-02, 
        -1.426424e-02, -1.650583e-02, -1.813978e-02, -1.952051e-02, -2.079222e-02, -2.199140e-02, -2.318612e-02, -2.428860e-02, 
        -2.536385e-02, -2.632518e-02, -2.708004e-02, -2.772888e-02, -2.793252e-02, -2.763354e-02, -2.729784e-02, -2.680502e-02, 
        -2.625252e-02, -2.562801e-02, -2.520969e-02, -2.459134e-02, -2.402998e-02, -2.367944e-02, -2.349122e-02, -2.347004e-02, 
        -2.268655e-02, -2.177420e-02, -2.102067e-02, -2.046612e-02, -2.017435e-02, -2.010539e-02, -1.984907e-02, -1.941804e-02, 
        -1.894860e-02, -1.847332e-02, -1.803340e-02, -1.760023e-02, -1.714239e-02, -1.670953e-02, -1.597351e-02, -1.467756e-02, 
        -1.334437e-02, -1.143254e-02, -9.190748e-03, -6.932587e-03, -4.763536e-03, -2.551227e-03, -2.080688e-04, 2.219243e-03, 
        4.409672e-03, 6.443073e-03, 8.377831e-03, 1.021087e-02, 1.201156e-02, 1.374064e-02, 1.545830e-02, 1.702197e-02, 
        1.888390e-02, 2.071518e-02, 2.245935e-02, 2.344217e-02, 2.440418e-02, 2.522417e-02, 2.594909e-02, 2.645563e-02, 
        2.669631e-02, 2.675554e-02, 2.674782e-02, 2.667195e-02, 2.652849e-02, 2.627962e-02, 2.596760e-02, 2.567768e-02, 
        2.546515e-02, 2.536571e-02, 2.524167e-02, 2.506378e-02, 2.497145e-02, 2.491217e-02, 2.476054e-02, 2.489279e-02, 
        2.497366e-02, 2.503084e-02, 2.515165e-02, 2.516790e-02, 2.510283e-02, 2.498922e-02, 2.482976e-02, 2.454682e-02, 
        2.416579e-02, 2.381887e-02, 2.336490e-02, 2.242567e-02, 2.132110e-02, 2.024481e-02, 1.909589e-02, 1.787123e-02, 
        1.656772e-02, 1.532286e-02, 1.415350e-02, 1.311266e-02, 1.220944e-02, 1.149946e-02, 1.055560e-02, 9.755882e-03, 
        8.992160e-03, 8.292029e-03, 7.805815e-03, 7.355886e-03, 6.959233e-03, 6.586886e-03, 6.569916e-03, 6.496576e-03, 
        6.406097e-03, 6.001400e-03, 5.458051e-03, 4.926243e-03, 4.315321e-03, 3.649063e-03, 2.913955e-03, 2.172937e-03, 
        1.323520e-03, 2.494032e-04, -1.016842e-03, -2.265649e-03, -3.811695e-03, -5.729069e-03, -7.528427e-03, -9.359915e-03, 
        -1.115366e-02, -1.289618e-02, -1.436931e-02, -1.565365e-02, -1.676667e-02, -1.776497e-02, -1.858983e-02, -1.937746e-02, 
        -2.036896e-02, -2.135186e-02, -2.212974e-02, -2.264182e-02, -2.316925e-02, -2.365002e-02, -2.414610e-02, -2.478922e-02, 
        -2.543580e-02, -2.605312e-02, -2.671318e-02, -2.741154e-02, -2.847393e-02, -2.961953e-02, -3.076283e-02, -3.149091e-02, 
        -3.195223e-02, -3.249157e-02, -3.313850e-02, -3.396393e-02, -3.494448e-02, -3.608686e-02, -3.721108e-02, -3.841949e-02, 
        -3.989676e-02, -4.134524e-02, -4.278263e-02, -4.418183e-02, -4.539317e-02, -4.600373e-02, -4.607777e-02, -4.588179e-02, 
        -4.533499e-02, -4.441912e-02, -4.314347e-02, -4.137390e-02, -3.963328e-02, -3.768302e-02, -3.546730e-02, -3.298884e-02, 
        -3.033928e-02, -2.740187e-02, -2.440793e-02, -2.134315e-02, -1.816116e-02, -1.496300e-02, -1.160043e-02, -8.079983e-03, 
        -4.961348e-03, -1.850219e-03, 1.395687e-03, 4.545362e-03, 7.506101e-03, 1.021898e-02, 1.274419e-02, 1.520360e-02, 
        1.771136e-02, 2.009179e-02, 2.236379e-02, 2.460752e-02, 2.660510e-02, 2.826751e-02, 2.992299e-02, 3.158282e-02, 
        3.312083e-02, 3.459771e-02, 3.604084e-02, 3.741493e-02, 3.872687e-02, 3.999709e-02, 4.147162e-02, 4.292926e-02, 
        4.437781e-02, 4.533007e-02, 4.592974e-02, 4.629982e-02, 4.658148e-02, 4.703863e-02, 4.741979e-02, 4.756681e-02, 
        4.750426e-02, 4.725191e-02, 4.678453e-02, 4.614883e-02, 4.559104e-02, 4.489925e-02, 4.352546e-02, 4.195567e-02, 
        4.020170e-02, 3.827532e-02, 3.620106e-02, 3.414337e-02, 3.196287e-02, 2.964226e-02, 2.729380e-02, 2.493518e-02, 
        2.286074e-02, 2.093077e-02, 1.913063e-02, 1.697084e-02, 1.489076e-02, 1.292853e-02, 1.105977e-02, 9.244886e-03, 
        7.475782e-03, 5.788072e-03, 4.388515e-03, 3.096280e-03, 1.877727e-03, 7.323806e-04, -3.526722e-04, -1.412134e-03, 
        -3.003547e-03, -4.489163e-03, -5.870796e-03, -7.201572e-03, -8.424293e-03, -9.596610e-03, -1.082831e-02, -1.199337e-02, 
        -1.312588e-02, -1.417553e-02, -1.518676e-02, -1.613656e-02, -1.694176e-02, -1.763842e-02, -1.849378e-02, -1.924874e-02, 
        -1.972425e-02, -2.008452e-02, -2.044026e-02, -2.070091e-02, -2.083397e-02, -2.080791e-02, -2.064436e-02, -2.015454e-02, 
        -1.948716e-02, -1.874811e-02, -1.789859e-02, -1.745872e-02, -1.705482e-02, -1.657329e-02, -1.605583e-02, -1.526581e-02, 
        -1.441425e-02, -1.330928e-02, -1.221088e-02, -1.114925e-02, -1.007136e-02, -9.052310e-03, -8.101342e-03, -6.970330e-03, 
        -5.879696e-03, -5.170864e-03, -4.381743e-03, -3.250538e-03, -2.109429e-03, -1.069344e-03, 2.367350e-05, 1.139974e-03, 
        2.068386e-03, 2.867085e-03, 3.617170e-03, 4.322660e-03, 5.017536e-03, 5.853732e-03, 6.643603e-03, 6.956689e-03, 
        7.182838e-03, 7.277807e-03, 7.253118e-03, 7.160764e-03, 6.984247e-03, 6.586128e-03, 6.184843e-03, 6.037641e-03, 
        6.031915e-03, 5.939830e-03, 5.841023e-03, 5.748898e-03, 5.558739e-03, 4.700314e-03, 3.831358e-03, 2.986117e-03, 
        2.095344e-03, 1.179259e-03, 5.411149e-04, -2.201710e-04, -1.136316e-03, -2.083543e-03, -3.000939e-03, -3.863737e-03, 
        -4.718609e-03, -5.564055e-03, -6.398729e-03, -7.477716e-03, -8.498700e-03, -9.038157e-03, -9.474478e-03, -9.704287e-03, 
        -9.998273e-03, -1.022132e-02, -1.041375e-02, -1.061439e-02, -1.084289e-02, -1.115954e-02, -1.152177e-02, -1.116880e-02, 
        -1.066547e-02, -1.016949e-02, -1.040908e-02, -1.081580e-02, -1.135060e-02, -1.212178e-02, -1.296112e-02, -1.353674e-02, 
        -1.423231e-02, -1.510847e-02, -1.505159e-02, -1.500618e-02, -1.508254e-02, -1.530489e-02, -1.563732e-02, -1.563577e-02, 
        -1.564875e-02, -1.650280e-02, -1.750175e-02, -1.851541e-02, -1.941360e-02, -1.841245e-02, -1.718508e-02, -1.572792e-02, 
        -1.396834e-02, -1.218440e-02, -1.033563e-02, -8.433616e-03, -6.438788e-03, -4.373265e-03, -2.216235e-03, -2.579775e-17
    },
    {
        0.000000e+00, -6.037378e-02, -6.469045e-03, 2.566552e-02, 4.210873e-02, 4.124150e-02, 3.096052e-02, 1.524907e-02, 
        2.785362e-03, -7.728595e-03, -1.698578e-02, -2.445510e-02, -2.919319e-02, -3.148743e-02, -3.142251e-02, -2.962631e-02, 
        -2.550305e-02, -1.973155e-02, -1.427010e-02, -7.931907e-03, -6.112233e-04, 7.491481e-03, 1.559396e-02, 2.351770e-02, 
        2.877784e-02, 3.255009e-02, 3.492912e-02, 3.425700e-02, 3.255751e-02, 2.866576e-02, 2.492890e-02, 2.033932e-02, 
        1.534457e-02, 7.894215e-03, 5.786402e-04, -5.714463e-03, -9.626747e-03, -1.367878e-02, -1.634066e-02, -1.844778e-02, 
        -2.053967e-02, -2.310193e-02, -2.553322e-02, -2.710448e-02, -2.760002e-02, -2.805446e-02, -2.734367e-02, -2.496195e-02, 
        -2.176249e-02, -1.742829e-02, -1.233449e-02, -8.869814e-03, -4.536597e-03, 2.414270e-04, 3.938743e-03, 7.684524e-03, 
        1.100897e-02, 1.401072e-02, 1.595778e-02, 1.702782e-02, 1.884968e-02, 1.967238e-02, 1.974188e-02, 2.062971e-02, 
        2.013866e-02, 1.842569e-02, 1.771824e-02, 1.658602e-02, 1.430307e-02, 1.201499e-02, 9.553737e-03, 6.269042e-03, 
        3.360829e-03, 1.254667e-03, -5.182312e-04, -2.372817e-03, -3.097430e-03, -3.573376e-03, -4.153988e-03, -4.488018e-03, 
        -4.492118e-03, -5.161001e-03, -6.639471e-03, -7.166803e-03, -7.256751e-03, -7.773312e-03, -7.994558e-03, -7.889688e-03, 
        -8.911424e-03, -9.977403e-03, -1.122079e-02, -1.155498e-02, -1.100076e-02, -1.071660e-02, -1.011592e-02, -9.500469e-03, 
        -7.222929e-03, -4.232981e-03, -2.761877e-03, -1.355558e-03, 5.808436e-04, 3.069494e-03, 4.022636e-03, 3.910751e-03, 
        4.202777e-03, 5.278721e-03, 4.696964e-03, 3.762970e-03, 3.120345e-03, 3.765287e-03, 3.939764e-03, 4.252810e-03, 
        5.437575e-03, 5.450772e-03, 6.156525e-03, 6.802959e-03, 6.699919e-03, 6.798808e-03, 7.977533e-03, 8.510721e-03, 
        9.513612e-03, 1.051562e-02, 1.177616e-02, 1.312116e-02, 1.386606e-02, 1.373182e-02, 1.313098e-02, 1.166804e-02, 
        9.809053e-03, 7.025868e-03, 3.968250e-03, 1.770472e-03, -5.016523e-04, -1.935521e-03, -3.686553e-03, -4.829481e-03, 
        -4.830921e-03, -6.160095e-03, -6.258897e-03, -6.919228e-03, -7.621123e-03, -8.593602e-03, -1.016672e-02, -1.202727e-02, 
        -1.408548e-02, -1.511033e-02, -1.554094e-02, -1.610314e-02, -1.532400e-02, -1.542983e-02, -1.570783e-02, -1.507096e-02, 
        -1.528697e-02, -1.455619e-02, -1.406848e-02, -1.362672e-02, -1.223586e-02, -1.119136e-02, -1.028329e-02, -1.046815e-02, 
        -9.989788e-03, -9.566241e-03, -8.986772e-03, -8.049935e-03, -5.965631e-03, -4.368594e-03, -3.173520e-03, -1.001296e-03, 
        -3.109018e-04, 2.629551e-04, 1.745318e-03, 3.204123e-03, 4.035660e-03, 6.218978e-03, 7.753124e-03, 9.885569e-03, 
        1.116178e-02, 1.245254e-02, 1.320182e-02, 1.478459e-02, 1.509932e-02, 1.588767e-02, 1.658916e-02, 1.657746e-02, 
        1.548080e-02, 1.605646e-02, 1.608772e-02, 1.586954e-02, 1.626351e-02, 1.626150e-02, 1.550502e-02, 1.512801e-02, 
        1.410334e-02, 1.271030e-02, 1.192894e-02, 1.140073e-02, 1.063790e-02, 9.100201e-03, 9.333021e-03, 9.095271e-03, 
        8.481116e-03, 7.338499e-03, 5.751654e-03, 3.801295e-03, 1.168824e-03, -6.809504e-04, -3.116799e-03, -5.788835e-03, 
        -7.881047e-03, -9.965807e-03, -1.219276e-02, -1.443369e-02, -1.563531e-02, -1.753826e-02, -1.941432e-02, -2.113058e-02, 
        -2.274960e-02, -2.438502e-02, -2.659924e-02, -2.772699e-02, -2.903151e-02, -3.029340e-02, -3.139278e-02, -3.169041e-02, 
        -3.153138e-02, -3.158971e-02, -3.159664e-02, -3.035610e-02, -2.937392e-02, -2.840589e-02, -2.711180e-02, -2.504244e-02, 
        -2.289625e-02, -2.159539e-02, -1.963929e-02, -1.684629e-02, -1.452578e-02, -1.154706e-02, -8.112968e-03, -3.753865e-03, 
        1.071476e-03, 5.515752e-03, 1.012575e-02, 1.547505e-02, 2.051150e-02, 2.510707e-02, 2.964321e-02, 3.356479e-02, 
        3.731168e-02, 4.017798e-02, 4.232159e-02, 4.555931e-02, 4.874874e-02, 5.124080e-02, 5.340434e-02, 5.536813e-02, 
        5.637646e-02, 5.676013e-02, 5.718229e-02, 5.732404e-02, 5.762667e-02, 5.706885e-02, 5.536933e-02, 5.288875e-02, 
        5.123134e-02, 4.912973e-02, 4.607073e-02, 4.270710e-02, 3.889235e-02, 3.498278e-02, 3.045412e-02, 2.560045e-02, 
        2.085320e-02, 1.701732e-02, 1.295545e-02, 7.964438e-03, 3.261862e-03, -1.359544e-03, -5.152683e-03, -8.195529e-03, 
        -1.217268e-02, -1.566566e-02, -1.773716e-02, -1.973003e-02, -2.213997e-02, -2.455584e-02, -2.695953e-02, -2.935791e-02, 
        -3.138782e-02, -3.306528e-02, -3.517096e-02, -3.749783e-02, -3.829531e-02, -3.880917e-02, -3.934775e-02, -3.965057e-02, 
        -4.061743e-02, -4.112536e-02, -4.111388e-02, -4.129607e-02, -4.209697e-02, -4.240947e-02, -4.211714e-02, -4.203469e-02, 
        -4.247345e-02, -4.244573e-02, -4.312946e-02, -4.308403e-02, -4.291717e-02, -4.212285e-02, -4.151760e-02, -4.083205e-02, 
        -3.895152e-02, -3.679633e-02, -3.512734e-02, -3.359432e-02, -3.169090e-02, -3.006724e-02, -2.781366e-02, -2.505097e-02, 
        -2.203950e-02, -1.970662e-02, -1.742626e-02, -1.380310e-02, -1.021928e-02, -7.155949e-03, -4.269678e-03, -7.184659e-04, 
        2.214367e-03, 4.618178e-03, 7.212744e-03, 1.011789e-02, 1.197997e-02, 1.395555e-02, 1.624820e-02, 1.828034e-02, 
        1.945293e-02, 2.061147e-02, 2.232654e-02, 2.488742e-02, 2.696525e-02, 2.888020e-02, 3.086175e-02, 3.208284e-02, 
        3.300377e-02, 3.399652e-02, 3.501373e-02, 3.538998e-02, 3.593130e-02, 3.624569e-02, 3.671883e-02, 3.694650e-02, 
        3.611745e-02, 3.491173e-02, 3.379608e-02, 3.215676e-02, 3.050474e-02, 2.942390e-02, 2.851606e-02, 2.729075e-02, 
        2.556305e-02, 2.351257e-02, 2.206939e-02, 2.063788e-02, 1.874339e-02, 1.674897e-02, 1.499513e-02, 1.282930e-02, 
        1.031069e-02, 8.318007e-03, 6.849225e-03, 4.868687e-03, 2.799463e-03, 6.554596e-04, -1.657586e-03, -3.815220e-03, 
        -6.019962e-03, -8.374727e-03, -1.060240e-02, -1.246368e-02, -1.438541e-02, -1.599249e-02, -1.711392e-02, -1.829963e-02, 
        -1.957395e-02, -2.076187e-02, -2.192923e-02, -2.255913e-02, -2.259167e-02, -2.263124e-02, -2.274266e-02, -2.276364e-02, 
        -2.277775e-02, -2.255446e-02, -2.185118e-02, -2.075609e-02, -1.997064e-02, -1.953343e-02, -1.885195e-02, -1.806234e-02, 
        -1.703671e-02, -1.563231e-02, -1.427013e-02, -1.333103e-02, -1.232643e-02, -1.134038e-02, -9.914061e-03, -7.802220e-03, 
        -4.849087e-03, -2.247817e-03, 7.093138e-05, 2.131760e-03, 3.507166e-03, 5.108711e-03, 7.054914e-03, 9.141091e-03, 
        1.116481e-02, 1.284738e-02, 1.467287e-02, 1.625545e-02, 1.738957e-02, 1.827707e-02, 1.889924e-02, 1.908773e-02, 
        1.882092e-02, 1.811302e-02, 1.646014e-02, 1.450542e-02, 1.299139e-02, 1.174056e-02, 1.085030e-02, 9.895594e-03, 
        8.697252e-03, 7.162899e-03, 5.196303e-03, 3.473491e-03, 1.543164e-03, -4.213685e-04, -2.074557e-03, -3.537647e-03, 
        -4.668432e-03, -6.406290e-03, -8.097026e-03, -9.015186e-03, -9.838171e-03, -1.069196e-02, -1.162989e-02, -1.209421e-02, 
        -1.231395e-02, -1.258722e-02, -1.212346e-02, -1.175342e-02, -1.128135e-02, -1.041603e-02, -9.455872e-03, -7.964977e-03, 
        -6.990851e-03, -6.215775e-03, -5.414600e-03, -4.704862e-03, -4.048329e-03, -3.610792e-03, -3.213320e-03, -2.062114e-03, 
        -1.004225e-03, 2.307415e-04, 1.273663e-03, 2.001758e-03, 3.443290e-03, 5.198106e-03, 6.909056e-03, 8.372257e-03, 
        8.707803e-03, 9.031754e-03, 9.231475e-03, 9.137415e-03, 8.805090e-03, 8.294868e-03, 8.180670e-03, 8.338760e-03, 
        7.864747e-03, 7.392176e-03, 6.555473e-03, 5.747565e-03, 6.255572e-03, 6.865768e-03, 7.337572e-03, 7.390398e-03, 
        6.762009e-03, 6.973934e-03, 7.537761e-03, 7.971484e-03, 8.123720e-03, 7.604849e-03, 7.216810e-03, 7.532116e-03, 
        7.600449e-03, 7.221970e-03, 6.604117e-03, 5.589618e-03, 4.770874e-03, 4.229896e-03, 3.640737e-03, 2.992700e-03, 
        2.006548e-03, 8.023127e-04, -1.177813e-04, -9.945589e-04, -2.032928e-03, -3.132484e-03, -4.516936e-03, -5.695809e-03, 
        -6.470323e-03, -7.195920e-03, -7.928012e-03, -8.794739e-03, -9.580493e-03, -9.773680e-03, -9.881701e-03, -1.006301e-02, 
        -1.045548e-02, -1.122410e-02, -1.164230e-02, -1.163747e-02, -1.138447e-02, -1.123806e-02, -1.134106e-02, -1.185723e-02, 
        -1.204192e-02, -1.168398e-02, -1.126568e-02, -1.089795e-02, -1.090845e-02, -1.105166e-02, -1.103055e-02, -1.023981e-02, 
        -9.361922e-03, -8.371049e-03, -7.578562e-03, -7.349685e-03, -7.310679e-03, -7.294808e-03, -7.335154e-03, -7.301579e-03, 
        -7.330223e-03, -7.763455e-03, -8.227565e-03, -8.066161e-03, -7.718895e-03, -7.156124e-03, -6.877906e-03, -6.921739e-03, 
        -6.834300e-03, -6.052919e-03, -5.057393e-03, -3.905368e-03, -2.622174e-03, -1.349292e-03, -5.034098e-04, 5.799790e-04, 
        1.529785e-03, 2.692727e-03, 3.428851e-03, 4.137996e-03, 4.574666e-03, 5.135323e-03, 5.730637e-03, 6.553256e-03, 
        7.186724e-03, 7.605896e-03, 7.715709e-03, 7.881939e-03, 8.185649e-03, 8.335573e-03, 8.606283e-03, 8.836317e-03, 
        8.999634e-03, 9.223964e-03, 9.686810e-03, 9.935024e-03, 1.040059e-02, 1.090493e-02, 1.146881e-02, 1.189723e-02, 
        1.261770e-02, 1.321377e-02, 1.409098e-02, 1.510879e-02, 1.597020e-02, 1.640195e-02, 1.658232e-02, 1.679451e-02, 
        1.700724e-02, 1.730688e-02, 1.765152e-02, 1.793573e-02, 1.790739e-02, 1.797367e-02, 1.782853e-02, 1.753643e-02, 
        1.766969e-02, 1.759952e-02, 1.742829e-02, 1.705576e-02, 1.673999e-02, 1.628532e-02, 1.573928e-02, 1.533888e-02, 
        1.467525e-02, 1.365310e-02, 1.227108e-02, 1.074951e-02, 9.222079e-03, 7.718998e-03, 6.239504e-03, 4.895915e-03, 
        3.669358e-03, 2.454426e-03, 1.345865e-03, 2.091807e-04, -7.286221e-04, -1.465081e-03, -2.030929e-03, -2.784536e-03, 
        -3.528809e-03, -4.517121e-03, -5.207065e-03, -5.788640e-03, -6.267730e-03, -6.845133e-03, -7.835692e-03, -8.727780e-03, 
        -9.531163e-03, -1.022097e-02, -1.088633e-02, -1.122360e-02, -1.120520e-02, -1.090742e-02, -1.051147e-02, -9.996182e-03, 
        -9.743216e-03, -9.607908e-03, -9.309272e-03, -8.930210e-03, -8.891010e-03, -8.848051e-03, -8.519383e-03, -7.971881e-03, 
        -7.183360e-03, -6.413700e-03, -5.484757e-03, -4.647386e-03, -4.008340e-03, -3.364449e-03, -2.953996e-03, -2.620614e-03, 
        -2.334315e-03, -2.267890e-03, -2.359967e-03, -2.927530e-03, -3.405608e-03, -4.080607e-03, -4.935338e-03, -5.752372e-03, 
        -6.416990e-03, -7.381614e-03, -8.781892e-03, -1.029007e-02, -1.184245e-02, -1.303781e-02, -1.434610e-02, -1.560290e-02, 
        -1.713361e-02, -1.882600e-02, -2.064117e-02, -2.229700e-02, -2.428934e-02, -2.626077e-02, -2.812560e-02, -2.924710e-02, 
        -2.997286e-02, -3.080780e-02, -3.126990e-02, -3.152929e-02, -3.173127e-02, -3.176193e-02, -3.189371e-02, -3.190178e-02, 
        -3.184276e-02, -3.153658e-02, -3.104103e-02, -3.051133e-02, -2.995644e-02, -2.890267e-02, -2.733478e-02, -2.565742e-02, 
        -2.418164e-02, -2.291387e-02, -2.122296e-02, -1.944181e-02, -1.748546e-02, -1.522782e-02, -1.309264e-02, -1.141865e-02, 
        -9.949129e-03, -8.412726e-03, -6.820412e-03, -5.404121e-03, -4.063398e-03, -2.967430e-03, -1.739144e-03, -5.983088e-04, 
        4.915583e-04, 1.805720e-03, 3.122572e-03, 4.539031e-03, 6.164998e-03, 8.052443e-03, 1.022771e-02, 1.228164e-02, 
        1.396105e-02, 1.559995e-02, 1.727900e-02, 1.876976e-02, 2.034776e-02, 2.214442e-02, 2.390706e-02, 2.563993e-02, 
        2.734110e-02, 2.902073e-02, 3.079046e-02, 3.247927e-02, 3.409687e-02, 3.581839e-02, 3.786579e-02, 3.975921e-02, 
        4.158360e-02, 4.319656e-02, 4.466196e-02, 4.597251e-02, 4.729922e-02, 4.886675e-02, 5.051901e-02, 5.214561e-02, 
        5.351464e-02, 5.482532e-02, 5.588239e-02, 5.625881e-02, 5.646446e-02, 5.666459e-02, 5.687511e-02, 5.705516e-02, 
        5.734115e-02, 5.764511e-02, 5.804020e-02, 5.810874e-02, 5.800663e-02, 5.769519e-02, 5.719326e-02, 5.666811e-02, 
        5.596670e-02, 5.500465e-02, 5.389550e-02, 5.246805e-02, 5.085580e-02, 4.908175e-02, 4.716307e-02, 4.540169e-02, 
        4.352360e-02, 4.129263e-02, 3.899745e-02, 3.640574e-02, 3.340002e-02, 3.029288e-02, 2.713674e-02, 2.419922e-02, 
        2.126105e-02, 1.814286e-02, 1.467007e-02, 1.126856e-02, 8.035846e-03, 4.936749e-03, 2.034712e-03, -8.402643e-04, 
        -3.798186e-03, -6.713516e-03, -9.620852e-03, -1.236111e-02, -1.469108e-02, -1.673423e-02, -1.874035e-02, -2.076505e-02, 
        -2.275763e-02, -2.457012e-02, -2.626111e-02, -2.762188e-02, -2.881963e-02, -3.008063e-02, -3.138960e-02, -3.280146e-02, 
        -3.417407e-02, -3.500368e-02, -3.558858e-02, -3.613100e-02, -3.685923e-02, -3.757275e-02, -3.824011e-02, -3.881196e-02, 
        -3.945278e-02, -4.014865e-02, -4.089369e-02, -4.152280e-02, -4.222498e-02, -4.300391e-02, -4.357753e-02, -4.389153e-02, 
        -4.417572e-02, -4.468131e-02, -4.536676e-02, -4.616546e-02, -4.687856e-02, -4.775342e-02, -4.867290e-02, -4.967323e-02, 
        -5.078950e-02, -5.206538e-02, -5.347670e-02, -5.497112e-02, -5.641970e-02, -5.769714e-02, -5.885459e-02, -6.002815e-02, 
        -6.126985e-02, -6.245799e-02, -6.357684e-02, -6.478398e-02, -6.606717e-02, -6.743520e-02, -6.884572e-02, -7.012717e-02, 
        -7.142284e-02, -7.255595e-02, -7.339904e-02, -7.408170e-02, -7.470702e-02, -7.521750e-02, -7.548688e-02, -7.547660e-02, 
        -7.509164e-02, -7.452128e-02, -7.366689e-02, -7.234040e-02, -7.051609e-02, -6.851947e-02, -6.624192e-02, -6.388047e-02, 
        -6.132734e-02, -5.849585e-02, -5.552270e-02, -5.250218e-02, -4.927400e-02, -4.567800e-02, -4.185546e-02, -3.780921e-02, 
        -3.356174e-02, -2.912511e-02, -2.457000e-02, -1.988600e-02, -1.517933e-02, -1.038374e-02, -5.597219e-03, -7.254290e-04, 
        4.143014e-03, 8.949597e-03, 1.368268e-02, 1.831937e-02, 2.285228e-02, 2.744269e-02, 3.192047e-02, 3.617557e-02, 
        4.037269e-02, 4.418612e-02, 4.761960e-02, 5.086220e-02, 5.387639e-02, 5.665861e-02, 5.920675e-02, 6.136500e-02, 
        6.316524e-02, 6.463713e-02, 6.592216e-02, 6.690185e-02, 6.769238e-02, 6.832333e-02, 6.879984e-02, 6.902306e-02, 
        6.894227e-02, 6.865506e-02, 6.807717e-02, 6.729998e-02, 6.639905e-02, 6.538164e-02, 6.426421e-02, 6.306813e-02, 
        6.194848e-02, 6.087209e-02, 5.986571e-02, 5.899887e-02, 5.816417e-02, 5.746282e-02, 5.678570e-02, 5.594664e-02, 
        5.501553e-02, 5.413006e-02, 5.330730e-02, 5.257485e-02, 5.192842e-02, 5.132706e-02, 5.074689e-02, 5.050003e-02, 
        5.035575e-02, 5.021581e-02, 5.003469e-02, 4.979947e-02, 4.952558e-02, 4.932980e-02, 4.909361e-02, 4.856641e-02, 
        4.766466e-02, 4.700044e-02, 4.636619e-02, 4.567631e-02, 4.477307e-02, 4.382717e-02, 4.287739e-02, 4.202948e-02, 
        4.108119e-02, 4.025089e-02, 3.912707e-02, 3.823687e-02, 3.738083e-02, 3.653945e-02, 3.545934e-02, 3.423688e-02, 
        3.288536e-02, 3.152637e-02, 3.012073e-02, 2.871450e-02, 2.720307e-02, 2.576423e-02, 2.421299e-02, 2.252979e-02, 
        2.060456e-02, 1.848958e-02, 1.630198e-02, 1.402818e-02, 1.163621e-02, 9.157455e-03, 6.467600e-03, 3.681196e-03, 
        1.076935e-03, -1.611882e-03, -4.520276e-03, -7.677941e-03, -1.089190e-02, -1.424759e-02, -1.762310e-02, -2.098455e-02, 
        -2.436754e-02, -2.750442e-02, -2.988875e-02, -3.221942e-02, -3.458169e-02, -3.712299e-02, -3.970633e-02, -4.240767e-02, 
        -4.501945e-02, -4.757800e-02, -5.010187e-02, -5.255989e-02, -5.471572e-02, -5.653811e-02, -5.833453e-02, -6.018337e-02, 
        -6.191623e-02, -6.360020e-02, -6.524241e-02, -6.684681e-02, -6.843125e-02, -7.002673e-02, -7.152629e-02, -7.240049e-02, 
        -7.300993e-02, -7.388027e-02, -7.498386e-02, -7.612198e-02, -7.717995e-02, -7.794049e-02, -7.872595e-02, -7.944172e-02, 
        -8.020577e-02, -8.077332e-02, -7.938030e-02, -7.806317e-02, -7.696373e-02, -7.589552e-02, -7.481753e-02, -7.383193e-02, 
        -7.278924e-02, -7.177350e-02, -7.024781e-02, -6.849253e-02, -6.630172e-02, -6.048931e-02, -5.491701e-02, -4.916730e-02, 
        -4.324916e-02, -3.726084e-02, -3.118685e-02, -2.504838e-02, -1.886408e-02, -1.263625e-02, -6.343596e-03, -4.415809e-16
    }
};
