/* search-panel.c generated by valac 0.14.0, the Vala compiler
 * generated from search-panel.vala, do not modify */

/*
 * Copyright (C) 2011  Daiki Ueno
 * Copyright (C) 2011  Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <ibuspanelextensionsprivate.h>
#include <sqlite3.h>
#include <ibus/ibuspanelextensions.h>
#include <stdio.h>
#include <config.h>


#define IBUS_CHARMAP_TYPE_CHARACTER_RENDERER (ibus_charmap_character_renderer_get_type ())
#define IBUS_CHARMAP_CHARACTER_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_CHARMAP_TYPE_CHARACTER_RENDERER, IBusCharmapCharacterRenderer))
#define IBUS_CHARMAP_CHARACTER_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_CHARMAP_TYPE_CHARACTER_RENDERER, IBusCharmapCharacterRendererClass))
#define IBUS_CHARMAP_IS_CHARACTER_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_CHARMAP_TYPE_CHARACTER_RENDERER))
#define IBUS_CHARMAP_IS_CHARACTER_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_CHARMAP_TYPE_CHARACTER_RENDERER))
#define IBUS_CHARMAP_CHARACTER_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_CHARMAP_TYPE_CHARACTER_RENDERER, IBusCharmapCharacterRendererClass))

typedef struct _IBusCharmapCharacterRenderer IBusCharmapCharacterRenderer;
typedef struct _IBusCharmapCharacterRendererClass IBusCharmapCharacterRendererClass;
typedef struct _IBusCharmapCharacterRendererPrivate IBusCharmapCharacterRendererPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define IBUS_CHARMAP_TYPE_SEARCH_PANEL (ibus_charmap_search_panel_get_type ())
#define IBUS_CHARMAP_SEARCH_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_CHARMAP_TYPE_SEARCH_PANEL, IBusCharmapSearchPanel))
#define IBUS_CHARMAP_SEARCH_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_CHARMAP_TYPE_SEARCH_PANEL, IBusCharmapSearchPanelClass))
#define IBUS_CHARMAP_IS_SEARCH_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_CHARMAP_TYPE_SEARCH_PANEL))
#define IBUS_CHARMAP_IS_SEARCH_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_CHARMAP_TYPE_SEARCH_PANEL))
#define IBUS_CHARMAP_SEARCH_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_CHARMAP_TYPE_SEARCH_PANEL, IBusCharmapSearchPanelClass))

typedef struct _IBusCharmapSearchPanel IBusCharmapSearchPanel;
typedef struct _IBusCharmapSearchPanelClass IBusCharmapSearchPanelClass;
typedef struct _IBusCharmapSearchPanelPrivate IBusCharmapSearchPanelPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))

struct _IBusCharmapCharacterRenderer {
	GtkCellRendererText parent_instance;
	IBusCharmapCharacterRendererPrivate * priv;
};

struct _IBusCharmapCharacterRendererClass {
	GtkCellRendererTextClass parent_class;
};

struct _IBusCharmapCharacterRendererPrivate {
	gunichar _codepoint;
};

struct _IBusCharmapSearchPanel {
	GtkBox parent_instance;
	IBusCharmapSearchPanelPrivate * priv;
};

struct _IBusCharmapSearchPanelClass {
	GtkBoxClass parent_class;
};

struct _IBusCharmapSearchPanelPrivate {
	GtkEntry* entry;
	GtkTreeView* matches;
	guint idle_search_id;
};

struct _Block1Data {
	int _ref_count_;
	IBusCharmapSearchPanel * self;
	guint max_matches;
};


static gpointer ibus_charmap_character_renderer_parent_class = NULL;
static gpointer ibus_charmap_search_panel_parent_class = NULL;
static sqlite3* ibus_charmap_search_panel_database;
static sqlite3* ibus_charmap_search_panel_database = NULL;
static IBusSelectableIface* ibus_charmap_search_panel_ibus_selectable_parent_iface = NULL;

GType ibus_charmap_character_renderer_get_type (void) G_GNUC_CONST;
#define IBUS_CHARMAP_CHARACTER_RENDERER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_CHARMAP_TYPE_CHARACTER_RENDERER, IBusCharmapCharacterRendererPrivate))
enum  {
	IBUS_CHARMAP_CHARACTER_RENDERER_DUMMY_PROPERTY,
	IBUS_CHARMAP_CHARACTER_RENDERER_CODEPOINT
};
IBusCharmapCharacterRenderer* ibus_charmap_character_renderer_new (void);
IBusCharmapCharacterRenderer* ibus_charmap_character_renderer_construct (GType object_type);
gunichar ibus_charmap_character_renderer_get_codepoint (IBusCharmapCharacterRenderer* self);
void ibus_charmap_character_renderer_set_codepoint (IBusCharmapCharacterRenderer* self, gunichar value);
static void ibus_charmap_character_renderer_finalize (GObject* obj);
static void _vala_ibus_charmap_character_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_ibus_charmap_character_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType ibus_charmap_search_panel_get_type (void) G_GNUC_CONST;
#define IBUS_CHARMAP_SEARCH_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_CHARMAP_TYPE_SEARCH_PANEL, IBusCharmapSearchPanelPrivate))
enum  {
	IBUS_CHARMAP_SEARCH_PANEL_DUMMY_PROPERTY
};
void ibus_charmap_search_panel_start_search (IBusCharmapSearchPanel* self, const gchar* name, guint max_matches);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
void ibus_charmap_search_panel_cancel_search (IBusCharmapSearchPanel* self);
static gboolean __lambda0_ (Block1Data* _data1_);
static gboolean ibus_charmap_search_panel_idle_search (IBusCharmapSearchPanel* self, guint max_matches);
static gboolean ___lambda0__gsource_func (gpointer self);
static void ibus_charmap_search_panel_real_activate_selected (IBusSelectable* base);
static void ibus_charmap_search_panel_real_move_cursor (IBusSelectable* base, IBusMovementStep step, gint count);
static void ibus_charmap_search_panel_on_row_activated (IBusCharmapSearchPanel* self, GtkTreePath* path, GtkTreeViewColumn* column);
IBusCharmapSearchPanel* ibus_charmap_search_panel_new (void);
IBusCharmapSearchPanel* ibus_charmap_search_panel_construct (GType object_type);
static void _ibus_charmap_search_panel_on_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void ibus_charmap_search_panel_finalize (GObject* obj);


IBusCharmapCharacterRenderer* ibus_charmap_character_renderer_construct (GType object_type) {
	IBusCharmapCharacterRenderer * self = NULL;
	self = (IBusCharmapCharacterRenderer*) g_object_new (object_type, NULL);
	return self;
}


IBusCharmapCharacterRenderer* ibus_charmap_character_renderer_new (void) {
	return ibus_charmap_character_renderer_construct (IBUS_CHARMAP_TYPE_CHARACTER_RENDERER);
}


gunichar ibus_charmap_character_renderer_get_codepoint (IBusCharmapCharacterRenderer* self) {
	gunichar result;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_codepoint;
	result = _tmp0_;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


void ibus_charmap_character_renderer_set_codepoint (IBusCharmapCharacterRenderer* self, gunichar value) {
	gunichar _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_codepoint = _tmp0_;
	_tmp1_ = self->priv->_codepoint;
	_tmp2_ = g_unichar_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set ((GtkCellRendererText*) self, "text", _tmp3_, NULL);
	_g_free0 (_tmp3_);
	g_object_notify ((GObject *) self, "codepoint");
}


static void ibus_charmap_character_renderer_class_init (IBusCharmapCharacterRendererClass * klass) {
	ibus_charmap_character_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusCharmapCharacterRendererPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_ibus_charmap_character_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ibus_charmap_character_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = ibus_charmap_character_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), IBUS_CHARMAP_CHARACTER_RENDERER_CODEPOINT, g_param_spec_uint ("codepoint", "codepoint", "codepoint", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void ibus_charmap_character_renderer_instance_init (IBusCharmapCharacterRenderer * self) {
	self->priv = IBUS_CHARMAP_CHARACTER_RENDERER_GET_PRIVATE (self);
}


static void ibus_charmap_character_renderer_finalize (GObject* obj) {
	IBusCharmapCharacterRenderer * self;
	self = IBUS_CHARMAP_CHARACTER_RENDERER (obj);
	G_OBJECT_CLASS (ibus_charmap_character_renderer_parent_class)->finalize (obj);
}


GType ibus_charmap_character_renderer_get_type (void) {
	static volatile gsize ibus_charmap_character_renderer_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_charmap_character_renderer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusCharmapCharacterRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_charmap_character_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusCharmapCharacterRenderer), 0, (GInstanceInitFunc) ibus_charmap_character_renderer_instance_init, NULL };
		GType ibus_charmap_character_renderer_type_id;
		ibus_charmap_character_renderer_type_id = g_type_register_static (GTK_TYPE_CELL_RENDERER_TEXT, "IBusCharmapCharacterRenderer", &g_define_type_info, 0);
		g_once_init_leave (&ibus_charmap_character_renderer_type_id__volatile, ibus_charmap_character_renderer_type_id);
	}
	return ibus_charmap_character_renderer_type_id__volatile;
}


static void _vala_ibus_charmap_character_renderer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IBusCharmapCharacterRenderer * self;
	self = IBUS_CHARMAP_CHARACTER_RENDERER (object);
	switch (property_id) {
		case IBUS_CHARMAP_CHARACTER_RENDERER_CODEPOINT:
		g_value_set_uint (value, ibus_charmap_character_renderer_get_codepoint (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_ibus_charmap_character_renderer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IBusCharmapCharacterRenderer * self;
	self = IBUS_CHARMAP_CHARACTER_RENDERER (object);
	switch (property_id) {
		case IBUS_CHARMAP_CHARACTER_RENDERER_CODEPOINT:
		ibus_charmap_character_renderer_set_codepoint (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda0_ (Block1Data* _data1_) {
	IBusCharmapSearchPanel * self;
	gboolean result = FALSE;
	guint _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data1_->self;
	_tmp0_ = _data1_->max_matches;
	_tmp1_ = ibus_charmap_search_panel_idle_search (self, _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean ___lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda0_ (self);
	return result;
}


void ibus_charmap_search_panel_start_search (IBusCharmapSearchPanel* self, const gchar* name, guint max_matches) {
	Block1Data* _data1_;
	guint _tmp0_;
	guint _tmp1_ = 0U;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = max_matches;
	_data1_->max_matches = _tmp0_;
	ibus_charmap_search_panel_cancel_search (self);
	_tmp1_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda0__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	self->priv->idle_search_id = _tmp1_;
	_tmp2_ = self->priv->entry;
	_tmp3_ = name;
	gtk_entry_set_text (_tmp2_, _tmp3_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void ibus_charmap_search_panel_cancel_search (IBusCharmapSearchPanel* self) {
	guint _tmp0_;
	GtkTreeView* _tmp2_;
	GtkTreeModel* _tmp3_ = NULL;
	GtkListStore* _tmp4_;
	GtkListStore* store;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->idle_search_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->idle_search_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = self->priv->matches;
	_tmp3_ = gtk_tree_view_get_model (_tmp2_);
	_tmp4_ = _g_object_ref0 (GTK_LIST_STORE (_tmp3_));
	store = _tmp4_;
	gtk_list_store_clear (store);
	_g_object_unref0 (store);
}


static void ibus_charmap_search_panel_real_activate_selected (IBusSelectable* base) {
	IBusCharmapSearchPanel * self;
	GtkTreePath* path = NULL;
	GtkTreeView* _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkTreeViewColumn* _tmp4_ = NULL;
	self = (IBusCharmapSearchPanel*) base;
	_tmp0_ = self->priv->matches;
	gtk_tree_view_get_cursor (_tmp0_, &_tmp1_, NULL);
	_gtk_tree_path_free0 (path);
	path = _tmp1_;
	_tmp2_ = self->priv->matches;
	_tmp3_ = self->priv->matches;
	_tmp4_ = gtk_tree_view_get_column (_tmp3_, 0);
	gtk_tree_view_row_activated (_tmp2_, path, _tmp4_);
	_gtk_tree_path_free0 (path);
}


static void ibus_charmap_search_panel_real_move_cursor (IBusSelectable* base, IBusMovementStep step, gint count) {
	IBusCharmapSearchPanel * self;
	IBusMovementStep _tmp0_;
	self = (IBusCharmapSearchPanel*) base;
	_tmp0_ = step;
	if (_tmp0_ == IBUS_MOVEMENT_STEP_DISPLAY_LINES) {
		GtkTreePath* path = NULL;
		GtkTreeView* _tmp1_;
		GtkTreeView* _tmp2_;
		GtkTreePath* _tmp3_ = NULL;
		GtkTreeView* _tmp10_;
		GtkTreeModel* _tmp11_ = NULL;
		GtkTreeModel* _tmp12_;
		GtkTreeModel* store;
		GtkTreeIter iter = {0};
		GtkTreeModel* _tmp13_;
		GtkTreePath* _tmp14_;
		GtkTreeIter _tmp15_ = {0};
		gboolean _tmp16_ = FALSE;
		_tmp1_ = self->priv->matches;
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
		_tmp2_ = self->priv->matches;
		gtk_tree_view_get_cursor (_tmp2_, &_tmp3_, NULL);
		_gtk_tree_path_free0 (path);
		path = _tmp3_;
		while (TRUE) {
			gint _tmp4_;
			GtkTreePath* _tmp5_;
			gint _tmp6_;
			_tmp4_ = count;
			if (!(_tmp4_ < 0)) {
				break;
			}
			_tmp5_ = path;
			gtk_tree_path_prev (_tmp5_);
			_tmp6_ = count;
			count = _tmp6_ + 1;
		}
		while (TRUE) {
			gint _tmp7_;
			GtkTreePath* _tmp8_;
			gint _tmp9_;
			_tmp7_ = count;
			if (!(_tmp7_ > 0)) {
				break;
			}
			_tmp8_ = path;
			gtk_tree_path_next (_tmp8_);
			_tmp9_ = count;
			count = _tmp9_ - 1;
		}
		_tmp10_ = self->priv->matches;
		_tmp11_ = gtk_tree_view_get_model (_tmp10_);
		_tmp12_ = _g_object_ref0 (_tmp11_);
		store = _tmp12_;
		_tmp13_ = store;
		_tmp14_ = path;
		_tmp16_ = gtk_tree_model_get_iter (_tmp13_, &_tmp15_, _tmp14_);
		iter = _tmp15_;
		if (_tmp16_) {
			GtkTreeView* _tmp17_;
			GtkTreePath* _tmp18_;
			_tmp17_ = self->priv->matches;
			_tmp18_ = path;
			gtk_tree_view_set_cursor (_tmp17_, _tmp18_, NULL, FALSE);
		}
		_g_object_unref0 (store);
		_gtk_tree_path_free0 (path);
	}
}


static void ibus_charmap_search_panel_on_row_activated (IBusCharmapSearchPanel* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* store;
	GtkTreeIter iter = {0};
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gunichar uc = 0U;
	GtkTreeIter _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = self->priv->matches;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	store = _tmp2_;
	_tmp3_ = path;
	gtk_tree_model_get_iter (store, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (store, &_tmp5_, 0, &uc, -1);
	g_signal_emit_by_name ((IBusSelectable*) self, "character-activated", uc);
	_g_object_unref0 (store);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean ibus_charmap_search_panel_idle_search (IBusCharmapSearchPanel* self, guint max_matches) {
	gboolean result = FALSE;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* text;
	GtkTreeView* _tmp3_;
	GtkTreeModel* _tmp4_ = NULL;
	GtkListStore* _tmp5_;
	GtkListStore* store;
	sqlite3_stmt* stmt = NULL;
	gchar* _tmp6_;
	gchar* sql;
	gint rc = 0;
	sqlite3* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_;
	sqlite3_stmt* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GDestroyNotify _tmp25_;
	gint _tmp26_ = 0;
	gint _tmp27_;
	sqlite3_stmt* _tmp31_;
	guint _tmp32_;
	gint _tmp33_ = 0;
	gint _tmp34_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp38_;
	GtkTreeIter _tmp39_ = {0};
	gboolean _tmp40_ = FALSE;
	gboolean valid;
	gint n_matches;
	GtkListStore* _tmp94_;
	GtkTreeIter _tmp95_ = {0};
	gboolean _tmp96_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp3_ = self->priv->matches;
	_tmp4_ = gtk_tree_view_get_model (_tmp3_);
	_tmp5_ = _g_object_ref0 (GTK_LIST_STORE (_tmp4_));
	store = _tmp5_;
	_tmp6_ = g_strdup ("\n" \
"SELECT codepoint, name FROM unicode_names WHERE name LIKE ? LIMIT ?;\n");
	sql = _tmp6_;
	_tmp7_ = ibus_charmap_search_panel_database;
	_tmp8_ = sql;
	_tmp9_ = sql;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = sqlite3_prepare (_tmp7_, _tmp8_, _tmp11_, &_tmp12_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp12_;
	rc = _tmp13_;
	_tmp14_ = rc;
	if (_tmp14_ != SQLITE_OK) {
		FILE* _tmp15_;
		sqlite3* _tmp16_;
		const gchar* _tmp17_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = ibus_charmap_search_panel_database;
		_tmp17_ = sqlite3_errmsg (_tmp16_);
		fprintf (_tmp15_, "can't prepare statement: %s\n", _tmp17_);
		result = FALSE;
		_g_free0 (sql);
		_sqlite3_finalize0 (stmt);
		_g_object_unref0 (store);
		_g_free0 (text);
		return result;
	}
	_tmp18_ = stmt;
	_tmp19_ = text;
	_tmp20_ = string_replace (_tmp19_, "%", "%%");
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat ("%", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, "%", NULL);
	_tmp25_ = g_free;
	_tmp26_ = sqlite3_bind_text (_tmp18_, 1, _tmp24_, -1, _tmp25_);
	rc = _tmp26_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_tmp27_ = rc;
	if (_tmp27_ != SQLITE_OK) {
		FILE* _tmp28_;
		sqlite3* _tmp29_;
		const gchar* _tmp30_ = NULL;
		_tmp28_ = stderr;
		_tmp29_ = ibus_charmap_search_panel_database;
		_tmp30_ = sqlite3_errmsg (_tmp29_);
		fprintf (_tmp28_, "can't bind values: %s\n", _tmp30_);
		result = FALSE;
		_g_free0 (sql);
		_sqlite3_finalize0 (stmt);
		_g_object_unref0 (store);
		_g_free0 (text);
		return result;
	}
	_tmp31_ = stmt;
	_tmp32_ = max_matches;
	_tmp33_ = sqlite3_bind_int64 (_tmp31_, 2, (gint64) ((gint) _tmp32_));
	rc = _tmp33_;
	_tmp34_ = rc;
	if (_tmp34_ != SQLITE_OK) {
		FILE* _tmp35_;
		sqlite3* _tmp36_;
		const gchar* _tmp37_ = NULL;
		_tmp35_ = stderr;
		_tmp36_ = ibus_charmap_search_panel_database;
		_tmp37_ = sqlite3_errmsg (_tmp36_);
		fprintf (_tmp35_, "can't bind values: %s\n", _tmp37_);
		result = FALSE;
		_g_free0 (sql);
		_sqlite3_finalize0 (stmt);
		_g_object_unref0 (store);
		_g_free0 (text);
		return result;
	}
	_tmp38_ = store;
	_tmp40_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp38_, &_tmp39_);
	iter = _tmp39_;
	valid = _tmp40_;
	n_matches = 0;
	while (TRUE) {
		sqlite3_stmt* _tmp41_;
		gint _tmp42_ = 0;
		gint _tmp43_;
		_tmp41_ = stmt;
		_tmp42_ = sqlite3_step (_tmp41_);
		rc = _tmp42_;
		_tmp43_ = rc;
		if (_tmp43_ == SQLITE_ROW) {
			gboolean _tmp44_;
			sqlite3_stmt* _tmp48_;
			const gchar* _tmp49_ = NULL;
			gchar* _tmp50_;
			gchar* name;
			const gchar* _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			const gchar* _tmp54_;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_;
			gint _tmp57_ = 0;
			gint _tmp58_;
			gint index;
			const gchar* _tmp59_;
			gint _tmp60_;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_;
			const gchar* _tmp63_;
			gint _tmp64_;
			const gchar* _tmp65_;
			gint _tmp66_;
			gint _tmp67_;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_;
			const gchar* _tmp70_;
			gint _tmp71_;
			const gchar* _tmp72_;
			gint _tmp73_;
			gint _tmp74_;
			gchar* _tmp75_ = NULL;
			gchar* _tmp76_;
			gchar* _tmp77_ = NULL;
			gchar* _tmp78_;
			gchar* markup;
			GtkListStore* _tmp79_;
			GtkTreeIter _tmp80_;
			sqlite3_stmt* _tmp81_;
			gint64 _tmp82_ = 0LL;
			const gchar* _tmp83_;
			GtkListStore* _tmp84_;
			gboolean _tmp85_ = FALSE;
			_tmp44_ = valid;
			if (!_tmp44_) {
				GtkListStore* _tmp45_;
				gint _tmp46_;
				GtkTreeIter _tmp47_ = {0};
				_tmp45_ = store;
				_tmp46_ = n_matches;
				n_matches = _tmp46_ + 1;
				gtk_list_store_insert (_tmp45_, &_tmp47_, _tmp46_);
				iter = _tmp47_;
			}
			_tmp48_ = stmt;
			_tmp49_ = sqlite3_column_text (_tmp48_, 1);
			_tmp50_ = g_strdup (_tmp49_);
			name = _tmp50_;
			_tmp51_ = name;
			_tmp52_ = g_utf8_casefold (_tmp51_, (gssize) (-1));
			_tmp53_ = _tmp52_;
			_tmp54_ = text;
			_tmp55_ = g_utf8_casefold (_tmp54_, (gssize) (-1));
			_tmp56_ = _tmp55_;
			_tmp57_ = string_index_of (_tmp53_, _tmp56_, 0);
			_tmp58_ = _tmp57_;
			_g_free0 (_tmp56_);
			_g_free0 (_tmp53_);
			index = _tmp58_;
			_tmp59_ = name;
			_tmp60_ = index;
			_tmp61_ = string_substring (_tmp59_, (glong) 0, (glong) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = name;
			_tmp64_ = index;
			_tmp65_ = text;
			_tmp66_ = strlen (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = string_substring (_tmp63_, (glong) _tmp64_, (glong) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = name;
			_tmp71_ = index;
			_tmp72_ = text;
			_tmp73_ = strlen (_tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = string_substring (_tmp70_, (glong) (_tmp71_ + _tmp74_), (glong) (-1));
			_tmp76_ = _tmp75_;
			_tmp77_ = g_markup_printf_escaped ("%s<b>%s</b>%s", _tmp62_, _tmp69_, _tmp76_);
			_tmp78_ = _tmp77_;
			_g_free0 (_tmp76_);
			_g_free0 (_tmp69_);
			_g_free0 (_tmp62_);
			markup = _tmp78_;
			_tmp79_ = store;
			_tmp80_ = iter;
			_tmp81_ = stmt;
			_tmp82_ = sqlite3_column_int64 (_tmp81_, 0);
			_tmp83_ = markup;
			gtk_list_store_set (_tmp79_, &_tmp80_, 0, (guint) _tmp82_, 1, _tmp83_, -1);
			_tmp84_ = store;
			_tmp85_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp84_, &iter);
			valid = _tmp85_;
			_g_free0 (markup);
			_g_free0 (name);
		} else {
			gint _tmp86_;
			_tmp86_ = rc;
			if (_tmp86_ == SQLITE_DONE) {
				break;
			} else {
				FILE* _tmp87_;
				sqlite3* _tmp88_;
				const gchar* _tmp89_ = NULL;
				_tmp87_ = stderr;
				_tmp88_ = ibus_charmap_search_panel_database;
				_tmp89_ = sqlite3_errmsg (_tmp88_);
				fprintf (_tmp87_, "can't step: %s\n", _tmp89_);
				break;
			}
		}
	}
	while (TRUE) {
		gboolean _tmp90_;
		GtkListStore* _tmp91_;
		GtkTreeIter _tmp92_;
		gboolean _tmp93_ = FALSE;
		_tmp90_ = valid;
		if (!_tmp90_) {
			break;
		}
		_tmp91_ = store;
		_tmp92_ = iter;
		_tmp93_ = gtk_list_store_remove (_tmp91_, &_tmp92_);
		valid = _tmp93_;
	}
	_tmp94_ = store;
	_tmp96_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp94_, &_tmp95_);
	iter = _tmp95_;
	if (_tmp96_) {
		GtkTreeView* _tmp97_;
		GtkListStore* _tmp98_;
		GtkTreeIter _tmp99_;
		GtkTreePath* _tmp100_ = NULL;
		GtkTreePath* _tmp101_;
		_tmp97_ = self->priv->matches;
		_tmp98_ = store;
		_tmp99_ = iter;
		_tmp100_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp98_, &_tmp99_);
		_tmp101_ = _tmp100_;
		gtk_tree_view_set_cursor (_tmp97_, _tmp101_, NULL, FALSE);
		_gtk_tree_path_free0 (_tmp101_);
	}
	result = FALSE;
	_g_free0 (sql);
	_sqlite3_finalize0 (stmt);
	_g_object_unref0 (store);
	_g_free0 (text);
	return result;
}


static void _ibus_charmap_search_panel_on_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	ibus_charmap_search_panel_on_row_activated (self, path, column);
}


IBusCharmapSearchPanel* ibus_charmap_search_panel_construct (GType object_type) {
	IBusCharmapSearchPanel * self = NULL;
	GtkVBox* _tmp0_;
	GtkVBox* _tmp1_;
	GtkVBox* paned;
	GtkEntry* _tmp2_;
	GtkEntry* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	GtkScrolledWindow* scrolled_window;
	GtkListStore* _tmp8_;
	GtkListStore* model;
	GtkTreeView* _tmp9_;
	GtkTreeView* _tmp10_;
	IBusCharmapCharacterRenderer* _tmp11_;
	GtkCellRenderer* _tmp12_;
	GtkCellRenderer* renderer;
	GtkTreeView* _tmp13_;
	GtkCellRenderer* _tmp14_;
	GtkCellRendererText* _tmp15_;
	GtkCellRenderer* _tmp16_;
	GtkTreeView* _tmp17_;
	GtkCellRenderer* _tmp18_;
	GtkTreeView* _tmp19_;
	GtkTreeView* _tmp20_;
	GtkTreeView* _tmp21_;
	GtkTreeViewColumn* _tmp22_ = NULL;
	GtkTreeViewColumn* _tmp23_;
	GtkTreeViewColumn* column;
	GtkTreeView* _tmp24_;
	self = (IBusCharmapSearchPanel*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	paned = _tmp1_;
	_tmp2_ = (GtkEntry*) gtk_entry_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp3_;
	_tmp4_ = self->priv->entry;
	gtk_editable_set_editable ((GtkEditable*) _tmp4_, FALSE);
	_tmp5_ = self->priv->entry;
	gtk_box_pack_start ((GtkBox*) paned, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	scrolled_window = _tmp7_;
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_ETCHED_IN);
	_tmp8_ = gtk_list_store_new (2, G_TYPE_UINT, G_TYPE_STRING);
	model = _tmp8_;
	_tmp9_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) model);
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->matches);
	self->priv->matches = _tmp10_;
	_tmp11_ = ibus_charmap_character_renderer_new ();
	_tmp12_ = (GtkCellRenderer*) g_object_ref_sink (_tmp11_);
	renderer = _tmp12_;
	_tmp13_ = self->priv->matches;
	_tmp14_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp13_, -1, "codepoint", _tmp14_, "codepoint", 0, NULL);
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp16_ = (GtkCellRenderer*) g_object_ref_sink (_tmp15_);
	_g_object_unref0 (renderer);
	renderer = _tmp16_;
	_tmp17_ = self->priv->matches;
	_tmp18_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp17_, -1, "name", _tmp18_, "markup", 1, NULL);
	_tmp19_ = self->priv->matches;
	gtk_tree_view_set_headers_visible (_tmp19_, FALSE);
	_tmp20_ = self->priv->matches;
	g_signal_connect_object (_tmp20_, "row-activated", (GCallback) _ibus_charmap_search_panel_on_row_activated_gtk_tree_view_row_activated, self, 0);
	_tmp21_ = self->priv->matches;
	_tmp22_ = gtk_tree_view_get_column (_tmp21_, 1);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	column = _tmp23_;
	gtk_tree_view_column_set_sizing (column, GTK_TREE_VIEW_COLUMN_FIXED);
	_tmp24_ = self->priv->matches;
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) _tmp24_);
	gtk_box_pack_end ((GtkBox*) paned, (GtkWidget*) scrolled_window, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) paned);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) paned, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer);
	_g_object_unref0 (model);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (paned);
	return self;
}


IBusCharmapSearchPanel* ibus_charmap_search_panel_new (void) {
	return ibus_charmap_search_panel_construct (IBUS_CHARMAP_TYPE_SEARCH_PANEL);
}


static void ibus_charmap_search_panel_class_init (IBusCharmapSearchPanelClass * klass) {
	gchar* _tmp0_ = NULL;
	gchar* filename;
	gint rc = 0;
	const gchar* _tmp1_;
	sqlite3* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_;
	ibus_charmap_search_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusCharmapSearchPanelPrivate));
	G_OBJECT_CLASS (klass)->finalize = ibus_charmap_search_panel_finalize;
	g_signal_new ("activate_character", IBUS_CHARMAP_TYPE_SEARCH_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	_tmp0_ = g_build_filename (PACKAGE_DATADIR, UNICODENAMESFILE, NULL);
	filename = _tmp0_;
	_tmp1_ = filename;
	_tmp3_ = sqlite3_open_v2 (_tmp1_, &_tmp2_, SQLITE_OPEN_READONLY, NULL);
	_sqlite3_close0 (ibus_charmap_search_panel_database);
	ibus_charmap_search_panel_database = _tmp2_;
	rc = _tmp3_;
	_tmp4_ = rc;
	if (_tmp4_ != SQLITE_OK) {
		FILE* _tmp5_;
		_tmp5_ = stderr;
		fprintf (_tmp5_, "can't open database\n");
		g_assert_not_reached ();
	}
	_g_free0 (filename);
}


static void ibus_charmap_search_panel_ibus_selectable_interface_init (IBusSelectableIface * iface) {
	ibus_charmap_search_panel_ibus_selectable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate_selected = (void (*)(IBusSelectable*)) ibus_charmap_search_panel_real_activate_selected;
	iface->move_cursor = (void (*)(IBusSelectable*, IBusMovementStep, gint)) ibus_charmap_search_panel_real_move_cursor;
}


static void ibus_charmap_search_panel_instance_init (IBusCharmapSearchPanel * self) {
	self->priv = IBUS_CHARMAP_SEARCH_PANEL_GET_PRIVATE (self);
	self->priv->idle_search_id = (guint) 0;
}


static void ibus_charmap_search_panel_finalize (GObject* obj) {
	IBusCharmapSearchPanel * self;
	self = IBUS_CHARMAP_SEARCH_PANEL (obj);
	_g_object_unref0 (self->priv->entry);
	_g_object_unref0 (self->priv->matches);
	G_OBJECT_CLASS (ibus_charmap_search_panel_parent_class)->finalize (obj);
}


GType ibus_charmap_search_panel_get_type (void) {
	static volatile gsize ibus_charmap_search_panel_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_charmap_search_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusCharmapSearchPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_charmap_search_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusCharmapSearchPanel), 0, (GInstanceInitFunc) ibus_charmap_search_panel_instance_init, NULL };
		static const GInterfaceInfo ibus_selectable_info = { (GInterfaceInitFunc) ibus_charmap_search_panel_ibus_selectable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType ibus_charmap_search_panel_type_id;
		ibus_charmap_search_panel_type_id = g_type_register_static (GTK_TYPE_BOX, "IBusCharmapSearchPanel", &g_define_type_info, 0);
		g_type_add_interface_static (ibus_charmap_search_panel_type_id, IBUS_TYPE_SELECTABLE, &ibus_selectable_info);
		g_once_init_leave (&ibus_charmap_search_panel_type_id__volatile, ibus_charmap_search_panel_type_id);
	}
	return ibus_charmap_search_panel_type_id__volatile;
}



